select_method=$1
seed=$2
device_id=$3
epochs=$4
percentage=$5
eval_dir=$6
version=$7
model=$8
submodel=$9
save_dir=results_${version}_${eval_dir}_${model}/${select_method}_seed${seed}_epoch${epochs}_p${percentage}_${submodel}/tydiqa
mkdir -p $save_dir

if [ "$select_method" = "uniform" ] | [ "$select_method" = "barycenter" ] | [ "$select_method" = "rand" ]; then
    postfix=${select_method}
else
    postfix="tydiqa"
fi

# Now you can use the postfix variable as needed
echo "The selected postfix is: $postfix"

CUDA_VISIBLE_DEVICES=${device_id} python -m ${version}.tydiqa.run_eval \
    --data_dir ../data/${eval_dir}/tydiqa \
    --n_shot 1 \
    --max_num_examples_per_lang 200 \
    --max_context_length 512 \
    --save_dir $save_dir \
    --model out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --tokenizer out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --eval_batch_size 5 \
    --use_chat_format \
    --chat_formatting_function eval.templates.create_prompt_with_tulu_chat_format --convert_to_bf16
