import os

def get_exp_name(folder, idx):
    exp_names = os.listdir(folder)
    for exp_name in exp_names:
        if exp_name.startswith(idx):
            return exp_name
    return None

def get_latest_exp_idx(folder):
    exp_names = os.listdir(folder)
    exp_idxs = [x.split('-')[0] for x in exp_names]
    exp_idx = sorted(exp_idxs)[-1]
    return exp_idx

def get_new_exp_idx(folder):
    exp_idx = get_latest_exp_idx(folder)
    exp_idx = int(exp_idx[3:]) + 1
    return f'exp{exp_idx:03d}'

def get_latest_ckpt(folder, exp_name):
    ckpt_folder = os.path.join(folder, exp_name, 'checkpoints')
    ckpts = os.listdir(ckpt_folder)
    ckpts = [x for x in ckpts if 'vq' in x]
    ckpt = sorted(ckpts)[-1].split('_')[1]
    return int(ckpt)