from typing import Any, Optional

import torch as th


def add_prefix_to_dict(
    d: dict[str, Any], prefix: str, sep: Optional[str] = "/"
) -> dict[str, Any]:
    return {f"{prefix}{sep}{k}": v for k, v in d.items()}


def combs_to_inds(n_covs: int, combs_l: list[tuple[int, ...]]) -> th.Tensor:
    n: int = len(combs_l)
    inds: th.Tensor = th.zeros((n, n_covs), dtype=th.bool)
    for i, comb in enumerate(combs_l):
        inds[i, comb] = True
    return inds


def inds_to_combs(inds: th.Tensor) -> list[tuple[int, ...]]:
    combs_l: list[tuple[int, ...]] = [
        tuple(th.argwhere(ind.to(dtype=th.bool)).flatten().tolist()) for ind in inds
    ]
    return combs_l
