### Setup Your API Keys

#### OpenAI API Keys

For setting up OpenAI API keys, add your API key to your environment variables:

MacOS/Linux:

```bash
export OPENAI_API_KEY='your-api-key-here'
```

Windows:

```text
setx OPENAI_API_KEY "your-api-key-here"
```

Visit [Quickstart tutorial - OpenAI API](https://platform.openai.com/docs/quickstart?context=python) for more details.

#### Claude API Keys

For setting up Claude API keys, add your API key to your environment variables:

MacOS/Linux:

```bash
export ANTHROPIC_API_KEY='your-api-key-here'
```

Windows:

```text
setx ANTHROPIC_API_KEY "your-api-key-here"
```
#### Gemini API Keys

For setting up Gemini API keys, add your API key to your environment variables:

MacOS/Linux:

```bash
export GOOGLE_API_KEY='your-api-key-here'
```

Windows:

```text
setx GOOGLE_API_KEY "your-api-key-here"
```

#### Together AI API Keys

For setting up Together AI API keys, add your API key to your environment variables:

MacOS/Linux:

```bash
export TOGETHER_API_KEY='your-api-key-here'
```

Windows:

```text
setx TOGETHER_API_KEY "your-api-key-here"
```

Make sure to replace `your-api-key-here` with your actual API keys. This ensures that the necessary APIs are accessible for the features you intend to use in the repository.