# -*- coding: utf-8 -*-
import os
import argparse

parser = argparse.ArgumentParser(description='Training SNN')
parser.add_argument('--seed', default=None, type=int)
parser.add_argument('--arch', default="VGG", type=str, help="VGG")  # used
parser.add_argument('--dataset', default="CIFAR10_DVS", type=str, help="dataset")  # used
parser.add_argument('--data_path', default="[your data path]", type=str)  # used
parser.add_argument('--ckpt_path', default="./checkpoint", type=str, help="checkpoint path")  # used
parser.add_argument('--log_path', default="./log", type=str, help="log path")  # used
parser.add_argument('--auto_aug', default=False, action='store_true')  # used
parser.add_argument('--cutout', default=False, action='store_true')  # used
parser.add_argument('--resume', default=None, type=str)  # used
parser.add_argument('--train_batch_size', default=32, type=int)  # used
parser.add_argument('--val_batch_size', default=32, type=int)  # used
parser.add_argument('--lr', default=0.1, type=float)  # used
parser.add_argument('--width_lr', default=3e-4, type=float)  # used
parser.add_argument('--save_last', default=False, action='store_true')  # used
parser.add_argument('--bn_type', default='', type=str)  # used
parser.add_argument('--bias', default=False, action='store_true')  # used
parser.add_argument('--wd', default=5e-4, type=float)  # used
parser.add_argument('--num_epoch', default=100, type=int)  # used # check
parser.add_argument('--num_workers', default=8, type=int)  # used
parser.add_argument('--optim', default='SGDM', type=str)  # used
parser.add_argument('--act', default='spike', type=str)  # used # check
parser.add_argument('--alpha', default=1.0, type=float)  # used # check
parser.add_argument('--decay', default=None, type=float)  # used
parser.add_argument('--thresh', default=0.5, type=float)  # used
parser.add_argument('--train_decay', action='store_true')  # used
parser.add_argument('--train_thresh', action='store_true')  # used
parser.add_argument('--device', default='cuda:0', type=str)  # used
parser.add_argument('--T', default=10, type=int, help='num of time steps')  # used # check
parser.add_argument('--scheduler', default='COSINE', type=str)  # used

parser.add_argument('--train_width', action='store_true')  # used
parser.add_argument('--detach_reset', default=True, action='store_true')  # used
parser.add_argument('--rate_flag', default=False, action='store_true')  # used
parser.add_argument('--ce', default=False, action='store_true')  # used

args = parser.parse_args()

if not os.path.exists(args.ckpt_path):
    os.mkdir(args.ckpt_path)
if not os.path.exists(args.log_path):
    os.mkdir(args.log_path)
print(args)

print(args.data_path)
defaults = vars(parser.parse_args([]))
args_in = vars(args)
for key in args_in:
    if args_in[key].__hash__ is None or not isinstance(args_in[key].__hash__(), int):
        args_in[key] = tuple(args_in[key])

for key in defaults:
    if defaults[key].__hash__ is None or not isinstance(defaults[key].__hash__(), int):
        defaults[key] = tuple(defaults[key])
args.cmd = [' --' + str(k).strip() + ' ' + str(v).strip() for k, v in set(args_in.items()) - set(defaults.items())]
