import autoai_libs.transformers.exportable

import lale.docstrings
import lale.operators


class _NumpyPermuteArrayImpl:
    def __init__(self, permutation_indices=None, axis=None):
        self._hyperparams = {"permutation_indices": permutation_indices, "axis": axis}
        self._wrapped_model = autoai_libs.transformers.exportable.NumpyPermuteArray(
            **self._hyperparams
        )

    def fit(self, X, y=None):
        self._wrapped_model.fit(X, y)
        return self

    def transform(self, X):
        return self._wrapped_model.transform(X)


_hyperparams_schema = {
    "allOf": [
        {
            "description": "This first object lists all constructor arguments with their types, but omits constraints for conditional hyperparameters.",
            "type": "object",
            "additionalProperties": False,
            "required": ["permutation_indices", "axis"],
            "relevantToOptimizer": [],
            "properties": {
                "permutation_indices": {
                    "description": "List of indexes based on which columns will be rearranged.",
                    "anyOf": [
                        {"type": "array", "items": {"type": "integer", "minimum": 0}},
                        {"enum": [None]},
                    ],
                    "default": None,
                },
                "axis": {
                    "anyOf": [
                        {"enum": [0, None], "description": "Permute along columns."},
                        {"enum": [1], "description": "Permute along rows."},
                    ],
                    "default": None,
                },
            },
        }
    ]
}

_input_fit_schema = {
    "type": "object",
    "required": ["X"],
    "additionalProperties": False,
    "properties": {
        "X": {  # Handles 1-D arrays as well
            "anyOf": [
                {"type": "array", "items": {"laleType": "Any"}},
                {
                    "type": "array",
                    "items": {"type": "array", "items": {"laleType": "Any"}},
                },
            ]
        },
        "y": {"laleType": "Any"},
    },
}

_input_transform_schema = {
    "type": "object",
    "required": ["X"],
    "additionalProperties": False,
    "properties": {
        "X": {  # Handles 1-D arrays as well
            "anyOf": [
                {"type": "array", "items": {"laleType": "Any"}},
                {
                    "type": "array",
                    "items": {"type": "array", "items": {"laleType": "Any"}},
                },
            ]
        }
    },
}

_output_transform_schema = {
    "description": "Features; the outer array is over samples.",
    "anyOf": [
        {"type": "array", "items": {"laleType": "Any"}},
        {"type": "array", "items": {"type": "array", "items": {"laleType": "Any"}}},
    ],
}

_combined_schemas = {
    "$schema": "http://json-schema.org/draft-04/schema#",
    "description": """Operator from `autoai_libs`_. Rearranges columns or rows of a numpy array based on a list of indices.

.. _`autoai_libs`: https://pypi.org/project/autoai-libs""",
    "documentation_url": "https://lale.readthedocs.io/en/latest/modules/lale.lib.autoai_libs.numpy_permute_array.html",
    "import_from": "autoai_libs.transformers.exportable",
    "type": "object",
    "tags": {"pre": [], "op": ["transformer"], "post": []},
    "properties": {
        "hyperparams": _hyperparams_schema,
        "input_fit": _input_fit_schema,
        "input_transform": _input_transform_schema,
        "output_transform": _output_transform_schema,
    },
}


NumpyPermuteArray = lale.operators.make_operator(
    _NumpyPermuteArrayImpl, _combined_schemas
)

lale.docstrings.set_docstrings(NumpyPermuteArray)
