import inspect
import logging

from lale.operators import Operator, clone_op, get_op_from_lale_lib, make_operator

logger = logging.getLogger(__name__)


def _wrap_operators_in_symtab(symtab):
    for name, impl in symtab.items():
        if (
            inspect.isclass(impl)
            and not issubclass(impl, Operator)
            and (hasattr(impl, "predict") or hasattr(impl, "transform"))
        ):
            operator = get_op_from_lale_lib(impl)
            if operator is None:
                symtab[name] = make_operator(impl=impl, name=name)
                logger.info(f"Lale:Wrapped unkwnown operator:{name}")
            else:
                symtab[name] = clone_op(operator, name)
                if operator.class_name().startswith("lale.lib.autogen"):
                    logger.info(f"Lale:Wrapped autogen operator:{name}")
                else:
                    logger.info(f"Lale:Wrapped known operator:{name}")


def wrap_imported_operators():
    calling_frame = inspect.stack()[1][0]
    _wrap_operators_in_symtab(calling_frame.f_globals)
    if calling_frame.f_code.co_name == "<module>":  # for testing with exec()
        _wrap_operators_in_symtab(calling_frame.f_locals)
