package ceka.KFNN;

public class Kalman {
    private double q; // process noise covariance  Э
    private double r; // measurement noise covariance Э
    private double x; // estimated value ֵ
    private double p; // estimation error covariance Э
    private double k; // adaptive Kalman filter gain ӦKalman˲
 
    public Kalman(double q, double r, double p, double initialValue) {
        this.q = q;
        this.r = r;
        this.p = p;
        this.x = initialValue;
    }
 
    public double update(double measurement, double processNoise) {
        // prediction update
        x = x + processNoise;
        p = p + q;
 
        // measurement update
        k = p / (p + r);
        x = x + k * (measurement - x);
        p = (1 - k) * p;
 
        return x;
    }
}