package ceka.KFNN;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

import ceka.AALI.AALI;
import ceka.IWMV.IWMV;
import ceka.LAWMV.LAWMV;
import ceka.MNLDP.MNLDP;
import ceka.consensus.MajorityVote;
import ceka.converters.FileLoader;
import ceka.core.Dataset;
import ceka.utils.PerformanceStatistic;
import myqpmatlab.MyQP;

public class Test_R {
	
	private static String dataSetArffDir = "./test/ceka/KFNN/real-world/";

	private static String[] dataSetArddFix = {"income94L10"};

	private static String runDir = "./test/ceka/KFNN/KFNN-results/";
	
	private static int times = 1;
	
	
	public static void main(String[] args) throws Exception {
		
		File testDir = new File(runDir);
		if (!testDir.exists())
			testDir.mkdirs();

		// write the result to a file
		FileOutputStream f_i = new FileOutputStream(new File(runDir + "result_F1.txt"));
		FileOutputStream f_c = new FileOutputStream(new File(runDir + "result_Acc.txt"));
		PrintStream result_i = new PrintStream(f_i);
		PrintStream result_c = new PrintStream(f_c);

		result_i.format("%-10s	%-10s	%-10s	%-10s	%-10s	%-10s	%-10s	%-10s", "dataset","MV","IWMV","AALI","LAGNN","LAWMV","MNLDP","KFNN");
		result_i.println();
		result_c.format("%-10s	%-10s	%-10s	%-10s	%-10s	%-10s	%-10s	%-10s", "dataset","MV","IWMV","AALI","LAGNN","LAWMV","MNLDP","KFNN");
		result_c.println();
		
		double F1_mv_all_sum = 0.0;
		double F1_iwmv_all_sum = 0.0;
		double F1_aali_all_sum = 0.0;
		double F1_lagnn_all_sum = 0.0;
		double F1_lawmv_all_sum = 0.0;
		double F1_mnldp_all_sum = 0.0;
		double F1_kfnn_all_sum = 0.0;
		
		double Acc_mv_all_sum = 0.0;
		double Acc_iwmv_all_sum = 0.0;
		double Acc_aali_all_sum = 0.0;
		double Acc_lagnn_all_sum = 0.0;
		double Acc_lawmv_all_sum = 0.0;
		double Acc_mnldp_all_sum = 0.0;
		double Acc_kfnn_all_sum = 0.0;
		
		for (int index = 0; index < dataSetArddFix.length; index++) {
			
			String arffxPath = dataSetArffDir + dataSetArddFix[index] + ".arff";
			String responsePath=dataSetArffDir + dataSetArddFix[index] + ".response.txt";
			String goldPath=dataSetArffDir + dataSetArddFix[index] + ".gold.txt";		
			Dataset dataset = FileLoader.loadFile(responsePath, goldPath, arffxPath);
			
			System.out.println(dataSetArddFix[index]);
			
			double F1_mv = 0.0;
			double F1_iwmv = 0.0;
			double F1_aali = 0.0;
			double F1_lagnn = 0.0;
			double F1_lawmv = 0.0;
			double F1_mnldp = 0.0;
			double F1_kfnn = 0.0;
			
			double Acc_mv = 0.0;
			double Acc_iwmv = 0.0;
			double Acc_aali = 0.0;
			double Acc_lagnn = 0.0;
			double Acc_lawmv = 0.0;
			double Acc_mnldp = 0.0;
			double Acc_kfnn = 0.0;
					
			for (int counts = 0; counts < times; counts++) {
				// MV
				Dataset datasetMV = CekaUtils.datasetCopy(dataset);
				MajorityVote mv = new MajorityVote();
				mv.doInference(datasetMV);
				PerformanceStatistic reporter = new PerformanceStatistic();
				reporter.stat(datasetMV);
				F1_mv += CekaUtils.calF1(datasetMV);
				Acc_mv += reporter.getAccuracy() * 100;

				//IWMV
				Dataset datasetIWMV = CekaUtils.datasetCopy(dataset);
				IWMV iwmv = new IWMV();
				iwmv.doInference(datasetIWMV);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetIWMV);
				F1_iwmv += CekaUtils.calF1(datasetIWMV);
				Acc_iwmv += reporter.getAccuracy() * 100;
				
				//AALI
				Dataset datasetAALI = CekaUtils.datasetCopy(dataset);
				AALI aali = new AALI();
				datasetAALI = aali.doInference(datasetAALI);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetAALI);
				F1_aali += CekaUtils.calF1(datasetAALI);
				Acc_aali += reporter.getAccuracy() * 100;
				
				//LAWMV
				Dataset datasetLAWMV = CekaUtils.datasetCopy(dataset);
				LAWMV lawmv = new LAWMV();
				lawmv.doInference(datasetLAWMV, (int)(0.5*datasetLAWMV.numInstances() / datasetLAWMV.numClasses()));
				reporter = new PerformanceStatistic();
				reporter.stat(datasetLAWMV);
				F1_lawmv += CekaUtils.calF1(datasetLAWMV);
				Acc_lawmv += reporter.getAccuracy() * 100;
				
				// MNLDP
				Dataset datasetMNLDP = CekaUtils.datasetCopy(dataset);
				MNLDP mnldp = new MNLDP();
				MyQP t1 = new MyQP();
				mnldp.setMyQP(t1);
				mnldp.doInference(datasetMNLDP);
				t1.dispose();
				reporter = new PerformanceStatistic();
				reporter.stat(datasetMNLDP);
				F1_mnldp += CekaUtils.calF1(datasetMNLDP);
				Acc_mnldp += reporter.getAccuracy() * 100;

				// KFNN
				Dataset datasetKFNN = CekaUtils.datasetCopy(dataset);
				KFNN kfnn = new KFNN();
				kfnn.doInference(datasetKFNN);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetKFNN);
				F1_kfnn += CekaUtils.calF1(datasetKFNN);
				Acc_kfnn += reporter.getAccuracy() * 100;
			}
			
			F1_mv_all_sum += F1_mv / times;
			F1_iwmv_all_sum += F1_iwmv / times;
			F1_aali_all_sum += F1_aali / times;
			F1_lagnn_all_sum += F1_lagnn / times;
			F1_mnldp_all_sum += F1_mnldp / times;
			F1_lawmv_all_sum += F1_lawmv / times;
			F1_kfnn_all_sum += F1_kfnn / times;
			
			Acc_mv_all_sum += Acc_mv / times;
			Acc_iwmv_all_sum += Acc_iwmv / times;
			Acc_aali_all_sum += Acc_aali / times;
			Acc_lagnn_all_sum += Acc_lagnn / times;
			Acc_mnldp_all_sum += Acc_mnldp / times;
			Acc_lawmv_all_sum += Acc_lawmv / times;
			Acc_kfnn_all_sum += Acc_kfnn / times;

			result_i.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f", dataSetArddFix[index],
					F1_mv / times, F1_iwmv / times, 
					F1_aali / times, F1_lagnn / times,
					F1_lawmv / times, F1_mnldp / times, 
					F1_kfnn / times);
			result_i.println();
			result_c.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f", dataSetArddFix[index],
					Acc_mv / times, Acc_iwmv / times, 
					Acc_aali / times, Acc_lagnn / times,
					Acc_lawmv / times, Acc_mnldp / times, 
					Acc_kfnn / times);
			result_c.println();
		}
		result_i.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f", "Average",
				F1_mv_all_sum / dataSetArddFix.length,
				F1_iwmv_all_sum / dataSetArddFix.length,
				F1_aali_all_sum / dataSetArddFix.length,
				F1_lagnn_all_sum / dataSetArddFix.length,
				F1_lawmv_all_sum / dataSetArddFix.length,
				F1_mnldp_all_sum / dataSetArddFix.length,
				F1_kfnn_all_sum / dataSetArddFix.length);
		result_i.close();
		result_c.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f	%-10.2f", "Average",
				Acc_mv_all_sum / dataSetArddFix.length,
				Acc_iwmv_all_sum / dataSetArddFix.length,
				Acc_aali_all_sum / dataSetArddFix.length,
				Acc_lagnn_all_sum / dataSetArddFix.length,
				Acc_lawmv_all_sum / dataSetArddFix.length,
				Acc_mnldp_all_sum / dataSetArddFix.length,
				Acc_kfnn_all_sum / dataSetArddFix.length);
		result_c.close();
	}

}
