
from rapidfuzz import fuzz, process


class Fuzzy:

	def __init__(self, threshold=5):
		# Default threshold = 60% similarity
		self.threshold = threshold

	def attribute(self, word, candidates):
		scores = [(fuzz.ratio(word, c), c) for c in candidates]
		scores.sort(reverse=True)
		i = 0
		ret = []
		while i<len(scores) and len(ret)<2:
			if scores[i][0] >= self.threshold:
				ret.append(candidates.index(scores[i][1]))
			i+=1

		return [], ret[:1], ret[:2]

