
import os
from openai import OpenAI
import PyPDF2

# Set your API key (or set it as an environment variable OPENAI_API_KEY)
client = OpenAI(api_key=os.getenv("OPENAI_API_KEY"))

def extract_text_from_pdf(pdf_path):
    """Extracts text from a PDF file."""
    text = ""
    with open(pdf_path, "rb") as f:
        reader = PyPDF2.PdfReader(f)
        for page in reader.pages:
            text += page.extract_text() + "\n"
    return text

class Conversation_GPT:

    def __init__(self, pdf_path=[]):
        for filename in pdf_path:
            pdf_text = extract_text_from_pdf(filename)
            if len(pdf_text) > 15000:
                pdf_text = pdf_text[:15000] + "\n...[truncated]"

            # Initial system + user messages
            self.messages = [
                {"role": "system", "content": "You are a helpful assistant that answers based on a provided PDF."},
                {"role": "user", "content": f"Here is the PDF content:\n{pdf_text}"}
            ]





    def ask_chatgpt_followup(self, question, model="gpt-4.1-mini"):
        # Append the user's follow-up question
        self.messages.append({"role": "user", "content": question})

        response = client.chat.completions.create(
            model=model,
            messages=self.messages
        )

        # Append assistant's response to maintain context
        assistant_reply = response.choices[0].message.content
        self.messages.append({"role": "assistant", "content": assistant_reply})

        return assistant_reply

