# Lightspeed Sparse iOT

The Lightspeed Sparse iOT package is a high-performance JAX Python package designed for the efficient computation of large-scale inverse optimal transport (iOT) problems. Additionally, the package possesses the capability to compute minimal norm certificates. 

## Core Modules:

1. **SISTA.py**: Serves as the iOT solver. It primarily relies on a Hadamard factorization of the solution and utilizes a LBFGS solver to address the associated problems.

2. **gaussian_certificate_asym.py**: Focuses on the computation of the minimal norm pre-certificate of the sparse iOT in the Gaussian case.

3. **graph_helpers.py**: A support module providing helper functions for graph generation and visualization.

## Jupyter Notebooks:

1. **test_iOT_graph.ipynb**
   - **Purpose:** Demonstrates the resolution of the iOT problem using the lightspeed solver.
   - **Contents:** Examples and walkthroughs illustrating the application of the lightspeed solver for various iOT problems.

2. **test_certif_graph.ipynb**
   - **Purpose:** Facilitates the exploration of the certificate as a function of the type of graph and the regularization parameter \(\epsilon\).
   - **Contents:** In-depth analysis and visualization of the certificates against different types of graphs and regularization parameters.
