import pandas as pd
import random 
import time
import os

from model_time.conAR import data_model as conAR
from model_dec.res_gp import resgp as resgp
from model_dec.ar import ar as ar
 
'''initial setting'''

data_name_list = ['Heat_mfGent_v5'] 
model_list = {'conAR': conAR}

model_name = ['conAR']
 
seed = [0, 1, 2, 3, 4] 
dec_rate = 0.5
fidelity_num = 5

for data_name in data_name_list:
        for k in seed:
                recording = {'n_iter':[], 'rmse':[], 'nrmse':[], 'r2':[], 'nll':[], 'time':[]}
                for n_iteration in list(range(5,205,5)):
                        # for train_sample_num in [128]:
                        train_sample_num = 128
                        random.seed(k)
                        model = model_list['conAR']
                        T1 = time.time()
                        mod = model(data_name,
                                train_begin_index = 0, 
                                test_begin_index = 0,
                                train_samples_num = train_sample_num, 
                                test_samples_num = 128, 
                                # test_samples_num = 100,
                                dec_rate = dec_rate,
                                fidelity_num = fidelity_num,
                                seed = k,
                                n_iteration = n_iteration,
                                need_inerp = True)
                        T2 = time.time()
                        recording['n_iter'].append(n_iteration)
                        recording['rmse'].append(mod['rmse'])
                        recording['nrmse'].append(mod['nrmse'])
                        recording['r2'].append(mod['r2'])
                        recording['nll'].append(mod['nll'])
                        recording['time'].append(T2 - T1)


                path_csv = os.path.join( 'exp_time', 'conAR', data_name)
                if not os.path.exists(path_csv):
                        os.makedirs(path_csv)

                df = pd.DataFrame(recording)
                df.to_csv(path_csv + '/time_' + str(k) + '.csv', index = False)
