 #!/bin/bash

# Define the classifier names
CLASSIFIER_NAMES="cifar100_resnet20 cifar100_resnet32 cifar100_resnet44 cifar100_resnet56 cifar100_vgg11_bn cifar100_vgg13_bn cifar100_vgg16_bn cifar100_vgg19_bn cifar100_mobilenetv2_x0_5 cifar100_mobilenetv2_x0_75 cifar100_mobilenetv2_x1_0 cifar100_mobilenetv2_x1_4 cifar100_shufflenetv2_x0_5 cifar100_shufflenetv2_x1_0 cifar100_shufflenetv2_x1_5 cifar100_shufflenetv2_x2_0 cifar100_repvgg_a0 cifar100_repvgg_a1 cifar100_repvgg_a2"

# Define the output file name
OUTPUT_FILE="log_cifar100_random.txt"

# Remove the output file if it exists
if [ -f "$OUTPUT_FILE" ]; then
    rm "$OUTPUT_FILE"
fi

# Loop through the classifier names and run the two Python scripts for each one
for CLASSIFIER_NAME in $CLASSIFIER_NAMES; do
    # Check if the tree file already exists
    if [ -f "cifar100_test_random_${CLASSIFIER_NAME}.json" ]; then
        echo "Tree file already exists for ${CLASSIFIER_NAME}, skipping treev2.py" >> "$OUTPUT_FILE"
    else
        echo "Running treev2.py with classifier $CLASSIFIER_NAME..." >> "$OUTPUT_FILE"
        python random_cifar100.py \
        --support_data_dir /Checkpoint/yangxingyi/data/tree_data/cifar100_images_32/ \
        --gpu_id 0 \
        --classifier "$CLASSIFIER_NAME" >> "$OUTPUT_FILE"
    fi
    
    echo "Running compute_TED.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_TED.py \
    cifar100_test_random_"$CLASSIFIER_NAME".json \
    cifar100_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_mcs.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_mcs.py \
    cifar100_test_random_"$CLASSIFIER_NAME".json \
    cifar100_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_tkd.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_tkd.py \
    cifar100_test_random_"$CLASSIFIER_NAME".json \
    cifar100_parsetree_gt.json >> "$OUTPUT_FILE"
done

echo "All done! Results saved to $OUTPUT_FILE."
