 #!/bin/bash

# Define the classifier names
CLASSIFIER_NAMES="vgg11_bn vgg13_bn vgg16_bn vgg19_bn resnet18 resnet34 resnet50 densenet121 densenet161 densenet169 mobilenet_v2 googlenet inception_v3"

# Define the output file name
OUTPUT_FILE="log_cifar10.txt"

# Remove the output file if it exists
if [ -f "$OUTPUT_FILE" ]; then
    rm "$OUTPUT_FILE"
fi

# Loop through the classifier names and run the two Python scripts for each one
for CLASSIFIER_NAME in $CLASSIFIER_NAMES; do
    # Check if the tree file already exists
    if [ -f "cifar10_test_random_${CLASSIFIER_NAME}.json" ]; then
        echo "Tree file already exists for ${CLASSIFIER_NAME}, skipping treev2.py" >> "$OUTPUT_FILE"
    else
        echo "Running treev2.py with classifier $CLASSIFIER_NAME..." >> "$OUTPUT_FILE"
        python random_cifar10.py --support_data_dir /Checkpoint/yangxingyi/data/tree_data/cifar10_images/ --gpu_id 2 --classifier "$CLASSIFIER_NAME" >> "$OUTPUT_FILE"
    fi
    
    echo "Running compute_TED.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_TED.py cifar10_test_random_"$CLASSIFIER_NAME".json cifar10_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_mcs.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_mcs.py cifar10_test_random_"$CLASSIFIER_NAME".json cifar10_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_tkd.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_tkd.py cifar10_test_random_"$CLASSIFIER_NAME".json cifar10_parsetree_gt.json >> "$OUTPUT_FILE"
done

echo "All done! Results saved to $OUTPUT_FILE."
