import torch


def cw_median(vectors):
    """
    Compute the coordinate-wise median of vectors
    :param vectors: vectors to be aggregated
    :return: the coordinate-wise median
    """

    length = len(vectors)
    half_length = int((length - 1) / 2)
    v_list = []
    for i in range(len(vectors)):
        v_list.append(vectors[i])
    v_list, _ = torch.sort(torch.stack(v_list), dim=0)
    result = torch.mean(v_list[half_length: length - half_length], dim=0)
    return result
