import torch


def cw_trmean(vectors, trim_num):
    """
    Compute the coordinate-wise trimmed-mean of vectors
    :param vectors: vectors to be aggregated
    :param trim_num: number of max/min values to be trimmed
    :return: the coordinate-wise trimmed-mean
    """

    length = len(vectors)
    if 2*trim_num >= length or trim_num < 0:
        raise ValueError("trim_num error")

    v_list = []
    for i in range(len(vectors)):
        v_list.append(vectors[i])
    v_list, _ = torch.sort(torch.stack(v_list), dim=0)
    result = torch.mean(v_list[trim_num: length - trim_num], dim=0)
    return result
