import numpy as np
from scipy.stats import norm
import pandas as pd

def regret(output,response):
    incumbent   = output[0]
    best_output = []
    for _ in output:
        incumbent = _ if _ > incumbent else incumbent
        best_output.append(incumbent)
    opt       = max(response)
    orde      = list(np.sort(np.unique(response))[::-1])
    tmp       = pd.DataFrame(best_output,columns=['regret_validation'])
    
    tmp['rank_valid']        = tmp['regret_validation'].map(lambda x : orde.index(x))
    tmp['regret_validation'] = opt - tmp['regret_validation']
    return tmp

def EI(incumbent, model_fn,support,queries,return_variance, return_score=False):
    mu, stddev     = model_fn(queries)
    mu             = mu.reshape(-1,)
    stddev         = stddev.reshape(-1,)
    if return_variance:
        stddev         = np.sqrt(stddev)
    with np.errstate(divide='warn'):
        imp = mu - incumbent
        Z = imp / stddev
        score = imp * norm.cdf(Z) + stddev * norm.pdf(Z)
    if not return_score:
        score[support] = 0
        return np.argmax(score)
    else:
        return score
