import numpy as np
import os

project_file = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
dataset_name = "netflix"
dataset_path = os.path.join(project_file, 'datasets', dataset_name)

def read_result(filename):
    gt = []
    with open(filename, 'r') as f:
        for line in f:
            line = line.strip().split()
            gt.append(line)
    return gt

def recall(gt, res, top_k):
    recall = 0
    for i in range(len(res)):
        res_i = res[i][0:top_k]
        res_i = [int(x) for x in res_i]
        gt_i = gt[i][0:top_k]
        gt_i = set([int(x) for x in gt_i])
        res_i = set(res_i)
        recall += len(gt_i & res_i)

        
    return recall / (len(res) * top_k)
  
def ivecs_read(fname):
    a = np.fromfile(fname, dtype='int32')
    d = a[0]
    return a.reshape(-1, d + 1)[:, 1:].copy()
 
def fvecs_read(fname):
    return ivecs_read(fname).view('float32')
  

if __name__ == "__main__":
  print(dataset_path)
  gt_file_path = dataset_path + '/result.txt'
  dsg_file_path = dataset_path + '/result_dsg.txt'
  
  gt = read_result(gt_file_path)
  dsg = read_result(dsg_file_path)
  k = 100
  acc = recall(gt, dsg, k)
  print("Recall@100: ", acc)
  
  
  
  
  