#! /bin/bash

if [ ! -d "build" ]; then
  echo "Directory build does not exist, creating it"
  mkdir build
fi

cd build
cmake ..
make

pre_file="DATASET_PATH"
dataset_file="netflix"
result_file="result_dsg"
evaluate_file="RECALL_PATH"
data_num=17770
query_num=1000
M=48
dim=300
efConstruction=500
L=400
threshold=12
efs=1000
K=100
angle=60


if [ $? -eq 0 ]; then
  echo "Build successful"

  ./test/test_dsg "index" "${pre_file}/${dataset_file}/database_${dataset_file}.bin"\
  "${pre_file}/${dataset_file}/${dataset_file}_top${L}.mipg" \
  "${pre_file}/${dataset_file}/${dataset_file}_${M}_${efConstruction}_${L}_${threshold}.index" \
  ${data_num} ${M} ${dim} ${efConstruction} ${L} ${threshold} ${angle}


else
  echo "Build failed"
fi


if [ $? -eq 0 ]; then
  echo "Build successful"
  efs=(100 200 300 400 500)
  for efs in "${efs[@]}"; do
    log_file=""
    echo "========================================" | tee -a "$log_file"
    echo "Running with efs: $efs" | tee -a "$log_file"
    ./test/test_dsg "query" "${pre_file}/${dataset_file}/database_${dataset_file}.bin"\
    "${pre_file}/${dataset_file}/query_${dataset_file}.bin"\
    "${pre_file}/${dataset_file}/${dataset_file}_${M}_${efConstruction}_${L}_${threshold}.index" \
    ${data_num} ${query_num} ${K} ${dim} ${efs} "${pre_file}/${dataset_file}/${result_file}.txt" | tee -a "$log_file"
    python3 "${evaluate_file}" | tee -a "$log_file"
    echo "========================================" | tee -a "$log_file"
  done


else
  echo "Build failed"
fi

