---
title: "Third Party Environments"
layout: "links"
firstpage:
lastpage:
---

# Third-Party Environments

*These environments are not maintained by Farama Foundation and, as such, cannot be guaranteed to function as intended.*

## Environments using the latest versions of PettingZoo
*Due to a very recent major release of PettingZoo, there are currently few contributed third-party environments. If you'd like to contribute one, please reach out on [Discord](https://discord.gg/nHg2JRN489).*

### [Sumo-RL](https://github.com/LucasAlegre/sumo-rl)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.2-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/LucasAlegre/sumo-rl)]()

PettingZoo (and Gymnasium) wrappers for the widely used [SUMO](https://github.com/eclipse/sumo) traffic simulation.


### [POGEMA](https://github.com/AIRI-Institute/pogema)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/AIRI-Institute/pogema)]()

[Partially-Observable Grid Environment for Multiple Agents](https://github.com/AIRI-Institute/pogema) (POGEMA) is a grid-based environment that was specifically designed to be flexible, tunable and scalable.


### [Racecar Gym](https://github.com/axelbr/racecar_gym)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.4-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/axelbr/racecar_gym)]()

A multi-agent racing environment for a miniature, [F1Tenth](https://f1tenth.org/)-like racecar using the Bullet physics engine with [PyBullet](https://github.com/bulletphysics/bullet3).


### [Teamfight Tactics MuZero Agent](https://github.com/silverlight6/TFTMuZeroAgent)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/silverlight6/TFTMuZeroAgent)]()

Using [Google DeepMind](https://www.deepmind.com/)'s [MuZero](https://en.wikipedia.org/wiki/MuZero) algorithm to learn to play [Teamfight Tactics](https://teamfighttactics.leagueoflegends.com/en-us/), an auto chess game made by [Riot games](https://www.riotgames.com/en).

### [CookingZoo](https://github.com/DavidRother/gym-cooking)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.23.0-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/DavidRother/gym-cooking)]()

CookingZoo: a gym-cooking derivative to simulate a complex cooking environment.

### [Crazy-RL](https://github.com/ffelten/CrazyRL)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/ffelten/CrazyRL)]()

A library for doing reinforcement learning using [Crazyflie](https://www.bitcraze.io/products/crazyflie-2-1/) drones.


### [PettingZoo Dilemma Envs](https://github.com/tianyu-z/pettingzoo_dilemma_envs)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/tianyu-z/pettingzoo_dilemma_envs)]()

PettingZoo environments for classic game theory problems: [Prisoner's Dilemma](https://en.wikipedia.org/wiki/Prisoner%27s_dilemma), [Samaritan's Dilemma](https://en.wikipedia.org/wiki/Samaritan%27s_dilemma), [Stag Hunt](https://en.wikipedia.org/wiki/Stag_hunt), [Chicken](https://en.wikipedia.org/wiki/Chicken_(game)) and [Matching Pennies](https://en.wikipedia.org/wiki/Matching_pennies).


### [Breakout-Clone](https://github.com/SethCram/Breakout-Clone)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.1-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/SethCram/Breakout-Clone)]()

Modernized clone of the [Breakout](https://en.wikipedia.org/wiki/Breakout_(video_game)) arcade game, using [Unity](https://unity.com/) game engine and PettingZoo.
* Online playable game (using [Unity WebGL](https://docs.unity3d.com/2020.1/Documentation/Manual/webgl-gettingstarted.html) and [Unity ML-Agents](https://unity.com/products/machine-learning-agents)): [link](https://sethcram.weebly.com/breakout-clone.html), [tutorial](https://www.youtube.com/watch?v=zPFU30tbyKs)

### [Carla Gym](https://github.com/johnMinelli/carla-gym/)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.23.0-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/johnMinelli/carla-gym)]()

PettingZoo interface for CARLA Autonomous Driving simulator.

### [MATS Gym](https://github.com/AutonomousDrivingExaminer/mats-gym)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.23.0-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/AutonomousDrivingExaminer/mats-gym)]()

A multi-agent traffic scenario environment for CARLA that supports [ScenarioRunner](https://github.com/carla-simulator/scenario_runner), [OpenScenario](https://www.asam.net/standards/detail/openscenario/) and [Scenic](https://github.com/BerkeleyLearnVerify/Scenic) scenario descriptions. It is also compatible with the [CARLA Autonomous Driving Challenge](https://leaderboard.carla.org/challenge/).

### [Fanorona AEC](https://github.com/AbhijeetKrishnan/fanorona-aec)
[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.23.1-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/AbhijeetKrishnan/fanorona-aec)]()

Implementation of the board game *Fanorona*.

### [Gobblet-RL](https://github.com/elliottower/gobblet-rl)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/elliottower/gobblet-rl)]()

Interactive PettingZoo implementation of the [Gobblet](https://en.wikipedia.org/wiki/Gobblet) board game.
* Online game demo (using [Pygame WebAssembly](https://github.com/pygame-web)): [link](https://elliottower.github.io/gobblet-rl/), [tutorial](https://github.com/elliottower/gobblet-rl/blob/main/tutorials/WebAssembly/web_assembly.md)

### [Cathedral-RL](https://github.com/elliottower/cathedral-rl)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.3-blue)]()
[![GitHub stars](https://img.shields.io/github/stars/elliottower/cathedral-rl)]()

Interactive PettingZoo implementation of the [Cathedral](https://en.wikipedia.org/wiki/Cathedral_(board_game)) board game.

### [Interactive Connect Four](https://huggingface.co/spaces/ClementBM/connectfour)
[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.22.4-blue)]()
[![HuggingFace likes](https://img.shields.io/badge/stars-_2-blue)]()

 Play [Connect Four](/environments/classic/connect_four/) in real-time against an [RLlib](https://docs.ray.io/en/latest/rllib/index.html) agent trained via self-play and PPO.
* Online game demo (using [Gradio](https://www.gradio.app/) and [HuggingFace Spaces](https://huggingface.co/docs/hub/spaces-overview)): [link](https://huggingface.co/spaces/ClementBM/connectfour), [tutorial](https://clementbm.github.io/project/2023/03/29/reinforcement-learning-connect-four-rllib.html)



___

## Environments using older versions of PettingZoo
*The following environments use a now-depreciated API design for PettingZoo, so may be more difficult to use.*

### [Neural MMO](https://github.com/jsuarez5341/neural-mmo)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.19.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/jsuarez5341/neural-mmo)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/jsuarez5341/neural-mmo)]()

Massively multiagent environment, inspired by Massively Multiplayer Online (MMO) role-playing games.


### [Sequential Social Dilemma Games](https://github.com/eugenevinitsky/sequential_social_dilemma_games)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.13.1-red)]()
[![GitHub stars](https://img.shields.io/github/stars/eugenevinitsky/sequential_social_dilemma_games)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/eugenevinitsky/sequential_social_dilemma_games)]()

An open-source implementation of DeepMind's Sequential Social Dilemma (SSD) multi-agent game-theoretic environments [[1]](https://arxiv.org/abs/1702.03037).
* Note: DeepMind's recently released [Meltingpot](https://github.com/deepmind/meltingpot) includes these scenarios and many more, and can be used with PettingZoo via a [Shimmy](http://shimmy.farama.org/) conversion wrapper.


### [Kaggle Environments](https://github.com/Kaggle/kaggle-environments)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.12.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/Kaggle/kaggle-environments)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/Kaggle/kaggle-environments)]()

Environments for [Kaggle](https://www.kaggle.com/) machine learning challenges.


### [cogment-verse](https://github.com/cogment/cogment-verse)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.18.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/cogment/cogment-verse)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/cogment/cogment-verse)]()

Library of Environments, Human Actor UIs and Agent implementation for Human In the Loop Learning & Reinforcement Learning.


### [Stone Ground Hearth Battles](https://github.com/JDBumgardner/stone_ground_hearth_battles)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.4.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/JDBumgardner/stone_ground_hearth_battles)]()
![GitHub last commit](https://img.shields.io/github/last-commit/JDBumgardner/stone_ground_hearth_battles)

Simulator and environments for [Blizzard](https://www.blizzard.com/en-us/)'s popular card game [Hearthstone Grounds](https://hearthstone.blizzard.com/en-us/battlegrounds/), including bots and human-interaction.


### [Cyber Operations Research Gym](https://github.com/cage-challenge/CybORG)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.19.2-red)]()
[![GitHub stars](https://img.shields.io/github/stars/cage-challenge/CybORG)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/cage-challenge/CybORG)]()

A cyber-security research environment for training and development of security human and autonomous agents.


### [conflict_rez](https://github.com/XuShenLZ/conflict_rez)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.19.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/XuShenLZ/conflict_rez)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/XuShenLZ/conflict_rez)]()

Conflict resolution for multiple vehicles in confined spaces.


### [pz-battlesnake](https://github.com/DaBultz/pz-battlesnake)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.19.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/DaBultz/pz-battlesnake)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/DaBultz/pz-battlesnake)]()

PettingZoo environment for online multi-player game [Battlesnake](https://play.battlesnake.com/).


### [BomberManAI](https://github.com/NaIwo/BomberManAI)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.16.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/NaIwo/BomberManAI)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/NaIwo/BomberManAI)]()

Environment with a simplified version of the video game *BomberMan*.

### [Galaga AI](https://github.com/SonicKurt/Galaga-AI)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.15.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/SonicKurt/Galaga-AI)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/SonicKurt/Galaga-AI)]()

Implementation of the [Galaga](https://en.wikipedia.org/wiki/Galaga) arcade game using [Unity](https://unity.com/) game engine and [Unity ML-Agents](https://unity.com/products/machine-learning-agents).


### [skyjo_rl](https://github.com/michaelfeil/skyjo_rl)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.14.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/michaelfeil/skyjo_rl)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/michaelfeil/skyjo_rl)]()

Implementation of the board game *SkyJo*.


### [Mu Torere](https://github.com/Aroksak/MuTorere)

[![PettingZoo version dependency](https://img.shields.io/badge/PettingZoo-v1.14.0-red)]()
[![GitHub stars](https://img.shields.io/github/stars/Aroksak/MuTorere)]()
[![GitHub last commit](https://img.shields.io/github/last-commit/DaBultz/pz-battlesnake)]()

Implementation of the board game *Mū tōrere* from New Zealand.


___

[//]: # (https://github.com/quantumiracle/MARS: WIP, not released yet )

[//]: # (## StarCraft Multi-Agent Challenge &#40;high priority fix&#41;)

[//]: # ([https://github.com/oxwhirl/smac]&#40;https://github.com/oxwhirl/smac&#41;)

[//]: # ()
[//]: # (Collection of widely used StarCraft2 based cooperative environments.)


[//]: # ()
[//]: # (## Hearthstone Battlegrounds Simulator &#40;not vc, will break&#41;)

[//]: # ([https://github.com/JDBumgardner/stone_ground_hearth_battles]&#40;https://github.com/JDBumgardner/stone_ground_hearth_battles&#41;)

[//]: # ()
[//]: # (PettingZoo environment wrapper for Blizzard's Hearthstone game.)

[//]: # ()
[//]: # (## Longroad Envs &#40;not vc, will break&#41;)

[//]: # ([https://github.com/grzPat/longroad-envs]&#40;https://github.com/grzPat/longroad-envs&#41;)

[//]: # ()
[//]: # (Multi-Agent traffic control environments.)

[//]: # ()
[//]: # ()
[//]: # (## PZ Dilemma &#40;not vc, will break&#41;)

[//]: # ([https://github.com/arjun-prakash/pz_dilemma]&#40;https://github.com/arjun-prakash/pz_dilemma&#41;)

[//]: # ()
[//]: # (Collection of prisoner's dilemma games as PettingZoo environments)

[//]: # ()
[//]: # (## Ants &#40;just an env, pre term/trunc style&#41;)

[//]: # ([https://github.com/chorsch/ants]&#40;https://github.com/chorsch/ants&#41;)

[//]: # ()
[//]: # (Simplified simulation of an ant colony)

[//]: # ()
[//]: # (## Generalized Rock Paper Scissors &#40;old fork&#41;)

[//]: # ([https://github.com/afozk95/PettingZoo/tree/add_generalized_rps]&#40;https://github.com/afozk95/PettingZoo/tree/add_generalized_rps&#41;)

[//]: # ()
[//]: # (More general n-players form of the Rock Paper Scissors environments in PettingZoo)

[//]: # ()
[//]: # (## PZ Risk &#40;no deps&#41;)

[//]: # ([https://github.com/mahi97/pz_risk]&#40;https://github.com/mahi97/pz_risk&#41;)

[//]: # ()
[//]: # (Implementation of the Risk board game as a PettingZoo environment)

[//]: # (## Sequential Social Delima Games &#40;will break&#41;)

[//]: # ([https://github.com/eugenevinitsky/sequential_social_dilemma_games/pull/197]&#40;https://github.com/eugenevinitsky/sequential_social_dilemma_games/pull/197&#41;)

[//]: # ()
[//]: # (Set of two environments with numerous multi-agent equilibria popular with researchers)

[//]: # (## SNIM &#40;deleted&#41;)

[//]: # ([https://github.com/qihuazhong/SNIM/blob/main/snim/envs.py]&#40;https://github.com/qihuazhong/SNIM/blob/main/snim/envs.py&#41;)

[//]: # ()
[//]: # (PettingZoo based supply chain management environment)

[//]: # ()
[//]: # (## CityLearn &#40;not vc, unreachable&#41;)

[//]: # ()
[//]: # ([https://github.com/apigott/CityLearn]&#40;https://github.com/apigott/CityLearn&#41;)
[//]: # ()
[//]: # (PettingZoo environments for city grid power management, based on the CityLearn simulator.)
