import openai # For GPT-3 API ...
import os,requests
from utils import *
import collections

class Baseline_engine():
    def __init__(self, args):
        self.args = args
        self.system_prompt = get_system_prompt(args)
        self.demo = get_demo(args)
        self.generation = ""

    def generate(self, decoder, x, parse_groups):  
        x = self.demo + x + self.system_prompt
        if self.args.stat:
            output = decoder.decode_with_stat(x, parse_groups)
        else:        
            output = decoder.decode(x)
        self.generation = answer_cleansing(output)

        return self.generation


def create_inference_engine(args):
    if args.method in ("direct_prompt", "zero_shot_cot"):
        return Baseline_engine(args)
    else:
        raise ValueError("method is not properly defined ...")