# Finite Element Operator Network for Solving Parametric PDEs

## Requirements

The codes in this repositroy were tested using Python 3.10.9, and Pytorch 1.13.1 with the cuda 12.0.

## Data generation
Generate data for accuracy measurement (FEONet is an unsupervised model that requires only random input functions and does not require labels).

1) Data generation in fine-grained elements.
```
python3 create_data_exact.py --equation Standard --eps 0.1 --b -1 --file 3000N1000 --num_data 3000 --basis_order 2 --kind train
```
```
python3 create_data_exact.py --equation Standard --eps 0.1 --b -1 --file 3000N1000 --num_data 3000 --basis_order 2 --kind validate
```

2) Data generation in coarse-grained elements by interpolating data in fine-grained elements.
```
python3 create_data_interpol.py --equation Standard --eps 0.1 --b -1 --file 3000N24 --num_data 3000 --basis_order 2 --kind train --exact 1000
```
```
python3 create_data_interpol.py --equation Standard --eps 0.1 --b -1 --file 3000N24 --num_data 3000 --basis_order 2 --kind validate --exact 1000
```

## Run

Example on the 1D convection-diffusion equation with Dirichlet boundary condition
```
python3 -u FEONet_1D.py --equation Standard --eps 0.1 --b -1 --file 3000N24 --basis_order 2 --model NetA --blocks 4 --ks 5 --filters 32 --epochs 150000
```
A pretrained model on the 1D convection-diffusion equation with Dirichlet boundary condition can be loaded by
```
model.load_state_dict(torch.load('train/P2/3000N24/pretrained/model.pt'))
```
