## Installation

1. Create a new environment

murmur requires Python 3.10 or higher. You may create and activate a new environment:

```bash
python -m venv .venv
source .venv/bin/activate
```

2. Install murmur

```bash
pip install -e .
```

This will enable you to run the `murmur` command.

**Note:** If you use `pip install .` (without `-e`), you'll need to set the `murmur_DATA_DIR` environment variable to point to your data directory:

```bash
export murmur_DATA_DIR=/path/to/your/murmur/data
```
## Run murmur

To run a test evaluation on only 5 tasks with 1 trial per task, run:

```bash
src.murmur.cli run 
--domain airline  # which domain to run
--agent-llm gpt-4.1 # which model to use for the agent
--user-llm gpt-4.1-mini # which model to use for the user
--num-trials 1 
--multi-user # whether to run in multi-user mode
--num-tasks 5 # number of tasks to run concurrently
--max-steps 120 # maximum number of steps to run
--injection-task injection_task_1 # which injection task to run (leave empty for no injection)
--agent llm-agent-murmur # which agent to use (empty for default llm with complete history in context)
--task-ids 1 2 3 # which tasks to run (leave empty for all tasks)
--log-level DEBUG # which log level to use, leave empty for no logging
```

Domains:
1. Slack
2. Workspace
3. Airline

Results will be saved in `data/murmur/simulations/`.

# Credits

This work uses tau2-bench (Barres et. al., 2025) as the code foundation on which we build multi-user simulation capabilities.
