# Copyright Sierra
import json
from typing import Optional, cast

from murmur.data_model.tasks import Task
from murmur.domains.slack.data_model import SlackDB
from murmur.domains.slack.tools import SlackTools
from murmur.domains.slack.utils import (
    SLACK_DB_PATH,
    SLACK_POLICY_PATH,
    SLACK_TASK_SET_PATH,
    SLACK_INJECTION_TASKS_PATH,
)
from murmur.environment.environment import Environment


def get_environment(
    db: Optional[SlackDB] = None,
    solo_mode: bool = False,
) -> Environment:
    if solo_mode:
        raise ValueError("Slack domain does not support solo mode")
    if db is None:
        db = cast(SlackDB, SlackDB.load(str(SLACK_DB_PATH)))
    tools = SlackTools(db)
    with open(SLACK_POLICY_PATH, "r") as fp:
        policy = fp.read()
    return Environment(
        domain_name="slack",
        policy=policy,
        tools=tools,
    )


def get_tasks() -> list[Task]:
    with open(SLACK_TASK_SET_PATH, "r") as fp:
        tasks = json.load(fp)
    return [Task.model_validate(task) for task in tasks]


def get_injection_tasks() -> list[Task]:
    """Load injection tasks from injection_tasks.json"""
    with open(SLACK_INJECTION_TASKS_PATH, "r") as fp:
        tasks = json.load(fp)
    return [Task.model_validate(task) for task in tasks]
