import json
from typing import Optional, cast

from murmur.data_model.tasks import Task
from murmur.domains.workspace.data_model import WorkspaceDB
from murmur.domains.workspace.tools import WorkspaceTools
from murmur.domains.workspace.utils import (
    WORKSPACE_DB_PATH,
    WORKSPACE_POLICY_PATH,
    WORKSPACE_TASK_SET_PATH,
    WORKSPACE_INJECTION_TASKS_PATH,
)
from murmur.environment.environment import Environment


def get_environment(
    db: Optional[WorkspaceDB] = None,
    solo_mode: bool = False,
) -> Environment:
    if solo_mode:
        raise ValueError("Workspace domain does not support solo mode")
    if db is None:
        db = cast(WorkspaceDB, WorkspaceDB.load(str(WORKSPACE_DB_PATH)))
    files = db.drive.files
    for file in files.values():
        file.size = len(file.content)
    db.drive.files = files
    tools = WorkspaceTools(db)
    with open(WORKSPACE_POLICY_PATH, "r") as fp:
        policy = fp.read()
    return Environment(
        domain_name="workspace",
        policy=policy,
        tools=tools,
    )


def get_tasks() -> list[Task]:
    with open(WORKSPACE_TASK_SET_PATH, "r") as fp:
        tasks = json.load(fp)
    return [Task.model_validate(task) for task in tasks]


def get_injection_tasks() -> list[Task]:
    with open(WORKSPACE_INJECTION_TASKS_PATH, "r") as fp:
        tasks = json.load(fp)
    return [Task.model_validate(task) for task in tasks]




