﻿
# POC: Preventing the Over-Collapse of Classes for Class-Incremental Learning

## Introduction

  

This is the Pytorch implementation of our submitted paper.

  

### Environment Preparation

- Download the code and pretrained models:

https://drive.google.com/file/d/1izswc_2n9HImT2TlzlH5ElzjYe53n1Zv/view?usp=sharing

There should be the following folders:

- cifar100-class-incremental

- utils_incremental

  

- Create a new environment and install the following packages:

- Python = 3.8.13, CUDA = 10.2, CUDNN = 8.0.4

- PyTorch = 1.9.0, torchvision = 0.10.0

  

## Data Preparation

  

**CIFAR-100:**

  

- We use CIFAR-100 as the evaluation dataset. The dataset is already prepared in the “cifar100-class-incremental” folder so that there is no need to download it again.

  
  

## Inference

  
  

To reproduce the results of LUCIR with POC on CIFAR-100, please enter “cifar100-class-incremental” and run:

```

python class_incremental_cosine_cifar100.py \

--nb_cl_fg 50 --nb_cl 10 --nb_protos 20 \

--resume --rs_ratio 0.0 \

--less_forget --lamda 5 --adapt_lamda \

--random_seed 1993 \

--mr_loss --dist 0.5 --K 2 --lw_mr 1 \

--ckp_prefix seed_1993_rs_ratio_0.0_class_incremental_MR_LFAD_cosine_cifar100

```

The results are under the setting that the class number of the first task and following tasks are 50 and 10 respectively.

### Notice:

Our codes are uploaded only for peer review, please do not distribute them.
