import sys
from transformers import T5Tokenizer, T5ForConditionalGeneration
import torch
tokenizer = T5Tokenizer.from_pretrained("path_to_model", model_max_length=512)
model = T5ForConditionalGeneration.from_pretrained(f'path_to_model').cuda()


from random import randint
num_try = 100
seeds = [32101+i for i in range(num_try)]

with open(f"path_to_generated_molecules", "w") as f:
    for (idx,i) in enumerate(seeds):
        input_text = 'A similar chemical of [S*]'
        input_ids = tokenizer(input_text, return_tensors="pt").input_ids
        dummy_token = seeds[idx]
        input_ids = torch.cat([input_ids[0][:-1].clone(), torch.Tensor([dummy_token, dummy_token]).long(),input_ids[0][-1:].clone()], dim=-1)
        input_ids = input_ids.unsqueeze(0).cuda()
        pader = torch.zeros_like(input_ids).cuda()
        outputs = model.generate(input_ids, num_beams=5, max_length=256)
        output = tokenizer.decode(outputs[0], skip_special_tokens=True)
        f.write(f"{output}\n")
