#%The data was generated with healthy participants simulating the
#%class activities of performed. Data was collected from 6
#%participants using a tri-axial accelerometer on the dominant wrist
#%whilst conducting 4 different activities. The four tasks, each of
#%different length, are: WALKING includes different paces and
#%gestures: walking slowing while gesturing, walking slowly, walking
#%normal and walking fast, each of 30 seconds long. RUNNING includes
#%running a 40 meters long corridor. SAWING with a saw and during 30
#%seconds. SEIZURE MIMICKING seated, with 5-6 sec before and 30 sec
#%after the mimicked seizure. The seizure was 30 sec long.
#%
#%Each participant performs each activity 10 times at least. The
#mimicked seizures were trained and controlled, following a protocol
#defined by an medical expert. All the activities were carried out
#indoors, either inside an office or in the corridor around it.
#
#The sampling frequency was 16 Hz. Some activities lasted about 30
#seconds, others are 1 minute long, others are about 2 minutes. Our
#standard practice for the archive is to truncate data to the length
#of the shortest series retained. We removed prefix and suffix flat
#series and truncated to the shortest series (20 measurements,
#approx 13 seconds), taking a random interval of activity for series
#longer than the minimum. A single case
#from the original (ID002 Running 16) was removed because the data
#was not collected correctly. After tidying the data we have a total
#of 275 cases. The train test split is divided into three
#participants for training, three for testing, with the IDs removed
#for consistency with the rest of the archive.
#
#Relevant Papers:
#[1] Villar JR, Vergara P, Menéndez M, de la Cal E, González VM, Sedano J.
#Generalized Models for the Classification of Abnormal Movements in Daily Life and its Applicability to Epilepsy Convulsion Recognition. Int
#J Neural Syst. 2016 Sep;26(6) 2016
@problemName Epilepsy
@timeStamps false
@missing false
@univariate false
@dimensions 3
@equalLength true
@seriesLength 206
@classLabel true EPILEPSY WALKING RUNNING SAWING
@data
0.6,0.6,0.6,0.61,0.59,0.59,0.59,0.6,0.6,0.6,0.59,0.58,0.56,0.53,0.53,0.54,0.56,0.56,0.53,0.54,0.51,0.47,0.46,0.49,0.48,0.49,0.5,0.51,0.49,0.49,0.48,0.44,0.46,0.45,0.46,0.47,0.48,0.48,0.48,0.48,0.42,0.38,0.37,0.28,0.24,0.24,0.19,0.12,0.12,0.07,0.06,0.01,-0.09,-0.1,-0.12,-0.17,-0.18,-0.19,-0.19,-0.17,-0.18,-0.24,-0.23,-0.2,-0.21,-0.21,-0.2,-0.23,-0.25,-0.24,-0.25,-0.27,-0.27,-0.24,-0.33,-0.29,-0.29,-0.32,-0.29,-0.26,-0.19,-0.19,-0.16,-0.15,-0.1,-0.06,-0.09,-0.06,-0.04,-0.07,-0.21,0.07,0.11,0.02,0.01,0.12,0.12,0.09,0.03,0.02,-0.04,-0.04,-0.03,0.0,0.0,0.01,0.0,-0.02,-0.01,0.0,0.0,-0.01,-0.07,0.0,-0.11,-0.18,-0.13,-0.12,-0.12,-0.13,-0.11,-0.09,-0.18,-0.18,-0.2,-0.21,-0.21,-0.19,-0.21,-0.25,-0.34,-0.35,-0.36,-0.34,-0.34,-0.36,-0.38,-0.39,-0.38,-0.39,-0.41,-0.45,-0.47,-0.48,-0.51,-0.52,-0.52,-0.52,-0.52,-0.51,-0.51,-0.52,-0.52,-0.52,-0.52,-0.51,-0.5,-0.49,-0.5,-0.54,-0.58,-0.61,-0.63,-0.66,-0.67,-0.68,-0.69,-0.68,-0.69,-0.69,-0.68,-0.68,-0.67,-0.68,-0.68,-0.68,-0.68,-0.68,-0.69,-0.7,-0.69,-0.7,-0.7,-0.7,-0.72,-0.7,-0.69,-0.73,-0.77,-0.77,-0.71,-0.72,-0.71,-0.73,-0.74,-0.75,-0.77,-0.75,-0.7,-0.68,-0.69,-0.7,-0.7,-0.69,-0.7,-0.7:-1.72,-1.28,1.49,0.78,-0.71,-1.62,1.17,1.17,0.2,-1.88,-1.29,1.66,0.89,-0.19,-1.79,0.34,1.22,0.55,-1.25,-1.65,1.37,0.93,-0.25,-1.79,0.17,1.38,0.46,-1.42,-1.6,1.36,0.98,-0.35,-1.79,0.27,0.92,0.5,-1.35,-1.32,1.56,1.08,-0.1,-1.85,0.07,1.24,0.47,-1.43,-1.58,1.49,1.05,-0.63,-1.66,1.34,1.16,-0.09,-1.58,-0.14,1.63,0.83,-1.39,-0.94,2.07,1.34,0.25,-1.69,1.34,1.48,0.28,-1.79,0.02,1.89,0.98,-1.65,-1.34,1.7,1.33,-0.27,-1.84,0.14,1.38,0.56,-1.32,-0.38,1.31,0.56,-1.09,-1.54,1.54,1.03,-0.17,-1.77,0.02,1.5,0.49,-1.49,-1.52,1.51,0.99,-0.42,-1.61,1.36,1.44,0.31,-1.46,-0.27,1.56,0.64,-1.13,-1.19,1.84,1.08,-0.59,-1.61,1.26,1.18,0.05,-1.68,0.25,1.15,0.73,-1.39,-1.44,1.62,0.9,-0.19,-1.63,0.84,1.11,0.18,-1.54,-0.73,1.23,0.77,-0.77,-1.49,1.23,1.12,-0.28,-1.34,0.64,1.36,0.45,-1.55,-1.27,1.55,0.58,-0.54,-1.75,0.78,0.98,-0.08,-1.88,-0.55,1.59,0.6,-0.88,-1.49,1.45,0.88,-0.17,-1.84,-0.04,1.29,0.32,-1.36,-1.29,1.67,0.96,-0.41,-1.64,0.64,1.2,0.43,-1.29,-1.52,1.21,0.94,-0.15,-1.72,0.42,1.21,0.29,-1.49,-1.36,1.41,1.16,0.47,-1.6,0.48,1.03,0.2,-1.91,-1.21,1.36,0.96,-0.71,-1.87,0.68,1.22,0.28,-1.82,-1.13,1.49,0.85,-0.73,-1.76,1.03:-0.47,0.02,-0.17,-0.25,-0.25,-0.4,0.24,0.51,-0.05,-0.52,0.45,-0.23,-0.23,-0.26,-0.15,-0.07,-0.47,-0.48,-0.4,-0.3,-0.33,-0.37,-0.46,-0.21,-0.27,-0.52,-0.12,-0.43,0.01,-0.27,0.06,-0.46,-0.01,-0.1,-0.33,-0.6,0.21,-0.18,-0.48,-0.28,-0.24,0.2,0.06,-0.44,-0.63,0.15,-0.85,-1.17,-0.81,0.14,-0.28,-0.8,-0.65,-0.55,0.27,0.19,-0.32,-0.47,0.26,-0.17,-0.62,-0.52,-0.35,-0.08,-0.79,-0.65,-0.7,0.25,-0.27,-0.82,-0.61,-0.18,-0.37,-0.89,-0.59,-0.23,-0.08,-0.12,-0.25,-0.55,0.3,0.64,-0.07,-0.54,0.75,-0.11,0.03,-0.27,-0.12,0.21,0.26,-0.22,-0.6,0.51,-0.2,-0.38,-0.5,0.16,-0.03,-0.23,-0.63,-0.23,0.3,-0.01,-0.39,-0.69,0.82,-0.38,-0.63,-0.46,-0.15,0.26,-0.05,-0.27,-0.47,0.63,-0.35,-0.48,-0.55,0.26,-0.01,-0.57,-0.43,-0.37,0.49,-0.12,-0.48,-0.67,0.3,-0.4,-0.59,-0.55,-0.21,0.11,0.28,-0.43,-0.57,0.46,-0.29,-0.05,-0.21,-0.26,0.42,0.85,0.02,-0.53,0.8,-0.15,0.85,-0.13,-0.37,0.92,1.19,0.25,-0.43,0.9,-0.05,0.13,-0.25,0.2,0.25,0.0,-0.13,-0.47,0.76,-0.1,-0.6,-0.4,0.11,0.17,-0.39,-0.47,-0.28,0.58,0.2,-0.6,-0.52,0.13,-0.27,-0.47,-0.55,-0.29,0.3,0.23,-0.45,-0.76,0.54,-0.35,-0.67,-0.66,-0.11,-0.03,-0.78,-0.65,-0.8,-0.03,-0.3,-1.49,-0.83,-0.5,-0.49,-0.5,-0.53,-0.36,-0.51,-0.57:EPILEPSY
-0.35,-0.44,-0.86,-0.64,-0.45,-0.25,-0.08,-0.07,0.3,0.73,1.01,0.87,0.65,0.39,0.55,0.6,0.58,0.63,0.66,0.66,0.65,0.65,0.66,0.65,0.65,0.66,0.66,0.66,0.66,0.66,0.65,0.66,0.66,0.66,0.66,0.79,0.64,0.59,0.54,0.56,0.59,0.56,0.55,0.51,0.51,0.51,0.52,0.53,0.52,0.49,0.48,0.5,0.5,0.48,0.51,0.51,0.5,0.52,0.5,0.5,0.52,0.5,0.5,0.5,0.5,0.5,0.5,0.51,0.53,0.5,0.43,0.45,0.48,0.51,0.55,0.56,0.54,0.55,0.54,0.57,0.59,0.55,0.55,0.63,0.6,0.56,0.51,0.48,0.47,0.47,0.64,0.86,1.21,1.23,0.97,0.9,1.0,0.99,0.92,0.9,0.86,0.88,0.95,1.01,1.02,1.0,0.99,0.96,0.95,0.93,0.94,0.95,0.96,0.96,0.97,0.97,0.96,0.96,0.96,0.95,0.95,0.94,0.96,0.96,0.97,0.96,0.96,0.95,0.98,0.95,0.95,0.91,0.92,0.89,0.95,0.84,0.84,0.83,0.85,0.82,0.8,0.91,0.69,0.82,0.75,0.78,0.74,0.69,0.7,0.66,0.67,0.67,0.7,0.63,0.63,0.65,0.7,0.62,0.63,0.61,0.59,0.52,0.58,0.55,0.4,0.26,0.2,0.09,-0.09,-0.04,0.02,-0.06,-0.09,-0.08,-0.06,-0.09,-0.07,-0.02,-0.02,0.0,0.06,0.11,0.33,0.24,-0.14,-0.38,-0.37,-0.35,-0.4,-0.47,-0.42,-0.39,-0.41,-0.33,-0.24,-0.09,-0.03,-0.08,-0.06,-0.01,-0.05,-0.03,-0.11,-0.18,-0.16,-0.14:-0.99,-2.3,-0.57,0.91,0.65,-1.96,-1.77,0.07,1.33,-0.72,-2.3,-0.88,0.54,0.53,-1.52,-1.73,-0.12,1.24,-0.5,-2.44,-0.37,1.42,-0.59,-2.42,-0.85,1.06,1.24,-0.72,-2.37,-0.87,0.83,1.22,-0.74,-2.12,-0.08,1.6,-1.07,-2.38,-0.96,1.0,0.91,-1.54,-1.77,0.07,1.57,-0.58,-2.43,-0.9,0.54,0.93,-0.83,-2.2,-0.5,1.09,-1.0,-2.18,-1.11,0.56,1.06,-0.85,-2.2,-0.56,1.13,-0.78,-2.39,-1.23,0.37,1.09,-0.66,-1.79,-0.4,1.04,0.94,-1.47,-1.85,0.04,1.19,-0.42,-2.33,-1.25,0.6,1.23,-0.75,-2.22,-0.59,0.77,0.64,-1.53,-1.82,0.13,1.27,-0.34,-2.35,-1.17,0.63,0.87,-1.23,-1.58,0.13,0.21,-0.76,-0.97,-0.53,-0.16,-0.32,0.26,0.31,-0.5,-1.35,-1.46,-0.63,-0.47,-0.27,-0.34,-0.55,-0.6,-0.48,-0.44,-0.51,-0.53,-0.52,-0.51,-0.52,-0.52,-0.51,-0.52,-0.51,-0.51,-0.51,-0.51,-0.51,-0.51,-0.38,-0.43,-0.62,-0.56,-0.67,-0.71,-0.48,-0.56,-0.62,-0.74,-0.75,-0.76,-0.88,-0.8,-0.84,-0.72,-0.73,-0.68,-0.66,-0.68,-0.63,-0.67,-0.67,-0.7,-0.82,-0.65,-0.68,-0.67,-0.61,-0.58,-0.6,-0.57,-0.57,-0.59,-0.59,-0.66,-0.81,-0.87,-0.83,-0.92,-0.9,-0.92,-0.81,-0.52,-0.67,-0.57,-0.66,-0.61,-0.48,-0.57,-0.5,-0.46,-0.38,-0.19,-0.13,-0.41,-0.64,-0.58,-1.0,-1.63,-1.04,-0.43,-0.07,-0.09,-0.24,-0.32,-0.29,-0.28,-0.3,-0.27,-0.22,-0.25,-0.32,-0.34:0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.04,0.05,0.05,0.05,0.03,0.03,0.04,0.04,0.04,0.03,0.04,0.04,0.04,0.03,0.04,0.03,0.03,0.07,0.1,-0.05,0.14,0.79,0.25,-0.11,0.01,0.26,0.13,-0.23,-0.52,-0.55,0.55,-0.21,-0.78,0.79,0.45,0.16,-0.31,0.62,0.27,-0.09,-0.27,0.91,0.4,0.03,-0.43,0.81,0.74,0.15,-0.47,0.45,0.76,0.3,-0.16,-0.44,0.67,0.44,-0.11,-0.67,0.58,0.62,-0.23,-0.63,1.02,0.44,0.06,-0.48,1.24,0.76,0.38,-0.71,1.24,0.94,0.2,-0.21,0.06,1.34,0.36,0.17,-0.33,1.33,0.7,0.07,-0.6,1.12,1.09,0.03,-0.43,0.68,2.19,0.36,0.48,0.9,1.87,0.55,0.25,-0.01,2.03,0.63,0.51,-0.29,1.52,0.72,0.07,-0.46,1.3,0.77,0.1,-0.45,1.16,0.74,0.16,-0.41,0.96,0.56,0.08,-0.35,1.45,1.02,0.18,-0.38,1.14,0.64,0.49,-0.41,1.02,0.29,-0.04,-0.3,1.22,0.27,-0.05,-0.22,1.37,0.52,0.23,-0.5,1.13,0.64,0.3,-0.48,1.01,0.72,-0.02,-0.47,1.12,0.78,0.12,-0.39,0.81,0.74,0.23,-0.57,1.07,0.68,0.01,-0.45,0.95,0.99,-0.17,-0.45,1.11,0.93,-0.29,-0.63,0.95,0.85,0.12,-0.04,-0.28,0.89,0.42,0.02,-0.42,0.51,0.6,0.1,-0.1,-0.25,0.94,0.57,-0.07,-0.22,0.55,0.83:EPILEPSY
-0.08,-0.01,-0.53,-0.49,0.04,-0.44,-0.42,-0.04,0.04,-0.43,-0.5,0.1,-0.19,-0.29,-0.36,-0.01,-0.64,-0.57,-0.15,-0.09,-0.61,-0.51,-0.02,-0.13,-0.64,-0.26,0.03,-0.66,-0.72,-0.02,-0.02,-0.65,-0.22,0.14,-0.63,-0.66,-0.18,-0.07,-0.76,-0.66,-0.11,-0.1,-0.51,-0.45,-0.15,-0.4,-0.47,-0.41,-0.09,-0.45,-0.37,-0.48,-0.14,-0.61,-0.46,-0.52,-0.1,-0.59,-0.37,-0.53,-0.12,-0.6,-0.48,-0.44,-0.14,-0.67,-0.62,-0.33,-0.15,-0.62,-0.41,-0.55,-0.15,-0.32,-0.41,-0.4,-0.28,-0.26,-0.61,-0.5,-0.25,-0.23,-0.57,-0.5,-0.21,-0.23,-0.62,-0.47,-0.16,-0.31,-0.5,-0.43,-0.17,-0.43,-0.47,-0.5,-0.13,-0.31,-0.55,-0.31,-0.07,-0.41,-0.34,-0.34,-0.09,-0.4,-0.51,-0.34,0.0,-0.45,-0.42,-0.47,-0.03,-0.41,-0.28,-0.45,-0.21,-0.39,-0.36,-0.49,-0.16,-0.31,-0.34,-0.56,-0.11,-0.24,-0.34,-0.56,-0.06,-0.31,-0.32,-0.52,-0.01,-0.52,-0.51,-0.38,-0.06,-0.62,-0.41,-0.35,-0.09,-0.38,-0.42,-0.11,-0.08,-0.6,-0.32,0.08,-0.52,-0.68,-0.17,-0.07,0.1,0.48,0.65,0.56,0.5,0.45,0.39,0.3,0.33,0.32,0.35,0.38,0.4,0.39,0.4,0.43,0.43,0.38,0.37,0.33,0.31,0.28,0.3,0.32,0.4,0.38,0.36,0.35,0.34,0.33,0.34,0.36,0.35,0.36,0.38,0.38,0.33,0.31,0.31,0.3,0.32,0.33,0.34,0.36,0.37,0.41,0.38,0.35,0.32,0.34,0.36,0.34,0.32,0.32:-1.02,-2.12,-0.95,0.4,0.01,-1.82,-1.23,0.55,-0.08,-1.91,-1.2,0.45,-0.1,-1.94,-1.04,0.37,-0.86,-2.0,-0.7,0.32,-0.82,-1.82,-0.62,0.09,-0.55,-2.12,-0.4,0.51,-0.91,-2.33,-0.52,0.26,-0.65,-2.21,-0.39,0.75,-1.08,-2.04,-0.14,0.45,-1.2,-1.91,-0.49,0.23,-0.74,-2.03,-0.68,0.34,-0.47,-2.11,-0.75,0.29,-0.61,-2.02,-0.65,0.29,-1.04,-2.13,-0.18,0.22,-0.83,-1.85,0.04,0.28,-1.14,-1.59,0.41,-0.09,-1.72,-1.24,0.54,-0.31,-2.05,-0.29,0.69,-0.87,-1.7,0.06,0.56,0.32,-0.52,-0.71,-1.39,-0.83,-0.67,-0.5,-0.6,-0.65,-0.75,-0.71,-0.68,-0.89,-0.95,-0.95,-0.95,-0.88,-0.8,-0.76,-0.74,-0.73,-0.7,-0.74,-0.78,-0.72,-0.75,-0.79,-0.79,-0.86,-0.85,-0.84,-0.89,-0.87,-0.9,-0.91,-0.88,-0.75,-0.79,-0.77,-0.78,-0.86,-0.92,-0.94,-0.95,-0.97,-0.94,-0.94,-0.77,-0.79,-0.86,-0.85,-0.79,-0.92,-0.92,-0.88,-0.89,-0.82,-0.85,-0.86,-0.89,-0.92,-0.82,-0.88,-0.85,-0.8,-0.78,-0.79,-0.75,-0.65,-0.62,-0.69,-0.7,-0.72,-0.8,-0.79,-0.78,-0.78,-0.73,-0.71,-0.75,-0.73,-0.75,-0.77,-0.78,-0.77,-0.77,-0.78,-0.8,-0.8,-0.79,-0.8,-0.81,-0.8,-0.82,-0.78,-0.78,-0.74,-0.72,-0.72,-0.7,-0.68,-0.66,-0.66,-0.69,-0.71,-0.74,-0.75,-0.74,-0.75,-0.75,-0.72,-0.73,-0.7,-0.68,-0.69,-0.66,-0.55,-0.5,-0.52,-0.55,-0.54,-0.55,-0.58,-0.53,-0.54,-0.62,-0.67:-0.03,-0.48,0.45,-0.33,-0.06,-0.54,-0.21,-0.39,-0.41,-0.09,-0.26,-0.33,-0.48,-0.1,-0.11,-0.32,-0.59,0.44,-0.33,-0.29,-0.8,0.25,-0.35,0.04,-0.68,0.12,-0.46,-0.11,-0.51,0.04,-0.43,-0.03,-0.77,0.01,-0.11,-0.25,-0.14,-0.25,-0.14,-0.55,0.21,-0.39,-0.07,-0.51,-0.43,-0.4,-0.01,0.18,-0.56,-0.13,-0.49,-0.32,-0.44,-0.03,-0.62,-0.38,-0.41,-0.35,0.03,-0.42,-0.05,-0.74,-0.45,-0.63,-0.09,-0.81,-0.54,-0.52,-0.51,0.1,-0.55,-0.08,-0.64,-0.55,-0.48,-0.16,0.1,-0.41,-0.04,-0.54,-0.02,-0.52,0.03,-0.59,-0.29,-0.3,0.02,-0.83,-0.17,-0.38,-0.11,-0.37,-0.21,-0.38,-0.06,-0.53,-0.13,-0.34,-0.16,-0.48,-0.38,-0.28,-0.09,-0.44,-0.44,-0.25,-0.08,-0.54,-0.68,-0.43,-0.42,-0.56,-0.3,-0.38,-0.09,-0.6,-0.35,-0.33,-0.17,-0.69,-0.36,-0.43,-0.27,-0.73,-0.16,-0.26,-0.11,-0.76,-0.2,-0.39,-0.08,-0.66,-0.39,-0.32,-0.06,-0.72,-0.03,-0.46,-0.07,0.0,-0.16,-0.27,-0.25,-0.87,-0.23,-0.37,-0.01,-0.84,-0.68,-0.36,-0.08,-0.9,-0.5,-0.52,-0.29,-0.46,-0.28,-0.38,-0.12,-0.94,-0.42,-0.43,0.0,-0.82,-0.18,-0.41,-0.01,-0.68,-0.24,-0.53,-0.06,-0.73,-0.31,-0.44,-0.22,-0.14,-0.52,-0.32,-0.4,-0.22,-0.55,-0.33,-0.71,-0.55,-0.6,-0.13,-0.95,-0.84,-0.62,-0.05,-0.71,-0.75,-0.34,-0.33,-0.58,-0.74,-1.24,-0.91,-0.79,-0.76,-0.77,-0.64,-0.65,-0.54,-0.62,-0.56:EPILEPSY
-0.43,-0.44,-0.47,-0.49,-0.53,-0.53,-0.57,-0.56,-0.51,-0.48,-0.48,-0.5,-0.45,-0.38,-0.28,-0.27,-0.3,-0.32,-0.32,-0.35,-0.33,-0.34,-0.36,-0.4,-0.43,-0.42,-0.44,-0.48,-0.52,-0.56,-0.53,-0.55,-0.6,-0.68,-0.69,-0.7,-0.73,-0.75,-0.77,-0.79,-0.8,-0.82,-0.82,-0.83,-0.85,-0.86,-0.85,-0.87,-0.87,-0.87,-0.87,-0.86,-0.85,-0.86,-0.84,-0.82,-0.81,-0.77,-0.76,-0.76,-0.7,-0.6,-0.56,-0.57,-0.49,-0.47,-0.4,-0.32,-0.17,-0.29,-0.34,-0.12,-0.02,0.02,0.14,0.17,0.26,0.22,0.4,0.38,0.32,0.25,0.34,0.44,0.48,0.47,0.53,0.58,0.56,0.53,0.55,0.58,0.58,0.53,0.52,0.5,0.51,0.51,0.53,0.53,0.53,0.51,0.54,0.57,0.6,0.61,0.67,0.67,0.63,0.65,0.66,0.66,0.64,0.63,0.65,0.65,0.65,0.65,0.65,0.66,0.66,0.64,0.66,0.66,0.66,0.66,0.66,0.65,0.64,0.65,0.61,0.52,0.51,0.5,0.47,0.42,0.39,0.35,0.27,0.18,0.12,0.07,0.03,0.0,0.0,-0.02,-0.02,0.0,0.0,-0.01,0.03,0.07,0.11,0.12,0.14,0.19,0.25,0.37,0.53,0.68,0.7,0.64,0.61,0.6,0.61,0.61,0.62,0.64,0.64,0.63,0.63,0.63,0.64,0.63,0.63,0.63,0.62,0.55,0.51,0.42,0.27,0.12,0.0,-0.09,-0.17,-0.24,-0.31,-0.3,-0.25,-0.19,-0.22,-0.25,-0.31,-0.34,-0.35,-0.17,-0.34,-0.27,-0.34,-0.36,-0.44,-0.35,-0.36,-0.34,-0.31,-0.31:0.78,0.78,0.78,0.78,0.78,0.78,0.76,0.71,0.63,0.77,1.7,1.99,1.63,0.2,-1.13,-1.07,0.97,2.12,0.73,-0.93,0.28,1.89,0.88,-1.1,-0.81,1.84,1.43,0.07,-1.09,-1.12,1.03,1.85,0.04,-1.03,-0.86,1.04,1.72,0.44,-1.14,-0.53,1.96,1.41,-0.42,-1.14,0.22,1.99,0.85,-0.69,-1.24,0.57,1.92,0.38,-0.91,-0.75,1.59,1.35,-0.5,-0.97,0.37,1.78,0.82,-0.72,-0.59,0.97,1.49,0.76,-0.46,-0.8,0.82,1.6,0.33,-0.66,-0.7,1.45,1.61,0.31,-0.7,-0.24,1.84,1.23,-0.37,-0.81,0.8,1.59,0.29,-0.88,-0.86,1.8,1.38,-0.3,-0.85,0.61,1.6,0.7,-0.6,-0.21,1.53,1.18,-0.61,-0.65,0.7,1.68,1.12,-0.53,-0.77,0.28,1.81,0.95,-0.58,-0.86,0.45,1.72,1.07,-0.48,-0.46,0.76,0.15,-0.07,-0.75,0.06,0.94,0.89,-0.73,-0.78,0.66,1.92,0.88,-0.65,-0.97,0.25,1.71,0.77,-0.62,-0.67,0.86,1.23,-0.12,-0.78,0.04,1.76,1.01,-0.44,-0.96,0.6,1.76,-0.27,-0.8,-0.54,1.59,1.24,-0.07,-0.92,-0.35,1.66,0.65,-0.5,-0.98,1.23,1.49,0.12,-0.95,-0.83,2.05,1.46,-0.09,-1.13,-0.24,1.84,1.2,-0.72,-0.75,0.45,1.63,0.55,-0.51,-0.51,1.22,1.25,0.26,-0.83,-0.86,1.43,1.59,0.54,-0.73,-0.92,0.45,1.54,0.25,-0.78,-0.03,1.84,0.9,-0.65,-0.78,1.02,1.26,-0.12,-1.13,-0.69,1.74,1.22,-0.25,-1.18,0.34,1.08:-0.44,-0.18,-0.4,-0.47,-0.53,-0.38,-0.38,-0.61,-0.82,-0.63,-0.27,-0.66,-0.8,-0.73,-0.28,-0.52,-0.56,-0.49,-0.35,-0.05,-0.3,-0.35,-0.72,-0.36,-0.01,-0.43,-0.72,-0.57,-0.5,-0.8,-0.07,-0.13,-0.41,-0.41,-0.7,-0.38,-0.49,-0.38,-0.7,-0.3,0.38,-0.07,-0.5,-0.8,-0.09,-0.01,-0.43,-0.64,-0.59,0.15,0.21,-0.85,-0.87,0.7,0.84,0.01,-0.85,-0.8,0.65,1.35,-0.28,-1.24,-0.38,1.25,0.89,-0.85,-1.35,0.48,0.92,-0.11,-0.71,-0.51,0.35,0.23,-0.57,-0.82,0.65,0.39,-0.36,-0.62,-0.59,-0.11,-0.02,-0.49,-0.75,-0.38,-0.18,-0.38,-0.28,-0.67,-0.1,-0.47,-0.43,-0.55,-0.47,-0.61,-0.5,-0.23,-0.31,-0.29,-0.6,-0.42,-0.31,-0.62,-0.48,-0.54,-0.49,-0.65,-0.45,-0.55,-0.6,-0.29,-0.54,-0.44,-0.54,-0.58,-0.59,-0.55,-0.6,-0.59,-0.72,-0.55,-0.55,-0.54,-0.5,-0.84,-0.38,-0.51,-0.62,-0.43,-0.57,-0.43,-0.58,-0.68,-0.74,-0.57,-0.65,-0.61,-0.72,-0.6,-0.64,-0.7,-0.58,-0.65,-0.67,-0.63,-0.55,-0.7,-0.53,-0.72,-0.5,-0.5,-0.63,-0.53,-0.62,-0.5,-0.6,-0.62,-0.57,-0.09,-0.65,-0.59,-0.46,-0.78,-0.08,-0.55,-0.67,-0.62,-0.7,0.2,-0.25,-0.52,-0.59,-0.54,-0.75,-0.62,-0.34,-0.39,-0.47,-0.52,-0.62,-0.38,-0.67,-0.29,-0.56,-0.49,-0.56,-0.56,-0.38,-0.52,-0.33,-0.71,-0.26,-0.62,-0.7,-0.72,-0.33,-0.38,-0.43,-0.4,-0.71,-0.4,-0.75,-0.6,-0.46,-0.59:EPILEPSY
-0.3,-0.81,-0.55,-0.81,-0.13,-1.1,-0.59,-0.64,-0.25,-1.06,-0.85,-0.45,-0.29,-0.8,-0.79,-0.24,-0.82,-0.78,-0.59,-0.03,-1.2,-0.72,-0.46,-0.46,-0.55,-0.65,-0.09,-0.83,-0.47,-0.38,-0.01,-0.49,-0.5,-0.18,-0.85,-0.8,-0.82,-0.01,-0.94,-0.7,-0.97,0.12,-0.33,-0.25,-0.08,-0.06,-0.39,-0.3,0.08,-0.94,-0.53,-0.47,-0.15,-0.62,-0.58,-0.15,-0.31,-0.62,-0.66,-0.06,-0.68,-0.34,-0.49,0.1,-1.06,-0.5,-0.46,-0.06,-0.45,-0.44,-0.17,-0.5,-0.51,-0.7,-0.1,-1.05,-0.51,-0.66,-0.14,-0.76,-0.6,-0.25,-0.48,-0.23,-0.75,-0.15,-0.83,-0.5,-0.2,-0.3,-0.29,-0.42,-0.14,-0.72,-0.35,-0.27,-0.4,-0.38,-0.66,-0.31,-1.08,-0.57,-0.47,-0.3,-0.36,-0.53,-0.08,-0.6,-0.16,-0.54,0.02,-0.89,-0.4,-0.24,-0.51,-0.68,-0.74,-0.26,-0.58,-0.58,-0.83,-0.28,-1.37,-0.73,-0.62,-0.32,-0.53,-0.59,-0.28,-0.39,-0.52,-0.69,-0.12,-0.81,-0.36,-0.61,-0.02,-1.04,-0.52,-0.4,-0.24,-0.73,-0.69,-0.24,-0.5,-0.46,-0.45,0.0,-0.94,-0.76,-0.3,-0.22,-0.6,-0.7,-0.16,0.05,-0.36,-0.67,-0.11,-0.99,-0.42,-0.48,-0.01,-1.06,-0.82,-0.38,-0.4,-0.77,-0.57,0.1,-0.86,-0.75,-0.54,0.01,-0.37,-0.47,-0.37,-0.4,-0.38,-0.42,-0.56,-0.76,-0.77,-0.75,-0.64,-0.71,-0.7,-0.74,-0.79,-0.82,-0.85,-0.94,-0.97,-0.9,-0.9,-0.7,-0.43,-0.28,-0.37,-0.51,-0.66,-0.78,-0.87,-0.87,-0.81,-0.8:-2.4,0.8,0.18,-2.7,-0.88,0.7,-1.98,-2.33,0.63,0.08,-2.97,-0.86,1.11,-1.72,-2.52,0.32,0.69,-2.52,-1.57,0.81,-1.53,-2.39,0.4,0.39,-2.68,-1.49,0.99,-0.83,-2.94,-0.6,0.34,-2.26,-2.11,0.42,0.24,-2.46,-1.91,0.81,-0.33,-2.86,-0.76,1.0,-1.29,-2.57,0.8,0.04,-2.68,-1.34,0.92,-1.13,-2.54,0.13,0.53,-2.3,-2.12,0.69,0.16,-2.27,-1.71,0.56,-0.12,-2.56,-1.28,0.95,-0.97,-2.4,0.11,0.38,-2.63,-1.59,1.21,-1.18,-2.75,0.37,0.73,-2.88,-1.38,1.26,-0.83,-2.84,0.31,0.47,-2.84,-1.47,1.37,-0.72,-2.9,0.16,0.55,-2.45,-1.79,0.8,-0.77,-2.9,-0.51,1.24,-1.62,-2.73,0.36,0.58,-2.11,-2.28,0.82,0.55,-2.64,-1.76,1.17,-0.29,-2.7,-0.27,1.1,-1.64,-2.57,0.96,-0.08,-2.79,-0.54,0.83,-1.63,-2.52,0.58,-0.11,-2.58,-1.36,1.13,-0.18,-3.11,-1.11,0.93,-0.93,-2.99,-0.85,1.09,-0.22,-2.88,-0.28,0.08,-2.6,-1.17,0.95,-1.05,-2.84,0.35,0.21,-2.56,-1.65,0.86,0.27,-2.92,-1.5,1.09,-0.46,-3.0,-0.66,0.84,-1.58,-2.7,0.12,0.63,-2.29,-1.86,0.86,0.17,-3.07,-1.18,1.19,-0.58,-2.94,-0.43,0.99,-2.12,-2.24,0.99,0.03,-3.04,-0.47,1.21,-2.11,-2.35,0.91,-0.22,-2.8,-0.66,0.75,-1.96,-2.48,0.7,0.85,-2.61,-1.32,1.27,-1.61,-2.55,0.7,0.25,-2.65,-1.4,0.98,-0.58,-2.98,-0.77,1.2,-1.66,-2.36,0.59,0.33:-0.31,-0.26,-0.19,-0.07,0.08,0.23,0.3,0.49,0.48,0.25,0.22,0.28,0.31,0.25,-0.03,-0.12,0.02,0.24,0.41,0.48,0.56,0.77,0.65,0.63,0.48,0.49,0.37,0.28,0.07,-0.09,-0.38,-0.66,-0.63,-0.52,-0.58,-0.51,-0.44,-0.37,-0.39,-0.37,-0.32,-0.3,-0.36,-0.41,-0.36,-0.3,-0.33,-0.37,-0.35,-0.38,-0.34,-0.36,-0.39,-0.41,-0.46,-0.38,-0.35,-0.37,-0.23,-0.13,-0.07,0.04,-0.06,-0.14,-0.15,-0.28,-0.31,-0.34,-0.4,-0.38,-0.41,-0.35,-0.36,-0.29,-0.28,-0.3,-0.42,-0.32,-0.44,-0.51,-0.51,-0.59,-0.49,-0.47,-0.48,-0.4,-0.33,-0.31,-0.3,-0.49,-0.44,-0.45,-0.52,-0.53,-0.53,-0.49,-0.47,-0.45,-0.42,-0.41,-0.39,-0.39,-0.45,-0.4,-0.28,-0.25,-0.19,-0.07,-0.02,-0.09,0.02,-0.05,-0.04,0.01,-0.06,0.07,0.0,0.05,0.1,0.16,0.12,0.12,0.07,0.1,0.16,0.18,0.13,0.09,0.07,0.05,-0.03,0.05,0.12,0.05,0.06,0.17,0.18,0.22,0.36,0.17,0.1,0.18,0.02,-0.11,-0.21,-0.33,-0.31,-0.37,-0.37,-0.42,-0.37,-0.42,-0.4,-0.28,-0.21,-0.33,-0.43,-0.44,-0.39,-0.42,-0.46,-0.46,-0.53,-0.5,-0.62,-0.57,-0.53,-0.48,-0.47,-0.45,-0.36,-0.41,-0.44,-0.53,-0.52,-0.76,-0.76,-0.71,-0.68,-0.65,-0.59,-0.59,-0.61,-0.77,-0.67,-0.59,-0.56,-0.52,-0.48,-0.48,-0.52,-0.52,-0.48,-0.48,-0.4,-0.39,-0.47,-0.41,-0.28,-0.18,-0.14,-0.04,0.0,-0.02,-0.03,-0.02:EPILEPSY
0.47,0.48,0.53,0.53,0.5,0.59,0.66,0.64,0.59,0.54,0.42,0.41,0.66,0.9,0.61,0.47,0.4,0.26,-0.01,0.2,0.49,0.53,0.63,0.38,0.27,0.29,0.31,0.39,0.3,0.33,0.29,0.22,0.34,0.87,1.06,1.52,1.76,0.96,0.77,1.04,1.0,1.02,0.93,0.89,0.9,0.94,0.97,0.94,0.93,0.91,0.92,0.93,0.94,0.93,0.9,0.89,0.93,0.92,0.89,0.93,0.93,0.92,0.92,0.91,0.92,0.92,0.91,0.94,0.95,0.92,0.92,0.93,0.93,0.93,0.92,0.94,0.92,0.92,0.93,0.93,0.93,0.93,0.93,0.93,0.94,0.94,0.92,0.94,0.94,0.95,0.94,1.0,0.94,0.94,0.92,0.98,0.97,1.0,1.05,1.05,0.86,0.89,1.07,0.87,0.84,0.73,0.68,0.87,0.77,0.52,0.49,0.62,0.76,0.66,0.72,0.59,0.65,0.62,0.64,0.61,0.62,0.65,0.61,0.66,0.6,0.64,0.64,0.73,0.71,0.6,0.75,0.69,0.4,0.21,0.0,0.01,0.13,-0.12,-0.13,-0.09,-0.14,-0.1,-0.05,-0.21,-0.16,0.01,-0.11,-0.16,-0.12,-0.06,-0.06,-0.07,-0.06,-0.07,-0.03,-0.06,-0.03,0.02,-0.02,0.11,0.12,0.04,0.01,0.06,0.19,0.13,0.02,0.05,0.04,0.07,0.05,-0.1,-0.18,-0.24,-0.25,-0.25,-0.29,-0.26,-0.32,-0.26,-0.13,-0.06,-0.17,-0.2,-0.46,-0.36,-0.56,-0.59,-0.37,-0.25,-0.27,-0.21,-0.36,-0.7,-0.85,-0.88,-0.81,-0.7,-0.66,-0.66,-0.68,-0.66,-0.62,-0.57,-0.53,-0.5:-0.8,0.8,0.4,-1.41,-1.82,-0.26,0.91,-1.18,-2.24,-0.78,0.82,1.05,-0.72,-2.42,-0.62,1.0,-0.51,-2.1,-1.36,0.43,1.13,-0.9,-2.24,-0.81,0.88,0.58,-1.53,-1.77,-0.22,0.97,-0.11,-2.35,-1.57,0.26,1.19,-1.09,-2.33,-1.0,0.62,0.85,-1.16,-1.84,-0.28,1.05,-0.52,-2.34,-1.28,0.56,1.14,-0.97,-2.04,-0.36,1.06,-0.32,-2.23,-1.39,0.06,1.26,-0.8,-2.33,-1.13,0.53,0.87,-0.94,-2.03,-0.77,0.9,0.18,-2.05,-1.61,-0.34,1.04,-0.33,-2.33,-1.45,0.47,1.1,-1.02,-2.33,-1.1,0.72,1.11,-1.38,-1.94,-0.39,1.02,0.18,-2.25,-1.65,0.14,1.19,-0.78,-2.36,-1.19,0.44,0.99,-1.0,-2.07,-0.67,0.83,-0.09,-2.04,-1.35,0.12,0.69,0.31,0.24,-1.06,-0.77,-0.24,-0.46,-1.0,-0.87,-0.4,-0.38,-0.5,-0.59,-0.56,-0.5,-0.53,-0.55,-0.53,-0.52,-0.53,-0.52,-0.53,-0.52,-0.53,-0.53,-0.53,-0.51,-0.55,-0.54,-0.54,-0.54,-0.53,-0.53,-0.57,-0.5,-0.51,-0.49,-0.48,-0.48,-0.5,-0.51,-0.46,-0.41,-0.68,-0.67,-0.55,-0.62,-0.65,-0.65,-0.59,-0.59,-0.66,-0.62,-0.56,-0.56,-0.75,-0.68,-0.78,-0.91,-0.92,-1.05,-0.7,-0.69,-0.48,-0.43,-0.57,-0.59,-0.55,-0.64,-0.79,-0.87,-0.59,-0.48,-0.47,-0.53,-0.76,-0.66,-1.32,-0.93,-0.9,-0.89,-0.62,-0.8,-0.82,-0.65,-0.95,-0.8,-0.48,-0.47,-0.25,0.09,-0.23,-0.83,-0.55,-0.75,-0.99,-0.75,-0.58,-0.49,-0.27,-0.08,-0.18:0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.16,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.18,0.1,0.12,-0.03,0.86,0.07,-0.05,0.15,0.03,0.04,0.16,0.55,-0.03,-0.94,-0.84,0.57,0.37,-0.14,-0.85,-0.68,0.6,0.52,-0.02,-0.52,-0.77,-0.49,0.38,0.44,-0.01,-0.64,-0.92,-0.09,0.59,0.37,-0.52,-0.89,-0.04,0.43,0.43,-0.11,-0.33,0.34,0.96,0.32,-0.5,-0.68,0.7,0.89,0.06,-0.54,-0.03,0.97,0.37,-0.17,-0.67,1.05,0.71,-0.05,-0.46,0.32,1.33,0.43,-0.17,-0.48,1.05,0.64,0.04,-0.66,0.8,0.66,0.04,-0.47,-0.15,1.06,0.58,-0.19,-0.53,-0.31,0.92,0.26,0.04,-0.52,-0.35,1.11,0.55,0.18,-0.04,-0.51,1.18,0.53,0.06,-0.51,-0.47,0.72,0.29,-0.21,-0.35,0.71,0.98,0.15,-0.17,-0.37,0.9,0.61,-0.01,-0.35,-0.39,1.24,0.88,0.11,-0.19,-0.56,0.93,0.53,-0.11,-0.25,-0.31,1.2,0.58,-0.04,-0.35,-0.31,1.29,0.29,-0.27,-0.63,0.06,0.93,0.13,-0.22,-0.59,0.6,0.67,0.2,-0.33,-0.34,0.01,0.99,0.18,-0.2,-0.49,0.4,1.04,0.04,-0.25,-0.5,1.42,0.91,0.12,-0.42,-0.23,1.07,0.63,0.19,-0.6,0.23,1.34,0.43,-0.1,-0.55,1.13,1.17,0.18,-0.16,-0.45,1.0,1.05:EPILEPSY
0.87,0.88,0.87,0.93,0.93,0.93,0.93,0.96,0.93,0.95,0.93,0.94,0.93,0.92,0.95,0.93,0.96,0.9,0.9,0.97,0.94,0.92,0.92,0.91,0.95,0.96,0.92,0.92,0.95,0.97,0.97,0.95,0.93,0.94,0.95,0.96,0.94,0.92,0.94,0.95,0.95,0.94,0.93,0.93,0.94,0.95,0.98,0.98,0.98,0.94,0.91,0.94,0.96,0.96,0.96,0.94,0.96,0.95,0.94,0.95,1.02,1.0,0.88,0.82,0.77,0.65,0.48,0.34,0.21,0.19,0.14,0.01,0.02,-0.02,-0.1,-0.17,-0.22,-0.25,-0.24,-0.22,-0.21,-0.2,-0.22,-0.31,-0.33,-0.32,-0.26,-0.22,-0.09,-0.19,-0.14,-0.18,0.01,0.11,0.06,0.02,0.16,0.12,-0.04,0.04,0.0,-0.06,-0.06,0.01,-0.03,-0.12,-0.13,-0.16,-0.13,-0.22,-0.22,-0.19,-0.02,0.16,0.41,0.91,0.65,0.56,0.54,0.52,0.49,0.52,0.55,0.57,0.53,0.47,0.46,0.49,0.52,0.51,0.51,0.49,0.53,0.5,0.51,0.52,0.55,0.55,0.54,0.51,0.57,0.61,0.59,0.6,0.56,0.49,0.53,0.63,0.65,0.66,0.72,0.7,0.64,0.56,0.46,0.43,0.33,0.27,0.19,0.32,0.39,0.29,0.37,0.29,0.3,0.29,0.33,0.4,0.42,0.31,0.37,0.44,0.42,0.49,0.42,0.33,0.26,0.24,0.2,0.26,0.25,0.22,0.29,0.21,0.1,0.17,0.2,0.26,0.25,0.35,0.38,0.37,0.38,0.41,0.43,0.4,0.42,0.4,0.41,0.4,0.4,0.36,0.33,0.33,0.33,0.22:-0.83,-0.78,-0.65,-0.68,-0.71,-0.7,-0.75,-0.55,-0.68,-0.78,-0.82,-0.68,-0.49,-0.57,-0.7,-0.63,-0.63,-0.57,-0.52,-0.66,-0.71,-0.64,-0.51,-0.49,-0.56,-0.84,-1.09,-0.88,-0.88,-0.76,-0.71,-0.9,-0.82,-0.9,-0.96,-0.72,-0.8,-0.78,-0.85,-1.34,-1.1,-0.87,-1.18,-1.24,-0.53,-0.66,-1.02,-1.35,-0.91,-1.02,-0.82,-0.7,-0.71,-0.93,-0.84,-0.56,-0.91,-1.22,-1.08,-0.91,-1.17,-1.12,-0.9,-0.86,-0.62,-0.58,-0.66,-0.79,-0.58,-0.72,-0.59,-0.08,-0.29,-0.96,-0.75,-0.78,0.21,-0.44,-1.25,-0.59,-0.18,-0.13,-0.07,-0.12,-0.19,-0.28,-0.37,-0.32,-0.38,-0.4,-0.38,-0.34,-0.43,-0.25,-0.24,-0.29,-0.32,-0.27,-0.32,-0.32,-0.31,-0.31,-0.3,-0.37,-0.43,-0.32,-0.29,-0.3,-0.34,-0.39,-0.35,-0.36,-0.38,-0.22,-0.33,-0.34,-0.33,-0.29,-0.27,-0.27,-0.3,-0.32,-0.36,-0.36,-0.33,-0.33,-0.32,-0.34,-0.39,-0.34,-0.28,-0.24,-0.25,-0.27,-0.28,-0.28,-0.28,-0.28,-0.28,-0.27,-0.32,-0.32,-0.35,-0.34,-0.34,-0.37,-0.32,-0.33,-0.46,-0.59,-0.65,-0.58,-0.52,-0.48,-0.63,-0.83,-0.95,-0.87,-0.82,-0.88,-0.91,-0.82,-0.96,-1.12,-0.95,-1.0,-0.94,-0.84,-0.78,-0.71,-0.72,-0.78,-0.76,-0.68,-0.69,-0.75,-0.67,-0.78,-0.67,-0.67,-0.4,-0.45,-0.4,-0.48,-0.37,-0.49,-0.46,-0.43,-0.52,-0.34,-0.38,-0.45,-0.5,-0.61,-0.56,-0.5,-0.43,-0.43,-0.51,-0.41,-0.32,-0.29,-0.4,-0.89,-1.47,-0.61:0.01,0.75,0.27,-0.31,-0.18,-0.49,0.75,0.39,-0.25,-0.25,-0.44,0.79,0.57,-0.24,-0.17,-0.49,0.9,0.51,-0.24,-0.19,-0.4,1.11,0.61,-0.33,-0.14,-0.37,0.9,0.27,-0.33,-0.25,-0.35,0.85,0.32,-0.28,-0.16,-0.3,0.56,0.1,-0.29,-0.28,-0.12,0.52,-0.08,-0.37,-0.57,0.23,0.42,-0.18,-0.26,-0.65,0.57,0.1,-0.37,-0.43,-0.15,0.37,-0.1,-0.5,-0.63,0.65,0.19,0.11,-0.27,-0.43,0.57,0.37,-0.02,-0.31,-0.53,0.73,0.33,-0.12,-0.25,-0.36,1.04,0.51,-0.48,-0.61,1.38,0.99,0.14,-0.09,-0.49,0.69,0.52,-0.19,-0.39,0.02,0.51,0.07,-0.26,-0.69,0.47,0.55,-0.05,-0.34,-0.6,0.18,0.04,-0.2,-0.22,-0.49,0.35,0.04,-0.28,-0.45,-0.29,0.48,0.15,-0.34,-0.19,-0.2,0.37,0.04,-0.32,-0.19,-0.37,0.8,0.14,-0.36,-0.23,-0.35,0.91,0.3,-0.4,-0.12,-0.2,0.72,-0.05,-0.31,-0.39,-0.21,0.54,0.03,-0.34,-0.25,0.05,0.32,-0.04,-0.23,-0.46,0.69,0.32,-0.31,-0.08,-0.41,0.73,0.16,-0.31,-0.11,-0.39,0.83,0.18,-0.22,-0.23,-0.47,0.7,0.28,-0.2,-0.3,-0.53,0.4,0.03,-0.33,-0.34,-0.27,0.21,0.26,-0.13,-0.4,-0.47,0.77,0.43,-0.09,-0.44,-0.46,0.52,0.33,-0.19,-0.25,-0.38,0.75,0.33,-0.27,-0.13,-0.25,0.57,0.15,-0.04,-0.09,-0.3,0.71,0.29,-0.15,-0.25,0.0,0.41,0.16,-0.24,-0.47,0.31,0.07,-0.16,-0.22,-0.27,0.94:EPILEPSY
1.0,0.82,0.7,0.31,0.38,0.81,1.08,1.05,0.91,0.65,0.42,-0.16,-0.3,-0.04,0.42,0.84,0.91,0.73,0.78,0.71,0.54,0.47,0.59,0.75,0.82,0.81,0.83,0.82,0.81,0.79,0.83,0.68,0.64,0.57,0.46,0.33,0.19,0.06,-0.01,-0.02,-0.09,-0.11,-0.11,0.01,0.09,0.09,0.12,0.1,0.04,0.07,0.15,0.23,0.42,0.64,0.7,0.78,0.86,0.9,0.91,0.91,0.92,0.92,0.9,0.87,0.83,0.83,0.82,0.79,0.77,0.75,0.72,0.61,0.68,0.64,0.65,0.64,0.76,0.71,0.69,0.74,0.75,0.74,0.73,0.73,0.73,0.72,0.72,0.68,0.7,0.73,0.77,0.77,0.75,0.75,0.74,0.74,0.74,0.74,0.73,0.74,0.73,0.67,0.64,0.61,0.58,0.57,0.56,0.55,0.53,0.52,0.49,0.49,0.5,0.51,0.54,0.58,0.61,0.64,0.67,0.71,0.76,0.81,0.85,0.86,0.86,0.85,0.84,0.84,0.81,0.8,0.78,0.75,0.69,0.67,0.64,0.67,0.69,0.69,0.71,0.71,0.71,0.71,0.72,0.72,0.71,0.71,0.73,0.69,0.65,0.63,0.59,0.54,0.5,0.48,0.48,0.47,0.48,0.54,0.55,0.57,0.58,0.6,0.61,0.62,0.62,0.64,0.65,0.68,0.66,0.68,0.67,0.68,0.68,0.66,0.68,0.63,0.6,0.56,0.53,0.49,0.46,0.44,0.44,0.44,0.46,0.5,0.55,0.57,0.61,0.64,0.66,0.69,0.7,0.73,0.73,0.73,0.75,0.77,0.76,0.74,0.75,0.72,0.7,0.69,0.68,0.68:0.17,0.22,0.2,0.17,0.05,-0.11,-0.31,-0.4,-0.31,-0.17,-0.01,0.12,0.17,0.14,0.12,0.05,-0.03,-0.17,-0.32,-0.34,-0.24,-0.08,0.09,0.14,0.1,0.11,0.17,0.11,0.0,-0.35,-0.51,-0.44,0.08,-0.4,-0.55,-0.08,-0.29,-0.3,-0.86,-1.04,-0.42,0.59,0.11,-0.44,-1.51,-0.55,0.74,0.52,-2.79,-1.44,0.67,0.97,-2.5,-1.54,0.72,1.27,-2.29,-1.61,0.6,1.39,-1.57,-2.2,-0.13,1.46,-0.63,-2.1,-0.23,0.81,-0.45,-3.0,-1.34,0.8,0.74,-2.58,-0.95,0.06,1.01,-1.95,-1.52,-0.14,1.0,-1.1,-1.48,-0.66,0.56,-0.49,-2.2,-0.83,0.56,0.55,-2.27,-0.92,-0.14,1.11,-0.74,-1.77,-0.31,1.1,-1.09,-1.67,0.13,1.11,-1.07,-1.96,-0.38,0.69,-0.07,-2.14,-0.65,0.62,0.85,-1.41,-0.72,0.01,0.92,-1.08,-0.79,-0.55,0.66,-0.01,-2.26,-0.76,0.62,1.08,-1.23,-1.62,0.42,1.24,-1.22,-1.69,-0.27,0.88,0.01,-2.23,-1.13,0.68,1.19,-1.38,-1.82,0.04,1.44,-1.36,-1.46,-0.6,0.43,0.07,-2.37,-1.12,0.62,0.85,-2.52,-0.85,0.25,0.92,-1.7,-0.83,0.14,0.99,-1.46,-1.34,0.11,1.0,-1.34,-1.66,-0.35,0.74,-0.93,-2.22,-0.99,0.77,1.05,-1.32,-1.6,0.32,1.23,-1.46,-1.72,-0.32,0.9,-0.48,-1.99,-0.97,0.76,1.13,-1.59,-1.13,0.25,1.22,-1.24,-1.86,-0.37,0.91,-0.43,-2.05,-0.88,0.62,1.04,-1.48,-1.39,0.18,1.41,-1.06,-2.05,-0.62,0.79,0.55:-0.09,-0.04,-0.03,0.01,0.05,0.02,0.05,0.04,-0.01,-0.08,-0.16,-0.11,-0.15,-0.22,-0.15,-0.06,-0.19,-0.33,-0.33,-0.33,-0.22,0.13,-0.14,-0.13,-0.02,0.01,-0.02,-0.07,-0.12,-0.06,-0.09,-0.12,-0.21,-0.14,-0.03,0.03,0.3,0.54,0.57,0.58,0.61,0.7,0.71,0.71,0.71,0.68,0.51,0.68,0.87,0.91,0.89,0.85,0.79,0.79,0.86,0.93,0.95,0.94,0.91,0.86,0.85,0.82,0.79,0.71,0.57,0.42,0.3,0.15,0.05,-0.05,-0.08,-0.11,-0.04,-0.11,-0.07,0.01,-0.03,-0.07,-0.29,-0.31,-0.06,0.17,0.37,0.52,0.62,0.69,0.71,0.72,0.75,0.58,0.71,0.76,0.67,0.6,0.71,0.81,0.82,0.88,0.98,1.0,0.9,0.8,0.86,0.83,0.8,0.76,0.81,0.86,0.85,0.81,0.72,0.72,0.72,0.74,0.76,0.69,0.73,0.74,0.76,0.78,0.62,0.67,0.81,0.88,0.85,0.85,0.98,0.99,0.92,0.87,0.88,0.87,0.83,0.79,0.73,0.71,0.7,0.72,0.71,0.66,0.61,0.62,0.64,0.64,0.71,0.68,0.64,0.68,0.71,0.74,0.71,0.65,0.61,0.51,0.42,0.29,0.17,0.07,-0.01,-0.13,-0.23,-0.27,-0.27,-0.27,-0.23,-0.21,-0.22,-0.16,-0.12,-0.12,-0.1,-0.07,-0.05,-0.03,-0.02,-0.02,-0.03,-0.05,-0.09,-0.07,-0.12,-0.1,-0.1,-0.12,-0.15,-0.18,-0.24,-0.23,-0.23,-0.22,-0.05,0.09,0.24,0.36,0.46,0.54,0.57,0.6,0.62,0.66,0.7,0.67,0.67,0.67,0.64,0.52:EPILEPSY
-0.67,-0.66,-0.59,-0.67,-0.6,-0.41,-0.48,-0.24,0.18,0.34,0.42,0.56,0.7,0.63,0.63,0.62,0.59,0.6,0.65,0.49,0.4,0.2,0.24,0.44,0.65,0.7,0.85,0.99,0.99,1.05,0.96,0.93,0.87,0.9,0.84,0.8,0.78,0.85,0.99,1.13,1.13,1.08,1.1,0.98,0.9,0.93,0.88,0.78,0.88,1.0,1.05,1.1,1.1,1.04,1.04,1.0,0.97,0.91,0.93,0.88,0.77,0.76,0.8,0.86,1.08,1.17,1.07,0.95,0.86,0.85,0.77,0.7,0.71,0.79,0.95,1.04,1.04,1.07,1.05,1.05,0.94,0.97,1.02,0.98,0.77,0.78,0.93,1.0,1.12,1.1,1.09,0.99,0.85,0.76,0.7,0.76,0.68,0.8,0.88,0.9,0.83,0.57,0.44,0.52,0.26,-0.2,-0.74,-0.97,-0.54,-0.64,-0.65,-0.85,-1.01,-1.23,-1.16,-1.08,-0.95,-0.77,-0.64,-0.52,-0.39,-0.28,-0.5,-0.68,-0.7,-0.66,-0.66,-0.6,-0.68,-0.73,-0.77,-0.87,-0.99,-1.13,-1.07,-1.01,-0.92,-0.86,-0.76,-0.65,-0.58,-0.52,-0.43,-0.27,-0.35,-0.56,-0.62,-0.61,-0.58,-0.71,-0.81,-0.91,-0.97,-1.04,-1.05,-0.97,-0.93,-0.87,-0.76,-0.68,-0.61,-0.48,-0.31,-0.19,-0.37,-0.58,-0.58,-0.52,-1.01,-1.63,-1.42,-0.85,-0.48,-0.2,-0.01,-0.01,-0.13,-0.15,-0.1,-0.1,-0.03,-0.08,-0.15,-0.06,-0.01,-0.05,0.02,0.02,0.04,0.05,0.05,0.06,0.07,0.11,0.15,0.18,0.15,0.15,-0.01,0.1,-0.01,0.02,0.0,0.12,0.06,0.07:-2.99,0.5,0.89,-2.56,-1.82,1.07,0.02,-3.02,-0.86,1.39,-1.54,-2.6,0.65,0.4,-2.95,-1.36,1.67,-0.2,-3.25,-1.09,1.66,-0.58,-3.02,-0.21,1.5,-1.91,-2.37,0.68,0.62,-2.63,-1.61,1.1,-1.08,-2.66,-0.03,0.87,-2.25,-2.35,0.93,0.05,-3.07,-0.91,1.11,-0.76,-2.98,-0.18,0.73,-2.23,-1.91,1.19,0.68,-2.82,-1.38,1.26,-0.81,-2.93,-0.13,0.99,-1.99,-2.79,0.6,0.62,-2.88,-1.38,0.95,-1.26,-2.76,-0.2,1.19,-2.38,-2.13,1.23,-0.07,-3.03,-1.16,1.44,-0.82,-3.1,-0.52,1.01,-1.52,-2.54,0.4,1.18,-1.98,-2.66,0.57,0.21,-2.6,-1.72,0.78,0.36,-2.94,-1.67,1.12,-0.05,-2.95,-0.96,0.78,-1.1,-2.75,-0.72,1.01,-0.93,-2.99,-0.78,1.22,-1.66,-2.33,0.32,0.69,-1.97,-3.1,-0.46,1.73,-0.01,-3.14,-0.59,1.29,-1.95,-2.21,0.87,-0.08,-2.71,-0.62,1.01,-1.55,-2.33,-0.06,0.09,-0.32,-1.05,-0.62,-0.48,-0.72,-0.46,-0.63,-0.64,-0.64,-0.6,-0.56,-0.61,-0.59,-0.56,-0.56,-0.6,-0.58,-0.56,-0.62,-0.65,-0.64,-0.63,-0.66,-0.8,-0.71,-0.63,-0.65,-0.66,-0.54,-0.59,-0.59,-0.57,-0.7,-0.6,-0.56,-0.51,-0.67,-0.5,-0.34,-0.49,-0.6,-0.73,-0.47,-0.54,-0.36,-0.38,-0.51,-0.29,-0.2,-0.38,-0.55,-0.62,-0.62,-0.67,-0.62,-0.65,-0.65,-0.67,-0.64,-0.73,-0.75,-0.6,-0.59,-0.54,-0.6,-0.55,-0.52,-0.51,-0.47,-0.26,-0.51,-0.45,-0.44,-0.56,-0.76,-0.82:0.43,0.48,0.33,-0.22,0.62,1.18,0.65,-0.26,0.5,0.62,-0.05,-0.02,0.97,0.27,-0.37,0.24,0.52,0.4,0.12,0.81,0.26,0.34,-0.33,-0.63,-0.84,-0.78,-0.63,-0.65,-0.63,-0.62,-0.56,-0.46,-0.34,-0.33,-0.32,-0.21,0.07,0.11,0.0,0.04,-0.12,-0.32,-0.47,-0.71,-0.62,-0.54,-0.47,-0.4,-0.35,-0.31,-0.16,-0.07,-0.01,0.14,0.25,0.35,0.46,0.52,0.47,0.53,0.54,0.58,0.7,0.62,0.65,0.61,0.66,0.73,0.53,0.35,0.23,0.07,0.06,-0.11,-0.14,-0.14,-0.26,-0.28,-0.45,-0.68,-0.57,-0.59,-0.44,-0.42,-0.3,-0.26,-0.22,-0.24,-0.16,-0.01,-0.08,-0.21,-0.27,-0.34,-0.41,-0.37,-0.36,-0.27,-0.14,-0.13,-0.13,0.22,0.71,0.56,0.38,0.36,0.4,0.4,0.36,0.3,0.12,0.1,0.0,-0.11,-0.14,-0.13,-0.19,-0.22,-0.16,-0.21,-0.49,-0.61,-0.7,-0.67,-0.54,-0.32,-0.23,-0.41,-0.52,-0.56,-0.39,-0.29,-0.21,-0.07,0.0,0.03,0.0,0.07,-0.02,0.13,0.08,0.11,0.03,0.14,0.08,0.13,0.07,0.06,0.14,0.12,0.02,0.07,-0.02,-0.17,-0.15,-0.18,-0.29,-0.34,-0.36,-0.4,-0.39,-0.4,-0.43,-0.44,-0.38,-0.34,-0.28,-0.42,-0.61,-0.47,-0.59,-0.5,-0.6,-0.73,-0.68,-0.61,-0.59,-0.62,-0.63,-0.55,-0.52,-0.51,-0.47,-0.53,-0.59,-0.61,-0.49,-0.5,-0.48,-0.5,-0.5,-0.38,-0.46,-0.41,-0.32,-0.23,-0.14,-0.25,-0.29,-0.19,-0.11,-0.08,-0.1,-0.1,-0.04,-0.01:EPILEPSY
0.18,0.18,0.18,0.18,0.19,0.19,0.18,0.18,0.19,0.19,0.19,0.18,0.18,0.18,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.19,0.19,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.17,0.16,0.23,0.19,0.27,0.39,0.46,0.56,0.64,0.64,0.66,0.62,0.62,0.65,0.71,0.72,0.7,0.69,0.7,0.73,0.68,0.66,0.63,0.6,0.56,0.55,0.52,0.48,0.48,0.51,0.51,0.52,0.52,0.54,0.54,0.53,0.53,0.51,0.52,0.54,0.52,0.52,0.56,0.55,0.53,0.53,0.52,0.54,0.52,0.53,0.56,0.56,0.55,0.54,0.52,0.54,0.53,0.52,0.54,0.56,0.56,0.55,0.54,0.54,0.54,0.56,0.54,0.54,0.56,0.56,0.55,0.53,0.55,0.54,0.54,0.54,0.5,0.48,0.61,0.54,0.47,1.04,1.18,1.19,1.01,0.68,0.43,0.44,0.69,0.57,0.57,0.67,-0.2,0.27,1.8,0.26,-1.13,-0.53,0.66,-0.09,-1.52,-1.08,-0.29,-0.03,-1.64,-1.16,-0.09,0.39,-1.48,-0.92,0.87,0.82,-0.84,-0.71,0.35,0.82,-0.28,-0.48,0.19,0.75,0.08,-0.5,0.04,0.79,0.55,-0.25,-0.16,1.36,0.86,-0.12,-0.16,1.25,0.97,0.15,-0.01,0.61,1.0,0.42,0.2,0.13,1.32,0.81,0.26,-0.01,0.62,0.8,0.36,0.21,0.45,0.79,0.53,0.28,0.41,1.05,0.63:-0.38,1.08,0.4,-2.17,-0.91,0.67,0.9,-1.62,-1.19,0.93,1.66,-0.81,-2.36,-0.44,1.69,0.53,-2.57,-0.95,0.92,1.3,-1.62,-1.41,0.68,1.65,-1.19,-1.97,-0.32,1.35,0.53,-2.16,-1.13,0.75,1.41,-1.36,-2.13,-0.28,1.59,0.25,-2.48,-0.9,0.88,1.2,-1.8,-1.47,0.89,1.69,-1.28,-1.91,-0.16,1.71,0.34,-2.13,-1.0,0.74,1.38,-1.47,-1.75,0.25,1.69,-0.53,-2.28,-0.71,0.81,0.95,-1.7,-1.38,0.61,1.73,-0.54,-2.28,-0.79,0.78,1.21,-1.44,-1.45,0.2,1.47,0.11,-2.14,-0.89,0.76,1.32,-1.34,-1.63,-0.13,1.45,0.55,-1.88,-1.13,0.87,1.55,-0.86,-2.17,-0.7,0.87,1.12,-1.77,-1.4,0.02,1.58,0.06,-2.15,-0.97,0.78,1.5,-1.21,-1.82,-0.32,1.32,0.68,-1.66,-1.19,0.66,1.87,-1.12,-2.1,-0.63,1.14,1.14,-1.97,-1.45,0.71,1.69,-1.45,-1.65,-0.55,1.04,0.77,-2.22,-1.11,0.83,1.48,-1.94,-0.55,-0.02,0.39,0.18,-1.71,-0.43,0.75,0.61,-1.77,-1.0,0.53,1.0,-1.05,-0.82,0.16,1.12,-0.91,-1.77,-0.73,0.95,1.26,-1.04,-1.54,0.19,1.52,-0.39,-1.89,-0.77,0.82,1.38,-1.16,-1.37,0.36,1.63,-0.72,-1.47,-0.95,0.7,0.78,-1.1,-1.26,0.4,1.39,-0.34,-2.03,-0.85,0.8,1.41,-1.06,-1.71,-0.1,1.47,-0.44,-2.1,-0.77,0.69,1.06,-1.37,-1.33,0.58,1.6,-0.88,-1.96,-0.73,0.69,1.01,-1.34,-1.41,0.71,1.5,-1.35,-1.66,-0.44:0.48,0.51,0.47,0.42,0.32,0.35,0.49,0.62,0.71,0.73,0.73,0.81,0.85,0.89,0.92,0.93,0.97,0.92,0.93,0.9,0.97,1.06,1.11,1.09,1.0,0.96,0.9,0.85,0.81,0.77,0.69,0.69,0.64,0.58,0.61,0.67,0.62,0.65,0.7,0.74,0.72,0.75,0.72,0.59,0.48,0.39,0.37,0.28,0.15,-0.01,-0.11,-0.12,-0.16,-0.12,-0.08,-0.08,-0.06,-0.02,-0.03,0.0,0.01,0.07,0.19,0.28,0.4,0.6,0.66,0.71,0.74,0.64,0.54,0.36,0.19,0.1,0.06,0.06,0.06,0.07,0.07,0.07,0.1,0.1,0.09,0.05,0.05,0.06,0.06,0.0,-0.08,-0.19,-0.13,-0.01,0.04,0.22,0.4,0.51,0.55,0.55,0.55,0.6,0.64,0.67,0.66,0.69,0.56,0.83,0.99,1.02,1.01,0.97,0.89,0.8,0.73,0.71,0.67,0.59,0.48,0.37,0.29,0.3,0.14,0.05,0.0,-0.07,-0.04,-0.01,-0.1,-0.13,-0.18,-0.25,-0.34,-0.34,-0.3,-0.17,-0.07,-0.03,-0.04,0.01,0.04,0.07,0.11,0.14,0.15,0.17,0.23,0.29,0.24,0.17,0.1,0.04,-0.05,-0.01,-0.04,-0.12,-0.19,-0.26,-0.15,-0.08,-0.17,-0.23,-0.27,-0.21,-0.11,-0.08,-0.05,-0.21,-0.08,-0.04,-0.12,-0.18,-0.25,-0.28,-0.11,-0.02,-0.02,0.05,0.18,0.46,0.65,0.67,0.72,0.78,0.77,0.58,0.7,0.83,0.93,0.98,0.97,0.95,0.97,1.0,1.02,1.02,0.97,0.87,0.79,0.66,0.55,0.41,0.27,0.12,0.03,0.0,-0.07,-0.12:EPILEPSY
0.74,0.58,0.67,0.58,0.49,0.73,0.89,0.74,0.81,0.56,0.58,0.85,0.72,0.65,0.56,0.26,0.58,0.63,0.55,0.74,0.51,0.55,0.78,0.63,0.71,0.54,0.53,0.77,0.82,0.82,0.51,0.41,0.82,0.69,0.57,0.52,0.39,0.7,0.68,0.72,0.6,0.65,0.79,0.78,0.68,0.73,0.55,0.43,0.65,0.68,0.62,0.55,0.47,0.74,0.87,0.72,0.66,0.7,0.67,0.68,0.71,0.57,0.57,0.67,0.75,0.62,0.6,0.51,0.77,0.86,0.75,0.62,0.64,0.82,0.79,0.75,0.55,0.44,0.84,0.83,0.64,0.74,0.64,0.65,0.93,1.0,0.78,0.66,0.72,0.88,0.87,0.69,0.65,0.58,0.74,0.58,0.48,0.32,0.59,0.55,0.66,0.59,0.59,0.49,0.51,0.69,0.65,0.59,0.45,0.41,0.66,0.51,0.41,0.32,0.5,0.48,0.64,0.6,0.65,0.64,0.63,0.74,0.69,0.73,0.68,0.59,0.5,0.63,0.83,0.7,0.7,0.66,0.69,0.86,0.82,0.71,0.65,0.58,0.59,0.8,0.79,0.68,0.61,0.62,0.78,0.68,0.84,0.72,0.84,0.79,0.89,0.66,0.65,0.84,0.87,0.7,0.69,0.68,0.49,0.81,0.64,0.65,0.74,0.59,0.64,0.84,0.83,0.72,0.66,0.63,0.73,0.83,0.71,0.73,0.63,0.46,0.56,0.82,0.69,0.64,0.58,0.55,0.41,0.84,0.67,0.7,0.63,0.64,0.84,0.8,0.64,0.58,0.5,0.7,0.75,0.74,0.74,0.65,0.57,0.6,0.79,0.88,0.82,0.68,1.0,0.77:-0.57,-0.44,-0.44,-0.5,-0.39,-0.42,-0.41,-0.38,-0.09,-0.81,-0.68,-0.42,-0.58,-0.71,-0.62,-0.57,-0.85,-1.64,-1.23,-0.75,-0.79,-1.04,-0.93,-0.79,-0.56,-0.38,-0.27,-0.28,-0.37,-0.34,-0.32,-0.39,-0.44,-0.33,0.07,-0.02,-0.82,-1.71,-1.37,-0.93,-0.66,-0.65,-0.73,-0.75,-0.9,-0.75,-0.6,-0.49,-0.49,-0.52,-0.5,-0.46,-0.56,-0.6,-0.83,-0.92,-0.71,-0.71,-0.65,-0.52,-0.48,-0.84,-0.66,-0.54,-0.81,-0.86,-0.67,-0.62,-0.56,-0.29,-0.27,-1.23,-0.89,-0.68,-1.24,-0.87,-0.6,-1.04,-1.01,-0.71,-0.8,-0.91,-0.59,-0.56,-0.75,-0.66,-0.59,-0.57,-0.52,-0.54,-0.61,-0.71,-0.67,-0.71,-0.61,-0.68,-0.68,-0.69,-0.77,-0.61,-0.71,-0.63,-0.58,-0.64,-0.65,-0.65,-0.67,-0.48,-0.33,-0.21,-0.15,0.1,0.08,0.07,0.04,-0.22,-0.46,-0.75,-1.01,-1.4,-0.93,-0.68,-0.7,-0.7,-0.64,-0.56,-0.6,-0.4,-0.3,-0.18,-0.18,-0.02,-0.33,-0.34,-0.27,-0.29,-0.35,-0.41,-0.47,-0.52,-0.52,-0.5,-0.45,-0.39,-0.37,-0.36,-0.35,-0.34,-0.33,-0.34,-0.35,-0.36,-0.37,-0.39,-0.39,-0.4,-0.41,-0.4,-0.39,-0.38,-0.37,-0.36,-0.36,-0.35,-0.33,-0.3,-0.42,-0.51,-0.57,-0.55,-0.64,-0.64,-0.66,-0.67,-0.65,-0.62,-0.57,-0.5,-0.44,-0.37,-0.31,-0.27,-0.29,-0.29,-0.28,-0.25,-0.22,-0.15,-0.16,-0.14,-0.07,0.14,0.5,0.65,0.49,0.6,0.71,0.71,0.78,0.8,0.83,0.86,0.87,0.89,0.84,0.91:-0.4,-0.28,-0.79,-0.08,-0.15,0.2,0.05,-0.19,-0.49,-0.38,-0.15,-0.24,-0.32,-0.34,-0.39,-0.34,-0.41,-0.39,-0.47,-0.49,-0.73,-0.75,-0.8,-0.48,-0.5,-0.31,-0.59,-0.7,-0.74,-0.7,-0.74,-0.67,-0.63,-0.6,-0.6,-0.65,-0.93,-0.42,-0.34,-0.28,-0.68,-0.67,-0.69,-0.96,-0.67,-0.4,-0.37,-0.5,-0.73,-0.76,-0.52,-0.54,-0.63,-0.6,-0.57,-0.59,-0.57,-0.62,-0.61,-0.51,-0.46,-0.35,-0.43,-0.36,-0.35,-0.5,-0.41,-0.45,-0.49,-0.55,-0.56,-0.47,-0.39,-0.44,-0.41,-0.43,-0.4,-0.7,-0.61,-0.48,-0.24,-0.19,-0.26,0.1,0.19,-0.21,-0.98,-1.36,-0.4,-0.05,-0.02,0.07,0.21,0.1,-0.19,-0.31,-0.41,-0.61,-0.5,-0.44,-0.45,-0.36,-0.26,-0.17,-0.14,-0.14,-0.2,-0.29,-0.33,-0.34,-0.34,-0.32,-0.31,-0.3,-0.31,-0.32,-0.34,-0.35,-0.35,-0.33,-0.31,-0.3,-0.29,-0.3,-0.31,-0.32,-0.32,-0.32,-0.32,-0.33,-0.41,-0.44,-0.37,-0.18,-0.1,-0.01,0.08,0.13,0.2,0.3,0.41,0.51,0.6,0.66,0.76,0.82,0.9,0.97,1.06,1.14,1.17,1.14,1.13,0.99,0.81,0.59,0.31,-0.01,-0.24,-0.24,-0.11,-0.06,-0.04,-0.04,-0.13,-0.18,-0.03,-0.13,-0.17,-0.16,-0.19,-0.31,-0.25,-0.2,-0.25,-0.25,-0.28,-0.23,-0.22,-0.21,-0.15,-0.21,-0.26,-0.15,-0.42,-0.45,-0.44,-0.45,-0.41,-0.52,-0.49,-0.52,-0.47,-0.45,-0.47,-0.58,-0.44,-0.38,-0.54,-0.61,-0.47,-0.63,-0.69,-1.1,-0.75,-0.63:EPILEPSY
-0.44,-0.48,-0.48,-0.58,-0.58,-0.6,-0.57,-0.58,-0.58,-0.57,-0.65,-0.66,-0.67,-0.69,-0.7,-0.71,-0.73,-0.77,-0.78,-0.74,-0.7,-0.68,-0.68,-0.67,-0.63,-0.62,-0.6,-0.6,-0.6,-0.6,-0.6,-0.59,-0.56,-0.55,-0.52,-0.52,-0.52,-0.5,-0.46,-0.45,-0.45,-0.47,-0.47,-0.51,-0.5,-0.58,-0.6,-0.63,-0.64,-0.7,-0.71,-0.72,-0.71,-0.69,-0.7,-0.73,-0.75,-0.76,-0.76,-0.74,-0.71,-0.7,-0.7,-0.7,-0.7,-0.7,-0.68,-0.66,-0.65,-0.64,-0.62,-0.61,-0.61,-0.6,-0.59,-0.57,-0.53,-0.49,-0.46,-0.41,-0.38,-0.39,-0.37,-0.35,-0.34,-0.32,-0.3,-0.25,-0.19,-0.16,-0.12,-0.12,-0.15,-0.17,-0.22,-0.3,-0.33,-0.36,-0.41,-0.46,-0.51,-0.54,-0.56,-0.59,-0.64,-0.66,-0.68,-0.7,-0.73,-0.75,-0.65,-0.66,-0.63,-0.61,-0.59,-0.56,-0.54,-0.54,-0.52,-0.5,-0.48,-0.46,-0.42,-0.41,-0.39,-0.38,-0.38,-0.38,-0.38,-0.41,-0.43,-0.46,-0.47,-0.5,-0.51,-0.55,-0.56,-0.59,-0.61,-0.64,-0.67,-0.69,-0.7,-0.7,-0.7,-0.71,-0.71,-0.73,-0.75,-0.73,-0.73,-0.7,-0.62,-0.47,-0.35,-0.24,-0.29,-0.31,-0.26,-0.34,-0.31,-0.28,-0.28,-0.26,-0.27,-0.29,-0.29,-0.22,-0.22,-0.22,-0.14,-0.21,-0.25,-0.19,-0.09,-0.13,-0.12,-0.09,-0.24,-0.24,-0.27,-0.21,-0.26,-0.24,-0.16,-0.17,-0.21,-0.12,-0.12,-0.05,-0.16,-0.13,-0.17,-0.15,-0.2,-0.24,-0.18,-0.24,-0.29,-0.3,-0.31,-0.26,-0.36,-0.48,-0.24,-0.34:-0.65,-0.64,-0.65,-0.65,-0.65,-0.65,-0.65,-0.64,-0.65,-0.64,-0.65,-0.64,-0.65,-0.64,-0.65,-0.64,-0.65,-0.65,-0.64,-0.65,-0.65,-0.64,-0.64,-0.65,-0.64,-0.65,-0.64,-0.63,-0.65,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.61,-0.55,-0.5,-0.3,-0.39,-0.54,-0.56,-0.6,-0.63,-0.6,-0.56,-0.59,-0.45,-0.46,-0.43,-0.38,-0.28,-0.32,-0.35,-0.35,-0.43,-0.43,-0.4,-0.29,-0.27,-0.28,-0.37,-0.44,-0.42,-0.3,-0.27,-0.23,-0.25,-0.32,-0.27,-0.32,-0.36,-0.42,-0.38,-0.36,-0.32,-0.29,-0.27,-0.26,-0.27,-0.36,-0.35,-0.32,-0.28,-0.35,-0.38,-0.39,-0.44,-0.42,-0.34,-0.4,-0.32,-0.32,-0.29,-0.32,-0.25,-0.19,-0.11,-0.16,-0.17,-0.19,-0.15,-0.08,-0.03,0.01,0.07,0.16,0.29,0.41,0.41,0.45,0.47,0.49,0.45,0.5,0.49,0.49,0.54,0.54,0.5,0.53,0.58,0.5,0.53,0.56,0.57,0.63,0.6,0.59,0.67,0.68,0.69,0.64,0.78,0.73,0.71,0.96,0.98,0.98,0.94,0.88,0.84,0.69,0.68,0.69,0.65,0.57,0.54,0.53,0.53,0.41,0.34,0.35,0.3,0.13,-0.1,-0.44,-0.22,-0.5,-0.6,-0.58,-0.63,-0.67,-0.64,-0.61,-0.61,-0.63,-0.61,-0.65,-0.68,-0.68,-0.63,-0.57,-0.58,-0.66,-0.65,-0.63,-0.63,-0.65,-0.58,-0.6,-0.58,-0.63,-0.58,-0.58,-0.57,-0.52,-0.35,-0.32,-0.36,-0.43,-0.45,-0.55,-0.42,-0.34,-0.31,-0.35,-0.27,-0.13,-0.17,0.0,-0.15,-0.76,-0.75,-0.48:-1.79,-1.26,-0.15,0.53,-0.8,-1.42,-0.51,0.3,0.38,-0.03,-0.15,-0.37,-0.77,-0.99,-0.52,-0.61,-0.83,-0.75,-0.78,-0.82,-0.77,-0.77,-0.75,-0.72,-0.73,-0.89,-0.75,-0.81,-0.87,-0.97,-1.0,-0.93,-0.98,-1.02,-0.89,-0.81,-0.67,-0.94,-0.94,-0.83,-0.79,-0.72,-0.7,-0.6,-0.51,-0.43,-0.43,-0.6,-0.6,-0.62,-0.62,-0.41,-0.5,-0.47,-0.6,-0.72,-0.69,-0.75,-0.7,-0.58,-0.8,-0.5,-0.49,-0.62,-0.67,-0.54,-0.6,-0.55,-0.58,-0.89,-0.75,-0.81,-0.8,-0.9,-0.82,-0.97,-0.85,-0.88,-0.92,-0.94,-0.97,-0.92,-0.84,-0.82,-0.73,-0.89,-1.07,-1.04,-0.9,-0.77,-0.81,-1.41,-1.04,-0.97,-0.95,-0.9,-0.96,-0.94,-0.89,-0.92,-0.81,-0.82,-1.01,-0.9,-0.84,-0.81,-0.8,-0.92,-0.89,-0.58,-0.4,-0.87,-0.95,-0.99,-0.88,-0.83,-0.85,-0.92,-0.93,-0.87,-0.89,-0.91,-0.89,-0.83,-0.86,-0.79,-1.02,-1.14,-0.97,-0.88,-0.82,-0.79,-0.88,-0.96,-0.87,-0.83,-0.76,-0.43,-0.65,-1.23,-0.75,-0.62,-0.85,-0.87,-0.77,-0.8,-0.92,-0.92,-0.8,-0.75,-0.82,-0.79,-0.75,-0.76,-0.79,-0.71,-0.7,-0.63,-0.55,-0.47,-0.48,-0.43,-0.28,-0.4,-0.5,-0.57,-0.53,-0.62,-0.57,-0.56,-0.72,-0.71,-0.63,-0.55,-0.55,-0.82,-0.25,0.24,-1.24,-0.95,-0.95,-0.75,-0.65,-0.6,-0.44,-0.36,-0.5,-0.57,-0.59,-0.55,-0.45,-0.52,-0.46,-0.38,-0.43,-0.52,-0.54,-0.5,-0.58,-0.59,-0.54,-0.56,-0.5,-0.46,-0.47,-0.5:EPILEPSY
0.81,0.82,0.83,0.8,0.8,0.76,0.81,0.76,0.72,0.71,0.68,0.65,0.6,0.51,0.46,0.37,0.28,0.24,0.24,0.25,0.27,0.34,0.45,0.57,0.64,0.69,0.76,0.78,0.8,0.84,0.85,0.85,0.85,0.81,0.81,0.82,0.78,0.74,0.78,0.77,0.75,0.7,0.66,0.61,0.58,0.54,0.46,0.5,0.5,0.52,0.56,0.65,0.68,0.66,0.73,0.75,0.74,0.75,0.74,0.74,0.7,0.67,0.66,0.67,0.67,0.65,0.74,0.7,0.71,0.77,0.74,0.73,0.72,0.72,0.74,0.71,0.73,0.71,0.67,0.66,0.64,0.62,0.61,0.6,0.6,0.59,0.6,0.61,0.63,0.64,0.66,0.67,0.7,0.72,0.74,0.75,0.78,0.78,0.81,0.82,0.84,0.84,0.82,0.81,0.81,0.79,0.81,0.81,0.78,0.78,0.77,0.74,0.75,0.77,0.77,0.77,0.77,0.78,0.78,0.78,0.78,0.77,0.77,0.76,0.76,0.76,0.76,0.75,0.75,0.76,0.72,0.72,0.72,0.69,0.65,0.61,0.56,0.51,0.45,0.39,0.31,0.26,0.23,0.22,0.24,0.29,0.33,0.4,0.5,0.56,0.62,0.69,0.72,0.75,0.78,0.79,0.81,0.82,0.84,0.84,0.84,0.85,0.85,0.85,0.84,0.84,0.82,0.81,0.78,0.76,0.72,0.66,0.59,0.53,0.5,0.45,0.4,0.36,0.31,0.28,0.29,0.29,0.29,0.34,0.39,0.43,0.47,0.51,0.54,0.54,0.53,0.52,0.51,0.48,0.49,0.51,0.52,0.53,0.57,0.63,0.66,0.66,0.66,0.66,0.67,0.67:-0.86,-0.87,-0.87,-0.87,-0.88,-0.88,-0.87,-0.89,-0.89,-0.88,-0.89,-0.9,-0.9,-0.9,-0.9,-0.91,-0.91,-0.9,-0.91,-0.91,-0.91,-0.91,-0.91,-0.91,-0.91,-0.92,-0.91,-0.91,-0.91,-0.91,-0.91,-0.91,-0.91,-0.92,-0.91,-0.91,-0.91,-0.91,-0.91,-0.92,-0.91,-0.91,-0.91,-1.02,-1.0,-0.99,-0.9,-0.75,-0.75,-0.72,-0.61,-0.53,-0.55,-0.7,-0.83,-0.85,-0.74,-0.72,-0.62,-0.6,-0.54,-0.45,-0.53,-0.59,-0.5,-0.76,-0.87,-0.8,-0.79,-0.75,-0.63,-0.58,-0.63,-0.71,-0.7,-0.48,-0.53,-0.36,-0.47,-0.59,-0.52,-0.57,-0.53,-0.67,-0.87,-0.86,-0.78,-0.74,-0.7,-0.67,-0.6,-0.56,-0.58,-0.6,-0.61,-0.56,-0.53,-0.4,-0.38,-0.25,-0.14,-0.12,-0.11,-0.07,-0.1,-0.08,-0.16,-0.25,-0.27,-0.13,0.04,0.12,0.1,0.1,0.1,0.03,-0.21,-0.38,-0.44,-0.17,-0.16,0.09,0.11,-0.18,-0.25,-0.64,-1.26,-1.52,-0.39,1.4,0.21,-1.11,-0.84,0.13,1.02,-0.76,-2.65,-0.59,0.79,-0.07,-3.01,-1.3,0.29,0.68,-2.67,-1.79,0.57,1.57,-1.88,-2.0,0.24,1.66,-1.1,-2.39,-0.52,0.96,-0.35,-2.97,-1.32,0.63,1.13,-1.69,-1.87,0.0,1.19,-1.04,-2.66,-0.85,0.24,0.61,-2.07,-1.26,0.45,1.32,-0.89,-2.52,-0.44,0.68,-0.98,-2.28,-0.46,-0.04,-0.46,-2.12,-1.08,0.18,0.3,-1.79,-1.32,0.31,0.81,-1.16,-1.59,-0.34,0.57,-0.58,-2.0,-0.94,0.32,0.8,-1.45,-1.0,-0.57,0.42,-0.06,-1.69:-0.4,-0.08,0.17,-0.03,-0.75,-0.15,0.07,-0.05,-0.66,-0.19,0.07,0.11,-0.55,-0.18,-0.15,-0.04,-0.22,-0.37,-0.16,0.06,-0.1,-0.32,-0.17,0.08,-0.02,-0.31,-0.27,0.0,0.14,-0.73,-0.12,0.0,0.02,-0.3,-0.29,-0.19,0.07,-0.09,-0.54,-0.18,0.15,-0.21,-0.27,-0.31,0.25,0.35,-0.86,-0.2,0.1,0.08,-0.81,-0.45,-0.08,0.29,-0.18,-0.51,-0.23,0.17,0.08,-0.37,-0.15,0.17,0.2,-0.75,-0.09,-0.06,0.07,0.01,-0.41,-0.21,0.26,0.24,-0.52,-0.34,0.12,0.39,-0.7,-0.27,0.07,0.17,-0.53,-0.16,-0.03,0.14,0.01,-0.68,-0.54,0.17,0.38,-0.82,-0.68,0.11,0.3,-0.41,-0.84,-0.34,0.45,0.36,-0.7,-0.62,0.11,0.28,-0.95,-0.41,-0.02,0.22,-0.34,-0.52,-0.21,0.37,0.22,-0.65,-0.68,0.4,0.67,-0.57,-1.07,0.05,0.83,-0.63,-1.46,-0.68,0.85,0.49,-0.79,-1.01,0.42,0.79,-0.92,-1.34,-0.05,0.6,-0.64,-1.05,-0.29,0.54,0.2,-0.72,-0.82,0.21,0.48,-0.67,-1.11,-0.31,0.56,0.05,-1.01,-0.97,0.58,0.79,-0.98,-1.79,-0.11,0.78,-0.25,-1.66,-1.05,0.5,0.49,-1.07,-1.52,0.35,0.82,-0.85,-1.8,-0.27,0.64,-0.52,-1.37,-0.46,0.01,-0.03,-0.62,-0.35,0.05,0.1,-0.86,-0.39,-0.1,-0.03,-0.48,-0.11,0.02,-0.01,-0.55,-0.11,0.07,0.03,-0.47,-0.07,-0.07,-0.01,-0.24,0.03,-0.26,-0.05,-0.09,-0.6,-0.46,-0.03,0.11,-0.82,-0.45,-0.17,0.11,-0.88:EPILEPSY
-0.27,-0.23,-0.17,-0.47,-0.34,-0.3,-0.05,-0.47,-0.31,-0.38,-0.21,-0.47,-0.36,-0.4,-0.44,-0.4,-0.34,-0.34,-0.33,-0.37,-0.47,-0.29,-0.25,-0.32,-0.43,-0.35,-0.34,-0.16,-0.4,-0.31,-0.49,-0.19,-0.25,-0.3,-0.49,-0.2,-0.33,-0.27,-0.44,-0.29,-0.37,-0.29,-0.47,-0.34,-0.27,-0.35,-0.46,-0.36,-0.28,0.01,0.21,0.63,0.73,0.37,0.34,0.33,0.36,0.37,0.36,0.39,0.4,0.42,0.42,0.4,0.44,0.44,0.4,0.41,0.44,0.44,0.42,0.42,0.42,0.42,0.42,0.41,0.42,0.42,0.42,0.42,0.41,0.41,0.42,0.42,0.41,0.41,0.42,0.41,0.42,0.42,0.46,0.48,0.46,0.44,0.45,0.45,0.47,0.46,0.46,0.46,0.43,0.39,0.38,0.34,0.33,0.36,0.39,0.44,0.44,0.42,0.42,0.44,0.43,0.46,0.45,0.48,0.44,0.35,0.3,0.3,0.4,0.45,0.45,0.48,0.5,0.51,0.44,0.28,0.26,0.34,0.29,0.27,0.29,0.22,0.17,0.11,0.0,-0.02,0.1,-0.03,-0.24,-0.2,-0.16,-0.21,-0.19,-0.11,-0.11,-0.11,-0.11,-0.08,-0.08,-0.12,-0.12,-0.15,-0.15,-0.1,-0.07,-0.12,-0.11,-0.16,-0.09,-0.07,-0.15,-0.13,-0.16,-0.17,-0.26,-0.3,-0.28,-0.31,-0.25,-0.24,-0.29,-0.26,-0.2,-0.22,-0.23,-0.21,-0.15,-0.13,-0.12,-0.12,-0.05,-0.05,-0.11,-0.1,-0.19,-0.21,-0.29,-0.35,-0.35,-0.37,-0.39,-0.45,-0.45,-0.4,-0.32,-0.27,-0.2,-0.13,-0.07,-0.08,-0.08,-0.08,-0.06,-0.04:-0.9,-0.79,-0.97,-0.83,-0.78,-0.81,-0.85,-0.65,-0.49,-0.6,-0.55,-0.58,-0.63,-0.58,-0.58,-0.63,-0.67,-0.66,-0.63,-0.68,-0.74,-0.73,-0.78,-0.8,-0.82,-0.87,-0.81,-0.82,-0.82,-0.81,-0.82,-0.87,-0.73,-0.68,-0.68,-0.67,-0.63,-0.64,-0.61,-0.58,-0.56,-0.58,-0.55,-0.56,-0.56,-0.59,-0.56,-0.58,-0.63,-0.62,-0.6,-0.58,-0.57,-0.57,-0.66,-0.69,-0.71,-0.74,-0.75,-0.75,-0.78,-0.75,-0.77,-0.77,-0.73,-0.71,-0.69,-0.67,-0.67,-0.78,-0.62,-0.43,-0.42,-0.41,-0.32,-0.29,-0.31,-0.34,-0.36,-0.37,-0.55,-0.63,-0.59,-0.65,-0.68,-0.69,-0.67,-0.7,-0.71,-0.72,-0.73,-0.68,-0.73,-0.71,-0.74,-0.73,-0.69,-0.65,-0.65,-0.7,-0.73,-0.74,-0.73,-0.73,-0.66,-0.52,-0.63,-0.71,-0.74,-0.77,-0.66,-0.64,-0.58,-0.48,-0.67,-0.58,-0.61,-0.6,-0.62,-0.64,-0.64,-0.62,-0.6,-0.59,-0.6,-0.62,-0.62,-0.6,-0.62,-0.64,-0.63,-0.62,-0.64,-0.63,-0.61,-0.62,-0.66,-0.66,-0.71,-0.73,-0.77,-0.8,-0.8,-0.82,-0.81,-0.86,-0.84,-0.85,-0.85,-0.86,-0.88,-0.88,-0.86,-0.88,-0.86,-0.9,-0.87,-0.84,-0.84,-0.86,-0.87,-0.87,-0.86,-0.86,-0.87,-0.87,-0.86,-0.85,-0.85,-0.87,-0.84,-0.85,-0.85,-0.82,-0.83,-0.82,-0.81,-0.82,-0.82,-0.8,-0.82,-0.78,-0.76,-0.74,-0.69,-0.72,-0.75,-0.72,-0.73,-0.77,-0.72,-0.67,-0.67,-0.69,-0.68,-0.66,-0.69,-0.67,-0.67,-0.64,-0.64,-0.62,-0.6,-0.6,-0.62,-0.63:0.08,0.09,0.09,0.09,0.09,0.08,0.08,0.08,0.09,0.09,0.08,0.09,0.09,0.09,0.09,0.08,0.09,0.1,0.09,0.09,0.09,0.1,0.09,0.09,0.1,0.1,0.09,0.08,0.09,0.1,0.09,0.09,-0.02,0.45,0.19,1.52,0.8,0.11,-0.33,-0.58,-0.19,1.35,1.54,0.83,0.12,2.46,0.26,-0.01,-0.1,1.0,0.03,-0.2,0.4,1.32,0.08,-0.24,1.04,0.79,0.26,-0.42,1.14,0.1,-0.46,1.21,0.0,-0.03,-0.36,0.35,0.04,-0.2,-0.47,0.06,2.08,0.67,-0.06,-0.16,0.8,0.91,-0.07,-0.34,0.66,0.32,0.08,-0.48,1.09,0.31,-0.04,-0.53,0.05,0.85,-0.12,-0.63,-0.06,1.19,0.12,-0.15,-0.53,1.85,0.85,0.11,-0.69,1.38,-0.03,0.06,-0.13,1.09,-0.33,-0.6,0.82,0.39,-0.13,-0.58,1.1,0.36,-0.19,-0.52,0.78,0.34,0.13,-0.42,0.81,0.93,-0.04,-0.23,-0.35,1.11,0.02,0.23,-0.15,0.98,-0.06,0.25,-0.2,1.12,0.05,0.12,-0.39,0.96,0.09,0.24,-0.33,1.21,0.06,0.04,-0.31,0.96,-0.04,0.05,-0.2,1.37,-0.08,-0.09,0.57,0.35,-0.17,-0.14,0.33,0.53,-0.24,-0.11,-0.09,0.62,-0.18,0.2,-0.07,0.63,-0.15,0.03,-0.05,0.83,-0.14,-0.31,0.15,0.68,-0.24,0.04,-0.33,0.72,-0.01,0.11,-0.31,0.95,0.03,0.14,-0.39,0.97,0.22,-0.07,-0.4,0.18,0.64,-0.39,-0.33,0.93,0.16,0.01,-0.44,0.76,0.07,-0.24,-0.48,0.56,0.36,-0.24,0.0,-0.29:EPILEPSY
-0.64,-0.29,-0.12,-0.12,-0.15,-0.36,-0.22,-0.26,-0.4,-0.55,-0.22,-0.08,-0.28,-0.54,-0.63,-0.17,-0.18,-0.24,-0.24,-0.46,-0.24,-0.24,-0.5,-0.56,-0.16,-0.07,-0.23,-0.44,-0.57,-0.19,-0.27,-0.17,-0.54,-0.07,-0.04,-0.32,-0.42,-0.52,-0.15,-0.08,-0.34,-0.53,-0.52,-0.12,-0.25,-0.19,-0.16,-0.39,-0.06,-0.28,-0.51,-0.52,-0.34,-0.33,-0.27,-0.59,-0.05,-0.2,-0.02,-0.55,-0.1,-0.16,-0.15,-0.18,-0.3,-0.03,-0.23,-0.35,-0.38,-0.64,-0.05,-0.06,-0.1,-0.37,-0.15,0.02,-0.19,-0.61,-0.66,-0.12,-0.05,0.02,-0.36,-0.38,-0.16,-0.29,-0.34,-0.54,-0.32,-0.13,-0.3,-0.57,-0.42,-0.2,-0.2,-0.33,-0.67,-0.36,-0.07,-0.17,-0.48,-0.35,-0.19,-0.32,-0.61,-0.69,-0.26,-0.19,-0.27,-0.47,-0.65,-0.27,-0.14,-0.16,-0.16,-0.31,-0.12,-0.25,-0.35,-0.43,-0.25,-0.04,-0.25,-0.47,-0.62,-0.14,-0.15,-0.21,-0.23,-0.33,-0.09,-0.26,-0.64,-0.74,-0.35,-0.44,-0.86,-0.64,-0.45,-0.25,-0.08,-0.07,0.3,0.73,1.01,0.87,0.65,0.39,0.55,0.6,0.58,0.63,0.66,0.66,0.65,0.65,0.66,0.65,0.65,0.66,0.66,0.66,0.66,0.66,0.65,0.66,0.66,0.66,0.66,0.79,0.64,0.59,0.54,0.56,0.59,0.56,0.55,0.51,0.51,0.51,0.52,0.53,0.52,0.49,0.48,0.5,0.5,0.48,0.51,0.51,0.5,0.52,0.5,0.5,0.52,0.5,0.5,0.5,0.5,0.5,0.5,0.51,0.53,0.5,0.43,0.45:0.76,0.59,-1.61,-1.21,0.64,0.82,-1.91,-1.41,0.84,0.82,-1.02,-1.57,0.19,0.96,-1.14,-1.48,0.24,1.17,-0.51,-1.82,0.37,0.97,-1.37,-1.55,0.27,1.02,-1.11,-1.58,0.15,1.35,-0.89,-1.65,0.17,1.45,-0.91,-2.0,-0.66,0.81,0.47,-1.97,-1.35,0.44,0.96,-0.64,-1.96,-0.56,0.82,0.55,-1.72,-1.42,0.15,1.06,-0.84,-1.99,-0.49,0.99,0.38,-1.94,-1.32,0.4,0.97,-0.6,-1.82,0.25,1.22,-0.69,-2.13,-1.02,0.64,0.55,-1.55,-1.44,0.09,1.33,-0.54,-1.83,-0.88,0.6,0.43,-2.0,-1.63,0.25,1.36,-0.62,-1.77,-0.18,1.14,-0.29,-2.1,-1.0,0.34,0.68,-1.52,-1.67,-0.46,1.07,0.16,-2.02,-1.21,0.33,1.06,-0.7,-1.82,-0.57,0.68,0.34,-1.74,-1.55,0.18,1.4,-0.82,-2.08,-0.82,0.58,0.94,-1.13,-1.73,-0.23,1.1,-0.03,-2.01,-1.24,0.29,1.38,-0.83,-1.66,0.03,1.25,-1.11,-2.05,-0.8,1.26,-0.07,-2.12,-0.8,1.11,0.0,-2.15,-1.2,0.86,0.9,-1.19,-1.91,-0.37,1.4,-0.61,-2.28,-1.0,0.88,0.84,-1.13,-1.91,-0.15,0.91,-0.82,-2.16,-1.17,0.2,0.95,-0.78,-1.92,-0.53,0.65,0.68,-1.39,-2.02,-0.77,0.74,0.59,-1.09,-1.89,-0.66,1.0,1.07,-0.64,-2.15,-0.71,0.54,0.38,-1.61,-1.83,-0.26,0.93,-0.13,-2.24,-1.39,0.1,1.24,-0.52,-2.38,-1.32,0.49,0.49,-1.83,-1.75,0.17,1.3,-0.42,-2.12,-1.62,-0.63,0.66,0.71,-1.41,-1.8,-0.38:-0.08,1.14,0.74,-0.08,-0.56,1.07,0.7,0.08,-0.2,-0.09,1.14,0.4,-0.04,-0.19,1.09,0.76,0.04,0.0,-0.1,1.09,0.44,-0.09,-0.39,0.92,0.86,0.04,-0.25,-0.21,0.9,0.54,-0.13,-0.35,1.16,1.05,0.32,-0.15,-0.36,0.94,0.76,0.0,-0.21,0.27,1.75,0.69,-0.34,-0.2,1.26,0.9,-0.17,-0.36,1.02,0.89,0.07,0.13,0.21,1.12,0.02,-0.29,-0.16,1.26,0.27,0.01,-0.27,1.09,0.64,-0.06,-0.29,0.16,0.69,0.08,0.08,-0.44,0.96,0.27,-0.12,-0.35,0.04,0.54,0.16,-0.19,-0.54,0.76,0.37,-0.01,-0.09,-0.4,0.99,0.31,0.1,-0.29,-0.47,0.82,0.59,-0.01,-0.08,-0.52,0.78,0.64,0.09,-0.22,-0.34,0.76,0.49,-0.08,-0.2,-0.11,0.81,0.42,-0.34,-0.56,0.18,0.62,0.18,-0.22,-0.45,0.56,0.25,-0.18,-0.3,-0.13,1.44,1.0,0.07,-0.09,-0.39,0.96,0.8,-0.03,-0.09,-0.27,1.25,0.97,0.15,0.07,-0.13,1.35,0.83,-0.34,-0.45,0.09,1.05,0.1,-0.4,-0.44,0.83,1.12,0.03,-0.02,-0.24,0.92,1.0,-0.25,-0.14,-0.09,0.8,0.32,-0.11,-0.41,0.81,0.68,0.01,-0.02,-0.2,1.14,0.54,-0.18,-0.35,0.87,0.78,0.09,-0.02,-0.35,1.02,0.58,-0.13,-0.09,-0.21,1.0,0.35,-0.18,-0.51,0.89,0.98,0.17,0.0,-0.35,1.18,0.64,-0.31,-0.28,0.41,0.14,0.08,-0.1,-0.5,1.11,0.64,-0.09,-0.05,-0.31,0.93,0.36,-0.16,-0.19,0.29,0.82:EPILEPSY
-0.05,-0.31,0.0,-0.02,0.13,-0.36,-0.04,0.14,0.7,0.63,-0.14,0.07,0.26,0.61,-0.2,-0.05,-0.12,0.46,0.04,-0.13,-0.05,0.09,-0.15,-0.41,0.04,0.06,0.09,-0.26,-0.1,0.02,-0.04,-0.04,-0.4,0.03,0.24,0.26,-0.22,-0.26,-0.09,-0.27,-0.06,-0.41,-0.05,-0.02,0.09,-0.23,-0.08,0.0,-0.02,0.17,-0.36,0.14,0.24,0.54,-0.31,0.02,0.02,0.39,0.17,-0.12,0.11,0.22,-0.17,-0.36,0.14,0.16,0.27,-0.12,-0.14,-0.15,-0.16,0.27,-0.26,0.16,0.17,0.29,-0.37,-0.14,-0.09,-0.31,0.17,-0.37,0.12,0.13,0.22,-0.29,-0.23,-0.22,-0.09,0.29,-0.34,-0.11,0.04,0.24,-0.27,-0.16,-0.17,-0.31,0.31,-0.39,0.04,0.0,0.27,-0.31,-0.24,-0.13,0.04,0.04,-0.42,-0.04,-0.04,0.19,-0.07,-0.2,-0.16,-0.27,0.24,-0.36,-0.04,-0.04,0.05,-0.34,-0.12,-0.04,-0.14,0.55,-0.2,0.09,0.09,0.09,-0.33,-0.19,-0.19,0.09,0.43,-0.24,-0.11,0.08,0.1,-0.32,0.0,0.07,0.14,-0.33,-0.11,-0.08,0.11,0.12,-0.24,-0.1,-0.09,0.26,-0.32,-0.11,-0.07,-0.24,-0.34,-0.08,0.0,0.11,-0.06,-0.31,0.02,-0.02,0.12,-0.42,0.01,0.26,0.24,-0.34,0.01,0.02,0.02,0.61,-0.28,-0.06,0.02,0.3,-0.35,0.03,0.05,-0.09,-0.31,-0.09,0.0,0.35,0.08,-0.01,0.02,-0.02,0.33,-0.31,0.03,0.1,0.08,-0.16,-0.09,0.05,0.14,0.51,-0.19,-0.04,-0.06,0.07,-0.26,-0.02:1.06,0.77,-0.68,-1.71,0.37,0.93,-0.19,-1.46,-1.22,0.98,0.47,-0.9,-1.49,1.32,0.79,-0.53,-1.59,0.7,0.79,0.04,-1.36,-0.94,0.93,0.58,-0.94,-1.75,1.13,0.46,-0.43,-1.87,0.1,1.13,0.11,-1.44,-1.63,0.89,0.35,-0.82,-1.58,1.23,0.98,-0.62,-1.59,0.72,1.05,-0.19,-1.71,-0.56,1.1,0.27,-1.3,-1.56,1.27,0.93,-0.57,-1.64,0.56,1.09,-0.02,-1.56,-0.64,1.52,0.77,-0.83,-1.42,1.11,1.21,-0.11,-1.56,-0.65,1.05,0.27,-1.21,-1.49,1.19,0.96,-0.56,-1.62,0.47,1.16,0.16,-1.26,-1.29,1.26,1.02,0.24,-0.96,-0.45,0.03,0.46,0.76,0.96,0.21,-0.73,-0.11,0.68,0.58,0.31,0.26,-0.12,0.03,0.16,-0.02,-0.27,-0.38,-0.33,-0.3,-0.24,-0.22,-0.26,-0.29,0.0,0.15,0.27,0.39,0.35,0.4,0.22,-0.05,0.0,0.0,-0.07,-0.1,-0.38,-0.43,-0.26,-0.22,-0.26,-0.34,-0.3,-0.25,-0.2,-0.18,-0.23,-0.23,-0.23,-0.23,-0.2,-0.25,-0.2,-0.23,-0.19,-0.09,-0.05,-0.13,-0.1,-0.3,-0.22,-0.22,-0.35,-0.3,-0.25,-0.25,-0.13,0.02,0.0,0.05,-0.12,0.18,0.72,0.8,0.95,1.01,1.06,0.95,0.91,0.79,1.02,1.06,1.02,1.02,1.03,0.98,1.01,1.01,1.01,1.05,1.02,1.02,1.05,1.11,1.08,1.06,0.83,0.75,0.87,0.96,0.97,0.96,0.96,0.96,0.8,0.83,0.73,0.62,0.57,0.4,0.42,0.3,0.3,0.04,0.0,-0.02,0.0,0.04,-0.03:-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.72,-0.69,-0.59,-0.6,-0.6,-0.57,0.06,-0.65,-1.07,0.38,-0.25,-0.68,-0.71,0.1,0.7,-0.48,-0.13,-0.67,-0.56,-0.09,-0.5,-0.26,-0.33,-0.28,-0.39,0.16,-0.67,-0.19,-0.34,-0.11,-0.51,-0.61,-0.52,-0.05,-0.8,-0.5,-0.64,-0.28,-0.75,-0.55,-0.7,-0.33,-0.23,-0.98,-0.1,-0.95,-0.33,-1.34,-0.6,-0.75,-0.07,-0.2,-0.55,-0.75,0.16,-0.41,-0.21,-0.61,-0.4,-0.3,-0.77,-0.42,-0.56,-0.05,-0.57,-0.53,-0.8,0.29,-0.45,-0.85,-0.43,-0.13,-0.02,-0.5,-0.53,-0.2,0.06,-0.59,-0.62,-0.55,0.06,-0.65,-0.83,-0.72,-0.3,-0.15,-1.13,-0.67,-0.5,-0.07,-0.67,-0.4,-0.77,0.21,-0.13,-0.52,-0.59,0.12,-0.21,-0.77,-0.68,-0.43,0.01,-0.02,-0.16,-0.59,0.76,0.03,-0.35,-0.61,0.27,-0.25,-0.11,-0.45,-0.11,0.28,-0.16,-0.3,-0.06,0.65,-0.25,-0.13,-0.63,0.09,-0.14,-0.6,-0.42,-0.35,0.31,0.1,-0.33,-0.38,0.32,-0.03,-0.33,-0.61,0.13,-0.33,-0.81,-0.57,-0.14,0.44,0.26,-0.26,-0.53,0.52,-0.23,-0.94,-0.59,-0.25,0.32,-0.04,-0.64,-0.57,0.11,-0.25,-1.04,-0.55,-0.3,0.69,-0.05,-0.38,-0.56,0.63,-0.03,-0.68,-0.42,0.11,0.34,-0.23,-0.57,-0.27,0.75,0.05,-0.68,-0.69,0.41,-0.52,-1.24,-0.61,0.08,0.03,-1.31,-0.73,-0.35,0.59,-0.43,-1.07,-0.58,0.32,-0.17,-1.13,-0.67,-0.05,0.49:EPILEPSY
-1.42,-0.63,-0.22,0.0,-0.65,-0.19,-0.16,-0.04,-0.71,-0.4,0.1,-0.09,-0.54,-0.44,-0.16,-0.39,-0.96,-0.75,-0.36,-0.21,-0.32,-0.8,-0.37,0.05,-0.16,-0.4,-0.52,-0.2,-0.1,-0.98,-0.6,-0.13,-0.28,-0.84,-0.68,-0.17,-0.28,-0.57,-0.63,-0.25,-0.2,-0.79,-0.6,0.07,-0.3,-1.13,-0.67,-0.23,-0.38,-0.44,-0.8,-0.44,-0.17,-0.08,-0.49,-0.56,-0.25,-0.15,-1.02,-0.75,-0.28,-0.11,-0.69,-0.83,-0.16,-0.18,-0.48,-0.81,-0.21,-0.2,-0.33,-0.94,-0.19,-0.07,-0.09,-0.47,-0.49,-0.29,-0.12,-0.12,-0.58,-0.31,-0.18,-0.26,-0.8,-0.69,-0.33,-0.26,-0.28,-0.4,-0.58,-0.32,-0.18,-0.25,-0.52,-0.63,-0.25,-0.07,-0.06,-0.62,-0.58,-0.26,-0.06,-0.29,-0.71,-0.36,-0.07,-0.14,-0.18,-0.6,-0.41,-0.32,-0.16,-0.22,-0.49,-0.4,-0.22,-0.21,-0.74,-0.89,-0.16,-0.16,-0.42,-0.59,-0.54,-0.43,-0.2,-0.14,-0.7,-0.71,-0.45,-0.14,-0.17,-0.5,-0.51,-0.07,0.07,-0.81,-0.75,-0.15,-0.19,-0.75,-0.77,-0.36,-0.37,-0.31,-0.23,-0.33,-0.37,-0.34,-0.3,-0.3,-0.65,-0.65,-0.46,-0.27,-0.19,-0.55,-0.54,-0.42,-0.26,-0.2,-0.64,-0.65,-0.43,-0.25,-0.1,-0.52,-0.46,-0.25,-0.16,-0.2,-0.59,-0.37,-0.26,-0.22,-0.2,-0.44,-0.39,-0.3,-0.21,-0.17,-0.55,-0.32,-0.19,-0.18,-0.22,-0.55,-0.28,-0.18,-0.21,-0.5,-0.6,-0.25,-0.13,-0.25,-0.62,-0.6,-0.16,-0.11,-0.06,-0.3,-0.51,-0.4,-0.18,-0.09:-0.59,-0.26,-0.23,-0.05,-0.28,-0.34,-0.37,-0.58,-0.46,-0.43,-0.45,-0.48,-0.38,-0.18,-0.15,-0.25,-0.32,-0.44,-0.49,-0.49,-0.55,-0.53,-0.56,-0.58,-0.64,-0.57,-0.55,-0.65,-0.67,-0.93,-1.0,-0.93,-0.9,-0.8,-0.8,-0.77,-0.83,-0.78,-1.14,-1.05,-0.87,-0.9,-0.88,-1.01,-1.06,-1.08,-0.97,-0.79,-0.82,-0.8,-0.8,-1.01,-1.14,-1.0,-1.06,-1.17,-0.94,-0.89,-0.72,-0.46,-0.38,-0.7,-0.54,-0.79,-0.99,-0.65,-0.6,-0.86,-0.8,-0.64,-0.61,-0.77,-0.88,-1.04,-0.92,-0.56,-0.65,-0.42,-0.22,-0.3,-0.46,-0.71,-0.74,-0.9,-0.65,-0.64,-0.39,-0.32,-0.35,-0.55,-0.7,-1.06,-0.93,-0.89,-0.98,-0.9,-0.89,-0.82,-0.78,-0.8,-0.83,-0.82,-0.95,-0.95,-0.59,-0.49,-0.77,-1.84,-0.98,-0.94,-0.7,-0.71,-1.12,-0.77,-0.8,-0.56,-0.76,-0.91,-1.13,-0.97,-0.92,-0.69,-0.83,-0.81,-0.84,-0.5,-0.67,-0.53,-0.67,-0.79,-0.72,-1.19,-1.14,-0.91,-0.86,-0.82,-0.84,-0.89,-0.72,-0.79,-0.74,-0.71,-0.62,-0.62,-0.67,-0.86,-1.05,-1.47,-0.97,-0.84,-0.8,-0.86,-0.91,-0.8,-0.86,-0.82,-0.84,-0.91,-0.89,-1.02,-0.99,-1.11,-1.01,-1.0,-1.07,-1.0,-0.77,-0.52,-0.25,-0.05,0.25,0.38,0.33,0.03,0.24,0.92,0.76,0.84,0.86,0.12,0.77,0.43,0.48,0.4,0.39,0.29,-0.02,-0.1,0.0,-0.13,-0.1,-0.33,-0.32,-0.2,-0.08,-0.09,-0.53,-0.02,-0.21,0.1,-0.39,-0.38,0.07,-0.25,-0.25,-0.52:0.43,0.23,-0.23,-0.66,0.02,0.06,-0.07,0.12,0.27,0.01,0.12,0.04,0.12,-0.17,-0.1,-0.2,-0.16,0.06,-0.07,-0.26,0.0,-0.08,-0.12,0.04,0.02,0.25,0.11,0.12,0.08,0.12,0.13,0.1,0.13,0.22,0.14,0.1,0.1,0.06,0.19,0.23,0.41,0.32,-0.45,-0.08,0.11,0.02,0.07,0.05,0.06,0.0,0.08,0.13,0.21,0.2,0.12,0.06,-0.09,-0.08,-0.3,-0.39,-0.53,-0.32,-0.2,-0.03,-0.05,-0.24,-0.64,-0.9,-0.68,-0.53,-0.57,-0.91,-0.87,-0.77,-0.76,-0.55,-0.54,-0.89,-1.11,-0.93,-0.78,-0.81,-1.0,-1.01,-0.68,-0.83,-0.95,-0.97,-0.81,-0.74,-0.94,-0.87,-0.78,-0.81,-0.94,-0.96,-0.82,-0.72,-0.93,-1.0,-0.79,-0.68,-0.95,-0.7,-0.74,-0.87,-0.78,-0.67,-0.34,0.48,0.99,0.58,-0.07,0.15,0.38,0.33,-0.01,-0.08,0.38,0.05,-0.03,-0.12,0.2,0.1,0.0,0.0,0.18,-0.03,-0.05,-0.17,-0.02,-0.05,-0.2,-0.33,-0.45,-0.49,-0.51,-0.51,-0.41,-0.43,-0.49,-0.52,-0.52,-0.52,-0.58,-0.68,-0.64,-0.57,-0.56,-0.58,-0.69,-0.6,-0.82,-0.8,-0.68,-0.43,-0.45,-0.42,-0.45,-0.08,-0.04,0.09,0.01,0.29,0.07,-0.16,-0.27,-0.42,-0.54,-0.39,-0.47,-0.61,-0.61,-0.53,-0.36,-0.26,-0.64,-0.63,-0.61,-0.65,-0.52,-0.66,-0.7,-0.74,-0.65,-0.57,-0.67,-0.77,-0.74,-0.68,-0.37,-0.11,-0.33,-0.62,-0.65,-0.76,-0.76,-0.84,-0.81,-0.86,-0.79,-0.79,-0.73,-0.78,-0.74,-0.75:EPILEPSY
-0.21,-0.35,-0.32,-0.26,-0.25,-0.26,-0.26,-0.26,-0.27,-0.29,-0.29,-0.27,-0.26,-0.28,-0.29,-0.34,-0.35,-0.39,-0.4,-0.38,-0.38,-0.37,-0.36,-0.36,-0.36,-0.38,-0.38,-0.36,-0.36,-0.36,-0.36,-0.37,-0.37,-0.37,-0.41,-0.43,-0.44,-0.43,-0.46,-0.48,-0.5,-0.51,-0.5,-0.49,-0.49,-0.5,-0.5,-0.49,-0.48,-0.49,-0.5,-0.5,-0.51,-0.51,-0.51,-0.52,-0.53,-0.53,-0.56,-0.56,-0.57,-0.56,-0.56,-0.56,-0.57,-0.57,-0.58,-0.58,-0.58,-0.58,-0.58,-0.59,-0.6,-0.6,-0.6,-0.6,-0.62,-0.64,-0.64,-0.65,-0.66,-0.68,-0.71,-0.71,-0.72,-0.72,-0.71,-0.7,-0.72,-0.69,-0.7,-0.68,-0.68,-0.66,-0.68,-0.68,-0.68,-0.68,-0.68,-0.66,-0.65,-0.65,-0.63,-0.63,-0.61,-0.6,-0.61,-0.6,-0.6,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.57,-0.54,-0.53,-0.53,-0.53,-0.52,-0.53,-0.52,-0.5,-0.48,-0.44,-0.45,-0.46,-0.47,-0.5,-0.44,-0.41,-0.39,-0.34,-0.26,-0.25,-0.26,-0.26,-0.23,-0.23,-0.21,-0.21,-0.21,-0.23,-0.21,-0.21,-0.19,-0.19,-0.11,0.07,0.01,0.0,0.01,0.01,0.0,0.0,0.03,0.04,0.04,0.03,0.0,0.02,0.04,0.05,0.05,0.07,0.08,0.07,0.06,0.07,0.07,0.05,0.04,0.0,-0.04,-0.03,-0.03,-0.02,0.0,-0.06,-0.11,-0.15,-0.18,-0.21,-0.23,-0.25,-0.26,-0.27,-0.31,-0.31,-0.33,-0.36,-0.36,-0.35,-0.34,-0.34,-0.35,-0.36,-0.38,-0.41,-0.44,-0.48,-0.51,-0.56,-0.59,-0.63:0.1,0.1,0.09,0.06,0.07,0.08,0.13,0.13,0.15,0.19,0.17,0.18,0.21,0.22,0.25,0.31,0.28,0.24,0.18,0.25,0.18,0.22,0.2,0.2,0.2,0.23,0.25,0.25,0.38,0.4,0.44,0.45,0.49,0.54,0.53,0.54,0.53,0.53,0.49,0.5,0.52,0.47,0.47,0.57,0.57,0.51,0.49,0.43,0.52,0.47,0.58,0.37,0.52,0.57,0.59,0.73,0.8,0.84,0.8,0.94,0.9,1.07,1.02,0.89,0.9,0.9,1.0,0.96,0.9,0.85,0.9,0.9,0.92,0.97,0.83,0.52,0.19,0.43,0.33,0.31,0.3,0.26,0.15,0.35,0.47,0.67,0.78,0.97,0.98,0.96,0.95,0.93,0.81,0.83,0.75,0.71,0.74,0.7,0.74,0.8,0.55,0.24,0.04,0.04,0.17,0.16,0.16,0.22,0.19,0.2,0.19,0.17,0.09,0.02,-0.02,-0.02,-0.02,-0.05,-0.05,-0.06,-0.05,-0.05,-0.05,-0.06,-0.11,-0.15,-0.11,-0.1,-0.01,0.0,0.07,0.07,0.11,0.15,0.17,0.2,0.21,0.25,0.22,0.23,0.23,0.22,0.2,0.29,0.38,0.31,0.22,0.22,0.25,0.25,0.3,0.32,0.21,0.25,0.31,0.35,0.36,0.37,0.35,0.36,0.4,0.39,0.37,0.35,0.38,0.4,0.41,0.31,0.3,0.32,0.27,0.27,0.32,0.25,0.23,0.2,0.25,0.22,0.32,0.27,0.31,0.32,0.33,0.32,0.3,0.31,0.31,0.28,0.3,0.3,0.3,0.31,0.31,0.3,0.31,0.32,0.3,0.27,0.33,0.34,0.42,0.45,0.47,0.41,0.35,0.37:-0.51,-0.77,-0.7,-0.67,-0.44,-0.25,-0.52,-0.71,-0.73,-0.82,-0.86,-0.85,-0.67,-0.73,-0.64,-0.74,-0.8,-0.84,-1.0,-0.97,-0.97,-0.92,-0.85,-0.86,-0.87,-0.85,-0.84,-0.82,-0.82,-0.87,-0.85,-0.8,-0.75,-0.44,-0.28,-0.66,-0.19,-0.15,-0.16,-0.09,-0.12,-0.09,-0.17,-0.2,-0.18,-0.12,-0.08,-0.11,-0.13,-0.13,-0.16,-0.21,-0.25,-0.3,-0.3,-0.31,-0.34,-0.35,-0.45,-0.61,-0.68,-0.73,-0.77,-0.82,-0.83,-0.85,-0.85,-0.87,-0.88,-0.86,-0.84,-0.85,-0.89,-0.93,-0.94,-0.88,-0.86,-0.83,-0.84,-0.89,-0.9,-0.92,-0.86,-0.82,-0.8,-0.76,-0.76,-0.77,-0.75,-0.75,-0.72,-0.65,-0.6,-0.55,-0.53,-0.5,-0.5,-0.62,-0.61,-0.52,-0.5,-0.41,-0.52,-0.59,-0.53,-0.49,-0.52,-0.54,-0.56,-0.56,-0.57,-0.61,-0.7,-0.76,-0.85,-0.87,-0.81,-0.69,-0.69,-0.71,-0.76,-0.79,-0.8,-0.81,-0.8,-0.8,-0.77,-0.82,-0.84,-0.84,-0.84,-0.83,-0.83,-0.83,-0.85,-0.83,-0.81,-0.8,-0.81,-0.8,-0.77,-0.78,-0.74,-0.78,-0.8,-0.79,-0.78,-0.78,-0.8,-0.8,-0.8,-0.79,-0.78,-0.79,-0.79,-0.78,-0.77,-0.77,-0.77,-0.75,-0.72,-0.73,-0.75,-0.76,-0.75,-0.73,-0.74,-0.74,-0.75,-0.73,-0.73,-0.73,-0.72,-0.72,-0.71,-0.72,-0.71,-0.69,-0.66,-0.67,-0.68,-0.65,-0.62,-0.59,-0.57,-0.56,-0.57,-0.58,-0.58,-0.59,-0.59,-0.57,-0.6,-0.64,-0.66,-0.65,-0.63,-0.62,-0.6,-0.61,-0.6,-0.6,-0.58,-0.58,-0.58,-0.6:EPILEPSY
-0.63,-0.72,-0.77,-0.79,-0.75,-0.71,-0.7,-0.7,-0.71,-0.7,-0.61,-0.64,-0.62,-0.78,-0.79,-0.84,-0.71,-0.75,-0.76,-0.8,-0.77,-0.75,-0.7,-0.78,-0.67,-0.69,-0.71,-0.68,-0.65,-0.62,-0.53,-0.45,-0.41,-0.45,-0.54,-0.59,-0.6,-0.6,-0.65,-0.68,-0.73,-0.75,-0.84,-0.85,-0.77,-0.84,-0.78,-0.78,-0.74,-0.68,-0.62,-0.54,-0.48,-0.43,-0.6,-0.77,-0.76,-0.98,-0.94,-0.9,-0.82,-0.78,-0.74,-0.68,-0.68,-0.67,-0.65,-0.64,-0.58,-0.52,-0.42,-0.5,-0.67,-0.64,-0.54,-0.66,-0.71,-0.72,-0.73,-0.85,-0.9,-1.01,-0.95,-0.85,-0.78,-0.78,-0.8,-0.81,-0.74,-0.58,-0.39,-0.42,-0.56,-0.62,-0.63,-0.7,-0.75,-0.79,-0.81,-0.83,-0.83,-0.86,-0.84,-0.78,-0.77,-0.73,-0.71,-0.7,-0.68,-0.7,-0.63,-0.62,-0.6,-0.62,-0.6,-0.56,-0.42,-0.4,-0.54,-0.62,-0.8,-0.8,-0.83,-0.91,-0.84,-0.75,-0.78,-0.66,-0.51,-0.38,-0.19,-0.09,0.02,0.1,0.26,0.44,0.54,0.62,0.66,0.73,0.81,0.87,0.8,0.76,0.81,0.73,0.77,0.91,0.98,0.94,0.86,0.89,0.85,0.74,0.75,0.87,0.99,1.07,0.96,0.92,0.89,0.81,0.81,0.91,0.94,0.94,0.92,0.92,0.89,0.91,0.93,0.97,0.86,0.82,0.74,0.69,0.58,0.7,0.76,0.71,0.68,0.58,0.54,0.51,0.55,0.54,0.47,0.49,0.3,0.21,0.28,0.41,0.44,0.45,0.43,0.4,0.39,0.27,0.18,0.04,-0.04,-0.18,-0.3,-0.3,-0.35,-0.27:-0.84,-0.87,-0.82,-0.96,-1.27,-1.39,-1.51,-1.1,-0.67,-0.5,-0.31,-0.04,0.67,0.71,-2.66,-2.6,0.95,-0.37,-2.76,0.35,0.14,-2.8,-0.65,0.9,-2.33,-1.8,1.23,-1.19,-2.89,-0.21,0.81,-2.78,-1.34,1.13,-1.23,-2.84,0.56,0.39,-3.04,-0.35,0.82,-2.77,-0.86,1.23,-2.41,-1.99,0.99,-0.85,-2.76,-0.05,0.79,-2.63,-1.91,0.87,-1.22,-2.59,0.22,0.37,-2.82,-0.99,0.79,-2.26,-1.91,0.96,-1.17,-2.49,0.55,-0.09,-2.71,-0.61,0.76,-2.43,-1.7,0.93,-1.73,-2.24,0.73,-0.11,-2.88,-0.05,0.73,-2.71,-1.11,0.94,-2.01,-2.2,0.66,-0.48,-2.71,-0.55,0.91,-2.32,-1.97,0.75,-0.51,-2.65,-0.6,0.82,-1.91,-2.22,0.49,0.4,-3.02,-0.99,1.26,-2.35,-1.77,0.85,-1.07,-2.41,0.0,0.43,-2.89,-1.4,1.39,-1.49,-2.33,0.43,-0.09,-2.88,-0.62,1.0,-2.22,-1.82,1.16,-1.14,-2.55,0.18,0.25,-2.75,-0.93,0.99,-2.21,-1.89,0.93,-1.24,-2.32,0.28,-0.14,-3.01,-0.82,0.88,-2.16,-2.02,0.57,0.03,-2.89,-0.94,0.76,-2.02,-1.97,0.44,-0.06,-2.75,-1.19,0.76,-0.89,-2.53,0.24,0.25,-2.7,-1.4,0.85,-1.39,-2.37,0.25,0.19,-2.61,-1.46,0.82,-1.1,-2.6,0.04,-0.03,-2.64,-0.86,0.79,-1.74,-2.11,0.14,0.24,-2.83,-1.08,0.82,-1.9,-2.27,0.34,0.25,-2.58,-1.35,0.96,-0.4,-2.9,-0.94,1.13,-1.74,-2.32,0.49,0.5,-2.51,-1.92,0.74,0.01,-2.77,-0.67,1.06:0.36,0.74,0.48,-0.26,0.4,0.64,0.25,0.09,0.75,0.64,-0.19,0.25,0.77,0.63,-0.02,0.46,0.5,0.01,0.11,0.78,0.65,-0.03,0.19,0.55,0.88,0.26,0.44,0.49,0.2,0.18,0.95,0.54,-0.25,0.27,0.88,1.0,0.01,0.48,0.7,0.7,0.0,0.7,0.25,-0.42,0.08,1.08,0.83,0.11,0.51,0.61,0.41,-0.35,0.61,0.48,-0.16,0.07,0.6,0.73,0.02,0.5,0.53,0.58,0.0,0.7,0.34,-0.04,-0.1,0.6,0.07,-0.16,0.2,0.72,0.44,-0.39,0.34,0.39,0.41,0.24,0.77,0.22,-0.58,0.47,0.41,0.26,0.06,0.62,0.38,-0.16,0.4,0.37,0.59,-0.18,0.91,0.24,-0.4,0.04,0.5,0.75,-0.48,0.49,0.63,0.44,0.01,0.9,0.34,-0.24,0.16,0.54,0.78,-0.17,0.57,0.32,0.74,0.35,0.94,0.47,-0.08,0.27,0.77,1.02,0.03,0.81,0.46,1.11,0.41,0.94,0.91,0.06,0.98,0.87,0.18,0.07,1.08,0.62,-0.17,0.66,0.74,0.02,-0.03,0.95,0.78,-0.18,0.44,0.73,-0.01,0.02,0.73,0.49,0.28,0.57,0.68,0.97,0.37,0.67,0.39,0.72,0.29,0.77,0.52,0.39,0.33,1.32,0.53,-0.38,0.36,0.58,0.7,0.07,0.86,0.52,0.28,0.12,-0.28,-0.63,-0.78,-0.68,-0.74,-0.61,-0.52,-0.43,-0.34,-0.21,-0.12,0.12,0.35,0.27,0.25,0.11,0.14,0.15,0.06,-0.07,-0.02,0.07,0.39,0.64,0.71,0.65,0.42,0.32,0.22,0.37,0.5,0.31,0.32,0.39:EPILEPSY
0.0,-0.05,-0.09,0.4,-0.29,-0.08,-0.21,-0.31,0.63,-0.2,-0.07,-0.07,-0.09,0.79,-0.14,-0.1,-0.06,0.13,0.03,-0.15,-0.13,-0.21,0.15,-0.24,-0.08,-0.14,-0.29,0.61,-0.24,-0.08,-0.1,-0.19,0.51,-0.18,-0.01,-0.1,-0.3,0.93,-0.14,-0.07,-0.18,-0.32,0.74,-0.3,-0.08,-0.13,-0.12,0.73,-0.19,-0.1,-0.25,-0.3,0.8,-0.17,-0.13,-0.12,0.06,0.36,-0.16,-0.16,-0.2,0.09,-0.16,-0.06,-0.12,-0.14,0.18,0.0,-0.13,-0.1,-0.14,0.29,-0.27,-0.11,-0.24,-0.26,0.69,-0.24,-0.09,-0.21,-0.32,0.85,-0.28,-0.12,-0.16,-0.03,0.7,-0.23,0.02,0.07,0.24,0.56,-0.13,-0.09,-0.08,0.07,0.34,-0.12,-0.17,-0.19,0.19,-0.09,-0.05,-0.12,-0.32,0.35,-0.36,-0.02,-0.14,-0.36,0.68,-0.27,-0.11,-0.21,-0.37,0.74,-0.28,-0.1,-0.19,-0.43,0.48,-0.23,-0.12,-0.2,-0.36,0.55,-0.3,-0.04,-0.13,-0.34,0.34,-0.32,-0.16,-0.25,-0.39,0.58,-0.21,-0.13,-0.16,-0.31,0.14,-0.32,-0.16,-0.27,-0.44,0.19,-0.3,-0.13,-0.17,-0.26,-0.11,-0.24,-0.38,-0.34,-0.39,-0.04,-0.2,-0.31,-0.4,-0.51,0.15,-0.3,-0.25,-0.24,-0.38,-0.05,-0.38,-0.21,-0.26,-0.42,-0.12,-0.36,-0.17,-0.28,-0.37,0.35,-0.5,-0.19,-0.2,-0.35,0.2,0.02,-0.11,-0.21,-0.05,0.41,-0.15,-0.06,-0.16,-0.21,0.56,-0.24,-0.12,-0.05,0.15,0.24,-0.29,-0.14,-0.22,-0.4,0.61,-0.16,-0.19,-0.31,-0.29,0.63:-0.05,-0.03,-0.02,0.03,0.06,-0.09,-0.18,-0.24,-0.25,-0.32,-0.34,-0.2,-0.12,-0.15,-0.13,-0.2,-0.1,-0.09,-0.03,-0.08,-0.25,-0.32,-0.34,-0.28,-0.25,-0.25,-0.35,-0.43,-0.36,-0.28,-0.02,0.66,0.98,0.72,0.34,0.25,-0.12,-0.3,-0.29,-0.19,-0.12,-0.04,-0.16,-0.3,-0.32,-0.33,-0.16,-0.16,-0.1,-0.13,-0.25,-0.27,-0.15,-0.12,-0.06,0.1,0.32,0.23,0.04,0.22,0.06,0.37,0.45,0.42,0.32,0.09,0.42,0.54,0.35,0.25,0.3,0.22,0.07,0.04,-0.15,-0.09,-0.11,-0.15,-0.25,-0.38,-0.4,-0.45,-0.45,-0.53,-0.53,-0.57,-0.58,-0.63,-0.63,-0.68,-0.6,-0.61,-0.64,-0.55,-0.58,-0.56,-0.57,-0.54,-0.47,-0.48,-0.4,-0.35,-0.29,-0.22,-0.22,-0.12,-0.03,0.03,0.15,0.15,0.22,0.2,0.24,0.31,0.35,0.48,0.51,0.5,0.52,0.51,0.56,0.54,0.52,0.48,0.48,0.5,0.51,0.47,0.46,0.53,0.51,0.45,0.47,0.47,0.5,0.45,0.47,0.45,0.46,0.47,0.35,0.42,0.38,0.43,0.42,0.4,0.37,0.46,0.47,0.53,0.4,0.32,0.32,0.22,0.27,0.27,0.35,0.4,0.4,0.44,0.48,0.55,0.57,0.46,0.52,0.41,0.47,0.46,0.44,0.3,0.38,0.39,0.37,0.33,0.35,0.33,0.37,0.37,0.35,0.4,0.38,0.51,0.49,0.55,0.42,0.67,0.65,0.63,0.61,0.6,0.9,1.29,0.88,0.72,0.2,-0.12,-0.24,0.04,-0.18,-0.12,-0.27,0.0,-0.05,-0.05,0.09,0.08:-0.8,-0.79,-0.79,-0.78,-0.78,-0.82,-0.82,-0.82,-0.83,-0.89,-0.85,-0.87,-0.82,-0.73,-0.58,-0.44,-0.27,-0.17,-0.15,-0.2,-0.3,-0.42,-0.43,-0.41,-0.4,-0.5,-0.6,-0.75,-0.8,-0.82,-0.81,-0.81,-0.82,-0.84,-0.85,-0.85,-0.85,-0.85,-0.85,-0.85,-0.88,-0.85,-0.92,-0.78,-0.83,-0.79,-0.95,-0.8,-0.9,-0.86,-0.92,-0.79,-0.66,-0.77,-0.71,-0.7,-0.63,-0.65,-0.78,-0.99,-0.9,-0.78,-0.8,-0.67,-0.72,-0.77,-0.8,-0.8,-0.72,-0.69,-0.82,-0.89,-0.96,-0.93,-0.95,-1.01,-0.99,-0.97,-0.89,-0.82,-0.75,-0.85,-0.83,-0.87,-0.89,-0.92,-0.9,-0.9,-0.94,-0.89,-0.93,-0.84,-0.79,-0.8,-0.74,-0.69,-0.67,-0.66,-0.6,-0.68,-0.74,-0.81,-0.66,-0.67,-0.62,-0.58,-0.72,-0.66,-0.77,-0.69,-0.75,-0.78,-0.79,-0.8,-0.71,-0.75,-0.79,-0.76,-0.76,-0.69,-0.73,-0.7,-0.81,-0.71,-0.78,-0.81,-0.83,-0.84,-0.79,-0.78,-0.81,-0.77,-0.8,-0.77,-0.8,-0.75,-0.8,-0.74,-0.74,-0.79,-0.8,-0.8,-0.75,-0.82,-0.74,-0.79,-0.8,-0.6,-0.63,-0.8,-0.69,-0.67,-0.6,-0.59,-0.62,-0.8,-0.87,-0.73,-0.8,-0.65,-0.58,-0.71,-0.67,-0.6,-0.4,-0.47,-0.5,-0.45,-0.45,-0.49,-0.47,-0.52,-0.54,-0.54,-0.59,-0.6,-0.61,-0.62,-0.66,-0.62,-0.67,-0.74,-0.74,-0.86,-0.79,-0.9,-0.88,-0.84,-0.82,-0.8,-0.74,-0.75,-0.68,-0.75,-0.77,-0.71,-0.71,-0.67,-0.71,-0.71,-0.7,-0.6,-0.61,-0.64,-0.7,-0.66:EPILEPSY
-0.53,-0.36,-0.74,-0.56,-0.85,-0.58,-0.53,-0.95,-0.8,-0.75,-0.48,-0.79,-0.64,-0.7,-0.46,-0.59,-0.61,-0.83,-0.6,-0.64,-0.87,-0.54,-0.81,-0.56,-0.54,-0.72,-0.8,-0.76,-0.52,-0.43,-0.92,-0.49,-0.79,-0.68,-0.47,-0.74,-0.49,-0.72,-0.65,-0.55,-0.93,-0.57,-0.76,-0.77,-0.45,-0.73,-0.67,-0.81,-0.58,-0.85,-0.48,-0.75,-0.77,-0.42,-0.49,-0.19,-0.77,-0.68,-0.68,-0.51,-0.57,-0.73,-0.5,-0.31,-0.53,-0.63,-0.74,-0.53,-0.47,-0.37,-0.64,-0.75,-0.65,-0.48,-0.46,-0.57,-0.73,-0.6,-0.43,-0.68,-0.73,-0.79,-0.59,-0.63,-0.25,-0.72,-0.79,-0.69,-0.46,-0.75,-0.53,-0.4,-0.56,-0.57,-0.8,-0.7,-0.53,-0.68,-0.58,-0.77,-0.64,-0.55,-0.72,-0.73,-0.6,-0.34,-0.56,-0.56,-0.63,-0.62,-0.6,-0.56,-0.5,-0.54,-0.42,-0.51,-0.6,-0.37,-0.78,-0.41,-0.56,-0.33,-0.67,-0.7,-0.51,-0.56,-0.38,-0.68,-0.63,-0.66,-0.7,-0.36,-0.63,-0.65,-0.63,-0.8,-0.72,-0.68,-0.56,-0.62,-0.73,-0.75,-0.66,-0.43,-0.84,-0.45,-0.72,-0.63,-0.58,-0.82,-0.53,-0.68,-0.62,-0.65,-0.63,-0.48,-0.59,-0.48,-0.61,-0.64,-0.6,-0.89,-0.73,-0.8,-0.43,-0.81,-0.7,-0.48,-0.58,-0.48,-0.65,-0.56,-0.62,-0.6,-0.72,-0.78,-0.71,-0.6,-0.41,-0.72,-0.69,-0.48,-0.56,-0.38,-0.69,-0.72,-0.45,-0.51,-0.57,-0.68,-0.43,-0.58,-0.26,-0.63,-0.7,-0.51,-0.65,-0.43,-0.61,-0.58,-0.61,-0.66,-0.71,-0.71,-0.51,-0.63:-0.5,0.87,0.57,0.32,0.06,0.04,0.32,0.45,0.45,0.46,0.55,0.78,0.81,1.32,-0.05,-0.13,0.02,-0.07,1.61,1.52,1.31,0.97,0.56,0.37,0.42,1.15,0.88,1.05,1.01,1.06,0.94,0.89,0.76,0.53,0.77,0.79,1.13,0.98,0.88,0.73,1.24,1.05,0.88,0.75,0.57,0.7,0.83,1.02,1.06,1.24,0.95,0.75,0.8,0.85,1.16,1.03,1.03,1.02,1.05,0.7,0.88,0.94,0.91,0.76,0.58,0.35,0.63,0.6,0.6,1.07,0.9,0.88,0.67,0.49,0.41,0.6,0.72,0.54,0.42,0.58,0.61,0.57,0.54,0.58,0.59,0.67,0.61,0.58,0.61,0.51,0.58,0.72,0.58,0.29,0.2,0.55,0.7,0.6,0.46,0.45,0.64,0.67,1.0,1.13,1.04,0.92,0.84,0.76,1.16,1.26,0.9,0.75,0.75,0.84,0.89,0.72,0.8,0.66,0.65,0.7,0.73,0.61,0.6,0.56,0.6,0.63,0.55,0.46,0.42,0.25,0.48,0.6,0.57,0.41,0.3,0.39,0.35,0.27,0.12,0.11,0.19,1.4,0.73,0.73,0.67,0.68,0.73,0.6,0.6,0.47,0.21,0.22,0.4,0.45,0.56,0.81,1.01,0.75,0.57,0.44,0.32,0.36,0.42,0.33,0.2,0.08,0.37,0.3,0.6,0.7,0.64,0.6,0.6,0.65,0.78,1.16,1.18,0.96,0.8,0.73,0.74,1.04,0.74,0.81,0.83,0.73,0.75,0.71,0.7,0.71,0.74,0.72,0.69,0.7,0.68,0.7,0.69,0.69,0.71,0.74,0.71,0.65,0.64,0.67,0.66,0.62:0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.39,0.36,0.16,-0.4,0.16,0.81,1.17,0.36,-0.94,-0.77,-0.26,-0.03,-0.4,-0.85,-0.65,-0.05,-0.06,-0.51,-0.8,-0.51,-0.02,-0.38,-0.5,-0.77,-0.3,0.09,-0.38,-0.61,-0.82,-0.18,0.03,-0.4,-0.63,-0.71,-0.11,-0.04,-0.4,-0.93,-0.28,-0.24,-0.38,-0.43,-0.85,-0.72,0.1,-0.23,-0.4,-0.74,-0.5,-0.2,-0.23,-0.52,-1.12,-0.11,-0.09,-0.4,-0.54,-0.7,-0.28,-0.3,-0.47,-0.92,-0.74,-0.23,-0.42,-0.5,-0.74,-0.42,-0.36,-0.46,-0.49,-0.82,-0.16,-0.31,-0.56,-0.62,-0.57,-0.55,-0.58,-0.47,-0.71,-0.4,-0.17,-0.38,-0.33,-1.04,-0.16,-0.31,-0.57,-0.77,-0.97,-0.3,-0.47,-0.45,-0.79,0.05,-0.13,-0.2,-0.6,-0.89,0.0,-0.09,-0.23,-0.67,-0.77,0.27,-0.28,-0.28,-0.52,-0.69,-0.72,-0.61,-0.58,-0.8,-0.4,-0.37,-0.57,-1.06,-0.03,-0.6,-0.68,-0.27,-0.6,-0.88,-0.77,-0.73,-0.45,-0.82,-0.67,-0.6,-0.51,-0.7,-0.53,-0.57,-0.44,-0.52,-0.85,-0.4,-0.39,-0.61,-0.45,-0.78,-0.29,-0.16,-0.56,-1.09,-0.43,0.02,-0.39,-1.14,-0.43,-0.32,-0.32,-0.57,-0.8,-0.82,-0.29,-0.48,-0.45,-0.76,-0.57,-0.6,-0.6,-0.37,-0.82,-0.38,-0.22,-0.51,-0.65,-0.66,-0.57,-0.4,-0.61,-0.78,-0.43,-0.27,-0.3,-0.6,-0.89,-0.3,-0.3,-0.49,-0.52,-0.73,-0.19,-0.33,-0.5,-0.73,-0.4,-0.47,-0.38,-0.81,-0.78,-0.62,-0.27,-0.51,-0.45,-0.45,-0.57:EPILEPSY
0.37,1.25,0.9,0.3,-0.03,0.67,0.95,0.7,0.44,0.3,1.26,0.86,0.66,0.07,0.7,1.04,0.76,0.62,0.42,1.17,0.97,0.63,0.08,0.41,1.06,0.86,0.48,0.15,0.71,1.12,0.65,0.23,0.28,1.01,1.02,0.52,-0.05,0.42,1.12,0.9,0.44,0.1,0.62,0.89,0.74,0.57,0.28,0.92,1.0,0.53,-0.14,0.33,0.86,0.82,0.45,-0.01,0.64,0.91,0.74,0.5,0.26,1.0,0.96,0.6,0.03,0.53,1.13,0.88,0.56,0.13,0.72,1.04,0.74,0.46,0.22,1.26,0.83,0.7,0.09,0.49,1.0,0.83,0.7,0.21,0.7,0.7,0.73,0.85,0.26,0.65,0.65,0.82,0.87,0.48,1.26,0.97,0.7,0.08,0.73,0.7,0.88,1.1,0.36,1.0,0.96,0.65,0.12,0.6,0.92,0.85,1.08,0.39,1.11,0.95,0.7,0.12,0.52,1.01,0.88,0.83,0.18,0.7,0.72,0.85,0.93,0.25,0.57,0.73,0.83,0.88,0.37,0.89,0.63,0.72,0.51,0.91,1.04,0.75,0.73,0.38,1.13,0.39,0.8,1.22,0.5,1.07,0.9,0.65,0.44,0.34,1.27,0.38,0.72,0.55,0.6,1.27,0.56,0.82,0.09,0.54,0.94,0.87,0.76,0.05,0.61,0.73,0.81,0.94,0.17,0.81,0.94,0.62,0.3,0.4,1.18,0.69,0.62,0.32,0.5,1.11,0.69,0.78,-0.02,0.82,0.72,0.77,0.53,0.59,0.83,0.76,0.71,0.6,0.69,0.74,0.81,0.86,0.89,0.86,0.86,0.88,0.86,0.86,0.85,0.82,0.78,0.75:-0.81,-0.96,-0.86,-0.54,-0.56,-0.75,-0.87,-0.77,-0.59,-0.32,-0.08,0.97,0.61,-1.97,-1.08,-0.15,0.75,0.54,-2.92,-0.69,-0.03,1.39,0.09,-3.03,-1.79,0.4,1.8,0.0,-2.82,-1.22,0.69,1.37,-0.61,-2.67,-0.95,0.68,1.45,-0.9,-2.57,-1.11,0.55,1.29,-0.13,-2.73,-1.35,0.51,1.3,-0.2,-2.63,-1.37,-0.07,0.99,0.27,-1.89,-1.7,-0.32,0.7,0.75,-1.75,-0.82,-0.38,0.66,0.72,-1.07,-2.79,-1.36,0.24,1.33,0.09,-2.61,-1.96,-0.44,0.54,0.7,-1.53,-1.84,-0.57,0.66,0.99,-0.84,-2.55,-1.08,0.25,1.08,-0.23,-2.61,-1.52,0.06,0.89,0.12,-2.1,-1.77,-0.39,0.49,0.91,-1.05,-2.26,-0.66,0.46,1.02,-0.7,-2.79,-1.2,0.29,0.94,-0.58,-2.43,-1.22,-0.05,0.8,0.15,-1.64,-1.39,-0.36,0.42,0.54,-1.23,-2.13,-0.84,0.18,0.74,-0.45,-2.44,-1.28,-0.07,0.77,0.06,-1.88,-1.52,-0.42,0.43,0.52,-0.98,-2.08,-0.73,0.34,0.73,-0.78,-2.33,-1.08,-0.04,0.75,0.07,-2.04,-1.54,-0.32,0.4,0.67,-1.45,-2.01,-0.73,0.35,0.79,-0.98,-2.3,-1.05,-0.01,0.89,-0.03,-2.26,-1.65,-0.25,0.66,0.59,-1.89,-1.09,-0.35,0.18,0.48,-0.69,-2.15,-1.05,0.29,0.72,-0.52,-2.45,-1.44,0.02,0.54,0.38,-1.49,-1.72,-0.49,0.39,0.72,-0.72,-2.09,-0.86,0.26,0.85,-0.24,-2.46,-0.68,-0.51,0.47,0.33,-1.53,-1.18,-0.73,0.52,0.72,-0.99,-1.23,-0.98,0.05,0.42:-0.39,0.13,0.34,0.21,-0.69,-0.45,0.03,0.32,0.36,-0.79,0.05,-0.09,0.33,0.05,-0.02,-0.95,-0.71,0.04,0.12,0.11,-0.95,-0.37,0.01,0.26,0.1,-0.56,-0.4,-0.52,-0.05,0.19,0.12,-0.86,-0.33,-0.08,0.12,0.19,-0.04,-0.3,-0.51,0.03,0.32,0.45,-1.01,-0.25,0.0,0.14,0.39,-0.09,-0.3,-0.3,0.12,0.26,0.13,-0.59,-0.74,-0.11,0.37,0.39,-0.85,-0.55,-0.12,0.3,0.25,-0.25,-0.51,-0.41,0.06,0.18,0.19,-1.04,-0.57,-0.05,0.15,0.36,-0.35,-0.51,-0.52,-0.05,0.01,0.01,-0.72,-0.67,-0.11,0.13,-0.16,-0.57,-0.68,-0.51,0.05,0.17,-0.23,-0.54,-0.57,-0.13,0.07,0.03,-0.89,-0.72,-0.29,0.04,0.1,-0.68,-0.53,-0.44,-0.02,-0.08,-0.27,-0.77,-0.79,-0.07,0.05,0.04,-0.92,-0.62,-0.26,0.12,0.2,-0.9,-0.58,-0.39,0.1,-0.03,-0.01,-0.77,-0.69,-0.07,0.46,0.48,-1.0,-0.87,-0.63,0.29,0.3,0.08,-0.93,-1.39,0.04,0.2,0.39,-0.46,-0.85,-0.76,0.04,0.08,-0.16,-0.59,-0.42,0.18,0.46,0.23,-0.65,-0.46,-0.06,0.32,0.31,-0.92,-0.48,-0.14,0.21,0.18,-0.77,-0.52,-0.11,0.17,0.09,-0.9,-0.37,-0.15,0.11,-0.09,-0.51,-0.48,-0.25,0.21,0.17,-0.72,-0.3,-0.2,0.09,-0.13,-1.16,-0.4,-0.11,0.12,-0.32,-0.59,-0.44,-0.09,0.1,-0.59,-0.15,-0.32,0.19,-0.08,-1.26,-0.57,0.13,0.25,0.07,-0.51,-0.67,0.05,0.45,-0.43,-0.56,-0.51:EPILEPSY
0.78,0.76,0.57,0.63,0.66,0.65,0.69,0.77,0.85,0.86,0.87,0.85,0.58,0.56,0.66,0.66,0.74,0.77,0.77,0.77,0.74,0.76,0.56,0.62,0.71,0.71,0.68,0.66,0.68,0.66,0.62,0.48,0.55,0.58,0.54,0.55,0.6,0.66,0.72,0.66,0.59,0.62,0.64,0.64,0.69,0.75,0.83,0.69,0.7,0.71,0.74,0.77,0.74,0.75,0.86,0.75,0.71,0.69,0.7,0.76,0.78,0.79,0.78,0.68,0.62,0.64,0.68,0.68,0.63,0.63,0.7,0.71,0.71,0.68,0.57,0.6,0.64,0.64,0.64,0.65,0.69,0.74,0.77,0.66,0.65,0.68,0.71,0.73,0.76,0.8,0.82,0.66,0.65,0.66,0.71,0.76,0.76,0.72,0.64,0.6,0.64,0.7,0.71,0.72,0.66,0.64,0.66,0.68,0.65,0.64,0.65,0.63,0.61,0.64,0.67,0.71,0.71,0.71,0.65,0.63,0.64,0.63,0.62,0.66,0.7,0.73,0.71,0.71,0.67,0.59,0.63,0.6,0.6,0.58,0.66,0.66,0.6,0.55,0.54,0.55,0.54,0.56,0.58,0.6,0.56,0.51,0.53,0.53,0.5,0.45,0.34,0.28,0.25,0.24,0.22,0.27,0.37,0.44,0.44,0.48,0.53,0.55,0.52,0.5,0.53,0.55,0.53,0.52,0.54,0.57,0.57,0.55,0.54,0.54,0.53,0.52,0.55,0.56,0.56,0.56,0.57,0.57,0.57,0.6,0.6,0.59,0.6,0.61,0.61,0.61,0.6,0.62,0.62,0.61,0.62,0.62,0.64,0.68,0.69,0.65,0.65,0.56,0.58,0.62,0.67,0.65:0.08,1.33,0.0,-2.72,-0.98,1.11,0.94,-1.76,-2.0,0.11,1.24,0.17,-2.28,-1.36,0.73,1.16,-1.58,-2.33,-0.27,1.21,0.38,-2.18,-1.58,0.47,1.26,-0.66,-2.8,-0.83,1.21,0.91,-2.28,-1.79,0.27,1.23,-1.26,-2.43,-0.63,1.11,0.77,-2.28,-2.0,0.26,1.26,-0.75,-2.69,-0.9,1.26,0.9,-2.5,-1.94,0.59,1.36,-1.26,-2.59,-0.36,1.6,0.35,-2.79,-1.26,0.97,1.2,-1.44,-2.58,-0.06,1.47,0.17,-2.53,-1.45,0.69,1.13,-0.89,-2.73,-0.72,1.11,0.91,-1.66,-2.25,-0.08,1.22,0.15,-2.46,-1.39,0.79,1.08,-1.42,-2.52,0.35,1.55,-0.05,-2.58,-1.3,0.7,1.13,-1.35,-2.37,-0.29,1.2,0.67,-1.74,-2.37,-0.1,1.02,0.72,-1.95,-2.04,0.13,1.25,0.34,-2.61,-1.51,0.67,1.2,-1.0,-2.65,-0.34,1.35,0.72,-2.72,-1.61,0.75,1.48,-1.06,-2.91,-0.7,1.76,0.81,-2.58,-1.36,0.76,1.3,-1.59,-2.51,0.42,1.91,0.25,-1.25,-2.18,-1.04,-0.66,-0.56,-0.43,-0.44,-0.46,-0.79,-0.75,-0.99,-0.81,-0.62,-0.62,-0.85,-0.91,-0.68,-0.77,-0.67,-0.81,-1.1,-1.07,-0.84,-0.61,-0.66,-0.69,-0.65,-0.68,-0.8,-0.78,-0.82,-0.65,-0.66,-0.68,-0.71,-0.69,-0.76,-0.75,-0.95,-0.73,-0.68,-0.59,-0.63,-0.62,-0.95,-0.93,-0.86,-0.83,-0.73,-0.7,-0.73,-0.71,-0.73,-0.72,-0.7,-0.72,-0.68,-0.63,-0.55,-0.6,-0.57,-0.72,-0.81,-0.66,-0.93,-0.79,-0.77,-0.58,-0.77,-0.85,-0.75:-0.19,-0.19,-0.11,-0.03,-0.01,0.05,0.0,-0.24,-0.44,-0.54,-0.69,-0.73,-0.88,-0.65,-0.84,-0.91,-0.92,-0.94,-0.93,-0.91,-0.89,-0.95,-0.95,-0.95,-0.94,-0.93,-0.94,-0.92,-0.94,-0.94,-0.94,-0.94,-0.94,-0.94,-0.93,-0.94,-0.94,-0.93,-0.91,-0.93,-0.93,-0.96,-0.93,-0.93,-0.92,-0.93,-0.93,-0.94,-0.93,-0.92,-0.93,-0.93,-0.93,-0.94,-0.93,-0.94,-0.92,-0.92,-0.91,-0.92,-0.93,-0.93,-0.93,-0.93,-0.94,-0.93,-0.93,-0.94,-0.93,-0.94,-0.93,-0.93,-0.92,-0.92,-0.93,-0.92,-0.92,-0.93,-0.92,-0.91,-0.92,-0.94,-0.91,-0.91,-0.93,-0.93,-0.94,-0.94,-0.93,-0.92,-0.9,-0.94,-0.92,-0.94,-0.92,-0.91,-0.91,-0.92,-0.92,-0.94,-0.92,-0.95,-0.93,-0.92,-0.92,-0.92,-0.94,-0.92,-0.93,-0.93,-0.89,-0.94,-0.94,-0.97,-0.91,-0.9,-0.94,-0.92,-0.91,-0.79,-1.09,-0.58,-0.17,0.27,0.89,0.4,0.1,0.19,-0.18,0.44,0.62,0.63,0.68,0.72,0.33,0.05,0.25,0.1,-0.43,1.57,0.31,0.13,-0.22,1.22,0.34,0.0,-0.22,0.7,0.48,-0.13,-0.26,-0.33,0.51,0.05,-0.47,-0.32,0.27,0.05,-0.61,-0.47,0.24,0.0,-0.63,-0.44,-0.03,0.0,-0.5,-0.54,-0.47,0.11,-0.35,-0.42,-0.22,0.44,-0.16,-0.5,-0.41,0.21,-0.09,-0.49,-0.35,-0.1,0.17,-0.25,-0.4,-0.47,0.18,-0.03,-0.47,-0.35,-0.09,0.09,-0.44,-0.51,-0.3,0.16,-0.14,-0.48,-0.41,0.17,0.15,-0.29,-0.37,-0.25,0.43,-0.12:EPILEPSY
0.65,0.27,0.69,0.7,0.59,0.56,0.28,0.86,0.61,0.8,0.71,0.3,0.75,0.64,0.76,0.66,0.3,0.77,0.5,0.75,0.9,0.28,0.57,0.37,0.71,0.57,0.3,0.25,1.0,0.68,0.66,0.6,0.34,0.92,0.49,0.69,0.74,0.43,0.65,0.54,0.76,0.69,0.58,0.58,0.98,0.75,0.66,0.55,0.51,1.18,0.39,0.93,1.0,0.38,0.86,0.71,0.75,0.75,0.44,0.51,0.69,0.7,0.23,0.6,0.61,0.78,0.78,0.75,0.73,0.96,0.86,0.73,0.76,0.78,0.61,0.47,0.4,0.32,0.32,0.32,0.33,0.4,0.53,0.69,0.74,0.7,0.65,0.67,0.71,0.69,0.69,0.69,0.71,0.72,0.76,0.76,0.78,0.82,0.76,0.75,0.79,0.81,0.78,0.8,0.82,0.85,0.87,0.89,0.9,0.89,0.88,0.9,0.89,0.89,0.88,0.89,0.89,0.88,0.86,0.85,0.82,0.8,0.78,0.77,0.75,0.77,0.82,0.77,0.74,0.76,0.81,0.82,0.81,0.83,0.86,0.87,0.87,0.86,0.86,0.85,0.83,0.86,0.84,0.81,0.76,0.75,0.8,0.85,0.79,0.8,0.8,0.8,0.79,0.78,0.77,0.76,0.78,0.79,0.76,0.8,0.79,0.78,0.78,0.7,0.58,0.56,0.58,0.57,0.57,0.6,0.6,0.61,0.62,0.66,0.69,0.69,0.71,0.74,0.75,0.79,0.8,0.82,0.84,0.86,0.88,0.89,0.89,0.9,0.92,0.93,0.91,0.89,0.85,0.83,0.79,0.76,0.69,0.66,0.62,0.6,0.56,0.54,0.66,0.43,0.54,0.54:0.04,0.05,0.08,0.06,0.07,0.08,0.09,0.09,0.11,0.1,0.07,0.05,0.02,0.04,0.04,0.05,0.08,0.04,0.03,0.01,0.01,0.03,0.01,-0.02,-0.05,-0.13,-0.18,-0.31,-0.33,-0.4,-0.53,-0.54,-0.5,-0.44,-0.59,-0.5,-0.46,-0.49,-0.53,-0.49,-0.5,-0.47,-0.48,-0.51,-0.45,-0.51,-0.52,-0.41,-0.38,-0.42,-0.45,-0.4,-0.36,-0.34,-0.38,-0.44,-0.39,-0.27,-0.21,-0.16,-0.1,-0.06,0.04,0.09,0.07,0.04,0.06,-0.03,-0.06,0.01,0.01,-0.03,-0.01,0.05,0.08,0.07,0.05,0.09,0.09,0.06,0.11,0.06,0.09,0.11,0.2,0.16,0.17,0.07,0.01,-0.11,-0.27,-0.55,-0.72,-0.47,-0.42,-0.53,-0.6,-0.6,-0.54,-0.55,-0.59,-0.57,-0.62,-0.69,-0.76,-0.74,-0.72,-0.7,-0.67,-0.64,-0.65,-0.61,-0.57,-0.6,-0.6,-0.57,-0.55,-0.58,-0.54,-0.56,-0.62,-0.65,-0.6,-0.67,-0.71,-0.56,-0.46,-0.57,-0.63,-0.54,-0.49,-0.49,-0.75,-1.04,-0.73,-0.7,-0.64,-0.62,-0.6,-0.58,-0.59,-0.57,-0.65,-0.74,-0.7,-0.67,-0.68,-0.72,-0.77,-0.77,-0.78,-0.81,-0.85,-0.85,-0.85,-0.93,-0.85,-1.0,-0.96,-1.01,-1.0,-0.95,-0.88,-0.95,-1.0,-0.95,-1.0,-0.93,-0.85,-0.74,-0.68,-0.68,-0.73,-0.72,-0.74,-0.69,-0.59,-0.52,-0.35,-0.48,-0.73,-0.78,-0.79,-0.79,-0.78,-0.87,-0.85,-0.69,-0.58,-0.53,-0.46,-0.33,-0.28,-0.06,0.05,0.13,0.16,0.13,0.11,0.14,0.11,0.13,0.1,0.07,0.07,0.04:0.4,0.47,0.51,0.6,0.71,0.73,0.81,0.58,0.08,-0.69,-0.91,-0.58,-0.48,-0.56,-0.63,-0.62,-0.52,-0.44,-0.47,-0.48,-0.37,-0.37,-0.31,-0.17,-0.32,-0.32,-0.22,-0.17,-0.12,-0.04,0.03,0.14,0.24,0.3,0.34,0.35,0.32,0.34,0.33,0.34,0.13,-0.06,0.5,0.6,0.57,0.51,0.36,0.44,0.38,0.36,0.34,0.37,0.4,0.44,0.4,0.38,0.45,0.48,0.5,0.49,0.51,0.57,0.61,0.62,0.74,0.83,0.84,0.81,0.83,0.89,0.85,0.79,0.84,0.8,0.72,0.79,0.75,0.72,0.67,0.66,0.59,0.49,0.53,0.6,0.58,0.44,0.3,0.18,0.04,-0.15,-0.19,-0.24,-0.35,-0.35,-0.33,-0.35,-0.35,-0.35,-0.35,-0.29,-0.32,-0.4,-0.37,-0.29,-0.3,-0.31,-0.33,-0.31,-0.3,-0.17,-0.04,0.04,0.16,0.43,0.53,0.62,0.64,0.63,0.56,0.51,0.54,0.6,0.64,0.42,0.43,0.51,0.5,0.45,0.47,0.55,0.57,0.56,0.57,0.58,0.55,0.58,0.62,0.53,0.58,0.54,0.57,0.66,0.68,0.66,0.68,0.76,0.83,0.82,0.56,0.07,-0.21,-0.26,-0.46,-0.5,-0.49,-0.51,-0.56,-0.58,-0.46,-0.32,-0.18,-0.2,-0.13,-0.11,-0.02,0.03,0.12,0.19,0.27,0.25,0.16,0.33,0.33,0.31,0.27,0.27,0.32,0.37,0.24,0.07,-0.09,-0.39,-0.7,-0.66,-0.63,-0.64,-0.64,-0.55,-0.55,-1.05,-0.7,-0.79,-0.77,-0.79,-0.8,-0.83,-0.8,-0.8,-0.76,-0.72,-0.7,-0.71,-0.7,-0.68,-0.64,-0.61:EPILEPSY
0.61,0.65,0.8,0.64,0.67,0.68,0.87,0.7,0.63,0.37,0.64,0.83,0.78,0.72,0.79,0.73,0.68,0.41,0.57,0.61,0.66,0.51,0.44,0.57,0.75,0.6,0.42,0.21,0.47,0.79,0.56,0.25,0.29,0.29,0.56,0.35,0.11,0.26,0.38,0.56,0.52,0.04,0.32,0.72,0.55,0.32,-0.06,0.43,0.75,0.65,0.37,0.24,0.61,0.65,0.59,0.65,0.63,0.52,0.65,0.58,0.65,0.66,0.71,0.58,0.29,0.12,0.65,0.86,0.65,0.66,0.57,0.55,0.67,0.59,0.51,0.63,0.7,0.62,0.72,0.71,0.83,0.69,0.62,0.66,0.71,0.7,0.62,0.57,0.63,0.7,0.6,0.49,0.58,0.64,0.76,0.65,0.65,0.62,0.69,0.63,0.55,0.45,0.48,0.8,0.62,0.66,0.62,0.65,0.71,0.71,0.49,0.59,0.69,0.72,0.67,0.51,0.51,0.65,0.65,0.45,0.45,0.44,0.66,0.52,0.36,0.5,0.51,0.68,0.6,0.06,0.25,0.51,0.63,0.54,0.5,0.46,0.59,0.7,0.59,0.53,0.53,0.54,0.76,0.49,0.18,0.3,0.42,0.64,0.62,0.31,0.44,0.63,0.73,0.64,0.5,0.43,0.52,0.68,0.58,0.05,0.16,0.45,0.74,0.61,0.42,0.49,0.62,0.71,0.62,0.5,0.6,0.68,0.74,0.54,0.58,0.48,0.71,0.87,0.68,0.74,0.59,0.72,0.66,0.65,0.51,0.58,0.65,0.73,0.49,0.55,0.39,0.56,0.78,0.66,0.61,0.72,0.8,0.71,0.37,0.25,0.43,0.74,0.59,0.12,0.05,0.39:-0.13,-2.26,-0.99,1.25,1.18,-1.14,-1.36,0.09,1.51,1.26,-1.0,-1.66,-0.01,1.42,0.65,-1.51,-0.83,0.2,1.05,0.45,-1.53,-0.91,0.37,1.01,0.71,-1.1,-0.68,0.38,1.23,0.53,-1.4,-0.45,1.0,1.27,-0.64,-1.2,0.13,0.86,0.25,-1.0,-0.37,0.92,1.37,0.44,-1.52,-0.71,0.55,1.24,0.49,-1.73,-0.15,0.76,0.03,-0.94,-0.72,-0.34,0.83,1.23,-0.14,-2.03,-0.7,1.21,1.17,-0.42,-1.52,-0.3,0.95,0.78,-0.35,-1.13,-0.09,1.0,1.32,-0.07,-1.89,-0.34,1.23,1.19,-1.61,-1.07,0.26,1.39,1.0,-1.59,-1.13,-0.23,0.94,0.48,-1.07,-1.22,-0.34,1.23,1.04,-1.14,-1.24,0.13,1.27,0.79,-1.82,-0.53,0.14,1.36,-0.73,-1.33,-0.25,1.05,1.4,-0.05,-1.49,-0.39,0.46,1.2,0.27,-1.6,-0.29,0.34,1.23,0.76,-1.98,-1.0,0.7,1.64,0.97,-1.45,-0.89,0.06,0.82,-0.04,-1.1,-0.45,0.6,1.54,0.92,-2.26,-1.06,-0.24,0.58,1.62,0.67,-1.53,-0.93,0.84,0.73,-1.6,0.25,0.12,-0.13,-0.46,-0.67,-0.1,0.84,0.91,-1.25,-0.19,-0.17,0.13,0.52,-0.55,-1.36,-0.4,0.16,1.14,-0.86,-1.19,0.59,0.34,0.39,-0.6,-1.07,-0.31,0.64,0.09,-1.02,-0.65,-0.3,0.94,1.26,-2.07,-1.02,0.07,1.6,0.65,-1.98,-1.02,0.24,1.44,0.62,-1.99,-0.72,0.28,1.88,1.01,-2.17,-0.4,1.26,0.44,-1.65,-0.64,0.06,1.62,1.13,-1.52,-0.79,0.15,1.4,1.28:-0.52,-0.53,-0.57,-0.59,-0.73,-0.77,-0.8,-0.71,-0.56,-0.65,-0.94,-0.81,-0.81,-0.91,-0.7,-0.53,-0.47,-0.49,-0.5,-0.6,-0.73,-0.84,-0.88,-0.72,-0.58,-0.53,-0.65,-0.74,-0.74,-0.6,-0.57,-0.58,-0.54,-0.49,-0.44,-0.41,-0.44,-0.54,-0.57,-0.57,-0.57,-0.54,-0.55,-0.52,-0.5,-0.54,-0.54,-0.57,-0.66,-0.68,-0.93,-0.8,-0.63,-0.7,-0.66,-0.79,-0.92,-0.84,-0.65,-0.8,-0.88,-0.77,-0.85,-0.69,-0.73,-0.8,-0.59,-0.61,-0.77,-0.77,-0.66,-0.55,-0.49,-0.5,-0.52,-0.52,-0.53,-0.55,-0.53,-0.61,-0.74,-0.8,-0.86,-0.52,-0.15,-0.04,-0.23,-0.33,-0.15,-0.1,-0.34,-0.56,-0.56,-0.55,-0.54,-0.56,-0.58,-0.56,-0.66,-0.71,-0.78,-0.82,-0.91,-0.83,-0.82,-0.86,-0.85,-0.89,-0.8,-0.83,-0.78,-0.68,-0.66,-0.65,-0.66,-0.72,-0.73,-0.76,-0.78,-0.69,-0.8,-0.77,-0.73,-0.73,-0.67,-0.59,-0.62,-0.55,-0.61,-0.66,-0.56,-0.65,-0.64,-0.57,-0.36,-0.37,-0.62,-0.45,-0.77,-0.72,-0.78,-0.78,-0.74,-0.52,-0.49,-0.55,-0.48,-0.44,-0.58,-0.72,-1.02,-0.82,-0.81,-0.8,-0.85,-0.84,-0.76,-0.68,-0.6,-0.67,-0.69,-0.63,-0.56,-0.67,-0.62,-0.61,-0.68,-0.45,-0.54,-0.64,-0.79,-0.74,-0.7,-0.76,-0.81,-0.75,-0.61,-0.53,-0.81,-0.75,-0.78,-0.85,-0.74,-0.65,-0.65,-0.57,-0.63,-0.63,-0.67,-0.65,-0.7,-0.71,-0.66,-0.72,-0.86,-0.85,-0.68,-0.65,-0.69,-0.74,-0.64,-0.59,-0.53,-0.56,-0.7,-0.65:EPILEPSY
-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.29,-0.3,-0.29,-0.3,-0.29,-0.3,-0.3,-0.3,-0.3,-0.3,-0.3,-0.3,-0.3,-0.3,-0.31,-0.48,-1.04,-1.09,0.4,1.41,0.81,0.02,0.16,0.11,0.17,-0.01,0.68,0.43,0.13,0.91,0.95,0.94,0.23,0.46,1.01,0.97,0.29,0.37,0.92,0.95,0.04,0.22,0.72,0.45,1.08,0.04,0.45,0.6,0.85,0.07,0.25,0.53,1.05,0.25,0.35,0.66,0.94,-0.14,0.2,0.76,0.78,0.24,0.51,-0.02,0.56,0.08,0.48,0.26,0.53,0.12,0.44,0.56,0.76,-0.15,0.37,0.36,0.85,-0.2,0.26,0.34,0.62,-0.45,0.46,0.38,0.63,-0.26,0.45,0.26,0.29,-0.31,0.56,0.48,-0.09,-0.93,0.44,0.58,-0.15,-0.57,0.19,0.88,-0.55,0.14,-0.04,0.38,0.32,0.41,-0.06,0.29,0.61,-0.24,-0.7,0.53,0.31,0.36,1.17,-0.35,0.48,0.73,0.47,-0.31,0.31,0.52,0.55,-0.06,0.09,0.41,0.5,0.45,-0.24,0.26,0.43,0.43,0.47,0.04,0.29,0.44,0.69,-0.13,0.34,0.44,0.31,0.5,-0.15,0.37,0.5,0.58,0.02,0.14,0.34,0.37,0.95,-0.14,0.29,0.36,0.36,-0.37,-0.07,0.3,0.53,0.22,-0.1,0.39,0.48,0.53,0.02,0.04,0.26,0.52,0.32,0.0,0.09,0.29,0.14,1.08,-0.37,0.11,0.48,-0.09,-0.34,0.14,0.17,0.24,1.15,-0.38,0.37,0.57,0.08,-0.3,0.22,0.39,0.07,0.68,-0.25:-1.9,-0.38,1.92,0.26,-1.95,-0.25,2.33,0.68,-1.63,-1.43,1.59,0.53,-1.58,-0.78,2.02,0.8,-1.59,-1.11,1.37,0.95,-1.75,-1.13,1.03,0.71,-1.71,-0.88,1.32,0.51,-2.05,0.17,2.07,0.41,-2.02,0.13,1.99,0.76,-1.96,-0.33,1.34,1.02,-1.8,-0.45,1.39,1.03,-1.67,-0.57,0.71,1.35,-1.54,-1.27,1.69,0.92,-1.65,-0.33,1.14,0.99,-1.53,-0.3,0.1,1.74,-1.11,-1.55,1.13,1.66,-0.46,-1.13,1.17,1.74,0.5,-1.79,-0.75,1.78,0.8,-1.49,-1.11,0.78,1.58,0.0,-2.12,-1.22,1.93,1.37,-0.91,-1.98,0.96,1.91,-0.14,-2.21,-0.1,1.87,0.47,-1.77,-1.56,1.44,0.96,-0.38,-2.17,-0.68,1.8,0.65,-0.96,-2.07,0.75,1.56,0.22,-1.88,-1.85,1.48,1.11,-0.57,-2.27,-0.14,1.49,0.4,-1.41,-2.02,1.13,1.26,-0.37,-2.22,0.27,1.1,0.39,-1.88,-1.48,0.98,0.86,-0.47,-2.08,0.1,1.44,0.59,-0.99,-1.95,0.56,1.02,0.0,-2.04,0.31,0.79,1.07,-0.75,-1.74,0.65,1.44,0.06,-1.96,-0.85,1.02,0.98,-1.13,-1.44,1.08,1.54,0.3,-1.84,-1.42,1.64,1.32,-0.37,-1.81,-0.97,1.09,0.7,-0.86,-1.99,0.63,1.46,0.09,-1.77,-1.03,0.88,0.81,-0.57,-1.89,-0.1,1.16,0.42,-1.51,-1.5,0.25,1.33,0.27,-1.91,0.61,-0.47,1.19,0.25,-2.08,0.47,0.72,0.96,-1.26,-1.44,0.94,1.53,-0.15,-1.94,-0.17,1.82,0.88,-1.06,-1.39,0.15,1.47,0.26:-0.19,-0.22,-0.21,-0.27,-0.21,-0.15,-0.2,-0.29,-0.32,-0.38,-0.44,-0.48,-0.56,-0.61,-0.63,-0.56,-0.7,-0.58,-0.62,-0.47,-0.44,-0.67,-0.43,-0.45,-0.41,-0.38,-0.36,-0.33,-0.41,-0.35,-0.44,-0.34,-0.47,-0.38,-0.56,-0.43,-0.38,-0.46,-0.35,-0.47,-0.41,-0.4,-0.5,-0.36,-0.49,-0.3,-0.39,-0.4,-0.44,-0.44,-0.41,-0.46,-0.44,-0.47,-0.5,-0.52,-0.52,-0.47,-0.45,-0.43,-0.4,-0.4,-0.43,-0.41,-0.28,-0.29,-0.3,-0.16,-0.02,-0.07,-0.13,-0.03,0.01,0.06,0.04,-0.02,-0.2,-0.22,-0.11,0.0,-0.05,0.07,-0.03,0.03,-0.12,-0.05,0.11,0.04,0.01,-0.08,-0.3,-0.94,-0.84,-0.77,-0.78,-0.72,-0.75,-0.8,-0.82,-0.85,-0.82,-0.81,-0.82,-0.78,-0.8,-0.7,-0.8,-0.84,-0.6,-0.87,-0.89,-0.87,-0.83,-0.8,-0.78,-0.8,-0.77,-0.78,-0.8,-0.81,-0.8,-0.78,-0.77,-0.75,-0.74,-0.74,-0.72,-0.71,-0.71,-0.72,-0.72,-0.71,-0.7,-0.67,-0.66,-0.65,-0.63,-0.6,-0.55,-0.57,-0.56,-0.55,-0.55,-0.57,-0.56,-0.59,-0.59,-0.6,-0.62,-0.64,-0.65,-0.68,-0.72,-0.73,-0.75,-0.75,-0.76,-0.77,-0.78,-0.76,-0.77,-0.78,-0.77,-0.75,-0.74,-0.73,-0.75,-0.73,-0.72,-0.7,-0.7,-0.67,-0.67,-0.67,-0.62,-0.64,-0.65,-0.69,-0.67,-0.64,-0.64,-0.68,-0.69,-0.71,-0.74,-0.85,-0.85,-0.77,-0.81,-0.84,-0.8,-0.79,-0.65,-0.67,-0.73,-0.73,-0.75,-0.75,-0.87,-0.75,-0.71,-0.75,-0.7,-0.81,-0.84,-0.83:EPILEPSY
-0.42,-0.29,-0.26,-0.41,-0.53,-0.33,0.04,0.39,-0.44,-0.54,-0.26,-0.05,0.12,-0.5,-0.65,-0.38,-0.39,-0.36,-0.44,-0.38,-0.33,-0.41,-0.38,-0.37,-0.2,-0.02,-0.06,-0.41,-0.36,-0.39,-0.42,-0.34,-0.54,-0.58,-0.38,-0.31,-0.04,-0.38,-0.51,-0.41,-0.63,-0.58,-0.84,-0.48,-0.36,-0.03,-0.51,-0.53,-0.29,-0.31,-0.21,-0.6,-0.36,-0.39,-0.65,-0.62,-0.92,-0.58,-0.36,-0.11,-0.46,-0.46,-0.38,-0.21,-0.16,-0.42,-0.48,-0.29,-0.42,-0.55,-0.68,-0.45,-0.41,-0.12,-0.41,-0.69,-0.46,-0.45,-0.38,-0.48,-0.67,-0.46,-0.38,-0.16,-0.48,-0.67,-0.53,-0.51,-0.45,-0.57,-0.54,-0.53,-0.43,-0.51,-0.61,-0.41,-0.55,-0.51,-0.71,-0.46,-0.4,-0.21,-0.54,-0.7,-0.6,-0.46,-0.25,-0.53,-0.69,-0.5,-0.56,-0.55,-0.56,-0.51,-0.35,-0.21,-0.48,-0.51,-0.31,-0.01,-0.15,-0.56,-0.51,-0.22,-0.14,-0.53,-0.82,-0.46,-0.34,-0.43,-0.58,-0.42,-0.27,-0.04,-0.48,-0.68,-0.19,0.13,-0.13,-0.65,-0.51,-0.29,-0.19,-0.25,-0.52,-0.34,-0.21,-0.24,-0.46,-0.88,-0.5,-0.61,-0.43,-0.55,-0.31,-0.34,-0.12,-0.41,-0.77,-0.48,-0.63,-0.24,-0.59,-0.29,-0.12,-0.58,-0.17,-0.82,-0.61,-0.42,-0.23,-0.61,-0.82,-0.43,-0.45,-0.25,-0.76,-0.31,-0.31,0.05,0.22,0.46,0.22,-0.21,-0.14,0.09,0.14,0.24,0.39,0.45,0.51,0.55,0.52,0.54,0.53,0.5,0.48,0.39,0.38,0.68,0.58,0.41,0.37,0.37,0.32,0.06:1.15,1.38,1.29,1.44,0.33,0.51,0.49,0.7,0.96,0.61,0.77,0.9,0.84,0.85,0.75,0.59,0.6,0.72,0.61,0.79,0.41,0.62,0.98,1.04,1.16,0.94,0.94,1.11,1.05,1.1,0.85,0.9,0.85,1.03,0.89,0.95,1.05,1.06,0.96,0.8,1.26,1.13,1.06,1.16,0.96,1.06,1.11,1.02,0.88,0.8,0.78,0.8,0.78,0.83,0.81,0.76,0.78,0.88,0.73,0.7,0.6,0.61,0.5,0.46,0.47,0.4,0.32,0.11,0.32,0.22,0.29,0.3,0.34,0.22,0.39,0.42,0.28,0.32,0.27,0.15,0.15,0.27,0.65,0.4,0.72,0.62,0.65,0.69,0.75,0.63,0.92,0.83,0.69,0.45,0.21,-0.09,0.16,0.14,-0.01,0.01,0.3,0.28,0.5,0.68,0.73,0.78,0.66,0.75,0.59,0.68,0.51,0.49,0.43,0.26,0.2,0.38,0.62,0.71,1.18,1.63,0.88,0.95,0.87,1.12,1.03,1.09,0.87,0.93,1.02,0.89,0.96,1.01,1.07,0.82,0.96,0.85,0.66,0.94,0.53,0.38,0.77,0.78,0.55,0.68,0.71,0.62,0.78,0.93,0.88,0.9,1.02,1.03,0.93,1.07,1.13,1.08,0.99,0.9,0.75,0.96,1.02,0.95,0.97,1.01,0.95,0.94,0.98,1.01,0.99,1.01,1.01,1.01,1.06,0.96,0.96,0.98,0.93,0.98,0.99,0.96,0.98,1.01,1.0,0.93,0.92,0.86,0.83,0.73,0.65,0.8,0.72,0.85,0.86,0.71,0.61,0.42,0.4,0.55,0.46,0.67,0.64,0.6,0.47,0.45,0.65,0.58:-0.43,-1.09,-0.55,-0.25,-0.68,-0.65,-0.95,-0.21,-0.15,-0.7,-0.97,-1.39,0.22,-0.12,-0.49,-0.65,-0.78,-0.26,-0.28,-0.55,-1.23,-0.2,-0.11,-0.59,-0.39,-0.9,-0.4,-0.36,-0.63,-0.8,-0.51,-0.12,-0.47,-0.46,-1.05,-0.45,-0.3,-0.64,-0.66,-0.74,-0.24,-0.46,-0.5,-0.88,-0.33,-0.38,-0.7,-0.38,-1.13,-0.48,-0.37,-0.7,-0.62,-1.02,-0.31,-0.35,-0.5,-0.98,-0.52,-0.53,-0.55,-0.67,-1.32,-0.39,-0.4,-0.79,-0.58,-1.41,-0.26,-0.05,-0.65,-0.7,-1.14,0.08,0.09,-0.62,-0.8,-0.8,-0.4,-0.7,-0.65,-1.44,-0.71,-0.68,-0.56,-0.7,-0.74,-0.72,-0.75,-0.45,-0.65,-0.64,-0.45,-0.54,-0.63,-0.89,-0.69,-0.47,-0.56,-0.66,-0.7,-0.25,-0.55,-0.54,-1.12,-0.13,-0.08,-0.64,-0.67,-0.72,0.03,-0.27,-0.55,-1.07,0.09,0.07,-0.52,-0.8,-0.49,0.26,-0.29,-0.71,-1.27,0.53,0.16,-0.31,-0.52,-1.25,0.28,0.06,-0.57,-0.77,-0.77,0.43,-0.01,-0.49,-1.11,0.55,-0.01,-0.49,-0.73,-0.29,0.53,0.21,-0.52,-0.99,0.84,0.52,-0.29,-0.81,-1.09,1.16,0.53,-0.42,-0.94,-0.34,0.4,-0.07,-0.52,-1.02,-0.07,0.09,-0.47,-0.63,-0.08,-0.21,0.43,-0.33,-0.72,-0.8,-1.07,-0.52,-0.4,-0.58,-0.77,-0.48,-0.46,-0.42,-0.32,-0.38,-0.41,-0.51,-0.55,-0.5,-0.2,-0.67,-0.66,-0.52,-0.33,-0.32,0.03,0.07,-0.35,-0.13,0.18,0.1,-0.15,-0.19,-0.2,-0.13,-0.11,-0.05,-0.17,-0.13,-0.13,0.01:EPILEPSY
-0.12,-0.58,-0.31,-0.18,-0.26,-0.8,-0.69,-0.33,-0.26,-0.28,-0.4,-0.58,-0.32,-0.18,-0.25,-0.52,-0.63,-0.25,-0.07,-0.06,-0.62,-0.58,-0.26,-0.06,-0.29,-0.71,-0.36,-0.07,-0.14,-0.18,-0.6,-0.41,-0.32,-0.16,-0.22,-0.49,-0.4,-0.22,-0.21,-0.74,-0.89,-0.16,-0.16,-0.42,-0.59,-0.54,-0.43,-0.2,-0.14,-0.7,-0.71,-0.45,-0.14,-0.17,-0.5,-0.51,-0.07,0.07,-0.81,-0.75,-0.15,-0.19,-0.75,-0.77,-0.36,-0.37,-0.31,-0.23,-0.33,-0.37,-0.34,-0.3,-0.3,-0.65,-0.65,-0.46,-0.27,-0.19,-0.55,-0.54,-0.42,-0.26,-0.2,-0.64,-0.65,-0.43,-0.25,-0.1,-0.52,-0.46,-0.25,-0.16,-0.2,-0.59,-0.37,-0.26,-0.22,-0.2,-0.44,-0.39,-0.3,-0.21,-0.17,-0.55,-0.32,-0.19,-0.18,-0.22,-0.55,-0.28,-0.18,-0.21,-0.5,-0.6,-0.25,-0.13,-0.25,-0.62,-0.6,-0.16,-0.11,-0.06,-0.3,-0.51,-0.4,-0.18,-0.09,-0.31,-0.44,-0.21,-0.2,-0.09,-0.31,-0.42,-0.34,-0.26,-0.09,-0.39,-0.4,-0.26,-0.29,-0.21,-0.31,-0.37,-0.27,-0.32,-0.22,-0.44,-0.24,-0.24,-0.42,-0.68,-0.66,-0.28,-0.21,-0.15,-0.46,-0.53,-0.38,-0.26,-0.09,-0.29,-0.39,-0.31,-0.25,-0.28,-0.51,-0.4,-0.25,-0.26,-0.54,-0.64,-0.29,-0.24,-0.27,-0.22,-0.33,-0.45,-0.32,-0.26,-0.22,-0.38,-0.44,-0.47,-0.25,-0.17,-0.3,-0.53,-0.42,-0.3,-0.33,-0.4,-0.41,-0.38,-0.18,-0.18,-0.44,-0.8,-0.32,-0.11,-0.17,-0.48,-0.69,-0.34,-0.14,-0.11:0.69,-1.35,-1.99,-0.47,0.71,0.77,-1.19,-2.08,-0.71,0.76,0.89,-0.92,-2.21,-0.78,0.77,0.62,-1.95,-1.77,-0.39,1.02,0.4,-2.26,-1.58,-0.08,1.48,-0.44,-2.35,-1.61,0.02,1.22,-0.28,-2.33,-1.35,0.34,1.07,-1.06,-2.27,-1.14,0.52,1.29,-1.11,-2.29,-0.94,0.68,0.84,-1.19,-2.32,-0.91,1.23,0.7,-1.39,-1.87,-0.37,1.18,0.56,-1.42,-2.07,-0.5,0.74,0.57,-1.47,-1.91,-0.36,1.35,0.08,-2.22,-1.54,-0.05,1.26,0.3,-2.11,-1.64,0.12,1.19,-0.83,-2.39,-1.28,0.61,1.22,-0.78,-2.23,-0.61,0.9,0.86,-1.25,-2.07,-0.6,1.0,0.97,-0.96,-2.18,-0.88,0.91,1.08,-1.06,-2.11,-0.57,0.7,0.67,-1.66,-1.77,-0.38,0.97,0.43,-1.78,-1.73,-0.39,0.91,0.36,-1.63,-1.7,-0.28,1.0,-0.65,-2.17,-1.38,-0.25,0.4,0.19,-0.21,-0.17,-0.5,-1.63,-1.97,-0.63,-0.45,-1.12,-0.6,-0.32,-0.34,-0.57,-0.56,-0.49,-0.5,-0.51,-0.51,-0.51,-0.5,-0.5,-0.5,-0.5,-0.51,-0.5,-0.51,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.53,-0.56,-0.2,-0.45,-0.4,-0.64,-0.55,-0.47,-0.51,-0.52,-0.63,-0.75,-0.9,-0.85,-0.77,-0.8,-0.65,-0.7,-0.65,-0.67,-0.62,-0.42,-0.8,-0.87,-0.77,-0.86,-0.86,-0.82,-0.83,-0.81,-0.82,-0.76,-0.76,-0.81,-0.8,-0.76,-0.81,-0.75,-0.84,-0.89,-0.98,-0.78,-0.85,-0.73,-0.67,-0.61,-0.44:0.35,-0.25,-0.28,0.58,0.58,0.05,-0.07,-0.61,0.73,0.08,0.04,0.08,-0.46,0.96,0.42,-0.18,-0.3,-0.36,0.83,0.27,-0.05,-0.19,-0.54,0.59,0.31,-0.03,-0.11,-0.17,0.93,0.1,0.0,-0.34,-0.4,0.84,0.16,-0.08,-0.46,0.04,0.47,0.08,-0.12,-0.4,0.61,0.26,0.08,-0.06,-0.46,0.86,0.36,0.08,-0.19,-0.48,0.72,0.47,0.12,-0.31,-0.51,0.97,0.72,0.07,-0.11,-0.43,0.84,0.45,0.03,-0.2,-0.34,0.97,0.62,0.02,-0.24,-0.24,1.13,0.89,-0.37,-0.11,0.17,0.93,0.35,-0.05,-0.38,-0.71,-0.46,-0.05,0.18,0.8,-0.18,-0.39,-0.32,-0.5,-0.51,-0.71,-0.68,-0.55,-0.55,-0.6,-0.61,-0.61,-0.61,-0.61,-0.61,-0.61,-0.61,-0.61,-0.61,-0.61,-0.62,-0.62,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.63,-0.77,-0.68,-0.68,-0.54,-0.66,-0.69,-0.65,-0.59,-0.45,-0.37,-0.14,-0.18,-0.35,-0.4,-0.49,-0.52,-0.56,-0.58,-0.63,-0.67,-0.31,-0.2,-0.28,-0.11,-0.08,-0.14,-0.19,-0.21,-0.2,-0.26,-0.26,-0.39,-0.5,-0.48,-0.25,-0.19,-0.01,0.05,0.05,-0.19,-0.12,-0.19,-0.5,-0.61,-0.68,-0.55,-0.82,-0.35,-0.31,-0.31,-0.33,-0.18,-0.18,-0.19,-0.27,-0.54,-0.67,-0.76,-0.79,-0.67,-0.62,-0.17,0.21,-0.21,-0.64,-0.57,-0.52,-0.59,-0.66,-0.43,-0.12,-0.18,-0.28,-0.45,-0.27,-0.06,-0.19,-0.25,0.23,0.6,0.56,0.52:EPILEPSY
0.48,0.51,0.55,0.58,0.59,0.61,0.66,0.68,0.66,0.62,0.58,0.54,0.52,0.51,0.47,0.49,0.48,0.51,0.52,0.54,0.56,0.56,0.56,0.56,0.56,0.55,0.55,0.59,0.68,0.72,0.74,0.77,0.8,0.83,0.86,0.89,0.88,0.89,0.9,0.89,0.88,0.87,0.88,0.87,0.85,0.84,0.85,0.84,0.84,0.82,0.83,0.82,0.82,0.8,0.8,0.8,0.83,0.86,0.89,0.91,0.94,0.94,0.97,0.95,0.97,0.96,0.97,0.97,0.97,0.97,0.96,0.96,0.96,0.97,0.96,0.97,0.97,0.96,0.97,0.96,0.94,0.96,0.96,0.95,0.97,0.97,0.95,0.94,0.93,0.91,0.92,0.92,0.94,0.91,0.93,0.93,0.89,0.85,0.83,0.82,0.77,0.72,0.68,0.66,0.64,0.62,0.62,0.62,0.6,0.6,0.59,0.67,0.65,0.68,0.69,0.72,0.75,0.74,0.76,0.76,0.78,0.76,0.75,0.76,0.74,0.74,0.75,0.77,0.74,0.77,0.76,0.71,0.73,0.75,0.77,0.82,0.82,0.85,0.83,0.85,0.82,0.81,0.79,0.77,0.74,0.72,0.71,0.7,0.7,0.71,0.71,0.72,0.72,0.72,0.71,0.7,0.68,0.64,0.6,0.56,0.53,0.52,0.51,0.49,0.51,0.53,0.52,0.52,0.52,0.53,0.53,0.52,0.5,0.48,0.48,0.48,0.5,0.51,0.51,0.49,0.47,0.45,0.42,0.42,0.45,0.49,0.58,0.65,0.73,0.79,0.8,0.82,0.86,0.87,0.88,0.89,0.9,0.9,0.9,0.89,0.88,0.86,0.82,0.79,0.78,0.75:-0.18,-0.19,-0.21,-0.27,-0.29,-0.3,-0.34,-0.33,-0.38,-0.33,-0.36,-0.42,-0.39,-0.48,-0.44,-0.32,-0.16,-0.06,0.06,0.1,0.08,0.13,0.21,0.23,0.22,0.23,0.31,0.28,0.24,0.2,0.14,0.14,0.05,0.01,0.03,0.04,0.03,-0.07,-0.2,-0.18,-0.37,-0.56,-0.4,-0.36,-0.47,-0.5,-0.54,-0.53,-0.5,-0.47,-0.39,-0.35,-0.41,-0.5,-0.5,-0.56,-0.54,-0.56,-0.61,-0.64,-0.71,-0.78,-0.77,-0.71,-0.55,-0.76,-0.69,-0.63,-0.59,-0.7,-0.71,-0.66,-0.65,-0.7,-0.85,-0.93,-0.9,-0.9,-0.92,-0.83,-0.82,-0.83,-0.83,-0.82,-0.81,-0.85,-0.82,-0.83,-0.76,-0.96,-0.88,-0.82,-0.84,-0.83,-0.79,-0.85,-0.86,-0.95,-1.06,-1.05,-0.88,-0.78,-0.65,-0.51,-0.51,-0.53,-0.53,-0.51,-0.49,-0.4,-0.36,-0.32,-0.3,-0.25,-0.23,-0.27,-0.36,-0.47,-0.64,-0.69,-0.65,-0.7,-0.74,-0.73,-0.74,-0.73,-0.81,-0.83,-0.89,-0.97,-0.96,-1.0,-0.94,-0.91,-0.91,-0.86,-0.9,-0.89,-0.95,-0.89,-0.84,-0.83,-0.76,-0.72,-0.74,-0.74,-0.67,-0.6,-0.58,-0.54,-0.45,-0.42,-0.31,-0.24,-0.2,-0.15,-0.12,-0.01,0.05,-0.1,0.05,0.19,0.2,0.17,0.13,0.13,0.17,0.18,0.14,0.0,-0.11,-0.23,-0.36,-0.46,-0.49,-0.48,-0.47,-0.51,-0.52,-0.57,-0.54,-0.47,-0.54,-0.56,-0.54,-0.53,-0.61,-0.7,-0.62,-0.59,-0.6,-0.56,-0.5,-0.43,-0.35,-0.23,-0.16,-0.05,0.01,0.07,0.11,0.16,0.18,0.19,0.17,0.17:0.01,0.24,0.07,-0.42,-0.25,0.1,0.3,0.1,-0.52,-0.1,0.21,0.16,-0.19,-0.15,-0.03,0.3,0.15,-0.54,-0.11,0.08,0.21,0.15,-0.73,-0.22,0.03,0.04,-0.18,-0.13,0.01,0.15,0.1,-0.52,-0.02,0.09,0.16,-0.19,-0.41,-0.04,0.09,0.07,-0.33,-0.24,0.04,0.05,0.03,-0.57,-0.17,0.0,0.01,-0.06,-0.81,-0.22,0.0,0.0,-0.08,-0.21,0.01,0.14,0.05,-0.29,-0.19,0.03,0.07,-0.06,-0.37,-0.09,0.07,0.23,-0.2,-0.18,-0.04,0.15,-0.06,-0.58,-0.17,0.09,0.08,0.13,-0.61,-0.27,0.07,0.1,-0.12,-0.35,-0.24,0.03,-0.07,-0.34,-0.14,-0.05,0.15,0.2,-0.77,-0.08,-0.01,0.1,-0.11,-0.63,-0.2,-0.02,0.04,-0.07,-0.59,-0.07,0.11,0.07,-0.46,-0.2,-0.09,-0.03,-0.18,-0.48,0.04,0.06,-0.01,-0.27,-0.37,0.05,0.07,-0.04,-0.31,-0.17,-0.01,0.05,-0.02,-0.7,0.24,0.23,-0.05,-0.24,-0.45,-0.16,0.1,0.07,-0.21,0.0,0.03,0.07,-0.11,-0.53,-0.08,0.0,0.09,-0.09,-0.62,-0.07,0.01,0.07,-0.14,-0.46,-0.06,0.07,-0.12,-0.23,-0.25,0.0,0.07,-0.02,-0.65,-0.2,0.02,-0.01,-0.04,-0.8,-0.22,0.09,-0.16,-0.2,-0.24,0.05,0.07,-0.08,-0.45,-0.05,0.08,0.0,-0.08,-0.68,-0.11,0.01,-0.03,-0.08,-0.68,-0.17,0.03,-0.01,-0.11,-0.22,-0.07,0.07,0.01,-0.37,-0.07,0.25,0.16,-0.26,-0.63,-0.29,-0.04,-0.01,-0.15,-0.64,-0.03,0.0,-0.01,-0.11:EPILEPSY
0.14,0.06,-0.01,-0.39,0.02,0.09,0.19,-0.06,-0.26,0.01,0.04,0.08,-0.48,-0.15,-0.02,0.0,-0.6,-0.05,0.27,0.08,0.16,-0.46,-0.19,-0.34,-0.09,-0.5,-0.14,0.03,-0.02,-0.07,-0.25,-0.01,0.17,-0.31,-0.45,-0.03,0.12,0.09,0.06,-0.36,-0.07,0.0,-0.03,0.04,-0.36,0.01,0.12,0.12,0.07,-0.1,0.17,0.29,0.14,-0.37,0.09,0.26,0.29,-0.05,-0.26,0.26,0.24,0.12,-0.41,-0.02,0.17,0.12,-0.11,-0.22,0.19,0.11,0.12,-0.37,-0.11,0.02,-0.07,0.06,-0.42,0.0,0.08,0.13,-0.39,-0.07,0.09,-0.1,0.03,-0.49,-0.04,0.13,0.14,-0.13,-0.22,0.11,0.03,0.11,-0.46,0.02,0.01,-0.16,-0.56,-0.13,0.06,-0.09,-0.15,-0.21,0.12,-0.1,-0.14,-0.48,-0.05,0.06,0.07,-0.45,-0.25,0.12,-0.02,0.19,-0.43,-0.04,0.1,0.33,-0.23,-0.11,0.25,-0.06,0.09,-0.36,0.05,0.04,0.04,-0.42,-0.1,0.11,0.17,-0.4,-0.11,0.11,-0.03,0.29,-0.26,0.04,-0.01,0.09,-0.36,-0.04,0.07,0.17,-0.24,-0.26,-0.12,-0.07,0.0,-0.39,0.02,0.12,0.09,-0.41,-0.16,0.0,0.02,-0.36,-0.18,0.05,0.09,0.06,-0.4,-0.02,0.06,0.08,-0.48,-0.12,0.02,0.04,-0.12,-0.19,0.1,0.13,0.17,0.09,-0.38,-0.32,-0.24,-0.22,-0.16,-0.34,0.07,0.26,0.13,0.18,0.22,0.38,0.6,0.62,0.75,0.81,0.82,0.07,-0.12,-0.12,-0.02,0.14,0.18,0.32,0.26,0.28,0.36,0.37:0.08,-1.57,-0.89,1.23,0.76,-0.72,-1.72,1.22,1.39,-0.07,-1.82,-1.01,1.72,0.83,-0.87,-1.55,1.06,1.26,-0.31,-1.78,0.39,1.31,0.31,-1.54,-1.24,1.35,0.94,-0.55,-1.75,0.89,1.18,0.15,-1.46,-1.48,1.19,0.78,-0.2,-1.88,-0.27,1.25,0.54,-0.68,-1.89,0.74,0.98,0.15,-1.37,-1.62,1.19,0.81,-0.04,-1.77,1.11,0.96,-0.36,-1.94,-0.08,1.31,-0.02,-1.27,-1.44,1.4,0.73,-1.13,-1.74,0.8,1.43,0.0,-1.84,-1.03,1.18,0.6,-0.67,-1.8,1.07,1.11,-0.3,-1.88,0.2,1.45,0.3,-1.82,-0.79,1.4,0.22,-1.39,-0.82,0.93,0.88,-0.43,-1.39,-0.03,1.4,0.59,-1.31,-1.46,1.34,1.24,0.27,-1.66,-1.25,1.26,1.18,0.19,-1.67,-1.45,1.6,0.96,-0.36,-1.79,-0.63,1.2,0.51,-1.32,-1.64,1.19,1.03,-0.35,-1.9,-1.11,1.63,0.91,-0.54,-2.01,0.55,1.26,-0.09,-1.92,-1.08,1.56,0.68,-0.73,-1.96,-0.13,1.25,0.1,-1.56,-1.64,1.33,1.07,-0.41,-1.88,0.1,1.53,0.35,-1.28,-1.57,1.26,0.9,-0.09,-2.01,-0.86,1.79,0.73,-0.88,-1.75,1.01,1.23,-0.63,-1.88,0.38,1.18,-0.12,-1.82,-1.06,1.49,0.45,-1.15,-1.67,0.48,0.89,-0.38,-1.89,-0.98,1.2,0.44,-1.11,-1.84,1.16,0.8,-0.26,-1.99,-0.41,1.32,0.6,-0.96,-1.72,1.27,0.84,-0.44,-1.84,0.4,1.18,-0.24,-1.87,-0.1,1.43,0.42,-1.49,-1.56,1.48,0.9,-0.88,-1.93,0.63,1.23:-0.75,-0.82,-0.8,-0.82,-0.83,-0.81,-0.83,-0.83,-0.8,-0.8,-0.8,-0.8,-0.78,-0.77,-0.8,-0.81,-0.73,-0.7,-0.73,-0.74,-0.74,-0.73,-0.73,-0.71,-0.7,-0.68,-0.68,-0.67,-0.63,-0.67,-0.57,-0.6,-0.65,-0.69,-0.77,-0.77,-0.83,-0.82,-0.93,-0.91,-0.89,-0.8,-0.81,-0.71,-0.69,-0.71,-0.8,-0.87,-0.49,0.06,0.1,0.08,0.08,-0.05,-0.15,-0.22,-0.12,-0.01,-0.02,0.02,-0.03,-0.07,-0.34,-0.47,-0.52,-0.46,-0.65,-0.81,-0.78,-0.54,-0.6,-0.65,-0.68,-0.74,-0.67,-0.75,-0.84,-0.79,-0.72,-0.67,-0.7,-0.75,-0.9,-0.81,-0.86,-0.88,-0.84,-0.85,-0.79,-0.8,-0.95,-0.95,-0.92,-0.92,-0.95,-1.01,-0.97,-0.85,-0.8,-0.77,-0.74,-0.77,-0.82,-0.88,-0.87,-0.85,-0.85,-0.84,-0.83,-0.85,-0.87,-0.86,-0.83,-0.8,-0.83,-0.82,-0.77,-0.86,-0.82,-0.81,-0.67,-0.68,-0.71,-0.7,-0.72,-0.72,-0.72,-0.76,-0.73,-0.85,-0.78,-0.68,-0.65,-0.74,-0.71,-0.7,-0.71,-0.68,-0.72,-0.7,-0.65,-0.61,-0.6,-0.62,-0.55,-0.47,-0.45,-0.47,-0.39,-0.28,-0.18,-0.17,-0.28,-0.39,-0.41,-0.42,-0.45,-0.43,-0.47,-0.43,-0.33,-0.33,-0.27,-0.2,-0.18,-0.15,-0.13,-0.05,-0.07,-0.07,-0.04,-0.1,-0.15,-0.15,-0.2,-0.18,-0.18,-0.22,-0.24,-0.27,-0.28,-0.32,-0.33,-0.37,-0.37,-0.37,-0.36,-0.37,-0.32,-0.45,-0.56,-0.51,-0.46,-0.45,-0.48,-0.61,-0.69,-0.73,-0.75,-0.77,-0.61,-0.57,-0.7,-0.75,-0.88,-0.88:EPILEPSY
0.15,0.15,0.15,0.15,0.15,0.14,0.15,0.15,0.15,0.13,0.13,0.16,0.36,0.36,0.34,0.34,0.46,0.5,0.49,0.42,0.34,0.32,0.43,0.45,0.47,0.45,0.43,0.45,0.45,0.45,0.43,0.43,0.42,0.42,0.42,0.42,0.43,0.43,0.41,0.42,0.42,0.42,0.42,0.43,0.43,0.42,0.42,0.42,0.42,0.42,0.42,0.42,0.42,0.42,0.42,0.43,0.43,0.43,0.43,0.43,0.43,0.44,0.43,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.44,0.43,0.44,0.44,0.43,0.43,0.44,0.43,0.44,0.43,0.43,0.43,0.43,0.44,0.44,0.43,0.44,0.43,0.44,0.43,0.43,0.44,0.44,0.44,0.44,0.43,0.44,0.44,0.44,0.44,0.44,0.41,0.56,0.71,1.0,1.05,0.85,0.34,-0.16,0.04,0.35,0.43,-0.13,0.44,1.17,1.05,0.08,-0.56,0.76,0.35,0.12,-0.64,0.11,0.67,-0.29,-0.88,-0.38,0.16,0.21,-0.88,-0.43,1.0,0.53,-0.56,-0.46,-0.18,-0.35,0.08,-0.62,-0.37,1.13,0.59,0.09,-0.11,0.09,0.47,0.11,-0.24,-0.13,0.77,0.48,0.16,-0.05,-0.12,0.71,0.65,0.22,-0.08,0.44,0.55,0.4,0.12,-0.01,1.2,0.84,0.31,-0.06,0.5,0.8,0.55,0.04,0.0,1.28,0.55,0.43,-0.17,0.28,0.37,0.65,0.06,-0.18,0.37,0.23,0.41,0.1,-0.01,0.82,0.48,0.79,0.46,0.56,0.83,0.75,0.47,0.22:-1.65,-0.81,0.26,0.67,-0.86,-1.52,-0.74,0.16,0.71,-0.76,-1.6,-0.69,0.21,0.55,-1.0,-1.37,-0.51,0.05,0.36,-0.78,-1.23,-0.42,0.48,0.62,-1.02,-1.17,-0.66,0.3,0.48,-0.84,-1.28,-0.44,0.25,0.4,-1.57,-0.97,-0.16,0.5,-0.33,-2.0,-0.18,-0.38,0.62,-1.04,-1.84,-0.77,0.2,0.66,-1.01,-1.36,-0.76,0.31,0.62,-1.25,-0.81,-0.54,0.57,0.69,-1.2,-1.19,-0.48,0.41,0.8,-1.5,-0.89,-0.36,0.61,0.53,-1.63,-1.08,0.12,0.75,0.03,-1.8,-0.82,0.34,0.99,-0.91,-1.76,-0.72,0.6,0.96,-1.3,-1.46,-0.6,0.62,0.87,-1.06,-1.66,-0.54,0.68,1.07,-1.52,-1.55,-0.16,0.85,0.87,-1.75,-1.38,-0.25,0.53,0.68,-1.52,-1.14,-0.03,0.99,0.5,-1.82,-1.11,0.13,0.93,-0.53,-1.41,-0.56,0.75,1.11,-1.24,-1.26,-0.56,0.71,0.75,-1.55,-0.83,-0.41,0.85,0.55,-1.84,-0.38,-0.25,0.71,0.26,-1.45,-0.82,0.06,0.84,-0.3,-0.71,-0.73,0.36,0.52,-0.93,-0.42,-0.47,0.4,0.33,-1.59,-0.75,-0.36,0.53,-0.32,-1.84,-0.72,0.1,0.83,-0.94,-1.26,-0.76,0.33,0.6,-1.41,-0.97,-0.71,0.38,0.59,-1.18,-1.27,-0.41,0.12,0.47,-1.28,-0.67,-0.41,0.26,0.27,-1.16,-1.04,-0.26,0.22,0.17,-1.37,-0.96,-0.02,0.45,-0.79,-1.29,-0.75,0.31,0.55,-1.18,-0.97,-0.72,0.37,0.47,-0.96,-0.95,-0.49,0.18,0.16,-1.07,-0.84,0.15,0.62,-0.82,-1.42,-0.91,0.46:-0.48,-0.16,0.44,0.03,-0.84,-0.44,0.18,0.42,-0.91,-0.65,-0.21,0.2,-0.19,-0.72,-0.73,0.08,0.16,-0.42,-0.51,-0.56,0.14,0.3,-0.62,-0.45,-0.31,0.28,0.27,-1.05,-0.33,0.18,-0.04,-0.42,-0.19,-0.24,0.22,0.22,-1.01,-0.48,-0.03,0.14,0.25,-1.16,-0.76,-0.05,0.06,-0.31,-0.55,-0.55,0.32,0.18,-1.13,-1.02,-0.09,0.26,0.08,-0.66,-1.11,0.24,0.31,-0.57,-1.05,-0.42,0.52,0.41,-0.55,-1.18,-0.22,0.49,0.63,-0.72,-0.82,-0.27,0.0,0.14,-0.41,-0.22,-0.09,0.36,0.21,-0.55,-0.55,-0.21,0.35,0.33,-0.23,-0.52,-0.46,0.48,-0.16,0.01,-0.07,0.03,0.16,0.16,-0.88,-0.29,-0.1,0.07,0.11,-0.81,-0.55,0.26,0.09,-0.19,-0.86,-0.61,0.27,0.01,-0.28,-0.72,-0.66,0.1,0.09,-0.28,-1.11,-0.69,0.26,0.21,-0.54,-1.08,-0.44,0.32,0.19,-0.75,-1.33,-0.27,0.07,0.28,-1.26,-0.92,-0.04,0.09,-0.18,-0.75,-0.34,0.06,0.08,-0.23,-0.64,-0.63,0.09,0.03,-0.48,-0.52,-0.35,0.01,-0.16,-0.48,-0.29,-0.31,0.08,0.08,-0.49,-0.17,-0.25,0.11,0.07,-0.61,-0.44,-0.2,0.01,0.18,-0.71,-0.23,-0.15,0.14,0.03,-0.86,-0.77,-0.16,0.0,0.18,-1.05,-0.11,-0.02,0.27,-0.28,-0.74,-0.31,-0.13,0.12,0.1,-0.9,-0.4,-0.11,0.07,0.13,-0.75,-0.33,-0.02,0.1,0.23,-0.9,-0.15,-0.03,0.27,0.16,-0.65,-0.38,-0.02,0.24,0.15,-1.04,-0.44,0.0,0.16:EPILEPSY
0.74,0.68,0.65,0.66,0.65,0.65,0.65,0.66,0.62,0.62,0.58,0.58,0.6,0.58,0.59,0.57,0.54,0.53,0.54,0.56,0.58,0.58,0.53,0.55,0.57,0.59,0.6,0.61,0.63,0.63,0.65,0.67,0.69,0.72,0.77,0.8,0.8,0.77,0.72,0.64,0.61,0.61,0.63,0.59,0.59,0.58,0.58,0.6,0.58,0.54,0.54,0.52,0.52,0.57,0.59,0.58,0.58,0.6,0.61,0.6,0.59,0.62,0.62,0.64,0.63,0.62,0.62,0.62,0.64,0.68,0.69,0.71,0.75,0.76,0.73,0.67,0.62,0.6,0.62,0.6,0.56,0.53,0.56,0.57,0.56,0.57,0.5,0.5,0.51,0.52,0.51,0.52,0.53,0.54,0.53,0.55,0.57,0.61,0.6,0.61,0.62,0.64,0.66,0.67,0.69,0.69,0.73,0.75,0.78,0.76,0.77,0.69,0.62,0.58,0.61,0.6,0.56,0.55,0.55,0.56,0.56,0.55,0.56,0.55,0.54,0.54,0.55,0.55,0.55,0.54,0.55,0.56,0.57,0.57,0.57,0.58,0.58,0.57,0.61,0.63,0.66,0.65,0.64,0.62,0.65,0.66,0.69,0.73,0.78,0.74,0.67,0.62,0.59,0.54,0.53,0.47,0.46,0.5,0.5,0.49,0.48,0.47,0.48,0.48,0.46,0.47,0.48,0.48,0.49,0.5,0.49,0.49,0.51,0.53,0.55,0.56,0.58,0.58,0.6,0.6,0.61,0.6,0.62,0.63,0.65,0.67,0.67,0.68,0.72,0.76,0.75,0.77,0.78,0.76,0.74,0.72,0.7,0.67,0.62,0.59,0.58,0.57,0.57,0.56,0.55,0.54:1.51,-1.51,-2.46,0.51,1.64,-0.62,-3.02,-0.23,1.76,0.11,-2.81,-0.8,1.3,0.94,-2.14,-1.51,0.41,1.36,-1.71,-2.42,0.18,1.49,-0.92,-2.55,-0.37,1.42,0.34,-2.52,-1.26,1.07,1.19,-1.5,-2.09,0.13,1.29,-0.62,-2.34,-0.89,0.87,0.89,-1.42,-1.88,-0.15,0.83,0.14,-1.6,-1.42,-0.24,0.4,0.14,-1.26,-1.14,0.01,0.53,-0.47,-1.74,-1.21,-0.34,0.01,-0.61,-1.52,-0.86,-0.18,0.15,-0.02,-1.77,-1.72,-0.21,0.68,0.68,-1.21,-1.49,-0.18,1.04,0.84,-1.42,-1.66,-0.09,0.64,0.52,-0.31,-1.13,-0.98,-0.54,0.01,0.5,0.68,-0.22,-1.82,-1.25,0.35,0.84,-1.39,-1.42,0.72,1.5,-1.36,-2.47,0.23,1.57,-1.0,-2.55,0.09,1.76,-0.78,-2.6,-0.49,1.17,0.6,-2.0,-1.62,0.34,1.48,-0.06,-2.53,-0.95,1.29,1.13,-1.97,-2.05,0.48,1.69,-0.99,-2.75,-0.31,1.73,0.87,-2.52,-1.66,0.88,1.46,-1.48,-2.36,0.17,1.52,0.02,-2.79,-0.98,1.26,1.08,-2.08,-2.08,0.61,1.46,-0.6,-2.52,-0.78,1.08,0.89,-1.84,-1.94,0.39,1.18,-0.96,-2.24,-0.08,1.45,0.42,-2.5,-1.69,0.58,1.38,-1.26,-2.65,-0.13,1.59,0.09,-2.48,-1.04,1.25,0.92,-2.33,-1.84,0.5,1.39,-1.1,-2.57,-0.51,1.19,0.72,-2.17,-1.6,0.37,1.34,-0.51,-2.43,-1.16,0.66,1.19,-1.61,-2.13,-0.17,1.32,0.62,-1.94,-1.8,0.26,1.35,-0.09,-2.75,-1.04,0.71,1.14,-1.55,-2.04,0.19:-0.12,-0.14,-0.26,-0.34,-0.29,-0.28,-0.26,-0.25,-0.25,-0.24,-0.21,-0.21,-0.21,-0.2,-0.14,-0.05,0.05,0.1,0.15,0.2,0.1,0.12,0.08,0.1,0.01,-0.04,-0.01,-0.01,-0.03,-0.03,-0.09,-0.04,-0.12,-0.14,-0.15,-0.22,-0.22,-0.25,-0.24,-0.25,-0.3,-0.29,-0.25,-0.27,-0.22,-0.25,-0.29,-0.28,-0.28,-0.26,-0.21,-0.21,-0.15,-0.08,-0.03,-0.06,-0.13,-0.19,-0.22,-0.07,-0.07,-0.16,-0.16,-0.23,-0.17,-0.2,-0.16,-0.22,-0.19,-0.21,-0.26,-0.3,-0.29,-0.31,-0.31,-0.36,-0.31,-0.31,-0.27,-0.28,-0.27,-0.26,-0.24,-0.23,-0.22,-0.19,-0.15,-0.1,-0.03,0.03,0.06,0.09,0.08,-0.05,-0.03,-0.05,-0.04,-0.12,-0.14,-0.12,-0.07,-0.09,-0.07,-0.08,-0.08,-0.08,-0.11,-0.12,-0.14,-0.17,-0.22,-0.24,-0.23,-0.21,-0.24,-0.23,-0.24,-0.28,-0.3,-0.26,-0.24,-0.2,-0.24,-0.29,-0.27,-0.26,-0.24,-0.2,-0.09,0.02,-0.04,-0.11,-0.12,-0.12,-0.05,-0.11,-0.18,-0.15,-0.08,-0.07,-0.09,-0.11,-0.11,-0.11,-0.11,-0.16,-0.14,-0.15,-0.17,-0.18,-0.2,-0.24,-0.23,-0.23,-0.23,-0.24,-0.22,-0.17,-0.18,-0.19,-0.18,-0.18,-0.23,-0.22,-0.21,-0.19,-0.19,-0.19,-0.18,-0.13,-0.09,-0.07,-0.03,0.05,0.05,0.06,0.05,0.07,0.08,0.01,-0.01,-0.03,-0.07,-0.07,-0.04,-0.05,-0.04,-0.04,-0.05,-0.01,-0.03,-0.05,-0.11,-0.15,-0.19,-0.21,-0.26,-0.32,-0.34,-0.34,-0.36,-0.38,-0.48,-0.51,-0.47,-0.42:EPILEPSY
-0.97,-0.89,-0.84,-0.99,-1.09,-1.01,-0.98,-0.93,-0.83,-0.79,-0.81,-0.88,-0.96,-0.97,-1.0,-1.0,-1.02,-1.02,-1.01,-0.94,-0.74,-0.59,-0.42,-0.29,-0.23,-0.14,-0.1,-0.12,-0.13,-0.17,-0.24,-0.31,-0.27,-0.2,-0.18,-0.29,-0.37,-0.52,-0.66,-0.79,-0.93,-1.18,-1.01,-0.95,-1.04,-1.02,-0.93,-0.93,-0.95,-0.84,-0.7,-0.53,-0.36,-0.29,-0.28,-0.26,-0.35,-0.45,-0.55,-0.65,-0.72,-0.75,-0.79,-0.87,-0.87,-0.88,-0.9,-0.87,-0.83,-0.73,-0.65,-0.54,-0.51,-0.43,-0.41,-0.49,-0.3,-0.09,-0.03,0.05,0.12,0.23,0.15,0.12,0.14,-0.07,-0.37,-0.56,-0.49,-0.43,-0.38,-0.36,-0.36,-0.39,-0.4,-0.4,-0.39,-0.43,-0.45,-0.46,-0.44,-0.44,-0.46,-0.52,-0.55,-0.6,-0.4,-0.02,0.05,0.11,0.15,0.12,0.14,0.23,0.26,0.31,0.35,0.39,0.4,0.39,0.37,0.4,0.42,0.49,0.51,0.55,0.54,0.57,0.63,0.66,0.65,0.66,0.58,0.45,0.32,0.26,0.23,0.15,0.09,0.11,0.01,-0.04,-0.01,-0.02,-0.02,-0.04,-0.05,-0.05,-0.06,-0.07,-0.14,-0.21,-0.21,-0.18,-0.16,-0.17,-0.19,-0.21,-0.21,-0.22,-0.16,-0.32,-0.44,-0.56,-0.69,-0.49,-0.46,-0.48,-0.52,-0.54,-0.55,-0.55,-0.57,-0.49,-0.55,-0.54,-0.39,-0.34,-0.35,-0.37,-0.45,-0.4,-0.34,-0.29,-0.36,-0.42,-0.43,-0.43,-0.42,-0.39,-0.4,-0.41,-0.43,-0.51,-0.56,-0.59,-0.49,-0.47,-0.48,-0.48,-0.49,-0.48,-0.48,-0.5,-0.47,-0.47:-0.17,0.35,0.5,0.09,-0.88,0.04,-0.08,0.5,0.29,-0.69,0.06,-0.02,0.55,0.48,-0.08,-0.9,0.05,0.12,0.6,0.39,-0.78,-0.06,0.18,1.01,0.55,-0.71,0.99,-0.25,0.18,0.76,0.84,-1.16,-0.99,-0.33,0.39,1.05,-0.1,-1.36,-0.25,0.63,1.07,-0.43,-1.99,-0.88,-0.01,1.29,1.04,-0.62,-1.39,-0.61,0.06,0.92,0.09,-1.4,-0.2,-0.18,0.76,1.02,-0.54,-1.85,-0.82,-0.02,1.3,1.07,-0.45,-1.54,-0.64,-0.08,0.95,0.22,-1.6,-0.83,-0.25,0.81,1.41,0.0,-2.42,-0.14,0.32,1.01,-0.53,-1.52,-0.44,0.79,1.28,0.08,-1.76,-0.82,0.07,1.52,0.96,-1.65,-0.57,-0.47,1.27,0.84,-1.18,-0.86,-0.41,0.8,0.8,-0.48,-0.94,-0.38,-0.15,1.16,0.58,-1.41,-1.1,-0.17,0.89,0.92,-0.73,-1.25,-0.37,0.77,1.33,0.46,-1.58,-0.89,-0.2,0.87,0.85,0.48,-1.35,-1.23,-0.13,1.25,1.22,-0.36,-1.61,-0.51,0.36,1.26,0.27,-1.49,-0.75,0.44,1.18,0.9,-1.69,-0.31,-0.26,0.46,0.74,-0.66,-0.64,-0.06,0.18,0.11,-0.01,-0.18,-0.85,0.07,0.2,-0.03,-0.24,-0.26,-0.42,-0.35,-0.07,-0.73,-0.29,-0.08,-0.12,-0.22,-0.33,-0.3,-0.27,-0.37,-0.5,-0.4,-0.42,-0.56,-0.49,-0.5,-0.54,-0.78,-0.89,-0.9,-0.78,-0.77,-0.95,-1.2,-1.07,-1.0,-1.08,-0.8,-0.93,-0.98,-0.96,-0.84,-0.72,-0.72,-0.87,-0.94,-0.97,-1.06,-0.93,-0.96,-0.93,-0.91,-0.93,-1.06,-1.2,-1.08:-0.77,-0.44,-0.62,-0.56,-0.59,-0.66,-0.46,-0.73,-0.38,-0.7,-0.57,-0.37,-0.48,-0.5,-0.61,-0.48,-0.71,-0.43,-0.58,-0.64,-0.41,-0.55,-0.44,-0.18,-0.52,-0.33,-0.56,-0.58,-0.67,-0.52,-0.65,-0.59,-0.46,-0.48,-0.62,-0.27,-0.48,-0.43,-0.65,-0.49,-0.31,-0.39,-0.39,-0.42,-0.41,-0.48,-0.44,-0.64,-0.56,-0.61,-0.87,-0.26,-1.0,-0.77,-0.75,-0.9,-0.2,-0.74,-0.41,-0.84,-0.66,-0.43,-0.72,-0.49,-1.0,-0.69,0.15,-1.0,-0.64,-0.45,-0.36,-0.41,-0.62,-0.45,-0.82,-0.69,-0.16,-1.0,-0.55,-0.78,-0.9,-0.24,-0.22,-1.13,-0.52,-0.6,-0.75,-0.26,-0.67,-0.59,-0.41,-0.7,-0.7,-0.3,-0.96,-0.57,-0.63,-0.94,-0.73,0.29,-0.71,-0.64,-0.6,-0.84,-0.2,-0.12,-0.3,-0.47,-0.7,-0.48,-0.64,-0.43,-0.45,-0.73,-0.58,-0.05,-1.35,-0.82,-0.53,-0.62,-0.21,-0.38,-0.69,-0.54,-0.9,-0.44,-0.06,-1.12,-0.43,-0.72,-1.01,-0.23,-0.71,-1.01,-0.58,-0.63,-0.57,-0.37,-0.68,-0.39,-0.94,-0.62,-0.23,-0.61,-0.46,-0.63,-0.57,-0.21,-0.96,-0.67,-0.54,-0.95,-0.28,-0.41,-0.9,-0.5,-0.83,-0.26,-0.37,-0.52,-0.58,-0.82,-0.48,-0.2,-1.13,-0.5,-0.43,-0.59,0.17,-0.79,-0.28,-0.8,-0.74,-0.48,-0.81,-0.44,-0.6,-0.9,-0.69,-0.28,-0.95,-0.3,-0.97,-0.95,-0.47,-0.68,-0.33,-0.42,-0.68,-0.64,-0.05,-0.78,-0.38,-0.85,-0.54,-0.21,-1.01,-0.46,-0.8,-0.49,0.22,-0.7,-0.31,-0.64,-0.33,0.04:EPILEPSY
0.56,0.19,0.8,0.68,0.55,0.5,0.24,0.92,0.73,0.56,0.27,0.24,1.13,0.85,0.7,0.16,0.36,0.4,0.64,0.46,0.13,0.73,0.6,0.45,0.1,0.31,0.58,0.75,0.33,0.01,0.79,0.84,0.42,0.13,0.19,0.98,0.91,0.39,-0.01,0.48,0.74,0.84,0.38,0.05,1.0,0.93,0.64,0.02,0.4,0.82,0.86,0.39,0.1,1.08,0.87,0.74,0.23,0.18,1.25,0.78,0.64,0.26,0.38,1.06,0.72,0.54,0.2,0.68,0.42,0.72,0.52,0.38,1.12,0.74,0.62,0.29,0.65,0.48,0.76,0.71,0.28,1.21,0.68,0.8,0.45,0.46,1.12,0.93,0.7,0.32,1.0,0.72,0.76,0.5,0.45,1.0,0.85,0.75,0.31,0.7,0.47,0.82,0.79,0.43,1.12,0.89,0.64,0.25,0.63,1.3,0.74,0.9,0.32,0.96,0.8,0.64,0.55,0.47,1.23,0.86,0.6,0.34,0.82,0.53,0.64,0.65,0.48,1.33,0.89,0.55,0.17,0.72,0.62,0.83,0.75,0.34,0.86,0.64,0.86,0.73,0.27,0.45,0.43,0.57,0.7,0.57,0.4,0.24,0.44,0.52,0.39,0.55,0.72,0.75,0.76,0.77,0.69,0.72,0.79,0.75,0.68,0.64,0.61,0.54,0.44,0.37,0.25,0.1,0.08,0.14,0.15,0.19,0.27,0.38,0.51,0.6,0.66,0.7,0.7,0.7,0.69,0.68,0.67,0.67,0.66,0.67,0.65,0.64,0.62,0.6,0.6,0.6,0.62,0.64,0.68,0.7,0.73,0.77,0.78,0.78,0.76,0.74,0.72,0.7,0.7,0.7:0.34,0.25,0.18,0.17,0.06,-0.19,-0.47,-0.58,-0.1,-0.47,-0.5,-0.28,0.02,0.08,-0.29,-0.62,-0.8,-0.66,-0.01,0.81,0.56,-1.33,-2.09,-0.28,0.98,-0.37,-2.48,-0.5,0.57,0.54,-2.94,-1.76,0.8,1.14,-2.56,-1.97,0.48,1.6,-2.24,-2.39,0.19,1.35,-1.52,-2.81,-0.78,1.06,-0.84,-3.06,-1.23,0.39,-0.05,-2.96,-1.64,0.68,0.9,-2.25,-2.07,0.18,1.38,-1.18,-2.56,-0.7,0.76,-0.29,-2.98,-1.55,0.67,0.95,-1.91,-1.88,-0.12,1.02,-1.4,-2.65,-0.9,0.15,0.21,-2.1,-1.77,0.04,0.6,-0.83,-1.94,-0.58,0.65,-0.15,-2.51,-1.32,0.69,1.0,-1.13,-1.96,0.29,1.06,-1.14,-2.15,-0.59,0.67,-0.09,-2.67,-0.68,-0.25,0.97,-1.24,-2.26,-0.48,0.64,-0.18,-2.28,-1.24,0.08,0.96,-1.06,-2.18,-0.86,0.58,0.99,-1.44,-1.76,-0.02,0.74,-1.11,-2.08,-0.92,0.3,0.89,-1.6,-0.98,-0.51,0.68,-0.35,-2.02,-1.13,0.45,0.76,-1.59,-1.65,0.18,0.93,-1.36,-2.15,-0.63,0.28,0.25,-1.71,-1.22,0.26,0.99,-1.35,-1.98,-0.46,0.5,-0.09,-1.58,-1.04,0.36,1.02,-1.17,-1.7,-0.41,0.61,0.55,-1.58,-1.5,-0.13,1.2,-0.31,-2.2,-1.2,0.36,0.91,-1.35,-1.61,-0.21,0.65,-0.15,-2.13,-1.13,0.5,1.13,-1.22,-1.96,-0.34,0.56,0.3,-1.67,-1.29,0.34,1.04,-1.26,-1.86,-0.57,0.38,0.8,-1.77,-1.74,0.14,1.16,-1.11,-2.12,-0.73,0.27,0.18,-2.0,-1.36,0.24:0.11,-0.19,-0.61,0.02,0.13,-0.08,-0.27,-0.27,0.0,0.09,-0.06,-0.61,0.12,0.1,-0.03,-0.17,0.19,0.13,0.13,-0.04,-0.62,0.02,0.1,0.02,-0.21,-0.34,-0.09,0.16,0.03,-0.26,-0.21,0.06,0.32,-0.23,-0.64,-0.11,0.13,0.07,-0.23,-0.21,0.04,0.01,-0.08,-0.54,0.1,0.13,0.11,-0.15,-0.41,0.08,0.2,0.01,-0.42,0.14,0.1,0.07,-0.11,-0.67,-0.05,0.01,0.12,0.17,-0.16,0.25,-0.5,-0.23,-0.29,-0.2,-0.42,-0.59,-0.35,-0.18,-0.02,0.1,0.31,0.43,0.46,0.6,0.71,0.8,0.7,0.58,0.64,0.72,0.74,0.79,0.83,0.85,1.05,1.29,1.32,1.2,1.05,0.92,0.77,0.69,0.62,0.58,0.54,0.59,0.71,0.85,0.81,0.65,0.53,0.39,0.26,0.16,0.15,0.06,-0.1,-0.21,-0.09,-0.07,-0.01,0.01,-0.02,-0.01,0.02,0.02,0.01,-0.03,-0.07,-0.11,-0.11,-0.09,-0.02,0.01,-0.01,0.05,0.2,0.29,0.46,0.54,0.6,0.67,0.72,0.72,0.7,0.81,0.59,0.69,0.7,0.6,0.59,0.73,0.77,0.74,0.78,0.98,1.14,1.13,1.04,0.98,0.88,0.79,0.76,0.74,0.7,0.7,0.67,0.63,0.63,0.58,0.59,0.6,0.55,0.57,0.51,0.55,0.56,0.66,0.66,0.66,0.69,0.76,0.78,0.81,0.87,0.81,0.77,0.85,0.94,1.08,1.13,1.07,1.02,1.06,0.88,0.69,0.48,0.27,0.15,0.09,0.06,0.0,-0.04,-0.04,-0.03,-0.04,-0.07,-0.06,-0.02,-0.08,-0.13,-0.19:EPILEPSY
-1.18,-1.22,-1.16,-0.94,-0.82,-0.79,-0.88,-1.14,-1.47,-1.32,-1.27,-1.13,-0.83,-0.72,-0.7,-0.78,-0.98,-1.21,-1.21,-1.14,-1.0,-0.84,-0.77,-0.8,-0.93,-1.27,-1.49,-1.29,-1.26,-1.13,-0.89,-0.8,-0.76,-0.78,-0.93,-1.12,-1.13,-1.21,-1.08,-0.85,-0.81,-0.86,-0.97,-1.33,-1.47,-1.35,-1.34,-1.13,-0.86,-0.78,-0.74,-0.81,-0.95,-1.06,-1.12,-1.23,-1.05,-0.86,-0.84,-0.88,-0.92,-1.35,-1.46,-1.29,-1.33,-1.08,-0.83,-0.74,-0.72,-0.83,-1.0,-1.12,-1.12,-1.16,-1.02,-0.85,-0.8,-0.84,-0.91,-1.22,-1.46,-1.36,-1.3,-1.13,-0.85,-0.71,-0.69,-0.73,-0.96,-1.2,-1.21,-1.24,-1.07,-0.8,-0.73,-0.81,-0.93,-1.28,-1.44,-1.29,-1.33,-1.14,-0.88,-0.76,-0.71,-0.79,-1.02,-1.19,-1.19,-1.22,-1.01,-0.83,-0.81,-0.84,-1.0,-1.4,-1.5,-1.37,-1.3,-1.06,-0.82,-0.72,-0.72,-0.88,-1.07,-1.18,-1.26,-1.24,-1.0,-0.82,-0.78,-0.8,-1.0,-1.46,-1.46,-1.42,-1.34,-1.01,-0.81,-0.72,-0.69,-0.9,-1.1,-1.21,-1.26,-1.18,-0.92,-0.83,-0.82,-0.87,-1.2,-1.53,-1.4,-1.4,-1.22,-0.91,-0.77,-0.72,-0.79,-0.96,-1.11,-1.2,-1.3,-1.12,-0.89,-0.82,-0.84,-0.96,-1.32,-1.48,-1.38,-1.34,-1.16,-0.88,-0.76,-0.71,-0.82,-0.98,-1.12,-1.26,-1.27,-0.96,-0.8,-0.82,-0.88,-1.07,-1.46,-1.42,-1.35,-1.26,-0.98,-0.79,-0.75,-0.76,-0.95,-1.12,-1.18,-1.26,-1.06,-0.85,-0.82,-0.84,-0.93,-1.27,-1.47,-1.4:-0.26,-0.2,-0.18,-0.17,-0.14,-0.14,-0.25,-0.42,-0.42,-0.31,-0.29,-0.39,-0.48,-0.52,-0.48,-0.44,-0.34,-0.29,-0.25,-0.2,-0.18,-0.15,-0.12,-0.13,-0.25,-0.47,-0.41,-0.25,-0.29,-0.47,-0.52,-0.5,-0.45,-0.42,-0.32,-0.28,-0.25,-0.19,-0.15,-0.14,-0.11,-0.13,-0.23,-0.48,-0.53,-0.31,-0.27,-0.41,-0.5,-0.54,-0.52,-0.43,-0.34,-0.29,-0.26,-0.19,-0.18,-0.15,-0.16,-0.18,-0.25,-0.41,-0.35,-0.32,-0.32,-0.36,-0.36,-0.36,-0.34,-0.38,-0.44,-0.39,-0.28,-0.25,-0.2,-0.18,-0.15,-0.13,-0.14,-0.29,-0.45,-0.36,-0.32,-0.38,-0.48,-0.44,-0.45,-0.42,-0.36,-0.31,-0.24,-0.24,-0.19,-0.18,-0.15,-0.14,-0.22,-0.37,-0.41,-0.29,-0.28,-0.32,-0.42,-0.45,-0.44,-0.44,-0.42,-0.34,-0.25,-0.21,-0.17,-0.16,-0.13,-0.12,-0.19,-0.35,-0.41,-0.34,-0.35,-0.43,-0.48,-0.46,-0.43,-0.38,-0.37,-0.32,-0.26,-0.21,-0.19,-0.19,-0.13,-0.15,-0.19,-0.35,-0.47,-0.37,-0.29,-0.33,-0.42,-0.45,-0.45,-0.39,-0.32,-0.32,-0.27,-0.22,-0.2,-0.17,-0.15,-0.14,-0.2,-0.36,-0.43,-0.31,-0.27,-0.34,-0.44,-0.44,-0.43,-0.41,-0.39,-0.29,-0.24,-0.24,-0.19,-0.15,-0.13,-0.15,-0.21,-0.37,-0.44,-0.31,-0.25,-0.34,-0.48,-0.5,-0.48,-0.46,-0.37,-0.31,-0.26,-0.22,-0.18,-0.17,-0.13,-0.11,-0.19,-0.38,-0.41,-0.29,-0.29,-0.39,-0.5,-0.52,-0.48,-0.46,-0.34,-0.27,-0.25,-0.2,-0.16,-0.15,-0.11,-0.11,-0.22,-0.41:-0.04,-0.07,-0.07,-0.17,-0.17,-0.05,-0.05,0.06,0.09,0.07,0.05,0.07,0.07,0.08,0.08,0.02,-0.1,-0.1,-0.1,-0.12,-0.19,-0.21,-0.08,-0.01,0.0,0.09,0.1,0.05,0.05,0.07,0.07,0.06,0.07,-0.06,-0.09,-0.06,-0.09,-0.11,-0.19,-0.17,0.0,0.0,0.05,0.09,0.03,0.03,0.08,0.09,0.13,0.12,0.0,-0.09,-0.11,-0.07,-0.07,-0.08,-0.09,-0.03,-0.03,0.11,0.11,0.05,0.07,0.09,0.11,0.12,0.1,-0.07,-0.09,-0.1,-0.07,-0.12,-0.11,-0.06,-0.01,0.06,0.11,0.04,0.02,0.05,0.11,0.15,0.1,-0.02,-0.11,-0.14,-0.14,-0.18,-0.19,-0.13,0.01,0.07,0.11,0.08,0.01,0.03,0.09,0.14,0.17,0.1,-0.04,-0.05,-0.07,-0.09,-0.16,-0.15,-0.02,0.02,0.07,0.07,0.04,0.04,0.07,0.1,0.15,0.12,-0.05,-0.07,-0.1,-0.1,-0.14,-0.21,-0.13,-0.06,0.02,0.09,0.07,0.04,0.06,0.1,0.13,0.1,0.01,-0.11,-0.12,-0.11,-0.11,-0.18,-0.19,-0.05,-0.03,0.07,0.11,0.05,0.04,0.07,0.1,0.1,0.11,-0.02,-0.09,-0.05,-0.11,-0.13,-0.19,-0.11,0.0,0.02,0.11,0.1,0.05,0.05,0.08,0.12,0.13,0.06,-0.12,-0.06,-0.07,-0.1,-0.15,-0.15,-0.03,-0.01,0.08,0.12,0.06,0.03,0.06,0.1,0.11,0.11,0.0,-0.09,-0.03,-0.07,-0.11,-0.16,-0.14,-0.05,-0.01,0.1,0.09,0.03,0.05,0.1,0.14,0.14,0.1,-0.07,-0.09,-0.07,-0.1,-0.17,-0.19,-0.05:WALKING
-0.91,-0.8,-0.8,-1.0,-1.11,-1.14,-1.18,-1.17,-0.8,-0.64,-0.85,-1.2,-1.47,-1.39,-1.38,-1.44,-1.02,-0.79,-0.81,-0.99,-1.16,-1.17,-1.29,-1.18,-0.75,-0.6,-0.88,-1.17,-1.32,-1.42,-1.62,-1.46,-0.98,-0.8,-0.88,-1.09,-1.1,-1.13,-1.28,-1.06,-0.72,-0.77,-1.04,-1.27,-1.39,-1.46,-1.62,-1.36,-0.95,-0.84,-0.94,-1.17,-1.11,-1.11,-1.27,-1.02,-0.78,-0.91,-1.16,-1.44,-1.36,-1.37,-1.66,-1.4,-1.01,-0.93,-1.04,-1.23,-1.08,-0.97,-1.13,-1.04,-0.77,-0.84,-1.19,-1.44,-1.44,-1.32,-1.46,-1.51,-1.1,-0.91,-0.88,-1.01,-1.17,-1.08,-1.12,-1.32,-0.94,-0.73,-0.88,-1.2,-1.46,-1.34,-1.47,-1.69,-1.28,-0.99,-0.9,-1.04,-1.2,-1.06,-1.07,-1.26,-1.0,-0.81,-0.92,-1.18,-1.39,-1.37,-1.36,-1.63,-1.3,-0.92,-0.84,-0.91,-1.07,-1.07,-1.16,-1.3,-1.1,-0.78,-0.73,-0.92,-1.35,-1.41,-1.33,-1.63,-1.38,-0.94,-0.81,-0.82,-1.14,-1.16,-1.13,-1.24,-1.13,-0.73,-0.57,-0.86,-1.27,-1.34,-1.38,-1.66,-1.54,-0.97,-0.83,-0.85,-1.13,-1.17,-1.11,-1.14,-1.12,-0.83,-0.8,-1.01,-1.33,-1.38,-1.38,-1.66,-1.44,-0.96,-0.82,-0.91,-1.17,-1.12,-1.08,-1.23,-1.12,-0.8,-0.73,-0.96,-1.34,-1.41,-1.38,-1.61,-1.26,-0.9,-0.85,-0.96,-1.24,-1.12,-1.01,-1.19,-1.04,-0.75,-0.75,-1.0,-1.33,-1.39,-1.37,-1.58,-1.34,-0.97,-0.88,-0.95,-1.13,-0.99,-1.06,-1.28,-1.13,-0.79,-0.72,-0.95,-1.28,-1.42:-1.24,-1.22,-1.25,-1.13,-0.88,-0.38,0.01,0.13,-0.05,-0.67,-1.29,0.59,0.84,0.1,0.09,0.21,0.13,-0.13,-1.16,-1.61,-1.48,-1.16,-0.62,-0.22,0.0,0.16,-0.4,-1.01,-0.66,0.01,-0.02,-0.04,0.17,0.05,-0.62,-1.17,-1.12,-1.1,-0.81,-0.15,-0.09,-0.15,-0.58,0.07,-0.43,-0.47,-0.63,0.02,0.14,0.07,-0.62,-1.08,-1.28,-1.27,-1.09,-0.44,-0.18,-0.13,-0.27,-0.32,-1.02,-0.48,-0.14,0.01,-0.08,0.05,0.18,0.21,0.09,-0.56,-0.85,-0.24,0.39,0.09,-0.31,-0.39,-0.11,-0.32,-0.42,1.16,-0.26,-0.11,0.09,0.24,0.02,0.11,0.4,0.46,-0.62,-1.21,-1.76,-0.18,0.37,0.37,0.15,0.75,0.27,-0.27,-0.2,-0.22,-0.46,-0.38,0.17,0.36,-0.36,-0.8,0.22,1.22,0.46,-0.31,-0.71,-0.66,-0.65,-0.47,-0.12,0.23,0.22,-0.03,-0.57,-0.75,0.0,-0.67,-0.22,-0.59,-0.8,-0.15,0.22,0.29,-1.64,-0.34,0.76,0.03,-0.13,-0.35,-0.4,-0.06,0.12,-0.99,-1.87,-1.35,-0.77,-0.1,0.43,0.35,-0.28,-0.73,-0.64,0.09,0.3,-0.39,-0.99,-0.36,-0.31,-0.27,-0.42,-0.7,-0.52,0.14,0.52,0.37,0.13,-0.47,-0.53,-0.47,-0.24,-0.22,-0.05,0.05,-0.59,-0.83,-0.5,-0.38,-0.28,-0.36,-0.49,0.52,0.58,0.26,0.19,0.3,-0.16,-0.56,-0.59,0.34,0.35,-0.54,-0.56,-0.43,-0.47,-0.21,-0.12,-0.12,0.08,0.2,0.1,0.05,0.09,-0.2,-0.2,-0.2,-0.35,-0.38,-0.56,-0.49,-0.02,0.5:0.35,0.47,0.34,0.35,0.2,0.08,0.08,0.13,0.21,0.3,0.26,0.58,0.45,0.19,0.21,0.23,0.28,0.44,0.22,0.17,0.25,0.06,0.16,0.16,0.23,0.28,0.21,0.43,0.44,0.14,0.19,0.25,0.35,0.41,0.29,0.2,0.21,0.07,0.08,0.14,0.19,0.25,0.22,0.47,0.38,0.17,0.21,0.23,0.34,0.38,0.28,0.25,0.12,0.06,0.11,0.18,0.23,0.28,0.24,0.41,0.33,0.15,0.18,0.23,0.38,0.39,0.32,0.29,0.16,0.04,0.09,0.11,0.21,0.22,0.22,0.43,0.32,0.14,0.18,0.23,0.31,0.4,0.33,0.3,0.19,0.07,0.1,0.13,0.21,0.29,0.28,0.51,0.31,0.14,0.19,0.21,0.38,0.41,0.41,0.35,0.22,0.05,0.1,0.11,0.2,0.29,0.33,0.56,0.32,0.17,0.21,0.28,0.4,0.38,0.35,0.29,0.18,0.1,0.12,0.12,0.16,0.29,0.38,0.48,0.21,0.17,0.22,0.31,0.42,0.43,0.38,0.3,0.21,0.1,0.11,0.11,0.19,0.27,0.37,0.51,0.2,0.19,0.24,0.28,0.42,0.41,0.33,0.22,0.08,0.08,0.1,0.15,0.21,0.25,0.43,0.46,0.18,0.2,0.23,0.3,0.37,0.28,0.29,0.26,0.1,0.1,0.14,0.17,0.24,0.24,0.45,0.36,0.15,0.18,0.24,0.36,0.4,0.41,0.3,0.18,0.1,0.09,0.1,0.1,0.27,0.26,0.45,0.31,0.16,0.2,0.25,0.38,0.39,0.36,0.24,0.17,0.1,0.1,0.1,0.12,0.29,0.28,0.47,0.31,0.16,0.19:WALKING
-1.46,-1.06,-0.89,-0.97,-1.13,-1.09,-1.05,-1.13,-1.28,-0.96,-0.85,-1.02,-1.28,-1.51,-1.35,-1.46,-1.63,-1.32,-1.04,-0.97,-1.05,-1.1,-0.99,-1.1,-1.29,-1.13,-0.86,-0.94,-1.2,-1.39,-1.37,-1.34,-1.53,-1.53,-1.17,-1.0,-0.95,-1.02,-1.05,-1.0,-1.07,-1.32,-1.06,-0.91,-1.05,-1.2,-1.39,-1.26,-1.34,-1.51,-1.33,-1.01,-0.91,-0.97,-1.22,-1.13,-1.05,-1.21,-1.11,-0.8,-0.82,-1.08,-1.39,-1.37,-1.34,-1.58,-1.47,-1.12,-0.98,-0.92,-1.06,-1.16,-1.08,-1.18,-1.23,-0.92,-0.82,-1.06,-1.36,-1.46,-1.34,-1.46,-1.66,-1.29,-1.01,-0.95,-1.02,-1.14,-1.12,-1.1,-1.29,-1.08,-0.87,-0.98,-1.19,-1.44,-1.39,-1.3,-1.54,-1.39,-1.04,-0.85,-0.94,-1.22,-1.12,-1.06,-1.21,-1.16,-0.92,-0.94,-1.16,-1.35,-1.37,-1.34,-1.54,-1.47,-1.12,-0.99,-0.99,-1.14,-1.13,-1.02,-1.11,-1.2,-0.96,-0.92,-1.08,-1.17,-1.39,-1.35,-1.42,-1.59,-1.24,-1.0,-0.93,-1.0,-1.12,-1.04,-1.1,-1.26,-1.08,-0.85,-0.88,-1.08,-1.34,-1.34,-1.33,-1.53,-1.34,-1.02,-0.92,-0.91,-1.07,-1.1,-1.13,-1.24,-1.2,-0.83,-0.73,-0.9,-1.18,-1.4,-1.41,-1.5,-1.45,-1.06,-0.83,-0.75,-0.93,-1.19,-1.11,-1.16,-1.23,-0.97,-0.71,-0.74,-0.95,-1.34,-1.42,-1.36,-1.53,-1.5,-1.08,-0.88,-0.82,-0.89,-1.1,-1.13,-1.17,-1.28,-1.0,-0.78,-0.82,-1.05,-1.36,-1.35,-1.35,-1.58,-1.37,-1.08,-0.97,-0.94,-1.04,-1.06,-1.1,-1.13:0.01,-0.04,0.03,0.28,0.35,0.09,0.07,0.02,0.01,-0.17,-0.35,-0.32,-0.15,-0.23,-0.27,-0.03,-0.04,-0.08,-0.02,0.18,0.31,0.2,0.13,0.04,-0.02,-0.12,-0.25,-0.31,-0.29,-0.28,-0.3,-0.1,0.01,-0.03,-0.02,0.09,0.31,0.19,-0.01,0.07,0.03,-0.15,-0.36,-0.32,-0.28,-0.18,-0.27,-0.25,-0.08,-0.01,-0.01,0.07,0.24,0.2,-0.01,0.06,0.08,-0.06,-0.23,-0.32,-0.32,-0.21,-0.28,-0.31,-0.12,-0.03,-0.05,0.0,0.16,0.32,0.13,0.07,0.12,0.01,-0.12,-0.28,-0.34,-0.25,-0.13,-0.23,-0.15,-0.08,-0.08,-0.04,0.05,0.2,0.11,0.07,0.18,0.01,-0.09,-0.18,-0.32,-0.36,-0.18,-0.14,-0.29,-0.13,0.0,-0.04,-0.03,0.07,0.18,0.14,0.01,0.07,0.0,-0.07,-0.23,-0.32,-0.24,-0.18,-0.35,-0.29,-0.03,0.03,-0.05,-0.02,0.15,0.19,0.05,0.05,0.08,-0.07,-0.17,-0.28,-0.32,-0.32,-0.2,-0.25,-0.17,-0.05,-0.05,-0.05,0.03,0.18,0.24,0.07,0.01,-0.02,-0.05,-0.18,-0.31,-0.29,-0.18,-0.29,-0.27,-0.09,-0.02,-0.04,0.0,0.18,0.25,0.12,0.12,0.01,-0.04,-0.1,-0.24,-0.31,-0.29,-0.17,-0.3,-0.25,-0.05,-0.01,-0.01,0.07,0.23,0.27,0.1,0.1,0.05,-0.01,-0.17,-0.34,-0.33,-0.21,-0.29,-0.22,-0.04,-0.03,-0.04,0.04,0.23,0.26,0.0,0.0,0.03,-0.03,-0.2,-0.29,-0.32,-0.2,-0.24,-0.28,-0.06,-0.04,-0.08,-0.01,0.18,0.28,0.14,0.08,0.07,0.03:0.21,0.22,0.42,0.23,0.11,0.19,0.21,0.42,0.38,0.48,0.25,0.12,0.16,0.15,0.18,0.21,0.22,0.55,0.47,0.21,0.28,0.42,0.48,0.36,0.33,0.36,0.23,0.15,0.18,0.17,0.16,0.26,0.31,0.52,0.27,0.2,0.28,0.38,0.54,0.38,0.31,0.19,0.07,0.08,0.05,0.0,0.09,0.27,0.44,0.52,0.22,0.21,0.26,0.3,0.39,0.37,0.35,0.34,0.17,0.12,0.18,0.23,0.32,0.22,0.44,0.63,0.28,0.21,0.29,0.38,0.5,0.39,0.45,0.22,0.08,0.11,0.11,0.12,0.33,0.28,0.62,0.48,0.18,0.28,0.35,0.45,0.38,0.34,0.34,0.1,0.08,0.12,0.13,0.23,0.34,0.34,0.61,0.42,0.26,0.32,0.39,0.46,0.43,0.42,0.38,0.19,0.16,0.13,-0.03,-0.04,0.16,0.43,0.52,0.27,0.37,0.59,0.64,0.54,0.42,0.17,-0.16,-0.26,0.02,-0.16,-0.18,0.29,0.58,0.52,0.23,0.26,0.39,0.5,0.45,0.32,0.17,0.12,0.07,0.2,0.2,0.05,0.22,0.28,0.65,0.4,0.15,0.31,0.45,0.56,0.33,0.38,0.25,0.13,0.18,0.22,0.1,0.12,0.27,0.56,0.58,0.23,0.29,0.52,0.71,0.57,0.51,0.3,0.14,0.09,0.14,0.16,0.15,0.26,0.35,0.61,0.32,0.19,0.29,0.34,0.57,0.48,0.46,0.14,-0.04,0.05,0.12,0.12,0.18,0.24,0.38,0.5,0.24,0.25,0.31,0.34,0.54,0.46,0.38,0.14,0.03,0.05,0.09,0.14,0.27,0.26,0.53,0.58:WALKING
-1.35,-1.39,-1.39,-1.26,-1.01,-1.26,-1.09,-1.05,-1.52,-1.95,-1.34,-1.02,-1.25,-1.72,-1.27,-1.24,-1.42,-1.51,-1.11,-0.91,-0.97,-1.13,-1.63,-1.96,-1.46,-1.06,-1.12,-1.7,-1.39,-1.35,-1.49,-1.47,-1.24,-1.1,-1.05,-1.0,-1.1,-1.87,-1.67,-1.09,-1.01,-1.61,-1.58,-1.29,-1.39,-1.32,-1.28,-1.12,-1.18,-1.13,-1.07,-1.58,-1.66,-1.13,-1.0,-1.51,-1.66,-1.41,-1.42,-1.26,-1.23,-1.35,-1.42,-1.24,-1.13,-1.52,-1.51,-1.17,-1.09,-1.71,-1.62,-1.36,-1.32,-1.34,-1.26,-1.16,-1.28,-1.12,-1.13,-1.83,-1.64,-1.17,-0.99,-1.33,-1.46,-1.38,-1.41,-1.47,-1.11,-1.06,-1.26,-1.14,-1.13,-1.7,-1.63,-1.18,-0.92,-1.16,-1.49,-1.28,-1.25,-1.32,-1.19,-1.08,-1.37,-1.26,-1.16,-1.48,-1.5,-1.09,-1.01,-1.55,-1.64,-1.36,-1.26,-1.23,-1.13,-1.12,-1.34,-1.16,-1.13,-1.79,-1.67,-1.16,-1.06,-1.39,-1.49,-1.32,-1.23,-1.28,-1.35,-1.22,-1.26,-1.11,-1.12,-1.66,-1.6,-1.13,-0.89,-1.32,-1.51,-1.39,-1.35,-1.26,-1.21,-1.14,-1.29,-1.19,-1.18,-1.65,-1.62,-1.26,-0.99,-1.28,-1.52,-1.2,-1.25,-1.32,-1.47,-1.18,-1.36,-1.26,-1.12,-1.41,-1.77,-1.36,-1.02,-1.11,-1.76,-1.44,-1.23,-1.13,-1.19,-1.29,-1.39,-1.19,-1.21,-1.46,-1.67,-1.26,-1.01,-1.36,-1.7,-1.26,-1.27,-1.33,-1.46,-1.26,-1.18,-1.08,-1.06,-1.57,-2.07,-1.63,-1.24,-1.46,-1.48,-1.11,-1.36,-1.58,-1.3,-1.05,-1.13,-1.16,-1.1,-1.27:-0.22,-0.21,-0.24,-0.25,-0.28,-0.21,-0.18,-0.16,-0.36,-0.45,-0.55,-0.44,-0.4,-0.31,-0.29,-0.33,-0.21,-0.17,-0.2,-0.26,-0.28,-0.21,-0.19,-0.25,-0.34,-0.46,-0.57,-0.4,-0.37,-0.32,-0.27,-0.28,-0.25,-0.2,-0.23,-0.25,-0.3,-0.22,-0.17,-0.24,-0.34,-0.45,-0.5,-0.43,-0.42,-0.32,-0.28,-0.3,-0.24,-0.2,-0.22,-0.28,-0.29,-0.26,-0.21,-0.24,-0.31,-0.39,-0.52,-0.5,-0.4,-0.38,-0.31,-0.27,-0.26,-0.22,-0.23,-0.25,-0.28,-0.25,-0.18,-0.23,-0.29,-0.39,-0.5,-0.49,-0.4,-0.35,-0.32,-0.32,-0.29,-0.19,-0.14,-0.18,-0.24,-0.24,-0.17,-0.19,-0.27,-0.38,-0.5,-0.5,-0.37,-0.37,-0.31,-0.27,-0.2,-0.16,-0.2,-0.25,-0.28,-0.27,-0.17,-0.19,-0.25,-0.37,-0.5,-0.54,-0.39,-0.32,-0.31,-0.34,-0.31,-0.22,-0.18,-0.26,-0.26,-0.3,-0.23,-0.19,-0.24,-0.36,-0.44,-0.55,-0.43,-0.41,-0.34,-0.25,-0.27,-0.29,-0.21,-0.21,-0.23,-0.28,-0.24,-0.2,-0.21,-0.32,-0.45,-0.56,-0.48,-0.39,-0.29,-0.28,-0.31,-0.22,-0.18,-0.23,-0.25,-0.28,-0.21,-0.19,-0.26,-0.33,-0.42,-0.54,-0.46,-0.41,-0.31,-0.24,-0.28,-0.23,-0.18,-0.19,-0.22,-0.28,-0.25,-0.22,-0.23,-0.32,-0.45,-0.58,-0.43,-0.37,-0.31,-0.27,-0.28,-0.22,-0.15,-0.17,-0.24,-0.26,-0.21,-0.17,-0.26,-0.34,-0.41,-0.51,-0.46,-0.39,-0.31,-0.27,-0.29,-0.2,-0.16,-0.22,-0.23,-0.27,-0.17,-0.17,-0.26,-0.33,-0.46,-0.6,-0.49,-0.33:0.34,0.2,0.02,-0.09,-0.21,-0.31,-0.02,0.45,0.82,0.59,0.23,0.65,1.33,1.75,1.8,1.35,1.04,0.97,0.86,0.77,0.63,0.59,0.44,0.32,0.31,0.77,1.58,1.64,1.34,0.83,-0.13,-0.36,-0.14,-0.15,-0.11,0.08,0.18,0.2,0.35,0.44,0.24,0.13,0.39,0.7,0.66,0.37,-0.06,-0.23,-0.24,-0.21,-0.16,-0.21,-0.23,-0.16,-0.25,-0.41,-0.44,-0.46,-0.51,-0.68,-0.53,-0.29,-0.25,-0.11,0.1,0.1,0.22,0.5,0.5,0.32,0.2,0.04,-0.07,-0.31,-0.58,-0.84,-0.95,-0.86,-0.56,-0.44,-0.02,-0.12,-0.12,0.03,0.07,0.01,0.0,0.04,0.08,0.16,0.26,0.51,0.72,0.67,0.33,-0.21,-0.66,-0.76,-0.64,-0.25,0.03,0.23,0.24,0.23,0.29,0.5,0.95,1.12,1.64,1.72,1.45,1.11,1.07,1.17,1.26,1.23,1.07,0.78,0.29,-0.05,-0.2,-0.31,-0.25,-0.05,0.13,0.01,-0.15,-0.36,-0.37,-0.44,-0.48,-0.77,-1.0,-1.06,-0.69,-0.44,-0.41,-0.47,-0.62,-0.57,-0.56,-0.67,-0.66,-0.52,-0.32,-0.03,0.13,0.25,0.17,-0.08,-0.37,-0.68,-0.75,-0.58,-0.53,-0.27,0.03,0.11,0.19,0.18,0.12,0.04,-0.09,-0.11,0.05,0.44,0.59,0.39,0.25,0.18,0.43,0.65,0.86,0.83,0.71,0.36,0.5,0.38,0.32,0.4,0.38,0.29,0.22,0.16,0.15,0.18,0.23,0.35,0.46,0.39,0.12,-0.15,-0.46,-0.68,-0.65,-0.43,-0.18,-0.04,0.01,0.05,0.1,0.16,0.27,0.49,0.9,0.97:WALKING
0.99,1.13,1.3,1.34,1.53,1.58,1.11,0.86,0.76,0.72,0.87,0.95,1.13,1.48,1.22,0.95,1.04,1.07,1.16,1.3,1.44,1.62,1.32,0.86,0.58,0.49,0.85,1.29,1.36,1.34,1.2,0.8,0.73,0.96,1.17,1.32,1.35,1.53,1.51,1.04,0.81,0.78,0.8,1.04,0.97,0.82,0.89,0.65,0.53,0.68,0.99,1.4,1.4,1.38,1.48,1.16,0.9,0.82,0.84,1.02,1.0,1.01,1.23,1.14,0.91,0.97,1.09,1.25,1.32,1.39,1.57,1.39,0.99,0.86,0.81,0.96,0.99,0.86,1.12,1.35,1.16,0.93,0.98,1.25,1.47,1.44,1.6,1.47,0.94,0.7,0.8,1.11,1.06,1.01,1.2,1.28,0.96,1.0,1.26,1.35,1.37,1.61,1.54,1.06,0.84,1.09,1.32,0.91,0.77,0.98,1.11,0.95,0.92,1.12,1.26,1.29,1.59,1.44,0.95,0.66,0.69,0.9,0.96,1.06,1.32,1.28,0.85,0.64,0.93,1.19,1.38,1.58,1.53,1.08,0.8,0.75,0.74,0.89,0.86,1.18,1.66,1.28,0.81,0.94,1.06,1.25,1.26,1.54,1.58,1.18,0.93,0.88,0.87,0.93,0.8,1.04,1.44,1.19,0.93,1.08,1.23,1.3,1.42,1.66,1.41,1.01,0.86,0.91,1.08,0.99,0.87,1.1,1.27,1.07,0.96,1.08,1.23,1.34,1.45,1.59,1.28,0.95,0.85,0.79,1.0,1.02,1.0,1.19,1.2,0.94,0.98,1.16,1.26,1.34,1.46,1.61,1.22,0.92,0.89,1.11,1.24,0.99,0.91,1.19,1.09,0.83:0.68,0.54,0.45,0.4,0.32,0.22,0.15,0.08,0.2,0.37,0.42,0.48,0.7,0.77,0.69,0.79,0.67,0.48,0.35,0.23,0.18,0.16,0.21,0.26,0.49,0.49,0.48,0.51,0.62,0.91,0.98,0.95,0.77,0.65,0.44,0.28,0.18,0.16,0.23,0.45,0.56,0.57,0.67,0.89,0.95,0.88,0.86,0.62,0.47,0.34,0.24,0.18,0.14,0.19,0.19,0.3,0.4,0.41,0.6,0.74,0.78,0.72,0.7,0.61,0.57,0.54,0.44,0.28,0.16,0.17,0.31,0.39,0.42,0.39,0.58,0.71,0.71,0.68,0.69,0.66,0.86,0.77,0.53,0.3,0.12,0.16,0.42,0.48,0.52,0.65,0.89,1.0,0.86,0.76,0.55,0.48,0.3,0.24,0.21,0.25,0.3,0.53,0.6,0.52,0.52,0.55,0.62,0.71,0.79,0.65,0.57,0.64,0.81,0.72,0.5,0.31,0.23,0.35,0.37,0.63,0.81,0.64,0.7,0.65,0.73,0.54,0.44,0.41,0.3,0.21,0.15,0.18,0.26,0.32,0.44,0.48,0.54,0.7,0.67,0.63,0.49,0.45,0.36,0.3,0.13,0.09,0.14,0.32,0.41,0.47,0.58,0.55,0.67,0.61,0.66,0.58,0.53,0.48,0.24,0.12,0.15,0.23,0.38,0.37,0.38,0.51,0.71,0.63,0.65,0.68,0.63,0.42,0.34,0.26,0.18,0.1,0.16,0.18,0.27,0.31,0.37,0.63,0.67,0.65,0.61,0.47,0.46,0.39,0.28,0.21,0.16,0.1,0.17,0.24,0.32,0.35,0.38,0.5,0.68,0.67,0.56,0.49,0.37,0.29,0.29,0.22:-0.16,-0.23,-0.11,-0.4,-0.3,-0.52,-0.63,-0.87,-1.02,-1.23,-1.2,-1.04,-0.8,-0.71,-0.67,-0.66,-0.43,-0.06,0.39,0.34,0.17,0.07,-0.12,-0.25,-0.39,-0.14,-0.17,-0.28,-0.25,-0.29,-0.4,-0.42,-0.42,-0.18,-0.06,-0.31,-0.31,-0.35,-0.45,-0.55,0.08,0.63,0.87,0.82,0.64,0.5,0.07,-0.58,-1.46,-0.64,0.39,0.59,0.47,0.38,0.49,0.37,0.16,0.18,0.04,0.1,-0.1,-0.23,-0.29,-0.28,-0.38,-0.33,0.07,-0.11,-0.19,-0.16,-0.29,-0.12,-0.25,-0.13,-0.07,-0.07,-0.13,-0.17,-0.17,-0.32,-0.39,-0.52,-0.32,-0.01,0.37,0.51,0.49,0.63,0.56,0.4,-0.35,-0.85,-1.13,-1.28,-1.01,-0.9,-0.89,-0.74,-0.75,-0.77,-0.54,-0.43,-0.43,-0.55,-0.7,-0.87,-1.0,-1.0,-0.88,-0.48,-0.17,-0.08,0.04,0.31,0.34,0.2,-0.08,-0.27,-0.67,-0.97,-1.13,-1.27,-1.3,-0.86,-0.23,0.18,0.3,0.08,-0.23,-0.71,-1.16,-1.16,-1.0,-0.69,-0.61,-0.61,-0.68,-0.84,-1.14,-1.27,-1.11,-0.7,-0.38,-0.07,0.09,0.74,0.68,0.01,-0.4,-0.79,-1.06,-0.89,-0.77,-0.97,-1.08,-0.98,-0.76,-0.51,-0.02,0.58,0.57,0.15,-0.04,-0.28,-0.61,-0.78,-0.63,-0.41,-0.26,-0.2,-0.33,-0.43,-0.55,-0.47,-0.36,-0.45,-0.5,-0.56,-0.48,-0.43,-0.42,-0.43,-0.42,-0.39,-0.48,-0.59,-0.62,-0.68,-0.85,-0.9,-0.67,-0.51,-0.32,-0.09,0.17,0.37,0.29,0.01,-0.12,-0.11,-0.02,0.06,0.23,0.21,-0.07,-0.31:WALKING
1.2,1.21,0.78,0.76,1.12,1.47,1.45,1.55,1.61,1.16,0.88,0.92,1.02,1.09,1.13,1.28,0.9,0.77,1.01,1.36,1.32,1.55,1.64,1.26,0.87,0.88,1.05,1.17,1.24,1.27,1.11,0.8,0.91,1.17,1.39,1.61,1.54,1.45,0.99,0.94,1.06,1.13,1.24,1.06,1.07,0.68,0.71,1.04,1.49,1.48,1.42,1.44,1.04,0.75,0.86,1.07,1.24,1.29,1.33,1.07,0.71,0.7,1.01,1.37,1.54,1.66,1.41,0.95,0.79,0.92,1.12,1.13,1.11,1.23,0.85,0.66,0.85,1.27,1.4,1.57,1.44,1.32,0.94,0.88,1.06,1.16,1.18,1.07,1.14,0.74,0.68,0.98,1.39,1.42,1.59,1.51,1.2,0.83,0.89,1.16,1.2,1.13,0.94,0.98,0.7,0.73,1.0,1.49,1.53,1.52,1.54,1.07,0.73,0.8,1.07,1.17,1.22,0.97,1.0,0.7,0.7,0.94,1.37,1.48,1.46,1.61,1.19,0.72,0.77,1.01,1.17,1.26,1.08,1.07,0.67,0.63,0.93,1.35,1.48,1.54,1.52,1.05,0.76,0.83,1.02,1.13,1.14,1.17,1.13,0.76,0.71,0.97,1.35,1.45,1.58,1.72,1.39,1.05,0.84,0.73,0.7,0.63,0.88,1.05,1.12,0.95,0.73,0.63,0.85,1.24,1.14,0.94,0.76,0.94,0.91,0.96,1.01,1.04,1.1,1.07,0.96,0.7,0.68,0.89,1.09,1.25,1.38,1.3,1.22,0.89,0.77,0.92,1.08,1.21,1.08,1.13,0.8,0.66,0.87,1.19,1.26,1.5,1.59,1.34,0.88,0.82:-0.18,-0.49,-0.73,-0.69,-0.72,-0.54,-0.34,-0.35,-0.26,-0.11,-0.1,-0.14,-0.23,-0.32,-0.3,-0.21,-0.41,-0.5,-0.53,-0.65,-0.43,-0.31,-0.32,-0.25,-0.15,-0.05,-0.04,-0.23,-0.33,-0.28,-0.14,-0.41,-0.52,-0.65,-0.6,-0.45,-0.39,-0.33,-0.28,-0.18,-0.1,-0.07,-0.25,-0.33,-0.2,-0.19,-0.63,-0.75,-0.68,-0.74,-0.71,-0.56,-0.32,-0.19,-0.17,-0.15,-0.15,-0.27,-0.36,-0.32,-0.27,-0.4,-0.51,-0.64,-0.66,-0.58,-0.38,-0.26,-0.21,-0.15,-0.17,-0.16,-0.15,-0.25,-0.33,-0.27,-0.24,-0.45,-0.7,-0.69,-0.6,-0.46,-0.34,-0.29,-0.24,-0.15,-0.11,-0.04,-0.23,-0.31,-0.18,-0.23,-0.47,-0.57,-0.47,-0.5,-0.44,-0.34,-0.29,-0.2,-0.11,-0.05,0.03,-0.1,-0.27,-0.26,-0.25,-0.41,-0.71,-0.7,-0.54,-0.47,-0.33,-0.25,-0.23,-0.15,-0.1,-0.07,-0.11,-0.21,-0.34,-0.28,-0.43,-0.65,-0.69,-0.67,-0.59,-0.4,-0.3,-0.27,-0.2,-0.09,0.0,-0.03,-0.17,-0.28,-0.22,-0.31,-0.4,-0.65,-0.62,-0.54,-0.47,-0.36,-0.28,-0.18,-0.15,-0.11,-0.05,-0.11,-0.21,-0.16,-0.22,-0.38,-0.5,-0.56,-0.51,0.05,0.02,0.16,0.2,0.1,0.0,-0.1,-0.33,-0.5,-0.47,-0.39,-0.36,-0.38,-0.31,-0.38,-0.45,-0.43,-0.41,-0.45,-0.49,-0.62,-0.62,-0.55,-0.49,-0.36,-0.29,-0.25,-0.2,-0.11,-0.08,-0.07,-0.16,-0.25,-0.4,-0.52,-0.56,-0.83,-0.5,-0.32,-0.3,-0.26,-0.13,-0.04,-0.05,-0.08,-0.21,-0.29,-0.28,-0.42:-0.18,-0.1,-0.12,-0.09,-0.14,-0.11,-0.14,-0.14,-0.11,-0.11,-0.11,-0.2,-0.36,-0.36,-0.32,-0.28,-0.19,-0.17,-0.18,-0.17,-0.14,-0.09,-0.11,-0.12,-0.14,-0.13,-0.1,-0.23,-0.31,-0.41,-0.35,-0.29,-0.19,-0.18,-0.16,-0.1,-0.01,-0.01,0.02,-0.04,-0.03,-0.06,-0.15,-0.26,-0.24,-0.26,-0.28,-0.25,-0.15,-0.06,-0.07,-0.01,0.02,0.07,0.06,-0.03,-0.05,-0.07,-0.27,-0.48,-0.5,-0.38,-0.32,-0.24,-0.26,-0.36,-0.32,-0.24,-0.12,-0.15,-0.04,0.3,0.37,0.54,0.62,0.69,0.46,0.13,-0.05,-0.18,-0.12,0.07,0.43,0.89,1.05,0.76,0.34,0.03,0.16,0.34,0.5,0.27,0.18,0.27,0.13,0.15,0.12,0.32,0.41,0.5,0.55,0.47,0.31,0.32,0.3,0.22,0.2,0.2,0.16,0.21,0.09,0.01,-0.09,-0.09,-0.02,-0.02,0.19,0.19,0.18,0.32,0.37,0.36,0.23,0.11,0.02,0.14,0.09,0.04,0.14,0.15,0.18,0.26,0.32,0.19,0.17,0.28,0.28,0.28,0.25,0.19,0.17,0.09,-0.03,-0.02,-0.09,-0.17,-0.14,-0.1,0.03,0.05,0.09,0.15,0.17,0.2,0.19,0.18,0.2,0.14,0.07,-0.05,-0.19,-0.35,-0.34,-0.16,0.01,0.04,0.12,0.21,0.3,0.29,0.22,0.17,0.21,0.18,0.13,-0.06,-0.2,-0.23,-0.13,0.18,0.25,0.07,0.23,0.33,0.26,0.2,0.17,0.18,0.2,0.09,-0.04,-0.23,-0.16,-0.12,0.05,0.2,0.33,0.31,0.39,0.4,0.13,-0.05,-0.12,-0.27,-0.3,-0.24:WALKING
1.16,1.35,1.29,1.24,1.06,0.82,0.78,0.79,0.97,1.18,1.2,1.16,1.13,0.81,0.66,0.76,0.94,1.18,1.37,1.25,1.22,1.18,0.9,0.8,0.78,0.9,1.22,1.25,1.12,1.13,0.86,0.72,0.79,1.07,1.28,1.37,1.33,1.38,1.24,0.9,0.8,0.76,0.87,1.1,1.16,1.21,1.17,0.77,0.67,0.77,0.99,1.26,1.38,1.29,1.3,1.06,0.81,0.74,0.77,1.01,1.24,1.21,1.13,1.04,0.76,0.74,0.84,1.01,1.21,1.34,1.25,1.32,1.13,0.86,0.78,0.78,0.88,1.13,1.19,1.08,1.13,0.88,0.7,0.74,0.87,1.01,1.13,1.25,1.23,1.26,1.06,0.82,0.78,0.83,1.05,1.2,1.12,1.06,1.12,0.9,0.83,0.89,0.96,1.07,1.14,1.26,1.34,1.27,0.98,0.82,0.79,0.85,1.12,1.25,1.11,1.1,1.05,0.8,0.8,0.88,1.01,1.24,1.38,1.24,1.26,1.08,0.81,0.74,0.83,1.09,1.19,1.13,1.1,1.16,0.85,0.74,0.85,0.95,1.17,1.27,1.32,1.39,1.16,0.83,0.72,0.71,0.88,1.12,1.13,1.16,1.25,0.93,0.74,0.78,0.93,1.13,1.27,1.33,1.39,1.16,0.85,0.72,0.75,0.97,1.16,1.13,1.14,1.17,0.84,0.73,0.79,1.0,1.19,1.32,1.33,1.38,0.99,0.75,0.71,0.74,1.01,1.18,1.2,1.29,1.02,0.74,0.66,0.87,1.1,1.19,1.18,1.37,1.29,0.92,0.73,0.72,0.86,1.13,1.25,1.16,1.21,0.88,0.7,0.83,1.04,1.19:0.4,0.33,0.29,0.27,0.21,0.22,0.2,0.22,0.29,0.33,0.44,0.58,0.68,0.67,0.64,0.61,0.47,0.33,0.27,0.21,0.18,0.24,0.34,0.44,0.47,0.38,0.37,0.42,0.47,0.71,0.72,0.68,0.59,0.46,0.35,0.3,0.28,0.29,0.29,0.32,0.29,0.3,0.29,0.34,0.41,0.48,0.58,0.63,0.63,0.61,0.49,0.37,0.31,0.26,0.27,0.31,0.34,0.35,0.36,0.36,0.35,0.39,0.42,0.51,0.62,0.69,0.73,0.76,0.59,0.44,0.34,0.29,0.27,0.23,0.22,0.23,0.22,0.23,0.28,0.35,0.44,0.52,0.59,0.68,0.64,0.55,0.4,0.31,0.26,0.24,0.25,0.23,0.25,0.27,0.28,0.3,0.36,0.4,0.5,0.58,0.63,0.62,0.59,0.44,0.37,0.34,0.31,0.28,0.21,0.23,0.27,0.31,0.31,0.34,0.43,0.48,0.58,0.61,0.69,0.6,0.46,0.3,0.2,0.2,0.22,0.25,0.29,0.36,0.4,0.39,0.39,0.44,0.5,0.6,0.6,0.64,0.56,0.42,0.31,0.21,0.2,0.21,0.22,0.25,0.33,0.39,0.4,0.42,0.47,0.56,0.65,0.68,0.62,0.54,0.4,0.31,0.21,0.2,0.23,0.27,0.3,0.36,0.36,0.37,0.41,0.51,0.64,0.64,0.62,0.61,0.48,0.38,0.29,0.22,0.21,0.21,0.28,0.34,0.37,0.38,0.39,0.49,0.61,0.66,0.65,0.62,0.55,0.39,0.28,0.24,0.24,0.26,0.27,0.28,0.33,0.36,0.38,0.42,0.47,0.56,0.66,0.64,0.6,0.53,0.39,0.31:0.07,0.03,-0.02,-0.06,-0.19,-0.24,-0.2,-0.17,-0.02,0.07,0.07,0.11,0.16,0.21,0.16,0.13,0.05,0.03,-0.04,-0.09,-0.17,-0.32,-0.41,-0.31,-0.14,-0.02,0.03,0.1,0.17,0.26,0.23,0.17,0.07,0.06,0.0,-0.03,-0.05,-0.14,-0.2,-0.25,-0.06,0.03,0.07,0.12,0.19,0.27,0.22,0.22,0.19,0.14,0.06,0.03,-0.05,-0.25,-0.34,-0.23,-0.02,0.11,0.12,0.17,0.23,0.31,0.32,0.24,0.11,0.1,0.05,0.04,-0.14,-0.33,-0.34,-0.21,0.01,0.11,0.1,0.12,0.17,0.21,0.24,0.14,0.05,0.07,0.03,0.0,-0.07,-0.24,-0.32,-0.2,0.0,0.11,0.09,0.13,0.18,0.22,0.18,0.13,0.08,0.05,-0.01,0.03,-0.07,-0.2,-0.27,-0.23,-0.06,0.06,0.08,0.11,0.16,0.22,0.22,0.16,0.1,0.1,0.05,-0.06,-0.16,-0.31,-0.36,-0.23,-0.05,0.11,0.11,0.11,0.15,0.18,0.22,0.15,0.07,0.05,-0.03,-0.1,-0.12,-0.29,-0.39,-0.3,-0.18,0.02,0.06,0.06,0.11,0.16,0.19,0.14,0.11,0.09,-0.01,-0.06,-0.1,-0.22,-0.31,-0.28,-0.13,0.06,0.07,0.07,0.12,0.15,0.23,0.18,0.11,0.07,0.0,-0.08,-0.1,-0.24,-0.33,-0.28,-0.19,0.01,0.06,0.07,0.12,0.16,0.18,0.18,0.06,0.06,0.01,-0.04,-0.11,-0.25,-0.4,-0.35,-0.22,-0.06,0.02,0.04,0.09,0.16,0.21,0.18,0.07,0.04,-0.01,-0.07,-0.08,-0.07,-0.25,-0.23,-0.1,0.08,0.13,0.21,0.21,0.11:WALKING
-0.66,-0.58,-0.49,-0.37,-0.72,-2.48,-1.47,-2.71,-1.26,-0.27,-0.37,-0.39,-1.06,-1.69,-1.67,-1.73,-1.1,-0.77,-0.71,-0.73,-0.62,-0.36,-1.09,-1.74,-0.47,-1.79,-1.46,-0.99,-0.68,-1.3,-1.33,-1.14,-0.72,-0.41,-0.36,-0.35,-0.3,-0.58,-1.3,-1.63,-2.19,-2.19,-1.64,-0.87,-0.44,-0.44,-1.27,-1.88,-2.03,-1.72,-1.37,-1.05,-0.71,-0.67,-1.06,-1.66,-1.4,-1.85,-2.47,-1.58,-0.71,-0.6,-0.64,-1.32,-1.52,-1.76,-1.45,-0.93,-0.84,-0.57,-0.48,-0.4,-0.62,-1.41,-1.49,-1.85,-1.46,-0.64,-0.24,-0.43,-1.36,-2.08,-2.65,-2.08,-1.76,-1.38,-1.0,-0.96,-0.62,-0.98,-1.39,-1.49,-2.23,-1.52,-1.18,-0.97,-1.12,-1.3,-1.53,-1.59,-1.16,-0.98,-1.0,-0.88,-0.98,-0.98,-1.26,-1.14,-1.14,-2.26,-1.62,-1.11,-0.75,-0.8,-1.5,-1.6,-1.66,-1.08,-0.9,-0.97,-1.17,-1.79,-1.05,-1.04,-1.46,-1.88,-1.91,-1.39,-0.9,-0.7,-0.99,-1.45,-1.66,-1.52,-1.08,-0.96,-0.96,-0.87,-1.0,-1.16,-1.42,-1.06,-2.28,-1.66,-1.18,-0.61,-0.65,-1.57,-1.91,-1.88,-1.36,-1.19,-1.16,-0.99,-0.84,-0.91,-1.5,-1.26,-1.95,-2.09,-1.28,-0.75,-0.92,-1.42,-1.38,-1.67,-1.25,-0.85,-0.78,-0.98,-1.13,-1.53,-0.87,-1.09,-2.08,-2.11,-1.7,-0.94,-0.41,-0.87,-1.61,-1.65,-1.88,-1.26,-0.9,-0.89,-0.95,-2.0,-1.42,-0.99,-1.69,-2.2,-1.65,-1.26,-0.6,-0.78,-1.38,-1.36,-1.77,-1.32,-0.89,-0.98,-0.85,-0.78,-0.73,-1.02:0.39,0.2,0.08,-0.08,-0.25,-0.31,-0.33,-0.32,-0.35,-0.03,0.04,0.0,0.1,0.31,0.32,0.3,0.3,0.16,0.05,-0.07,-0.31,-0.41,-0.45,-0.48,-0.31,-0.05,-0.01,0.04,0.18,0.38,0.33,0.41,0.32,0.1,-0.02,-0.11,-0.2,-0.25,-0.28,-0.37,-0.13,0.03,-0.01,0.06,0.27,0.52,0.52,0.55,0.34,0.08,-0.11,-0.18,-0.28,-0.26,-0.25,-0.34,0.01,0.11,0.03,0.08,0.23,0.38,0.34,0.36,0.35,0.12,-0.06,-0.13,-0.17,-0.26,-0.29,-0.39,-0.17,0.05,0.06,0.09,0.28,0.48,0.44,0.6,0.46,0.14,-0.09,-0.12,-0.25,-0.31,-0.32,-0.33,-0.14,0.11,0.16,0.08,0.21,0.46,0.43,0.64,0.44,0.08,-0.04,-0.18,-0.34,-0.32,-0.31,-0.35,-0.1,0.15,0.1,0.18,0.38,0.53,0.91,0.82,0.38,0.15,0.09,-0.14,-0.46,-0.3,-0.17,0.08,0.16,0.21,0.16,0.34,0.41,0.36,0.61,0.64,0.22,0.09,0.02,-0.18,-0.01,-0.12,-0.16,-0.07,0.18,0.05,0.13,0.39,0.56,0.47,0.43,0.19,0.03,-0.09,-0.25,-0.32,-0.23,-0.21,-0.03,0.08,0.06,0.03,0.09,0.24,0.22,0.22,0.24,0.14,-0.04,-0.12,-0.31,-0.32,-0.29,-0.31,-0.32,0.0,0.08,0.02,0.15,0.28,0.3,0.32,0.26,0.08,-0.01,-0.13,-0.33,-0.44,-0.26,-0.23,-0.1,0.05,-0.02,-0.03,0.07,0.19,0.17,0.2,0.2,0.1,-0.04,-0.14,-0.32,-0.34,-0.16,-0.25,-0.27,0.04,0.01,-0.01,0.08,0.26,0.26,0.26:0.22,0.24,0.27,0.31,0.66,0.5,0.25,0.24,0.36,0.51,0.53,0.52,0.31,0.15,0.11,0.19,0.24,0.17,0.21,0.27,0.56,0.32,0.18,0.27,0.27,0.36,0.41,0.45,0.34,0.22,0.07,0.1,0.11,0.11,0.27,0.25,0.59,0.41,0.18,0.23,0.24,0.4,0.46,0.48,0.29,0.05,0.02,0.07,0.07,0.12,0.26,0.24,0.52,0.42,0.2,0.27,0.27,0.29,0.42,0.46,0.33,0.19,0.09,0.15,0.16,0.17,0.27,0.26,0.61,0.53,0.27,0.31,0.29,0.34,0.47,0.46,0.39,0.19,0.11,0.15,0.21,0.25,0.31,0.31,0.62,0.53,0.23,0.26,0.28,0.45,0.47,0.5,0.36,0.24,0.18,0.24,0.28,0.3,0.27,0.33,0.65,0.52,0.24,0.31,0.34,0.37,0.44,0.45,0.34,0.14,0.1,0.26,0.2,0.16,0.33,0.38,0.62,0.43,0.24,0.33,0.53,0.72,0.54,0.32,0.17,-0.01,-0.05,-0.07,-0.12,0.03,0.27,0.43,0.61,0.43,0.35,0.47,0.71,0.62,0.36,0.11,0.12,-0.05,0.05,0.03,0.09,0.25,0.33,0.72,0.48,0.34,0.36,0.56,0.69,0.51,0.23,0.09,-0.11,-0.04,0.07,0.14,0.2,0.28,0.36,0.62,0.38,0.23,0.24,0.33,0.49,0.5,0.39,0.27,0.12,0.09,0.13,0.2,0.25,0.27,0.3,0.5,0.33,0.25,0.3,0.33,0.42,0.46,0.34,0.21,0.1,0.07,0.08,0.08,0.14,0.22,0.32,0.5,0.27,0.18,0.24,0.22,0.34,0.38,0.36,0.3,0.19,0.07:WALKING
1.59,1.38,1.2,1.0,0.74,0.57,0.61,0.79,1.09,1.11,1.23,1.28,1.07,0.89,1.02,1.11,0.88,0.79,0.76,0.81,0.88,0.94,1.13,1.39,1.29,1.13,0.98,0.91,0.85,0.79,0.84,1.04,1.23,1.08,1.04,0.9,0.73,0.69,0.81,1.0,1.23,1.54,1.5,1.47,1.11,0.84,0.8,0.87,0.98,1.0,1.0,1.13,0.92,0.81,0.92,1.22,1.41,1.53,1.45,1.5,1.1,0.95,0.98,1.09,1.1,1.09,0.88,0.97,0.8,0.89,1.09,1.41,1.41,1.46,1.46,1.29,0.93,0.86,0.95,1.11,1.11,0.96,1.01,0.89,0.76,0.89,1.16,1.4,1.46,1.4,1.53,1.14,0.9,0.93,1.05,1.12,1.08,0.89,0.98,0.83,0.83,0.99,1.3,1.39,1.48,1.36,1.49,1.02,0.9,0.99,1.0,0.98,1.02,1.02,1.1,0.85,0.84,0.97,1.34,1.37,1.37,1.42,1.26,0.9,0.91,1.04,1.02,0.9,0.93,1.04,1.04,0.84,0.79,0.94,1.27,1.34,1.38,1.49,1.13,0.94,1.01,0.95,0.9,0.91,1.0,1.18,0.9,0.81,0.87,1.13,1.26,1.47,1.46,1.39,0.96,0.83,0.88,1.0,0.98,1.05,1.02,1.0,0.82,0.91,1.06,1.34,1.33,1.4,1.55,1.26,0.9,0.9,1.01,1.07,1.02,0.88,1.08,0.92,0.84,0.93,1.16,1.42,1.64,1.47,1.52,1.13,0.92,0.93,1.01,1.02,1.08,0.9,1.09,0.93,0.91,1.01,1.29,1.35,1.48,1.51,1.5,1.05,0.98,1.05,1.07,0.97:-0.2,-0.34,-0.47,-0.71,-0.86,-0.74,-0.49,-0.32,-0.27,-0.17,-0.08,-0.04,-0.02,-0.11,-0.2,-0.19,-0.32,-0.39,-0.57,-0.7,-0.7,-0.53,-0.45,-0.45,-0.3,-0.13,-0.05,-0.05,0.0,-0.07,-0.09,-0.21,-0.49,-0.75,-1.0,-1.11,-0.75,-0.42,-0.29,-0.19,-0.08,0.12,0.3,0.12,-0.07,-0.18,-0.42,-0.73,-0.99,-1.11,-0.83,-0.48,-0.35,-0.22,-0.11,-0.07,-0.03,0.05,-0.15,-0.26,-0.26,-0.45,-0.6,-0.72,-0.55,-0.55,0.09,-0.02,-0.1,-0.02,0.06,0.04,-0.14,-0.5,-0.49,-0.4,-0.3,-0.44,-0.63,-0.75,-0.72,-0.78,-0.77,-0.71,-0.68,-0.57,-0.39,-0.27,-0.26,-0.28,-0.08,-0.2,-0.32,-0.31,-0.46,-0.62,-0.85,-0.58,-0.22,-0.15,-0.13,-0.15,-0.07,0.1,0.03,-0.06,-0.11,-0.23,-0.49,-0.72,-0.76,-0.73,-0.49,-0.27,-0.28,-0.29,-0.15,0.0,0.07,-0.02,-0.09,-0.22,-0.37,-0.55,-0.9,-0.92,-0.82,-0.49,-0.3,-0.26,-0.2,-0.07,0.06,0.01,-0.11,-0.17,-0.24,-0.38,-0.72,-1.07,-1.24,-0.9,-0.57,-0.41,-0.28,-0.15,0.02,0.11,-0.07,-0.22,-0.31,-0.39,-0.8,-0.94,-0.82,-0.79,-0.54,-0.32,-0.27,-0.2,-0.13,-0.09,-0.02,-0.06,-0.15,-0.26,-0.4,-0.63,-0.8,-0.82,-0.82,-0.46,-0.27,-0.24,-0.18,-0.1,-0.01,0.09,-0.04,-0.12,-0.24,-0.42,-0.54,-0.6,-0.78,-0.77,-0.53,-0.36,-0.32,-0.22,-0.04,0.01,0.02,-0.06,-0.13,-0.23,-0.4,-0.63,-0.82,-0.83,-0.72,-0.42,-0.31,-0.26,-0.18,-0.05:-0.15,-0.1,-0.11,0.02,0.12,0.16,0.07,0.02,-0.01,0.02,0.1,0.14,0.05,0.08,-0.04,-0.06,-0.01,0.05,0.15,0.28,0.36,0.44,0.32,0.15,0.07,0.12,0.18,0.1,0.16,0.11,-0.05,-0.08,-0.02,0.04,0.12,0.15,0.22,0.2,0.16,0.16,0.03,-0.02,0.08,0.12,-0.09,0.1,-0.1,0.1,0.2,0.21,0.29,0.22,0.15,0.08,-0.06,-0.16,-0.05,0.06,-0.08,-0.01,-0.08,-0.12,-0.19,-0.19,-0.16,-0.13,-0.09,-0.02,0.08,0.12,0.08,-0.05,-0.08,-0.01,0.07,-0.09,-0.08,-0.16,-0.22,-0.15,-0.03,-0.03,0.02,0.13,0.19,0.25,0.2,0.03,-0.03,-0.11,-0.18,-0.06,0.07,0.18,0.2,0.1,0.04,-0.02,0.0,0.0,-0.02,0.11,0.18,0.22,0.25,0.24,0.19,0.14,0.18,0.01,-0.05,-0.19,-0.2,-0.27,-0.21,-0.04,-0.27,0.15,0.18,-0.05,-0.06,0.01,0.01,0.07,0.11,0.08,0.08,0.04,-0.01,-0.05,-0.09,-0.09,-0.05,-0.02,0.04,0.09,0.09,0.1,0.14,0.14,0.17,0.2,0.18,0.07,0.06,-0.05,-0.1,-0.16,-0.14,-0.13,-0.09,0.04,0.21,0.17,0.12,0.17,0.15,0.2,0.21,0.25,0.11,0.07,-0.02,-0.05,-0.08,-0.03,0.05,0.13,0.21,0.25,0.17,0.15,0.15,0.18,0.2,0.23,0.12,0.1,0.03,0.01,-0.02,-0.01,0.03,0.05,0.08,0.11,0.1,0.07,0.08,0.04,0.12,0.12,0.19,0.05,-0.03,-0.11,-0.12,-0.14,-0.15,-0.12,-0.14,-0.05,0.01,0.03,0.02,0.02:WALKING
-1.13,-1.25,-1.26,-1.17,-1.16,-1.13,-0.99,-0.89,-0.81,-0.73,-0.79,-0.91,-1.17,-1.22,-1.27,-0.97,-0.73,-0.71,-0.87,-1.13,-1.33,-1.35,-1.2,-1.13,-1.19,-1.01,-0.92,-0.89,-0.81,-0.83,-0.85,-1.12,-1.22,-1.22,-0.94,-0.75,-0.81,-1.05,-1.24,-1.29,-1.39,-1.16,-1.26,-1.21,-0.99,-0.93,-0.87,-0.8,-0.81,-0.92,-1.09,-1.27,-1.26,-0.94,-0.76,-0.78,-1.0,-1.23,-1.3,-1.45,-1.16,-1.23,-1.12,-0.91,-0.87,-0.82,-0.82,-0.85,-1.02,-1.07,-1.26,-1.08,-0.79,-0.7,-0.88,-1.18,-1.4,-1.42,-1.29,-1.18,-1.26,-1.11,-0.99,-0.93,-0.83,-0.98,-0.87,-0.85,-0.92,-0.68,-0.35,-0.09,0.02,0.15,0.3,0.44,0.56,0.65,0.61,0.57,0.54,0.52,0.64,0.82,0.99,1.05,0.79,0.54,0.51,0.53,0.49,0.48,0.62,0.7,0.64,0.67,0.5,0.21,0.04,-0.01,-0.01,0.01,-0.09,-0.1,-0.04,-0.14,-0.29,0.03,-0.12,-0.17,-0.25,-0.03,0.13,0.09,0.06,-0.02,-0.17,-0.25,-0.31,-0.39,-0.62,-1.09,-1.59,-1.37,-1.34,-1.0,-0.62,-0.54,-0.78,-1.18,-1.41,-1.4,-1.23,-1.14,-1.22,-1.04,-0.96,-0.96,-0.89,-0.77,-0.64,-0.84,-1.02,-1.22,-1.01,-0.85,-0.86,-1.07,-1.26,-1.38,-1.45,-1.17,-1.13,-1.26,-1.12,-1.02,-0.98,-0.86,-0.8,-0.77,-0.98,-1.14,-1.23,-1.01,-0.87,-0.92,-1.1,-1.28,-1.36,-1.44,-1.16,-1.24,-1.22,-1.04,-0.99,-0.89,-0.83,-0.8,-0.89,-1.01,-1.26,-1.22,-0.89,-0.74,-0.87,-1.14:-0.17,-0.21,-0.2,-0.28,-0.26,-0.31,-0.34,-0.38,-0.35,-0.38,-0.33,-0.22,-0.14,-0.12,-0.1,-0.05,-0.12,-0.16,-0.2,-0.16,-0.25,-0.27,-0.29,-0.34,-0.38,-0.37,-0.39,-0.35,-0.26,-0.17,-0.15,-0.09,-0.04,-0.07,-0.14,-0.2,-0.19,-0.24,-0.24,-0.26,-0.33,-0.38,-0.4,-0.4,-0.38,-0.29,-0.18,-0.12,-0.09,-0.05,-0.03,-0.11,-0.22,-0.13,-0.2,-0.28,-0.28,-0.31,-0.39,-0.42,-0.36,-0.37,-0.28,-0.18,-0.17,-0.13,-0.09,-0.06,-0.13,-0.15,-0.19,-0.19,-0.25,-0.25,-0.28,-0.35,-0.42,-0.38,-0.4,-0.33,-0.21,-0.16,-0.11,-0.09,-0.03,-0.09,-0.15,-0.25,-0.2,-0.25,-0.29,-0.33,-0.35,-0.41,-0.38,-0.38,-0.33,-0.22,-0.16,-0.11,-0.09,-0.05,-0.1,-0.14,-0.2,-0.17,-0.25,-0.25,-0.3,-0.34,-0.38,-0.35,-0.35,-0.34,-0.24,-0.17,-0.14,-0.1,-0.03,-0.05,-0.1,-0.25,-0.15,-0.19,-0.24,-0.26,-0.3,-0.35,-0.4,-0.37,-0.34,-0.26,-0.17,-0.12,-0.14,-0.05,-0.01,-0.07,-0.16,-0.13,-0.22,-0.25,-0.26,-0.31,-0.38,-0.42,-0.39,-0.39,-0.31,-0.18,-0.14,-0.09,-0.06,-0.03,-0.1,-0.16,-0.16,-0.25,-0.28,-0.27,-0.32,-0.36,-0.39,-0.36,-0.39,-0.32,-0.19,-0.13,-0.12,-0.09,-0.01,-0.08,-0.14,-0.19,-0.2,-0.27,-0.28,-0.31,-0.36,-0.42,-0.39,-0.39,-0.33,-0.23,-0.13,-0.09,-0.09,-0.05,-0.1,-0.16,-0.21,-0.15,-0.28,-0.28,-0.28,-0.32,-0.4,-0.4,-0.38,-0.35,-0.23,-0.14,-0.12,-0.12,-0.07,-0.09:0.23,0.21,0.22,0.22,0.15,0.15,0.11,0.11,0.01,-0.01,0.02,0.08,0.16,0.17,0.17,0.12,0.17,0.17,0.16,0.18,0.17,0.2,0.19,0.22,0.15,0.2,0.1,-0.04,0.0,0.03,0.12,0.15,0.16,0.14,0.14,0.21,0.19,0.22,0.28,0.08,-0.03,-0.45,-0.68,-0.61,-0.58,-0.6,-0.78,-0.84,-0.85,-0.84,-0.78,-0.64,-0.56,-0.49,-0.48,-0.51,-0.56,-0.56,-0.62,-0.68,-0.52,-0.27,-0.56,-0.74,-0.75,-0.71,-0.63,-0.58,-0.84,0.23,0.11,0.11,0.37,0.33,0.19,-0.16,-0.21,0.65,1.26,1.48,1.2,1.37,0.9,-0.29,-0.31,-0.35,-1.0,-1.13,-1.19,-0.99,-0.92,-0.88,-0.6,-0.4,-0.54,-0.46,0.0,0.65,0.4,0.29,0.02,-0.01,-0.02,-0.02,0.06,0.13,0.17,0.12,0.16,0.24,0.2,0.19,0.2,0.2,0.19,0.06,0.1,0.06,0.22,0.16,0.08,0.07,0.1,0.13,0.17,0.18,0.13,0.17,0.26,0.23,0.25,0.29,0.25,0.21,0.11,0.16,0.14,0.23,0.11,0.05,0.05,0.06,0.13,0.18,0.21,0.17,0.22,0.25,0.18,0.21,0.22,0.26,0.23,0.15,0.06,0.14,0.08,-0.04,-0.02,0.07,0.15,0.22,0.26,0.18,0.19,0.26,0.2,0.21,0.22,0.18,0.23,0.17,0.19,0.15,0.2,0.08,0.04,0.06,0.08,0.16,0.19,0.21,0.13,0.2,0.24,0.18,0.22,0.22,0.24,0.23,0.17,0.13,0.17,0.23,0.06,0.04,0.07,0.1,0.17,0.19,0.19,0.07,0.15,0.17,0.17,0.1:WALKING
-1.51,-1.44,-1.46,-1.66,-1.42,-1.07,-0.97,-1.07,-1.23,-1.0,-1.0,-1.17,-1.09,-0.9,-0.95,-1.0,-1.22,-1.44,-1.33,-1.41,-1.41,-1.0,-0.87,-0.93,-1.11,-1.2,-1.1,-1.04,-1.24,-0.82,-0.7,-0.75,-1.0,-1.4,-1.5,-1.37,-1.3,-0.97,-0.67,-0.58,-0.58,-0.69,-0.74,-0.74,-0.68,-0.63,-0.38,-0.31,-0.4,-0.72,-1.25,-1.45,-1.51,-1.34,-0.86,-0.7,-0.76,-1.04,-1.25,-1.21,-1.22,-1.16,-0.73,-0.5,-0.61,-0.87,-1.27,-1.37,-1.52,-1.51,-1.0,-0.75,-0.71,-0.9,-1.13,-1.18,-1.13,-1.2,-0.82,-0.63,-0.76,-1.02,-1.38,-1.46,-1.44,-1.45,-1.08,-0.85,-0.79,-0.95,-1.13,-1.11,-1.02,-1.17,-0.91,-0.73,-0.84,-1.08,-1.39,-1.37,-1.32,-1.46,-1.26,-0.95,-0.81,-0.84,-1.18,-1.18,-1.01,-1.07,-1.01,-0.72,-0.69,-0.94,-1.33,-1.47,-1.42,-1.44,-1.41,-1.01,-0.84,-0.86,-1.07,-1.16,-1.12,-1.05,-1.17,-0.87,-0.74,-0.89,-1.13,-1.39,-1.39,-1.37,-1.46,-1.12,-0.86,-0.85,-1.01,-1.22,-1.09,-1.0,-1.11,-0.89,-0.72,-0.86,-1.14,-1.46,-1.36,-1.37,-1.5,-1.21,-0.93,-0.87,-0.92,-1.13,-1.1,-1.04,-1.16,-1.02,-0.75,-0.77,-1.01,-1.37,-1.4,-1.39,-1.51,-1.34,-0.99,-0.86,-0.87,-1.14,-1.18,-1.0,-1.13,-1.11,-0.87,-0.83,-1.0,-1.27,-1.39,-1.29,-1.45,-1.37,-1.04,-0.9,-0.86,-1.0,-1.17,-1.08,-1.09,-1.22,-0.96,-0.75,-0.83,-1.1,-1.38,-1.23,-1.32,-1.46,-1.23,-1.0,-0.9,-0.89,-1.22,-1.13:-0.28,-0.19,-0.53,-0.54,-0.47,-0.34,-0.21,-0.12,-0.06,0.16,0.21,0.12,0.18,-0.2,-0.38,-0.56,-0.64,-0.71,-0.45,-0.24,-0.44,-0.7,-0.4,0.19,0.33,0.11,0.29,0.5,0.41,0.19,-0.22,-0.5,-0.14,-0.29,-0.55,-0.62,-0.47,-0.41,-0.19,-0.39,-1.05,-0.26,0.54,0.41,0.18,0.08,0.18,0.26,0.03,-0.29,-0.31,0.02,-0.14,-0.45,-0.54,-0.47,-0.38,-0.42,-0.88,-0.1,0.48,0.43,0.19,0.37,0.5,0.26,-0.58,-1.17,-0.95,-0.69,-0.53,-0.52,-0.59,-0.47,-0.29,-0.87,-1.08,-0.12,0.39,0.17,0.15,0.21,-0.09,-0.44,-0.63,-0.58,-0.29,-0.6,-0.47,-0.32,-0.42,-0.52,-0.68,-0.67,-0.01,0.01,-0.03,0.01,0.2,0.22,-0.39,-0.48,-0.31,-0.51,-0.6,-0.53,-0.51,-0.44,-0.32,-0.6,-0.82,-0.7,-0.48,0.0,0.53,0.45,0.79,-0.28,-0.12,-0.21,-0.49,-0.74,-0.3,-0.14,0.05,0.07,-0.52,-0.39,-0.32,-0.23,0.03,0.25,0.2,0.2,0.15,0.05,0.04,-0.34,-0.51,-0.55,-0.74,-0.52,-0.4,-0.74,-0.41,-0.19,0.18,0.41,0.51,0.4,0.48,0.11,-0.12,-0.19,0.07,0.28,0.05,-0.3,-0.45,-1.07,-0.04,0.41,0.14,-0.12,0.53,0.35,-0.56,-0.54,-0.79,-0.7,-0.25,-0.39,-0.37,-0.33,-0.19,-0.15,-1.74,-1.12,-0.85,-0.6,0.05,0.13,0.09,-0.24,-0.84,-0.32,-0.9,-0.81,-1.0,-1.07,-0.43,0.15,-0.32,-0.99,-0.13,-0.13,-0.01,-0.07,0.22,-0.09,-1.02,-1.4,-0.67,-0.16,-0.02,-0.17:0.04,0.1,0.12,0.19,0.28,0.23,0.39,0.31,0.18,0.21,0.24,0.28,0.33,0.22,0.16,0.13,0.06,0.1,0.13,0.17,0.27,0.24,0.38,0.36,0.19,0.2,0.25,0.35,0.47,0.26,0.12,0.11,-0.01,0.02,0.08,0.2,0.33,0.28,0.38,0.41,0.23,0.22,0.23,0.3,0.39,0.29,0.09,0.14,0.05,0.07,0.14,0.17,0.26,0.22,0.19,0.27,0.19,0.13,0.15,0.13,0.21,0.34,0.26,0.18,0.13,0.02,0.03,0.09,0.19,0.28,0.21,0.36,0.35,0.13,0.12,0.15,0.18,0.38,0.35,0.14,0.14,0.04,0.02,0.09,0.16,0.24,0.25,0.23,0.3,0.15,0.11,0.13,0.13,0.26,0.34,0.32,0.26,0.2,0.13,0.17,0.23,0.31,0.37,0.24,0.28,0.27,0.11,0.1,0.1,0.16,0.31,0.27,0.14,0.16,-0.01,0.03,0.18,0.25,0.32,0.28,0.39,0.41,0.18,0.1,0.1,0.12,0.28,0.31,0.13,0.24,0.17,0.11,0.17,0.18,0.25,0.31,0.27,0.43,0.25,0.14,0.15,0.19,0.38,0.46,0.34,0.1,0.01,0.05,0.08,0.09,0.12,0.23,0.17,0.29,0.21,0.13,0.15,0.19,0.27,0.33,0.27,0.1,0.01,-0.05,-0.04,-0.02,0.02,0.13,0.16,0.26,0.28,0.13,0.12,0.18,0.19,0.31,0.29,0.12,0.2,0.01,0.0,0.06,0.13,0.25,0.31,0.31,0.43,0.27,0.16,0.21,0.24,0.36,0.36,0.11,0.16,0.06,0.08,0.12,0.15,0.23,0.27,0.25,0.39,0.25,0.16,0.22:WALKING
0.58,0.69,0.99,1.39,1.55,1.39,1.52,1.39,1.27,1.17,1.0,0.7,0.15,-0.34,-0.5,-0.48,-0.47,-0.56,-0.59,-0.87,-1.13,-1.29,-1.2,-1.06,-0.85,-0.6,-0.57,-0.68,-0.75,-0.83,-0.9,-0.84,-0.73,-0.56,-0.48,-0.57,-0.75,-0.9,-1.07,-0.99,-0.81,-0.65,-0.51,-0.51,-0.58,-0.66,-0.74,-0.83,-0.68,-0.47,-0.37,-0.36,-0.4,-0.53,-0.68,-0.79,-0.77,-0.68,-0.53,-0.32,-0.32,-0.51,-0.69,-0.85,-1.05,-0.99,-0.69,-0.4,-0.18,-0.1,-0.14,-0.34,-0.64,-0.99,-0.86,-0.53,-0.26,-0.18,-0.3,-0.43,-0.4,-0.22,-0.22,-0.03,0.13,0.13,-0.04,-0.13,-0.13,-0.09,-0.06,0.02,0.13,0.28,0.18,0.08,0.03,0.07,0.01,0.13,0.65,0.62,0.18,-0.16,-0.45,-0.57,-0.6,-0.67,-0.56,-0.4,-0.18,-0.04,0.08,0.17,0.21,0.34,0.56,0.8,0.59,0.27,0.05,-0.08,-0.21,-0.13,0.01,0.03,-0.04,-0.04,0.01,0.03,0.07,0.19,0.38,0.61,0.88,0.79,0.4,0.06,-0.2,-0.24,-0.12,-0.06,-0.03,-0.1,-0.1,-0.06,0.05,0.16,0.38,0.52,0.65,0.82,0.6,0.24,-0.01,-0.2,-0.18,-0.18,-0.19,-0.16,-0.17,-0.07,-0.07,-0.3,-0.53,-0.53,-0.54,-0.72,-0.63,-0.43,-0.38,-0.4,-0.51,-0.72,-0.82,-0.9,-0.93,-0.88,-0.72,-0.53,-0.42,-0.51,-0.57,-0.6,-0.54,-0.53,-0.44,-0.34,-0.34,-0.46,-0.7,-0.88,-1.04,-1.02,-0.8,-0.54,-0.26,-0.14,-0.1,-0.25,-0.42,-0.52,-0.38,-0.1,0.0,-0.06:0.42,0.38,0.35,0.34,0.29,0.27,0.24,0.2,0.2,0.28,0.43,0.5,0.33,0.14,0.21,0.35,0.41,0.42,0.41,0.33,0.33,0.31,0.27,0.28,0.27,0.22,0.24,0.34,0.45,0.45,0.21,0.19,0.3,0.45,0.45,0.44,0.43,0.36,0.33,0.28,0.25,0.25,0.21,0.19,0.24,0.39,0.5,0.34,0.19,0.26,0.41,0.43,0.45,0.42,0.36,0.37,0.33,0.27,0.26,0.24,0.19,0.18,0.31,0.47,0.43,0.22,0.16,0.32,0.44,0.43,0.43,0.43,0.4,0.39,0.29,0.27,0.25,0.21,0.19,0.23,0.38,0.51,0.34,0.17,0.18,0.34,0.45,0.45,0.41,0.39,0.36,0.36,0.28,0.26,0.26,0.19,0.17,0.25,0.41,0.57,0.36,0.12,0.23,0.44,0.47,0.47,0.39,0.33,0.36,0.4,0.3,0.27,0.32,0.37,0.33,0.38,0.56,0.69,0.44,0.24,0.29,0.49,0.55,0.57,0.57,0.61,0.51,0.6,0.49,0.37,0.42,0.4,0.37,0.38,0.39,0.37,0.36,0.29,0.24,0.27,0.37,0.42,0.4,0.48,0.52,0.56,0.52,0.45,0.37,0.28,0.2,0.23,0.39,0.51,0.31,0.22,0.37,0.47,0.42,0.41,0.44,0.4,0.31,0.25,0.26,0.26,0.21,0.15,0.25,0.51,0.37,0.21,0.22,0.33,0.4,0.48,0.57,0.49,0.39,0.26,0.24,0.26,0.23,0.16,0.18,0.39,0.48,0.27,0.2,0.31,0.43,0.47,0.56,0.51,0.37,0.24,0.24,0.24,0.2,0.12,0.13,0.32,0.6,0.45,0.42,0.41:-0.12,-0.13,-0.1,-0.13,-0.19,-0.08,0.0,0.04,0.11,0.06,0.01,0.03,0.16,0.22,0.22,-0.03,-0.14,-0.07,-0.06,-0.02,-0.11,-0.17,-0.04,0.01,0.17,0.13,0.04,0.0,0.08,0.17,0.21,0.15,-0.22,-0.22,-0.24,-0.13,0.0,0.11,0.01,0.0,0.14,0.16,0.11,0.06,0.08,0.14,0.24,0.24,-0.01,0.08,0.08,0.09,0.08,0.09,0.09,0.13,0.07,0.15,0.13,0.07,0.0,0.05,0.23,0.3,0.14,-0.08,0.04,0.01,-0.01,0.0,0.01,0.01,-0.07,-0.04,0.04,-0.01,-0.06,-0.06,0.1,0.18,0.21,0.0,-0.11,-0.01,-0.05,-0.07,-0.17,-0.15,-0.08,-0.09,-0.02,0.06,0.05,0.03,0.04,0.12,0.18,0.19,-0.13,-0.14,-0.06,-0.05,-0.12,-0.22,-0.14,-0.04,-0.06,0.03,0.06,0.04,0.02,0.05,0.13,0.2,0.16,-0.24,-0.13,-0.05,-0.06,-0.16,-0.21,-0.06,0.02,0.06,0.14,0.08,0.02,0.01,0.1,0.2,0.25,0.03,-0.14,-0.03,-0.05,-0.03,-0.06,-0.04,0.01,0.01,0.15,0.16,0.17,0.12,0.13,0.17,0.23,0.23,0.02,0.12,0.07,-0.04,-0.05,-0.02,0.01,-0.02,-0.1,0.06,0.06,-0.01,-0.06,0.0,0.15,0.25,0.17,-0.24,-0.1,-0.09,-0.09,-0.04,-0.15,-0.18,-0.09,0.02,0.09,0.01,-0.09,-0.04,0.04,0.12,0.19,0.13,-0.23,-0.11,-0.1,-0.14,-0.22,-0.23,-0.05,-0.03,0.01,0.11,0.06,-0.03,-0.02,0.07,0.17,0.24,-0.03,-0.22,0.0,-0.04,-0.04,-0.06,-0.07,-0.06:WALKING
-0.71,-0.71,-1.01,-1.13,-1.13,-1.24,-1.18,-0.79,-0.61,-0.74,-1.07,-1.34,-1.39,-1.42,-1.41,-1.02,-0.76,-0.66,-0.8,-1.22,-1.25,-1.17,-1.25,-0.94,-0.58,-0.59,-0.78,-1.17,-1.29,-1.41,-1.52,-1.26,-0.85,-0.67,-0.66,-1.0,-1.18,-1.17,-1.18,-1.19,-0.8,-0.61,-0.65,-0.96,-1.33,-1.39,-1.37,-1.47,-1.12,-0.78,-0.66,-0.73,-1.01,-1.11,-1.13,-1.23,-1.14,-0.71,-0.58,-0.72,-1.0,-1.34,-1.35,-1.33,-1.36,-1.0,-0.74,-0.61,-0.69,-1.02,-1.18,-1.19,-1.32,-0.97,-0.57,-0.58,-0.78,-1.13,-1.36,-1.37,-1.39,-1.06,-0.73,-0.63,-0.64,-0.99,-1.22,-1.34,-1.27,-1.0,-0.55,-0.48,-0.76,-1.1,-1.36,-1.32,-1.41,-1.29,-0.87,-0.7,-0.69,-0.95,-1.13,-1.24,-1.27,-1.21,-0.73,-0.53,-0.77,-1.1,-1.3,-1.34,-1.45,-1.39,-1.0,-0.78,-0.71,-0.92,-1.22,-1.19,-1.23,-1.21,-0.84,-0.66,-0.77,-1.06,-1.32,-1.37,-1.49,-1.46,-1.09,-0.83,-0.8,-1.01,-1.18,-1.09,-1.11,-1.27,-0.96,-0.69,-0.73,-0.97,-1.32,-1.33,-1.3,-1.44,-1.25,-0.91,-0.78,-0.86,-1.11,-1.08,-1.16,-1.3,-1.13,-0.74,-0.62,-0.86,-1.19,-1.38,-1.35,-1.47,-1.44,-1.02,-0.77,-0.7,-0.73,-1.02,-1.19,-1.29,-1.37,-0.95,-0.64,-0.64,-0.85,-1.21,-1.36,-1.37,-1.49,-1.1,-0.77,-0.62,-0.66,-1.07,-1.18,-1.13,-1.3,-1.09,-0.69,-0.6,-0.74,-1.02,-1.24,-1.35,-1.39,-1.28,-0.93,-0.7,-0.69,-0.9,-1.2,-1.26,-1.24,-1.18,-0.75,-0.57:-0.74,0.27,0.14,0.07,0.12,0.41,0.37,-0.02,-0.61,-1.06,-1.09,-0.93,-0.78,-0.69,-0.78,-0.66,-0.64,-0.56,-1.16,-0.89,-0.71,-0.25,0.06,0.4,0.35,0.19,-0.31,-0.55,-0.57,-0.6,-0.71,-0.76,-0.62,-0.43,-0.23,-0.22,-1.36,0.01,0.01,-0.38,-0.21,0.05,0.17,0.24,0.18,-0.03,-0.03,-0.2,-0.2,-0.25,-0.61,-0.86,-0.78,-0.58,-0.2,-0.05,0.06,0.19,0.31,0.39,0.38,-0.31,-0.98,-1.42,-1.25,-1.01,-0.82,-0.68,-0.5,-0.32,-0.34,-0.97,-0.58,-0.47,-0.34,-0.06,0.16,0.26,0.22,-0.22,-0.7,-0.91,-0.97,-0.93,-0.78,-0.66,-0.48,-0.41,-0.55,-1.12,-1.07,-1.06,-0.7,-0.17,0.09,0.18,0.17,-0.14,-0.48,-0.83,-1.05,-0.9,-0.79,-0.62,-0.47,-0.41,-0.71,-0.82,-0.8,-0.34,-0.04,0.01,0.16,0.27,0.18,-0.28,-0.56,-0.68,-0.93,-0.84,-0.81,-0.73,-0.56,-0.33,-0.52,-0.81,-0.8,-0.36,-0.08,-0.01,0.18,0.25,0.14,-0.4,-0.6,-0.77,-0.99,-1.07,-0.97,-0.69,-0.42,-0.28,-0.73,-1.23,-1.49,-1.12,-0.63,-0.09,0.12,0.21,0.14,-0.12,-0.31,-0.69,-0.73,-0.65,-0.53,-0.42,-0.57,-0.28,-0.09,0.1,0.09,0.1,0.07,0.12,0.18,0.12,0.05,0.04,-0.01,-0.07,-0.15,-0.22,-0.22,-0.19,-0.05,-0.15,-0.21,-0.21,-0.15,-0.11,-0.09,-0.07,-0.06,0.01,-0.04,0.01,0.11,0.01,-0.15,-0.17,-0.23,-0.29,-0.25,-0.21,-0.28,-0.29,-0.25,-0.16,-0.09,-0.07,-0.02,0.08,0.03,0.02:0.14,0.17,0.32,0.46,0.27,0.3,0.09,-0.05,-0.01,0.07,0.2,0.31,0.32,0.42,0.22,0.13,0.17,0.29,0.4,0.45,0.36,0.32,0.1,0.02,0.07,0.11,0.16,0.23,0.33,0.42,0.22,0.19,0.22,0.23,0.43,0.35,0.24,0.26,0.02,0.02,0.07,0.14,0.23,0.29,0.33,0.38,0.15,0.13,0.16,0.24,0.34,0.34,0.28,0.22,0.03,0.03,0.12,0.19,0.26,0.25,0.41,0.4,0.14,0.1,0.1,0.28,0.37,0.34,0.34,0.18,-0.02,0.06,0.14,0.28,0.47,0.5,0.68,0.49,0.29,0.18,0.2,0.28,0.41,0.4,0.35,0.17,0.07,0.08,0.13,0.21,0.31,0.43,0.38,0.22,0.18,0.17,0.3,0.47,0.5,0.39,0.22,0.0,-0.01,0.07,0.13,0.22,0.27,0.41,0.34,0.14,0.16,0.16,0.3,0.44,0.42,0.32,0.18,0.06,0.07,0.07,0.13,0.22,0.26,0.43,0.27,0.14,0.17,0.19,0.35,0.37,0.33,0.29,0.16,-0.02,0.02,0.08,0.18,0.25,0.28,0.44,0.31,0.14,0.16,0.17,0.33,0.43,0.34,0.31,0.13,0.04,0.03,0.05,0.14,0.23,0.27,0.41,0.22,0.13,0.18,0.22,0.4,0.39,0.33,0.31,0.11,0.05,0.07,0.12,0.22,0.27,0.29,0.48,0.2,0.13,0.15,0.17,0.4,0.42,0.29,0.28,0.11,0.04,0.06,0.08,0.16,0.25,0.25,0.38,0.24,0.16,0.17,0.17,0.33,0.38,0.29,0.31,0.14,0.01,0.07,0.08,0.16,0.27,0.27,0.43,0.24,0.18:WALKING
-1.26,-1.16,-1.26,-1.13,-0.79,-0.59,-0.77,-1.13,-1.26,-1.12,-1.13,-1.01,-0.65,-0.56,-0.95,-1.1,-1.2,-1.13,-1.32,-1.12,-0.76,-0.59,-0.81,-1.16,-1.27,-1.13,-1.13,-0.92,-0.57,-0.58,-0.96,-1.12,-1.22,-1.12,-1.3,-1.04,-0.7,-0.62,-0.85,-1.16,-1.26,-1.12,-1.12,-0.92,-0.59,-0.57,-0.91,-1.09,-1.26,-1.19,-1.26,-1.04,-0.74,-0.64,-0.86,-1.17,-1.26,-1.13,-1.1,-0.86,-0.59,-0.66,-0.98,-1.14,-1.23,-1.16,-1.34,-1.04,-0.7,-0.63,-0.87,-1.16,-1.23,-1.12,-1.13,-0.87,-0.56,-0.67,-1.0,-1.12,-1.28,-1.18,-1.2,-0.98,-0.71,-0.66,-0.94,-1.26,-1.24,-1.11,-1.2,-0.93,-0.62,-0.65,-0.93,-1.09,-1.25,-1.08,-1.21,-1.05,-0.75,-0.75,-0.91,-1.13,-1.18,-1.08,-1.08,-0.92,-0.71,-0.74,-0.95,-1.14,-1.2,-1.14,-1.29,-1.05,-0.73,-0.67,-0.96,-1.18,-1.21,-1.09,-1.14,-0.89,-0.56,-0.68,-1.05,-1.11,-1.21,-1.18,-1.26,-0.98,-0.72,-0.65,-0.95,-1.22,-1.26,-1.09,-1.11,-0.87,-0.59,-0.66,-0.98,-1.11,-1.26,-1.12,-1.32,-1.08,-0.75,-0.72,-0.86,-1.13,-1.39,-1.23,-1.26,-1.0,-0.69,-0.75,-1.18,-1.2,-1.19,-1.47,-1.55,-1.18,-0.86,-0.79,-1.07,-1.27,-1.22,-1.41,-1.32,-0.92,-0.96,-1.23,-1.12,-1.12,-1.69,-1.46,-1.0,-0.79,-0.9,-1.26,-1.24,-1.27,-1.51,-1.13,-0.73,-0.92,-1.26,-1.13,-1.12,-1.62,-1.49,-0.99,-0.75,-0.87,-1.2,-1.26,-1.32,-1.42,-1.07,-0.77,-1.01,-1.27,-1.16,-1.08:0.04,-0.18,-0.22,-0.23,-0.4,-0.84,-0.8,-0.82,-0.52,-0.32,-0.23,-0.2,-0.09,0.26,0.03,-0.18,-0.23,-0.37,-0.51,-0.52,-0.76,-0.89,-0.49,-0.19,-0.12,-0.23,-0.08,0.22,0.03,-0.15,-0.18,-0.2,-0.35,-0.68,-0.81,-0.92,-0.49,-0.25,-0.2,-0.28,-0.19,0.26,0.05,-0.14,-0.15,-0.15,-0.42,-0.93,-0.9,-0.83,-0.36,-0.22,-0.21,-0.21,-0.03,0.14,-0.06,-0.26,-0.25,-0.25,-0.43,-0.74,-0.86,-0.69,-0.37,-0.27,-0.25,-0.34,-0.1,0.16,-0.03,-0.18,-0.24,-0.32,-0.53,-0.61,-0.77,-0.98,-0.43,-0.13,-0.16,-0.32,-0.16,0.21,0.0,-0.17,-0.16,-0.28,-0.63,-0.75,-0.86,-0.88,-0.43,-0.23,-0.23,-0.37,0.02,0.3,0.0,-0.14,-0.17,-0.21,-0.62,-0.73,-0.86,-0.93,-0.44,-0.11,-0.01,-0.31,0.06,0.3,-0.09,-0.18,-0.1,-0.15,-0.46,-1.01,-0.91,-0.72,-0.46,-0.29,-0.17,-0.32,0.05,0.11,0.03,-0.17,-0.19,-0.28,-0.62,-0.7,-0.77,-1.0,-0.53,-0.2,-0.16,-0.33,-0.15,0.33,0.01,-0.13,-0.15,-0.22,-0.65,-0.62,-0.78,-0.97,-0.45,-0.17,-0.27,-0.3,-0.09,0.18,-0.02,-0.15,-0.09,-0.17,-0.59,-0.73,-0.83,-0.93,-0.33,-0.15,-0.32,-0.33,0.12,0.17,-0.07,-0.19,-0.23,-0.38,-0.54,-0.89,-1.04,-0.7,-0.34,-0.26,-0.14,-0.29,-0.05,0.11,-0.1,-0.19,-0.2,-0.28,-0.71,-0.69,-0.81,-0.77,-0.33,-0.14,-0.21,-0.37,0.08,0.32,-0.03,-0.09,-0.14,-0.22,-0.65,-0.81,-0.93,-0.71,-0.27,-0.25:-0.22,-0.24,-0.49,-0.61,-0.56,-0.38,-0.27,-0.35,-0.09,0.18,0.18,0.09,-0.08,-0.25,-0.27,-0.26,-0.57,-0.66,-0.54,-0.28,-0.39,-0.35,-0.07,0.07,0.05,-0.01,-0.11,-0.27,-0.23,-0.22,-0.49,-0.58,-0.55,-0.39,-0.34,-0.37,-0.09,0.21,0.2,0.08,-0.11,-0.23,-0.23,-0.29,-0.49,-0.6,-0.54,-0.42,-0.33,-0.33,-0.02,0.28,0.22,-0.01,-0.27,-0.28,-0.31,-0.26,-0.38,-0.47,-0.49,-0.35,-0.21,-0.33,-0.11,0.23,0.28,0.15,-0.15,-0.22,-0.16,-0.19,-0.52,-0.68,-0.54,-0.26,-0.35,-0.36,-0.02,0.14,0.11,0.05,-0.23,-0.35,-0.25,-0.42,-0.68,-0.64,-0.49,-0.28,-0.31,-0.19,0.03,0.11,0.14,-0.01,-0.17,-0.23,-0.25,-0.33,-0.48,-0.53,-0.5,-0.45,-0.42,-0.43,-0.11,0.2,0.16,0.06,-0.17,-0.21,-0.27,-0.34,-0.65,-0.71,-0.54,-0.28,-0.4,-0.27,0.0,0.25,0.19,0.0,-0.21,-0.22,-0.23,-0.33,-0.55,-0.58,-0.48,-0.19,-0.36,-0.32,-0.12,0.15,0.15,0.04,-0.22,-0.19,-0.19,-0.28,-0.69,-0.77,-0.57,-0.25,-0.44,-0.25,0.01,0.14,0.06,0.0,-0.19,-0.24,-0.27,-0.36,-0.59,-0.59,-0.49,-0.29,-0.32,-0.32,-0.03,0.08,0.24,0.12,-0.18,-0.18,-0.24,-0.43,-0.76,-0.72,-0.5,-0.25,-0.37,-0.24,-0.05,0.06,0.14,-0.01,-0.26,-0.21,-0.27,-0.43,-0.63,-0.69,-0.5,-0.28,-0.38,-0.27,-0.06,0.13,0.09,-0.01,-0.16,-0.32,-0.21,-0.37,-0.63,-0.61,-0.49,-0.25,-0.38,-0.16,0.0,0.18:WALKING
1.08,1.08,1.17,1.06,0.76,0.68,0.82,1.13,1.26,1.35,1.35,1.29,0.9,0.76,0.8,0.91,1.1,1.1,1.14,1.07,0.77,0.72,0.81,1.1,1.25,1.3,1.48,1.33,0.91,0.82,0.83,0.88,1.0,1.02,1.18,1.1,0.81,0.78,0.85,1.0,1.13,1.29,1.36,1.37,1.13,0.98,0.83,0.91,1.05,1.12,1.21,1.01,1.05,1.05,0.89,0.78,0.81,0.87,0.88,0.96,1.01,1.25,1.22,1.0,0.8,0.79,0.9,1.13,1.34,1.22,1.12,0.98,0.67,0.59,0.88,1.22,1.44,1.59,1.6,1.26,0.91,0.81,0.88,1.01,1.25,1.27,1.22,0.85,0.84,0.98,1.22,1.22,1.48,1.64,1.32,0.95,0.82,0.89,1.1,1.27,1.26,1.08,0.77,0.92,1.14,1.38,1.45,1.5,1.45,0.95,0.84,1.06,1.19,1.17,1.12,1.24,0.91,0.72,0.94,1.19,1.2,1.47,1.61,1.42,1.0,0.85,0.95,1.06,1.13,1.12,1.26,1.01,0.82,0.95,1.19,1.24,1.45,1.61,1.46,1.04,0.85,0.89,1.01,1.09,1.17,1.35,1.14,0.82,0.82,0.97,1.26,1.39,1.55,1.63,1.24,0.91,0.76,0.76,0.98,1.16,1.28,1.45,1.01,0.77,0.87,1.17,1.29,1.52,1.62,1.5,1.09,0.86,0.89,1.0,1.12,1.14,1.32,1.07,0.8,0.9,1.16,1.36,1.51,1.62,1.55,1.09,0.83,0.85,0.99,1.08,1.26,1.26,1.08,0.82,0.94,1.13,1.32,1.51,1.6,1.53,1.05,0.87,0.92,1.1,1.22,1.21:-0.23,-0.15,-0.12,-0.14,-0.16,-0.29,-0.19,-0.17,-0.27,-0.33,-0.47,-0.53,-0.67,-0.54,-0.35,-0.29,-0.2,-0.13,-0.07,-0.1,-0.07,-0.21,-0.21,-0.19,-0.32,-0.44,-0.51,-0.54,-0.72,-0.46,-0.35,-0.3,-0.21,-0.12,-0.06,-0.08,-0.1,-0.2,-0.21,-0.25,-0.36,-0.45,-0.47,-0.53,-0.65,-0.42,-0.34,-0.3,-0.2,-0.13,-0.09,-0.1,-0.18,-0.13,-0.08,-0.26,-0.39,-0.44,-0.49,-0.6,-0.6,-0.38,-0.32,-0.25,-0.16,-0.08,-0.07,-0.08,-0.14,-0.19,-0.23,-0.32,-0.4,-0.48,-0.53,-0.64,-0.46,-0.32,-0.29,-0.21,-0.11,-0.06,-0.11,-0.12,-0.21,-0.23,-0.27,-0.34,-0.4,-0.47,-0.52,-0.62,-0.39,-0.29,-0.26,-0.2,-0.12,-0.07,-0.1,-0.11,-0.25,-0.31,-0.29,-0.32,-0.35,-0.36,-0.38,-0.56,-0.39,-0.27,-0.28,-0.21,-0.17,-0.11,-0.13,-0.11,-0.16,-0.14,-0.15,-0.25,-0.34,-0.37,-0.39,-0.54,-0.48,-0.31,-0.3,-0.22,-0.16,-0.08,-0.07,-0.13,-0.22,-0.22,-0.24,-0.33,-0.39,-0.39,-0.43,-0.56,-0.33,-0.25,-0.22,-0.15,-0.09,-0.01,-0.06,-0.15,-0.25,-0.22,-0.19,-0.32,-0.41,-0.49,-0.56,-0.57,-0.34,-0.24,-0.17,-0.12,-0.02,-0.01,-0.15,-0.2,-0.25,-0.21,-0.29,-0.35,-0.36,-0.37,-0.43,-0.5,-0.33,-0.32,-0.25,-0.18,-0.1,-0.13,-0.21,-0.18,-0.26,-0.26,-0.29,-0.36,-0.42,-0.44,-0.54,-0.51,-0.34,-0.31,-0.22,-0.15,-0.09,-0.12,-0.15,-0.23,-0.29,-0.28,-0.34,-0.41,-0.45,-0.43,-0.54,-0.43,-0.34,-0.29:0.15,0.16,0.15,0.17,0.16,0.18,0.19,0.15,0.1,0.07,-0.01,-0.05,-0.08,0.0,0.05,0.03,0.07,0.14,0.09,0.14,0.13,0.16,0.23,0.25,0.11,0.09,-0.01,-0.04,-0.08,-0.05,0.0,0.01,0.12,0.17,0.12,0.16,0.15,0.18,0.2,0.2,0.12,0.1,0.02,0.01,0.03,0.04,0.07,0.06,0.24,0.26,0.11,0.06,0.07,0.08,0.3,0.46,0.5,0.2,0.17,0.13,0.13,0.11,0.08,0.05,-0.03,-0.17,-0.19,-0.16,-0.04,0.05,0.09,0.14,0.12,0.16,0.2,0.25,0.28,0.25,0.11,0.04,-0.06,-0.04,-0.05,-0.01,0.17,0.22,0.21,0.26,0.3,0.28,0.34,0.26,0.17,0.07,0.04,-0.01,0.05,0.08,0.13,0.26,0.23,0.19,0.17,0.22,0.24,0.34,0.25,0.21,0.1,0.05,0.02,0.1,0.09,0.24,0.3,0.2,0.21,0.26,0.32,0.27,0.29,0.21,0.1,0.01,-0.09,0.02,0.1,0.16,0.31,0.28,0.22,0.19,0.23,0.3,0.27,0.32,0.27,0.16,0.05,-0.07,-0.03,0.03,0.07,0.22,0.25,0.19,0.19,0.23,0.32,0.28,0.36,0.26,0.22,0.05,-0.06,-0.11,0.01,0.07,0.19,0.27,0.23,0.21,0.18,0.2,0.25,0.26,0.27,0.28,0.14,0.05,-0.04,-0.03,0.09,0.11,0.26,0.29,0.21,0.21,0.23,0.27,0.28,0.32,0.25,0.2,0.07,-0.05,-0.06,0.01,0.01,0.21,0.26,0.18,0.19,0.19,0.25,0.26,0.36,0.28,0.21,0.09,0.0,-0.07,0.0,0.0,0.21,0.28:WALKING
-1.42,-1.22,-1.21,-0.93,-0.79,-0.84,-0.88,-0.94,-1.12,-1.24,-1.3,-0.92,-0.54,-0.62,-1.04,-1.45,-1.39,-1.39,-1.3,-1.25,-0.87,-0.82,-0.91,-0.94,-0.92,-1.06,-1.24,-1.37,-0.9,-0.6,-0.73,-1.12,-1.51,-1.48,-1.27,-1.33,-1.13,-0.79,-0.78,-0.89,-0.99,-0.99,-1.08,-1.27,-1.19,-0.76,-0.55,-0.78,-1.23,-1.45,-1.5,-1.25,-1.28,-1.04,-0.79,-0.83,-0.96,-1.05,-1.05,-1.01,-1.26,-1.1,-0.66,-0.57,-0.95,-1.4,-1.4,-1.48,-1.21,-1.24,-0.97,-0.78,-0.84,-0.88,-0.96,-1.06,-1.13,-1.34,-1.1,-0.64,-0.56,-0.87,-1.36,-1.46,-1.46,-1.16,-1.26,-1.02,-0.82,-0.86,-0.91,-0.93,-0.98,-1.13,-1.4,-1.12,-0.66,-0.57,-0.89,-1.36,-1.41,-1.47,-1.14,-1.29,-1.01,-0.81,-0.82,-0.83,-0.9,-1.01,-1.17,-1.39,-1.18,-0.7,-0.54,-0.81,-1.26,-1.39,-1.46,-1.2,-1.27,-0.98,-0.83,-0.93,-0.93,-0.95,-1.04,-1.13,-1.34,-1.05,-0.64,-0.59,-0.9,-1.37,-1.42,-1.41,-1.22,-1.28,-1.0,-0.84,-0.91,-0.91,-0.9,-1.0,-1.14,-1.4,-1.1,-0.66,-0.58,-0.94,-1.38,-1.4,-1.49,-1.29,-1.32,-0.99,-0.83,-0.88,-0.86,-0.93,-1.0,-1.13,-1.46,-1.14,-0.69,-0.63,-0.95,-1.32,-1.38,-1.44,-1.26,-1.36,-0.98,-0.76,-0.83,-0.84,-0.95,-1.02,-1.14,-1.34,-1.13,-0.68,-0.64,-0.94,-1.32,-1.36,-1.51,-1.26,-1.29,-0.96,-0.78,-0.84,-0.85,-0.92,-0.98,-1.11,-1.3,-1.24,-0.8,-0.61,-0.75,-1.09,-1.4,-1.39,-1.34,-1.21:-0.34,-0.41,-0.36,-0.31,-0.23,-0.26,-0.33,-0.35,-0.37,-0.37,-0.36,-0.37,-0.37,-0.42,-0.3,-0.22,-0.21,-0.2,-0.17,-0.25,-0.31,-0.31,-0.26,-0.31,-0.33,-0.34,-0.37,-0.38,-0.38,-0.38,-0.39,-0.36,-0.3,-0.25,-0.21,-0.14,-0.17,-0.17,-0.25,-0.25,-0.38,-0.36,-0.29,-0.25,-0.24,-0.32,-0.39,-0.44,-0.44,-0.43,-0.44,-0.37,-0.29,-0.21,-0.21,-0.21,-0.25,-0.25,-0.33,-0.33,-0.36,-0.24,-0.2,-0.11,-0.19,-0.36,-0.61,-0.87,-0.99,-1.12,-1.14,-1.19,-1.12,-0.89,-0.59,-0.37,-0.32,-0.36,-0.55,-0.69,-0.98,-1.04,-0.85,-0.7,-0.54,-0.49,-0.52,-0.46,-0.52,-0.48,-0.75,-0.72,-0.72,-0.8,-0.95,-1.08,-1.16,-1.26,-1.23,-1.18,-1.1,-1.05,-0.92,-0.83,-0.71,-0.53,-0.48,-0.42,-0.51,-0.57,-0.84,-0.82,-0.85,-0.78,-0.77,-0.72,-0.73,-0.9,-0.94,-0.91,-0.85,-0.81,-0.7,-0.7,-0.6,-0.72,-0.71,-0.66,-0.55,-0.45,-0.25,-0.28,-0.38,-0.54,-0.64,-0.95,-1.26,-1.49,-1.33,-0.71,-0.39,-0.37,-0.71,-0.89,-0.8,-0.52,-0.54,-0.72,-0.91,-0.95,-1.07,-1.18,-0.83,-0.89,-0.84,-0.83,-0.71,-0.71,-0.89,-1.06,-1.19,-1.21,-1.13,-1.1,-1.07,-0.84,-0.71,-0.54,-0.35,-0.23,-0.3,-0.67,-1.13,-1.45,-1.33,-1.01,-0.74,-0.64,-0.55,-0.37,-0.31,-0.37,-0.8,-0.85,-0.7,-0.56,-0.42,-0.31,-0.26,-0.27,-0.41,-0.66,-1.13,-1.28,-1.19,-0.94,-0.74,-0.8,-0.9,-0.98,-1.07,-1.13,-1.07,-0.82,-0.68,-0.57:-0.05,-0.27,-0.44,-0.49,-0.51,-0.48,-0.51,-0.5,-0.36,-0.31,-0.36,-0.33,-0.31,-0.44,-0.71,-0.81,-0.84,-0.62,-0.29,0.08,0.28,0.31,0.36,0.3,-0.31,-0.73,-0.72,-0.43,-0.16,-0.08,-0.1,-0.11,-0.16,-0.26,-0.38,-0.44,-0.37,-0.29,-0.19,-0.34,-0.56,-0.71,-0.74,-0.72,-0.68,-0.86,-1.0,-0.82,-0.35,0.08,0.33,0.36,0.07,-0.36,-0.45,-0.41,-0.3,-0.11,0.02,-0.07,-0.22,-0.45,-0.61,-0.52,-0.33,-0.16,-0.11,-0.01,0.12,0.21,0.28,0.33,0.24,0.29,0.32,0.34,0.27,0.32,0.34,0.34,0.36,0.32,0.18,0.02,-0.08,0.0,0.12,0.11,0.12,0.14,0.24,0.24,0.26,0.3,0.32,0.27,0.25,0.32,0.33,0.35,0.29,0.17,-0.18,-0.49,-0.56,-0.38,0.18,0.19,-0.42,-0.73,-0.99,-1.09,-1.12,-0.8,-0.24,-0.07,-0.41,-0.75,-0.91,-0.9,-0.79,-0.6,-0.42,-0.31,-0.62,-0.95,-1.1,-0.92,-1.02,-1.1,-1.0,-0.59,-0.27,0.01,0.17,0.29,0.3,0.18,-0.03,-0.53,-1.0,-1.22,-1.1,-0.83,-0.62,-0.33,-0.25,-0.32,-0.38,-0.37,-0.29,-0.35,-0.44,-0.48,-0.35,-0.27,-0.19,-0.21,-0.38,-0.59,-0.78,-0.75,-0.57,-0.28,0.12,0.22,0.19,0.19,0.07,0.08,0.14,0.2,0.17,0.24,0.25,0.16,0.19,0.23,0.17,0.12,0.05,0.03,0.08,0.14,-0.04,-0.03,0.0,0.07,0.21,0.24,0.24,0.2,0.23,0.22,0.17,0.17,0.21,0.16,0.17,0.01,-0.02,0.07,0.06,-0.06,-0.02,-0.03:WALKING
-0.97,-0.97,-0.95,-0.87,-0.91,-1.38,-1.5,-1.22,-1.2,-1.1,-1.19,-1.49,-1.46,-1.44,-1.16,-0.91,-0.97,-0.95,-1.16,-1.26,-1.37,-1.38,-1.12,-0.79,-0.76,-1.14,-1.38,-1.5,-1.32,-1.3,-1.05,-0.84,-0.86,-1.01,-1.16,-1.21,-1.49,-1.35,-0.9,-0.87,-0.98,-1.18,-1.52,-1.57,-1.63,-1.34,-0.98,-0.83,-0.85,-0.98,-1.08,-1.29,-1.5,-1.22,-1.0,-1.08,-1.21,-1.47,-1.63,-1.66,-1.63,-1.23,-1.01,-0.92,-0.94,-0.92,-1.07,-1.46,-1.5,-1.12,-1.13,-1.18,-1.26,-1.57,-1.54,-1.66,-1.33,-1.05,-0.99,-1.01,-1.01,-0.95,-1.19,-1.34,-1.07,-0.92,-1.02,-1.22,-1.41,-1.62,-1.54,-1.52,-1.14,-1.0,-0.94,-0.99,-0.94,-1.02,-1.37,-1.32,-0.96,-1.04,-1.13,-1.29,-1.53,-1.57,-1.66,-1.34,-1.0,-0.94,-0.91,-0.96,-0.92,-1.12,-1.57,-1.37,-0.98,-1.04,-1.17,-1.3,-1.59,-1.61,-1.69,-1.26,-1.0,-0.91,-0.89,-0.9,-0.97,-1.26,-1.48,-1.13,-1.0,-1.16,-1.24,-1.46,-1.55,-1.7,-1.58,-1.17,-1.05,-0.98,-0.96,-0.85,-0.86,-1.3,-1.57,-1.14,-1.12,-1.22,-1.33,-1.49,-1.55,-1.75,-1.45,-1.11,-0.99,-0.95,-0.91,-0.82,-0.99,-1.48,-1.49,-1.08,-1.1,-1.24,-1.36,-1.58,-1.54,-1.66,-1.26,-0.98,-0.88,-0.87,-0.94,-0.92,-1.13,-1.5,-1.26,-1.04,-1.11,-1.19,-1.36,-1.59,-1.66,-1.66,-1.25,-1.01,-0.91,-0.9,-0.89,-0.89,-1.22,-1.62,-1.3,-1.06,-1.12,-1.21,-1.42,-1.58,-1.66,-1.55,-1.1,-0.92,-0.82,-0.88:-0.46,-0.43,-0.45,-0.42,-0.3,-0.24,-0.21,-0.2,-0.16,-0.17,-0.21,-0.32,-0.4,-0.31,-0.31,-0.39,-0.45,-0.48,-0.47,-0.45,-0.38,-0.3,-0.24,-0.21,-0.18,-0.12,-0.08,-0.17,-0.36,-0.4,-0.27,-0.23,-0.36,-0.47,-0.5,-0.47,-0.41,-0.34,-0.29,-0.24,-0.2,-0.17,-0.13,-0.1,-0.21,-0.4,-0.36,-0.23,-0.24,-0.4,-0.46,-0.45,-0.44,-0.45,-0.38,-0.26,-0.21,-0.18,-0.15,-0.12,-0.1,-0.22,-0.43,-0.39,-0.22,-0.2,-0.36,-0.46,-0.42,-0.42,-0.43,-0.4,-0.32,-0.24,-0.2,-0.17,-0.15,-0.12,-0.18,-0.34,-0.38,-0.3,-0.29,-0.37,-0.45,-0.48,-0.49,-0.5,-0.36,-0.25,-0.2,-0.16,-0.12,-0.09,-0.07,-0.17,-0.34,-0.41,-0.35,-0.36,-0.42,-0.5,-0.52,-0.5,-0.45,-0.33,-0.23,-0.2,-0.17,-0.14,-0.11,-0.08,-0.15,-0.33,-0.44,-0.42,-0.35,-0.4,-0.5,-0.5,-0.49,-0.45,-0.33,-0.23,-0.19,-0.17,-0.13,-0.09,-0.07,-0.15,-0.32,-0.45,-0.33,-0.28,-0.44,-0.54,-0.56,-0.56,-0.48,-0.35,-0.24,-0.21,-0.17,-0.14,-0.07,-0.03,-0.14,-0.33,-0.43,-0.31,-0.31,-0.47,-0.58,-0.58,-0.54,-0.44,-0.36,-0.25,-0.18,-0.12,-0.08,-0.03,-0.02,-0.13,-0.4,-0.5,-0.27,-0.32,-0.57,-0.63,-0.61,-0.52,-0.35,-0.28,-0.25,-0.17,-0.12,-0.07,0.01,-0.04,-0.23,-0.55,-0.48,-0.16,-0.24,-0.54,-0.61,-0.55,-0.47,-0.32,-0.22,-0.23,-0.17,-0.13,-0.05,0.0,-0.08,-0.32,-0.46,-0.33,-0.21,-0.34,-0.52,-0.6,-0.62,-0.44:-0.02,-0.17,-0.08,-0.05,-0.05,-0.13,-0.19,-0.18,-0.07,-0.05,0.03,0.09,0.03,0.03,0.07,0.05,0.05,0.03,-0.05,-0.15,-0.11,-0.09,-0.07,-0.13,-0.16,-0.12,-0.01,0.01,0.02,-0.01,-0.12,-0.28,-0.32,-0.39,-0.21,0.0,0.04,-0.09,-0.21,-0.41,-0.28,-0.28,-0.28,-0.15,-0.1,-0.17,-0.54,-0.61,-0.45,-0.28,-0.21,-0.31,-0.39,-0.43,-0.25,-0.43,-0.51,-0.37,-0.28,-0.35,-0.44,-0.54,-0.51,-0.36,-0.34,-0.36,-0.4,-0.4,-0.33,-0.19,-0.12,-0.08,-0.13,-0.03,0.07,-0.05,-0.09,-0.19,-0.16,-0.06,0.01,0.07,0.12,0.08,0.03,0.06,0.07,0.05,0.04,0.03,-0.07,-0.17,-0.14,-0.12,-0.09,-0.14,-0.21,-0.17,-0.12,-0.06,0.0,0.04,0.0,0.0,0.04,0.04,0.02,0.02,-0.07,-0.17,-0.14,-0.13,-0.09,-0.13,-0.18,-0.18,-0.15,-0.11,-0.01,0.06,0.04,0.03,0.04,0.04,0.03,0.02,-0.13,-0.21,-0.16,-0.15,-0.13,-0.18,-0.19,-0.09,0.03,0.03,0.07,0.11,0.07,0.07,0.11,0.11,0.1,0.07,-0.05,-0.14,-0.13,-0.11,-0.12,-0.16,-0.2,-0.16,-0.05,0.06,0.13,0.16,0.16,0.14,0.13,0.14,0.1,0.07,0.02,-0.12,-0.14,-0.08,-0.09,-0.15,-0.18,-0.15,-0.07,0.02,0.05,0.14,0.16,0.11,0.08,0.1,0.1,0.08,0.07,-0.02,-0.13,-0.08,-0.05,-0.08,-0.12,-0.13,-0.12,-0.05,-0.03,0.05,0.08,0.05,0.07,0.08,0.07,0.07,0.07,-0.04,-0.15,-0.09,-0.08,-0.09,-0.13,-0.15:WALKING
-0.38,-0.64,-0.56,-0.5,-0.43,-0.48,-0.64,-0.87,-1.09,-1.25,-1.18,-0.99,-0.71,-0.56,-0.65,-0.96,-1.23,-1.37,-1.21,-0.9,-0.71,-0.57,-0.61,-0.76,-0.97,-1.2,-1.33,-1.19,-1.0,-0.73,-0.62,-0.66,-0.88,-1.11,-1.17,-0.95,-0.75,-0.56,-0.48,-0.56,-0.59,-0.74,-0.6,-0.24,0.23,0.47,0.57,0.65,0.63,0.62,0.7,0.76,0.83,0.78,0.57,0.33,0.19,0.2,0.17,0.21,0.35,0.35,0.3,0.27,0.16,0.11,0.07,0.07,0.13,0.18,0.31,0.28,0.08,-0.06,-0.25,-0.43,-0.55,-0.68,-0.59,-0.53,-0.41,-0.4,-0.47,-0.47,-0.38,-0.21,-0.04,0.17,0.28,0.12,-0.02,-0.24,-0.36,-0.4,-0.41,-0.29,-0.22,-0.15,-0.14,-0.17,-0.17,-0.15,-0.15,-0.13,-0.04,0.14,0.17,0.11,0.04,-0.02,-0.06,-0.01,0.12,0.23,0.25,0.29,0.27,0.27,0.29,0.31,0.27,0.21,0.39,0.58,0.58,0.46,0.33,0.28,0.22,0.14,0.07,0.03,0.04,0.1,0.13,0.12,0.04,-0.04,-0.06,-0.01,0.05,0.23,0.43,0.61,0.52,0.26,0.07,-0.01,-0.04,-0.04,-0.02,0.12,0.07,0.09,0.11,0.02,-0.08,-0.14,-0.21,-0.29,-0.41,-0.44,-0.38,-0.33,-0.31,-0.3,-0.39,-0.5,-0.5,0.01,0.02,0.03,0.07,-0.02,-0.06,-0.17,-0.31,-0.53,-0.59,-0.54,-0.46,-0.41,-0.46,-0.59,-0.71,-0.69,-0.77,-0.75,-0.69,-0.58,-0.45,-0.4,-0.47,-0.54,-0.7,-0.96,-0.97,-0.81,-0.58,-0.55,-0.44,-0.45,-0.49,-0.54,-0.32,0.16:-0.21,-0.03,0.08,0.45,0.51,0.75,0.84,1.17,1.02,0.9,0.81,0.88,0.98,0.97,0.8,0.59,0.51,0.37,0.12,-0.09,-0.29,-0.45,-0.55,-0.46,-0.33,-0.17,-0.15,-0.17,-0.17,-0.19,-0.27,-0.37,-0.34,-0.21,-0.19,-0.22,-0.19,-0.17,-0.42,-0.58,-0.5,-0.41,-0.21,-0.21,-0.22,-0.18,-0.21,-0.26,-0.33,-0.41,-0.25,-0.13,0.03,0.19,0.28,0.3,0.38,0.46,0.49,0.58,0.57,0.45,0.55,0.45,0.4,0.53,0.79,1.18,1.12,0.77,0.58,0.53,0.7,0.84,1.02,1.3,1.22,1.01,0.81,0.63,0.6,0.71,0.86,1.07,1.3,1.37,0.99,0.58,0.36,0.33,0.37,0.52,0.64,0.72,0.71,0.54,0.52,0.49,0.45,0.42,0.18,0.31,0.13,0.11,0.09,0.22,0.36,0.54,0.81,1.07,1.1,1.04,0.86,0.68,0.56,0.64,0.77,0.9,1.06,1.13,0.95,0.64,0.37,0.35,0.43,0.48,0.45,0.9,0.78,0.76,0.63,0.5,0.38,0.49,0.63,0.68,0.99,0.87,0.83,0.8,0.73,0.68,0.6,0.61,0.68,0.7,0.76,0.92,1.05,0.94,0.77,0.57,0.48,0.5,0.52,0.63,0.69,0.9,0.66,0.44,0.4,0.41,0.48,0.57,0.69,0.9,1.08,0.81,0.71,0.38,0.3,0.32,0.27,0.34,0.43,0.49,0.41,0.19,0.19,0.34,0.61,0.67,0.61,0.62,0.87,0.78,0.61,0.42,0.43,0.45,0.34,0.29,0.28,0.29,0.17,0.06,0.0,0.07,0.36,0.8,1.12,1.33,1.2,0.86,0.45,0.13:-0.86,-0.78,-0.65,-0.63,-0.71,-0.77,-0.89,-1.02,-1.16,-1.08,-0.79,-0.45,-0.28,-0.18,-0.29,-0.5,-1.0,-1.09,-1.28,-1.12,-0.8,-0.86,-0.9,-0.93,-0.97,-0.91,-0.93,-0.74,-0.56,-0.36,-0.32,-0.37,-0.32,-0.16,-0.09,-0.21,-0.32,-0.39,-0.33,-0.43,-0.55,-0.61,-0.69,-0.8,-0.9,-0.66,-0.39,-0.31,-0.21,-0.22,-0.16,0.02,0.14,-0.02,-0.17,-0.34,-0.41,-0.46,-0.3,-0.06,0.24,0.14,-0.04,-0.03,-0.06,-0.02,-0.09,-0.09,0.03,0.01,0.06,0.06,0.03,-0.02,0.0,0.01,0.12,0.21,0.06,-0.29,-0.1,-0.06,-0.07,-0.12,-0.16,-0.18,-0.09,-0.03,0.08,0.1,0.02,0.0,0.03,0.05,0.09,0.12,-0.18,-0.2,-0.07,-0.06,-0.07,-0.2,-0.17,-0.09,-0.1,-0.04,0.07,0.06,0.03,0.05,0.08,0.12,0.13,0.03,-0.21,-0.09,-0.04,-0.02,-0.03,-0.1,-0.14,-0.1,-0.01,0.1,0.09,0.03,0.0,0.05,0.08,0.08,0.06,-0.23,-0.24,-0.1,-0.04,-0.08,-0.23,-0.19,-0.07,-0.03,0.03,0.1,0.06,0.01,0.01,0.03,0.09,0.09,0.01,-0.2,-0.08,-0.05,-0.06,-0.19,-0.21,-0.12,0.03,-0.05,0.05,0.07,-0.02,0.0,0.06,0.03,0.03,0.08,-0.2,-0.14,-0.05,-0.05,-0.07,-0.16,-0.16,-0.09,-0.08,0.0,0.07,0.03,-0.03,-0.01,0.04,0.08,0.13,0.03,-0.22,-0.1,-0.08,-0.09,-0.19,-0.21,-0.16,-0.07,-0.12,0.03,0.06,0.0,0.0,0.05,0.07,0.09,0.12,-0.18,-0.19,-0.09,-0.09,-0.1:WALKING
-0.72,-0.73,-0.99,-1.21,-1.23,-1.3,-1.11,-1.22,-1.11,-0.94,-0.92,-0.9,-0.92,-0.9,-1.06,-1.09,-1.32,-1.05,-0.75,-0.71,-0.84,-1.06,-1.24,-1.27,-1.25,-1.22,-1.18,-0.93,-0.81,-0.81,-0.84,-0.93,-0.98,-1.14,-1.14,-1.23,-0.97,-0.67,-0.64,-0.89,-1.2,-1.35,-1.37,-1.14,-1.19,-1.23,-0.98,-0.83,-0.88,-0.85,-0.86,-0.92,-1.12,-1.25,-1.18,-0.85,-0.67,-0.75,-1.07,-1.3,-1.35,-1.35,-1.11,-1.19,-1.13,-0.9,-0.88,-0.86,-0.85,-0.82,-1.0,-1.13,-1.27,-1.11,-0.79,-0.71,-0.82,-1.13,-1.38,-1.39,-1.3,-1.21,-1.23,-1.05,-0.92,-0.92,-0.87,-0.8,-0.79,-1.09,-1.17,-1.24,-1.05,-0.75,-0.75,-0.96,-1.18,-1.37,-1.39,-1.2,-1.14,-1.17,-1.01,-0.94,-0.96,-0.87,-0.78,-0.79,-1.08,-1.2,-1.28,-1.02,-0.74,-0.74,-0.95,-1.23,-1.35,-1.4,-1.17,-1.16,-1.2,-0.98,-0.86,-0.85,-0.82,-0.84,-0.92,-1.13,-1.35,-1.26,-0.85,-0.6,-0.72,-1.07,-1.33,-1.35,-1.41,-1.14,-1.42,-1.27,-1.24,-1.34,-1.25,-1.11,-0.83,-0.65,-0.58,-0.37,-0.25,-0.07,0.02,0.27,0.62,0.89,1.01,1.08,0.8,0.71,0.67,0.62,0.59,0.65,0.53,0.37,0.11,-0.74,-1.18,-1.27,-1.29,-1.47,-1.59,-1.65,-1.48,-1.39,-1.33,-1.32,-1.1,-1.0,-0.97,-0.89,-0.8,-0.69,-0.86,-1.1,-1.24,-1.01,-0.81,-0.81,-1.06,-1.34,-1.38,-1.45,-1.16,-1.24,-1.17,-0.96,-0.92,-0.9,-0.81,-0.74,-0.96,-1.12,-1.3,-1.13,-0.8,-0.7:-0.08,-0.11,-0.23,-0.13,-0.2,-0.28,-0.27,-0.32,-0.39,-0.44,-0.41,-0.36,-0.25,-0.15,-0.14,-0.1,-0.07,-0.03,-0.12,-0.17,-0.2,-0.17,-0.27,-0.31,-0.33,-0.34,-0.39,-0.39,-0.38,-0.32,-0.21,-0.16,-0.11,-0.09,-0.06,-0.12,-0.16,-0.24,-0.15,-0.21,-0.27,-0.27,-0.33,-0.41,-0.4,-0.38,-0.36,-0.28,-0.15,-0.13,-0.1,-0.07,-0.07,-0.13,-0.24,-0.13,-0.19,-0.29,-0.28,-0.33,-0.39,-0.41,-0.39,-0.37,-0.28,-0.16,-0.12,-0.11,-0.11,-0.04,-0.16,-0.17,-0.17,-0.18,-0.27,-0.26,-0.29,-0.33,-0.41,-0.41,-0.4,-0.35,-0.24,-0.12,-0.09,-0.1,-0.05,-0.12,-0.17,-0.23,-0.13,-0.18,-0.26,-0.26,-0.33,-0.39,-0.4,-0.4,-0.39,-0.28,-0.14,-0.11,-0.12,-0.08,-0.07,-0.14,-0.24,-0.14,-0.21,-0.27,-0.26,-0.35,-0.39,-0.37,-0.36,-0.38,-0.29,-0.17,-0.16,-0.14,-0.08,-0.03,-0.1,-0.19,-0.19,-0.19,-0.29,-0.33,-0.36,-0.36,-0.39,-0.34,-0.34,-0.23,-0.15,-0.14,-0.16,-0.08,-0.05,-0.16,-0.19,-0.23,-0.17,-0.24,-0.25,-0.26,-0.3,-0.36,-0.36,-0.36,-0.33,-0.22,-0.15,-0.13,-0.1,-0.05,-0.09,-0.14,-0.23,-0.14,-0.23,-0.28,-0.28,-0.33,-0.37,-0.36,-0.34,-0.32,-0.24,-0.16,-0.12,-0.12,-0.07,-0.11,-0.14,-0.19,-0.2,-0.19,-0.23,-0.25,-0.29,-0.35,-0.43,-0.36,-0.33,-0.26,-0.18,-0.14,-0.09,-0.07,-0.04,-0.12,-0.18,-0.28,-0.21,-0.19,-0.26,-0.29,-0.28,-0.36,-0.4,-0.39,-0.35,-0.26,-0.12,-0.1:0.14,0.19,0.19,0.16,0.26,0.35,0.36,0.35,0.27,0.38,0.05,-0.03,-0.02,0.14,0.23,0.26,0.21,0.28,0.22,0.21,0.27,0.33,0.38,0.34,0.26,0.31,-0.05,-0.08,-0.03,0.23,0.31,0.24,0.21,0.34,0.22,0.17,0.3,0.31,0.31,0.22,0.17,0.28,0.01,-0.07,0.01,0.18,0.36,0.33,0.19,0.25,0.2,0.13,0.23,0.27,0.31,0.23,0.26,0.26,0.13,-0.04,-0.03,0.09,0.24,0.21,0.15,0.22,0.18,0.1,0.17,0.26,0.31,0.35,0.31,0.21,0.18,-0.06,-0.06,0.02,0.2,0.26,0.25,0.2,0.24,0.13,0.15,0.24,0.26,0.33,0.39,0.23,0.29,0.0,-0.07,-0.06,0.11,0.23,0.2,0.13,0.17,0.19,0.12,0.2,0.26,0.32,0.29,0.3,0.25,0.27,-0.06,-0.09,0.01,0.17,0.23,0.22,0.14,0.18,0.15,0.15,0.25,0.32,0.37,0.3,0.24,0.24,0.07,-0.06,-0.07,0.08,0.22,0.22,0.16,0.2,0.2,0.11,0.21,0.3,0.34,0.31,0.3,0.19,0.22,-0.02,-0.03,0.02,0.17,0.24,0.2,0.1,0.17,0.15,0.14,0.28,0.34,0.4,0.3,0.23,0.21,0.15,-0.06,-0.04,0.06,0.21,0.24,0.17,0.14,0.2,0.16,0.17,0.28,0.33,0.37,0.27,0.19,0.28,0.07,-0.07,-0.04,0.07,0.21,0.24,0.15,0.2,0.24,0.19,0.21,0.26,0.29,0.33,0.32,0.22,0.26,-0.01,-0.06,-0.04,0.1,0.19,0.2,0.14,0.21,0.19,0.16,0.24,0.28,0.33,0.23,0.26:WALKING
-0.16,-0.36,-0.36,-0.31,-0.31,-0.37,-0.47,-0.64,-0.95,-1.11,-1.11,-0.88,-0.6,-0.52,-0.51,-0.47,-0.26,0.27,0.51,1.12,0.51,-0.02,-0.29,-0.26,-0.14,-0.02,0.11,0.97,0.44,0.09,-0.04,-0.02,0.09,0.18,0.18,0.47,0.12,-0.03,-0.11,-0.2,-0.12,-0.18,-0.06,-0.04,-0.1,-0.12,-0.14,-0.16,-0.03,0.13,0.11,0.93,0.38,-0.21,-0.39,-0.49,-0.38,-0.02,0.06,0.2,0.23,0.12,-0.1,-0.25,-0.19,0.03,0.37,0.29,-0.03,-0.13,-0.2,-0.23,-0.19,-0.07,-0.28,-0.16,-0.08,-0.06,-0.07,-0.15,-0.11,0.07,0.08,0.07,0.02,-0.02,0.01,-0.04,0.17,-0.32,-0.58,-0.4,-0.35,-0.22,-0.13,-0.24,-0.23,0.36,0.58,-0.04,0.01,0.44,0.06,0.54,-0.14,-0.57,-0.44,-0.19,-0.12,0.01,0.09,0.09,0.42,0.68,0.84,0.94,1.46,1.47,0.89,0.79,0.91,1.0,1.16,1.19,1.38,1.36,1.18,0.9,0.66,0.49,0.44,0.46,0.52,0.79,0.8,1.0,1.3,1.19,0.92,0.86,0.97,1.14,0.98,0.89,0.76,0.65,0.62,0.59,0.47,0.39,0.1,-0.11,-0.25,-0.37,-0.44,-0.57,-0.69,-0.74,-0.56,-0.35,-0.31,-0.32,-0.19,-0.03,0.44,0.28,-0.04,-0.17,-0.24,-0.34,-0.4,-0.42,-0.38,-0.35,-0.28,-0.19,-0.15,-0.15,-0.11,-0.04,0.0,0.08,0.1,-0.01,-0.15,-0.3,-0.35,-0.38,-0.33,-0.2,-0.13,-0.14,-0.19,-0.31,-0.33,-0.17,0.02,0.37,0.42,0.32,0.2,-0.19,-0.28,-0.04,0.34,0.54:-1.26,-1.06,-0.69,-0.29,-0.32,-0.47,-0.81,-1.66,-1.48,-1.04,-0.78,-0.44,-0.15,-0.19,-0.21,-0.32,0.22,0.12,-0.18,-0.21,-0.16,-0.31,-0.68,-1.04,-1.23,-1.1,-0.74,-0.45,-0.46,-0.53,-0.35,-0.22,-0.85,-1.17,-1.23,-1.0,-0.74,-0.53,-0.33,-0.24,-0.32,-0.04,-0.01,-0.21,-0.27,-0.37,-0.47,-0.5,-0.43,-0.46,-0.45,-0.32,-0.28,-0.22,-0.16,-0.13,-0.11,-0.19,-0.26,-0.32,-0.32,-0.37,-0.46,-0.5,-0.55,-0.61,-0.65,-0.53,-0.33,-0.26,-0.25,-0.2,-0.21,-0.17,-0.17,-0.2,-0.25,-0.2,-0.17,-0.3,-0.38,-0.47,-0.5,-0.51,-0.6,-0.49,-0.38,-0.33,-0.26,-0.21,-0.19,-0.18,-0.25,-0.38,-0.38,-0.3,-0.35,-0.42,-0.46,-0.48,-0.5,-0.5,-0.35,-0.31,-0.27,-0.22,-0.2,-0.21,-0.26,-0.32,-0.36,-0.29,-0.23,-0.32,-0.4,-0.3,-0.29,-0.34,-0.32,-0.29,-0.26,-0.28,-0.28,-0.25,-0.23,-0.22,-0.15,-0.16,-0.19,-0.27,-0.34,-0.32,-0.4,-0.36,-0.26,-0.32,-0.3,-0.27,-0.22,-0.22,-0.34,-0.39,-0.2,-0.13,-0.21,-0.27,-0.34,-0.42,-0.46,-0.61,-0.61,-0.46,-0.4,-0.32,-0.31,-0.31,-0.34,-0.28,-0.29,-0.26,-0.22,-0.3,-0.4,-0.47,-0.51,-0.53,-0.63,-0.54,-0.43,-0.35,-0.28,-0.24,-0.21,-0.25,-0.26,-0.34,-0.33,-0.32,-0.36,-0.38,-0.44,-0.52,-0.56,-0.64,-0.44,-0.37,-0.29,-0.23,-0.25,-0.32,-0.38,-0.35,-0.52,-0.38,-0.34,-0.23,-0.28,-0.41,-0.55,-0.6,-0.65,-0.48,-0.36,-0.31,-0.25,-0.22:-0.01,0.07,0.14,0.26,0.3,0.19,0.17,0.15,0.23,0.25,0.36,0.26,0.18,0.06,0.01,0.0,0.07,0.09,0.2,0.3,0.21,0.21,0.13,0.21,0.24,0.37,0.31,0.21,0.07,0.04,0.01,0.03,0.06,0.17,0.3,0.2,0.2,0.24,0.29,0.34,0.41,0.25,0.17,0.01,-0.05,-0.06,-0.01,0.09,0.2,0.25,0.22,0.16,0.14,0.17,0.27,0.32,0.27,0.18,0.14,0.05,0.06,0.05,0.14,0.21,0.2,0.34,0.22,0.18,0.18,0.23,0.28,0.31,0.23,0.21,0.09,0.04,-0.04,0.06,0.15,0.12,0.31,0.28,0.16,0.16,0.14,0.26,0.33,0.31,0.29,0.22,0.12,0.01,-0.02,0.02,0.06,0.18,0.31,0.23,0.24,0.23,0.28,0.29,0.31,0.23,0.17,0.04,-0.02,-0.08,-0.04,-0.04,0.15,0.35,0.41,0.37,0.26,0.23,0.17,0.21,0.32,0.5,0.31,0.17,0.09,0.09,0.17,0.23,0.24,0.46,0.47,0.42,0.3,0.31,0.26,0.28,0.05,0.29,0.26,0.17,0.07,0.1,0.13,0.18,0.28,0.33,0.28,0.25,0.21,0.21,0.32,0.35,0.17,0.26,0.2,0.18,0.18,0.21,0.28,0.33,0.58,0.61,0.55,0.45,0.45,0.4,0.35,0.24,0.32,0.59,0.18,0.2,0.07,0.07,0.05,0.15,0.34,0.5,0.54,0.49,0.44,0.33,0.31,0.28,0.26,0.27,0.3,0.15,0.12,0.1,0.15,0.2,0.3,0.39,0.29,0.28,0.29,0.32,0.31,0.41,0.3,0.31,0.19,0.03,0.05,0.06,0.17,0.29:WALKING
0.46,0.24,0.26,-0.44,-1.44,-0.91,-0.79,-0.69,-0.92,-0.76,-0.41,-0.22,0.1,0.57,0.87,1.02,1.09,0.82,0.5,0.31,0.38,0.48,0.55,0.42,0.22,0.24,0.34,0.41,0.54,0.8,1.04,1.14,1.18,0.96,0.73,0.59,0.46,0.34,0.06,-0.43,-0.99,-1.83,-1.8,-1.46,-1.49,-1.27,-1.1,-1.0,-1.08,-1.14,-1.12,-1.16,-1.46,-1.89,-1.91,-1.2,-0.59,-0.18,0.09,0.32,0.67,1.04,1.12,1.06,1.12,0.77,0.48,0.46,0.51,0.49,0.56,0.45,0.26,-0.02,-0.07,-0.07,0.17,0.2,-0.13,0.09,0.05,0.02,-0.08,-0.34,-0.63,-0.73,-0.72,-0.56,-0.7,-0.4,0.09,0.32,0.53,0.83,1.14,1.27,1.22,0.96,0.72,0.59,0.43,0.17,-0.32,-0.86,-1.3,-1.65,-1.38,-1.05,-1.13,-1.26,-1.33,-1.22,-0.76,-0.71,-0.61,-0.54,-0.76,-1.27,-1.77,-1.79,-1.59,-1.8,-1.52,-1.06,-0.64,-0.19,0.45,0.92,1.22,1.01,0.74,0.56,0.54,0.67,0.72,0.74,0.48,-0.01,-0.39,-0.65,-1.01,-1.4,-1.67,-1.8,-1.51,-1.29,-0.82,-0.38,-0.41,-0.81,-1.0,-0.98,-0.42,-0.45,-0.57,-0.52,-0.63,-1.08,-1.22,-1.63,-1.82,-1.78,-1.34,-0.7,-0.28,-0.1,0.29,0.7,0.74,0.69,0.5,0.39,0.31,0.27,0.21,0.38,-0.2,-0.57,-0.24,0.17,0.1,-0.09,0.01,0.34,0.51,0.54,0.44,0.46,0.61,0.85,1.16,1.34,1.32,1.07,0.76,0.54,0.34,0.19,0.14,-0.07,-0.42,-0.97,-1.3,-1.21,-1.27,-1.34:0.91,0.99,0.78,0.4,0.08,0.0,-0.14,-0.21,-0.66,-1.11,-0.9,-0.92,-0.86,-0.82,-0.87,-0.82,-0.62,-0.54,-0.2,0.03,0.1,0.06,-0.13,-0.55,-0.39,-1.94,-0.27,0.3,0.1,-0.66,-0.81,-0.76,-0.45,-0.08,-0.05,0.01,0.43,0.68,0.7,0.93,0.57,0.24,0.13,-0.11,-0.38,-0.09,-0.05,-0.32,-0.58,-0.36,-0.31,-0.75,-1.19,-0.99,-0.73,-0.47,-0.36,-0.35,-0.28,-0.2,-0.54,-0.77,-0.82,-0.93,-0.67,-0.35,-0.02,0.27,0.43,0.43,0.37,0.33,0.19,-0.07,-0.2,-0.39,-0.47,-0.5,-0.32,-0.26,-0.24,-0.07,0.1,0.31,0.34,0.37,0.55,0.66,0.61,0.27,-0.28,-0.87,-0.88,-0.39,-0.67,-0.86,-0.89,-0.81,-0.67,-0.6,-0.43,-0.13,0.15,0.27,0.04,-0.25,-0.22,-0.19,-0.12,-0.23,-0.37,-0.37,0.0,-0.14,-0.18,-0.32,-0.64,-0.77,-0.82,-0.47,-0.34,-0.37,-0.25,-0.27,-0.57,-0.55,-0.6,-0.54,-0.25,-0.18,-0.09,-0.02,0.09,0.19,0.11,-0.1,-0.18,-0.39,-0.37,-0.05,0.06,0.02,-0.02,-0.4,-0.7,-0.64,-0.44,-0.31,-0.02,0.23,0.43,0.34,0.15,-0.06,0.06,-0.02,-0.32,-1.21,-2.02,-0.97,-0.53,-0.24,-0.15,-0.02,0.19,0.22,0.38,0.59,0.48,0.11,-0.17,-0.22,-0.27,-0.23,-0.31,-0.42,-0.54,-0.51,-0.48,-0.48,-0.62,-0.62,-0.66,-0.59,-0.49,-0.38,-0.36,-0.29,-0.29,-0.23,-0.31,-0.5,-0.44,-0.27,-0.21,-0.25,-0.13,0.03,0.18,0.23,0.16,0.6,0.45,0.25,0.21,0.09:-0.07,-0.09,-0.07,-0.06,-0.21,-0.29,-0.23,-0.24,-0.22,-0.35,-0.48,-0.53,-0.44,-0.32,-0.28,-0.21,-0.08,-0.11,-0.08,-0.12,-0.24,-0.3,-0.23,-0.22,-0.23,-0.35,-0.51,-0.56,-0.44,-0.27,-0.29,-0.19,-0.05,-0.09,-0.04,-0.1,-0.28,-0.26,-0.2,-0.23,-0.25,-0.38,-0.52,-0.54,-0.43,-0.27,-0.3,-0.18,-0.05,-0.04,-0.04,-0.13,-0.28,-0.28,-0.24,-0.26,-0.24,-0.39,-0.52,-0.51,-0.4,-0.26,-0.27,-0.14,-0.02,-0.07,-0.02,-0.08,-0.29,-0.31,-0.27,-0.29,-0.37,-0.51,-0.47,-0.41,-0.26,-0.2,-0.15,-0.02,0.08,0.12,0.07,-0.06,-0.26,-0.24,-0.29,-0.33,-0.41,-0.48,-0.48,-0.39,-0.27,-0.27,-0.15,0.02,0.08,0.07,-0.03,-0.16,-0.3,-0.27,-0.29,-0.41,-0.5,-0.52,-0.49,-0.39,-0.29,-0.19,0.01,0.1,0.16,0.06,-0.2,-0.28,-0.27,-0.27,-0.36,-0.54,-0.61,-0.54,-0.31,-0.33,-0.26,-0.01,0.06,0.1,0.02,-0.18,-0.27,-0.28,-0.29,-0.36,-0.54,-0.63,-0.54,-0.36,-0.37,-0.32,-0.08,0.0,0.03,0.0,-0.12,-0.26,-0.27,-0.27,-0.35,-0.53,-0.51,-0.47,-0.46,-0.41,-0.34,-0.16,-0.04,0.06,0.01,-0.08,-0.22,-0.31,-0.3,-0.34,-0.49,-0.56,-0.54,-0.47,-0.36,-0.33,-0.16,-0.03,0.1,-0.01,-0.1,-0.25,-0.32,-0.28,-0.33,-0.48,-0.57,-0.56,-0.43,-0.38,-0.28,-0.06,0.04,0.09,0.09,-0.04,-0.31,-0.31,-0.31,-0.29,-0.45,-0.58,-0.55,-0.42,-0.31,-0.33,-0.17,-0.02,0.04,0.04,-0.09,-0.24:WALKING
-0.82,-0.85,-0.89,-0.96,-1.14,-1.11,-1.13,-1.04,-0.74,-0.7,-0.83,-0.99,-1.18,-1.2,-1.3,-1.04,-1.05,-1.0,-0.82,-0.79,-0.83,-0.89,-1.05,-1.1,-1.13,-1.0,-1.07,-0.88,-0.69,-0.74,-0.91,-1.04,-1.22,-1.29,-1.25,-1.1,-1.13,-0.92,-0.79,-0.79,-0.83,-0.94,-1.04,-1.2,-1.1,-1.17,-0.95,-0.68,-0.65,-0.84,-1.07,-1.27,-1.34,-1.24,-1.02,-1.11,-0.96,-0.82,-0.84,-0.83,-0.91,-1.0,-1.22,-1.08,-1.17,-0.99,-0.71,-0.64,-0.79,-1.02,-1.26,-1.35,-1.29,-1.06,-1.08,-0.97,-0.83,-0.82,-0.88,-0.92,-0.98,-1.13,-1.08,-1.17,-1.05,-0.74,-0.67,-0.85,-1.02,-1.18,-1.23,-1.32,-1.02,-1.08,-0.98,-0.8,-0.8,-0.86,-0.88,-1.02,-1.14,-1.08,-1.1,-1.06,-0.78,-0.66,-0.77,-0.96,-1.13,-1.25,-1.36,-1.07,-1.09,-1.05,-0.86,-0.81,-0.85,-0.86,-0.97,-1.09,-1.16,-1.12,-1.13,-0.87,-0.65,-0.68,-0.89,-1.12,-1.27,-1.32,-1.11,-1.04,-1.05,-0.89,-0.82,-0.84,-0.86,-0.97,-1.02,-1.17,-1.07,-1.13,-0.94,-0.68,-0.67,-0.86,-1.08,-1.28,-1.37,-1.18,-1.09,-1.07,-0.82,-0.77,-0.81,-0.84,-1.0,-1.1,-1.19,-1.11,-1.13,-0.83,-0.65,-0.69,-0.9,-1.11,-1.26,-1.37,-1.07,-1.04,-1.01,-0.83,-0.82,-0.9,-0.91,-0.99,-1.1,-1.1,-1.11,-1.09,-0.78,-0.63,-0.72,-0.96,-1.24,-1.27,-1.3,-1.02,-1.07,-1.04,-0.85,-0.84,-0.86,-0.86,-1.05,-1.12,-1.1,-1.0,-1.07,-0.82,-0.65,-0.73,-1.0,-1.13,-1.24,-1.34:-0.98,-0.77,-0.39,-0.34,-0.48,-0.91,-1.21,-1.33,-1.26,-1.16,-0.9,-0.67,-0.57,-0.62,-0.79,-1.0,-1.14,-1.12,-1.0,-1.1,-1.28,-1.07,-0.88,-0.82,-0.77,-0.33,0.22,0.84,0.52,0.0,-0.16,-0.15,-0.28,-1.02,-1.65,-1.77,-1.6,-1.4,-1.26,-1.17,-0.98,-0.74,-0.65,-0.61,-0.65,-0.87,-0.87,-0.68,-0.5,-0.44,-0.4,-0.48,-0.68,-1.0,-1.11,-1.09,-1.02,-0.87,-0.74,-0.63,-0.59,-0.62,-0.73,-0.73,-0.47,-0.21,-0.04,-0.27,-0.52,-0.55,-0.62,-0.64,-0.75,-0.83,-0.85,-0.79,-0.71,-0.63,-0.5,-0.37,-0.38,-0.66,-0.89,-0.98,-1.0,-0.86,-0.63,-0.45,-0.39,-0.27,0.22,0.73,0.67,0.4,-0.1,-0.54,-0.66,-0.71,-0.39,0.69,0.88,0.66,0.45,-0.14,-0.55,-0.77,-0.87,-0.57,-0.73,-0.51,-0.33,-0.51,-0.71,-0.82,-0.94,-0.96,-1.11,-1.0,-0.81,-0.66,-0.7,-0.06,0.71,0.37,-0.26,-0.94,-0.85,-0.92,-0.98,-1.04,-0.97,-1.0,-1.18,-1.33,-1.29,-1.36,-1.17,-0.76,-0.58,-0.52,-0.5,-0.29,-0.11,-0.32,-0.21,-0.34,-0.47,-0.52,-0.51,-0.59,-0.66,-0.65,-0.6,-0.62,-0.49,-0.31,-0.25,-0.28,-0.25,-0.19,-0.12,-0.17,-0.26,-0.33,-0.27,-0.29,-0.33,-0.36,-0.44,-0.57,-0.59,-0.49,-0.45,-0.36,-0.32,-0.23,-0.15,-0.12,-0.15,-0.14,-0.27,-0.36,-0.52,-0.42,-0.32,-0.23,-0.27,-0.46,-0.76,-0.9,-0.89,-0.97,-0.94,-0.87,-0.72,-0.6,-0.51,-0.46,-0.45,-0.65,-1.13,-0.98,-0.68,-0.48,-0.27,-0.09:0.27,0.28,0.19,0.19,0.17,0.07,-0.1,-0.08,0.02,0.15,0.2,0.16,0.12,0.17,0.16,0.1,0.2,0.26,0.27,0.2,0.22,0.17,0.13,-0.13,-0.06,0.0,0.14,0.23,0.23,0.14,0.17,0.16,0.08,0.17,0.24,0.3,0.33,0.25,0.14,0.18,-0.02,-0.04,0.04,0.15,0.23,0.2,0.11,0.16,0.19,0.16,0.17,0.25,0.26,0.29,0.25,0.14,0.15,-0.04,-0.05,-0.02,0.1,0.21,0.15,0.16,0.24,0.16,0.16,0.24,0.24,0.29,0.34,0.28,0.23,-0.09,-0.12,-0.06,0.1,0.14,0.17,0.25,0.28,0.15,0.17,0.25,0.27,0.27,0.24,0.18,0.22,-0.08,-0.09,-0.01,0.16,0.22,0.21,0.23,0.24,0.14,0.14,0.23,0.27,0.29,0.25,0.13,0.25,-0.01,-0.04,-0.02,0.09,0.21,0.18,0.13,0.19,0.14,0.1,0.17,0.22,0.25,0.22,0.24,0.28,0.12,-0.06,-0.06,0.06,0.23,0.23,0.16,0.17,0.2,0.1,0.17,0.25,0.27,0.29,0.23,0.17,0.21,0.0,-0.07,-0.03,0.12,0.24,0.2,0.14,0.19,0.17,0.12,0.2,0.26,0.31,0.28,0.28,0.19,0.04,-0.11,-0.1,-0.01,0.19,0.2,0.14,0.15,0.16,0.07,0.11,0.24,0.25,0.31,0.28,0.17,0.2,0.0,-0.08,-0.1,-0.07,0.1,0.19,0.17,0.24,0.18,0.11,0.16,0.22,0.26,0.21,0.19,0.16,0.17,-0.06,-0.07,0.0,0.17,0.25,0.19,0.16,0.22,0.1,0.12,0.22,0.23,0.27,0.21,0.17,0.26,0.01,-0.12:WALKING
-0.8,-0.84,-0.85,-0.96,-1.13,-1.17,-1.29,-0.98,-0.57,-0.57,-0.91,-1.22,-1.39,-1.47,-1.11,-1.22,-1.08,-0.82,-0.78,-0.84,-0.97,-1.0,-1.17,-1.08,-1.2,-0.94,-0.64,-0.65,-0.89,-1.22,-1.39,-1.44,-1.13,-1.22,-1.08,-0.82,-0.83,-0.89,-0.92,-0.94,-1.08,-1.13,-1.32,-0.99,-0.62,-0.56,-0.88,-1.24,-1.39,-1.52,-1.11,-1.18,-1.0,-0.78,-0.79,-0.85,-0.93,-0.98,-1.16,-1.13,-1.26,-0.89,-0.57,-0.62,-0.94,-1.28,-1.38,-1.5,-1.12,-1.22,-1.0,-0.79,-0.8,-0.86,-0.96,-0.95,-1.09,-1.22,-1.28,-0.85,-0.6,-0.68,-1.01,-1.36,-1.41,-1.33,-1.2,-1.16,-0.9,-0.81,-0.84,-0.83,-0.97,-1.0,-1.08,-1.27,-1.22,-0.8,-0.62,-0.72,-1.05,-1.37,-1.44,-1.26,-1.21,-1.18,-0.91,-0.82,-0.89,-0.88,-0.94,-1.02,-1.13,-1.38,-1.08,-0.68,-0.54,-0.83,-1.26,-1.4,-1.48,-1.16,-1.2,-1.07,-0.81,-0.78,-0.88,-0.95,-0.96,-1.13,-1.17,-1.2,-0.86,-0.59,-0.65,-0.99,-1.26,-1.33,-1.36,-1.12,-1.22,-1.04,-0.86,-0.88,-0.9,-0.93,-0.94,-1.07,-1.23,-1.23,-0.85,-0.61,-0.68,-1.01,-1.33,-1.42,-1.35,-1.16,-1.14,-0.94,-0.81,-0.82,-0.85,-1.0,-1.05,-1.13,-1.26,-1.16,-0.78,-0.55,-0.68,-1.1,-1.35,-1.39,-1.25,-1.19,-1.13,-0.89,-0.81,-0.86,-0.86,-0.95,-1.08,-1.13,-1.2,-1.08,-0.73,-0.63,-0.84,-1.13,-1.35,-1.4,-1.2,-1.23,-1.18,-0.9,-0.86,-0.86,-0.85,-0.87,-1.01,-1.18,-1.39,-1.11,-0.73,-0.62:-0.27,-0.23,-0.18,-0.15,-0.14,-0.14,-0.19,-0.29,-0.3,-0.2,-0.22,-0.24,-0.24,-0.26,-0.27,-0.29,-0.28,-0.33,-0.35,-0.3,-0.24,-0.21,-0.17,-0.15,-0.14,-0.18,-0.2,-0.29,-0.24,-0.21,-0.24,-0.24,-0.26,-0.27,-0.29,-0.28,-0.29,-0.33,-0.33,-0.27,-0.21,-0.19,-0.14,-0.14,-0.14,-0.19,-0.2,-0.3,-0.26,-0.22,-0.25,-0.24,-0.27,-0.29,-0.32,-0.3,-0.33,-0.29,-0.3,-0.25,-0.26,-0.23,-0.19,-0.17,-0.16,-0.2,-0.2,-0.27,-0.26,-0.21,-0.21,-0.22,-0.24,-0.26,-0.29,-0.31,-0.3,-0.33,-0.3,-0.25,-0.21,-0.19,-0.13,-0.14,-0.14,-0.19,-0.19,-0.27,-0.23,-0.17,-0.19,-0.25,-0.25,-0.27,-0.3,-0.31,-0.3,-0.31,-0.29,-0.21,-0.21,-0.23,-0.19,-0.15,-0.12,-0.1,-0.11,-0.23,-0.22,-0.25,-0.21,-0.21,-0.24,-0.28,-0.22,-0.14,-0.13,-0.07,-0.02,-0.03,-0.06,-0.15,-0.25,-0.33,-0.37,-0.38,-0.39,-0.43,-0.57,-0.62,-0.5,-0.29,-0.17,-0.14,-0.11,-0.09,-0.09,-0.1,-0.1,-0.21,-0.23,-0.25,-0.22,-0.27,-0.33,-0.37,-0.43,-0.4,-0.34,-0.28,-0.19,-0.15,-0.14,-0.12,-0.13,-0.2,-0.19,-0.29,-0.22,-0.26,-0.3,-0.33,-0.33,-0.34,-0.34,-0.37,-0.38,-0.31,-0.25,-0.19,-0.09,-0.09,-0.08,-0.15,-0.21,-0.27,-0.24,-0.23,-0.26,-0.27,-0.31,-0.38,-0.36,-0.36,-0.33,-0.22,-0.17,-0.15,-0.11,-0.07,-0.06,-0.15,-0.29,-0.23,-0.21,-0.27,-0.3,-0.33,-0.33,-0.36,-0.36,-0.36,-0.28,-0.14,-0.14,-0.14:0.03,0.13,0.1,0.09,0.14,0.11,0.2,0.22,0.17,0.24,0.36,0.13,-0.03,-0.17,-0.39,-0.62,-0.8,-0.66,-0.6,-0.51,-0.56,-0.78,-0.93,-0.81,-0.59,-0.14,0.2,0.31,0.22,0.01,-0.34,-0.67,-0.71,-0.61,-0.53,-0.52,-0.44,-0.53,-0.11,-0.14,0.06,-0.04,-0.11,-0.17,-0.17,-0.03,0.01,0.14,0.12,0.09,0.06,0.07,0.14,0.19,0.1,0.01,-0.03,-0.01,0.03,0.08,0.08,0.08,0.04,0.08,0.1,0.12,0.17,0.16,0.17,0.15,0.15,0.09,0.1,0.06,-0.03,-0.05,-0.03,0.01,0.03,0.05,0.09,0.08,0.15,0.15,0.17,0.18,0.19,0.19,0.13,0.08,-0.03,-0.01,-0.07,-0.06,-0.03,0.03,0.11,0.15,0.15,0.13,0.1,0.15,0.1,0.11,0.16,0.13,0.16,0.15,0.17,0.13,0.09,-0.06,-0.05,-0.02,-0.01,0.03,0.15,0.16,0.17,0.13,0.17,0.28,0.36,0.41,0.43,0.34,0.16,0.05,-0.14,-0.22,-0.11,-0.08,-0.02,0.06,0.1,0.21,0.37,0.21,0.08,0.05,0.05,0.06,0.12,0.19,0.22,0.17,0.11,-0.03,-0.12,-0.25,-0.31,-0.35,-0.24,-0.18,-0.15,-0.21,-0.29,-0.29,-0.25,-0.28,-0.3,-0.41,-0.48,-0.5,-0.5,-0.5,-0.53,-0.6,-0.61,-0.31,0.1,0.53,0.59,0.47,0.31,0.24,0.28,0.29,0.23,0.14,0.1,0.09,0.0,-0.05,0.03,0.14,0.07,0.04,0.12,0.31,0.35,0.25,0.17,0.01,-0.12,-0.25,-0.18,-0.03,-0.02,-0.12,-0.26,-0.36,-0.39,-0.36,-0.31,-0.39:WALKING
-1.41,-1.17,-0.66,-0.53,-0.89,-1.34,-1.44,-1.5,-1.27,-1.3,-1.0,-0.77,-0.8,-0.87,-0.95,-1.0,-1.07,-1.38,-1.13,-0.69,-0.6,-0.91,-1.39,-1.38,-1.52,-1.33,-1.33,-0.9,-0.76,-0.83,-0.86,-0.95,-1.06,-1.18,-1.47,-1.07,-0.66,-0.67,-1.06,-1.39,-1.37,-1.34,-1.37,-1.19,-0.84,-0.86,-0.98,-0.93,-0.84,-1.04,-1.25,-1.34,-0.89,-0.65,-0.78,-1.19,-1.46,-1.57,-1.33,-1.48,-1.13,-0.87,-0.85,-0.81,-0.85,-0.89,-1.12,-1.46,-1.3,-0.85,-0.67,-0.84,-1.26,-1.4,-1.5,-1.22,-1.3,-1.13,-0.88,-0.89,-0.92,-0.92,-0.91,-1.04,-1.34,-1.24,-0.84,-0.7,-0.91,-1.32,-1.42,-1.52,-1.24,-1.39,-1.07,-0.85,-0.92,-0.97,-0.99,-0.97,-1.05,-1.33,-1.12,-0.73,-0.71,-1.11,-1.45,-1.39,-1.42,-1.33,-1.34,-0.96,-0.85,-0.92,-0.87,-0.86,-1.07,-1.26,-1.42,-1.01,-0.67,-0.74,-1.11,-1.44,-1.37,-1.26,-1.33,-1.33,-1.02,-0.94,-0.98,-0.91,-0.85,-0.96,-1.19,-1.47,-1.08,-0.74,-0.76,-1.05,-1.41,-1.38,-1.33,-1.23,-1.36,-1.07,-0.97,-0.98,-0.91,-0.83,-0.89,-1.07,-1.45,-1.2,-0.79,-0.73,-1.04,-1.34,-1.3,-1.37,-1.21,-1.42,-1.17,-1.0,-1.0,-0.92,-0.8,-0.66,-0.91,-1.29,-1.55,-1.13,-0.9,-0.77,-0.89,-1.12,-1.45,-1.42,-1.08,-0.83,-0.82,-0.92,-1.05,-1.12,-1.05,-1.13,-1.35,-1.69,-1.52,-1.06,-0.81,-0.7,-0.7,-0.84,-1.09,-1.47,-1.53,-1.38,-1.14,-1.18,-1.12,-1.07,-1.0,-0.99,-0.9,-0.83:-0.18,-0.17,-0.32,-0.33,-0.39,-0.44,-0.48,-0.43,-0.44,-0.4,-0.34,-0.21,-0.11,-0.12,-0.16,-0.16,-0.17,-0.18,-0.24,-0.26,-0.21,-0.24,-0.23,-0.3,-0.44,-0.53,-0.49,-0.43,-0.42,-0.35,-0.28,-0.18,-0.12,-0.11,-0.16,-0.16,-0.22,-0.2,-0.29,-0.2,-0.2,-0.27,-0.28,-0.36,-0.46,-0.48,-0.44,-0.41,-0.38,-0.33,-0.24,-0.15,-0.12,-0.13,-0.17,-0.21,-0.29,-0.26,-0.3,-0.22,-0.25,-0.27,-0.22,-0.42,-0.56,-0.57,-0.52,-0.48,-0.44,-0.36,-0.27,-0.18,-0.14,-0.19,-0.19,-0.24,-0.25,-0.26,-0.29,-0.27,-0.28,-0.25,-0.26,-0.32,-0.42,-0.51,-0.67,-0.69,-0.53,-0.43,-0.33,-0.25,-0.17,-0.1,0.0,0.01,-0.09,-0.2,-0.25,-0.26,-0.29,-0.23,-0.17,-0.14,-0.32,-0.33,-0.39,-0.35,-0.44,-0.55,-0.55,-0.54,-0.51,-0.49,-0.37,-0.44,-0.47,-0.4,-0.37,-0.42,-0.5,-0.52,-0.5,-0.51,-0.48,-0.47,-0.49,-0.49,-0.53,-0.57,-0.56,-0.58,-0.6,-0.64,-0.69,-0.71,-0.6,-0.51,-0.49,-0.46,-0.44,-0.38,-0.21,-0.27,-0.18,-0.25,-0.31,-0.37,-0.41,-0.35,-0.29,-0.15,0.06,0.11,0.0,-0.2,-0.26,-0.29,-0.36,-0.35,-0.36,-0.34,-0.29,-0.27,-0.2,-0.2,-0.25,-0.28,-0.28,-0.33,-0.36,-0.36,-0.39,-0.36,-0.31,-0.23,-0.23,-0.22,-0.19,-0.17,-0.19,-0.22,-0.22,-0.29,-0.24,-0.23,-0.25,-0.29,-0.33,-0.33,-0.34,-0.32,-0.33,-0.33,-0.31,-0.26,-0.22,-0.21,-0.18,-0.19,-0.19,-0.25,-0.22,-0.31,-0.29,-0.26:0.17,0.14,0.17,0.18,0.2,0.2,0.16,0.2,0.13,0.14,0.13,0.05,0.02,0.0,0.02,0.08,0.12,0.16,0.11,0.13,0.16,0.12,0.15,0.18,0.17,0.24,0.24,0.23,0.1,0.06,-0.04,0.02,0.02,0.02,0.06,0.14,0.16,0.15,0.13,0.15,0.13,0.1,0.13,0.15,0.13,0.17,0.17,0.16,0.13,0.17,0.09,0.08,0.04,0.05,0.09,0.12,0.14,0.17,0.16,0.2,0.1,0.13,0.21,0.19,0.2,0.17,0.2,0.09,0.12,0.12,0.03,0.05,0.04,0.05,0.09,0.13,0.16,0.15,0.14,0.17,0.12,0.14,0.17,0.14,0.15,0.17,0.23,0.15,0.1,0.08,0.03,0.02,0.03,0.04,0.1,0.13,0.15,0.12,0.12,0.13,0.14,0.16,0.17,0.17,0.19,0.16,0.22,0.11,0.17,0.11,0.04,0.02,0.0,0.06,0.12,0.13,0.15,0.14,0.17,0.13,0.15,0.23,0.29,0.23,0.18,0.13,0.13,0.05,0.16,0.1,0.08,0.07,0.04,0.01,0.07,0.12,0.14,0.12,0.14,0.13,0.12,0.16,0.13,0.12,0.17,0.14,0.18,0.11,0.2,0.1,-0.02,0.04,0.07,0.04,0.05,0.1,0.11,0.1,0.15,0.17,0.15,0.18,0.2,0.17,0.18,0.13,0.17,0.08,0.1,0.07,0.02,0.07,0.05,0.06,0.09,0.13,0.17,0.15,0.13,0.16,0.15,0.17,0.19,0.17,0.13,0.15,0.13,0.2,0.08,0.08,0.1,0.08,0.1,0.09,0.08,0.1,0.1,0.1,0.08,0.15,0.28,0.27,0.22,0.17,0.13,0.19:WALKING
-0.27,-0.31,-0.56,-0.14,-0.51,-0.73,-0.57,-0.65,-0.83,-0.46,-0.47,-0.46,-0.5,-0.31,0.08,0.6,0.93,1.26,1.02,0.85,0.76,0.81,0.89,1.07,1.23,1.39,1.27,0.96,0.82,0.73,0.79,0.96,1.0,1.06,1.26,1.0,0.75,0.7,0.93,1.17,1.28,1.36,1.52,1.26,0.99,0.86,0.85,1.08,1.16,1.16,0.98,0.67,0.43,0.44,0.64,0.71,0.9,1.07,1.09,1.0,0.74,0.66,0.74,0.92,1.0,1.06,1.12,1.2,1.02,0.89,0.92,1.0,1.14,1.19,1.4,1.52,1.16,0.92,0.8,0.82,1.0,1.04,1.06,1.16,0.89,0.77,0.85,0.93,1.08,1.21,1.57,1.4,0.98,0.68,0.6,0.76,1.09,1.14,1.18,1.36,1.16,0.94,0.96,1.13,1.33,1.37,1.51,1.76,1.28,0.9,0.82,0.87,1.0,1.02,1.12,1.25,1.09,0.89,0.98,1.12,1.26,1.36,1.44,1.8,1.53,1.08,0.73,0.61,0.65,0.83,0.99,1.26,1.36,1.04,0.88,0.92,1.16,1.42,1.41,1.46,1.41,0.97,0.72,0.75,0.92,1.02,1.0,1.18,1.39,1.02,0.72,0.75,0.95,1.17,1.26,1.47,1.58,1.26,0.94,0.79,0.75,0.89,0.89,1.06,1.35,1.21,0.95,1.01,1.18,1.24,1.32,1.33,1.66,1.44,0.97,0.79,0.76,0.95,1.1,1.02,1.07,1.2,1.04,1.01,1.1,1.19,1.26,1.27,1.37,1.46,1.17,0.96,0.9,0.94,1.07,1.02,1.0,1.22,1.1,0.89,0.96,1.13,1.25,1.29,1.36,1.59:0.22,0.46,0.56,0.62,0.57,0.67,0.87,0.95,0.85,0.73,0.65,0.45,0.32,0.3,0.19,0.15,0.16,0.34,0.56,0.68,0.61,0.64,0.75,0.81,0.79,0.68,0.59,0.38,0.28,0.17,0.01,0.07,0.25,0.47,0.63,0.51,0.58,0.67,0.73,0.77,0.61,0.49,0.33,0.19,0.18,0.23,0.3,0.4,0.35,0.4,0.38,0.44,0.53,0.78,0.81,0.68,0.58,0.46,0.28,0.16,0.04,0.06,0.22,0.36,0.51,0.56,0.62,0.71,0.77,0.69,0.68,0.53,0.39,0.31,0.2,0.06,0.04,0.14,0.25,0.55,0.69,0.57,0.78,0.8,0.73,0.65,0.55,0.37,0.28,0.22,0.06,0.01,0.13,0.3,0.54,0.68,0.62,0.6,0.7,0.78,0.81,0.61,0.4,0.34,0.26,0.12,0.11,0.14,0.26,0.42,0.54,0.74,0.66,0.64,0.61,0.67,0.44,0.4,0.23,0.15,0.05,0.03,0.1,0.28,0.4,0.51,0.43,0.48,0.52,0.62,0.6,0.53,0.42,0.22,0.08,0.0,-0.03,0.08,0.3,0.5,0.54,0.35,0.43,0.5,0.56,0.55,0.54,0.41,0.36,0.28,0.24,0.17,0.04,0.19,0.38,0.45,0.39,0.39,0.54,0.56,0.57,0.59,0.48,0.42,0.24,0.11,0.11,0.09,0.18,0.3,0.47,0.56,0.37,0.39,0.47,0.58,0.62,0.62,0.57,0.44,0.35,0.26,0.17,0.12,0.19,0.32,0.53,0.68,0.44,0.65,0.74,0.69,0.68,0.7,0.5,0.37,0.24,0.12,0.14,0.17,0.28,0.43,0.52,0.51,0.42,0.53:0.13,0.31,0.28,0.23,0.24,0.21,0.2,0.19,0.16,0.1,0.12,0.07,0.05,-0.01,-0.05,-0.06,0.04,0.14,0.21,0.19,0.18,0.2,0.2,0.18,0.21,0.18,0.09,0.17,0.11,0.05,0.0,-0.1,-0.11,-0.01,-0.01,0.16,0.27,0.19,0.21,0.22,0.2,0.2,0.2,0.13,0.2,0.18,0.02,-0.09,-0.03,-0.08,0.05,0.1,0.31,0.22,0.13,0.18,0.3,0.28,0.25,0.19,0.15,0.08,0.04,-0.04,-0.15,-0.13,-0.05,0.29,0.2,0.09,0.18,0.34,0.36,0.31,0.27,0.11,0.06,0.06,0.05,-0.11,-0.25,-0.16,-0.04,0.28,0.15,0.06,0.16,0.28,0.28,0.22,0.15,0.08,0.14,-0.02,-0.15,-0.18,-0.18,-0.09,-0.02,0.3,0.18,0.07,0.14,0.21,0.27,0.2,0.2,0.07,0.12,0.07,0.01,-0.09,-0.17,-0.19,-0.11,0.21,0.17,0.05,0.08,0.17,0.16,0.23,0.25,0.19,0.17,0.06,-0.11,-0.29,-0.31,-0.18,-0.07,0.09,0.31,0.07,0.07,0.09,0.06,0.07,0.05,0.11,0.06,0.07,0.08,0.1,0.02,-0.06,0.26,0.01,0.18,0.26,0.04,0.04,0.07,0.16,0.19,0.2,0.17,0.14,0.15,0.01,-0.03,0.01,0.07,0.12,0.16,0.14,0.04,0.08,0.12,0.26,0.32,0.17,0.11,0.18,0.12,0.12,0.03,-0.09,-0.02,-0.06,0.14,0.31,0.15,0.18,0.24,0.23,0.25,0.18,0.1,0.14,0.12,0.09,0.03,0.05,-0.02,0.0,0.1,0.34,0.21,0.21,0.22,0.25,0.28,0.25,0.13,0.12:WALKING
1.4,1.23,1.29,1.77,1.64,1.25,1.11,1.1,1.13,1.09,1.12,1.3,1.25,1.06,1.07,1.35,1.38,1.34,1.39,1.71,1.52,1.2,1.05,1.07,1.18,1.06,1.06,1.25,1.19,1.02,1.13,1.38,1.4,1.26,1.38,1.7,1.39,1.08,0.98,1.07,1.14,1.08,1.13,1.34,1.24,1.11,1.16,1.29,1.28,1.34,1.46,1.79,1.42,1.1,0.98,1.02,1.0,0.95,1.07,1.41,1.34,1.17,1.2,1.3,1.21,1.23,1.45,1.8,1.42,1.09,0.98,0.89,0.96,0.98,1.06,1.36,1.28,1.0,1.0,1.1,1.25,1.24,1.32,1.55,1.52,1.24,1.06,0.96,0.87,0.95,1.04,1.1,1.25,1.12,0.83,0.8,0.97,1.22,1.37,1.27,1.39,1.42,1.16,1.0,0.87,0.84,0.98,1.0,1.16,1.4,1.14,0.92,1.0,1.16,1.29,1.3,1.38,1.64,1.26,0.94,0.94,1.05,1.11,1.02,1.04,1.21,1.02,0.91,1.09,1.33,1.36,1.33,1.47,1.61,1.19,0.98,1.0,1.11,1.09,1.06,1.16,1.29,1.07,1.01,1.16,1.27,1.25,1.39,1.7,1.53,1.09,0.95,0.98,1.07,1.07,1.08,1.18,1.13,0.93,1.0,1.16,1.23,1.26,1.39,1.67,1.39,0.93,0.81,0.94,1.11,1.1,1.17,1.39,1.2,0.94,1.02,1.26,1.32,1.34,1.55,1.66,1.2,0.92,0.92,1.09,1.17,1.07,1.07,1.18,1.01,0.97,1.12,1.32,1.29,1.26,1.42,1.53,1.18,0.95,0.96,1.06,1.11,1.13,1.21,1.25,1.0:0.59,0.64,0.67,0.63,0.62,0.54,0.42,0.31,0.32,0.31,0.21,0.17,0.17,0.23,0.35,0.43,0.62,0.75,0.49,0.48,0.49,0.41,0.42,0.35,0.31,0.24,0.15,0.12,0.22,0.28,0.43,0.45,0.5,0.54,0.53,0.55,0.46,0.45,0.4,0.38,0.3,0.25,0.21,0.18,0.18,0.21,0.28,0.44,0.48,0.48,0.53,0.57,0.51,0.44,0.41,0.4,0.35,0.28,0.21,0.14,0.13,0.27,0.25,0.33,0.44,0.57,0.61,0.68,0.72,0.62,0.6,0.49,0.4,0.25,0.28,0.22,0.15,0.17,0.28,0.42,0.52,0.64,0.65,0.55,0.62,0.6,0.62,0.53,0.39,0.33,0.28,0.19,0.15,0.15,0.19,0.32,0.42,0.54,0.54,0.51,0.68,0.65,0.59,0.54,0.47,0.31,0.28,0.22,0.14,0.11,0.17,0.34,0.42,0.41,0.58,0.75,0.69,0.72,0.65,0.7,0.52,0.41,0.3,0.26,0.21,0.14,0.17,0.21,0.35,0.37,0.37,0.48,0.52,0.53,0.65,0.61,0.56,0.4,0.32,0.26,0.2,0.16,0.16,0.24,0.29,0.33,0.29,0.4,0.44,0.4,0.46,0.62,0.83,0.72,0.73,0.6,0.37,0.18,0.16,0.14,0.31,0.51,0.56,0.59,0.75,0.64,0.6,0.52,0.78,0.61,0.36,0.26,0.14,0.11,0.14,0.18,0.28,0.31,0.36,0.38,0.42,0.49,0.43,0.48,0.64,0.55,0.43,0.37,0.23,0.14,0.11,0.16,0.31,0.46,0.49,0.61,0.52,0.44,0.47,0.58,0.54,0.62,0.48,0.42,0.39,0.33:0.09,-0.21,-0.13,-0.25,-0.33,-0.35,-0.25,-0.23,-0.23,-0.13,0.11,0.17,-0.3,-0.47,-0.24,0.17,0.5,0.57,0.36,0.05,-0.07,-0.25,-0.51,-1.04,-0.71,-0.26,0.61,0.72,0.81,0.61,0.18,-0.13,-0.37,-0.33,-0.22,-0.14,-0.23,-0.17,-0.25,-0.4,-0.37,-0.32,-0.39,-0.69,-0.43,0.22,0.57,0.78,0.53,0.56,0.23,0.01,-0.52,-0.21,0.08,0.34,0.5,0.79,1.2,1.28,0.33,-0.39,-0.56,0.15,0.19,0.32,0.53,0.53,0.63,0.55,0.32,0.15,-0.46,-0.73,-0.34,0.04,0.02,0.18,0.5,0.6,0.72,0.81,0.6,0.5,0.27,0.02,-0.22,-0.45,-0.65,-0.47,0.21,0.41,0.44,0.56,0.58,0.58,0.54,0.47,0.28,0.07,-0.19,-0.2,-0.21,-0.26,-0.27,-0.29,-0.16,-0.16,-0.17,-0.25,-0.32,-0.36,-0.34,-0.38,-0.26,-0.23,-0.32,-0.31,-0.33,-0.47,-0.55,-0.52,-0.09,0.1,0.07,-0.11,-0.21,-0.28,-0.24,-0.19,-0.04,0.03,-0.06,-0.12,-0.26,-0.34,-0.44,-0.39,-0.14,-0.05,-0.19,-0.18,-0.17,-0.24,-0.26,-0.26,-0.16,-0.01,-0.27,-0.4,-0.63,-0.59,-0.19,0.23,0.58,0.7,0.62,0.34,0.33,0.51,0.15,-0.04,-0.32,-0.19,-0.24,-0.18,0.08,0.16,0.21,0.38,0.4,0.43,0.34,0.11,-0.28,-0.52,-0.65,-0.8,-0.82,-0.75,-0.64,-0.47,-0.39,-0.47,-0.65,-0.78,-0.56,-0.58,-0.51,-0.38,-0.3,-0.38,-0.5,-0.68,-0.88,-0.88,-0.68,-0.24,-0.15,-0.36,-0.76,-1.45,-1.57,-0.96,-0.06,0.3:WALKING
-0.98,-1.17,-1.26,-1.26,-1.04,-1.04,-0.99,-0.84,-0.82,-0.82,-0.85,-1.0,-1.17,-1.1,-1.11,-1.09,-0.81,-0.65,-0.66,-0.88,-1.1,-1.22,-1.33,-1.13,-1.02,-1.07,-0.93,-0.83,-0.84,-0.81,-0.88,-1.01,-1.21,-1.06,-1.13,-1.02,-0.74,-0.64,-0.74,-0.97,-1.14,-1.24,-1.29,-1.02,-1.05,-1.09,-0.88,-0.84,-0.91,-0.82,-0.89,-1.0,-1.23,-1.04,-1.11,-0.99,-0.73,-0.66,-0.79,-1.02,-1.25,-1.29,-1.24,-1.04,-1.07,-0.99,-0.82,-0.79,-0.85,-0.9,-0.96,-0.96,-1.13,-1.08,-1.11,-1.01,-0.79,-0.68,-0.73,-0.91,-1.12,-1.24,-1.35,-1.08,-1.07,-1.08,-0.88,-0.82,-0.83,-0.82,-0.93,-1.04,-1.25,-1.02,-1.09,-0.98,-0.76,-0.66,-0.74,-0.98,-1.17,-1.26,-1.35,-1.04,-1.04,-1.08,-0.92,-0.85,-0.85,-0.85,-0.92,-1.01,-1.17,-1.08,-1.11,-0.99,-0.84,-0.78,-0.81,-1.0,-1.32,-1.34,-1.09,-0.98,-1.0,-0.93,-0.87,-0.91,-0.93,-0.93,-0.97,-1.05,-1.18,-1.33,-1.39,-1.22,-1.18,-1.23,-1.1,-1.0,-0.98,-0.97,-0.96,-0.97,-1.13,-1.27,-1.13,-0.79,-0.6,-0.69,-1.01,-1.38,-1.34,-1.3,-1.16,-1.18,-0.92,-0.76,-0.8,-0.93,-1.01,-1.06,-1.06,-1.14,-1.08,-0.72,-0.63,-0.8,-1.01,-1.32,-1.33,-1.25,-1.13,-1.13,-0.85,-0.8,-0.86,-0.83,-0.91,-1.08,-1.13,-1.32,-1.13,-0.7,-0.54,-0.73,-1.12,-1.37,-1.44,-1.2,-1.23,-1.1,-0.8,-0.75,-0.81,-0.91,-1.0,-1.17,-1.13,-1.27,-1.0,-0.65,-0.63,-0.89,-1.21,-1.29:-0.27,-0.24,-0.23,-0.25,-0.26,-0.28,-0.32,-0.36,-0.33,-0.33,-0.31,-0.28,-0.26,-0.28,-0.25,-0.21,-0.22,-0.19,-0.24,-0.25,-0.22,-0.21,-0.25,-0.25,-0.25,-0.28,-0.3,-0.33,-0.39,-0.38,-0.36,-0.32,-0.24,-0.11,-0.05,0.02,-0.03,-0.1,-0.23,-0.25,-0.24,-0.23,-0.27,-0.29,-0.32,-0.34,-0.31,-0.26,-0.21,-0.18,-0.15,-0.17,-0.15,-0.19,-0.19,-0.23,-0.2,-0.19,-0.22,-0.23,-0.25,-0.29,-0.3,-0.29,-0.31,-0.31,-0.31,-0.25,-0.21,-0.19,-0.17,-0.16,-0.16,-0.2,-0.21,-0.23,-0.23,-0.19,-0.18,-0.23,-0.25,-0.29,-0.3,-0.32,-0.29,-0.33,-0.33,-0.3,-0.19,-0.15,-0.17,-0.15,-0.14,-0.15,-0.18,-0.2,-0.25,-0.23,-0.22,-0.22,-0.25,-0.27,-0.28,-0.32,-0.29,-0.31,-0.32,-0.29,-0.21,-0.19,-0.16,-0.15,-0.14,-0.16,-0.18,-0.22,-0.24,-0.21,-0.21,-0.23,-0.26,-0.31,-0.34,-0.33,-0.3,-0.32,-0.3,-0.24,-0.21,-0.17,-0.14,-0.14,-0.14,-0.19,-0.24,-0.22,-0.2,-0.2,-0.25,-0.28,-0.33,-0.33,-0.32,-0.28,-0.31,-0.31,-0.24,-0.17,-0.16,-0.13,-0.14,-0.13,-0.2,-0.21,-0.24,-0.2,-0.19,-0.23,-0.27,-0.3,-0.31,-0.33,-0.29,-0.31,-0.32,-0.28,-0.2,-0.16,-0.15,-0.15,-0.13,-0.17,-0.17,-0.24,-0.22,-0.21,-0.23,-0.22,-0.25,-0.29,-0.33,-0.33,-0.33,-0.33,-0.29,-0.23,-0.19,-0.18,-0.14,-0.15,-0.15,-0.2,-0.16,-0.25,-0.24,-0.22,-0.22,-0.24,-0.26,-0.3,-0.33,-0.33,-0.31,-0.29,-0.28,-0.23:0.12,0.08,0.06,0.12,-0.04,-0.02,0.01,0.16,0.22,0.24,0.21,0.16,0.16,0.18,0.16,0.2,0.2,0.14,0.11,-0.08,-0.11,-0.15,-0.24,-0.51,-0.81,-0.94,-0.79,-0.54,-0.45,-0.4,-0.56,-0.56,-0.65,-0.78,-0.71,-0.67,-0.72,-0.55,-0.68,-1.14,-1.42,-1.33,-0.86,-0.51,-0.37,-0.41,-0.71,-0.99,-1.09,-0.97,-0.64,-0.45,-0.38,-0.43,-0.53,-0.66,-0.8,-0.81,-0.84,-0.77,-0.68,-0.48,-0.2,-0.04,-0.13,-0.33,-0.41,-0.09,0.24,0.25,0.08,-0.18,-0.42,-0.61,-0.79,-0.85,-0.66,-0.44,-0.14,0.11,0.17,0.25,0.29,0.3,0.27,0.22,0.02,0.08,0.08,0.07,0.18,0.37,0.51,0.49,0.23,-0.12,-0.32,-0.42,-0.53,-0.47,-0.5,-0.64,-0.81,-0.88,-0.91,-0.78,-0.51,-0.59,-0.74,-0.79,-0.73,-0.63,-0.34,-0.18,0.03,0.23,0.27,0.22,0.11,-0.06,-0.04,0.04,0.02,0.07,0.09,0.17,0.18,0.02,0.01,-0.13,-0.19,-0.3,-0.53,-0.77,-0.81,-0.8,-0.75,-0.65,-0.64,-0.74,-0.73,-0.58,-0.48,-0.65,-0.69,-0.61,-0.53,-0.52,-0.54,-0.55,-0.63,-0.82,-0.77,-0.81,-0.67,-0.32,-0.21,-0.37,-0.45,-0.6,-0.71,-0.51,-0.21,0.06,0.24,0.26,0.26,0.31,0.25,0.2,0.06,0.1,0.0,0.05,-0.03,-0.13,-0.06,-0.02,0.05,0.12,0.15,0.15,0.13,0.21,0.17,0.15,0.21,0.2,0.19,0.09,0.1,0.01,0.03,0.02,-0.01,0.0,0.03,0.13,0.1,0.09,0.14,0.11,0.2,0.22,0.17,0.24:WALKING
-0.14,-0.09,-0.08,-0.3,-0.53,-0.67,-0.25,0.27,0.35,0.18,0.1,0.02,-0.04,-0.18,-0.22,-0.19,0.19,0.19,0.0,-0.1,-0.18,-0.35,-0.12,-0.06,-0.08,-0.09,0.0,-0.02,-0.06,-0.03,0.2,0.34,0.4,0.46,0.31,-0.05,-0.21,-0.26,-0.24,-0.28,-0.08,0.01,-0.05,-0.14,-0.12,-0.09,-0.04,0.13,0.23,0.09,-0.06,-0.14,-0.21,-0.19,-0.11,-0.03,0.22,0.27,0.05,-0.02,0.02,0.1,0.23,0.3,0.22,0.26,0.1,-0.03,-0.09,-0.1,-0.06,-0.11,-0.08,0.04,-0.09,-0.15,-0.06,0.17,0.17,0.04,0.09,0.12,0.0,-0.08,-0.17,-0.21,-0.03,0.1,0.09,0.11,0.07,0.07,0.05,0.11,0.13,0.24,0.17,0.1,0.0,-0.08,-0.14,-0.1,-0.09,-0.02,0.02,0.04,0.01,-0.04,-0.06,-0.01,0.02,0.04,0.07,-0.02,-0.2,-0.3,-0.36,-0.42,-0.52,-0.44,-0.33,-0.38,-0.47,-0.18,-0.16,-0.17,-0.05,0.08,0.05,-0.05,-0.19,-0.31,-0.36,-0.41,-0.42,-0.29,-0.21,-0.19,-0.14,0.1,0.33,0.1,-0.1,-0.06,-0.06,-0.15,-0.2,-0.25,-0.13,-0.07,0.02,0.09,0.16,0.11,0.05,0.06,0.09,0.09,0.12,0.11,0.07,-0.08,-0.18,-0.24,-0.13,-0.12,-0.07,-0.03,0.01,-0.02,-0.05,-0.09,-0.07,0.01,0.18,0.36,0.3,-0.01,-0.17,-0.21,-0.22,-0.23,-0.13,-0.03,-0.02,0.01,0.05,0.34,0.79,1.44,1.96,1.78,1.06,0.74,0.63,0.86,0.98,1.26,1.75,1.76,1.4,1.05,0.68,0.46,0.39,0.34:-0.19,-0.04,-0.09,-0.09,-0.08,-0.1,-0.28,-0.39,-0.46,-0.57,-0.68,-0.7,-0.62,-0.47,-0.34,-0.25,-0.19,-0.15,-0.16,-0.32,-0.31,-0.28,-0.38,-0.45,-0.57,-0.67,-0.85,-0.7,-0.48,-0.36,-0.28,-0.21,-0.15,-0.17,-0.15,-0.24,-0.23,-0.21,-0.32,-0.47,-0.59,-0.7,-0.83,-0.68,-0.42,-0.32,-0.29,-0.23,-0.12,-0.09,-0.12,-0.25,-0.27,-0.31,-0.41,-0.62,-0.83,-0.65,-0.62,-0.59,-0.82,-0.82,-0.85,-0.82,-0.56,-0.25,-0.1,0.04,-0.09,-0.32,-0.6,-0.97,-1.3,-1.46,-1.04,-0.74,-0.57,-0.36,-0.31,-0.7,-0.33,-0.24,-0.4,-0.44,-0.48,-0.52,-0.62,-0.59,-0.59,-0.55,-0.35,-0.44,-0.38,-0.32,-0.31,-0.42,-0.4,-0.4,-0.33,-0.28,-0.32,-0.38,-0.41,-0.39,-0.58,-0.48,-0.39,-0.41,-0.32,-0.24,-0.24,-0.26,-0.3,-0.37,-0.28,-0.26,-0.36,-0.43,-0.5,-0.52,-0.62,-0.43,-0.32,-0.15,-0.11,-0.16,-0.34,-0.35,-0.29,-0.28,-0.2,-0.25,-0.27,-0.33,-0.57,-0.78,-0.98,-0.78,-0.7,-0.62,-0.51,-0.38,-0.16,0.06,-0.12,-0.16,-0.37,-0.54,-0.74,-0.93,-1.26,-1.25,-0.79,-0.47,-0.2,-0.14,-0.09,-0.1,-0.19,-0.22,-0.34,-0.41,-0.46,-0.57,-0.66,-0.71,-0.79,-0.71,-0.57,-0.43,-0.32,-0.22,-0.2,-0.18,-0.17,-0.22,-0.28,-0.3,-0.37,-0.55,-0.66,-0.72,-0.82,-0.73,-0.54,-0.42,-0.31,-0.21,-0.19,-0.13,-0.16,-0.26,-0.26,-0.32,-0.43,-0.55,-0.69,-0.8,-0.82,-0.62,-0.45,-0.35,-0.26,-0.18,-0.11,-0.12:0.39,0.47,0.5,0.64,0.54,0.16,-0.17,-0.34,-0.46,-0.6,-0.68,-0.76,-0.7,-0.54,-0.34,-0.32,-0.39,-0.45,-0.48,-0.37,-0.27,-0.2,-0.12,-0.15,-0.4,-0.08,0.36,0.67,0.52,0.56,0.07,-0.34,-0.5,-0.53,-0.85,-0.78,-0.67,-0.71,-0.75,-0.64,-0.09,0.1,0.61,1.13,0.95,0.6,0.34,0.39,0.02,-0.28,-0.2,-0.03,0.06,-0.03,-0.09,0.0,-0.04,-0.21,-0.36,-0.58,-0.7,-0.23,0.07,0.13,0.45,0.94,1.23,1.35,1.25,0.58,0.11,0.01,0.04,-0.1,-0.47,-0.42,-0.04,-0.05,0.01,0.27,0.77,1.22,1.33,1.25,1.01,0.54,0.12,-0.03,-0.07,0.1,-0.04,-0.01,-0.03,-0.18,-0.19,-0.16,-0.03,0.15,0.55,0.64,0.57,0.3,0.13,0.09,0.34,0.35,0.55,0.57,0.52,0.31,0.34,0.56,0.59,0.44,0.76,0.66,0.27,-0.05,-0.11,-0.04,0.25,0.1,-0.12,0.16,0.05,-0.04,-0.04,0.06,0.18,0.26,0.36,0.34,0.24,0.07,-0.12,-0.09,-0.2,-0.38,-0.44,-0.44,-0.29,-0.21,-0.1,0.17,0.4,0.56,0.81,0.82,0.34,0.18,-0.18,-0.35,-0.14,0.31,0.48,0.56,0.34,0.21,0.12,0.28,0.45,0.67,0.73,0.48,0.09,-0.03,0.39,0.74,0.62,0.52,0.62,0.31,0.07,0.01,0.03,0.21,0.2,0.27,0.34,0.28,0.12,-0.05,-0.08,-0.05,-0.12,-0.14,-0.11,0.02,0.05,0.14,0.29,0.48,0.5,0.56,0.59,0.37,0.07,-0.15,-0.19,0.06,0.27,0.73,0.87,0.86,0.57,0.29:WALKING
0.63,0.55,0.51,0.49,0.57,0.78,1.01,1.22,1.14,0.97,0.75,0.59,0.55,0.71,1.0,1.26,1.28,1.05,0.84,0.71,0.59,0.57,0.66,0.9,1.1,1.24,1.14,0.94,0.73,0.54,0.52,0.81,0.96,0.97,0.79,0.51,0.43,0.37,0.36,0.45,0.64,0.96,1.14,1.13,0.98,0.78,0.7,0.47,0.31,0.29,0.34,0.39,0.47,0.53,0.42,0.28,0.23,0.27,0.42,0.57,0.66,0.65,0.38,0.2,0.07,-0.02,-0.04,-0.06,-0.08,-0.13,-0.11,-0.13,-0.15,-0.08,-0.05,0.04,0.12,0.31,0.45,0.46,0.34,0.26,0.17,0.13,0.16,0.11,0.05,-0.07,-0.1,-0.1,-0.07,0.01,0.18,0.46,0.73,0.99,1.22,1.24,1.14,1.01,0.77,0.63,0.57,0.62,0.54,0.49,0.47,0.5,0.46,0.29,0.12,0.0,-0.22,-0.43,-0.78,-1.26,-1.44,-1.27,-0.94,-0.7,-0.65,-0.78,-1.24,-1.37,-1.22,-1.05,-0.88,-0.63,-0.56,-0.66,-0.8,-1.07,-1.44,-1.38,-1.26,-1.06,-0.76,-0.67,-0.68,-0.85,-1.13,-1.22,-1.08,-1.05,-0.87,-0.65,-0.64,-0.7,-0.87,-1.36,-1.47,-1.29,-1.21,-0.93,-0.67,-0.61,-0.68,-0.91,-1.24,-1.26,-1.11,-1.0,-0.78,-0.63,-0.67,-0.76,-1.0,-1.41,-1.46,-1.32,-1.23,-0.94,-0.74,-0.66,-0.66,-0.87,-1.1,-1.18,-1.24,-1.1,-0.84,-0.71,-0.74,-0.86,-1.1,-1.44,-1.39,-1.34,-1.17,-0.81,-0.63,-0.61,-0.66,-1.0,-1.26,-1.26,-1.18,-1.02,-0.77,-0.68,-0.73,-0.91,-1.24,-1.52,-1.39,-1.32:-0.26,-0.23,-0.18,-0.3,-0.34,-0.42,-0.52,-0.55,-0.56,-0.43,-0.26,-0.32,-0.41,-0.64,-0.57,-0.53,-0.4,-0.33,-0.29,-0.23,-0.21,-0.22,-0.21,-0.21,-0.26,-0.42,-0.36,-0.3,-0.29,-0.37,-0.43,-0.43,-0.41,-0.45,-0.36,-0.27,-0.24,-0.22,-0.24,-0.2,-0.2,-0.19,-0.28,-0.42,-0.37,-0.31,-0.32,-0.39,-0.45,-0.44,-0.38,-0.41,-0.32,-0.26,-0.23,-0.22,-0.2,-0.16,-0.15,-0.17,-0.31,-0.39,-0.32,-0.3,-0.33,-0.42,-0.44,-0.42,-0.39,-0.42,-0.32,-0.25,-0.24,-0.22,-0.17,-0.16,-0.15,-0.15,-0.33,-0.47,-0.36,-0.25,-0.3,-0.39,-0.42,-0.37,-0.39,-0.46,-0.37,-0.28,-0.23,-0.21,-0.19,-0.15,-0.15,-0.19,-0.3,-0.43,-0.39,-0.37,-0.37,-0.39,-0.42,-0.39,-0.35,-0.34,-0.33,-0.23,-0.29,-0.24,-0.25,-0.22,-0.19,-0.2,-0.22,-0.41,-0.42,-0.31,-0.3,-0.32,-0.38,-0.35,-0.36,-0.33,-0.33,-0.33,-0.35,-0.32,-0.29,-0.28,-0.22,-0.19,-0.19,-0.23,-0.36,-0.38,-0.27,-0.31,-0.32,-0.37,-0.38,-0.39,-0.43,-0.39,-0.31,-0.28,-0.24,-0.18,-0.17,-0.16,-0.17,-0.19,-0.32,-0.44,-0.35,-0.27,-0.3,-0.4,-0.42,-0.37,-0.36,-0.39,-0.32,-0.3,-0.24,-0.2,-0.21,-0.19,-0.17,-0.2,-0.28,-0.4,-0.36,-0.3,-0.3,-0.34,-0.4,-0.42,-0.41,-0.43,-0.37,-0.31,-0.25,-0.21,-0.2,-0.18,-0.15,-0.16,-0.23,-0.37,-0.42,-0.31,-0.29,-0.33,-0.41,-0.42,-0.42,-0.37,-0.4,-0.33,-0.29,-0.23,-0.22,-0.19,-0.17,-0.17:0.03,-0.06,0.12,-0.03,0.11,0.12,0.01,0.01,0.16,0.21,0.31,0.23,0.18,0.34,0.25,0.07,0.05,0.05,0.03,0.04,0.07,0.01,-0.02,0.03,-0.01,0.06,0.02,0.01,0.07,0.06,0.09,0.12,-0.02,-0.16,-0.18,-0.24,-0.39,-0.51,-0.63,-0.58,-0.57,-0.35,-0.19,-0.07,-0.07,-0.12,-0.2,-0.17,-0.02,-0.04,-0.12,-0.28,-0.47,-0.81,-0.75,-0.78,-0.62,-0.49,-0.27,-0.12,-0.04,-0.06,-0.1,0.03,-0.01,0.07,0.07,0.02,0.01,0.07,0.07,0.07,0.04,-0.04,-0.11,-0.08,-0.01,-0.07,-0.19,-0.25,-0.12,-0.01,0.02,0.12,0.12,0.04,0.1,0.1,0.07,0.07,0.07,-0.05,-0.07,0.01,-0.06,-0.11,-0.21,-0.27,-0.12,0.0,0.08,0.12,0.13,0.09,0.1,0.14,0.11,0.06,0.02,-0.07,-0.05,-0.02,-0.07,-0.12,-0.19,-0.2,-0.06,0.06,0.06,0.12,0.12,0.08,0.09,0.16,0.1,0.05,0.03,-0.09,-0.12,-0.07,-0.06,-0.11,-0.24,-0.28,-0.15,0.07,0.24,0.3,0.15,0.09,-0.01,-0.24,-0.49,-0.86,-1.19,-1.41,-1.32,-0.96,-0.62,-0.35,-0.22,-0.09,-0.06,-0.1,-0.02,0.09,0.08,-0.11,-0.3,-0.67,-0.95,-1.2,-1.35,-1.19,-0.83,-0.48,-0.21,-0.05,-0.01,-0.11,-0.23,-0.32,-0.34,-0.49,-0.37,-0.34,-0.51,-0.62,-0.86,-1.07,-1.24,-1.29,-1.2,-0.9,-0.58,-0.37,-0.35,-0.41,-0.47,-0.55,-0.54,-0.38,-0.42,-0.39,-0.36,-0.49,-0.6,-0.73,-0.75,-0.65,-0.54,-0.35,-0.17,0.02,0.09,0.12:WALKING
1.53,1.45,1.5,1.1,0.95,0.98,1.09,1.1,1.09,0.88,0.97,0.8,0.89,1.09,1.41,1.41,1.46,1.46,1.29,0.93,0.86,0.95,1.11,1.11,0.96,1.01,0.89,0.76,0.89,1.16,1.4,1.46,1.4,1.53,1.14,0.9,0.93,1.05,1.12,1.08,0.89,0.98,0.83,0.83,0.99,1.3,1.39,1.48,1.36,1.49,1.02,0.9,0.99,1.0,0.98,1.02,1.02,1.1,0.85,0.84,0.97,1.34,1.37,1.37,1.42,1.26,0.9,0.91,1.04,1.02,0.9,0.93,1.04,1.04,0.84,0.79,0.94,1.27,1.34,1.38,1.49,1.13,0.94,1.01,0.95,0.9,0.91,1.0,1.18,0.9,0.81,0.87,1.13,1.26,1.47,1.46,1.39,0.96,0.83,0.88,1.0,0.98,1.05,1.02,1.0,0.82,0.91,1.06,1.34,1.33,1.4,1.55,1.26,0.9,0.9,1.01,1.07,1.02,0.88,1.08,0.92,0.84,0.93,1.16,1.42,1.64,1.47,1.52,1.13,0.92,0.93,1.01,1.02,1.08,0.9,1.09,0.93,0.91,1.01,1.29,1.35,1.48,1.51,1.5,1.05,0.98,1.05,1.07,0.97,0.96,1.0,1.02,0.86,0.96,1.17,1.49,1.57,1.45,1.52,1.27,1.0,1.01,1.06,1.02,0.94,0.87,1.08,0.96,0.92,1.04,1.29,1.42,1.55,1.39,1.42,1.05,0.9,0.98,1.09,1.02,1.12,1.01,1.05,0.83,0.86,0.98,1.41,1.39,1.48,1.49,1.34,0.98,0.96,0.96,0.95,0.99,0.91,1.14,1.02,0.93,0.99,1.23,1.27,1.46,1.52,1.47:0.09,0.0,-0.12,-0.05,-0.08,-0.35,-0.5,-0.62,-0.62,-0.51,-0.35,-0.29,-0.27,-0.19,0.04,0.18,0.04,-0.08,-0.18,-0.41,-0.61,-0.87,-0.99,-1.17,-0.77,-0.42,-0.23,-0.11,-0.05,-0.03,0.05,-0.22,-0.13,-0.02,-0.24,-0.55,-0.86,-0.87,-0.73,-0.49,-0.34,-0.27,-0.21,-0.14,0.05,0.14,-0.02,-0.17,-0.15,-0.32,-0.49,-0.82,-0.87,-0.66,-0.52,-0.33,-0.25,-0.19,-0.08,0.13,0.14,-0.03,-0.13,-0.17,-0.38,-0.58,-0.8,-0.81,-0.61,-0.36,-0.28,-0.24,-0.16,0.08,0.2,0.07,-0.08,-0.13,-0.23,-0.46,-0.62,-0.68,-0.67,-0.56,-0.36,-0.27,-0.22,-0.14,0.0,0.18,0.07,-0.07,-0.14,-0.24,-0.45,-0.67,-0.8,-0.75,-0.51,-0.34,-0.29,-0.22,-0.11,-0.01,0.16,0.1,-0.01,-0.06,-0.26,-0.49,-0.63,-0.77,-0.79,-0.53,-0.34,-0.31,-0.24,-0.15,-0.08,0.15,0.21,0.1,-0.09,-0.36,-0.56,-0.66,-0.88,-0.77,-0.5,-0.36,-0.28,-0.17,-0.07,0.02,0.08,-0.01,-0.07,-0.13,-0.32,-0.5,-0.67,-0.67,-0.76,-0.57,-0.4,-0.29,-0.18,-0.14,-0.04,0.04,0.03,-0.05,-0.06,-0.16,-0.38,-0.52,-0.67,-0.86,-0.71,-0.45,-0.32,-0.26,-0.17,-0.13,-0.09,0.11,0.05,-0.07,-0.12,-0.38,-0.51,-0.6,-0.84,-0.76,-0.45,-0.31,-0.27,-0.2,-0.13,0.03,0.12,0.03,-0.05,-0.13,-0.38,-0.53,-0.62,-0.8,-0.66,-0.44,-0.35,-0.28,-0.17,-0.05,0.16,0.05,-0.04,-0.07,-0.17,-0.48,-0.68,-0.82,-0.84,-0.56,-0.34,-0.29:0.08,0.01,0.04,0.09,0.21,0.32,0.48,0.46,0.36,0.13,0.05,0.09,0.13,-0.03,0.15,0.08,-0.06,-0.12,-0.26,-0.12,-0.21,-0.16,-0.03,0.1,0.12,0.12,0.07,0.06,0.12,0.07,0.05,0.14,0.03,-0.18,-0.23,-0.25,-0.07,-0.01,0.15,0.18,0.14,0.04,-0.07,-0.04,0.01,-0.01,0.07,0.03,-0.08,-0.2,-0.21,-0.15,-0.1,-0.11,0.02,0.12,0.16,0.07,0.02,-0.01,0.02,0.1,0.14,0.05,0.08,-0.04,-0.06,-0.01,0.05,0.15,0.28,0.36,0.44,0.32,0.15,0.07,0.12,0.18,0.1,0.16,0.11,-0.05,-0.08,-0.02,0.04,0.12,0.15,0.22,0.2,0.16,0.16,0.03,-0.02,0.08,0.12,-0.09,0.1,-0.1,0.1,0.2,0.21,0.29,0.22,0.15,0.08,-0.06,-0.16,-0.05,0.06,-0.08,-0.01,-0.08,-0.12,-0.19,-0.19,-0.16,-0.13,-0.09,-0.02,0.08,0.12,0.08,-0.05,-0.08,-0.01,0.07,-0.09,-0.08,-0.16,-0.22,-0.15,-0.03,-0.03,0.02,0.13,0.19,0.25,0.2,0.03,-0.03,-0.11,-0.18,-0.06,0.07,0.18,0.2,0.1,0.04,-0.02,0.0,0.0,-0.02,0.11,0.18,0.22,0.25,0.24,0.19,0.14,0.18,0.01,-0.05,-0.19,-0.2,-0.27,-0.21,-0.04,-0.27,0.15,0.18,-0.05,-0.06,0.01,0.01,0.07,0.11,0.08,0.08,0.04,-0.01,-0.05,-0.09,-0.09,-0.05,-0.02,0.04,0.09,0.09,0.1,0.14,0.14,0.17,0.2,0.18,0.07,0.06,-0.05,-0.1,-0.16,-0.14,-0.13,-0.09,0.04,0.21,0.17,0.12:WALKING
0.1,-0.25,-0.64,-0.83,-0.89,-0.83,-0.7,-0.48,-0.47,-0.63,-0.88,-1.0,-0.96,-0.81,-0.68,-0.51,-0.49,-0.6,-0.74,-0.84,-0.96,-0.95,-0.67,-0.43,-0.39,-0.46,-0.46,-0.29,-0.15,-0.05,0.02,-0.05,-0.18,-0.33,-0.46,-0.52,-0.6,-0.51,-0.4,-0.38,-0.54,-0.72,-0.75,-0.86,-0.84,-0.69,-0.49,-0.43,-0.54,-0.8,-0.94,-1.02,-1.08,-0.94,-0.59,-0.49,-0.6,-0.82,-1.0,-0.95,-0.85,-0.76,-0.58,-0.46,-0.51,-0.81,-1.0,-1.05,-1.11,-0.96,-0.59,-0.38,-0.47,-0.65,-0.83,-0.83,-0.75,-0.66,-0.46,-0.39,-0.5,-0.77,-0.95,-1.0,-0.89,-0.73,-0.48,-0.28,-0.27,-0.38,-0.48,-0.57,-0.52,-0.43,-0.41,-0.35,-0.38,-0.53,-0.83,-0.98,-1.06,-1.06,-0.79,-0.53,-0.52,-0.67,-0.89,-1.01,-1.01,-0.88,-0.72,-0.51,-0.38,-0.47,-0.72,-0.91,-1.13,-1.13,-1.07,-0.65,-0.34,-0.35,-0.41,-0.43,-0.39,-0.33,-0.01,0.07,-0.06,-0.21,-0.28,-0.39,-0.33,-0.11,0.15,0.2,0.05,-0.12,-0.26,-0.1,0.08,0.22,0.44,0.48,0.31,0.08,-0.13,-0.2,-0.39,-0.71,-0.87,-0.94,-0.76,-0.43,-0.22,-0.28,-0.28,-0.33,-0.31,-0.38,-0.49,-0.38,-0.3,-0.35,-0.47,-0.57,-0.5,-0.61,-0.75,-0.51,-0.3,-0.15,-0.2,-0.14,0.02,0.34,0.49,0.38,0.06,-0.1,-0.16,-0.44,-0.69,-0.66,-0.4,-0.02,0.12,0.1,-0.05,-0.14,-0.06,0.01,0.08,0.1,0.06,-0.01,0.02,0.07,0.18,0.39,0.49,0.28,0.12,0.1,0.15,0.3:0.36,0.3,0.22,0.21,0.25,0.3,0.34,0.38,0.37,0.36,0.52,0.69,0.83,0.83,0.82,0.77,0.58,0.35,0.21,0.18,0.18,0.19,0.29,0.36,0.43,0.44,0.46,0.55,0.63,0.67,0.63,0.63,0.58,0.46,0.32,0.19,0.14,0.13,0.18,0.36,0.46,0.49,0.47,0.4,0.43,0.49,0.71,0.72,0.67,0.55,0.38,0.31,0.23,0.13,0.09,0.18,0.38,0.57,0.63,0.56,0.44,0.45,0.6,0.62,0.73,0.67,0.67,0.5,0.38,0.34,0.25,0.2,0.22,0.31,0.44,0.48,0.49,0.42,0.42,0.49,0.56,0.68,0.62,0.69,0.53,0.37,0.29,0.17,0.18,0.25,0.29,0.38,0.46,0.46,0.43,0.48,0.58,0.75,0.67,0.67,0.56,0.45,0.32,0.16,0.11,0.13,0.23,0.38,0.48,0.47,0.39,0.44,0.55,0.67,0.77,0.7,0.75,0.69,0.5,0.43,0.36,0.27,0.24,0.23,0.23,0.3,0.44,0.52,0.6,0.82,0.95,0.91,0.83,0.63,0.43,0.23,0.08,0.05,0.09,0.16,0.3,0.42,0.46,0.55,0.7,0.79,0.88,0.77,0.6,0.5,0.34,0.28,0.15,0.13,0.12,0.17,0.27,0.36,0.44,0.54,0.65,0.73,0.71,0.58,0.46,0.41,0.28,0.17,0.14,0.14,0.18,0.32,0.38,0.47,0.58,0.68,0.57,0.41,0.5,0.52,0.54,0.42,0.31,0.18,0.15,0.12,0.18,0.3,0.51,0.64,0.67,0.61,0.59,0.55,0.47,0.53,0.51,0.38,0.32,0.2,0.15,0.11,0.2,0.32,0.43,0.6:0.02,0.01,-0.16,-0.23,-0.09,-0.03,0.37,0.19,0.12,0.23,0.28,0.38,0.21,0.16,0.12,0.15,0.11,-0.01,-0.11,-0.2,-0.17,0.0,0.23,0.06,0.1,0.23,0.36,0.38,0.24,0.11,-0.03,0.0,-0.14,-0.31,-0.38,-0.11,-0.08,0.2,0.27,-0.08,-0.05,0.08,0.24,0.23,0.16,0.16,0.22,0.09,-0.02,-0.18,-0.27,-0.16,-0.11,0.27,0.36,0.24,0.21,0.35,0.32,0.19,0.16,0.11,0.07,0.03,-0.09,-0.33,-0.38,-0.19,0.05,0.26,0.14,0.12,0.22,0.39,0.3,0.15,0.05,0.1,0.05,0.02,-0.07,-0.29,-0.27,-0.15,0.22,0.17,0.1,0.21,0.33,0.38,0.26,0.11,0.02,0.01,0.03,-0.06,-0.11,-0.21,-0.22,-0.12,0.16,0.11,0.09,0.22,0.3,0.31,0.18,0.08,0.05,0.03,0.05,-0.04,-0.2,-0.17,-0.11,-0.03,0.11,0.07,0.12,0.18,0.22,0.37,0.29,0.21,0.15,0.09,0.11,-0.11,-0.25,-0.32,-0.22,0.0,0.34,0.15,0.17,0.26,0.31,0.22,0.13,0.07,0.05,0.03,0.05,-0.08,-0.31,-0.27,-0.13,0.13,0.12,0.14,0.27,0.3,0.33,0.22,0.14,0.08,0.1,0.08,0.11,-0.1,-0.51,-0.3,0.01,0.18,0.04,0.15,0.31,0.36,0.31,0.2,0.12,-0.05,-0.04,0.05,-0.04,-0.39,-0.41,-0.2,0.11,0.29,0.1,0.15,0.32,0.32,0.24,0.25,0.1,0.08,0.03,-0.05,-0.24,-0.35,-0.18,-0.12,0.32,0.36,0.09,0.26,0.36,0.32,0.19,0.13,0.01,-0.03,0.02,-0.07:WALKING
-0.79,-0.76,-0.83,-0.92,-1.04,-1.13,-1.16,-1.23,-1.02,-1.07,-1.13,-1.0,-0.93,-0.89,-0.85,-0.89,-0.95,-1.0,-1.07,-0.94,-0.92,-0.93,-0.92,-0.91,-0.9,-0.95,-0.96,-0.94,-0.96,-1.01,-1.12,-1.11,-1.12,-1.08,-1.09,-1.0,-0.94,-0.93,-0.87,-0.9,-1.01,-1.11,-1.12,-1.02,-1.0,-0.86,-0.71,-0.68,-0.86,-1.1,-1.23,-1.36,-1.18,-1.2,-1.12,-0.89,-0.82,-0.83,-0.81,-0.95,-1.0,-1.13,-1.05,-1.12,-0.94,-0.71,-0.67,-0.89,-1.17,-1.26,-1.33,-1.13,-1.14,-1.04,-0.82,-0.86,-0.87,-0.82,-0.9,-1.11,-1.08,-1.19,-1.11,-0.75,-0.62,-0.76,-1.06,-1.29,-1.33,-1.25,-1.14,-1.13,-0.84,-0.77,-0.8,-0.79,-0.99,-1.06,-1.16,-1.1,-1.13,-0.83,-0.62,-0.71,-0.96,-1.26,-1.29,-1.41,-1.12,-1.13,-0.95,-0.74,-0.75,-0.82,-0.95,-0.96,-1.14,-1.13,-1.21,-0.9,-0.64,-0.67,-0.91,-1.2,-1.33,-1.38,-1.13,-1.22,-1.0,-0.82,-0.84,-0.86,-0.93,-0.93,-1.13,-1.12,-1.2,-0.91,-0.62,-0.68,-1.0,-1.25,-1.29,-1.39,-1.18,-1.21,-0.98,-0.8,-0.87,-0.88,-0.89,-0.9,-1.13,-1.14,-1.26,-0.94,-0.65,-0.61,-0.87,-1.19,-1.34,-1.47,-1.13,-1.2,-1.0,-0.79,-0.77,-0.83,-0.93,-0.99,-1.09,-1.05,-1.18,-1.0,-0.65,-0.65,-0.93,-1.22,-1.29,-1.36,-1.13,-1.25,-1.05,-0.74,-0.78,-0.85,-0.92,-0.98,-1.13,-1.09,-1.21,-0.95,-0.65,-0.65,-0.91,-1.18,-1.37,-1.39,-1.17,-1.22,-1.09,-0.8,-0.76,-0.82,-0.87,-0.97:-0.41,-0.61,-0.49,-0.51,-0.31,-0.13,-0.12,-0.13,-0.05,-0.06,-0.12,-0.18,-0.15,-0.25,-0.29,-0.32,-0.43,-0.54,-0.52,-0.5,-0.37,-0.19,-0.1,-0.15,-0.08,-0.04,-0.11,-0.13,-0.24,-0.22,-0.24,-0.33,-0.38,-0.44,-0.51,-0.52,-0.47,-0.33,-0.19,-0.13,-0.09,-0.05,-0.08,-0.13,-0.17,-0.16,-0.29,-0.33,-0.32,-0.4,-0.52,-0.5,-0.49,-0.44,-0.26,-0.12,-0.1,-0.11,-0.03,-0.11,-0.13,-0.2,-0.14,-0.25,-0.31,-0.32,-0.41,-0.55,-0.5,-0.5,-0.36,-0.2,-0.09,-0.1,-0.09,-0.07,-0.13,-0.17,-0.15,-0.22,-0.27,-0.31,-0.44,-0.56,-0.51,-0.54,-0.45,-0.29,-0.16,-0.09,-0.07,-0.02,-0.07,-0.12,-0.22,-0.17,-0.23,-0.27,-0.33,-0.44,-0.61,-0.57,-0.55,-0.46,-0.3,-0.09,-0.11,-0.31,-0.32,-0.41,-0.38,-0.41,-0.41,-0.25,-0.26,-0.29,-0.3,-0.28,-0.27,-0.38,-0.44,-0.46,-0.49,-0.39,-0.44,-0.28,-0.21,0.19,0.34,0.19,-0.07,-0.25,-0.35,-0.42,-0.44,-0.37,-0.34,-0.24,-0.19,-0.16,-0.1,-0.12,-0.06,-0.14,-0.21,-0.28,-0.25,-0.28,-0.28,-0.28,-0.37,-0.4,-0.44,-0.47,-0.46,-0.26,-0.15,-0.14,-0.17,-0.08,-0.15,-0.15,-0.16,-0.21,-0.28,-0.25,-0.28,-0.39,-0.46,-0.5,-0.47,-0.3,-0.19,-0.12,-0.11,-0.06,-0.1,-0.15,-0.2,-0.14,-0.2,-0.21,-0.3,-0.44,-0.55,-0.47,-0.52,-0.34,-0.18,-0.1,-0.1,-0.03,-0.01,-0.1,-0.16,-0.15,-0.17,-0.3,-0.33,-0.4,-0.49,-0.48,-0.51,-0.35,-0.21,-0.1:0.09,0.01,0.07,0.17,0.24,0.15,0.22,0.24,0.14,0.24,0.32,0.33,0.26,0.21,0.26,0.2,-0.02,-0.01,0.07,0.19,0.22,0.16,0.21,0.25,0.14,0.24,0.33,0.29,0.2,0.21,0.18,0.21,-0.01,0.01,0.05,0.21,0.17,0.13,0.15,0.21,0.11,0.14,0.27,0.31,0.24,0.28,0.2,0.27,0.09,-0.02,0.02,0.15,0.14,0.05,-0.02,0.16,0.15,0.12,0.27,0.35,0.36,0.27,0.17,0.17,0.08,-0.04,-0.02,0.08,0.09,0.17,0.11,0.17,0.21,0.2,0.29,0.25,0.25,0.2,0.18,0.32,0.2,0.01,-0.01,0.08,0.18,0.22,0.11,0.22,0.33,0.17,0.21,0.32,0.28,0.2,0.24,0.2,0.21,-0.02,-0.04,0.0,0.2,0.2,0.15,0.2,0.33,0.2,0.25,0.29,0.27,0.26,0.23,0.17,0.29,0.01,0.0,0.0,0.14,0.19,0.17,0.17,0.3,0.17,0.17,0.28,0.31,0.29,0.25,0.18,0.24,0.03,-0.08,-0.11,0.02,0.13,0.1,0.19,0.34,0.18,0.19,0.24,0.21,0.2,0.21,0.13,0.27,0.1,-0.03,-0.06,0.04,0.11,0.11,0.12,0.33,0.28,0.16,0.17,0.22,0.21,0.24,0.2,0.23,0.12,-0.03,-0.01,0.06,0.19,0.18,0.04,0.17,0.22,0.13,0.23,0.31,0.32,0.25,0.21,0.21,0.24,-0.01,-0.05,0.04,0.17,0.19,0.12,0.19,0.25,0.14,0.21,0.32,0.34,0.31,0.27,0.22,0.23,-0.01,-0.1,0.0,0.15,0.12,0.09,0.15,0.27,0.22,0.21,0.3,0.29:WALKING
-1.14,-0.95,-0.65,-0.59,-0.83,-1.26,-1.35,-1.49,-1.25,-1.28,-0.97,-0.77,-0.77,-0.79,-0.96,-1.04,-1.11,-1.26,-1.2,-0.76,-0.64,-0.9,-1.24,-1.36,-1.46,-1.25,-1.35,-1.0,-0.77,-0.76,-0.8,-0.93,-1.0,-1.1,-1.32,-1.21,-0.8,-0.61,-0.81,-1.14,-1.38,-1.42,-1.16,-1.2,-0.97,-0.75,-0.77,-0.84,-0.99,-1.04,-1.14,-1.18,-1.21,-0.82,-0.54,-0.65,-1.01,-1.35,-1.35,-1.32,-1.18,-1.19,-0.85,-0.73,-0.82,-0.88,-1.01,-1.1,-1.08,-1.22,-1.08,-0.68,-0.57,-0.79,-1.16,-1.37,-1.47,-1.16,-1.26,-1.05,-0.76,-0.79,-0.87,-0.95,-0.94,-1.11,-1.13,-1.23,-0.91,-0.65,-0.67,-0.95,-1.34,-1.4,-1.35,-1.19,-1.14,-0.87,-0.8,-0.85,-0.89,-0.95,-1.06,-1.1,-1.29,-1.02,-0.65,-0.57,-0.85,-1.24,-1.39,-1.48,-1.14,-1.24,-1.0,-0.75,-0.77,-0.86,-0.99,-1.05,-1.11,-1.13,-1.13,-0.78,-0.61,-0.74,-1.09,-1.41,-1.46,-1.29,-1.21,-1.14,-0.89,-0.78,-0.8,-0.83,-0.93,-1.1,-1.13,-1.29,-1.06,-0.71,-0.61,-0.84,-1.2,-1.33,-1.46,-1.17,-1.24,-1.02,-0.8,-0.82,-0.92,-0.96,-0.91,-1.1,-1.19,-1.26,-0.9,-0.63,-0.66,-0.99,-1.28,-1.34,-1.36,-1.16,-1.25,-0.99,-0.82,-0.78,-0.81,-0.93,-1.0,-1.13,-1.13,-1.14,-0.84,-0.59,-0.7,-1.02,-1.32,-1.36,-1.37,-1.2,-1.18,-0.89,-0.83,-0.88,-0.85,-0.94,-1.0,-1.07,-1.17,-1.17,-0.79,-0.64,-0.78,-1.08,-1.32,-1.39,-1.25,-1.17,-1.14,-0.92,-0.8,-0.78:-0.38,-0.33,-0.24,-0.15,-0.12,-0.13,-0.17,-0.21,-0.29,-0.26,-0.3,-0.22,-0.25,-0.27,-0.22,-0.42,-0.56,-0.57,-0.52,-0.48,-0.44,-0.36,-0.27,-0.18,-0.14,-0.19,-0.19,-0.24,-0.25,-0.26,-0.29,-0.27,-0.28,-0.25,-0.26,-0.32,-0.42,-0.51,-0.67,-0.69,-0.53,-0.43,-0.33,-0.25,-0.17,-0.1,0.0,0.01,-0.09,-0.2,-0.25,-0.26,-0.29,-0.23,-0.17,-0.14,-0.32,-0.33,-0.39,-0.35,-0.44,-0.55,-0.55,-0.54,-0.51,-0.49,-0.37,-0.44,-0.47,-0.4,-0.37,-0.42,-0.5,-0.52,-0.5,-0.51,-0.48,-0.47,-0.49,-0.49,-0.53,-0.57,-0.56,-0.58,-0.6,-0.64,-0.69,-0.71,-0.6,-0.51,-0.49,-0.46,-0.44,-0.38,-0.21,-0.27,-0.18,-0.25,-0.31,-0.37,-0.41,-0.35,-0.29,-0.15,0.06,0.11,0.0,-0.2,-0.26,-0.29,-0.36,-0.35,-0.36,-0.34,-0.29,-0.27,-0.2,-0.2,-0.25,-0.28,-0.28,-0.33,-0.36,-0.36,-0.39,-0.36,-0.31,-0.23,-0.23,-0.22,-0.19,-0.17,-0.19,-0.22,-0.22,-0.29,-0.24,-0.23,-0.25,-0.29,-0.33,-0.33,-0.34,-0.32,-0.33,-0.33,-0.31,-0.26,-0.22,-0.21,-0.18,-0.19,-0.19,-0.25,-0.22,-0.31,-0.29,-0.26,-0.27,-0.26,-0.26,-0.29,-0.32,-0.33,-0.33,-0.34,-0.33,-0.28,-0.22,-0.21,-0.19,-0.2,-0.19,-0.22,-0.21,-0.28,-0.25,-0.24,-0.25,-0.25,-0.29,-0.33,-0.33,-0.34,-0.33,-0.33,-0.32,-0.29,-0.23,-0.2,-0.18,-0.16,-0.17,-0.2,-0.19,-0.27,-0.29,-0.23,-0.3,-0.29,-0.27,-0.3,-0.31,-0.33,-0.31,-0.33:-0.89,-1.1,-0.85,-0.64,-0.51,-0.44,-0.5,-0.53,-0.42,-0.35,-0.39,-0.55,-0.71,-0.55,-0.45,-0.84,-0.73,-0.68,-0.62,-0.7,-1.04,-0.99,-0.84,-0.67,-0.5,-0.41,-0.36,-0.59,-1.04,-0.99,-0.83,-0.75,-0.75,-0.89,-1.26,-1.14,-0.86,-0.49,-0.13,0.01,0.23,0.62,0.44,0.32,-0.16,0.08,0.29,0.28,0.24,0.31,0.36,0.27,0.19,0.15,0.14,0.15,0.05,0.17,0.13,0.28,0.17,0.07,0.05,0.09,0.14,0.19,0.19,0.2,0.19,0.29,0.27,0.22,0.23,0.27,0.19,0.13,0.06,0.04,0.14,0.3,0.13,0.15,0.11,0.14,0.22,0.25,0.31,0.24,0.31,0.43,0.34,0.28,0.19,0.12,0.13,0.04,0.19,0.17,0.26,0.17,0.09,0.09,0.16,0.17,0.2,0.21,0.19,0.17,0.25,0.31,0.23,0.24,0.19,0.19,0.16,0.09,0.16,0.15,0.2,0.05,0.07,0.09,0.11,0.19,0.23,0.22,0.19,0.17,0.25,0.23,0.21,0.26,0.22,0.17,0.08,0.09,0.13,0.22,0.17,0.05,0.03,0.06,0.13,0.2,0.22,0.22,0.18,0.25,0.3,0.24,0.23,0.22,0.17,0.19,0.1,0.19,0.11,0.22,0.17,0.1,0.12,0.14,0.15,0.19,0.21,0.2,0.18,0.23,0.27,0.23,0.23,0.22,0.22,0.23,0.13,0.18,0.11,0.22,0.17,0.09,0.1,0.17,0.22,0.23,0.23,0.24,0.2,0.27,0.33,0.28,0.28,0.27,0.17,0.09,0.01,0.05,0.09,0.07,0.2,0.17,0.1,0.11,0.13,0.1,0.06,0.21:WALKING
0.75,1.05,1.22,1.37,1.1,0.79,0.71,0.69,0.64,0.6,0.74,0.99,1.24,1.26,1.07,0.74,0.37,0.3,0.41,0.46,0.46,0.47,0.24,0.17,0.18,0.25,0.28,0.29,0.46,0.6,0.5,0.39,0.36,0.39,0.44,0.5,0.42,0.3,0.43,0.45,0.42,0.32,0.22,0.18,0.2,0.31,0.3,0.2,0.12,0.16,0.18,0.2,0.21,0.14,0.06,0.09,0.12,0.02,-0.15,-0.12,-0.06,0.05,0.22,0.38,0.37,0.12,0.0,-0.09,-0.16,-0.16,-0.19,-0.23,-0.32,-0.45,-0.75,-1.26,-1.6,-1.35,-1.04,-0.93,-0.96,-1.26,-1.41,-1.19,-1.26,-1.13,-0.95,-0.87,-0.84,-0.92,-0.98,-1.0,-1.1,-1.2,-1.04,-0.88,-0.85,-0.82,-1.06,-1.48,-1.42,-1.38,-1.27,-0.92,-0.77,-0.73,-0.77,-0.96,-1.09,-1.14,-1.26,-1.09,-0.85,-0.79,-0.79,-0.94,-1.27,-1.47,-1.38,-1.37,-1.1,-0.82,-0.71,-0.67,-0.79,-1.01,-1.19,-1.22,-1.25,-1.0,-0.8,-0.76,-0.78,-0.98,-1.41,-1.44,-1.34,-1.3,-1.0,-0.77,-0.71,-0.7,-0.88,-1.06,-1.13,-1.2,-1.14,-0.91,-0.78,-0.79,-0.87,-1.07,-1.45,-1.37,-1.35,-1.3,-0.99,-0.76,-0.7,-0.69,-0.86,-1.04,-1.16,-1.22,-1.18,-0.95,-0.84,-0.83,-0.86,-1.1,-1.38,-1.32,-1.21,-1.2,-0.94,-0.77,-0.77,-0.8,-0.98,-1.11,-1.0,-0.98,-1.04,-0.92,-0.9,-0.93,-0.86,-0.99,-1.29,-1.3,-1.11,-1.18,-1.02,-0.89,-0.84,-0.85,-0.92,-1.01,-1.1,-0.96,-0.97,-1.05,-0.98,-0.94,-0.91,-0.86:-0.31,-0.23,-0.2,-0.16,-0.1,-0.01,0.01,-0.17,-0.36,-0.41,-0.31,-0.43,-0.59,-0.62,-0.61,-0.51,-0.37,-0.26,-0.2,-0.15,-0.12,-0.04,0.0,-0.12,-0.33,-0.41,-0.32,-0.33,-0.49,-0.6,-0.67,-0.62,-0.44,-0.3,-0.21,-0.14,-0.11,-0.07,0.03,-0.04,-0.29,-0.41,-0.46,-0.34,-0.47,-0.65,-0.66,-0.55,-0.41,-0.29,-0.2,-0.15,-0.13,-0.08,0.01,-0.03,-0.2,-0.5,-0.59,-0.32,-0.31,-0.55,-0.64,-0.58,-0.39,-0.26,-0.21,-0.19,-0.13,-0.08,-0.04,-0.01,-0.19,-0.41,-0.44,-0.36,-0.45,-0.55,-0.54,-0.52,-0.47,-0.29,-0.21,-0.22,-0.17,-0.13,-0.08,-0.02,-0.12,-0.37,-0.48,-0.35,-0.32,-0.48,-0.6,-0.6,-0.55,-0.4,-0.26,-0.21,-0.16,-0.13,-0.09,0.0,-0.06,-0.29,-0.44,-0.36,-0.24,-0.34,-0.54,-0.56,-0.57,-0.49,-0.34,-0.24,-0.22,-0.17,-0.12,-0.04,-0.01,-0.13,-0.32,-0.34,-0.38,-0.41,-0.55,-0.58,-0.57,-0.51,-0.39,-0.28,-0.22,-0.16,-0.11,-0.07,0.0,-0.05,-0.27,-0.44,-0.44,-0.31,-0.42,-0.61,-0.64,-0.57,-0.42,-0.29,-0.23,-0.18,-0.14,-0.1,-0.01,-0.01,-0.18,-0.36,-0.41,-0.35,-0.51,-0.65,-0.66,-0.59,-0.53,-0.38,-0.2,-0.18,-0.14,-0.11,-0.05,0.02,-0.1,-0.37,-0.46,-0.32,-0.3,-0.48,-0.59,-0.61,-0.57,-0.4,-0.27,-0.22,-0.16,-0.1,-0.04,0.01,-0.04,-0.29,-0.46,-0.43,-0.3,-0.4,-0.56,-0.62,-0.62,-0.42,-0.28,-0.23,-0.17,-0.12,-0.06,0.03,-0.01,-0.19,-0.41,-0.47:0.18,0.15,0.15,0.17,0.18,0.14,0.0,-0.11,-0.11,-0.17,-0.19,-0.32,-0.29,-0.13,0.07,0.28,0.29,0.25,0.23,0.24,0.25,0.2,0.17,0.03,-0.05,-0.21,-0.25,-0.28,-0.26,-0.12,-0.05,-0.08,0.05,0.18,0.14,0.09,0.1,0.12,0.14,0.14,0.02,-0.09,-0.06,-0.15,-0.19,-0.18,-0.15,-0.02,-0.01,0.1,0.1,0.05,0.05,0.1,0.13,0.13,0.07,-0.06,0.01,-0.02,-0.16,-0.23,-0.21,-0.13,-0.06,0.07,0.14,0.1,0.07,0.08,0.12,0.14,0.19,0.05,-0.03,0.01,-0.06,-0.14,-0.2,-0.2,-0.07,-0.04,0.08,0.15,0.07,0.06,0.09,0.12,0.14,0.14,-0.02,-0.07,-0.02,-0.1,-0.17,-0.17,-0.13,-0.08,0.02,0.14,0.09,0.07,0.07,0.13,0.18,0.18,0.07,-0.02,-0.02,-0.07,-0.19,-0.25,-0.23,-0.14,0.0,0.11,0.11,0.05,0.08,0.12,0.13,0.12,0.09,-0.03,-0.01,0.0,-0.11,-0.19,-0.21,-0.13,-0.04,0.08,0.14,0.08,0.07,0.11,0.13,0.13,0.12,0.02,0.0,0.04,-0.07,-0.25,-0.25,-0.15,-0.08,0.04,0.15,0.09,0.07,0.1,0.13,0.13,0.15,0.02,-0.04,-0.01,-0.06,-0.19,-0.22,-0.18,-0.14,-0.07,0.07,0.08,0.06,0.1,0.22,0.22,0.19,0.07,0.01,-0.04,-0.05,-0.16,-0.23,-0.15,-0.07,0.07,0.17,0.1,0.07,0.15,0.22,0.23,0.23,0.09,-0.03,-0.03,-0.15,-0.33,-0.36,-0.16,0.09,0.26,0.18,0.22,0.26,0.29,0.22,0.16,0.07,0.02,0.05,-0.21:WALKING
-0.84,-0.99,-1.19,-1.19,-1.17,-1.58,-1.41,-0.9,-0.88,-1.51,-1.5,-1.35,-1.37,-1.21,-0.84,-0.88,-1.24,-1.23,-1.18,-1.67,-1.39,-0.84,-0.81,-1.27,-1.52,-1.41,-1.47,-1.23,-0.91,-0.87,-1.26,-1.27,-1.13,-1.44,-1.39,-0.88,-0.74,-1.44,-1.57,-1.3,-1.44,-1.26,-0.86,-0.79,-1.29,-1.23,-1.07,-1.62,-1.51,-0.92,-0.75,-1.33,-1.54,-1.42,-1.39,-1.27,-0.93,-0.82,-1.25,-1.18,-1.19,-1.61,-1.6,-0.98,-0.85,-1.35,-1.5,-1.35,-1.4,-1.34,-0.98,-0.78,-1.19,-1.24,-1.13,-1.53,-1.58,-1.04,-0.84,-1.13,-1.46,-1.33,-1.4,-1.41,-1.13,-0.81,-1.14,-1.33,-1.17,-1.21,-1.58,-1.22,-0.9,-1.0,-1.46,-1.46,-1.32,-1.46,-1.28,-0.78,-0.78,-1.27,-1.25,-1.09,-1.53,-1.39,-0.94,-0.75,-1.19,-1.57,-1.41,-1.48,-1.36,-1.01,-0.79,-1.14,-1.22,-1.18,-1.42,-1.57,-1.1,-0.82,-1.09,-1.52,-1.42,-1.38,-1.45,-1.23,-0.83,-0.84,-1.29,-1.22,-1.24,-1.6,-1.36,-0.93,-0.92,-1.38,-1.51,-1.38,-1.44,-1.22,-0.98,-1.13,-1.28,-1.23,-1.16,-1.7,-1.55,-1.07,-0.87,-1.34,-1.49,-1.34,-1.41,-1.34,-1.06,-1.06,-1.34,-1.17,-1.24,-1.5,-1.53,-1.13,-0.81,-1.2,-1.6,-1.5,-1.38,-1.33,-1.14,-1.0,-1.17,-1.17,-1.1,-1.46,-1.63,-1.18,-0.95,-1.33,-1.55,-1.29,-1.59,-1.6,-1.26,-0.95,-1.2,-1.25,-1.13,-1.21,-1.72,-1.54,-1.13,-1.13,-1.34,-1.3,-1.17,-1.26,-1.29,-1.19,-1.37,-1.28,-1.16,-1.08,-1.64,-1.61:-0.43,-0.34,-0.31,-0.25,-0.24,-0.11,-0.09,-0.17,-0.2,-0.15,-0.18,-0.31,-0.38,-0.42,-0.53,-0.46,-0.42,-0.36,-0.32,-0.24,-0.2,-0.07,-0.1,-0.12,-0.16,-0.1,-0.24,-0.3,-0.37,-0.47,-0.56,-0.46,-0.38,-0.32,-0.29,-0.24,-0.16,-0.08,-0.12,-0.18,-0.23,-0.15,-0.26,-0.37,-0.44,-0.5,-0.47,-0.47,-0.37,-0.19,-0.13,-0.08,-0.03,-0.08,-0.13,-0.24,-0.19,-0.14,-0.24,-0.35,-0.36,-0.37,-0.41,-0.44,-0.32,-0.29,-0.2,-0.19,-0.11,-0.13,-0.11,-0.14,-0.1,-0.19,-0.26,-0.34,-0.38,-0.43,-0.39,-0.42,-0.28,-0.21,-0.16,-0.13,-0.13,-0.12,-0.17,-0.17,-0.11,-0.23,-0.29,-0.34,-0.41,-0.5,-0.42,-0.33,-0.24,-0.22,-0.15,-0.09,-0.1,-0.11,-0.21,-0.13,-0.14,-0.25,-0.34,-0.33,-0.43,-0.43,-0.41,-0.32,-0.28,-0.21,-0.15,-0.05,-0.19,-0.22,-0.24,-0.11,-0.18,-0.29,-0.38,-0.42,-0.51,-0.48,-0.34,-0.23,-0.26,-0.21,-0.13,-0.07,-0.13,-0.21,-0.21,-0.18,-0.23,-0.32,-0.37,-0.43,-0.45,-0.41,-0.36,-0.26,-0.24,-0.17,-0.11,-0.09,-0.11,-0.17,-0.16,-0.16,-0.24,-0.33,-0.36,-0.46,-0.45,-0.38,-0.25,-0.29,-0.27,-0.15,-0.08,-0.12,-0.16,-0.24,-0.16,-0.19,-0.28,-0.34,-0.35,-0.48,-0.44,-0.41,-0.26,-0.2,-0.23,-0.16,-0.1,-0.16,-0.17,-0.21,-0.12,-0.23,-0.31,-0.38,-0.43,-0.46,-0.42,-0.32,-0.27,-0.27,-0.16,-0.11,-0.1,-0.17,-0.23,-0.2,-0.17,-0.24,-0.32,-0.39,-0.49,-0.48,-0.41,-0.34:-0.06,-0.01,-0.07,-0.09,-0.27,-0.27,-0.27,-0.25,-0.35,-0.51,-0.57,-0.51,-0.33,-0.32,-0.27,-0.07,0.03,0.0,-0.11,-0.33,-0.34,-0.21,-0.18,-0.25,-0.45,-0.59,-0.46,-0.27,-0.31,-0.19,-0.02,-0.02,-0.06,-0.09,-0.26,-0.31,-0.27,-0.21,-0.31,-0.48,-0.51,-0.42,-0.33,-0.34,-0.18,-0.07,-0.02,-0.02,-0.13,-0.32,-0.33,-0.28,-0.2,-0.3,-0.46,-0.55,-0.45,-0.22,-0.35,-0.23,-0.02,-0.03,-0.05,-0.14,-0.28,-0.28,-0.26,-0.22,-0.25,-0.43,-0.49,-0.41,-0.31,-0.37,-0.24,-0.08,-0.02,-0.05,-0.15,-0.34,-0.31,-0.27,-0.23,-0.31,-0.45,-0.54,-0.47,-0.28,-0.35,-0.25,-0.05,-0.02,-0.03,-0.09,-0.27,-0.3,-0.24,-0.2,-0.36,-0.46,-0.52,-0.46,-0.29,-0.34,-0.23,-0.06,-0.03,-0.05,-0.14,-0.25,-0.28,-0.23,-0.24,-0.39,-0.53,-0.57,-0.44,-0.25,-0.34,-0.19,-0.02,0.02,0.03,-0.11,-0.27,-0.26,-0.26,-0.29,-0.47,-0.61,-0.58,-0.47,-0.31,-0.33,-0.16,-0.06,-0.05,-0.08,-0.17,-0.28,-0.25,-0.22,-0.26,-0.4,-0.56,-0.58,-0.47,-0.31,-0.36,-0.18,-0.02,-0.01,-0.02,-0.13,-0.29,-0.24,-0.24,-0.29,-0.46,-0.56,-0.53,-0.44,-0.32,-0.34,-0.15,-0.06,0.01,-0.05,-0.2,-0.28,-0.22,-0.23,-0.28,-0.48,-0.58,-0.56,-0.37,-0.34,-0.34,-0.1,-0.06,-0.05,-0.06,-0.2,-0.31,-0.26,-0.23,-0.32,-0.52,-0.61,-0.56,-0.4,-0.31,-0.29,-0.09,0.01,0.05,0.0,-0.18,-0.22,-0.19,-0.24,-0.31,-0.48,-0.58,-0.55:WALKING
-1.0,-1.11,-1.21,-1.19,-1.27,-0.94,-0.64,-0.65,-0.98,-1.26,-1.27,-1.13,-1.09,-0.74,-0.47,-0.64,-1.05,-1.18,-1.23,-1.22,-1.16,-0.81,-0.59,-0.71,-1.18,-1.37,-1.26,-1.09,-1.0,-0.67,-0.53,-0.8,-1.07,-1.24,-1.21,-1.22,-1.08,-0.74,-0.57,-0.85,-1.22,-1.32,-1.13,-1.09,-0.98,-0.63,-0.54,-0.84,-1.08,-1.18,-1.14,-1.26,-1.16,-0.78,-0.61,-0.79,-1.19,-1.28,-1.13,-1.12,-0.98,-0.64,-0.56,-0.86,-1.02,-1.23,-1.22,-1.27,-1.07,-0.74,-0.61,-0.93,-1.26,-1.3,-1.07,-1.11,-0.95,-0.63,-0.62,-0.94,-1.02,-1.23,-1.23,-1.29,-1.0,-0.69,-0.67,-1.05,-1.34,-1.3,-1.08,-1.09,-0.79,-0.59,-0.76,-0.93,-0.99,-1.23,-1.3,-1.29,-0.96,-0.7,-0.67,-1.13,-1.42,-1.23,-1.08,-1.11,-0.84,-0.62,-0.73,-0.98,-1.1,-1.25,-1.25,-1.29,-0.96,-0.68,-0.73,-1.08,-1.34,-1.25,-1.2,-1.11,-0.75,-0.6,-0.86,-1.13,-1.19,-1.14,-1.34,-1.26,-0.86,-0.65,-0.79,-1.24,-1.33,-1.22,-1.2,-0.96,-0.65,-0.64,-1.06,-1.22,-1.26,-1.16,-1.3,-1.07,-0.78,-0.74,-0.96,-1.24,-1.27,-1.21,-1.19,-0.85,-0.58,-0.73,-1.09,-1.16,-1.22,-1.26,-1.3,-0.97,-0.7,-0.69,-1.01,-1.22,-1.2,-1.2,-1.19,-0.84,-0.63,-0.86,-1.16,-1.22,-1.17,-1.28,-1.26,-0.9,-0.68,-0.77,-1.11,-1.29,-1.22,-1.16,-1.08,-0.76,-0.64,-0.9,-1.12,-1.28,-1.2,-1.26,-1.13,-0.77,-0.62,-0.82,-1.26,-1.37,-1.17,-1.22,-1.0,-0.65,-0.6,-0.93:-0.93,-0.62,-0.4,-0.57,-0.82,-0.76,-0.76,-0.53,-0.4,-0.23,-0.17,-0.28,-0.62,-0.64,-0.5,-0.39,-0.19,-0.15,-0.32,-0.47,-0.45,-0.15,-0.3,-0.42,-0.15,-0.06,-0.41,-0.49,-0.61,-0.48,-0.35,-0.16,-0.17,-0.28,-0.3,-0.22,-0.09,-0.08,-0.24,-0.27,-0.22,-0.38,-0.65,-0.44,-0.38,-0.35,-0.14,-0.11,-0.36,-0.44,-0.62,-0.28,-0.14,-0.29,-0.27,0.17,0.07,0.04,0.08,-0.09,-0.22,-0.27,-0.13,-0.31,-0.29,-0.26,0.0,-0.02,-0.26,-0.62,-1.25,-1.49,-1.28,-1.37,-0.72,-0.55,-0.74,-0.33,-0.02,-0.57,-0.85,-1.22,-0.6,-0.48,-0.32,-0.44,-0.74,-0.82,-0.85,-0.69,-0.6,-0.68,-0.47,-0.46,-0.71,-1.48,-1.57,-0.94,-1.13,-0.76,-0.29,-0.15,-0.28,-0.2,-0.32,-0.72,-0.6,0.24,-0.55,-1.16,-0.75,-0.44,-0.35,-0.51,-0.73,-0.82,-0.81,-0.71,-0.75,-0.54,-0.25,-0.14,0.04,0.38,0.72,0.89,0.65,0.71,0.74,0.36,-0.06,-0.31,-0.32,-0.59,-0.72,-1.13,-1.1,-0.84,-0.61,-0.59,-0.62,-0.59,-0.56,-0.46,-0.59,-0.84,-1.06,-0.76,-0.44,-0.31,-0.64,-0.87,-0.32,-0.12,-0.16,0.0,0.53,1.0,0.54,0.09,0.01,0.12,0.21,0.12,-0.03,0.05,0.01,-0.23,-0.22,-0.25,-0.78,-0.74,-0.8,-0.79,-0.64,-0.54,-0.5,-0.49,-0.58,-0.61,-0.38,-0.21,-0.72,-1.02,-0.69,-0.26,-0.06,0.01,0.15,0.32,0.55,0.75,0.69,0.66,0.34,-0.04,-0.23,-0.38,-0.85,-1.02,-0.89,-0.76,-0.26,-0.04,0.11,0.2:-0.3,-0.49,-0.66,-0.52,-0.44,-0.22,-0.09,-0.09,0.06,0.2,0.26,0.04,-0.09,-0.29,-0.29,-0.3,-0.47,-0.65,-0.49,-0.41,-0.28,-0.19,-0.2,-0.04,0.04,0.2,0.03,-0.02,-0.2,-0.28,-0.29,-0.45,-0.68,-0.59,-0.53,-0.28,-0.3,-0.23,-0.03,0.02,0.07,-0.02,-0.15,-0.22,-0.25,-0.28,-0.45,-0.66,-0.64,-0.47,-0.25,-0.33,-0.12,0.0,0.12,0.11,0.06,-0.19,-0.29,-0.27,-0.24,-0.46,-0.59,-0.58,-0.43,-0.25,-0.33,-0.14,-0.04,-0.05,-0.05,-0.11,-0.23,-0.22,-0.2,-0.25,-0.54,-0.7,-0.65,-0.35,-0.27,-0.34,-0.14,-0.05,-0.04,-0.07,-0.18,-0.27,-0.22,-0.25,-0.4,-0.55,-0.55,-0.54,-0.33,-0.25,-0.23,-0.14,-0.08,0.07,-0.08,-0.14,-0.26,-0.27,-0.25,-0.34,-0.55,-0.58,-0.47,-0.29,-0.27,-0.24,-0.11,-0.05,0.03,-0.06,-0.2,-0.23,-0.19,-0.2,-0.3,-0.5,-0.61,-0.5,-0.3,-0.29,-0.28,-0.15,-0.03,0.05,-0.03,-0.22,-0.24,-0.2,-0.19,-0.3,-0.52,-0.58,-0.48,-0.21,-0.3,-0.24,-0.04,0.07,0.02,0.0,-0.24,-0.23,-0.22,-0.21,-0.44,-0.55,-0.55,-0.41,-0.23,-0.31,-0.18,-0.07,0.02,0.05,-0.06,-0.2,-0.2,-0.21,-0.24,-0.49,-0.62,-0.58,-0.35,-0.26,-0.31,-0.13,-0.02,0.11,0.03,-0.13,-0.24,-0.2,-0.23,-0.31,-0.52,-0.59,-0.52,-0.28,-0.26,-0.27,-0.08,0.03,0.08,0.01,-0.17,-0.24,-0.22,-0.18,-0.33,-0.52,-0.59,-0.48,-0.24,-0.3,-0.25,-0.07,0.07,0.05,0.02,-0.18:WALKING
-1.0,-1.34,-1.45,-1.26,-1.24,-1.07,-0.84,-0.72,-0.68,-0.71,-0.97,-1.2,-1.13,-1.14,-1.06,-0.87,-0.81,-0.79,-0.86,-1.18,-1.41,-1.28,-1.24,-1.16,-0.91,-0.78,-0.7,-0.67,-0.86,-1.1,-1.24,-1.17,-1.11,-0.96,-0.82,-0.81,-0.79,-0.87,-1.26,-1.41,-1.23,-1.26,-1.09,-0.86,-0.75,-0.7,-0.72,-0.94,-1.18,-1.17,-1.13,-1.08,-0.91,-0.8,-0.79,-0.8,-1.01,-1.34,-1.44,-1.26,-1.21,-1.05,-0.83,-0.72,-0.67,-0.72,-0.96,-1.24,-1.2,-1.13,-1.09,-0.9,-0.78,-0.78,-0.84,-1.07,-1.41,-1.38,-1.27,-1.23,-0.95,-0.74,-0.66,-0.61,-0.74,-1.08,-1.32,-1.26,-1.19,-0.98,-0.81,-0.8,-0.83,-0.97,-1.32,-1.46,-1.27,-1.25,-1.09,-0.83,-0.72,-0.66,-0.73,-1.0,-1.23,-1.14,-1.12,-1.1,-0.91,-0.82,-0.85,-0.85,-1.06,-1.35,-1.39,-1.21,-1.2,-0.98,-0.77,-0.7,-0.66,-0.78,-1.08,-1.32,-1.16,-1.16,-1.01,-0.83,-0.79,-0.83,-0.95,-1.38,-1.51,-1.29,-1.28,-1.1,-0.83,-0.72,-0.66,-0.73,-1.0,-1.23,-1.16,-1.2,-1.13,-0.93,-0.84,-0.83,-0.89,-1.23,-1.49,-1.28,-1.34,-1.26,-0.96,-0.79,-0.68,-0.62,-0.81,-1.09,-1.23,-1.24,-1.26,-1.02,-0.87,-0.77,-0.75,-0.95,-1.29,-1.48,-1.32,-1.24,-1.19,-0.92,-0.8,-0.76,-0.89,-1.09,-1.12,-1.11,-1.16,-0.96,-0.86,-0.88,-1.0,-1.27,-1.52,-1.39,-1.45,-1.23,-0.91,-0.79,-0.76,-0.87,-1.01,-1.08,-1.21,-1.3,-1.0,-0.91,-0.94,-0.95,-1.16,-1.54,-1.42,-1.41:-1.57,-1.17,-0.76,-0.49,-0.3,-0.28,-0.41,-0.67,-0.68,-1.21,-1.12,-0.82,-0.74,-0.66,-0.68,-0.78,-0.93,-0.82,-0.71,-0.96,-0.79,-0.58,-0.4,-0.37,-0.62,-0.97,-1.13,-1.12,-1.08,-1.09,-1.02,-0.83,-0.68,-0.68,-0.84,-1.14,-1.25,-1.21,-1.02,-0.89,-0.64,-0.31,-0.13,-0.05,-0.02,-0.2,-0.32,-0.53,-0.36,-0.5,-0.63,-0.7,-0.8,-0.86,-0.66,-0.79,-0.66,-0.39,-0.24,-0.27,-0.26,-0.27,-0.24,-0.17,-0.19,-0.25,-0.35,-0.27,-0.16,-0.19,-0.23,-0.29,-0.36,-0.44,-0.4,-0.43,-0.39,-0.34,-0.29,-0.26,-0.23,-0.19,-0.18,-0.21,-0.31,-0.44,-0.36,-0.27,-0.27,-0.31,-0.36,-0.38,-0.43,-0.38,-0.36,-0.35,-0.32,-0.24,-0.21,-0.21,-0.18,-0.19,-0.24,-0.36,-0.45,-0.38,-0.31,-0.3,-0.35,-0.34,-0.39,-0.43,-0.36,-0.32,-0.32,-0.28,-0.23,-0.23,-0.21,-0.18,-0.21,-0.25,-0.4,-0.5,-0.34,-0.27,-0.29,-0.39,-0.42,-0.43,-0.4,-0.41,-0.27,-0.28,-0.27,-0.23,-0.23,-0.2,-0.21,-0.24,-0.26,-0.42,-0.47,-0.33,-0.31,-0.34,-0.43,-0.42,-0.42,-0.4,-0.35,-0.28,-0.27,-0.22,-0.19,-0.2,-0.2,-0.22,-0.28,-0.3,-0.45,-0.45,-0.32,-0.31,-0.36,-0.42,-0.41,-0.4,-0.39,-0.4,-0.31,-0.27,-0.22,-0.2,-0.21,-0.18,-0.18,-0.22,-0.32,-0.49,-0.39,-0.32,-0.32,-0.39,-0.41,-0.45,-0.41,-0.38,-0.28,-0.26,-0.25,-0.2,-0.2,-0.18,-0.2,-0.21,-0.23,-0.36,-0.45,-0.36,-0.33,-0.36,-0.44,-0.43,-0.42,-0.38:-0.63,-0.53,-0.41,-0.32,-0.4,-0.51,-0.59,-0.63,-0.59,-0.36,-0.27,-0.15,-0.3,-0.55,-0.65,-0.69,-0.74,-0.74,-0.64,-0.49,-0.39,-0.21,-0.07,-0.37,-0.47,-0.39,-0.43,-0.33,-0.22,-0.22,-0.21,-0.24,-0.37,-0.45,-0.58,-0.67,-0.67,-0.55,-0.42,-0.3,-0.32,-0.36,-0.43,-0.46,-0.43,-0.29,-0.2,-0.21,-0.13,-0.16,-0.25,-0.38,-0.51,-0.62,-0.64,-0.57,-0.47,-0.32,-0.28,-0.25,-0.34,-0.39,-0.42,-0.32,-0.23,-0.2,-0.19,-0.18,-0.24,-0.41,-0.51,-0.62,-0.62,-0.53,-0.42,-0.31,-0.31,-0.38,-0.44,-0.5,-0.52,-0.37,-0.29,-0.26,-0.21,-0.22,-0.31,-0.45,-0.55,-0.63,-0.64,-0.57,-0.47,-0.36,-0.32,-0.42,-0.49,-0.57,-0.61,-0.46,-0.31,-0.24,0.03,-0.03,0.01,-0.15,-0.09,-0.27,-0.42,-0.28,-0.42,-0.17,-0.17,-0.09,-0.03,0.08,0.14,0.12,0.16,0.24,0.16,0.19,0.25,0.25,0.2,0.15,0.07,-0.04,-0.13,-0.21,-0.31,-0.48,-0.39,-0.39,-0.45,-0.34,-0.13,-0.22,-0.25,-0.27,-0.27,-0.29,-0.37,-0.41,-0.44,-0.28,-0.16,-0.07,-0.04,-0.1,-0.1,-0.13,-0.01,0.16,0.34,0.33,0.35,0.36,0.26,0.25,0.35,0.28,-0.06,-0.41,-0.59,-0.6,-0.53,-0.37,-0.42,-0.49,-0.56,-0.63,-0.43,-0.39,-0.43,-0.22,-0.23,-0.22,-0.23,-0.28,-0.43,-0.55,-0.58,-0.53,-0.44,-0.41,-0.31,-0.13,-0.25,-0.3,-0.35,-0.28,0.01,0.14,0.1,0.07,0.03,-0.13,-0.01,0.07,0.07,-0.13,-0.42,-0.61,-0.57,-0.36:WALKING
-0.99,-0.98,-1.0,-0.97,-0.95,-0.97,-0.99,-1.0,-0.99,-0.98,-0.97,-0.98,-0.98,-0.97,-0.99,-0.98,-0.98,-0.98,-0.98,-0.97,-0.97,-0.97,-0.98,-0.99,-0.98,-0.98,-0.94,-1.0,-1.05,-1.0,-0.92,-0.89,-0.87,-0.85,-0.91,-1.0,-1.13,-1.26,-1.17,-1.23,-2.15,-3.59,-3.2,-2.03,-1.38,-1.89,-3.52,-3.59,-2.36,-0.64,0.55,0.02,-2.74,-3.59,-2.88,-1.94,-1.66,-3.04,-3.59,-2.0,-0.41,0.93,0.29,-2.6,-3.16,-2.01,-1.57,-1.59,-3.49,-3.02,-1.69,0.29,1.04,0.09,-3.15,-2.77,-1.84,-1.51,-1.72,-3.59,-2.74,-1.13,0.8,1.0,-1.12,-3.46,-2.53,-1.98,-1.65,-2.07,-3.45,-2.0,-0.59,0.83,0.67,-1.49,-3.08,-2.35,-1.71,-1.3,-2.54,-3.39,-1.91,-0.2,1.02,0.61,-1.96,-3.18,-2.18,-1.79,-1.52,-2.94,-2.73,-1.66,-0.02,1.18,0.26,-2.67,-2.81,-2.05,-1.72,-1.32,-2.18,-2.82,-1.69,-0.06,0.92,0.05,-2.99,-2.91,-2.09,-1.77,-1.42,-3.02,-2.49,-1.37,0.28,1.1,0.01,-3.0,-2.59,-1.88,-1.64,-1.48,-3.17,-2.43,-1.01,0.41,0.8,-0.75,-3.2,-2.36,-1.75,-1.62,-1.8,-3.09,-2.39,-0.85,0.77,0.5,-1.87,-3.1,-2.28,-1.58,-1.37,-1.76,-2.81,-1.91,-0.5,0.98,0.49,-2.1,-2.82,-2.05,-1.53,-1.26,-2.04,-3.14,-2.03,-0.2,1.16,0.22,-2.86,-2.89,-1.91,-1.52,-1.24,-2.48,-2.35,-1.24,0.28,1.2,0.2,-2.57,-2.41,-1.62,-1.41,-1.34,-3.25,-2.53,-1.16,0.52,1.0,-0.42,-3.17,-2.55:-1.33,-1.8,-2.72,-1.83,-0.78,0.68,1.52,0.68,-2.57,-1.28,-0.89,-1.39,-1.87,-3.17,-1.59,-0.89,1.18,1.58,0.32,-1.37,-1.1,-1.23,-1.49,-1.52,-3.17,-1.18,-0.5,1.22,1.12,-0.81,-1.55,-0.99,-1.08,-1.72,-1.21,-3.13,-1.07,-0.47,1.25,0.99,-0.53,-1.3,-1.05,-1.22,-1.74,-1.46,-3.01,-0.93,-0.38,1.39,0.86,-1.39,-1.48,-1.33,-1.27,-1.64,-1.58,-2.67,-0.89,0.18,1.19,0.6,-2.18,-1.82,-1.47,-1.39,-1.62,-2.74,-1.78,-0.89,0.46,1.13,0.69,-2.49,-1.63,-1.49,-1.77,-1.79,-3.34,-1.28,-0.65,0.86,1.19,0.1,-2.02,-1.17,-1.07,-1.5,-1.79,-3.5,-1.5,-0.6,1.17,1.05,-0.13,-1.29,-1.21,-1.46,-1.79,-1.49,-3.15,-0.79,-0.47,1.26,1.05,-0.97,-1.5,-1.6,-0.98,-1.18,-1.4,-2.96,-1.27,-0.21,1.22,0.71,-1.8,-1.47,-1.47,-1.26,-1.86,-2.0,-2.59,-0.96,-0.04,1.22,0.58,-1.57,-1.94,-1.25,-1.13,-2.23,-2.25,-2.55,-1.19,0.14,0.97,0.31,-2.33,-1.39,-1.48,-1.47,-1.67,-2.74,-1.86,-0.94,0.74,1.19,0.42,-2.25,-1.13,-1.18,-1.86,-1.73,-3.2,-1.24,-0.55,0.9,1.16,0.11,-1.73,-1.32,-1.3,-1.29,-1.48,-3.23,-1.59,-0.73,1.0,1.04,-0.1,-1.83,-1.35,-1.05,-1.57,-1.74,-3.29,-1.34,-0.73,1.12,1.21,0.42,-1.38,-1.05,-1.13,-1.21,-1.33,-2.86,-1.7,-0.69,0.63,1.21,0.41,-2.26,-1.46,-1.19,-0.94,-1.08,-1.79,-1.97,-0.58,-0.44,1.04,0.87,-0.2,-1.91:0.49,-0.57,-0.05,-0.07,0.26,0.16,-0.17,0.36,-0.55,-0.23,0.24,0.43,-0.36,-0.01,0.0,0.29,-0.01,-0.2,-0.12,-0.45,-0.07,0.33,0.27,-0.38,-0.02,0.06,0.37,0.02,0.03,-0.24,-0.6,-0.03,0.65,0.01,-0.29,0.1,0.01,0.42,-0.11,-0.98,-0.71,-0.97,-0.12,0.49,-0.45,-0.37,-0.16,0.04,0.48,-0.28,-0.38,-0.3,-0.37,0.24,0.73,-0.47,0.21,-0.04,0.17,0.24,0.02,0.51,-0.01,-0.27,0.07,0.16,-0.06,0.12,0.22,0.24,0.31,-0.15,-0.06,-0.66,-0.14,0.15,0.03,-0.28,-0.11,0.02,0.27,0.06,-0.45,0.16,-0.69,-0.16,0.27,0.16,-0.21,-0.09,0.08,0.41,0.0,-0.7,-0.36,-0.55,0.01,0.54,-0.38,-0.27,-0.11,-0.01,0.5,-0.08,-0.5,-0.52,-0.25,-0.14,0.33,-0.43,-0.19,-0.38,0.08,0.19,-0.2,0.16,-0.45,-0.04,0.18,0.66,-0.7,-0.22,-0.29,0.19,0.32,-0.15,0.93,0.23,-0.01,-0.01,0.52,0.05,0.3,0.29,0.33,0.51,0.07,-0.52,-0.7,-0.22,0.1,0.49,-0.46,-0.27,-0.07,0.34,0.18,-0.22,0.53,-0.41,-0.14,0.52,-0.02,-0.33,-0.33,-0.04,0.33,0.17,-0.2,0.27,-0.46,-0.13,0.1,0.27,-0.48,-0.2,-0.04,0.21,0.04,-0.65,0.29,-0.43,-0.16,0.36,0.18,-0.46,-0.25,0.01,0.32,0.05,-0.22,0.01,-0.54,-0.22,0.13,0.5,-0.55,-0.44,-0.33,0.26,0.12,-0.37,0.0,-0.84,-0.51,0.02,0.54,-0.49,-0.63,-0.61,-0.13,0.24,0.04,-0.4,-0.27,-0.61:RUNNING
0.98,0.97,0.98,1.0,1.0,0.98,0.99,0.97,0.97,0.97,0.97,0.97,1.0,0.99,1.0,0.99,0.99,0.99,0.98,0.98,0.99,0.98,0.97,0.99,0.99,0.98,0.99,0.99,0.98,0.98,0.99,0.97,0.99,0.98,0.98,1.04,0.98,0.94,1.0,0.97,0.95,0.96,0.95,0.95,0.97,0.97,1.0,1.02,0.97,0.99,1.0,0.98,0.95,0.9,0.97,1.24,1.68,1.33,1.02,1.41,2.93,3.15,1.77,0.75,0.9,1.97,3.16,3.36,1.75,0.05,-0.5,-0.02,2.28,3.24,2.3,1.22,0.99,1.34,2.83,3.35,1.46,-0.26,-0.92,-0.16,2.19,3.21,2.28,1.07,1.0,1.5,2.94,2.95,0.6,-0.63,-0.96,-0.24,2.2,3.05,1.92,1.14,1.14,1.71,3.1,1.25,-0.52,-1.1,-1.12,0.37,2.53,2.37,1.38,1.01,1.15,2.63,2.01,0.24,-0.84,-1.14,-0.53,1.19,2.14,1.58,1.02,0.99,2.1,2.56,0.58,-0.56,-1.0,-1.17,-0.09,1.6,1.79,1.41,1.2,1.24,2.69,1.52,0.07,-0.6,-1.12,-1.05,0.07,2.02,2.1,1.39,1.1,1.53,2.27,0.53,-0.46,-0.9,-1.27,-0.75,1.3,2.21,1.7,1.36,1.24,2.1,1.99,0.4,-0.41,-0.89,-1.06,-0.21,1.68,1.59,1.22,0.95,1.11,2.49,1.91,0.08,-0.85,-1.12,-0.64,1.03,2.24,1.56,1.01,1.01,1.8,2.96,1.0,-0.34,-0.87,-1.09,-0.26,1.76,2.1,1.41,1.03,1.14,2.56,1.95,0.17,-0.58,-1.03,-0.97,0.56,2.29,1.72,1.22,1.19,1.49:0.24,0.24,0.22,0.23,0.24,0.22,0.25,0.3,0.33,0.35,0.31,0.3,0.28,0.26,0.24,0.22,0.22,0.22,0.2,0.13,0.1,0.1,0.11,0.15,0.17,0.17,0.15,0.18,0.25,0.5,0.66,1.28,2.6,1.44,-0.64,-1.3,-1.07,-0.88,-0.2,1.26,1.58,1.75,1.71,1.71,2.95,2.32,-0.05,-1.39,-1.36,-0.97,-0.38,1.85,1.7,1.51,1.39,1.76,2.98,1.98,-0.51,-1.45,-1.26,-0.78,0.7,2.36,1.81,1.45,1.22,1.49,2.99,1.84,-0.32,-1.23,-1.06,-0.38,2.24,2.29,1.27,0.58,0.55,2.4,3.0,0.82,-0.91,-1.2,-0.7,1.51,2.65,1.84,1.12,0.57,1.73,3.09,1.81,-0.35,-1.03,-0.71,0.89,2.8,1.82,0.79,0.35,0.53,2.52,2.92,1.01,-0.41,-0.86,-0.6,1.84,2.78,1.46,0.62,0.2,0.68,2.7,2.73,0.57,-0.58,-0.92,-0.13,2.44,2.18,0.93,0.3,0.07,1.62,3.05,1.73,-0.12,-0.88,-0.63,1.1,2.88,2.0,0.84,0.25,0.15,2.16,2.88,1.03,-0.37,-0.9,-0.71,1.49,2.67,1.5,0.64,0.27,1.18,2.93,1.94,-0.23,-1.03,-0.83,0.01,2.52,2.15,1.11,0.56,0.42,2.09,3.1,1.05,-0.6,-1.03,-0.67,1.62,2.59,1.29,0.53,0.13,0.87,2.81,2.53,0.15,-0.91,-0.91,-0.23,2.32,2.14,1.07,0.54,0.34,1.51,3.02,1.51,-0.37,-1.07,-0.78,0.45,2.65,1.68,0.65,0.21,0.27,2.42,2.95,0.8,-0.72,-1.06,-0.64,1.81,2.4,1.34,0.63,0.37:0.03,0.03,0.02,0.01,0.01,0.01,0.01,0.0,0.02,0.06,0.07,0.08,0.08,0.08,0.08,0.07,0.03,-0.14,-0.35,-0.15,0.75,1.57,2.02,1.72,1.27,1.15,1.83,1.25,0.44,0.18,0.18,0.06,1.11,1.99,1.96,1.47,1.1,0.76,1.62,0.8,-0.04,-0.15,0.02,0.03,0.78,1.52,1.44,0.92,0.6,0.63,1.67,0.84,-0.18,-0.36,-0.08,0.24,0.86,1.12,1.05,0.86,0.85,0.88,0.75,0.43,0.24,0.18,0.13,0.34,0.87,1.01,0.91,0.72,0.59,0.89,0.74,0.56,0.34,0.38,0.52,1.02,0.97,0.7,0.51,0.54,0.73,0.6,0.32,0.16,0.11,0.22,0.61,0.89,0.9,0.63,0.51,0.5,0.28,0.01,0.1,0.27,0.48,0.32,0.1,0.5,0.66,0.56,0.5,0.58,0.26,0.07,0.01,0.01,0.23,0.08,-0.01,0.18,0.58,0.65,0.55,0.27,0.08,-0.01,0.05,-0.02,0.17,0.14,0.47,0.5,0.5,0.61,0.64,0.5,0.16,0.04,0.0,0.07,0.01,0.36,0.81,0.8,0.63,0.63,0.71,0.5,0.17,0.09,0.06,0.14,0.18,0.68,0.99,0.76,0.73,0.56,0.53,0.21,0.03,-0.07,0.1,0.18,0.41,0.64,0.67,0.57,0.6,0.51,0.66,0.38,0.22,0.15,0.0,0.04,0.62,0.92,0.78,0.75,0.59,0.58,0.31,0.06,-0.15,-0.04,0.28,0.36,0.58,0.55,0.33,0.41,0.49,0.37,0.03,-0.03,0.13,0.22,0.19,0.14,0.43,0.6,0.6,0.59,0.58,0.49,0.04,-0.03,-0.09,-0.15:RUNNING
0.99,1.0,0.98,0.99,1.0,0.98,0.98,0.99,0.98,0.98,1.0,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.98,0.99,0.98,0.98,0.99,0.94,0.97,1.05,0.91,0.94,1.0,0.92,0.83,0.77,0.78,0.99,1.0,0.66,0.28,0.47,1.48,1.27,0.5,0.35,0.52,1.62,1.06,-0.21,-0.67,-0.58,-0.41,1.12,1.1,0.72,0.58,0.78,1.42,1.29,0.06,-0.7,-0.79,-0.68,0.39,1.06,0.55,0.52,0.76,1.02,1.6,0.45,-0.36,-0.79,-0.83,-0.31,0.96,0.55,0.58,0.78,0.98,1.71,0.69,-0.3,-0.81,-0.84,-0.53,0.71,0.8,0.51,0.56,0.84,1.48,0.98,-0.2,-0.72,-0.86,-0.68,0.49,0.78,0.55,0.61,0.86,1.26,0.94,-0.17,-0.66,-0.88,-0.56,0.34,0.74,0.53,0.57,0.8,1.2,1.0,-0.02,-0.54,-0.8,-0.69,0.3,0.93,0.57,0.64,0.83,1.13,1.13,-0.03,-0.59,-0.83,-0.7,-0.08,0.8,0.57,0.64,0.91,1.04,1.17,0.07,-0.51,-0.89,-0.77,-0.19,0.78,0.56,0.58,0.76,0.98,1.29,0.39,-0.38,-0.9,-0.82,-0.27,0.87,0.63,0.49,0.69,0.96,1.22,0.45,-0.29,-0.74,-0.86,-0.61,0.49,0.55,0.59,0.72,0.92,1.18,0.43,-0.29,-0.77,-0.86,-0.59,0.52,0.66,0.55,0.59,0.77,1.13,0.82,-0.15,-0.65,-0.86,-0.72,0.12,0.72,0.54,0.64,0.84,1.05,0.83,0.04,-0.44,-0.87,-0.82,-0.29,0.72,0.5,0.59,0.65,0.81,1.08,0.32,-0.34,-0.84,-0.86,-0.58:0.2,0.22,0.24,0.26,0.25,0.27,0.27,0.25,0.24,0.25,0.24,0.25,0.26,0.27,0.27,0.27,0.26,0.26,0.26,0.27,0.26,0.27,0.24,0.26,0.26,0.27,0.3,0.28,0.31,0.42,0.48,0.53,0.59,0.72,0.83,0.75,0.66,0.6,1.13,2.14,1.33,0.12,-0.31,-0.28,1.19,1.89,0.97,0.43,0.24,0.97,3.35,1.69,0.18,-0.35,-0.39,0.81,2.39,1.78,0.69,0.2,0.5,3.15,2.14,0.74,-0.09,-0.53,-0.15,2.42,2.27,0.99,0.28,0.25,2.65,2.69,1.13,0.13,-0.48,-0.37,1.79,2.66,1.39,0.41,0.18,1.27,2.88,1.69,0.59,-0.29,-0.39,1.18,2.69,1.46,0.44,0.08,1.0,3.0,1.75,0.64,-0.2,-0.44,0.94,2.55,1.73,0.63,0.07,0.94,3.0,1.82,0.67,-0.22,-0.44,0.79,2.68,1.87,0.69,0.16,0.68,3.05,2.11,0.78,-0.14,-0.49,0.32,2.86,1.92,0.72,0.15,0.43,2.86,2.58,1.11,-0.02,-0.54,0.01,2.73,2.19,1.0,0.21,0.39,2.85,2.34,0.97,0.03,-0.44,-0.01,2.48,2.19,1.0,0.29,0.37,2.17,2.79,1.29,0.31,-0.38,-0.37,1.91,2.51,1.26,0.38,0.21,1.47,3.06,1.55,0.44,-0.36,-0.3,1.52,2.57,1.48,0.46,0.12,1.26,3.06,1.77,0.51,-0.26,-0.46,1.01,2.69,1.65,0.55,0.1,0.8,3.02,1.95,0.7,-0.23,-0.42,0.68,2.68,1.77,0.68,0.33,0.75,2.44,2.0,1.07,0.0,-0.47,-0.1,2.2,2.24,0.99,0.32,0.19:1.04,0.64,0.03,-0.44,-0.27,0.75,1.35,0.68,0.2,0.02,0.02,1.26,1.04,0.46,-0.16,-0.19,0.23,0.92,0.77,0.27,0.06,0.03,0.56,0.62,0.26,-0.22,-0.34,-0.03,0.81,0.77,0.3,0.05,0.1,0.63,0.81,0.35,-0.19,-0.27,-0.06,0.79,0.81,0.37,0.04,0.1,0.56,0.72,0.16,-0.32,-0.37,-0.12,0.84,0.99,0.46,0.02,0.05,0.2,0.94,0.45,-0.05,-0.32,-0.15,0.57,0.75,0.37,0.07,0.11,0.11,0.94,0.57,-0.07,-0.29,-0.23,0.72,1.0,0.52,0.1,0.04,0.07,0.96,0.6,0.11,-0.23,-0.11,0.49,0.78,0.64,0.17,0.02,0.12,0.98,0.63,0.2,-0.05,-0.27,0.19,0.83,0.75,0.28,0.07,0.18,0.85,0.76,0.27,-0.21,-0.32,0.14,1.05,0.84,0.37,0.07,0.12,0.72,0.92,0.42,-0.08,-0.22,0.0,0.95,0.88,0.4,0.1,0.1,0.47,0.85,0.43,0.02,-0.28,0.09,1.14,1.49,0.76,0.17,0.11,0.06,1.26,0.86,0.28,-0.27,-0.17,1.04,1.39,0.82,0.36,0.09,0.05,0.93,0.73,0.35,-0.04,-0.25,0.19,1.4,1.04,0.39,0.05,0.02,0.52,1.19,0.5,0.03,-0.16,0.09,0.9,0.82,0.41,0.06,0.11,0.17,0.74,0.32,-0.05,-0.2,-0.1,0.86,0.97,0.48,0.08,0.11,0.1,0.98,0.66,0.04,-0.18,-0.14,0.77,0.93,0.5,0.08,0.01,0.07,1.06,0.67,0.05,-0.27,-0.22,0.88,1.22,0.75,0.23,0.08,0.05,1.12,0.81,0.3,-0.07,-0.15:RUNNING
-1.26,-1.3,0.17,2.39,2.09,1.49,1.26,1.4,3.07,1.87,-0.12,-1.0,-1.39,-0.91,0.54,1.77,1.26,1.12,0.97,0.99,2.73,1.01,-0.27,-0.68,-0.95,-0.9,0.66,1.34,1.19,1.16,1.04,1.16,2.71,0.79,-0.29,-0.55,-0.74,-0.82,0.98,1.1,0.98,0.97,1.02,1.28,2.01,0.14,-0.64,-0.88,-0.81,-0.24,0.95,1.0,1.12,0.95,0.95,2.02,1.86,0.09,-0.65,-1.09,-0.83,0.27,2.0,1.49,1.13,0.97,1.12,2.47,1.83,0.08,-0.71,-1.04,-0.84,1.25,2.29,1.52,1.11,0.98,0.95,2.8,1.0,-0.15,-0.58,-0.77,-0.65,1.1,1.52,1.32,1.09,0.94,1.52,2.82,0.61,-0.53,-1.01,-0.89,-0.41,1.5,1.46,1.11,0.85,1.1,2.3,1.33,-0.15,-0.61,-0.98,-0.8,0.96,1.53,1.42,1.14,1.01,1.21,2.91,0.81,-0.41,-0.81,-1.01,-0.94,1.29,1.51,1.22,1.08,1.07,1.67,1.47,-0.2,-0.59,-0.85,-0.73,-0.31,0.47,1.01,1.19,1.1,1.1,2.49,1.2,-0.22,-0.65,-0.87,-0.73,0.76,1.42,1.09,1.11,0.99,1.39,2.29,0.32,-0.36,-0.59,-0.73,-0.57,1.41,1.12,0.79,0.84,0.88,1.13,1.76,0.05,-0.46,-0.69,-0.65,-0.91,1.34,1.1,0.78,0.8,0.82,1.0,2.61,0.67,-0.25,-0.42,-0.5,-0.57,0.05,1.59,1.22,0.69,0.39,0.38,0.82,0.63,0.3,0.22,0.12,0.59,0.4,0.33,0.27,0.24,0.38,0.42,0.57,0.5,0.37,0.37,0.23,0.18,0.09,0.21,0.23:-0.07,3.09,2.23,0.64,0.36,1.21,3.26,3.59,1.32,-0.3,-1.0,-0.47,-0.12,3.26,2.2,0.52,0.24,0.66,2.93,3.59,1.11,-0.28,-0.73,-0.33,1.94,3.07,0.9,-0.12,-0.4,0.08,3.1,2.68,0.65,-0.34,-0.63,-0.33,2.33,2.81,0.6,-0.23,-0.39,0.15,3.31,2.45,0.42,-0.71,-0.61,-0.1,3.08,2.28,0.5,-0.47,-0.47,0.62,3.51,1.79,0.13,-0.62,-0.44,0.71,3.33,1.52,0.1,-0.41,-0.17,2.7,3.22,1.2,-0.1,-0.58,-0.37,1.55,2.9,0.92,0.08,-0.05,0.1,2.65,3.06,0.86,-0.33,-0.81,-0.53,1.79,2.6,0.65,-0.16,-0.18,0.27,3.21,2.16,0.26,-0.83,-0.7,-0.24,2.89,2.52,0.58,-0.35,-0.4,0.38,3.54,2.12,0.06,-0.79,-0.52,0.19,3.28,1.62,0.01,-0.49,-0.28,2.04,3.59,1.32,-0.36,-0.75,-0.45,2.03,2.71,0.53,-0.4,-0.39,0.06,3.26,3.03,0.56,-0.59,-0.73,-0.28,3.01,2.1,0.22,-0.44,-0.33,1.34,3.59,1.85,0.12,-0.57,-0.5,0.93,3.26,1.01,-0.28,-0.49,-0.35,2.74,3.27,1.13,-0.17,-0.6,-0.38,2.01,2.99,0.63,-0.38,-0.51,0.06,3.23,2.39,-0.06,-0.88,-0.59,0.4,3.33,1.18,-0.22,-0.41,-0.25,1.94,3.59,1.6,0.14,-0.57,-0.47,0.25,3.39,1.95,0.49,-0.22,-0.27,0.65,3.59,1.85,0.31,-0.49,-0.61,-0.11,3.18,2.1,0.63,0.12,-0.05,0.16,2.24,2.01,0.85,0.2,0.0,0.04,0.07,-0.22,-0.11,-0.02,0.08:-0.81,-0.7,0.38,0.57,0.62,0.24,0.65,-0.95,-0.74,-0.31,-0.38,-0.3,-0.39,-0.58,0.39,0.52,0.29,0.31,-0.87,-1.1,-0.14,-0.13,-0.09,-0.07,-1.08,-0.42,0.07,0.32,0.32,0.19,-0.41,-0.75,-0.08,-0.11,-0.15,-0.09,-1.24,-0.43,0.07,0.29,0.21,0.11,-0.77,-0.64,-0.38,-0.22,-0.31,-0.43,-1.29,-0.48,-0.09,0.18,0.22,-0.22,-0.82,-0.66,-0.3,-0.23,-0.17,-0.76,-0.72,-0.02,0.35,0.16,0.1,-0.74,-1.26,-0.68,-0.25,-0.19,-0.19,-1.04,-0.88,-0.03,0.29,0.16,0.28,-0.69,-1.41,-0.71,-0.37,-0.2,-0.18,-1.76,-0.65,-0.09,0.42,0.31,0.31,-0.29,-0.48,-0.18,-0.14,-0.32,-0.15,-1.18,-0.21,0.17,0.31,0.18,0.15,-0.99,-0.54,-0.39,-0.11,-0.15,-0.26,-0.35,0.32,0.53,0.17,0.21,-0.58,-0.84,-0.18,-0.29,-0.23,-0.03,-0.83,-0.48,0.3,0.42,0.22,0.17,-0.89,-0.77,-0.17,-0.21,-0.33,-0.49,-0.98,-0.16,0.32,0.1,0.11,-0.16,-1.38,-0.77,-0.18,-0.11,0.21,-1.25,-1.45,-0.5,-0.03,0.1,-0.04,-0.42,-0.99,-0.14,-0.27,-0.27,-0.11,-0.99,-0.25,0.45,0.32,0.08,-0.24,-0.9,-0.46,-0.18,-0.15,-0.11,-0.16,-0.23,-0.06,0.21,0.35,0.25,0.18,-0.43,-0.48,-0.02,-0.15,-0.07,-0.27,-0.84,-0.37,-0.01,0.14,0.21,0.14,-0.72,-0.88,-0.41,-0.32,-0.16,-0.07,-1.64,-1.45,-0.75,-0.1,0.13,-0.33,-1.09,-1.34,-1.1,-0.72,-0.96,-1.19,-1.05,-1.0,-0.93,-0.9,-0.89:RUNNING
-0.7,-0.84,-2.5,-1.97,0.04,0.84,0.82,0.19,-1.54,-1.96,-1.27,-0.9,-0.85,-1.64,-2.7,-1.21,0.59,1.05,0.76,-0.62,-2.17,-1.99,-1.27,-0.81,-0.87,-2.6,-2.3,-0.09,0.92,1.12,0.73,-1.13,-2.33,-1.79,-1.13,-0.85,-1.42,-2.28,-0.69,0.71,0.84,0.75,-0.35,-1.39,-1.53,-1.16,-0.85,-0.92,-2.25,-1.47,0.2,0.77,0.95,0.76,-0.66,-1.7,-1.37,-1.04,-0.89,-1.65,-2.56,-0.7,0.64,0.98,0.94,-0.29,-1.67,-1.79,-1.29,-0.98,-0.98,-2.43,-1.4,0.19,0.74,1.0,0.7,-0.94,-1.67,-1.37,-1.02,-0.92,-1.97,-1.79,-0.32,0.57,0.85,1.0,-0.08,-1.53,-1.87,-1.37,-1.07,-1.22,-2.54,-1.33,0.16,0.85,1.16,0.68,-1.09,-1.96,-1.52,-1.13,-1.07,-2.22,-1.96,-0.16,0.66,0.98,0.98,-0.26,-1.79,-1.92,-1.41,-1.02,-1.22,-2.61,-1.41,0.21,0.87,1.0,0.56,-1.08,-1.83,-1.39,-1.0,-0.88,-1.7,-1.89,-0.49,0.54,0.89,0.78,-0.48,-1.6,-1.57,-1.08,-0.82,-0.87,-2.13,-1.13,0.11,0.8,1.0,0.4,-1.24,-1.79,-1.36,-0.95,-0.84,-1.86,-1.87,-0.28,0.51,0.87,0.88,-0.01,-1.34,-1.54,-1.13,-0.87,-0.87,-2.18,-1.33,0.2,0.81,0.86,0.51,-1.2,-1.87,-1.48,-0.97,-0.87,-1.55,-1.59,-0.34,0.45,0.81,1.14,0.35,-1.07,-1.58,-1.06,-0.53,-0.53,-0.54,-0.06,0.5,0.54,0.52,0.6,0.33,0.52,0.2,-0.38,-0.32,-0.27,-0.4,-0.54,0.09,0.37,0.51,0.43,-0.06,-0.28:1.05,0.84,0.5,-1.7,-2.45,-1.47,-0.77,-0.34,-1.13,-3.34,-1.97,0.26,1.13,0.8,0.1,-2.66,-2.09,-1.19,-0.54,-0.68,-2.7,-3.42,-1.07,0.74,1.16,0.77,-1.27,-2.9,-1.83,-0.94,-0.36,-0.95,-3.34,-2.74,-0.08,1.17,0.91,0.1,-2.9,-2.12,-0.97,-0.25,-0.05,-2.4,-3.22,-0.94,0.72,0.96,0.66,-1.98,-2.77,-1.38,-0.48,-0.08,-0.41,-3.15,-2.51,-0.04,1.05,0.82,-0.1,-3.0,-2.02,-0.99,-0.33,-0.1,-2.36,-3.38,-1.13,0.73,1.2,0.78,-2.29,-2.72,-1.23,-0.33,0.02,-0.75,-3.32,-2.29,0.0,1.06,0.82,-1.04,-2.95,-1.72,-0.67,-0.09,0.03,-2.52,-3.26,-1.25,0.66,1.25,0.8,-2.43,-2.6,-1.34,-0.52,-0.1,-1.33,-3.5,-2.2,0.06,1.16,0.9,-1.01,-3.05,-1.75,-0.67,-0.09,-0.11,-2.81,-3.07,-0.8,0.79,1.19,0.7,-2.41,-2.6,-1.35,-0.58,-0.22,-1.44,-3.53,-2.04,0.12,0.88,0.71,-0.8,-3.01,-1.84,-0.73,-0.11,-0.12,-2.73,-2.99,-0.72,0.68,0.94,0.63,-2.45,-2.47,-1.14,-0.28,0.02,-1.75,-3.52,-1.77,0.22,1.08,0.75,-0.93,-3.04,-1.85,-0.76,-0.15,0.03,-2.4,-3.2,-1.16,0.45,0.97,0.69,-2.13,-2.66,-1.49,-0.53,-0.11,-0.86,-3.34,-2.07,-0.01,1.22,0.95,-0.56,-3.02,-2.02,-1.01,-0.36,-0.4,-2.52,-3.24,-1.72,-0.34,0.24,-0.09,-1.07,-1.04,-0.71,-0.17,0.19,-0.25,-0.9,-0.99,-0.5,-0.16,0.02,-0.04,-0.67,-1.37,-1.07,-0.63,-0.11,-0.38,-1.24:1.29,0.75,0.29,0.09,0.21,1.14,1.0,0.39,-0.04,-0.02,0.29,1.42,1.21,0.55,0.17,0.23,0.68,1.1,0.74,0.04,-0.02,0.09,0.59,1.18,0.91,0.38,0.17,0.29,1.37,1.19,0.46,0.02,-0.01,0.35,1.21,1.4,0.86,0.34,0.26,0.75,1.35,0.64,-0.06,-0.26,-0.22,0.64,1.24,0.9,0.41,0.2,0.31,1.49,1.27,0.35,-0.05,-0.19,0.11,1.33,1.4,0.82,0.42,0.36,0.7,1.08,0.58,0.03,-0.15,-0.16,0.66,1.27,1.02,0.49,0.22,0.37,1.22,0.77,0.11,-0.19,-0.17,0.16,1.13,1.13,0.66,0.34,0.29,0.97,0.98,0.37,-0.11,-0.21,-0.11,0.62,1.18,0.99,0.5,0.25,0.46,1.13,0.74,0.2,-0.03,-0.04,0.38,1.26,1.21,0.72,0.41,0.44,1.22,1.11,0.45,-0.05,-0.17,-0.04,0.92,1.44,1.02,0.36,0.19,0.46,1.35,0.93,0.31,-0.06,-0.14,0.2,1.33,1.27,0.72,0.42,0.43,0.92,1.02,0.44,-0.1,-0.2,-0.14,0.81,1.22,0.9,0.38,0.16,0.33,1.09,0.73,0.14,-0.19,-0.13,0.31,1.26,1.18,0.59,0.26,0.19,0.71,0.87,0.43,0.1,-0.09,-0.13,0.44,0.94,0.8,0.35,0.22,0.25,0.99,0.76,0.25,-0.03,-0.12,0.11,1.2,1.16,0.55,0.02,0.25,0.86,1.12,0.48,0.07,-0.05,0.0,0.32,0.22,0.19,0.34,0.36,-0.16,-1.0,-1.46,-1.13,-0.42,0.04,-0.23,-0.98,-1.38,-1.18,-0.57,-0.34,-0.56,-1.37,-1.54,-1.19,-0.45,0.17:RUNNING
0.66,0.77,1.04,1.77,1.13,-0.27,-0.94,-1.05,-0.8,0.48,0.87,0.6,0.61,0.88,1.42,1.79,0.08,-0.95,-1.16,-0.81,0.48,1.04,0.65,0.65,0.76,1.08,1.24,0.14,-0.62,-0.9,-0.77,-0.16,0.66,0.36,0.43,0.66,1.01,1.6,0.3,-0.57,-0.84,-0.82,-0.56,0.65,0.49,0.59,0.75,0.82,1.48,0.72,-0.35,-0.87,-0.94,-0.78,0.18,0.5,0.53,0.66,0.85,1.36,0.52,-0.44,-0.8,-0.89,-0.68,0.53,0.66,0.46,0.69,0.85,1.23,1.13,-0.07,-0.62,-0.82,-0.73,-0.14,0.64,0.33,0.55,0.84,1.07,1.2,0.11,-0.51,-0.75,-0.75,-0.5,0.38,0.39,0.5,0.68,0.82,1.2,0.71,-0.16,-0.62,-0.8,-0.6,0.04,0.34,0.41,0.67,0.88,1.06,0.87,0.09,-0.52,-0.81,-0.71,-0.08,0.63,0.38,0.57,0.89,0.99,0.9,0.12,-0.44,-0.82,-0.79,-0.46,0.51,0.28,0.41,0.79,0.99,0.99,0.19,-0.45,-0.82,-0.8,-0.64,0.34,0.41,0.47,0.69,0.79,0.9,0.44,-0.18,-0.7,-0.71,-0.5,0.27,0.48,0.38,0.57,0.75,0.88,1.01,0.02,-0.55,-0.75,-0.62,-0.21,0.5,0.25,0.49,0.76,0.89,0.79,0.02,-0.51,-0.69,-0.69,-0.65,-0.08,0.1,0.26,0.56,0.74,0.8,0.24,-0.33,-0.64,-0.75,-0.62,-0.48,0.13,0.23,0.6,0.8,0.89,0.46,-0.25,-0.48,-0.66,-0.75,-0.76,-0.17,0.05,0.42,0.76,0.92,0.92,0.27,-0.29,-0.7,-0.73,-0.57,-0.3,0.23,0.38,0.58,0.79:-0.07,-0.07,-0.06,-0.06,-0.13,-0.1,0.21,0.12,0.03,0.11,0.22,0.29,0.31,0.37,0.39,0.36,0.32,0.36,0.34,0.39,0.37,0.32,0.16,0.07,0.08,0.43,0.7,0.77,0.68,1.28,1.91,0.83,-0.08,-0.56,-0.66,-0.33,1.63,2.07,1.18,0.51,0.48,2.93,2.86,0.93,-0.12,-0.47,-0.2,1.55,2.78,1.8,0.69,0.18,1.29,3.3,1.53,0.3,-0.39,-0.39,1.41,2.93,1.84,0.68,0.13,0.79,3.29,1.86,0.61,-0.23,-0.39,0.73,2.99,1.95,0.87,0.2,0.68,3.25,2.19,0.81,-0.22,-0.42,0.53,2.4,2.26,1.0,0.14,0.34,2.73,2.52,1.18,0.0,-0.47,-0.05,2.79,2.42,0.99,0.14,0.07,2.25,2.98,1.36,0.26,-0.35,-0.32,1.76,2.75,1.44,0.35,0.06,1.05,3.31,1.79,0.51,-0.37,-0.38,1.69,3.0,1.54,0.41,0.08,1.0,3.26,1.79,0.38,-0.37,-0.38,0.86,3.03,1.83,0.66,0.09,0.57,2.97,2.37,1.0,-0.07,-0.38,0.19,2.75,2.37,0.98,0.09,0.14,1.85,2.92,1.59,0.32,-0.32,-0.22,1.8,2.89,1.5,0.24,0.0,0.86,3.05,1.96,0.69,-0.23,-0.4,0.97,2.84,1.89,0.79,0.23,0.63,2.82,2.34,1.01,-0.11,-0.51,0.35,2.61,2.25,0.96,0.25,0.41,2.38,2.57,1.19,0.26,-0.31,-0.07,2.0,2.52,1.2,0.37,0.33,1.89,2.74,1.34,0.36,-0.26,-0.1,1.54,2.58,1.41,0.51,0.35,1.26,2.69,1.83,0.84,-0.14,-0.5,0.68,2.73:-0.19,-0.2,-0.2,-0.19,-0.19,-0.19,-0.19,-0.19,-0.17,-0.18,-0.12,-0.15,-0.14,-0.05,-0.02,-0.01,-0.03,-0.11,-0.03,0.1,0.16,0.16,0.14,0.15,0.22,0.27,0.22,0.14,0.15,0.55,0.26,0.02,-0.03,0.46,1.27,0.92,0.24,-0.03,-0.08,0.03,0.61,0.42,0.11,-0.17,-0.16,-0.07,0.19,0.24,0.13,0.24,0.27,0.58,0.17,0.22,-0.11,-0.15,0.14,0.43,0.53,0.24,0.06,0.19,0.78,0.39,0.3,-0.09,-0.15,0.0,0.4,0.5,0.19,0.11,0.28,0.15,0.13,0.21,-0.14,-0.09,0.05,0.47,0.57,0.23,0.05,0.11,0.07,0.36,0.28,0.02,-0.11,-0.06,0.24,0.42,0.23,0.05,0.12,0.04,0.49,0.21,-0.06,-0.27,-0.13,0.31,0.58,0.42,0.12,0.09,0.11,0.63,0.32,0.16,-0.19,-0.16,0.17,0.68,0.68,0.2,0.1,0.15,0.68,0.45,0.12,-0.32,-0.14,0.11,0.83,0.68,0.27,0.09,0.21,0.58,0.8,0.39,-0.13,-0.19,-0.03,0.8,0.89,0.39,0.08,0.21,0.1,0.8,0.32,0.05,-0.17,-0.13,0.15,0.48,0.43,0.25,0.24,0.22,0.7,0.43,0.05,-0.19,-0.24,0.13,0.74,0.72,0.29,0.1,0.25,0.63,0.7,0.38,0.03,-0.11,0.03,0.68,0.91,0.45,0.06,0.13,0.26,0.73,0.36,-0.01,-0.27,-0.16,0.64,0.96,0.56,0.14,0.11,0.15,1.0,0.6,0.16,-0.16,-0.18,0.46,0.98,0.73,0.19,0.15,0.12,0.73,0.54,0.26,-0.11,-0.18,0.06,0.63,0.78,0.38:RUNNING
-0.98,-0.98,-0.98,-0.99,-0.98,-0.99,-0.99,-0.99,-0.99,-0.98,-0.98,-0.99,-0.99,-0.99,-0.99,-0.99,-0.99,-0.98,-0.99,-0.99,-0.99,-0.99,-0.98,-0.97,-0.97,-0.97,-0.99,-1.0,-1.0,-1.06,-1.13,-1.0,-0.81,-0.89,-0.99,-0.94,-0.81,-0.58,-0.86,-1.66,-1.72,-1.1,-1.09,-2.46,-3.47,-3.03,-1.95,-1.35,-1.66,-3.29,-3.59,-2.68,-0.78,0.12,-0.64,-3.42,-3.59,-2.61,-1.86,-1.89,-3.59,-3.54,-1.95,0.17,0.43,-2.22,-3.59,-2.92,-2.08,-1.64,-1.94,-3.59,-2.77,-1.13,0.26,0.35,-2.17,-3.59,-2.53,-2.0,-1.4,-1.69,-3.5,-2.3,-0.75,0.66,0.47,-2.26,-3.33,-2.25,-1.82,-1.46,-2.55,-3.4,-2.14,-0.42,0.65,0.2,-2.79,-3.13,-2.09,-1.78,-1.54,-3.2,-3.16,-1.65,0.42,0.57,-0.7,-3.47,-3.07,-2.19,-1.83,-1.41,-3.24,-2.81,-1.14,0.33,0.18,-1.36,-3.56,-2.71,-2.1,-1.51,-1.35,-3.41,-2.45,-0.75,0.75,0.73,-1.59,-3.32,-2.45,-1.89,-1.51,-1.58,-3.1,-2.13,-0.51,0.61,0.39,-2.19,-3.35,-2.27,-1.87,-1.36,-2.18,-2.96,-2.15,-0.38,0.54,0.23,-2.7,-3.27,-2.28,-1.85,-1.5,-3.07,-3.25,-2.02,-0.26,0.14,-0.75,-3.3,-3.17,-2.21,-1.75,-1.38,-3.0,-3.18,-1.83,0.03,0.59,-0.05,-2.83,-2.83,-2.0,-1.59,-1.52,-3.25,-3.01,-1.71,0.13,0.4,-0.76,-3.35,-3.21,-2.28,-1.88,-1.59,-3.38,-2.97,-1.66,-0.1,0.28,-0.7,-3.4,-3.13,-2.17,-1.72,-1.38,-3.14,-2.89,-1.66,0.26,0.66:0.55,-2.33,-1.27,-1.21,-1.88,-2.09,-3.29,-1.13,-0.31,1.14,1.2,0.09,-2.15,-1.09,-1.53,-1.78,-2.23,-3.11,-1.1,0.04,1.11,0.82,-1.27,-1.36,-1.85,-1.84,-1.97,-2.74,-2.12,-0.75,0.33,1.52,0.79,-2.0,-0.81,-1.09,-2.12,-1.98,-2.55,-1.65,-0.64,0.83,1.3,0.6,-2.29,-0.99,-1.32,-1.71,-1.79,-3.34,-1.87,-0.71,0.46,1.35,0.27,-2.66,-1.48,-1.4,-1.92,-1.87,-3.42,-1.23,-0.42,0.95,1.33,0.12,-2.26,-1.14,-1.72,-2.07,-1.9,-3.42,-1.0,0.03,1.21,0.76,-0.95,-1.6,-1.21,-1.74,-2.52,-2.12,-2.75,-0.87,-0.04,1.3,1.04,-0.72,-1.85,-1.38,-1.59,-1.94,-2.02,-3.21,-1.07,0.27,1.1,0.75,-1.7,-1.64,-1.65,-1.69,-2.07,-2.42,-2.66,-1.01,0.06,1.47,0.91,-1.46,-1.69,-1.23,-1.79,-2.46,-2.45,-2.64,-0.92,0.0,1.47,0.89,-1.28,-1.85,-1.27,-1.98,-2.12,-2.82,-2.09,-0.73,0.37,1.54,0.79,-2.24,-1.34,-1.53,-1.82,-2.14,-3.14,-1.47,-0.6,0.85,1.24,0.37,-2.37,-1.07,-0.98,-1.5,-1.79,-2.61,-1.79,-0.63,0.53,1.19,0.56,-1.98,-0.92,-0.86,-1.59,-2.03,-2.13,-1.79,-0.69,0.02,1.29,0.66,-0.49,-2.01,-1.16,-0.95,-1.74,-1.59,-2.46,-0.83,-0.34,0.82,1.05,0.47,-1.99,-0.9,-0.76,-1.34,-1.76,-1.27,-1.58,-1.27,-0.28,0.47,1.0,0.7,-0.96,-1.33,-0.75,-0.94,-0.81,-0.66,-0.49,-0.25,-0.12,-0.01,-0.06,-0.1,-0.1,-0.02,0.01,0.04,0.04,0.15:0.04,0.03,0.02,0.01,0.02,0.02,0.02,0.03,0.03,0.02,0.02,0.02,0.02,0.01,0.01,0.02,0.01,0.01,0.02,0.01,0.0,-0.01,-0.01,-0.07,-0.1,-0.08,0.0,0.09,0.12,0.1,0.05,0.06,0.04,-0.01,-0.14,-0.31,0.0,-0.03,-0.33,-0.11,0.68,1.1,1.59,1.18,0.96,0.71,1.62,0.96,0.28,-0.48,-0.52,-0.32,0.49,0.76,0.82,1.22,1.02,0.94,0.09,-0.64,-0.7,-0.27,-0.6,0.82,0.36,0.81,0.44,0.28,0.68,-0.21,-0.39,-0.46,-0.25,-0.98,0.21,0.24,0.78,0.22,-0.04,0.12,-0.54,-0.47,-0.23,-0.22,-0.69,0.21,0.15,0.54,0.28,-0.01,-0.1,-0.51,-0.31,-0.43,-0.16,-0.39,0.24,0.36,0.69,0.24,-0.13,-0.35,-0.42,-0.52,-0.45,-0.23,0.17,0.34,0.38,0.73,-0.2,0.0,-0.57,-0.44,-0.12,-0.34,-0.99,0.1,-0.15,0.63,0.32,-0.2,-0.04,-0.59,-0.45,-0.1,0.11,-0.7,0.27,0.05,0.39,0.4,-0.5,0.04,-0.59,-0.53,-0.14,-0.12,-0.54,0.24,0.03,0.45,0.05,-0.41,0.02,-0.66,-0.27,-0.18,-0.22,-0.5,0.07,0.21,0.6,0.21,0.33,-0.12,-0.6,-0.45,-0.11,-0.3,-0.03,0.18,0.35,0.75,0.16,0.18,-0.3,-0.53,-0.3,-0.06,-0.18,-0.35,0.04,0.33,0.49,0.15,-0.04,-0.39,-0.57,-0.55,-0.35,-0.47,-0.13,0.03,0.32,0.58,-0.07,0.28,-0.3,-0.59,-0.39,-0.07,-0.41,0.01,0.14,0.23,0.65,-0.09,0.16,-0.08,-0.48,0.13,0.17,-0.21,0.73,0.33:RUNNING
0.71,0.8,1.08,1.7,0.66,-0.25,-0.85,-0.83,-0.16,1.08,0.71,0.64,0.72,0.96,1.67,0.71,-0.32,-0.94,-0.86,-0.08,1.0,0.7,0.6,0.82,1.0,1.8,0.91,-0.29,-0.98,-1.02,-0.25,1.1,0.84,0.68,0.82,1.12,1.84,0.67,-0.39,-0.98,-0.9,-0.18,0.99,0.79,0.72,0.85,1.19,1.77,0.64,-0.33,-0.88,-1.02,-0.57,0.92,0.79,0.69,0.88,1.13,1.69,1.1,-0.2,-1.02,-1.02,-0.44,0.94,0.85,0.78,0.87,1.07,1.52,1.02,-0.15,-0.86,-1.04,-0.39,1.02,0.66,0.49,0.82,1.13,1.52,1.18,-0.01,-0.78,-1.1,-0.73,0.78,0.93,0.74,0.89,1.1,1.6,1.11,-0.09,-0.73,-1.04,-0.75,0.53,0.94,0.57,0.78,1.16,1.64,1.35,0.03,-0.81,-1.17,-0.75,0.57,1.1,0.58,0.69,0.98,1.19,1.73,0.38,-0.53,-1.07,-0.93,0.12,1.21,0.78,0.74,0.9,1.22,1.65,0.6,-0.47,-1.05,-1.05,-0.22,1.13,0.74,0.66,0.98,1.18,1.85,0.98,-0.19,-1.0,-1.08,-0.48,1.02,0.91,0.65,0.9,1.21,1.96,1.32,-0.24,-1.07,-1.17,-0.64,1.0,1.17,0.77,0.85,1.11,1.8,1.22,0.02,-0.87,-1.07,-0.7,0.5,0.89,0.47,0.74,0.98,1.41,1.69,0.39,-0.65,-1.05,-0.66,0.21,1.0,0.59,0.63,0.89,1.02,1.74,0.92,-0.12,-0.68,-0.64,-0.31,0.79,0.83,0.48,0.76,0.81,0.69,1.52,1.91,1.29,0.84,0.78,0.96,1.5,1.61,1.13,0.87,0.72,0.64,0.78:0.32,0.32,0.31,0.31,0.31,0.31,0.33,0.33,0.33,0.34,0.38,0.47,0.5,0.52,0.61,0.59,0.62,0.75,0.88,0.74,0.4,0.26,0.97,1.34,0.95,0.55,0.29,0.84,2.83,1.91,0.87,0.09,-0.37,-0.43,1.62,2.68,1.21,0.25,0.2,2.51,3.06,1.3,0.02,-0.63,-0.49,2.08,2.59,1.16,0.26,0.1,2.36,3.14,1.33,0.17,-0.46,-0.42,1.94,2.66,1.21,0.24,0.1,2.52,2.69,1.14,0.12,-0.52,-0.47,2.36,2.37,1.04,0.23,0.19,2.66,2.75,1.17,0.05,-0.47,-0.33,2.34,2.28,1.12,0.28,0.23,2.53,2.79,1.17,-0.05,-0.5,-0.28,2.34,2.36,1.16,0.27,0.27,2.52,2.79,1.44,0.1,-0.6,-0.49,2.02,2.64,1.21,0.4,0.45,2.6,2.99,1.3,-0.06,-0.62,-0.44,2.5,2.43,1.19,0.35,0.36,2.63,2.79,1.23,0.03,-0.57,-0.31,2.28,2.44,1.28,0.27,0.17,2.36,3.21,1.49,0.24,-0.5,-0.44,1.5,2.96,1.64,0.7,0.32,1.97,3.19,1.55,0.2,-0.48,-0.44,1.52,2.97,1.64,0.64,0.22,1.95,3.19,1.47,0.43,-0.44,-0.59,1.12,3.14,1.85,0.71,0.18,1.4,3.5,1.8,0.38,-0.54,-0.58,1.08,3.32,1.79,0.66,0.14,0.99,3.46,2.0,0.64,-0.37,-0.61,0.75,3.26,1.98,0.81,0.22,0.87,3.42,2.19,0.77,-0.22,-0.62,-0.01,3.07,2.27,0.91,0.2,0.74,3.19,2.58,1.0,-0.07,-0.52,-0.18,2.36,2.64,1.19,0.35,0.25,2.7:0.01,0.54,0.22,0.07,0.17,0.09,0.67,0.27,0.11,-0.25,-0.22,0.2,0.75,0.51,0.13,0.19,0.07,0.58,0.09,-0.09,-0.37,-0.25,0.07,0.7,0.48,0.19,0.19,0.15,0.53,-0.01,-0.24,-0.46,-0.45,-0.2,0.57,0.36,0.07,0.16,0.08,0.43,-0.11,-0.18,-0.37,-0.32,0.02,0.65,0.44,0.18,0.18,0.11,0.45,0.05,-0.22,-0.4,-0.29,-0.12,0.52,0.41,0.24,0.32,0.09,0.51,0.09,-0.19,-0.36,-0.28,-0.07,0.35,0.24,0.1,0.29,0.13,0.54,-0.06,-0.15,-0.24,-0.15,0.22,0.65,0.41,0.13,0.07,0.04,0.48,0.06,-0.33,-0.43,-0.37,0.22,0.88,0.59,0.28,0.18,0.16,0.58,0.27,-0.13,-0.23,-0.37,-0.07,0.62,0.5,0.2,0.27,0.08,0.6,0.27,0.04,-0.39,-0.37,-0.17,0.5,0.45,0.25,0.26,0.21,0.65,0.26,0.01,-0.33,-0.27,0.04,0.55,0.47,0.2,0.22,0.19,0.49,0.42,0.07,-0.22,-0.23,0.13,0.68,0.67,0.31,0.23,0.24,0.5,0.37,0.1,-0.26,-0.32,-0.03,0.61,0.64,0.31,0.17,0.24,0.36,0.39,0.0,-0.28,-0.42,-0.13,0.52,0.61,0.28,0.16,0.22,0.05,0.35,0.03,-0.19,-0.24,-0.15,0.19,0.64,0.38,0.16,0.2,-0.01,0.56,0.17,-0.01,-0.23,-0.28,0.33,0.86,0.53,0.21,0.2,-0.01,0.79,0.48,0.11,-0.11,-0.08,0.37,0.7,0.55,0.22,0.09,0.07,0.65,0.38,0.13,-0.16,-0.28,0.16,0.62,0.65,0.29,0.13,0.1,0.58:RUNNING
0.31,0.14,-2.79,-3.59,-3.3,-1.97,-1.42,-2.13,-3.59,-2.54,-0.57,0.7,0.58,-1.73,-3.48,-2.73,-1.96,-1.49,-1.11,-3.17,-2.66,-0.71,0.98,1.06,-0.78,-3.0,-2.35,-1.92,-1.4,-1.34,-2.98,-2.16,-0.4,1.22,1.24,-1.58,-2.77,-2.1,-1.65,-1.19,-1.07,-2.84,-1.73,-0.28,0.94,0.7,-1.61,-2.94,-2.01,-1.65,-1.3,-1.46,-3.03,-1.79,-0.14,1.01,0.63,-2.04,-2.99,-2.19,-1.71,-1.19,-1.17,-2.66,-1.78,-0.14,0.85,0.69,-1.79,-3.16,-2.23,-1.83,-1.44,-1.34,-3.13,-2.07,-0.46,0.88,0.68,-1.08,-3.02,-1.9,-1.46,-1.0,-1.87,-3.15,-1.8,-0.48,0.68,0.58,-1.58,-3.0,-2.01,-1.57,-1.19,-1.1,-2.74,-1.86,-0.62,0.82,0.76,-1.25,-3.4,-2.55,-2.01,-1.53,-1.37,-2.79,-2.0,-0.56,0.75,0.44,-1.48,-3.29,-2.34,-1.73,-1.26,-1.26,-3.02,-1.66,-0.44,0.85,0.71,-1.57,-3.31,-2.42,-1.79,-1.26,-1.42,-3.03,-2.01,-0.1,0.79,0.42,-2.53,-3.15,-2.19,-1.58,-1.21,-2.22,-2.76,-1.71,-0.04,0.86,0.38,-2.45,-2.93,-1.96,-1.27,-1.01,-1.52,-2.58,-1.73,0.11,0.8,-0.25,-2.98,-2.71,-1.7,-1.36,-1.01,-1.66,-2.18,-1.34,0.05,0.59,-0.14,-2.69,-2.71,-1.72,-1.23,-0.91,-1.57,-2.48,-1.35,-0.08,0.66,0.06,-2.59,-2.91,-1.82,-1.46,-1.18,-1.22,-2.77,-1.73,-0.4,0.7,0.49,-0.94,-2.91,-2.26,-1.57,-1.18,-0.96,-2.44,-2.43,-1.36,-0.04,0.66,0.03,-2.09,-2.91,-1.87,-1.26,-0.93:-1.62,-2.77,-1.98,-0.94,0.39,1.22,0.35,-2.91,-1.18,-1.48,-1.76,-1.37,-3.41,-1.52,-0.59,0.69,0.93,0.08,-2.94,-1.26,-1.1,-1.8,-1.45,-3.14,-1.47,-0.6,0.65,0.98,-0.13,-2.9,-1.27,-1.29,-1.7,-1.57,-3.3,-1.72,-0.81,0.73,1.01,0.08,-2.79,-1.24,-1.39,-1.54,-1.32,-3.26,-1.49,-0.69,0.56,1.16,0.21,-2.68,-1.16,-0.94,-1.5,-1.53,-2.84,-1.83,-0.96,0.6,0.91,0.38,-2.45,-1.38,-1.36,-1.63,-1.75,-3.26,-1.66,-0.72,0.53,0.9,0.15,-2.78,-1.19,-0.98,-1.63,-1.66,-3.05,-2.07,-0.87,0.32,1.39,0.2,-2.61,-1.19,-1.16,-1.91,-1.82,-3.08,-1.78,-0.75,0.72,1.14,0.24,-2.7,-1.26,-1.0,-1.71,-1.85,-3.17,-1.83,-0.62,0.75,0.9,0.09,-2.71,-1.39,-1.66,-1.79,-1.97,-3.52,-1.11,-0.27,1.17,0.75,-0.09,-1.89,-1.05,-1.07,-1.7,-1.38,-3.05,-0.91,-0.22,0.88,0.86,-0.26,-2.42,-1.54,-1.26,-1.54,-1.83,-2.71,-0.83,-0.18,0.93,0.84,-0.62,-2.38,-1.14,-1.14,-1.85,-1.64,-3.15,-0.89,-0.28,1.05,0.74,-0.23,-2.47,-1.11,-0.99,-1.7,-1.58,-3.25,-1.1,-0.45,0.76,0.9,0.05,-2.75,-1.55,-1.0,-1.3,-1.51,-2.29,-2.18,-0.84,-0.12,1.12,0.73,-1.18,-1.8,-1.06,-1.0,-1.66,-1.46,-2.82,-1.18,-0.48,0.4,1.01,0.55,-1.66,-1.45,-0.85,-1.17,-1.35,-1.0,-2.29,-0.92,-0.41,0.18,1.1,0.7,-1.3,-1.69,-0.67,-0.6,-0.67,-0.48,-0.9,0.05,0.05,0.08:-0.39,-0.39,-0.39,-0.4,-0.39,-0.39,-0.39,-0.39,-0.39,-0.4,-0.4,-0.39,-0.4,-0.39,-0.39,-0.39,-0.4,-0.4,-0.4,-0.39,-0.39,-0.41,-0.49,-0.56,-0.33,-0.13,-0.06,-0.06,-0.08,0.01,0.02,-0.05,-0.1,-0.13,-0.22,-0.16,0.03,0.64,1.02,1.39,1.2,0.76,1.25,2.47,1.48,-0.01,-0.91,-0.89,0.07,0.16,1.07,1.0,0.95,0.95,1.14,0.41,-0.25,-0.41,-0.71,-0.07,-0.87,0.07,0.01,0.39,0.66,-0.17,-0.11,-0.62,-0.45,-0.31,0.28,-0.92,-0.31,-0.11,0.26,0.3,-0.21,-0.21,-0.6,-0.24,0.2,0.58,-0.36,0.26,0.0,0.36,0.12,-0.22,0.11,-0.67,-0.37,0.2,0.39,-0.7,-0.07,-0.01,0.27,0.14,-0.21,0.08,-0.58,-0.24,0.07,0.31,-0.82,-0.3,-0.14,0.28,0.13,-0.24,-0.03,-0.57,-0.2,-0.01,0.18,-0.58,-0.14,-0.05,0.31,0.25,-0.12,-0.02,-0.67,-0.26,0.26,0.38,-0.8,-0.44,-0.23,0.1,0.06,0.25,0.04,-0.35,-0.32,-0.16,0.02,-0.65,-0.25,-0.1,0.34,0.21,-0.2,0.18,-0.63,-0.42,0.28,0.23,-0.72,-0.33,-0.19,0.18,0.28,-0.57,0.05,-0.54,-0.25,0.21,0.11,-0.66,-0.15,-0.13,0.28,0.03,-0.28,0.24,-0.52,-0.5,0.1,0.32,-0.67,-0.06,0.06,0.33,0.26,-0.07,0.23,-0.54,-0.36,-0.32,0.07,-0.42,0.05,0.18,0.4,0.08,0.07,0.11,-0.68,-0.32,0.25,0.28,-0.07,0.28,0.3,0.62,0.43,-0.11,0.06,-0.31,0.3,0.28,-0.01,-0.21,-0.3,0.09:RUNNING
-1.2,-1.2,-1.16,-0.94,-0.8,-0.81,-1.23,-1.36,-1.23,-0.96,-1.17,-1.76,-2.48,-2.03,-1.4,-1.17,-1.11,-1.25,-0.81,0.18,0.52,0.61,-0.26,-1.71,-1.39,-0.99,-0.9,-1.13,-2.32,-2.22,-0.43,0.78,1.08,0.42,-1.91,-2.0,-1.44,-1.13,-1.13,-1.53,-2.9,-1.26,0.32,1.09,0.8,-0.39,-1.73,-1.25,-1.17,-1.39,-1.63,-3.2,-1.84,0.09,0.98,0.93,0.0,-1.79,-1.42,-1.26,-1.35,-1.44,-2.77,-2.13,-0.12,0.92,1.13,0.32,-1.63,-1.39,-1.19,-1.46,-1.63,-2.9,-1.91,-0.2,0.86,0.97,0.31,-1.71,-1.39,-1.08,-1.38,-1.51,-2.69,-1.88,-0.16,0.75,1.16,0.4,-1.79,-1.48,-1.45,-1.46,-1.44,-2.5,-2.26,-0.24,0.97,1.19,0.45,-1.55,-1.62,-1.38,-1.46,-1.59,-2.58,-2.23,-0.35,0.84,1.38,0.68,-1.65,-1.76,-1.44,-1.32,-1.34,-2.35,-2.35,-0.51,0.62,1.08,0.54,-1.6,-1.67,-1.61,-1.48,-1.45,-2.16,-2.77,-0.78,0.56,1.06,0.57,-0.61,-1.52,-1.18,-1.35,-1.54,-1.99,-2.05,-0.53,0.6,1.18,0.87,-0.68,-1.73,-1.5,-1.2,-1.22,-1.48,-2.82,-1.17,0.38,1.05,0.87,-0.35,-1.63,-1.21,-1.07,-1.23,-1.3,-2.57,-1.42,0.05,0.75,0.83,0.38,-1.5,-1.32,-1.26,-1.28,-1.24,-2.26,-2.02,-0.25,0.64,1.0,0.58,-0.74,-1.26,-1.18,-1.26,-1.32,-1.69,-2.39,-0.96,0.08,0.68,0.78,0.33,-1.52,-1.26,-1.3,-1.23,-1.28,-2.03,-1.88,-0.57,0.27,0.87,0.79,-0.19,-1.58,-1.46,-1.42:-0.16,-0.16,-0.17,-0.18,-0.18,-0.19,-0.18,-0.18,-0.19,-0.17,-0.17,-0.17,-0.16,-0.15,-0.18,-0.2,-0.23,-0.24,-0.23,-0.23,-0.24,-0.24,-0.24,-0.25,-0.29,-0.26,0.16,0.32,0.24,0.31,0.09,-0.13,-1.02,-1.79,-1.47,-1.32,-1.13,-1.16,-0.85,-0.16,0.24,0.43,0.15,-0.51,-1.32,-0.97,-0.73,-0.7,-2.09,-2.73,-1.25,0.28,0.68,0.63,-0.8,-1.87,-1.4,-1.01,-0.89,-1.66,-3.36,-1.86,0.08,0.88,0.82,0.26,-2.59,-1.76,-1.04,-0.76,-1.05,-2.98,-2.41,-0.82,0.84,1.05,0.7,-2.25,-2.14,-1.29,-0.82,-1.02,-2.48,-2.93,-1.19,0.49,0.85,0.77,-1.62,-2.25,-1.47,-0.82,-0.95,-2.29,-3.04,-1.13,0.75,1.11,0.74,-2.07,-2.0,-1.37,-0.82,-0.96,-1.97,-3.16,-1.27,0.75,0.98,0.72,-1.7,-2.13,-1.33,-0.81,-0.98,-2.01,-3.15,-1.49,0.52,1.06,0.89,-1.13,-2.33,-1.4,-0.74,-1.32,-2.11,-3.42,-1.41,0.58,0.92,0.78,-1.08,-2.35,-1.54,-0.94,-1.19,-2.05,-3.31,-1.47,0.55,1.05,0.78,-0.95,-2.47,-1.42,-0.75,-0.99,-1.82,-3.49,-1.83,0.42,0.99,0.89,-0.18,-2.68,-1.8,-0.97,-0.96,-1.76,-3.15,-2.08,-0.04,0.56,0.81,-0.44,-2.54,-1.51,-0.84,-0.91,-1.37,-3.36,-2.19,-0.25,0.73,0.75,0.42,-2.65,-1.82,-0.97,-0.58,-1.22,-3.18,-2.34,-0.44,0.68,0.77,0.43,-2.46,-1.95,-1.04,-0.59,-0.81,-2.22,-2.98,-1.35,0.47,0.87,0.73,-1.39,-2.51,-1.39,-0.52,-0.88,-1.28,-3.29:0.13,0.13,0.13,0.12,0.13,0.13,0.12,0.11,0.11,0.09,0.12,0.11,0.11,0.09,0.08,0.07,0.09,0.09,0.08,0.05,0.02,0.04,-0.08,-0.22,-0.5,-0.21,0.26,0.51,0.52,0.56,0.33,-0.02,-0.06,0.11,0.45,0.74,1.05,0.74,0.46,0.41,0.09,0.09,-0.55,-0.37,-0.52,-0.56,-0.55,0.47,0.34,0.13,-0.15,0.21,0.69,0.89,0.16,-0.37,-0.52,-0.4,0.84,0.95,0.53,0.04,-0.06,0.26,0.93,0.45,-0.35,-0.63,-0.51,-0.06,1.02,0.56,0.34,-0.02,0.39,1.11,0.79,-0.22,-0.58,-0.55,-0.04,1.28,0.89,0.43,0.02,0.15,0.92,1.02,0.03,-0.41,-0.56,-0.2,1.11,0.89,0.43,0.13,0.35,1.11,0.87,-0.09,-0.56,-0.68,-0.32,1.23,0.96,0.5,0.14,0.21,1.02,0.86,-0.11,-0.65,-0.79,-0.34,1.34,0.96,0.42,0.04,0.16,0.92,1.06,-0.06,-0.56,-0.7,-0.26,1.46,1.23,0.32,-0.07,0.04,0.84,1.18,0.29,-0.24,-0.52,-0.22,1.51,1.02,0.47,0.22,0.32,0.99,1.22,-0.1,-0.78,-0.79,-0.3,1.21,1.26,0.8,0.29,0.04,0.48,1.07,0.18,-0.58,-0.87,-0.67,0.31,1.0,0.63,0.03,-0.11,0.25,0.74,0.02,-0.49,-0.53,-0.29,0.61,1.27,0.7,0.16,-0.15,0.13,0.94,0.34,-0.42,-0.58,-0.58,0.12,1.06,0.64,0.23,0.09,0.2,0.92,0.48,-0.36,-0.68,-0.62,-0.18,1.34,1.02,0.48,0.1,0.07,0.66,0.86,-0.16,-0.59,-0.75,-0.41,0.43,1.01,0.59:RUNNING
-3.59,-3.26,-1.86,0.2,0.7,-0.79,-3.46,-3.55,-2.5,-1.92,-1.78,-3.59,-3.05,-1.59,0.43,0.75,-1.4,-3.59,-2.78,-1.98,-1.71,-2.42,-3.59,-2.52,-0.83,0.98,0.5,-1.9,-3.47,-2.48,-1.77,-1.62,-2.89,-3.59,-2.35,-0.21,0.93,0.06,-2.78,-3.25,-2.24,-1.85,-1.65,-3.39,-3.29,-1.84,0.12,1.0,-0.33,-3.14,-2.75,-1.98,-1.69,-1.48,-3.3,-3.13,-1.73,0.17,0.7,-0.52,-3.26,-2.74,-1.87,-1.75,-1.46,-3.06,-2.63,-1.39,0.38,0.76,-1.05,-3.46,-2.67,-1.97,-1.57,-1.44,-3.31,-2.64,-1.45,0.19,0.62,-1.01,-3.32,-2.63,-1.89,-1.66,-1.48,-3.35,-2.49,-1.22,0.62,0.86,-0.83,-3.31,-2.21,-1.52,-1.49,-1.61,-3.18,-2.09,-0.67,0.81,0.76,-0.87,-3.29,-2.54,-1.85,-1.47,-1.17,-2.66,-2.2,-0.82,0.82,0.82,-1.35,-3.05,-2.24,-1.62,-1.38,-1.6,-3.27,-2.41,-0.92,0.72,0.45,-1.79,-3.14,-2.33,-1.66,-1.34,-1.69,-3.35,-2.4,-0.78,0.77,0.35,-1.8,-3.21,-2.22,-1.48,-1.21,-1.71,-3.06,-2.15,-0.67,0.81,0.54,-2.0,-3.0,-2.11,-1.52,-1.36,-1.73,-3.2,-1.94,-0.38,0.86,0.06,-2.58,-2.98,-2.0,-1.57,-1.3,-2.41,-3.02,-1.94,-0.22,1.05,0.11,-2.46,-2.71,-1.72,-1.39,-1.24,-2.42,-3.03,-1.84,-0.46,0.92,0.7,-1.8,-3.17,-2.03,-1.52,-1.29,-1.17,-2.98,-2.09,-1.04,0.47,0.96,-0.7,-3.14,-2.25,-1.48,-1.23,-0.99,-2.19,-2.79,-1.7,-0.36,0.84,0.46,-1.89,-2.98,-1.92:-0.17,-0.17,-0.16,-0.17,-0.17,-0.18,-0.2,-0.19,-0.17,-0.12,-0.04,-0.01,-0.02,-0.06,-0.07,-0.2,-0.43,-0.64,-1.28,-1.42,-1.52,-1.26,0.23,1.0,1.64,1.01,-0.85,-1.25,-2.16,-2.55,-2.17,-3.17,-0.82,-0.11,1.62,1.65,1.08,-2.38,-0.87,-1.58,-2.16,-1.99,-3.01,-0.73,0.12,1.58,1.28,-1.1,-0.97,-1.19,-1.82,-2.07,-2.3,-2.48,-0.72,0.61,1.99,1.17,-1.49,-1.63,-1.54,-1.74,-2.39,-2.94,-1.4,-0.53,1.22,1.44,0.95,-2.02,-0.75,-1.3,-1.91,-1.87,-3.08,-1.14,-0.35,1.36,1.36,0.17,-1.23,-0.91,-1.51,-2.15,-1.76,-3.03,-0.73,0.13,1.66,1.17,-0.87,-1.59,-1.48,-1.41,-1.89,-1.75,-2.52,-0.75,0.43,1.61,0.84,-1.39,-1.18,-1.39,-1.58,-1.79,-1.9,-2.35,-0.82,-0.09,1.48,0.7,-1.64,-1.24,-1.14,-1.62,-1.83,-2.3,-1.83,-0.57,0.71,1.45,0.69,-1.61,-1.09,-1.09,-1.53,-1.97,-2.44,-2.08,-0.82,0.17,1.45,0.75,-2.23,-1.35,-1.29,-1.46,-1.71,-2.24,-1.88,-0.59,0.51,1.07,0.14,-2.24,-1.44,-1.3,-1.5,-1.52,-2.6,-1.76,-0.82,0.39,1.28,0.52,-2.25,-1.54,-1.18,-1.21,-1.67,-3.0,-1.53,-0.72,0.72,1.16,0.38,-2.43,-1.06,-1.05,-1.7,-1.79,-3.17,-1.26,-0.76,1.02,1.25,0.58,-1.97,-0.71,-1.46,-1.83,-1.5,-3.0,-0.95,-0.37,1.01,0.94,0.15,-2.07,-0.85,-1.19,-1.51,-1.36,-3.21,-1.11,-0.48,0.92,1.12,0.14,-2.18,-1.13,-0.97,-1.79,-1.66,-3.3:0.06,0.15,-0.26,-0.23,0.15,0.22,-0.2,0.03,0.03,0.2,0.54,-0.21,-0.11,-0.55,-0.53,0.39,0.55,-0.41,0.21,-0.18,0.14,0.0,-0.31,0.9,-0.19,-0.38,0.14,0.38,-0.07,-0.09,0.07,0.18,0.4,-0.03,-0.37,-0.59,-0.43,0.21,0.45,-0.63,-0.21,-0.29,0.31,0.18,-0.47,0.26,-0.56,-0.34,0.18,0.09,-0.37,-0.05,0.09,0.07,0.15,-0.19,-0.63,-0.63,-0.25,0.18,0.21,-0.22,-0.14,0.02,0.28,0.07,-0.17,0.47,-0.52,-0.44,0.17,0.03,-0.52,-0.11,-0.04,0.44,0.12,-0.18,0.66,-0.67,0.0,0.52,-0.06,-0.25,0.13,0.12,0.43,0.24,-0.08,0.21,-0.64,-0.15,0.39,0.06,-0.31,0.04,0.07,0.52,0.26,-0.47,0.35,-0.43,-0.44,0.44,-0.04,-0.26,-0.05,0.15,0.52,0.13,-0.26,-0.17,-0.63,0.01,0.54,-0.19,-0.23,-0.23,0.04,0.21,0.04,-0.34,-0.07,-0.54,0.05,0.33,0.58,-0.23,-0.23,-0.08,0.35,0.51,-0.14,0.24,-0.64,-0.62,0.07,0.59,-0.24,-0.34,-0.32,0.04,0.24,-0.17,-0.36,-0.3,-0.6,-0.27,0.29,0.58,-0.45,-0.4,-0.34,0.15,0.46,-0.2,-0.37,-0.52,-0.73,-0.5,-0.01,0.38,-0.2,-0.38,0.18,0.29,0.35,0.23,0.19,0.0,-0.21,-0.29,-0.26,-0.34,-0.48,-0.05,0.2,0.15,0.11,0.15,0.24,0.29,0.26,0.22,-0.13,-0.26,-0.25,-0.21,-0.28,-0.16,-0.09,-0.1,-0.07,-0.05,-0.05,-0.09,-0.11,-0.13,-0.12,-0.09,-0.07,-0.06,-0.06,-0.08,-0.13,-0.15:RUNNING
-0.97,-0.98,-0.98,-0.97,-0.97,-0.98,-0.99,-0.99,-0.98,-0.99,-0.99,-0.97,-0.98,-0.98,-0.96,-0.99,-0.97,-0.97,-0.97,-0.97,-0.98,-1.0,-0.98,-0.96,-0.99,-0.99,-0.97,-0.92,-1.13,-0.89,-0.81,-0.63,-0.74,-0.7,-0.73,-0.95,-0.92,-0.8,-1.0,-1.14,-1.28,-2.14,-2.14,-0.16,0.92,0.58,-0.5,-1.92,-1.85,-1.58,-1.47,-1.44,-2.25,-2.05,-0.23,0.75,1.04,0.26,-1.58,-1.82,-1.42,-1.33,-1.42,-1.91,-2.75,-0.98,0.5,1.1,0.79,-0.4,-1.69,-1.39,-1.23,-1.26,-1.36,-2.99,-1.55,0.23,1.07,1.13,0.25,-1.52,-1.32,-1.47,-1.69,-1.8,-3.08,-1.73,0.16,1.08,1.19,0.18,-1.58,-1.46,-1.46,-1.62,-1.75,-3.13,-1.88,0.08,1.12,1.13,0.07,-1.79,-1.61,-1.51,-1.73,-1.9,-3.21,-1.66,0.08,1.05,1.14,0.38,-1.48,-1.4,-1.28,-1.51,-1.77,-3.14,-1.48,0.36,1.17,0.99,-0.26,-1.65,-1.36,-1.37,-1.5,-1.66,-3.07,-1.34,0.36,1.11,0.99,0.15,-1.64,-1.45,-1.26,-1.37,-1.83,-2.89,-1.21,0.37,1.13,0.99,-0.06,-1.49,-1.33,-1.25,-1.37,-1.76,-2.99,-1.08,0.6,1.34,1.01,-0.32,-1.6,-1.41,-1.32,-1.5,-1.86,-2.5,-0.74,0.55,1.1,0.93,0.02,-1.47,-1.33,-1.26,-1.36,-1.85,-2.37,-0.69,0.61,1.16,0.91,-0.84,-1.69,-1.29,-1.02,-1.2,-1.71,-2.04,-0.51,0.58,1.08,0.83,-0.43,-1.61,-1.38,-1.2,-1.26,-1.58,-1.98,-0.88,0.17,1.24,1.14,0.28,-1.69,-1.78,-1.73,-1.52:0.85,0.81,-0.16,-2.56,-1.75,-1.08,-0.84,-1.36,-3.39,-2.7,-0.56,0.69,0.75,0.54,-2.52,-1.96,-0.92,-0.48,-1.01,-2.8,-3.07,-1.2,0.78,1.06,0.7,-2.42,-2.24,-1.23,-0.68,-1.07,-2.99,-3.19,-1.1,0.7,0.94,0.74,-2.28,-2.29,-1.29,-0.61,-1.0,-2.92,-3.15,-0.95,0.9,1.01,0.68,-2.68,-2.16,-1.1,-0.59,-0.87,-2.66,-2.98,-0.85,0.96,0.93,0.46,-2.59,-1.96,-1.0,-0.71,-1.28,-3.22,-2.65,-0.6,0.92,0.99,0.46,-2.73,-2.08,-0.82,-0.66,-1.14,-3.0,-2.77,-0.56,0.97,1.09,0.21,-2.78,-1.92,-0.99,-0.79,-1.25,-3.19,-2.57,-0.27,0.89,0.86,0.23,-2.81,-1.8,-0.86,-0.82,-1.48,-3.45,-2.51,-0.25,1.0,0.74,-0.15,-2.85,-1.67,-0.71,-0.58,-1.24,-3.23,-2.59,-0.32,1.07,0.74,-0.17,-2.76,-1.71,-0.84,-0.59,-1.19,-3.29,-2.14,-0.05,0.81,0.59,-0.37,-2.53,-1.54,-0.93,-0.72,-0.85,-3.07,-2.33,-0.12,0.83,0.53,-0.19,-2.65,-1.63,-1.09,-1.02,-1.13,-2.53,-2.77,-1.28,0.6,0.91,0.39,-2.15,-2.27,-1.38,-0.73,-0.79,-1.06,-3.23,-2.17,-0.51,1.0,0.78,-0.3,-3.07,-1.79,-0.82,-0.68,-0.67,-1.55,-3.02,-1.98,-0.26,0.85,0.28,-0.41,-2.33,-2.21,-1.11,-0.77,-0.28,-0.97,-2.83,-1.7,-0.93,0.23,0.49,0.62,-0.92,-1.35,-0.32,-0.29,-0.63,-0.52,-0.55,0.05,-0.31,-0.19,0.25,0.25,0.01,-0.29,-0.57,-0.63,-0.69,-0.73,-0.6,-0.56,-0.45,-0.36,-0.42,-0.35:-0.43,-0.45,0.58,0.73,0.42,-0.03,0.06,0.38,0.91,0.45,-0.38,-0.77,-0.81,-0.14,0.98,0.78,0.45,0.14,0.23,0.77,0.56,-0.4,-0.55,-0.53,-0.18,1.13,0.82,0.47,0.08,0.52,1.09,0.76,-0.25,-0.62,-0.58,-0.14,1.16,0.89,0.59,0.16,0.37,1.01,0.77,-0.51,-0.74,-0.68,-0.26,1.1,0.88,0.51,0.1,0.5,0.95,0.68,-0.24,-0.49,-0.57,-0.18,1.2,0.81,0.4,0.21,0.44,1.06,0.56,-0.34,-0.63,-0.56,0.07,1.33,0.84,0.21,0.11,0.38,1.26,0.52,-0.31,-0.64,-0.55,0.01,1.3,0.87,0.3,0.07,0.38,1.13,0.27,-0.37,-0.68,-0.6,0.1,1.19,0.85,0.38,0.12,0.38,1.12,0.31,-0.46,-0.7,-0.55,0.31,1.19,0.75,0.17,-0.05,0.33,1.06,0.2,-0.38,-0.62,-0.53,0.14,1.2,0.75,0.32,0.09,0.41,1.07,0.28,-0.44,-0.71,-0.6,0.5,1.24,0.67,0.18,-0.09,0.36,1.14,0.14,-0.68,-0.77,-0.46,0.4,1.18,0.53,-0.06,-0.15,0.17,0.84,0.22,-0.48,-0.58,-0.34,0.23,1.53,0.78,-0.04,-0.26,-0.01,1.05,0.63,-0.31,-0.65,-0.48,-0.03,1.12,0.9,0.28,-0.14,-0.12,0.14,0.57,-0.15,-0.56,-0.59,-0.37,-0.12,0.91,0.14,-0.05,0.0,0.14,0.22,0.4,-0.12,-0.47,-0.79,-0.58,-0.41,0.41,0.07,-0.24,0.03,0.26,0.24,0.01,0.29,0.05,-0.46,-0.22,0.23,0.73,0.26,0.15,0.23,0.14,0.16,0.07,0.0,0.14,0.2,0.19,0.32,0.35:RUNNING
0.99,0.98,0.99,0.98,0.98,0.98,0.98,0.99,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.97,0.99,0.99,0.99,0.98,0.98,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.99,0.99,0.98,0.99,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,0.98,0.99,0.98,0.98,0.99,0.99,0.99,1.0,0.98,0.98,0.99,1.0,0.98,0.98,0.99,0.99,0.99,1.0,1.0,1.0,0.98,0.99,0.9,0.95,0.95,0.98,1.04,1.0,1.0,1.0,0.91,0.83,0.89,0.87,1.56,1.31,0.23,0.81,2.55,3.22,1.93,0.93,0.55,1.03,2.65,3.11,1.25,-0.21,-0.62,-0.21,1.9,2.97,1.77,0.83,0.62,1.07,2.76,1.83,0.21,-0.58,-0.85,-0.15,2.2,2.13,1.16,0.73,0.72,1.29,2.6,0.7,-0.51,-0.84,-0.7,0.64,2.12,1.49,0.9,0.78,1.17,2.71,1.65,-0.14,-0.91,-1.09,-0.37,1.76,2.17,1.37,0.85,0.87,2.1,2.02,0.22,-0.63,-0.99,-0.81,0.63,1.81,1.29,0.86,0.73,1.1,2.31,0.99,-0.09,-0.52,-0.83,-0.63,1.15,1.61,1.09,0.73,0.67,1.57,1.94,0.3,-0.51,-0.77,-0.85,-0.07,1.58,1.43,0.99,0.82,1.02,2.47,1.0,-0.18,-0.73,-0.96,-0.26,1.49,1.68,1.15,0.81,0.88,2.24,1.68,-0.02,-0.63,-0.81,-0.76,0.48,1.49,1.24,0.9,0.76,0.97,2.28:0.0,-0.05,-0.12,-0.15,-0.08,0.82,1.21,1.38,1.72,1.16,-0.02,-0.75,-1.16,-0.98,-0.17,1.59,1.62,1.33,0.85,0.99,2.55,2.06,-0.02,-0.95,-1.1,-0.68,1.51,2.11,1.5,0.85,0.45,1.53,2.89,1.03,-0.38,-0.73,-0.64,0.0,2.41,1.9,0.88,0.35,0.35,2.45,2.54,0.35,-0.63,-0.8,-0.56,1.74,2.48,1.55,0.75,0.31,1.77,3.08,1.36,-0.22,-0.85,-0.65,1.08,2.67,1.75,0.78,0.23,0.3,2.57,2.14,0.33,-0.54,-0.65,-0.27,2.37,2.27,1.13,0.5,0.03,1.18,2.89,1.35,-0.07,-0.56,-0.48,0.78,2.7,1.76,0.78,0.22,0.04,2.35,2.56,0.49,-0.6,-0.71,-0.36,2.27,2.22,0.98,0.38,0.02,1.84,2.98,1.13,-0.3,-0.78,-0.58,1.48,2.68,1.57,0.55,0.13,0.37,2.65,2.2,0.39,-0.66,-0.75,0.13,2.55,1.92,0.81,0.22,-0.02,1.58,2.92,1.21,-0.1,-0.66,-0.5,1.62,2.55,1.36,0.46,0.15,0.56,2.74,2.24,0.41,-0.61,-0.6,0.26,2.63,1.92,0.75,0.25,0.14,2.14,2.83,0.83,-0.43,-0.73,-0.63,2.07,2.4,1.23,0.25,-0.08,1.66,3.06,1.51,0.02,-0.6,-0.64,0.53,2.73,2.14,0.8,0.1,-0.09,2.06,2.95,0.88,-0.44,-0.68,-0.43,2.09,2.47,0.98,0.22,-0.1,0.68,2.76,2.2,0.37,-0.53,-0.73,-0.1,2.35,2.2,0.97,0.39,0.07,1.93,3.05,1.33,-0.21,-0.65,-0.54,0.98,2.7,1.76,0.62,0.26,0.44,2.57,2.71:0.16,0.28,-0.23,-0.64,-0.15,0.39,0.89,1.0,1.02,1.07,0.84,1.25,0.81,0.25,-0.11,-0.11,-0.01,0.29,0.75,0.83,0.73,0.48,0.34,0.65,0.3,0.06,-0.1,-0.2,-0.1,0.56,0.82,0.58,0.43,0.38,0.44,0.31,0.17,-0.05,-0.17,-0.15,0.01,0.36,0.63,0.56,0.43,0.53,0.54,0.26,-0.03,-0.12,-0.02,-0.11,0.36,0.77,0.61,0.52,0.42,0.4,0.02,-0.06,0.01,-0.08,0.08,-0.05,0.37,0.46,0.36,0.31,0.41,0.14,-0.03,0.02,0.06,0.06,0.18,0.37,0.57,0.41,0.31,0.26,0.36,0.16,0.03,-0.05,-0.05,0.06,-0.02,0.36,0.56,0.44,0.4,0.38,0.36,0.17,0.11,0.07,0.14,0.03,0.41,0.62,0.51,0.39,0.31,0.34,0.09,0.06,0.08,-0.04,0.02,0.38,0.53,0.45,0.35,0.25,0.38,0.24,0.16,0.06,-0.01,0.0,0.13,0.41,0.52,0.34,0.31,0.31,0.25,0.05,0.0,-0.15,-0.28,-0.07,0.21,0.47,0.43,0.38,0.32,0.49,0.33,0.2,0.0,0.03,0.06,0.18,0.31,0.54,0.6,0.49,0.52,-0.24,-0.2,-0.12,-0.11,0.16,0.08,0.21,0.47,0.31,0.31,0.38,0.49,-0.06,-0.13,-0.1,-0.08,0.05,0.0,0.23,0.63,0.55,0.49,0.38,0.16,-0.02,-0.08,-0.06,-0.05,0.02,0.08,0.48,0.51,0.41,0.3,0.24,0.02,0.08,0.19,0.06,0.16,0.26,0.49,0.47,0.38,0.35,0.33,0.28,0.31,0.13,0.16,0.08,0.09,0.16,0.44,0.51,0.42,0.36:RUNNING
-1.63,-1.22,-1.09,-0.99,-1.41,-3.16,-1.16,0.23,0.92,0.92,0.66,-1.76,-1.77,-1.36,-1.09,-1.04,-1.48,-3.11,-1.08,0.19,0.78,0.79,0.55,-1.09,-1.67,-1.35,-1.25,-1.06,-1.14,-2.82,-1.22,0.1,0.66,0.94,0.72,-0.56,-1.57,-1.3,-1.0,-0.86,-1.0,-2.51,-1.82,-0.04,0.68,0.94,0.82,-0.23,-1.4,-1.33,-1.13,-0.98,-1.04,-1.94,-1.73,-0.06,0.94,1.06,0.69,-0.46,-1.37,-1.39,-1.13,-0.84,-0.9,-1.84,-1.58,-0.1,0.69,1.13,0.84,-0.18,-1.64,-1.64,-1.34,-0.99,-0.94,-1.9,-1.73,-0.34,0.56,1.16,0.86,-0.38,-1.77,-1.53,-1.06,-0.89,-0.99,-1.85,-1.92,-0.11,0.53,1.0,0.85,0.1,-1.1,-1.23,-1.24,-1.12,-1.24,-2.39,-1.35,0.1,0.9,1.08,0.72,-0.89,-1.49,-1.21,-0.91,-0.8,-1.0,-2.75,-1.27,0.27,0.86,1.0,0.9,-1.18,-1.67,-1.26,-1.16,-0.94,-1.17,-2.52,-0.84,0.37,0.87,0.82,0.79,-1.02,-1.26,-0.98,-0.94,-0.96,-1.49,-2.22,-0.34,0.52,0.81,0.8,0.86,-1.0,-1.42,-1.44,-1.13,-0.92,-1.26,-2.26,-0.48,0.53,0.88,0.76,0.53,-1.38,-1.46,-1.13,-0.94,-0.92,-1.61,-1.85,-0.17,0.61,0.97,0.85,0.37,-0.85,-1.13,-1.3,-1.11,-1.06,-1.66,-1.58,-0.31,0.4,0.72,0.77,0.83,-0.95,-1.18,-0.88,-0.95,-0.88,-1.07,-2.22,-0.87,0.18,0.48,0.7,0.65,-0.06,-1.42,-1.22,-0.94,-0.82,-0.68,-0.83,-2.0,-1.61,-0.68,-0.05,0.27,-0.25,-2.51,-2.18:-2.72,-2.2,-0.89,-0.23,-0.21,-0.86,-3.24,-2.63,-0.56,0.55,0.69,0.35,-2.39,-2.71,-1.13,-0.11,0.05,-0.09,-2.85,-2.8,-0.9,0.24,0.71,0.56,-1.8,-2.99,-1.17,-0.16,-0.07,-0.16,-2.64,-3.15,-1.24,0.11,0.68,0.59,-1.25,-3.04,-1.63,-0.3,-0.03,-0.24,-2.71,-3.09,-1.12,0.15,0.66,0.5,-1.3,-3.03,-1.46,-0.11,0.07,-0.06,-2.5,-3.44,-1.32,0.27,0.85,0.62,-1.09,-2.97,-1.74,-0.17,0.01,-0.04,-2.5,-3.08,-1.26,0.22,0.85,0.66,-1.21,-3.04,-1.53,-0.29,0.0,-0.03,-2.3,-3.33,-1.41,0.32,0.76,0.46,-1.98,-3.26,-1.23,0.2,0.31,-0.11,-3.13,-2.76,-0.62,0.53,0.74,0.43,-2.37,-2.76,-0.74,0.0,0.13,-0.53,-3.44,-2.38,-0.43,0.69,0.68,0.34,-2.67,-2.68,-0.62,0.1,0.2,-0.4,-3.39,-2.0,-0.32,0.64,0.59,-0.25,-3.11,-1.78,-0.31,-0.1,0.04,-0.9,-3.55,-2.22,-0.35,0.77,0.54,-0.05,-3.06,-2.0,-0.44,-0.12,0.06,-1.63,-3.59,-1.96,0.05,0.74,0.62,-0.42,-3.17,-1.88,-0.43,0.07,0.01,-1.86,-3.59,-1.89,0.01,0.75,0.4,-1.01,-2.96,-1.91,-0.8,-0.14,-0.04,-1.13,-3.44,-2.09,-0.3,0.43,0.57,0.25,-2.68,-2.75,-1.07,-0.27,0.1,-0.05,-2.46,-3.0,-1.3,-0.08,0.34,0.62,0.19,-1.44,-2.27,-1.51,-0.5,-0.18,-0.65,-1.55,-1.25,-0.8,-0.05,0.36,0.21,-0.06,-0.66,-1.09,-1.18,-0.78,-0.6,-0.47,-0.39,-0.42,-0.47,-0.57,-0.48,-0.41:0.15,1.12,0.82,0.42,-0.03,-0.15,0.07,0.77,0.32,-0.14,-0.49,-0.59,0.07,0.58,0.66,0.36,-0.02,-0.19,-0.07,1.04,0.43,-0.07,-0.47,-0.5,-0.2,0.47,0.8,0.41,0.03,-0.2,-0.02,0.68,0.67,0.07,-0.43,-0.5,-0.16,0.58,0.85,0.51,0.2,0.06,0.03,0.42,0.65,0.01,-0.52,-0.48,-0.09,0.5,0.77,0.53,0.23,0.01,0.02,0.48,0.64,0.07,-0.58,-0.68,-0.27,0.54,1.02,0.56,0.24,-0.1,-0.06,0.62,0.61,0.11,-0.48,-0.59,-0.33,0.38,1.0,0.47,0.09,-0.14,-0.02,0.33,0.83,0.16,-0.41,-0.58,-0.35,0.56,1.0,0.51,0.22,-0.1,0.09,0.78,0.79,0.17,-0.58,-0.59,-0.07,0.94,0.94,0.43,0.07,-0.09,-0.02,1.17,0.54,0.05,-0.65,-0.59,0.16,1.07,0.86,0.33,0.16,-0.1,0.07,1.14,0.33,0.13,-0.53,-0.49,0.15,1.19,0.8,0.25,0.02,-0.02,0.21,0.98,0.29,-0.21,-0.7,-0.48,0.04,1.06,0.62,0.23,-0.04,-0.11,0.22,0.99,0.24,-0.17,-0.67,-0.39,0.16,1.07,0.59,0.24,-0.17,-0.11,0.37,0.48,0.17,-0.22,-0.53,-0.36,0.3,1.0,0.5,0.22,-0.15,-0.04,0.44,0.82,0.4,0.03,-0.37,-0.42,0.43,1.07,0.74,0.27,-0.04,-0.04,-0.01,0.63,0.19,-0.11,-0.39,-0.42,-0.18,0.32,0.65,0.28,0.04,-0.17,-0.07,0.0,0.5,0.87,0.44,0.18,-0.05,0.06,1.13,0.41,0.2,0.02,-0.16,-0.12,0.16,0.64,0.66,0.61,0.43,0.42:RUNNING
1.71,1.39,2.01,3.59,1.58,-0.36,-1.62,-1.46,0.55,3.04,2.79,1.87,1.76,1.66,3.01,2.72,0.48,-0.89,-1.73,-1.27,0.96,2.44,2.03,1.76,1.54,1.7,3.57,1.52,-0.43,-1.51,-1.52,-0.45,2.21,2.37,1.85,1.53,1.51,2.72,2.12,0.21,-1.06,-1.5,-0.96,1.59,2.12,1.67,1.48,1.37,1.65,3.23,0.95,-0.38,-1.32,-1.35,-0.59,1.94,1.91,1.49,1.33,1.49,2.85,1.86,0.03,-0.89,-1.51,-1.33,0.5,1.75,1.6,1.6,1.57,2.23,2.65,0.53,-0.58,-1.39,-1.52,-0.28,1.83,1.73,1.25,1.25,1.39,3.1,1.39,-0.26,-1.21,-1.49,-0.82,1.46,1.79,1.58,1.22,1.16,1.79,2.73,0.54,-0.71,-1.53,-1.11,0.43,1.67,1.61,1.47,1.32,1.38,3.07,1.13,-0.32,-1.26,-1.47,-0.47,1.49,1.73,1.33,1.4,1.35,2.29,2.28,0.25,-0.86,-1.53,-1.11,0.65,2.0,1.79,1.51,1.25,1.26,2.91,1.24,-0.23,-0.97,-1.23,-0.93,1.34,2.0,1.33,1.13,1.19,1.89,2.89,0.67,-0.5,-1.41,-1.24,0.51,2.69,2.01,1.47,1.22,1.13,2.77,1.62,-0.09,-0.82,-1.05,-0.84,1.11,1.95,1.44,1.37,1.22,1.4,3.16,1.14,-0.16,-0.5,-0.98,-0.81,0.66,2.16,1.52,0.99,0.89,0.82,1.34,3.16,1.4,0.41,-0.32,-0.69,-0.9,0.23,2.99,2.0,1.09,0.65,0.35,0.47,0.78,0.5,0.25,0.2,0.24,0.04,-0.05,-0.01,-0.07,-0.11,-0.08,-0.16,-0.2,-0.22,-0.27,-0.28:-0.45,0.08,3.01,2.89,0.66,-0.04,0.75,2.78,3.59,1.52,-0.31,-0.82,-0.26,0.95,3.59,1.82,0.22,-0.1,0.67,3.32,3.27,0.76,-0.56,-0.59,-0.06,2.52,3.14,0.91,-0.03,0.02,2.0,3.59,1.7,-0.17,-0.77,-0.36,1.04,3.43,1.47,-0.05,-0.23,1.23,3.59,2.29,0.2,-0.78,-0.59,-0.22,3.11,2.54,0.53,-0.24,-0.24,2.08,3.59,1.46,-0.21,-0.81,-0.42,1.54,3.48,1.21,-0.13,-0.36,0.66,3.52,2.45,0.27,-0.71,-0.48,0.51,3.53,1.91,0.16,-0.34,-0.15,2.56,3.41,0.94,-0.28,-0.69,-0.41,2.05,3.23,0.88,-0.1,-0.23,1.33,3.59,2.1,0.08,-0.66,-0.49,0.15,3.4,2.05,0.36,-0.18,0.58,3.33,3.05,0.7,-0.51,-0.42,-0.18,2.57,2.76,0.83,-0.04,-0.03,2.11,3.59,1.66,0.03,-0.75,-0.46,0.85,3.39,1.62,0.1,-0.23,0.94,3.52,3.14,0.7,-0.4,-0.54,-0.18,2.55,2.86,0.92,-0.04,-0.26,0.73,3.57,1.67,0.22,-0.91,-0.72,0.39,3.09,1.59,0.16,-0.23,0.09,2.67,2.76,1.11,-0.29,-0.84,-0.51,1.82,2.57,0.84,-0.11,-0.33,0.29,3.28,2.33,0.55,-0.68,-0.81,-0.25,2.57,2.77,1.08,0.25,-0.02,-0.03,2.84,2.86,0.91,-0.1,-0.71,-0.73,0.25,2.51,2.79,1.49,0.61,0.02,-0.09,1.78,1.48,0.67,0.11,0.09,0.06,0.04,0.18,0.09,0.16,0.05,0.07,0.05,-0.1,-0.14,-0.09,-0.13,-0.12,-0.1,-0.16,-0.17,-0.14,-0.19,-0.21:0.57,0.64,0.28,0.23,-1.1,-0.54,-0.37,-0.34,-0.55,-0.86,-0.4,0.38,0.71,0.46,0.33,-0.7,-1.0,-0.31,-0.22,-0.54,-0.92,-0.92,-0.14,0.57,0.48,0.33,0.01,-1.13,-0.53,-0.43,-0.31,-0.56,-0.86,-0.3,0.38,0.57,0.29,0.22,-0.77,-0.79,-0.12,-0.28,-0.22,-1.02,-1.06,-0.21,0.39,0.48,0.36,-0.19,-1.0,-0.25,-0.06,-0.17,-0.36,-1.47,-0.72,0.19,0.54,0.3,-0.07,-1.09,-0.72,-0.17,-0.16,-0.07,-0.9,-0.71,0.21,0.39,0.35,0.3,-0.35,-1.08,-0.16,-0.43,-0.37,-0.5,-0.63,-0.12,0.58,0.39,0.25,0.19,-0.7,-0.65,-0.35,-0.36,-0.54,-1.01,-0.47,0.34,0.48,0.32,0.23,-0.8,-1.0,-0.51,-0.46,-0.36,-0.82,-0.84,-0.15,0.37,0.61,0.35,-0.12,-1.0,-0.64,-0.55,-0.38,-0.7,-1.07,-0.61,0.27,0.49,0.29,0.1,-0.59,-0.8,-0.53,-0.32,-0.28,-0.49,-1.44,-0.32,-0.06,0.69,0.43,0.06,-0.85,-0.63,-0.56,-0.39,-0.52,-1.87,-1.17,-0.52,0.28,0.5,0.21,-0.79,-1.18,-0.76,-0.53,-0.44,-0.4,-1.77,-0.72,-0.32,0.41,0.27,0.13,-0.46,-0.77,-0.26,-0.31,-0.39,-0.01,-1.2,-0.46,-0.12,0.06,0.26,0.37,-0.03,-0.12,-0.42,-0.02,-0.5,-0.23,0.17,-1.44,-0.82,-0.51,-0.11,-0.08,-0.25,-0.91,-1.26,-1.14,-0.92,-0.82,-0.82,-0.88,-0.96,-1.02,-1.04,-0.98,-0.97,-0.98,-0.95,-0.88,-0.86,-0.87,-0.91,-0.96,-0.91,-0.94,-0.95,-0.92,-0.9,-0.94,-0.98,-0.87,-0.85:RUNNING
-1.41,-2.54,-3.53,-2.8,-1.65,-1.12,-1.73,-3.39,-3.59,-2.85,-0.89,0.3,-0.41,-3.11,-3.59,-2.95,-2.01,-1.61,-2.93,-3.59,-2.17,-0.11,0.79,0.12,-2.82,-3.46,-2.32,-1.86,-1.69,-3.48,-2.94,-1.6,0.36,0.95,-0.39,-3.32,-2.7,-1.55,-1.22,-1.49,-3.25,-2.5,-0.93,0.71,0.5,-2.0,-3.59,-2.88,-1.91,-1.4,-2.71,-3.49,-2.1,-0.1,0.72,-0.06,-2.7,-3.31,-2.37,-1.7,-1.36,-2.77,-3.0,-1.99,-0.21,0.46,-0.24,-3.01,-3.1,-2.1,-1.66,-1.59,-3.39,-3.0,-1.77,0.11,0.58,-0.89,-3.52,-3.16,-2.26,-1.74,-1.37,-3.05,-2.56,-1.42,0.48,1.0,-0.4,-3.16,-2.64,-1.76,-1.48,-1.48,-3.36,-2.39,-0.86,0.59,0.24,-1.99,-3.39,-2.3,-1.57,-1.36,-1.37,-3.2,-2.25,-0.95,0.61,0.36,-1.9,-3.34,-2.28,-1.62,-1.45,-1.76,-3.19,-2.21,-0.96,0.65,0.27,-1.72,-3.36,-2.32,-1.69,-1.44,-1.83,-3.26,-2.26,-0.73,0.72,0.26,-2.13,-3.42,-2.48,-1.66,-1.07,-1.18,-3.21,-2.6,-0.78,0.59,-0.13,-1.91,-3.41,-2.51,-1.7,-1.37,-1.71,-3.1,-2.23,-0.8,0.52,0.21,-1.66,-3.46,-2.36,-1.73,-1.48,-2.35,-3.54,-2.24,-0.35,0.75,0.37,-2.0,-3.46,-2.42,-1.69,-1.41,-1.91,-3.51,-2.54,-0.65,0.64,0.32,-1.79,-3.55,-2.72,-1.75,-1.44,-1.66,-3.49,-2.61,-0.84,0.56,0.23,-2.04,-3.56,-2.48,-1.67,-1.35,-1.71,-3.41,-2.42,-0.77,0.73,0.56,-1.23,-3.41,-2.71,-1.83,-1.49,-1.3,-3.18,-2.94:-2.18,-2.67,-0.96,-0.25,1.6,1.7,0.69,-1.63,-1.35,-1.59,-2.05,-1.87,-2.99,-0.69,0.2,1.39,0.78,-1.51,-1.25,-1.55,-1.58,-2.21,-2.26,-2.19,-0.33,0.84,0.94,0.5,-1.83,-1.29,-1.14,-1.8,-2.04,-3.32,-1.44,-0.39,1.4,1.49,0.23,-1.79,-1.36,-1.51,-2.18,-1.91,-3.39,-1.07,-0.08,1.44,1.25,-0.38,-1.98,-1.3,-1.61,-2.26,-1.9,-3.07,-0.96,0.33,1.39,1.0,-1.4,-1.76,-1.42,-1.8,-2.09,-2.75,-2.27,-0.89,0.52,1.54,0.61,-1.78,-1.63,-1.25,-1.58,-1.66,-2.49,-2.08,-0.76,0.68,1.32,0.47,-2.14,-1.36,-1.19,-1.96,-1.79,-2.82,-0.95,-0.4,0.86,1.14,0.4,-2.3,-1.28,-1.09,-1.86,-1.6,-2.93,-1.1,-0.46,0.97,1.12,0.35,-2.3,-1.0,-1.04,-1.77,-1.66,-2.84,-1.28,-0.52,0.99,1.1,0.47,-2.2,-1.05,-1.35,-1.67,-1.47,-2.81,-1.02,-0.33,0.84,1.25,0.76,-1.75,-1.69,-1.18,-1.72,-1.99,-2.8,-1.19,-0.39,1.11,1.0,0.41,-2.04,-0.98,-0.97,-1.52,-1.91,-2.64,-1.46,-0.46,1.18,1.13,0.32,-1.94,-1.42,-1.52,-1.65,-1.64,-2.86,-1.13,-0.41,1.01,1.09,0.29,-2.24,-1.36,-1.6,-1.88,-1.76,-3.1,-1.46,-0.49,1.04,1.05,0.35,-2.1,-1.12,-1.52,-1.64,-1.6,-2.82,-0.97,-0.41,1.09,1.2,0.41,-2.13,-1.25,-1.32,-1.57,-1.46,-2.73,-1.67,-0.63,0.51,1.46,0.57,-1.66,-1.1,-1.26,-1.26,-1.62,-1.73,-2.26,-0.71,-0.01,1.18,0.71,-0.21,-2.2,-1.23:0.54,0.46,0.22,0.09,-0.28,-0.1,0.34,0.32,-0.22,0.33,0.38,0.74,0.36,0.08,0.24,-0.22,-0.1,0.39,-0.02,-0.1,0.25,0.25,0.48,0.16,-0.03,0.07,-0.46,-0.2,0.12,-0.09,-0.12,0.01,0.22,0.33,0.06,0.32,-0.25,-0.27,0.22,0.14,-0.27,0.08,-0.06,0.21,0.38,-0.17,-0.15,-0.35,-0.41,0.32,0.43,-0.11,0.18,0.18,0.26,0.36,-0.11,0.1,-0.52,-0.47,0.27,0.05,-0.36,-0.07,0.03,0.24,0.32,-0.16,0.12,-0.6,-0.52,0.4,0.03,-0.35,0.0,0.02,0.31,0.2,-0.12,0.35,-0.59,-0.29,0.37,0.01,-0.31,-0.13,0.06,0.33,0.14,-0.08,0.2,-0.59,-0.17,0.2,-0.06,-0.25,-0.33,0.23,0.51,0.52,0.01,-0.15,-0.16,-0.53,-0.22,-0.22,-0.39,-0.08,0.15,0.58,0.38,-0.26,0.03,-0.65,-0.36,0.14,0.18,-0.27,0.01,0.07,0.34,0.26,0.03,0.33,-0.21,-0.05,0.11,0.15,-0.31,0.07,0.16,0.38,0.5,0.07,0.25,-0.41,-0.26,0.06,0.11,-0.25,0.29,0.25,0.45,0.53,0.18,0.2,-0.5,-0.4,-0.09,-0.08,-0.34,0.0,0.08,0.61,0.41,0.03,0.22,-0.62,-0.33,0.18,0.17,-0.18,-0.15,0.01,0.22,0.32,-0.09,0.09,-0.55,-0.35,0.16,0.46,-0.01,-0.2,-0.12,0.13,0.49,0.12,0.0,0.15,-0.32,-0.11,0.26,0.69,0.46,-0.16,0.26,0.26,0.15,-0.01,-0.03,-0.61,-0.45,-0.19,0.18,0.02,-0.65,-0.38,0.02,0.33,0.33,0.07,0.16,0.15,0.07,-0.2:RUNNING
1.55,3.11,0.85,-0.34,-0.85,-0.99,-0.7,0.82,1.34,1.27,1.19,1.05,1.69,2.56,0.5,-0.49,-1.08,-0.97,-0.82,0.84,1.24,1.11,1.13,1.35,2.23,1.7,-0.16,-0.72,-0.86,-0.81,-0.75,0.83,1.19,1.26,1.25,1.37,2.77,1.14,-0.19,-0.46,-0.89,-0.71,-0.18,0.93,1.1,1.14,1.02,1.25,2.54,0.59,-0.41,-0.71,-0.99,-0.9,0.98,1.33,1.27,0.99,0.88,1.3,2.12,0.35,-0.33,-0.88,-0.96,-0.86,1.19,1.39,1.32,1.17,1.26,2.95,0.96,-0.31,-0.78,-1.12,-0.89,0.7,1.57,1.51,1.29,1.21,1.53,2.83,0.58,-0.44,-0.8,-0.93,-0.95,0.63,1.28,1.22,1.26,1.24,0.97,0.56,-0.28,-0.34,-0.54,-0.66,-0.86,0.33,0.59,0.86,0.93,1.1,2.84,1.29,-0.22,-0.79,-1.2,-0.84,0.33,1.47,1.17,1.01,0.94,0.98,2.17,0.88,-0.27,-0.56,-0.87,-0.75,-0.09,0.95,1.13,1.17,1.02,1.13,2.49,0.75,-0.31,-0.52,-0.79,-0.71,0.1,0.9,0.94,0.94,0.86,1.1,2.0,0.54,-0.43,-0.59,-0.82,-1.01,0.05,0.78,0.98,1.14,1.06,1.24,1.83,0.43,-0.4,-0.47,-0.69,-0.78,-0.3,0.49,0.93,1.2,1.02,1.2,1.87,0.23,-0.42,-0.53,-0.63,-0.69,-0.14,0.52,0.67,0.85,0.91,1.06,2.25,0.46,-0.4,-0.42,-0.61,-0.59,-0.9,0.64,0.74,0.74,0.65,0.25,0.0,0.52,0.6,0.16,-0.02,-0.12,-0.14,0.13,0.52,0.52,0.56,0.33,0.31,0.51,0.62,0.59:3.52,1.58,0.32,-0.06,0.66,3.33,3.59,1.42,-0.15,-0.67,-0.4,-0.03,3.22,2.29,0.44,-0.16,-0.18,1.0,3.59,2.53,0.32,-0.63,-0.58,0.12,3.33,1.75,0.01,-0.5,-0.47,1.62,3.59,1.62,-0.01,-0.71,-0.3,1.13,3.38,1.11,-0.37,-0.69,-0.4,2.13,3.29,1.02,-0.34,-0.8,-0.18,2.47,2.84,0.66,-0.16,-0.4,-0.25,2.91,2.82,0.6,-0.48,-0.62,-0.2,2.96,2.35,0.03,-0.79,-0.59,1.29,3.59,2.05,0.25,-0.68,-0.66,0.42,3.44,1.53,-0.25,-0.65,-0.43,2.05,3.58,1.26,-0.45,-0.83,-0.38,2.26,3.04,0.75,-0.38,-0.38,0.05,3.33,2.58,0.33,-0.89,-0.72,-0.21,3.1,2.11,0.3,-0.22,-0.32,1.29,3.59,1.78,-0.11,-0.81,-0.29,1.96,2.23,0.58,-0.18,-0.42,-0.25,1.67,2.37,0.82,-0.14,-0.49,-0.27,2.16,2.12,0.69,-0.02,-0.15,0.22,3.28,2.77,0.63,-0.33,-0.51,-0.26,2.32,2.76,0.74,-0.27,-0.44,-0.04,3.06,2.9,0.76,-0.31,-0.55,-0.29,2.78,2.45,0.62,-0.27,-0.43,0.1,3.25,2.74,0.77,-0.26,-0.55,-0.26,2.55,2.66,0.87,-0.21,-0.4,0.62,3.59,2.18,0.25,-0.52,-0.26,0.36,3.51,2.27,0.35,-0.38,-0.38,0.46,3.45,2.45,0.52,-0.5,-0.46,0.14,3.38,2.17,0.45,-0.35,-0.37,0.52,3.52,2.45,0.7,-0.17,-0.38,-0.16,2.86,2.39,0.71,0.0,-0.21,-0.12,1.74,3.14,1.4,0.41,-0.01,-0.05,0.3,0.36,-0.04,-0.16,-0.08:-0.38,-0.27,-0.34,-0.99,-0.86,0.03,0.47,0.48,0.22,0.17,-0.66,-0.64,-0.04,-0.2,-0.28,-0.18,-0.62,-0.28,0.61,0.28,0.17,0.06,-1.04,-0.84,-0.04,-0.16,-0.11,-0.83,-1.14,0.16,0.17,0.33,0.31,-0.09,-1.28,-0.71,0.04,-0.03,-0.12,-1.34,-1.16,-0.22,0.07,0.25,0.08,-0.24,-0.54,0.1,-0.28,-0.28,-0.11,-1.25,-0.49,0.13,0.28,0.28,0.23,-0.69,-0.78,0.01,0.03,0.03,-0.55,-0.65,-0.16,0.2,0.28,0.12,-0.14,-0.59,-0.27,0.11,-0.09,-0.11,-0.65,-0.45,0.04,0.42,0.27,0.14,0.05,-0.28,-0.12,-0.22,-0.32,-0.12,-0.07,-0.18,0.35,0.41,0.14,0.28,-0.27,-0.32,-0.28,-0.43,-0.32,-0.47,-0.89,-0.05,0.3,0.21,-0.15,-1.61,-1.92,-0.81,-0.01,0.18,0.01,-1.6,-1.72,-0.69,-0.26,0.08,-0.11,-1.29,-1.49,-0.64,-0.35,-0.23,-0.13,-1.25,-0.55,-0.04,0.13,0.29,0.21,-0.75,-0.9,-0.4,-0.37,-0.25,-0.09,-1.05,-0.55,-0.01,0.21,0.15,0.08,-0.79,-0.74,-0.32,-0.4,-0.24,-0.16,-0.95,-0.35,0.01,0.11,0.14,0.12,-0.55,-0.62,-0.36,-0.33,-0.22,-0.21,-0.97,-0.31,0.17,0.35,0.34,0.15,-0.09,-0.32,-0.17,-0.14,-0.14,-0.09,-0.64,-0.41,0.0,0.12,0.12,0.03,-0.66,-0.58,-0.16,-0.16,-0.2,-0.22,-1.02,-0.44,-0.12,0.02,0.06,0.0,-0.86,-0.9,-0.43,-0.17,-0.1,0.0,-0.98,-1.24,-0.69,-0.22,-0.02,-0.14,-0.72,-1.91,-1.73,-0.97,-0.56,-0.34,-0.42:RUNNING
0.79,0.72,0.44,0.1,0.38,1.37,1.79,0.85,0.37,0.41,0.97,1.96,0.58,-0.44,-0.72,-0.63,0.62,1.44,0.87,0.57,0.69,1.27,1.77,0.48,-0.3,-0.7,-0.71,0.38,1.35,0.77,0.53,0.58,0.97,1.5,0.49,-0.31,-0.74,-0.74,0.06,1.0,0.71,0.54,0.61,1.05,1.51,0.52,-0.26,-0.73,-0.73,-0.12,0.78,0.61,0.56,0.69,1.0,1.41,0.5,-0.33,-0.85,-0.84,-0.18,0.94,0.64,0.56,0.64,1.05,1.44,0.58,-0.24,-0.84,-0.87,-0.27,0.98,0.61,0.51,0.76,1.04,1.35,0.47,-0.36,-0.81,-0.73,0.14,0.87,0.5,0.48,0.74,1.13,1.36,0.6,-0.36,-0.84,-0.79,-0.17,0.85,0.51,0.44,0.68,1.04,1.23,0.58,-0.26,-0.72,-0.77,-0.23,0.79,0.55,0.52,0.65,0.99,1.34,0.55,-0.2,-0.73,-0.76,-0.28,0.7,0.48,0.44,0.59,0.95,1.21,0.78,-0.08,-0.65,-0.82,-0.45,0.68,0.54,0.51,0.56,0.74,1.19,0.68,-0.12,-0.62,-0.78,-0.56,0.45,0.64,0.47,0.54,0.89,1.38,1.39,0.15,-0.57,-0.99,-0.74,0.16,0.85,0.54,0.6,0.93,1.2,1.58,0.33,-0.41,-0.98,-0.85,-0.07,1.0,0.61,0.61,0.88,1.12,1.58,0.56,-0.3,-0.85,-0.85,-0.36,0.96,0.67,0.68,0.7,0.9,1.34,0.84,-0.14,-0.73,-0.77,-0.15,1.04,0.52,0.32,0.5,1.01,1.66,1.22,0.0,-0.79,-0.91,-0.47,0.7,0.86,0.58,0.64,1.08,1.52,0.96,-0.06,-0.65,-0.85,-0.54,0.36:0.96,0.21,0.2,2.11,2.81,1.53,0.18,-0.49,-0.25,2.43,2.27,0.9,0.15,0.02,2.38,2.99,1.39,0.1,-0.49,-0.27,2.35,2.36,0.9,0.13,0.13,2.25,2.92,1.39,0.09,-0.55,0.11,2.52,2.07,0.75,0.07,0.2,2.79,2.49,1.12,-0.01,-0.51,0.3,2.48,2.12,0.72,0.12,0.12,2.32,2.89,1.42,0.21,-0.46,-0.08,2.2,2.26,0.97,0.13,0.12,2.05,2.85,1.57,0.32,-0.44,-0.31,2.16,2.43,1.13,0.18,0.2,2.02,2.72,1.6,0.32,-0.43,-0.28,1.87,2.42,1.32,0.22,0.12,1.54,2.82,1.74,0.56,-0.33,-0.42,1.23,3.01,1.7,0.41,-0.05,0.62,3.06,2.19,0.85,-0.32,-0.62,0.57,3.03,1.9,0.81,0.13,0.5,2.94,2.43,0.99,-0.07,-0.59,-0.07,3.0,2.33,0.95,0.18,0.2,2.66,2.96,1.35,0.13,-0.56,-0.42,2.19,2.73,1.11,0.22,0.2,2.49,2.74,1.39,0.31,-0.46,-0.43,1.7,2.69,1.44,0.47,0.16,1.65,2.96,1.59,0.38,-0.53,-0.56,1.01,3.02,1.62,0.62,0.27,1.36,2.98,1.77,0.58,-0.3,-0.47,1.22,2.79,1.77,0.58,0.24,1.02,2.97,1.95,0.78,-0.08,-0.36,0.23,2.57,2.0,0.8,0.28,1.0,2.69,2.18,1.17,0.06,-0.56,-0.34,2.42,2.36,1.05,0.18,0.32,2.14,2.64,1.5,0.4,-0.43,-0.41,1.61,2.74,1.38,0.39,0.2,1.37,2.93,1.77,0.76,-0.2,-0.46,0.36,2.63,2.17,0.98,0.25,0.27,1.05,2.13:-0.32,-0.53,-0.31,-0.02,0.57,0.35,0.15,0.1,0.08,0.23,-0.18,-0.1,-0.24,-0.26,-0.05,0.44,0.27,0.08,0.17,0.04,0.17,-0.12,-0.23,-0.29,-0.27,0.04,0.47,0.26,0.09,0.14,0.07,0.35,-0.25,-0.16,-0.34,-0.26,-0.03,0.38,0.32,0.11,0.16,0.13,0.33,-0.19,-0.2,-0.25,-0.33,-0.11,0.27,0.3,0.12,0.12,0.13,0.44,-0.03,-0.2,-0.26,-0.35,-0.16,0.34,0.37,0.14,0.12,0.15,0.42,-0.07,-0.29,-0.21,-0.31,-0.1,0.19,0.24,-0.04,0.17,0.14,0.35,-0.01,-0.24,-0.3,-0.32,-0.15,0.19,0.37,0.2,0.12,0.24,0.2,0.12,-0.08,-0.39,-0.34,-0.2,0.58,0.74,0.34,0.06,0.15,0.05,0.54,0.06,-0.19,-0.27,-0.23,0.22,0.68,0.43,0.12,0.23,0.07,0.8,0.3,0.02,-0.27,-0.35,0.01,0.76,0.57,0.13,0.19,0.1,0.47,0.12,-0.19,-0.42,-0.27,-0.04,0.41,0.46,0.17,0.23,0.3,0.72,0.41,0.07,-0.19,-0.31,-0.11,0.5,0.67,0.31,0.13,0.15,0.58,0.14,-0.12,-0.25,-0.38,-0.28,0.28,0.52,0.25,0.1,0.1,0.13,0.18,-0.1,-0.24,-0.31,-0.27,0.01,0.42,0.17,0.13,0.25,0.16,0.24,-0.19,-0.26,-0.26,-0.25,-0.12,0.1,0.17,0.09,0.18,0.14,0.42,-0.17,-0.29,-0.37,-0.31,-0.07,0.11,0.26,0.07,0.19,0.2,0.07,0.15,-0.18,-0.17,-0.35,-0.28,-0.11,0.07,0.19,0.03,0.06,0.06,0.0,0.19,0.09,0.31,0.16,-0.03,-0.17:RUNNING
-0.99,-0.98,-1.0,-1.0,-0.99,-0.99,-0.99,-0.97,-0.98,-0.98,-0.97,-0.98,-0.98,-0.98,-0.99,-0.99,-0.99,-0.99,-0.99,-0.98,-0.98,-0.98,-0.97,-0.98,-0.98,-0.92,-1.0,-1.0,-1.0,-1.0,-1.05,-1.02,-0.87,-0.89,-1.0,-1.04,-1.16,-1.29,-1.12,-1.19,-2.39,-3.59,-3.59,-2.66,-1.54,-1.75,-3.27,-3.59,-2.33,-0.83,0.18,-0.66,-3.31,-3.59,-2.53,-1.79,-1.87,-3.59,-3.25,-1.66,0.3,0.54,-1.91,-3.59,-2.78,-2.0,-1.7,-2.49,-3.59,-2.38,-0.65,0.78,0.7,-1.87,-3.59,-2.55,-2.26,-1.78,-2.74,-3.58,-2.3,-0.47,0.62,-0.2,-3.13,-3.15,-2.4,-1.99,-1.53,-3.05,-2.51,-1.55,0.29,0.95,-0.01,-3.14,-2.65,-2.11,-1.83,-1.67,-3.31,-2.24,-0.99,0.65,0.94,-0.47,-3.15,-2.58,-1.99,-1.57,-1.37,-3.0,-2.32,-1.0,0.58,0.77,-1.08,-3.32,-2.72,-2.0,-1.62,-1.24,-3.03,-2.5,-1.0,0.6,0.48,-1.57,-3.34,-2.49,-1.97,-1.62,-1.79,-3.39,-2.4,-0.82,0.62,0.29,-1.84,-3.41,-2.56,-2.08,-1.55,-1.58,-2.89,-2.09,-0.59,0.68,0.29,-2.38,-3.22,-2.19,-1.76,-1.42,-2.26,-3.1,-2.16,-0.49,0.82,0.43,-2.43,-3.26,-2.43,-1.85,-1.38,-2.43,-3.01,-2.08,-0.42,0.7,-0.02,-2.84,-3.2,-2.12,-1.66,-1.33,-2.35,-3.0,-1.8,-0.11,0.69,0.07,-2.88,-2.77,-1.8,-1.51,-1.55,-3.47,-3.03,-1.5,0.25,0.72,-0.4,-3.24,-2.93,-2.04,-1.54,-1.49,-3.44,-3.06,-1.7,0.23,0.75,-0.76,-3.31,-2.65:-0.97,-1.26,-1.71,-2.01,-3.07,-1.37,-0.35,1.19,1.01,0.32,-2.29,-1.25,-1.74,-2.43,-2.43,-2.93,-1.23,0.13,1.35,0.68,-1.79,-1.53,-0.86,-1.66,-1.63,-1.79,-2.52,-0.83,0.47,1.37,0.5,-2.56,-1.35,-1.11,-1.5,-1.64,-2.27,-2.01,-0.82,0.62,1.36,0.47,-2.38,-1.1,-1.17,-1.83,-1.53,-2.65,-1.66,-0.7,0.42,1.38,0.57,-1.94,-1.36,-1.22,-1.57,-1.77,-2.92,-1.6,-0.62,0.8,1.3,0.18,-2.02,-0.95,-1.13,-2.19,-1.78,-3.13,-1.32,-0.59,0.93,1.26,0.18,-2.26,-1.13,-1.25,-2.0,-1.6,-3.41,-0.95,-0.41,1.02,1.13,0.21,-2.24,-1.02,-1.26,-1.94,-1.46,-3.43,-1.36,-0.31,1.2,1.11,0.21,-1.84,-1.1,-1.39,-1.85,-1.91,-3.34,-0.66,-0.15,1.09,0.77,-0.56,-2.0,-1.14,-1.39,-1.92,-1.63,-2.79,-0.82,0.09,1.28,0.97,-1.63,-1.21,-1.54,-1.38,-1.64,-2.04,-2.19,-0.84,0.48,1.66,1.13,-1.7,-1.18,-1.29,-1.53,-2.07,-2.03,-1.91,-0.59,0.55,1.23,0.6,-1.75,-1.0,-1.18,-1.65,-1.95,-2.43,-1.87,-0.74,0.52,1.48,0.68,-1.74,-1.16,-1.21,-1.67,-1.82,-2.11,-2.4,-0.44,0.49,1.41,0.66,-1.82,-1.14,-1.39,-1.62,-1.67,-2.14,-1.88,-0.52,0.58,1.5,1.18,-1.86,-0.99,-1.58,-1.63,-1.95,-2.0,-1.9,-0.58,0.37,1.48,0.83,-1.59,-1.06,-0.89,-1.11,-1.51,-1.27,-2.11,-0.72,-0.32,1.0,0.82,0.17,-2.37,-1.05,-0.66,-0.79,-1.0,-1.76,-0.71,-0.07,-0.5,0.62:-0.34,0.69,0.54,-0.15,-0.17,0.07,0.13,0.43,-0.15,0.5,-0.38,-0.03,0.54,0.61,-0.38,-0.05,-0.07,0.14,0.18,-0.19,0.09,-0.52,-0.39,0.43,0.22,-0.6,-0.02,-0.04,0.15,0.44,-0.34,-0.39,-0.58,-0.6,0.09,0.07,-0.56,-0.18,-0.07,0.39,0.18,-0.49,0.16,-0.51,-0.23,0.48,0.06,-0.52,0.07,0.01,0.39,0.15,-0.55,-0.02,-0.75,-0.22,0.4,-0.12,-0.37,-0.01,0.0,0.28,0.01,-0.24,0.05,-0.59,0.03,0.56,0.07,-0.09,0.2,0.06,0.43,-0.06,-0.12,0.0,-0.56,0.0,0.17,-0.13,-0.11,-0.02,0.3,0.66,0.43,-0.18,-0.07,-0.46,0.05,0.36,0.08,-0.13,0.21,0.2,0.5,0.1,0.0,-0.47,-0.2,0.09,0.22,-0.21,-0.19,0.07,0.13,0.39,0.07,0.15,-0.38,-0.33,0.14,0.46,-0.45,0.22,-0.02,0.31,0.33,0.04,0.34,-0.39,-0.31,0.17,0.15,-0.42,0.15,0.01,0.39,0.47,-0.11,-0.04,-0.52,-0.48,0.29,0.31,-0.49,0.11,-0.2,0.25,0.36,-0.01,0.02,-0.53,-0.47,0.11,0.23,-0.54,0.05,-0.02,0.3,0.38,0.26,0.44,-0.31,-0.11,0.09,0.22,-0.2,0.04,0.07,0.33,0.38,0.01,-0.15,-0.52,-0.47,0.06,0.5,0.15,-0.39,-0.42,-0.07,0.23,0.11,-0.33,-0.28,-0.63,-0.45,-0.14,0.23,0.32,-0.68,-0.22,-0.09,0.05,0.09,-0.58,-0.21,-0.24,-0.15,0.11,0.38,0.37,0.03,-0.14,-0.39,-0.25,0.07,0.46,0.61,0.21,0.06,-0.04,-0.06,-0.07,-0.02,0.0:RUNNING
1.91,1.58,1.89,3.4,2.63,0.21,-1.11,-1.47,-0.98,1.77,2.98,2.14,1.67,1.17,1.49,3.47,0.99,-0.48,-0.99,-1.07,-0.91,1.75,1.96,1.79,1.3,1.2,2.78,1.77,0.08,-0.48,-1.13,-0.99,0.69,2.04,1.64,1.52,1.23,1.29,3.52,1.02,-0.41,-1.14,-1.28,-0.99,1.26,2.03,1.78,1.36,1.33,3.09,1.6,-0.18,-0.88,-1.26,-1.09,1.54,1.91,1.48,1.21,1.09,1.45,3.04,0.64,-0.38,-0.97,-0.99,-1.1,0.68,1.26,1.4,1.5,1.45,2.51,1.0,-0.29,-0.73,-0.99,-0.85,-0.16,1.23,1.04,1.05,1.0,1.28,2.15,0.51,-0.45,-1.07,-1.12,-0.69,1.49,1.52,1.13,1.11,1.12,2.26,1.33,-0.08,-0.6,-0.65,-0.23,0.76,2.51,1.65,1.99,1.33,0.94,1.1,0.05,-0.55,-0.79,-0.78,-0.86,0.95,1.24,0.95,0.79,0.66,2.26,1.91,0.26,-0.38,-0.75,-0.69,-0.77,0.9,1.2,1.32,1.19,1.35,3.07,0.92,-0.22,-0.77,-0.98,-0.91,0.72,1.11,1.14,1.06,0.99,0.98,1.87,0.19,-0.32,-0.51,-0.8,-1.1,-0.2,0.8,1.32,1.18,1.04,1.17,2.24,0.34,-0.37,-0.69,-0.78,-0.65,0.24,0.94,0.91,0.94,0.96,1.04,1.99,0.3,-0.37,-0.6,-0.72,-0.65,0.25,0.92,0.9,0.87,0.78,0.78,1.65,0.86,-0.06,-0.37,-0.33,-0.36,-0.69,0.86,1.09,0.67,0.43,0.16,0.01,0.5,0.71,0.55,0.31,0.54,0.6,0.41,0.23,0.36,0.29,0.36,0.53,0.48,0.29,0.27:-0.17,1.33,3.46,1.47,0.01,-0.25,0.49,3.51,2.96,0.24,-0.85,-0.76,-0.21,2.95,2.27,-0.08,-0.67,-0.41,1.45,3.59,1.86,-0.33,-1.13,-0.56,0.93,3.3,0.82,-0.73,-0.73,0.04,3.21,3.0,0.63,-0.78,-0.79,-0.57,2.93,2.09,-0.21,-0.66,-0.37,1.89,3.59,1.79,-0.28,-0.94,-0.44,1.99,2.89,0.81,-0.36,-0.41,1.0,3.59,2.21,0.23,-0.84,-0.63,-0.2,3.11,2.05,0.14,-0.49,-0.42,1.65,3.59,1.66,-0.01,-0.7,-0.33,2.0,3.26,0.85,-0.4,-0.43,-0.09,3.02,2.64,0.46,-0.61,-0.45,0.13,3.41,1.78,-0.15,-0.49,-0.18,2.4,3.55,0.95,-0.06,-0.75,-0.5,1.83,3.02,0.92,-0.38,-0.22,-0.66,0.67,3.52,1.86,-0.19,-0.81,0.24,2.86,1.73,0.22,-0.17,-0.04,1.47,3.59,1.62,-0.34,-0.97,-0.4,1.75,2.78,0.64,-0.46,-0.45,-0.35,2.4,3.21,0.99,-0.77,-0.73,-0.13,3.03,2.59,0.39,-0.45,-0.33,1.17,3.59,2.18,0.36,-0.6,-0.45,0.6,3.39,1.48,-0.11,-0.36,-0.33,0.84,3.59,2.65,0.43,-0.61,-0.49,0.28,3.36,1.99,0.44,-0.28,-0.17,0.72,3.55,2.23,0.53,-0.34,-0.46,-0.03,3.17,2.47,0.65,-0.27,-0.33,0.26,3.26,2.54,0.71,-0.25,-0.47,-0.35,2.04,3.2,1.38,0.42,-0.01,-0.07,1.01,2.94,2.01,0.73,0.13,-0.04,0.06,-0.1,-0.2,-0.05,-0.21,0.05,0.03,-0.03,-0.07,-0.04,0.0,-0.25,-0.22,-0.13,-0.18,-0.15,-0.13,-0.05:0.15,0.59,0.29,0.1,0.74,-0.72,-0.14,-0.23,-0.07,-0.24,-1.07,-0.36,0.45,0.74,0.16,0.22,-0.63,-0.8,0.03,-0.11,-0.16,-0.67,-0.83,-0.11,0.63,0.37,0.07,0.52,-1.06,-0.13,0.45,0.07,-0.21,-1.59,-1.09,-0.22,0.47,0.34,0.06,-0.96,-0.8,-0.02,0.02,-0.09,-0.75,-1.07,-0.07,0.58,0.27,0.08,-0.5,-1.0,-0.52,-0.34,-0.28,-0.43,-0.92,-0.15,0.1,0.43,0.17,0.1,-0.79,-0.64,-0.1,-0.11,-0.15,-0.88,-1.26,-0.64,0.08,0.3,0.06,-0.69,-1.17,-0.2,-0.19,-0.21,-0.05,-1.22,-0.56,-0.13,0.32,0.17,0.08,-0.77,-0.73,0.0,0.08,0.04,-0.45,-0.72,0.22,0.12,0.32,0.35,-0.42,-0.8,-0.45,-0.4,-0.92,-2.19,-2.12,-0.96,0.2,0.02,-1.19,-1.23,-0.9,-0.6,-0.05,-0.17,-0.1,-0.34,-0.61,-0.09,0.06,-0.16,0.16,-0.26,-0.75,-0.4,-0.46,-0.33,-0.07,-0.38,0.03,0.03,0.1,0.17,0.21,0.22,-0.1,-0.2,-0.31,-0.29,-0.02,0.14,0.35,0.41,0.26,0.05,-0.18,-0.68,-0.48,-0.15,-0.22,-0.22,-0.04,-0.46,-0.32,0.17,0.13,0.11,-0.2,-1.33,-0.89,-0.39,-0.31,-0.19,-0.28,-0.98,-0.36,-0.1,-0.01,0.28,0.08,-0.5,-0.62,-0.28,-0.2,-0.21,-0.13,-1.13,-0.65,-0.19,0.06,0.13,0.16,-0.45,-0.65,-0.61,-0.15,-0.23,-0.26,-0.56,-1.07,-0.85,-0.39,0.0,0.06,-0.23,-1.08,-1.25,-1.17,-0.79,-1.21,-1.14,-1.06,-0.95,-0.84,-0.79,-0.8,-0.96,-0.95,-0.96:RUNNING
1.83,1.55,1.35,1.77,3.08,0.83,-0.51,-1.23,-1.36,-0.35,1.34,1.75,1.35,1.28,1.25,2.04,1.96,0.19,-0.66,-1.04,-0.86,0.16,1.63,1.62,1.53,1.19,1.36,3.0,1.39,-0.05,-0.64,-1.25,-0.88,0.85,1.5,1.49,1.24,1.17,1.44,1.78,0.26,-0.54,-1.14,-1.12,-0.52,1.13,1.42,1.22,1.13,1.21,1.83,1.36,0.03,-0.75,-1.12,-0.68,0.59,1.5,1.13,0.85,0.88,1.05,2.45,0.9,-0.27,-0.76,-0.98,-0.68,1.24,1.52,1.04,0.97,0.93,1.28,2.4,0.36,-0.48,-1.07,-0.93,-0.21,1.13,1.06,0.89,0.93,1.09,1.88,1.51,-0.04,-0.54,-0.96,-0.88,-0.03,1.11,1.13,1.14,0.94,1.05,2.2,0.87,-0.3,-0.69,-0.99,-0.85,0.18,0.98,1.24,1.0,1.01,1.22,1.63,0.28,-0.37,-0.96,-1.0,-0.39,0.88,1.12,1.12,1.12,1.23,2.08,0.35,-0.54,-1.0,-0.94,-0.49,0.96,1.07,0.88,0.82,1.16,1.85,1.11,-0.36,-0.83,-1.01,-0.86,0.46,1.11,1.12,1.17,1.11,1.22,1.58,0.13,-0.51,-0.82,-0.8,-0.77,1.37,1.05,0.72,0.7,0.85,1.39,1.28,-0.22,-0.51,-0.78,-0.71,-0.9,1.24,1.13,0.93,0.84,0.87,1.34,1.18,0.04,-0.38,-0.44,-0.56,-0.76,0.58,0.99,0.65,0.51,0.35,0.19,0.3,0.5,0.23,0.11,-0.16,-0.15,-0.08,0.11,0.24,0.17,0.15,0.23,0.09,-0.02,-0.02,-0.01,-0.04,-0.07,-0.21,-0.33,-0.39,-0.39,-0.4,-0.44,-0.44,-0.42,-0.44:0.41,-0.48,-0.4,-0.05,3.17,2.48,0.45,-0.17,0.07,2.48,3.59,1.76,-0.02,-0.66,-0.33,0.92,3.5,1.62,-0.04,-0.41,-0.08,2.57,3.44,1.01,-0.72,-0.96,-0.33,2.55,2.91,0.44,-0.5,-0.18,1.57,3.59,2.35,0.23,-0.46,-0.35,0.3,3.45,2.09,0.35,-0.36,-0.09,2.38,3.56,1.27,-0.2,-0.6,-0.34,1.54,3.23,1.34,0.15,-0.01,0.73,3.25,2.5,0.77,-0.25,-0.54,-0.38,2.67,2.39,0.73,0.01,-0.05,1.2,3.59,2.14,0.26,-0.56,-0.44,0.08,3.29,1.66,0.33,-0.24,-0.11,2.38,3.38,1.23,-0.11,-0.51,-0.37,1.69,2.95,1.12,0.04,-0.3,0.53,2.86,3.17,1.13,-0.24,-0.59,-0.41,2.47,2.73,0.75,-0.18,-0.28,0.78,3.59,2.33,0.41,-0.28,-0.19,0.49,3.2,1.9,0.73,0.16,0.16,2.6,3.36,1.09,-0.31,-0.5,-0.2,2.84,2.7,0.61,-0.22,-0.06,2.08,3.4,1.59,0.06,-0.56,-0.38,1.77,3.16,0.96,-0.1,-0.27,0.94,3.59,2.4,0.51,-0.51,-0.56,0.5,3.46,1.83,0.28,-0.28,-0.25,1.8,3.46,1.55,0.1,-0.48,-0.53,1.41,3.2,1.1,-0.04,-0.31,-0.28,1.8,3.54,1.44,-0.07,-0.64,-0.57,1.38,3.4,1.5,0.22,-0.07,-0.11,0.87,3.32,2.0,0.74,0.18,0.06,0.15,0.11,-0.08,-0.32,-0.12,-0.1,-0.11,-0.04,-0.06,-0.24,-0.27,-0.16,-0.11,-0.09,-0.29,-0.16,-0.11,-0.17,-0.13,-0.05,-0.1,-0.32,-0.26,-0.23,-0.25,-0.14,-0.13,-0.09:0.46,0.54,0.4,0.18,-0.87,-0.91,-0.14,-0.19,-0.35,-0.65,-0.8,0.09,0.36,0.44,0.17,-0.08,-1.01,-0.66,-0.27,-0.2,-0.2,-1.0,-0.77,-0.13,0.25,0.18,0.2,-0.29,-0.65,-0.03,-0.03,-0.19,-0.25,-0.67,-0.41,0.21,0.18,0.13,-0.24,-1.48,-0.96,-0.31,-0.02,-0.22,-0.87,-1.1,-0.2,0.22,0.25,0.25,-0.4,-1.14,-0.67,-0.41,-0.24,-0.3,-0.84,-0.52,-0.02,0.12,0.28,0.17,-0.59,-0.79,-0.27,-0.19,-0.3,-0.03,-0.31,-0.04,0.42,0.29,0.1,0.07,-1.08,-0.72,-0.41,-0.3,-0.26,-0.68,-0.69,0.07,0.09,0.18,0.22,-0.69,-0.94,-0.59,-0.32,-0.27,-0.43,-0.95,-0.83,-0.22,0.17,0.16,0.17,-0.69,-0.98,-0.46,-0.26,-0.4,-0.19,-1.2,-0.41,0.0,0.18,0.17,-0.01,-0.94,-0.6,-0.36,-0.19,-0.24,-0.89,-0.93,-0.2,0.27,0.3,0.19,-0.54,-0.91,-0.22,-0.18,-0.24,-0.38,-0.63,-0.08,0.11,0.17,0.23,-0.37,-0.97,-0.35,-0.5,-0.32,-0.17,-0.74,-0.2,0.09,0.24,0.2,-0.06,-0.67,-0.55,-0.26,-0.28,-0.18,-0.29,-0.45,-0.11,0.14,0.0,0.19,-0.24,-0.77,-0.31,-0.23,-0.27,-0.11,-0.53,-0.78,-0.21,0.02,0.04,0.23,-0.36,-0.76,-0.44,-0.16,-0.17,-0.15,-0.33,-1.04,-0.84,-0.39,-0.14,0.01,-0.3,-1.44,-1.73,-1.08,-0.67,-0.33,-0.32,-1.16,-1.53,-1.37,-1.05,-0.79,-0.92,-1.19,-1.19,-0.97,-0.85,-0.89,-1.05,-0.96,-1.02,-1.01,-0.87,-0.78,-0.66,-0.61,-0.64,-0.97:RUNNING
-1.02,-0.95,-1.2,-1.79,-2.35,-2.37,-0.77,0.75,1.16,0.48,-1.49,-2.9,-2.75,-1.79,-1.13,-0.96,-1.36,-3.09,-1.45,0.08,0.75,0.81,0.65,-0.46,-1.64,-1.54,-1.26,-1.05,-0.94,-2.01,-2.26,-0.45,0.41,0.86,0.75,0.33,-1.34,-1.46,-1.18,-1.12,-1.02,-1.95,-2.49,-0.57,0.39,0.86,0.8,0.61,-1.05,-1.32,-1.1,-1.11,-0.91,-1.2,-2.23,-0.62,0.3,0.79,0.76,0.84,-0.42,-0.98,-1.0,-1.09,-1.07,-1.52,-2.09,-0.47,0.49,0.89,0.92,0.61,-0.82,-1.2,-1.14,-1.22,-1.19,-1.78,-1.9,-0.25,0.38,0.75,0.67,0.82,-0.52,-0.88,-1.0,-1.06,-1.07,-1.79,-1.75,-0.12,0.58,0.88,0.75,0.29,-1.02,-1.23,-1.14,-1.06,-1.01,-1.92,-1.49,-0.05,0.48,0.85,0.82,0.37,-0.95,-1.1,-1.08,-1.0,-0.95,-1.71,-1.63,-0.12,0.49,1.0,0.9,0.22,-1.04,-1.29,-1.32,-1.23,-1.24,-2.18,-1.62,-0.09,0.49,0.92,0.76,0.17,-1.05,-1.12,-0.98,-0.97,-1.07,-2.02,-1.72,-0.02,0.53,0.87,0.81,0.32,-0.97,-1.23,-1.13,-1.07,-1.06,-1.87,-1.89,-0.2,0.54,0.94,0.84,0.34,-1.0,-1.26,-1.33,-1.13,-1.17,-2.34,-2.2,-0.18,0.77,1.44,1.0,-0.45,-1.9,-1.84,-1.26,-0.98,-1.08,-2.73,-2.24,-0.22,0.56,1.36,1.04,0.38,-1.13,-1.39,-1.46,-1.39,-1.6,-3.09,-1.47,0.15,1.0,1.35,0.84,-1.21,-2.0,-1.64,-1.41,-1.4,-1.71,-3.39,-1.85,-0.05,0.71,1.17,0.93,-0.11,-1.54,-1.4:-1.8,-3.53,-1.87,0.19,0.8,0.48,-0.25,-2.84,-1.96,-0.36,-0.05,-0.07,-1.27,-3.43,-2.19,-0.36,0.64,0.6,0.13,-2.96,-2.25,-0.36,0.0,0.06,-0.95,-3.47,-2.12,-0.32,0.64,0.44,-0.18,-2.98,-1.82,-0.53,-0.24,-0.16,-1.74,-3.56,-1.79,-0.03,0.84,0.58,-0.69,-3.02,-1.82,-0.41,-0.04,0.08,-1.66,-3.28,-1.72,-0.27,0.68,0.53,-1.04,-3.09,-1.61,-0.35,0.03,0.14,-2.18,-3.24,-1.46,0.01,0.72,0.41,-1.59,-2.99,-1.34,-0.26,0.14,0.19,-2.1,-3.25,-1.36,0.06,0.5,0.48,-1.25,-2.84,-1.42,-0.47,-0.24,-0.01,-2.26,-3.46,-1.5,0.16,0.68,0.46,-1.39,-3.19,-1.62,-0.39,0.09,0.02,-2.32,-3.16,-1.37,-0.01,0.63,0.41,-1.29,-3.08,-1.52,-0.45,-0.21,-0.05,-2.2,-3.34,-1.48,0.13,0.67,0.47,-1.13,-3.07,-1.66,-0.4,0.19,0.15,-2.3,-3.33,-1.47,0.28,0.81,0.35,-1.26,-3.0,-1.06,-0.6,-0.51,-0.45,-2.78,-3.18,-0.78,0.73,0.72,0.45,-1.52,-3.07,-1.32,-0.26,-0.05,-0.02,-2.53,-3.32,-1.06,0.69,0.86,0.3,-2.23,-2.97,-0.99,-0.51,-0.24,-0.41,-3.09,-3.07,-1.0,0.71,1.2,0.44,-2.1,-3.19,-1.18,-0.52,-0.26,-0.4,-2.96,-2.77,-0.8,0.35,0.6,0.51,-1.78,-3.05,-1.27,-0.4,-0.11,-0.05,-2.26,-3.07,-1.44,-0.05,0.68,0.72,-0.19,-2.89,-2.47,-1.07,-0.42,0.03,0.22,-1.97,-3.35,-1.79,0.1,0.83,0.5,-1.26,-2.82,-1.79,-0.7,-0.22,-0.73,-1.75:1.0,0.52,-0.2,-0.27,0.11,1.35,1.57,1.13,0.46,0.1,-0.07,0.06,1.64,1.0,0.21,-0.38,-0.47,-0.06,1.21,1.41,0.74,0.27,-0.06,-0.15,0.62,1.25,0.46,-0.29,-0.56,-0.33,0.41,1.64,0.84,0.48,-0.12,-0.17,0.43,1.53,0.68,-0.03,-0.47,-0.43,0.56,1.77,1.04,0.42,0.0,-0.2,0.03,1.52,0.59,-0.04,-0.54,-0.51,0.21,1.39,0.81,0.14,-0.24,-0.11,0.29,1.33,0.61,-0.23,-0.62,-0.42,0.6,1.74,1.06,0.4,-0.03,-0.03,0.38,1.06,0.29,-0.14,-0.57,-0.51,0.36,1.51,0.99,0.27,-0.11,-0.18,0.55,1.21,0.47,-0.39,-0.6,-0.32,0.6,1.47,0.54,0.1,-0.16,-0.22,0.66,0.98,0.31,-0.37,-0.51,-0.33,0.52,1.26,0.57,0.2,-0.14,-0.13,0.25,0.56,0.11,-0.23,-0.53,-0.25,0.67,1.41,0.7,0.29,-0.14,-0.05,0.65,1.27,0.43,-0.28,-0.52,-0.4,0.68,1.41,0.54,0.07,-0.18,-0.13,0.67,1.17,0.37,-0.39,-0.63,-0.38,0.85,1.54,0.76,0.3,-0.11,-0.1,0.41,1.06,0.28,-0.48,-0.65,-0.4,0.52,1.64,0.62,0.15,-0.17,-0.12,0.78,1.21,0.68,-0.19,-0.4,-0.04,1.39,1.88,0.9,0.1,-0.35,0.01,1.02,1.21,0.51,-0.36,-0.69,-0.39,1.05,1.78,0.76,0.13,-0.18,0.08,2.16,1.39,0.65,-0.55,-0.57,0.04,2.25,1.86,0.81,0.11,-0.38,-0.14,1.54,1.18,0.26,-0.53,-0.61,-0.14,1.55,1.69,0.61,0.07,-0.25,-0.11,1.11,1.26:RUNNING
-1.91,-1.79,-3.51,-3.06,-1.53,0.31,1.13,0.0,-3.1,-2.93,-2.09,-1.89,-1.79,-3.59,-2.22,-0.65,0.93,0.92,-1.35,-3.32,-2.5,-2.01,-1.57,-2.46,-3.41,-1.99,-0.18,1.26,0.33,-2.65,-2.9,-2.15,-1.74,-1.32,-3.09,-3.06,-1.54,0.2,1.13,0.08,-3.16,-2.91,-2.13,-1.72,-1.63,-3.56,-2.76,-0.98,0.78,0.58,-2.0,-3.14,-2.26,-1.76,-1.48,-1.91,-3.27,-2.15,-0.19,1.06,0.3,-2.73,-3.17,-2.19,-1.77,-1.46,-2.71,-3.25,-1.63,0.23,0.87,-0.19,-3.26,-2.76,-1.94,-1.74,-1.37,-3.29,-2.6,-1.53,0.34,0.84,-0.75,-3.46,-2.68,-2.16,-1.85,-1.72,-3.51,-2.36,-0.64,0.8,0.44,-1.42,-3.44,-2.36,-1.83,-1.62,-2.34,-3.06,-2.07,-0.33,1.06,0.02,-2.67,-3.16,-2.09,-1.62,-1.42,-3.08,-3.13,-1.71,0.21,1.13,-0.1,-3.06,-3.17,-2.25,-1.96,-1.59,-3.26,-2.82,-1.5,0.36,1.05,-0.63,-3.38,-2.64,-1.75,-1.46,-1.27,-3.22,-2.24,-1.0,0.61,0.76,-1.09,-3.52,-2.58,-2.08,-1.63,-1.53,-3.43,-2.22,-0.8,0.85,0.65,-1.99,-3.42,-2.26,-1.8,-1.44,-1.59,-3.13,-2.16,-0.79,0.9,0.73,-1.91,-3.17,-2.03,-1.58,-1.26,-1.91,-3.02,-2.02,-0.59,0.82,0.57,-1.92,-3.32,-2.15,-1.57,-1.3,-1.72,-2.66,-1.73,-0.46,0.95,0.72,-1.73,-3.05,-1.76,-1.41,-1.21,-1.27,-2.8,-1.92,-0.76,0.69,0.87,-0.84,-3.03,-1.99,-1.41,-1.02,-0.84,-2.49,-2.58,-1.46,-0.13,0.68,0.1,-2.43,-2.47,-1.7:-1.12,-0.09,1.39,0.72,-1.04,-1.6,-1.26,-1.39,-1.84,-1.88,-2.51,-0.67,0.4,1.32,0.68,-2.13,-0.97,-1.6,-1.97,-1.82,-3.28,-1.14,-0.64,0.85,0.84,0.18,-1.9,-0.9,-1.42,-1.91,-1.3,-3.26,-0.93,-0.22,1.24,0.99,-0.39,-1.95,-1.46,-1.73,-1.91,-2.12,-2.13,-0.76,0.0,1.52,0.68,-1.62,-1.16,-1.01,-1.83,-1.32,-2.34,-1.86,-0.63,0.55,1.46,0.51,-2.13,-1.19,-1.39,-1.79,-1.82,-2.82,-1.3,-0.39,0.82,1.07,-0.02,-2.28,-1.0,-1.26,-2.02,-1.48,-3.33,-0.95,-0.22,1.23,1.13,-0.99,-1.22,-1.19,-1.49,-1.82,-1.3,-3.11,-0.89,-0.05,1.5,0.95,-1.61,-1.39,-1.21,-1.39,-1.76,-2.18,-2.01,-0.65,0.18,1.29,0.73,-2.07,-1.18,-1.21,-1.41,-1.71,-2.55,-1.92,-0.82,0.53,1.57,0.68,-2.53,-1.47,-1.13,-1.52,-1.71,-3.02,-1.41,-0.62,0.87,1.34,0.34,-2.53,-1.17,-0.97,-1.52,-1.38,-3.0,-1.28,-0.63,0.91,1.13,0.59,-1.91,-1.26,-1.13,-1.45,-1.26,-2.94,-1.21,-0.52,0.99,1.07,-0.01,-2.23,-1.12,-0.98,-1.27,-1.33,-2.81,-1.37,-0.64,0.54,1.18,0.05,-2.43,-0.97,-0.82,-1.12,-1.14,-2.19,-1.32,-0.5,-0.3,1.46,0.93,-0.96,-1.23,-0.92,-1.06,-1.18,-1.25,-1.21,-0.38,-0.32,0.52,0.82,0.46,-2.33,-1.89,-0.79,-0.51,-0.65,-0.82,-0.62,-0.38,-0.5,-0.25,-0.03,-0.03,-0.44,-0.32,-0.27,-0.21,-0.4,-0.32,0.56,0.5,-0.1,-0.27,-0.1,0.18,0.27,0.03,-0.18:0.01,-0.14,-0.24,0.79,0.24,0.58,0.27,0.28,0.46,-0.31,0.09,0.71,0.13,-0.04,0.36,0.16,0.5,0.22,0.38,-0.07,-0.05,0.12,0.53,-0.18,0.25,0.31,0.31,0.34,-0.07,0.61,-0.21,0.13,0.81,0.41,-0.14,0.37,0.07,0.44,0.13,-0.01,0.28,-0.33,0.35,0.8,-0.1,0.31,0.15,0.16,0.51,-0.14,0.44,-0.15,-0.15,0.4,0.73,-0.45,-0.13,-0.13,0.26,0.56,0.28,0.12,-0.49,-0.23,0.14,-0.05,-0.47,0.07,0.13,0.54,0.44,-0.22,-0.1,-0.75,-0.16,0.44,-0.26,-0.26,0.19,0.07,0.46,0.09,-0.19,0.06,-0.4,0.08,0.37,-0.23,0.1,0.16,0.12,0.54,-0.13,0.38,-0.43,-0.39,0.74,0.2,-0.26,0.16,-0.09,0.29,0.27,-0.46,0.4,-0.44,0.04,0.49,0.31,-0.46,0.26,0.11,0.5,0.41,-0.04,0.39,-0.44,0.1,0.86,-0.07,-0.16,-0.08,0.15,0.4,0.17,-0.02,-0.35,-0.39,0.16,0.62,-0.33,-0.09,-0.05,0.17,0.34,-0.13,-0.07,-0.44,-0.37,0.38,0.6,-0.51,-0.12,-0.14,0.21,0.37,-0.25,0.08,-0.61,-0.43,0.16,0.33,-0.6,-0.25,-0.09,0.14,0.24,-0.21,0.55,-0.46,-0.33,0.47,0.37,-0.61,-0.28,-0.2,0.26,0.04,-0.42,0.35,-0.76,-0.34,0.56,0.3,-0.66,-0.36,-0.11,0.26,0.0,-0.31,0.3,-0.62,-0.35,0.32,0.07,-0.57,-0.34,-0.15,0.27,0.13,-0.4,0.07,-0.78,-0.26,0.38,0.52,-0.83,-0.49,-0.4,0.22,0.19,-0.5,0.19,-0.7,-0.39,0.1:RUNNING
1.66,1.51,1.91,3.18,0.76,-0.63,-1.3,-1.21,-0.22,1.79,1.91,1.55,1.3,1.23,2.2,2.19,0.2,-0.54,-0.97,-0.83,-0.19,1.1,1.59,1.53,1.32,1.33,3.13,1.71,0.14,-0.54,-0.96,-0.76,1.05,1.47,1.46,1.52,1.53,1.61,2.93,0.81,-0.26,-0.8,-1.13,-0.95,1.34,1.91,1.91,1.65,1.54,2.15,2.92,0.58,-0.56,-1.09,-0.97,0.61,2.12,1.79,1.39,1.24,1.35,2.9,2.03,0.23,-0.55,-1.28,-1.07,0.34,1.78,1.73,1.44,1.28,1.49,2.9,1.83,0.06,-0.7,-1.18,-1.0,1.26,2.0,1.66,1.45,1.23,1.44,2.97,1.22,-0.17,-0.91,-1.26,-0.83,1.92,2.24,1.71,1.6,1.36,1.88,3.59,2.84,0.98,0.52,0.22,1.35,2.65,1.16,0.05,-0.29,0.13,1.79,3.19,0.86,-0.41,-0.38,0.92,3.13,3.05,1.48,0.6,0.65,2.11,2.89,1.34,-0.52,-0.91,-0.63,-0.04,1.53,1.36,1.1,0.91,0.92,1.5,1.24,-0.14,-0.6,-0.92,-0.79,-0.74,0.74,1.22,1.3,1.02,0.84,1.76,1.54,-0.03,-0.54,-0.84,-0.75,-0.36,0.9,0.88,0.94,0.87,0.9,1.9,1.08,-0.18,-0.65,-1.02,-0.81,0.11,1.53,1.34,1.26,1.06,1.0,1.89,1.39,-0.04,-0.43,-0.65,-0.7,-1.2,0.84,1.37,1.13,0.97,0.8,0.68,1.74,2.25,0.9,0.04,-0.35,-0.83,0.31,2.68,1.83,1.13,0.59,0.48,0.21,0.39,0.09,0.04,0.16,0.2,0.11,0.3,0.24,0.11,0.04,0.02,0.17,0.1:2.57,1.33,0.44,0.36,1.86,3.57,1.84,0.26,-0.58,-0.3,-0.09,2.11,2.86,0.97,0.1,0.14,1.4,3.59,2.76,0.26,-0.75,-0.56,-0.16,3.23,2.41,0.23,-0.45,-0.14,2.39,3.59,1.47,-0.22,-0.78,-0.46,0.49,3.44,1.6,0.19,-0.28,0.23,2.92,3.39,0.98,-0.35,-0.62,-0.2,1.83,3.07,1.04,-0.05,-0.33,0.47,3.36,2.73,0.44,-0.6,-0.5,0.17,3.11,1.96,0.37,-0.23,-0.22,1.41,3.59,2.15,-0.12,-0.94,-0.51,0.51,3.31,1.63,0.14,-0.15,0.11,2.76,3.31,1.13,-0.4,-0.92,-0.59,1.21,3.16,1.34,0.19,-0.02,0.58,3.18,3.17,0.94,-0.43,-0.71,-0.29,1.88,3.22,1.26,0.01,-0.37,0.59,3.51,2.77,0.38,-0.68,-0.62,-0.25,2.66,2.82,0.78,-0.22,-0.27,1.2,3.59,2.35,0.26,-1.0,-0.68,-0.09,1.49,1.94,2.23,0.92,1.79,1.84,0.33,-0.78,-0.89,-0.87,-0.22,0.67,0.48,0.58,0.91,1.35,1.55,1.04,-0.08,-1.26,-1.26,-0.81,0.25,2.12,1.49,-0.08,-0.34,-0.12,2.43,3.32,1.0,-0.16,-0.67,-0.45,1.32,3.43,1.1,-0.2,-0.34,-0.22,2.07,3.41,1.3,-0.03,-0.64,-0.42,1.49,3.1,1.13,-0.09,-0.45,-0.28,2.54,2.75,0.84,-0.16,-0.49,-0.06,2.08,2.01,0.71,-0.05,-0.28,0.16,2.73,3.13,1.02,-0.14,-0.77,-0.53,1.39,3.52,1.3,0.18,-0.26,-0.32,0.92,3.59,1.96,0.41,-0.36,-0.61,-0.48,0.89,3.08,2.17,0.9,0.16,-0.22:-0.67,-0.28,0.61,0.48,0.3,0.28,-0.85,-0.77,-0.14,-0.19,-0.28,-0.88,-0.96,-0.07,0.42,0.4,0.18,0.15,-1.0,-0.44,-0.17,-0.39,-0.45,-1.12,-0.81,0.06,0.46,0.26,0.06,-0.4,-0.93,-0.35,-0.36,-0.5,-0.38,-0.82,-0.74,0.25,0.33,0.05,-0.31,-1.39,-0.9,-0.43,-0.33,-0.37,-0.66,-0.52,-0.17,0.53,0.32,0.19,-0.06,-0.96,-0.63,-0.24,-0.46,-0.51,-0.74,-0.49,0.2,0.57,0.23,0.26,0.13,-0.82,-0.35,-0.25,-0.51,-0.53,-1.0,-0.67,0.17,0.44,0.25,0.25,-0.32,-0.86,-0.49,-0.48,-0.51,-0.57,-1.0,0.03,0.66,0.51,0.26,0.37,-0.56,-0.78,-0.24,-0.33,-0.38,-0.68,-1.07,-0.39,0.05,0.69,0.28,0.37,0.68,1.0,1.2,0.36,-0.56,0.83,2.08,2.05,1.1,0.87,0.91,1.35,-0.77,0.29,0.63,0.54,0.63,1.14,1.13,0.76,0.31,0.19,0.54,-0.16,-0.26,-0.2,-0.19,-0.3,-0.77,-0.67,0.02,0.11,0.35,0.27,-0.28,-1.07,-0.54,-0.14,-0.22,0.04,-0.8,-1.13,-0.39,0.18,0.21,0.06,-0.74,-1.26,-0.59,-0.23,-0.24,-0.11,-1.58,-1.39,-0.52,-0.04,0.25,0.02,-1.33,-1.6,-0.77,-0.41,-0.31,-0.06,-1.23,-0.95,-0.33,0.15,0.21,0.12,-0.76,-0.82,-0.43,-0.16,-0.31,-0.18,-0.33,-0.9,-0.56,-0.08,0.17,0.25,0.15,-0.34,-0.49,-0.57,-0.31,-0.2,0.13,-1.22,-0.53,-0.61,-0.12,0.11,0.06,-0.31,-0.86,-1.1,-0.89,-0.72,-0.53,-0.58,-1.02,-1.19,-1.11,-1.02:RUNNING
2.36,3.43,0.85,-1.02,-1.21,-0.73,0.6,1.55,0.92,0.61,0.78,1.61,3.55,1.79,-0.31,-0.95,-0.72,-0.06,1.32,1.49,0.89,0.58,0.92,2.64,2.61,0.73,-0.67,-0.89,-0.69,0.07,1.45,1.27,0.64,0.44,1.08,3.0,2.52,0.62,-0.65,-0.73,-0.32,0.98,1.64,1.29,0.8,0.58,1.23,3.34,2.82,0.38,-1.06,-0.89,0.1,1.52,1.51,0.68,0.33,0.63,1.67,3.28,1.72,-0.1,-0.66,-0.46,-0.07,0.75,1.13,0.74,0.47,0.78,2.01,3.24,1.45,-0.35,-0.82,-0.44,0.08,1.46,1.55,0.86,0.47,0.76,1.66,2.97,1.5,0.06,-0.53,-0.4,-0.09,1.2,1.5,0.9,0.61,0.85,2.26,3.59,1.49,-0.28,-0.63,-0.28,0.42,1.74,1.46,0.73,0.5,1.0,2.48,2.52,0.81,-0.39,-0.57,-0.3,0.35,1.65,1.39,0.71,0.35,0.73,1.92,3.0,1.22,-0.31,-0.64,-0.29,0.13,1.58,1.58,0.78,0.38,0.66,1.67,3.19,1.65,-0.2,-0.69,-0.35,0.14,1.13,1.39,0.89,0.49,0.55,1.18,2.8,2.16,0.39,-0.62,-0.62,-0.23,0.56,1.41,1.22,0.64,0.34,0.61,1.49,3.0,1.69,0.04,-0.73,-0.46,0.05,0.93,1.48,1.05,0.65,0.41,0.55,1.44,2.68,1.66,0.4,-0.39,-0.57,-0.18,1.0,1.57,1.13,0.62,0.23,0.46,0.81,1.05,0.72,0.37,0.09,0.12,0.36,0.76,0.66,0.81,0.6,0.55,0.69,1.0,0.94,0.82,0.78,0.83,0.87,0.93,0.89,0.83,0.81,0.91,0.86:-0.89,0.79,1.04,0.58,-2.08,-2.27,-1.32,-0.62,-0.67,-1.88,-3.15,-1.88,0.08,1.08,0.87,-0.81,-2.53,-1.75,-0.98,-0.47,-0.85,-2.5,-2.92,-1.19,0.39,1.02,0.74,-1.0,-1.98,-1.53,-0.93,-0.77,-1.28,-2.94,-2.86,-1.25,0.48,1.38,1.22,-0.94,-2.54,-1.77,-0.98,-1.16,-1.86,-2.6,-1.79,-0.45,0.59,0.97,0.58,-1.79,-2.08,-1.34,-0.84,-0.85,-1.3,-2.63,-2.12,-0.44,0.79,1.06,0.18,-2.12,-2.09,-1.4,-1.0,-0.95,-1.51,-2.86,-2.02,-0.28,1.17,1.06,0.28,-1.9,-1.84,-1.25,-0.87,-0.84,-0.99,-2.44,-2.26,-0.7,0.71,1.48,0.64,-2.2,-2.17,-1.4,-0.89,-0.81,-1.77,-2.4,-1.25,0.06,0.98,0.95,-0.56,-1.91,-1.61,-1.07,-0.77,-0.76,-1.85,-2.66,-1.49,0.06,0.93,0.93,0.1,-2.03,-1.82,-1.19,-0.85,-0.99,-1.51,-2.74,-1.77,-0.2,1.02,1.0,0.37,-1.83,-1.86,-1.26,-0.8,-0.82,-1.32,-2.43,-2.16,-0.65,0.55,0.75,0.59,-1.54,-1.98,-1.53,-0.83,-0.47,-0.78,-2.04,-2.6,-1.47,-0.19,0.72,0.75,0.36,-1.92,-1.91,-1.26,-0.72,-0.63,-1.0,-2.32,-2.39,-1.1,0.07,0.7,0.64,-0.15,-1.84,-1.73,-1.2,-0.77,-0.55,-0.79,-2.1,-2.28,-1.26,-0.41,-0.03,-0.36,-0.97,-0.22,-0.27,-0.21,0.1,-0.03,-0.15,-0.32,-0.26,-0.13,-0.04,-0.16,-0.11,-0.38,-0.32,-0.26,-0.19,-0.27,-0.26,-0.22,-0.2,-0.21,-0.16,-0.17,-0.17,-0.22,-0.22,-0.26,-0.3,-0.3,-0.28,-0.31,-0.31:0.56,0.62,0.2,-0.25,-0.39,-0.55,-0.22,0.39,0.52,0.62,0.65,0.59,0.73,0.05,0.16,-0.11,-0.18,-0.31,-0.08,0.37,0.49,0.49,0.57,0.38,0.78,0.36,0.13,-0.17,-0.44,-0.56,-0.15,0.3,0.64,0.87,0.97,0.66,0.63,0.42,0.2,0.03,-0.21,-0.25,0.07,0.36,0.58,0.74,0.75,0.52,0.4,0.26,0.09,0.01,-0.08,-0.19,-0.09,0.06,0.25,0.47,0.67,0.67,0.67,0.31,0.03,-0.21,-0.48,-0.3,0.3,0.55,0.65,0.73,0.65,0.52,0.46,0.34,0.05,-0.12,-0.18,-0.03,0.25,0.17,0.16,0.49,0.81,0.94,1.04,0.46,0.06,-0.06,-0.16,0.32,0.84,0.63,0.34,0.25,0.21,1.11,0.81,0.59,-0.09,-0.28,-0.27,0.22,0.64,0.46,0.39,0.43,0.44,0.71,0.71,0.59,0.13,-0.04,-0.19,0.13,0.7,0.64,0.43,0.51,0.54,0.68,0.65,0.37,-0.04,-0.25,-0.33,-0.11,0.2,0.29,0.36,0.42,0.49,0.5,0.47,0.22,0.07,-0.16,-0.25,-0.27,-0.12,0.07,0.14,0.24,0.52,0.57,0.5,0.27,0.14,0.02,-0.16,-0.31,-0.34,-0.12,0.19,0.15,0.3,0.43,0.34,0.4,0.08,0.09,0.04,-0.09,-0.21,-0.15,0.17,0.3,0.24,0.08,-0.17,-0.21,-0.52,-0.85,-0.99,-0.88,-0.57,-0.51,-0.67,-1.1,-1.14,-0.9,-0.67,-0.57,-0.62,-0.75,-0.75,-0.71,-0.57,-0.43,-0.37,-0.42,-0.45,-0.48,-0.53,-0.58,-0.63,-0.61,-0.66,-0.7,-0.7,-0.65,-0.64,-0.66,-0.68,-0.6,-0.46,-0.54:RUNNING
0.97,1.01,0.52,-1.54,-2.15,-1.57,-1.05,-0.95,-1.91,-1.86,-0.1,0.69,0.75,0.65,-0.56,-1.73,-1.53,-1.07,-0.82,-1.07,-2.86,-1.79,0.37,1.01,0.99,0.22,-1.52,-2.18,-1.6,-1.13,-1.12,-2.67,-1.85,0.13,1.06,1.26,0.76,-1.18,-2.32,-1.82,-1.18,-1.06,-1.9,-2.0,-0.36,0.61,1.19,1.04,-0.11,-1.7,-1.66,-1.12,-0.91,-1.22,-1.82,-0.48,0.57,0.79,0.92,0.47,-0.92,-1.45,-1.17,-0.92,-1.07,-2.25,-1.2,0.32,0.79,0.9,0.29,-1.23,-1.58,-1.16,-0.84,-0.87,-1.95,-1.52,-0.03,0.65,0.85,0.67,-0.71,-1.53,-1.33,-0.97,-0.77,-0.89,-2.01,-0.83,0.3,0.81,0.94,0.24,-1.36,-1.6,-1.13,-0.8,-0.75,-1.94,-1.46,-0.13,0.65,0.94,0.77,-0.53,-1.34,-1.09,-0.71,-0.64,-1.17,-2.03,-0.73,0.53,0.93,0.91,-0.18,-1.37,-1.39,-1.01,-0.75,-0.75,-1.98,-1.29,0.08,0.75,0.9,0.68,-0.89,-1.46,-1.14,-0.8,-0.69,-1.24,-2.04,-0.6,0.49,0.9,0.92,-0.22,-1.64,-1.65,-1.17,-0.78,-0.66,-1.51,-1.24,-0.1,0.36,0.7,0.76,-0.28,-1.12,-1.13,-0.89,-0.65,-0.69,-1.65,-0.87,0.26,0.73,0.92,0.66,-0.49,-1.11,-1.05,-0.65,-0.37,-0.28,-0.36,-0.26,-0.1,0.05,0.13,0.35,0.09,0.11,-0.1,-0.27,-0.18,-0.11,-0.13,-0.34,-0.2,0.07,-0.1,0.05,0.04,0.16,-0.04,-0.22,-0.17,0.08,0.04,-0.01,0.0,0.0,-0.01,0.04,0.05,0.08,0.02,-0.05,0.01,0.02,-0.07:0.7,-2.13,-2.58,-1.27,-0.47,-0.13,-1.13,-3.45,-2.0,0.21,1.19,0.87,-1.0,-3.0,-1.79,-0.67,-0.2,-0.25,-2.78,-3.0,-0.74,0.73,1.06,0.72,-1.78,-2.79,-1.62,-0.69,-0.28,-1.8,-3.59,-1.66,0.75,1.24,0.77,-1.52,-2.95,-1.66,-0.66,-0.14,-1.27,-3.52,-2.18,0.23,1.14,0.83,-0.71,-3.06,-1.91,-0.83,-0.27,-0.29,-2.74,-3.13,-0.87,0.69,0.95,0.24,-2.86,-2.23,-0.98,-0.15,0.08,-1.72,-3.34,-1.35,0.55,1.01,0.74,-2.24,-2.55,-1.23,-0.35,-0.07,-1.63,-3.33,-1.62,0.3,1.13,0.8,-1.52,-2.74,-1.45,-0.54,-0.13,-0.56,-3.13,-2.47,-0.4,0.76,0.86,0.4,-2.69,-2.12,-1.09,-0.44,-0.18,-1.8,-3.22,-1.45,0.33,0.97,0.7,-1.55,-2.76,-1.48,-0.64,-0.16,-0.35,-3.07,-2.23,-0.22,0.78,0.73,0.01,-2.89,-2.1,-0.94,-0.21,-0.04,-2.41,-3.03,-1.05,0.34,0.86,0.64,-1.89,-2.83,-1.49,-0.46,-0.02,-0.44,-3.13,-2.17,-0.26,0.84,0.82,-0.07,-2.91,-2.05,-0.9,-0.18,0.03,-2.33,-2.99,-1.16,0.28,0.91,0.76,-1.34,-2.89,-1.61,-0.66,0.01,0.03,-2.59,-2.75,-1.12,0.15,0.85,0.62,-2.16,-2.55,-1.49,-0.62,-0.05,-1.24,-2.9,-2.41,-1.16,-0.16,0.04,-0.31,-0.26,-0.52,-0.59,-0.37,-0.07,-0.04,-0.68,-0.77,-0.52,-0.04,0.09,0.02,0.03,-0.06,-0.14,0.01,0.02,0.0,0.04,0.01,-0.17,-0.35,-0.01,-0.16,-0.17,-0.3,-0.23,-0.21,-0.25,-0.19,-0.17,-0.13,-0.13:0.98,0.33,0.02,-0.03,0.22,1.12,1.14,0.63,0.27,0.32,0.84,0.93,0.37,-0.12,-0.28,-0.19,0.7,1.13,0.86,0.35,0.19,0.35,1.52,1.2,0.47,0.23,0.21,0.58,1.52,1.36,0.63,0.23,0.35,1.38,1.14,0.47,0.02,0.08,0.59,1.79,1.69,0.71,0.14,0.38,0.83,1.27,0.65,0.21,0.15,0.17,1.08,1.5,0.97,0.44,0.36,0.54,1.27,0.78,0.23,-0.08,-0.17,0.4,1.34,1.06,0.36,0.22,0.44,1.52,1.1,0.25,-0.06,-0.12,0.5,1.63,1.24,0.48,0.22,0.28,1.1,1.07,0.39,-0.05,-0.1,0.16,1.58,1.4,0.64,0.17,0.12,0.33,1.38,0.94,0.36,-0.08,-0.22,0.44,1.41,1.07,0.38,0.11,0.14,1.13,1.19,0.56,0.1,-0.01,0.11,1.37,1.19,0.4,0.06,0.22,0.61,1.46,0.6,-0.01,-0.15,-0.03,0.77,1.26,0.82,0.33,0.21,0.17,0.99,0.8,0.25,-0.03,-0.14,-0.05,0.97,0.98,0.44,0.17,0.21,0.49,0.94,0.53,0.08,-0.11,-0.12,0.68,1.28,0.92,0.39,0.17,0.11,0.89,0.91,0.18,-0.14,-0.2,-0.09,1.1,1.19,0.68,0.21,0.09,0.08,0.79,0.66,0.19,-0.1,-0.1,0.14,0.44,0.07,0.1,0.21,0.11,-0.47,-1.12,-1.2,-0.92,-0.66,-0.47,-0.76,-1.09,-1.27,-1.2,-0.87,-0.75,-0.82,-1.01,-1.3,-1.32,-0.9,-0.57,-0.69,-1.02,-1.21,-1.13,-1.14,-0.94,-0.8,-0.9,-0.96,-0.97,-0.98,-1.01,-0.99,-0.93,-0.89,-0.94,-1.05,-1.07:RUNNING
-0.57,-0.16,2.21,2.71,1.44,0.73,0.82,1.32,2.91,2.0,0.34,-0.7,-0.83,-0.05,2.34,2.49,1.23,0.8,1.06,2.07,2.83,0.87,-0.32,-0.75,-0.75,0.58,2.46,1.95,1.23,0.86,0.95,2.38,2.13,0.34,-0.53,-0.99,-0.82,1.13,2.39,1.56,0.88,0.8,1.26,2.85,1.13,-0.36,-1.04,-1.21,1.11,2.83,2.07,1.17,0.76,1.0,2.4,1.94,0.24,-0.58,-0.79,-0.6,1.07,2.12,1.51,0.9,0.74,0.89,2.71,1.38,-0.17,-0.85,-1.12,-0.56,1.38,2.13,1.51,1.05,0.89,1.61,2.62,0.85,-0.21,-0.92,-1.19,-0.48,1.5,1.94,1.27,0.9,1.12,2.56,1.61,0.26,-0.48,-1.14,-1.08,0.32,1.79,1.46,1.09,0.95,1.23,2.73,1.11,-0.19,-0.72,-1.14,-0.57,1.57,1.92,1.34,1.02,1.09,2.15,2.27,0.34,-0.82,-1.09,-0.76,0.83,2.24,1.65,1.01,0.97,1.35,2.94,1.36,-0.18,-0.93,-1.25,-0.35,2.04,2.53,1.44,1.0,1.0,2.22,2.19,0.51,-0.5,-1.21,-0.91,1.02,2.16,1.51,1.08,1.19,2.22,2.62,0.41,-0.73,-1.08,-0.9,0.74,2.39,1.78,1.41,1.29,1.75,2.99,1.19,-0.12,-0.69,-0.91,-0.31,1.71,2.02,1.41,0.98,1.01,1.79,2.73,0.97,-0.21,-0.82,-0.96,0.24,2.13,1.94,1.22,0.8,0.75,2.22,2.25,0.34,-0.51,-0.94,-0.79,0.66,2.36,1.95,1.2,0.83,1.06,2.4,2.51,0.7,-0.19,-0.82,-0.99,0.1,2.09,2.2,0.91,0.68,0.8,2.6:0.38,0.36,0.42,0.61,0.92,1.54,0.9,-0.33,-0.88,-1.21,-0.85,1.01,1.62,1.23,0.91,0.7,1.18,2.9,1.82,-0.51,-1.18,-1.0,-0.48,1.58,2.05,1.37,0.78,0.68,1.64,3.06,1.38,-0.72,-1.13,-0.74,0.37,2.47,1.73,0.79,0.43,0.78,2.53,2.75,0.69,-0.65,-1.01,-0.73,1.31,2.62,1.44,0.58,0.21,0.82,2.77,2.31,0.14,-0.89,-0.88,-0.27,2.27,1.98,0.96,0.49,0.73,2.58,2.62,0.58,-0.63,-0.9,-0.63,1.43,2.56,1.53,0.65,0.22,0.55,2.67,2.18,0.0,-0.87,-0.71,-0.38,2.05,2.43,1.2,0.52,0.3,1.63,3.05,1.85,0.03,-0.86,-0.73,0.27,2.58,2.3,1.17,0.55,0.35,2.06,3.1,1.18,-0.55,-0.86,-0.45,1.77,2.73,1.67,0.69,0.27,0.69,2.75,2.37,0.35,-0.56,-0.72,-0.25,2.28,2.24,1.16,0.55,0.25,1.87,3.08,1.01,-0.47,-0.84,-0.53,0.93,2.75,1.66,0.75,0.3,0.79,2.78,2.24,0.0,-0.98,-0.79,-0.23,2.18,2.14,1.15,0.53,0.45,1.95,3.12,1.42,-0.27,-1.06,-0.81,1.35,2.67,1.58,0.64,0.22,1.11,2.9,1.93,-0.4,-1.2,-0.72,0.83,2.77,1.69,0.68,0.37,0.93,2.8,2.59,-0.12,-1.06,-0.81,0.17,2.54,2.06,0.98,0.57,0.42,1.93,3.11,1.37,-0.39,-0.98,-0.7,0.54,2.7,1.79,0.82,0.51,0.52,2.46,2.68,0.5,-0.7,-0.95,-0.61,1.23,2.57,1.56,0.77,0.42,0.62,2.63,2.78,0.62,-0.59:-0.15,-0.28,-0.32,0.14,1.12,1.0,0.72,0.49,0.55,0.33,0.1,-0.15,-0.13,-0.15,-0.1,0.35,0.74,0.53,0.45,0.45,0.55,0.13,0.07,-0.05,0.03,0.08,0.11,0.4,0.44,0.59,0.58,0.45,-0.15,-0.42,-0.28,-0.18,-0.4,-0.59,-0.22,0.43,0.6,0.62,0.5,0.36,-0.06,-0.06,0.0,0.09,0.08,0.02,0.32,0.59,0.5,0.43,0.46,0.54,0.14,0.08,0.11,0.29,0.21,0.43,0.58,0.48,0.73,0.52,0.38,0.02,-0.13,0.03,0.17,0.28,0.16,0.36,0.46,0.41,0.5,0.55,0.36,-0.03,-0.06,-0.02,-0.08,0.05,0.06,0.43,0.53,0.57,0.47,0.45,0.2,0.06,0.08,0.11,0.11,0.13,0.5,1.0,0.68,0.66,0.47,0.53,0.31,0.11,-0.16,-0.09,0.0,0.43,0.95,0.73,0.61,0.55,0.41,0.29,0.08,0.13,0.36,0.41,0.33,0.36,0.61,0.49,0.68,0.53,0.45,0.32,0.13,0.07,-0.01,-0.04,0.21,0.41,0.74,0.96,0.68,0.48,0.01,-0.13,-0.1,-0.08,0.0,0.06,0.17,0.86,0.68,0.75,0.55,0.12,-0.04,-0.06,-0.11,-0.15,-0.14,0.41,0.95,0.9,0.7,0.53,0.59,0.41,0.17,0.05,0.0,0.02,0.5,0.86,0.95,0.65,0.5,0.37,0.64,0.15,0.18,0.04,0.07,0.11,0.53,0.75,0.79,0.54,0.41,0.29,0.33,0.0,0.06,-0.04,0.1,0.22,-0.13,-0.04,0.22,0.32,0.31,0.25,0.2,0.19,-0.03,-0.19,-0.08,0.05,0.2,0.96,1.06,0.86,0.59,0.39:RUNNING
0.52,-0.99,-1.1,-0.39,0.61,1.38,1.08,0.81,1.13,2.36,3.43,0.85,-1.02,-1.21,-0.73,0.6,1.55,0.92,0.61,0.78,1.61,3.55,1.79,-0.31,-0.95,-0.72,-0.06,1.32,1.49,0.89,0.58,0.92,2.64,2.61,0.73,-0.67,-0.89,-0.69,0.07,1.45,1.27,0.64,0.44,1.08,3.0,2.52,0.62,-0.65,-0.73,-0.32,0.98,1.64,1.29,0.8,0.58,1.23,3.34,2.82,0.38,-1.06,-0.89,0.1,1.52,1.51,0.68,0.33,0.63,1.67,3.28,1.72,-0.1,-0.66,-0.46,-0.07,0.75,1.13,0.74,0.47,0.78,2.01,3.24,1.45,-0.35,-0.82,-0.44,0.08,1.46,1.55,0.86,0.47,0.76,1.66,2.97,1.5,0.06,-0.53,-0.4,-0.09,1.2,1.5,0.9,0.61,0.85,2.26,3.59,1.49,-0.28,-0.63,-0.28,0.42,1.74,1.46,0.73,0.5,1.0,2.48,2.52,0.81,-0.39,-0.57,-0.3,0.35,1.65,1.39,0.71,0.35,0.73,1.92,3.0,1.22,-0.31,-0.64,-0.29,0.13,1.58,1.58,0.78,0.38,0.66,1.67,3.19,1.65,-0.2,-0.69,-0.35,0.14,1.13,1.39,0.89,0.49,0.55,1.18,2.8,2.16,0.39,-0.62,-0.62,-0.23,0.56,1.41,1.22,0.64,0.34,0.61,1.49,3.0,1.69,0.04,-0.73,-0.46,0.05,0.93,1.48,1.05,0.65,0.41,0.55,1.44,2.68,1.66,0.4,-0.39,-0.57,-0.18,1.0,1.57,1.13,0.62,0.23,0.46,0.81,1.05,0.72,0.37,0.09,0.12,0.36,0.76,0.66,0.81,0.6,0.55,0.69,1.0,0.94,0.82:-0.74,-2.34,-1.72,-0.9,-0.65,-1.48,-3.3,-2.88,-0.63,1.04,1.14,0.02,-3.04,-2.14,-0.87,-0.43,-0.98,-3.17,-2.73,-0.89,0.79,1.04,0.58,-2.08,-2.27,-1.32,-0.62,-0.67,-1.88,-3.15,-1.88,0.08,1.08,0.87,-0.81,-2.53,-1.75,-0.98,-0.47,-0.85,-2.5,-2.92,-1.19,0.39,1.02,0.74,-1.0,-1.98,-1.53,-0.93,-0.77,-1.28,-2.94,-2.86,-1.25,0.48,1.38,1.22,-0.94,-2.54,-1.77,-0.98,-1.16,-1.86,-2.6,-1.79,-0.45,0.59,0.97,0.58,-1.79,-2.08,-1.34,-0.84,-0.85,-1.3,-2.63,-2.12,-0.44,0.79,1.06,0.18,-2.12,-2.09,-1.4,-1.0,-0.95,-1.51,-2.86,-2.02,-0.28,1.17,1.06,0.28,-1.9,-1.84,-1.25,-0.87,-0.84,-0.99,-2.44,-2.26,-0.7,0.71,1.48,0.64,-2.2,-2.17,-1.4,-0.89,-0.81,-1.77,-2.4,-1.25,0.06,0.98,0.95,-0.56,-1.91,-1.61,-1.07,-0.77,-0.76,-1.85,-2.66,-1.49,0.06,0.93,0.93,0.1,-2.03,-1.82,-1.19,-0.85,-0.99,-1.51,-2.74,-1.77,-0.2,1.02,1.0,0.37,-1.83,-1.86,-1.26,-0.8,-0.82,-1.32,-2.43,-2.16,-0.65,0.55,0.75,0.59,-1.54,-1.98,-1.53,-0.83,-0.47,-0.78,-2.04,-2.6,-1.47,-0.19,0.72,0.75,0.36,-1.92,-1.91,-1.26,-0.72,-0.63,-1.0,-2.32,-2.39,-1.1,0.07,0.7,0.64,-0.15,-1.84,-1.73,-1.2,-0.77,-0.55,-0.79,-2.1,-2.28,-1.26,-0.41,-0.03,-0.36,-0.97,-0.22,-0.27,-0.21,0.1,-0.03,-0.15,-0.32,-0.26,-0.13,-0.04,-0.16,-0.11,-0.38:0.36,0.84,0.87,0.56,0.62,0.2,-0.25,-0.39,-0.55,-0.22,0.39,0.52,0.62,0.65,0.59,0.73,0.05,0.16,-0.11,-0.18,-0.31,-0.08,0.37,0.49,0.49,0.57,0.38,0.78,0.36,0.13,-0.17,-0.44,-0.56,-0.15,0.3,0.64,0.87,0.97,0.66,0.63,0.42,0.2,0.03,-0.21,-0.25,0.07,0.36,0.58,0.74,0.75,0.52,0.4,0.26,0.09,0.01,-0.08,-0.19,-0.09,0.06,0.25,0.47,0.67,0.67,0.67,0.31,0.03,-0.21,-0.48,-0.3,0.3,0.55,0.65,0.73,0.65,0.52,0.46,0.34,0.05,-0.12,-0.18,-0.03,0.25,0.17,0.16,0.49,0.81,0.94,1.04,0.46,0.06,-0.06,-0.16,0.32,0.84,0.63,0.34,0.25,0.21,1.11,0.81,0.59,-0.09,-0.28,-0.27,0.22,0.64,0.46,0.39,0.43,0.44,0.71,0.71,0.59,0.13,-0.04,-0.19,0.13,0.7,0.64,0.43,0.51,0.54,0.68,0.65,0.37,-0.04,-0.25,-0.33,-0.11,0.2,0.29,0.36,0.42,0.49,0.5,0.47,0.22,0.07,-0.16,-0.25,-0.27,-0.12,0.07,0.14,0.24,0.52,0.57,0.5,0.27,0.14,0.02,-0.16,-0.31,-0.34,-0.12,0.19,0.15,0.3,0.43,0.34,0.4,0.08,0.09,0.04,-0.09,-0.21,-0.15,0.17,0.3,0.24,0.08,-0.17,-0.21,-0.52,-0.85,-0.99,-0.88,-0.57,-0.51,-0.67,-1.1,-1.14,-0.9,-0.67,-0.57,-0.62,-0.75,-0.75,-0.71,-0.57,-0.43,-0.37,-0.42,-0.45,-0.48,-0.53,-0.58,-0.63,-0.61,-0.66,-0.7,-0.7,-0.65,-0.64,-0.66,-0.68:RUNNING
-0.98,-1.01,-1.11,-0.8,-0.32,-0.27,-0.79,-1.38,-1.66,-1.57,-1.33,-1.26,-1.85,-2.07,-2.86,-1.72,0.19,1.46,1.01,-0.74,-3.17,-3.28,-2.3,-1.49,-1.05,-1.36,-3.23,-1.86,-0.2,0.97,1.11,0.62,-1.17,-2.17,-1.78,-1.47,-1.14,-1.1,-2.8,-1.58,-0.12,0.68,1.09,0.82,-0.71,-1.61,-1.36,-1.0,-0.8,-0.96,-2.79,-1.44,-0.02,0.59,0.84,0.79,-0.47,-1.02,-1.05,-1.16,-1.04,-1.25,-2.38,-0.62,0.29,0.75,0.9,0.82,-0.48,-1.04,-1.0,-0.98,-0.81,-1.13,-2.23,-0.51,0.26,0.69,0.83,0.91,-0.53,-0.93,-0.87,-1.04,-1.12,-1.6,-2.03,-0.32,0.46,0.78,0.71,0.39,-0.73,-0.86,-0.84,-0.93,-1.04,-2.01,-1.1,0.29,0.57,1.08,0.93,-0.11,-1.07,-1.11,-1.17,-0.98,-1.11,-2.41,-0.96,0.22,0.81,0.96,0.76,-0.9,-1.42,-1.16,-1.02,-0.82,-0.94,-2.45,-0.7,0.18,0.66,0.84,0.96,-0.53,-0.82,-0.86,-1.13,-1.0,-1.39,-3.18,-0.97,0.32,0.94,1.05,0.75,-1.44,-1.49,-1.24,-1.1,-1.05,-1.65,-1.89,-0.31,0.56,1.11,1.0,-0.35,-1.66,-1.57,-1.16,-1.11,-1.21,-2.02,-1.78,-0.14,0.67,1.04,0.82,-0.12,-1.21,-1.2,-1.12,-1.04,-1.12,-2.38,-1.29,0.17,0.94,1.09,0.4,-0.52,-1.0,-1.05,-1.24,-1.51,-1.64,-2.76,-1.02,0.26,0.79,1.07,0.76,-0.91,-1.48,-1.21,-1.1,-1.0,-1.28,-2.75,-1.32,0.0,0.62,1.0,0.93,-0.48,-1.47,-1.32,-1.26,-1.3,-1.47,-2.38,-1.64:-1.41,-2.72,-3.59,-1.94,-0.07,0.98,0.7,0.38,-2.27,-2.82,-1.26,-0.38,-0.22,-0.74,-3.2,-3.05,-1.04,0.64,0.91,0.45,-1.94,-2.66,-1.1,-0.3,-0.08,-0.35,-3.11,-2.78,-0.58,0.61,0.68,0.47,-2.32,-2.69,-0.79,0.16,0.06,-0.19,-3.08,-2.75,-0.6,0.57,0.61,0.2,-2.97,-2.37,-0.6,-0.18,0.01,-0.4,-3.27,-2.47,-0.44,0.66,0.55,0.13,-3.08,-2.24,-0.45,0.15,0.04,-0.88,-3.36,-2.09,-0.28,0.65,0.53,-0.81,-3.19,-1.74,-0.19,0.12,0.03,-2.27,-3.27,-1.36,0.15,0.56,0.45,-2.0,-3.04,-1.12,-0.03,0.02,-0.25,-2.83,-3.03,-1.1,0.32,0.58,0.38,-2.36,-2.81,-0.82,0.13,0.35,-0.18,-3.18,-2.75,-0.82,0.5,0.63,0.41,-2.38,-2.85,-0.71,0.4,0.4,-0.74,-3.26,-2.43,-0.4,0.47,0.45,0.0,-3.05,-2.32,-0.78,-0.07,0.14,-1.32,-3.5,-2.1,-0.21,0.77,0.6,-0.67,-2.78,-1.49,-0.82,-0.62,-0.53,-2.73,-3.15,-1.17,0.32,0.68,0.6,-1.7,-3.01,-1.67,-0.66,-0.23,-0.05,-2.81,-2.89,-1.02,0.17,0.6,0.46,-1.98,-2.77,-1.47,-0.71,-0.62,-1.63,-3.56,-2.57,-0.42,0.58,0.46,0.06,-2.91,-2.86,-1.6,-0.77,-0.37,-0.87,-3.23,-2.57,-0.46,0.36,0.59,0.39,-2.33,-2.65,-1.32,-0.29,-0.15,-0.67,-3.41,-2.96,-1.02,0.32,0.59,0.28,-1.65,-3.46,-1.82,-0.79,-0.33,-0.49,-3.16,-2.96,-0.97,0.27,0.69,0.58,-1.13,-3.35,-1.72,-0.53,-0.23,-0.06,-1.72,-3.51:0.0,0.49,0.44,0.28,0.03,0.04,0.08,0.75,0.13,-0.06,-0.43,-0.39,0.09,1.01,0.72,0.4,0.12,-0.04,0.07,0.87,0.15,-0.05,-0.35,-0.51,0.22,0.63,0.49,0.17,-0.08,0.07,0.26,0.75,0.32,-0.4,-0.54,-0.42,0.36,0.92,0.53,0.3,0.01,0.08,0.48,0.32,0.05,-0.3,-0.5,-0.09,0.62,0.81,0.4,0.31,0.01,0.03,0.66,0.32,0.05,-0.56,-0.44,-0.04,0.93,0.7,0.36,0.21,-0.05,-0.05,0.67,-0.02,0.05,-0.19,-0.35,0.27,0.51,0.13,0.19,-0.02,-0.05,0.2,0.82,0.08,-0.28,-0.6,-0.39,0.18,1.21,0.59,0.42,0.08,-0.03,0.18,0.33,0.23,-0.11,-0.29,0.07,1.22,1.24,0.81,0.39,0.03,0.12,0.41,0.57,0.16,-0.23,-0.43,-0.22,0.24,0.64,0.17,0.18,0.05,0.1,0.84,0.54,0.16,-0.48,-0.14,0.59,1.54,1.0,0.5,0.05,0.28,0.18,0.86,0.35,-0.01,-0.41,-0.45,0.23,1.05,0.77,0.56,0.09,-0.05,0.07,0.79,0.4,-0.03,-0.29,-0.46,0.25,1.4,1.25,0.54,0.28,0.12,0.15,0.87,0.94,0.26,-0.34,-0.33,0.13,1.29,0.97,0.53,0.16,-0.01,0.05,0.52,0.75,0.29,-0.35,-0.52,-0.35,0.24,1.05,0.58,0.25,0.02,-0.06,0.02,1.17,0.39,0.14,-0.23,-0.46,-0.27,-0.19,1.11,0.97,0.66,0.2,-0.16,-0.07,0.07,0.18,0.17,0.07,0.16,0.33,0.42,0.64,0.47,0.36,0.2,0.19,0.32,0.35,0.22,0.21,0.19,0.14,0.07:RUNNING
1.53,1.27,0.8,0.96,1.49,3.2,1.97,0.09,-0.9,-0.66,-0.21,1.02,1.66,1.08,0.53,0.33,1.21,3.22,2.0,0.04,-1.08,-0.8,-0.14,1.01,1.47,0.82,0.31,0.42,1.24,3.0,2.03,0.43,-0.71,-0.54,-0.22,1.19,1.64,1.05,0.48,0.6,1.39,3.35,2.33,0.16,-0.8,-0.6,-0.28,1.18,1.95,1.16,0.6,0.38,0.97,2.94,2.84,0.44,-1.27,-1.0,-0.32,0.84,1.45,0.92,0.44,0.48,1.45,2.97,1.94,-0.01,-1.1,-0.71,-0.13,1.08,1.44,0.85,0.43,0.57,1.48,2.98,1.66,-0.07,-0.68,-0.48,-0.17,0.86,1.21,0.83,0.4,0.44,1.33,2.93,1.75,0.01,-0.81,-0.55,-0.09,0.84,1.28,0.85,0.48,0.54,1.13,2.59,2.36,0.89,-0.52,-0.7,-0.25,0.65,1.45,1.12,0.53,0.36,1.16,2.81,2.47,0.6,-0.64,-0.52,-0.14,0.72,1.33,1.02,0.67,0.47,0.96,2.38,2.64,1.02,-0.63,-0.73,-0.28,0.37,1.07,1.09,0.76,0.47,0.6,1.71,2.99,1.48,-0.42,-0.82,-0.38,-0.03,1.24,1.47,0.87,0.38,0.58,1.39,2.82,1.76,0.24,-0.57,-0.51,-0.22,1.04,1.8,1.26,0.7,0.64,1.19,2.77,2.26,0.39,-0.77,-0.79,-0.3,0.57,1.41,1.18,0.68,0.42,0.7,1.86,2.6,1.29,-0.08,-0.69,-0.61,-0.18,0.89,1.22,0.97,0.64,0.37,0.79,2.34,2.18,1.07,0.08,-0.53,-0.44,-0.05,1.52,1.45,0.89,0.45,0.16,0.32,1.41,1.45,0.77,0.27,0.19,0.35:-2.97,-2.22,-0.37,0.79,0.99,0.47,-1.64,-1.87,-1.27,-0.77,-1.04,-1.57,-2.96,-2.23,-0.49,0.88,0.83,0.46,-1.46,-1.96,-1.58,-1.06,-0.86,-0.98,-2.71,-2.34,-0.58,0.69,0.77,0.53,-1.32,-1.73,-1.35,-0.52,-0.67,-1.35,-2.97,-2.54,-0.82,0.41,0.89,0.85,-0.77,-2.64,-1.74,-0.84,-0.7,-1.34,-2.78,-2.27,-0.64,0.5,0.83,0.52,-1.69,-2.05,-1.36,-0.83,-0.83,-1.44,-2.83,-2.13,-0.65,0.59,0.87,0.44,-1.79,-1.95,-1.13,-0.7,-0.63,-1.4,-2.7,-2.07,-0.75,0.64,0.96,0.52,-1.7,-2.0,-1.22,-0.6,-0.45,-1.25,-2.68,-2.14,-0.52,0.67,0.85,0.48,-1.04,-1.71,-1.33,-0.93,-0.72,-1.08,-2.21,-2.4,-0.9,0.5,0.96,0.69,-0.92,-1.66,-1.33,-0.89,-0.77,-0.92,-2.3,-2.52,-1.17,0.3,0.94,0.64,-0.83,-1.61,-1.47,-0.99,-0.68,-0.93,-2.15,-2.8,-1.6,-0.07,0.78,0.71,0.06,-1.9,-1.83,-1.08,-0.63,-0.83,-1.39,-2.79,-1.92,-0.29,0.83,0.79,0.38,-1.66,-1.66,-1.11,-0.62,-0.57,-1.01,-2.46,-2.52,-1.13,0.22,1.07,0.9,-1.09,-2.44,-1.48,-0.75,-0.49,-0.95,-2.4,-2.79,-1.36,0.12,0.85,0.64,-0.49,-2.0,-1.74,-1.02,-0.62,-0.56,-1.21,-2.5,-2.08,-0.93,0.12,0.72,0.58,-1.01,-1.66,-1.39,-0.94,-0.58,-0.41,-1.17,-2.61,-1.7,-0.62,0.09,0.29,-0.31,-1.53,-1.11,-0.73,-0.32,-0.46,-0.44,-1.01,-0.85,-0.67,-0.38,-0.09,-0.18,-0.25,-0.44,-0.4,-0.41,-0.37:-0.08,0.68,0.9,0.66,0.51,0.6,0.47,0.52,0.32,0.08,-0.07,-0.18,-0.05,0.3,0.52,0.52,0.7,0.73,0.53,0.95,0.52,0.17,-0.25,-0.61,-0.67,0.18,0.7,0.73,0.83,0.71,0.56,0.49,0.17,-0.1,-0.15,-0.25,-0.39,-0.01,0.28,0.46,0.63,0.75,0.56,0.72,0.38,-0.12,-0.28,-0.26,-0.09,0.22,0.4,0.35,0.48,0.71,0.67,0.63,0.33,0.08,-0.22,-0.25,-0.08,0.31,0.36,0.49,0.56,0.72,0.56,0.67,0.34,0.06,-0.25,-0.25,-0.07,0.39,0.48,0.53,0.69,0.74,0.65,0.4,0.06,-0.12,-0.11,-0.17,-0.12,0.25,0.39,0.42,0.36,0.45,0.27,0.99,0.81,0.51,0.14,0.01,-0.06,0.29,0.45,0.46,0.41,0.51,0.53,0.9,0.57,0.33,0.0,-0.12,-0.28,0.06,0.27,0.34,0.39,0.55,0.49,0.92,0.43,0.24,-0.15,-0.31,-0.5,-0.31,-0.03,0.39,0.63,0.65,0.57,0.76,0.72,0.47,0.15,-0.1,-0.35,-0.28,0.24,0.52,0.52,0.57,0.44,0.44,0.77,0.56,0.28,-0.11,-0.35,-0.42,-0.01,0.49,0.66,0.66,0.57,0.13,0.56,0.54,0.3,0.02,-0.12,-0.14,0.19,0.38,0.32,0.29,0.38,0.45,0.6,0.28,0.1,-0.05,-0.31,-0.4,-0.31,0.05,0.35,0.37,0.3,0.26,0.14,0.51,0.14,-0.04,-0.06,-0.19,-0.22,-0.14,0.38,0.26,0.23,0.16,0.07,-0.13,-0.27,-0.71,-0.65,-0.58,-0.52,-0.67,-0.53,-0.73,-0.73,-0.55,-0.51,-0.53,-0.67,-0.84,-0.89,-0.85:RUNNING
-2.65,-2.29,-1.69,-1.52,-1.52,-2.18,-1.52,-0.15,0.66,0.73,0.08,-1.21,-1.71,-1.46,-1.26,-1.22,-1.26,-3.0,-1.76,0.13,0.84,0.81,-0.11,-1.23,-1.08,-1.28,-1.48,-1.46,-2.83,-2.52,-0.22,0.76,1.02,0.43,-0.59,-1.11,-1.28,-1.48,-1.46,-2.03,-3.29,-0.86,0.51,1.0,0.76,-0.53,-1.36,-1.24,-1.29,-1.44,-1.66,-3.39,-1.41,0.26,0.92,0.95,0.31,-1.42,-1.39,-1.46,-1.61,-1.62,-3.1,-2.29,-0.19,0.76,1.08,0.62,-0.86,-1.24,-1.35,-1.39,-1.47,-2.5,-2.94,-0.68,0.58,1.08,0.82,-0.42,-1.34,-1.44,-1.32,-1.41,-1.73,-3.22,-1.09,0.46,1.13,1.0,0.2,-1.21,-1.3,-1.49,-1.47,-1.51,-3.04,-1.39,0.18,0.9,1.05,0.52,-1.22,-1.21,-1.32,-1.41,-1.49,-2.93,-1.87,-0.18,0.71,1.0,0.61,-0.67,-0.91,-1.23,-1.14,-1.25,-1.87,-1.6,-0.01,0.77,1.13,0.93,-0.46,-1.2,-1.41,-1.55,-1.66,-2.57,-2.81,-0.63,0.66,1.21,0.9,-0.49,-1.5,-1.53,-1.52,-1.52,-2.05,-3.1,-0.83,0.5,1.01,0.87,-0.07,-1.13,-1.26,-1.48,-1.77,-2.71,-3.04,-0.82,0.5,1.12,0.97,-0.15,-1.66,-1.54,-1.36,-1.58,-2.0,-2.72,-0.79,0.42,1.05,0.96,0.15,-1.37,-1.27,-1.18,-1.4,-1.57,-2.9,-1.52,0.02,0.81,1.0,0.34,-1.7,-1.41,-1.46,-1.32,-1.24,-1.96,-2.18,-0.72,0.29,0.94,0.72,-0.94,-1.79,-1.71,-1.51,-1.22,-0.82,-1.32,-1.32,-0.46,0.28,0.73,0.33,-2.64,-2.26,-1.83:-0.33,-1.08,-1.65,-1.55,-1.62,-1.77,-1.19,0.22,0.83,0.9,0.4,-0.9,-1.91,-1.62,-1.0,-0.86,-2.02,-3.15,-2.01,-0.31,0.79,0.68,0.43,-2.26,-1.98,-1.25,-0.57,-0.85,-2.82,-3.19,-1.23,0.48,0.74,0.7,-1.55,-2.36,-1.38,-0.46,-0.61,-2.13,-3.39,-2.0,0.11,0.76,0.74,-0.31,-2.7,-1.71,-0.64,-0.27,-1.17,-3.45,-2.32,-0.3,0.91,0.92,0.25,-2.75,-2.0,-0.81,-0.33,-0.82,-2.57,-3.23,-1.37,0.64,0.97,0.73,-1.89,-2.05,-1.27,-0.48,-0.74,-1.66,-3.59,-1.72,0.48,1.06,0.75,-0.89,-2.4,-1.61,-0.54,-0.65,-1.26,-3.51,-2.28,-0.18,0.92,0.81,0.29,-2.84,-1.79,-0.75,-0.56,-0.97,-2.98,-2.67,-0.8,0.62,0.95,0.52,-2.55,-2.22,-0.87,-0.43,-0.68,-2.45,-2.97,-1.28,0.56,0.98,0.62,-2.14,-2.14,-1.26,-0.46,-0.94,-1.75,-3.29,-1.83,-0.18,0.87,0.47,-1.47,-2.47,-1.16,-0.35,-0.66,-1.71,-3.59,-2.04,0.27,1.04,0.78,-0.83,-2.42,-1.71,-0.63,-0.77,-1.62,-3.59,-2.28,-0.12,0.95,0.87,-0.05,-2.79,-1.76,-0.53,-0.43,-1.2,-3.35,-2.38,-0.13,1.26,1.0,-0.61,-2.51,-1.67,-0.72,-0.76,-1.18,-3.33,-2.56,-0.31,1.04,0.91,-0.01,-2.84,-1.79,-0.59,-0.47,-1.07,-3.06,-2.82,-0.62,0.99,0.82,0.42,-2.71,-1.99,-1.04,-0.67,-0.99,-1.96,-3.0,-1.42,0.34,1.0,0.66,-1.09,-2.72,-1.33,-0.64,-0.81,-1.19,-2.93,-2.26,-0.81,0.74,0.72,0.32,-1.57,-2.4,-1.42:1.34,0.33,-0.37,-0.49,-0.4,0.18,1.04,0.7,0.31,0.17,0.39,1.0,0.43,-0.43,-0.62,-0.58,-0.18,1.26,0.95,0.55,0.02,0.3,0.87,1.09,-0.16,-0.54,-0.68,-0.37,0.58,0.84,0.47,0.31,0.25,0.67,1.23,-0.04,-0.53,-0.64,-0.31,0.54,1.17,0.56,0.15,-0.14,0.33,1.14,0.39,-0.46,-0.59,-0.4,0.37,1.32,0.69,0.01,-0.05,0.17,1.07,0.52,-0.44,-0.65,-0.44,0.03,1.17,0.63,0.26,-0.06,0.13,0.86,0.73,-0.16,-0.59,-0.7,-0.41,0.51,0.82,-0.03,0.12,0.02,0.62,0.31,-0.55,-0.67,-0.61,-0.14,0.65,1.0,0.54,0.14,0.09,0.61,1.1,0.01,-0.38,-0.58,-0.27,0.46,1.13,0.79,0.43,0.13,0.51,1.06,0.09,-0.45,-0.68,-0.49,0.07,1.07,0.81,0.4,0.33,0.95,1.34,0.21,-0.34,-0.64,-0.37,0.37,1.44,0.86,0.25,-0.04,0.51,1.14,0.19,-0.48,-0.62,-0.48,0.05,1.09,0.73,0.14,0.04,0.36,1.04,0.47,-0.46,-0.67,-0.52,0.03,1.42,0.75,0.08,-0.1,0.03,0.7,0.58,-0.31,-0.7,-0.66,-0.33,0.42,0.9,0.11,-0.04,0.08,0.08,0.42,0.06,-0.37,-0.59,-0.51,-0.07,1.01,0.62,0.22,0.74,0.52,0.15,0.0,0.52,0.18,-0.05,-0.11,-0.05,0.06,-0.02,-0.15,-0.29,-0.42,-0.52,-0.62,-0.67,-0.82,-0.83,-0.93,-0.89,-0.95,-0.96,-0.95,-0.98,-0.95,-0.97,-0.95,-0.95,-0.97,-0.99,-0.99,-0.97,-0.96,-0.95,-0.97,-0.99,-0.99,-1.0,-1.0:RUNNING
-0.95,-0.94,-0.93,-0.94,-0.95,-0.94,-0.94,-0.9,-1.49,-1.35,-1.44,-1.79,-3.31,-2.45,-0.18,1.25,1.44,0.37,-2.4,-2.47,-1.84,-1.4,-1.11,-1.66,-3.58,-1.83,0.14,1.67,1.62,0.2,-3.05,-2.9,-2.22,-1.63,-1.36,-2.11,-3.59,-1.25,0.77,1.52,1.53,0.52,-2.34,-2.76,-2.01,-1.6,-1.44,-2.82,-3.15,-0.62,1.21,1.94,1.3,-1.46,-2.75,-2.37,-1.89,-1.51,-1.73,-3.59,-1.97,0.23,1.83,2.01,0.63,-3.03,-3.15,-2.23,-1.77,-1.74,-3.28,-3.13,-0.61,1.25,1.82,1.05,-2.32,-2.69,-2.25,-1.75,-1.41,-2.37,-2.55,-0.42,0.96,1.64,1.44,-1.14,-2.91,-2.61,-1.84,-1.22,-1.84,-3.54,-1.16,0.76,1.6,1.26,0.33,-2.05,-2.1,-1.78,-1.49,-1.5,-3.23,-1.62,0.33,1.51,1.7,1.12,-1.8,-2.08,-1.82,-1.59,-1.52,-2.98,-2.19,0.01,1.26,1.67,1.07,-2.14,-2.41,-1.89,-1.4,-1.3,-1.75,-3.48,-1.14,0.71,1.52,1.48,0.92,-2.03,-1.85,-1.51,-1.29,-1.27,-2.84,-2.4,-0.12,0.95,1.51,1.21,-0.57,-2.19,-2.04,-1.52,-1.23,-1.57,-3.54,-1.55,0.46,1.26,1.53,1.18,-2.05,-2.46,-2.08,-1.67,-1.34,-1.61,-3.36,-1.0,0.78,1.14,1.24,0.86,-2.09,-2.25,-1.88,-1.38,-1.04,-1.42,-3.26,-1.12,0.38,1.0,1.13,0.84,-2.18,-2.38,-1.73,-1.19,-1.01,-1.2,-2.95,-1.62,0.05,0.66,0.97,0.77,-0.35,-2.07,-1.47,-1.06,-0.84,-0.79,-1.47,-2.35,-0.69,0.27,0.34,0.36,0.64,0.38:-2.25,-3.59,-1.87,0.17,1.07,0.79,0.4,-3.09,-2.4,-0.08,0.44,-0.1,-2.09,-3.59,-1.64,0.24,1.13,0.64,-0.39,-3.38,-1.91,-0.04,0.02,-0.93,-3.45,-3.0,-0.58,0.64,0.6,0.27,-2.46,-3.17,-1.0,0.06,-0.25,-2.54,-3.59,-1.36,0.56,1.49,0.68,-0.97,-3.27,-1.46,0.26,0.24,-1.4,-3.02,-1.91,-0.05,1.44,0.86,-0.31,-3.26,-1.7,0.43,0.73,-0.29,-3.18,-2.94,-0.32,1.27,0.98,0.41,-2.64,-2.54,-0.12,0.45,0.18,-2.19,-3.43,-1.37,0.48,1.05,0.34,-2.0,-3.05,-0.79,0.19,0.23,-1.51,-3.34,-1.79,0.4,1.1,0.42,-1.39,-3.29,-1.08,0.54,0.66,-0.98,-3.24,-1.82,-0.1,1.26,0.82,0.07,-2.77,-2.68,-0.36,0.28,0.26,-2.07,-3.29,-1.24,0.4,1.16,0.71,-1.07,-3.49,-1.22,0.03,0.35,-0.07,-3.01,-2.93,-0.44,1.0,0.9,0.47,-2.46,-3.05,-0.31,0.33,0.46,-1.28,-3.49,-2.18,-0.26,1.0,0.91,0.18,-2.9,-2.61,-0.31,0.3,0.38,-1.39,-3.46,-2.14,-0.17,1.17,0.83,0.15,-2.68,-2.55,-0.51,0.32,0.48,-0.79,-3.28,-2.26,-0.25,0.81,1.02,0.52,-1.79,-3.1,-1.07,0.07,0.3,0.23,-2.52,-3.0,-0.98,0.26,0.95,0.77,-0.82,-3.03,-2.15,-0.66,-0.23,0.13,0.33,-1.61,-2.79,-1.13,0.0,0.51,0.5,-0.67,-2.18,-1.91,-0.66,-0.27,-1.4,-1.6,-1.11,-0.64,-0.32,-0.36,-0.83,-1.17,-1.26,-0.99,-0.8,-0.75,-0.89,-0.96,-1.0,-1.0,-0.96,-0.85,-0.78:-0.47,-0.45,-0.76,-0.9,-0.1,0.4,0.75,0.39,0.33,-0.3,-0.29,-0.56,-0.27,-0.21,-0.64,-0.54,0.07,0.69,0.63,0.3,0.73,-0.46,-0.43,-0.37,-0.48,-0.23,-1.18,-0.9,-0.15,0.41,0.58,0.36,0.67,-0.19,-0.27,-0.46,-0.31,-0.57,-0.99,-0.26,0.3,0.63,0.42,0.29,-0.2,-0.51,-0.55,-0.34,-0.16,-1.06,-0.45,0.39,0.66,0.51,0.35,0.56,-0.55,-0.68,-0.7,-0.34,-1.18,-0.61,-0.21,0.29,0.68,0.17,0.13,-0.61,-0.25,-0.29,-0.21,-0.08,-0.58,-0.02,0.45,0.69,0.07,0.35,-0.27,-0.33,-0.4,-0.4,-0.25,-1.25,-0.7,-0.32,0.46,0.3,0.15,0.32,-0.5,-0.36,-0.51,-0.36,-1.12,-0.69,-0.33,0.3,0.37,0.22,0.2,-0.45,-0.43,-0.38,-0.23,-0.81,-0.2,-0.16,0.09,0.56,0.24,0.14,0.06,-0.32,-0.49,-0.5,-0.26,-1.04,-0.13,-0.05,0.3,0.31,0.17,0.59,-0.1,0.09,-0.41,-0.44,-0.09,-1.16,-0.26,0.12,0.47,0.16,0.33,0.15,-0.4,-0.19,-0.71,-0.44,-0.95,-0.51,-0.11,0.13,0.51,0.21,0.14,-0.08,-0.63,-0.47,-0.64,-0.43,-0.89,-0.31,-0.32,0.26,0.42,0.04,-0.05,-0.48,-0.45,-0.36,-0.42,-0.45,-0.6,-0.43,-0.24,0.1,0.37,0.15,0.11,0.08,-0.43,-0.53,-0.43,-0.5,-0.05,-1.14,-0.27,-0.17,0.11,0.17,0.07,-0.46,-0.31,-0.36,-0.35,-0.47,-0.37,0.03,-1.26,-0.24,-0.26,0.01,0.05,0.0,-0.43,0.26,-0.2,-0.07,-0.1,0.21,0.16,0.05,0.07,0.05:RUNNING
-2.48,-3.59,-2.53,-0.51,0.86,0.18,-2.57,-3.59,-2.68,-2.12,-1.66,-3.29,-3.17,-1.65,0.69,0.86,-1.0,-3.47,-2.86,-2.07,-1.66,-1.66,-3.39,-2.18,-0.83,0.73,0.62,-1.55,-3.32,-2.54,-2.14,-1.46,-2.43,-2.99,-1.79,0.05,1.16,-0.2,-3.13,-2.8,-2.11,-1.87,-1.41,-2.82,-2.81,-1.45,0.33,0.92,-0.84,-3.33,-2.55,-2.07,-1.67,-1.66,-3.36,-1.88,-0.46,0.79,0.39,-1.76,-3.3,-2.38,-1.85,-1.45,-2.03,-2.97,-1.59,-0.25,1.14,0.42,-2.11,-3.05,-2.16,-1.84,-1.34,-2.45,-2.97,-1.79,-0.18,0.97,0.21,-2.65,-2.99,-1.95,-1.67,-1.23,-2.41,-2.73,-1.35,0.13,1.09,0.38,-2.52,-2.74,-1.88,-1.66,-1.51,-3.23,-2.52,-1.07,0.47,1.14,0.1,-2.97,-2.5,-1.86,-1.62,-1.41,-3.18,-2.3,-1.02,0.64,0.93,-0.76,-3.18,-2.43,-1.96,-1.58,-1.35,-3.08,-2.3,-0.91,0.63,0.84,-0.74,-3.15,-2.35,-1.75,-1.62,-1.52,-3.04,-2.27,-0.72,0.93,0.63,-1.49,-3.05,-2.09,-1.66,-1.3,-1.84,-3.32,-2.13,-0.5,0.99,0.57,-1.89,-3.55,-2.33,-1.96,-1.57,-1.39,-2.71,-1.88,-0.43,0.97,0.57,-2.21,-2.63,-1.7,-1.5,-1.23,-1.87,-2.8,-1.79,-0.4,0.92,0.65,-1.9,-2.93,-1.79,-1.38,-1.16,-1.05,-2.78,-2.1,-1.01,0.39,0.52,-1.24,-2.82,-2.07,-1.45,-1.0,-0.79,-2.7,-1.96,-1.13,-0.03,0.73,0.25,-1.96,-2.85,-2.11,-1.49,-1.14,-0.66,-0.75,-0.7,-0.33,-0.08,0.13,-0.03,-0.85,-1.37,-1.44:-2.2,-0.5,0.58,2.09,1.84,-1.39,-0.81,-1.44,-1.78,-2.29,-3.22,-1.86,-0.47,1.16,1.75,0.95,-1.85,-1.5,-1.66,-1.9,-1.86,-3.32,-1.13,0.03,1.58,1.14,-1.16,-1.52,-1.58,-1.38,-1.82,-3.08,-2.56,-0.86,0.82,1.39,0.53,-1.48,-1.11,-1.69,-2.11,-2.33,-3.4,-1.08,-0.08,1.37,1.09,-1.18,-1.28,-1.33,-2.12,-1.91,-2.81,-1.41,-0.45,0.64,1.69,0.87,-2.46,-1.36,-1.32,-1.97,-1.59,-3.13,-0.94,-0.41,1.34,1.19,-0.17,-1.64,-1.23,-1.5,-2.09,-1.72,-2.57,-0.7,0.15,1.32,0.65,-1.38,-1.3,-1.25,-1.52,-1.6,-2.08,-2.2,-0.62,0.52,1.34,0.97,-2.45,-1.59,-1.26,-1.82,-1.79,-3.29,-1.55,-0.79,0.77,1.23,0.19,-2.43,-1.44,-0.98,-1.76,-1.33,-3.28,-1.09,-0.44,1.01,1.19,-0.13,-1.88,-1.29,-1.32,-1.82,-1.21,-3.28,-0.7,-0.13,1.1,0.86,-0.38,-1.74,-1.76,-1.19,-1.36,-1.32,-3.19,-1.21,0.01,1.44,0.73,-1.97,-1.4,-1.4,-1.09,-1.42,-1.59,-2.57,-1.13,0.02,1.27,0.61,-2.26,-1.6,-1.38,-1.44,-1.57,-2.51,-1.91,-0.95,0.29,1.33,0.5,-2.57,-1.11,-1.45,-1.29,-1.54,-2.59,-1.7,-0.71,0.39,1.01,0.2,-2.1,-0.88,-1.26,-1.54,-1.44,-2.88,-1.3,-0.63,0.67,1.37,0.61,-1.84,-1.14,-1.34,-1.83,-0.98,-2.83,-1.17,-0.45,0.71,1.27,-0.09,-1.78,-0.97,-1.27,-1.61,-0.82,-2.93,-1.04,-0.5,1.08,0.99,-0.06,-1.32,-0.95,-0.99,-1.33,-1.27,-2.84,-1.13:0.02,0.16,0.17,0.16,0.15,0.1,-0.04,-0.17,-0.36,-0.36,0.13,1.1,1.05,0.96,0.96,1.23,1.39,1.19,-0.27,-0.68,-0.56,-0.22,0.31,1.01,0.83,1.25,1.32,1.07,-0.1,-0.39,-0.27,-0.08,-0.81,0.75,0.45,0.7,0.6,0.55,0.64,-0.11,-0.13,0.12,-0.29,-0.36,0.02,0.1,0.76,0.07,0.27,-0.24,-0.04,0.19,0.45,-0.27,0.4,0.08,0.29,0.46,-0.13,0.25,-0.23,-0.01,0.11,-0.3,-0.37,0.19,0.31,0.96,0.27,0.1,-0.54,-0.17,0.52,-0.11,-0.68,0.11,0.05,0.08,0.24,-0.38,0.16,-0.7,-0.09,0.46,-0.2,-0.15,0.16,0.08,0.71,-0.13,-0.65,-0.3,-0.44,0.24,0.66,-0.63,0.2,-0.49,0.1,0.43,-0.3,-0.77,-0.83,-0.69,0.12,0.3,-1.17,-0.48,-0.53,0.13,0.07,-0.32,0.47,-0.49,-0.08,0.47,-0.05,-0.68,-0.15,-0.12,0.19,0.01,-0.53,0.13,-0.31,-0.02,0.65,-0.2,-0.66,-0.3,-0.09,0.18,-0.07,-0.19,-0.2,-0.61,-0.09,0.54,-0.5,-0.41,-0.23,0.02,0.47,-0.13,-0.83,-0.7,-0.62,-0.14,0.18,-0.33,-0.41,-0.19,-0.04,0.03,-0.19,0.41,-0.55,-0.23,0.0,0.51,-0.63,-0.32,-0.43,0.0,0.14,-0.33,-0.03,-0.63,-0.36,0.22,0.22,-0.68,-0.23,-0.29,0.13,0.14,-0.5,-0.07,-0.72,-0.34,-0.09,0.14,-0.77,-0.29,-0.19,0.27,0.56,-0.42,-0.05,-0.82,-0.17,0.35,0.08,-0.94,-0.5,-0.33,0.13,-0.09,-0.57,-0.06,-0.79,-0.33,0.7,-0.32,-0.9,-0.33:RUNNING
-1.06,-1.46,-2.23,-1.05,0.36,1.05,0.74,-0.74,-2.11,-1.26,-0.84,-0.97,-1.21,-1.97,-0.94,0.35,0.89,0.61,-0.62,-2.0,-1.21,-0.82,-0.8,-1.13,-2.2,-1.06,0.31,0.77,0.58,-0.43,-2.05,-1.14,-0.73,-0.8,-0.87,-1.79,-1.42,-0.01,0.66,0.85,0.47,-1.83,-1.35,-1.07,-1.13,-1.13,-1.74,-1.6,-0.25,0.55,0.82,0.21,-1.8,-1.6,-1.1,-0.82,-0.77,-0.86,-1.64,-0.82,0.16,0.74,0.62,-0.16,-1.65,-1.01,-0.78,-0.73,-0.92,-1.69,-1.37,-0.03,0.68,0.75,0.14,-1.63,-1.14,-0.68,-0.66,-0.86,-1.41,-1.63,-0.1,0.63,0.78,0.33,-1.44,-1.33,-0.9,-0.63,-0.75,-1.35,-1.7,-0.42,0.47,0.85,0.53,-1.39,-1.58,-1.0,-0.71,-0.68,-0.89,-1.74,-0.84,0.27,0.83,0.71,-0.1,-1.64,-1.04,-0.8,-0.71,-0.89,-1.63,-1.29,-0.13,0.6,0.75,0.27,-1.07,-1.16,-0.81,-0.77,-0.91,-1.27,-1.62,-0.4,0.54,0.76,0.39,-0.48,-1.39,-0.93,-0.77,-0.87,-1.02,-1.57,-0.91,0.11,0.63,0.64,0.19,-1.49,-1.06,-0.83,-0.79,-0.93,-1.27,-1.69,-0.56,0.37,0.76,0.54,-0.33,-1.53,-1.0,-0.8,-0.73,-0.81,-1.42,-1.5,-0.51,0.14,0.53,0.54,-0.15,-1.7,-1.23,-0.94,-0.85,-0.68,-0.74,-1.2,-0.89,-0.15,0.17,0.08,-0.46,-1.79,-1.32,-0.87,-0.75,-0.5,-0.61,-1.0,-1.06,-0.47,-0.1,-0.15,-0.47,-0.99,-0.93,-0.57,-0.42,-0.55,-0.62,-0.48,-0.45,-0.35,-0.4,-0.52,-0.52,-0.6,-0.83,-1.17:-0.26,-0.25,-0.25,-0.26,-0.26,-0.26,-0.27,-0.27,-0.27,-0.27,-0.27,-0.26,-0.25,-0.25,-0.25,-0.25,-0.26,-0.27,-0.27,-0.27,-0.29,-0.32,-0.39,-0.47,-0.62,-0.59,-0.54,-0.49,-0.45,-0.33,-0.25,-0.17,-0.14,-0.58,-0.86,-1.0,-0.92,-1.22,-1.73,-1.38,-0.43,0.48,0.46,-0.06,-1.63,-1.5,-0.9,-0.47,-0.52,-1.05,-2.56,-1.16,0.13,0.75,0.47,-0.55,-2.0,-1.07,-0.64,-0.74,-1.0,-2.83,-1.9,0.08,1.02,0.68,-0.31,-2.11,-1.32,-0.83,-0.62,-0.9,-2.54,-1.91,-0.28,0.78,0.75,0.08,-2.25,-1.4,-0.82,-0.6,-0.87,-2.22,-2.26,-0.44,0.84,0.7,-0.1,-2.17,-1.26,-0.82,-0.82,-1.07,-2.46,-2.02,-0.29,0.84,0.5,-0.22,-2.2,-1.17,-0.66,-0.67,-1.09,-2.37,-2.21,-0.45,0.6,0.68,0.16,-2.35,-1.47,-0.75,-0.57,-0.94,-1.95,-2.24,-0.47,0.66,0.4,0.03,-1.96,-1.63,-0.71,-0.53,-0.79,-1.17,-3.01,-1.14,0.61,0.71,0.17,-1.51,-1.73,-0.83,-0.5,-0.74,-1.36,-2.76,-1.49,0.04,0.67,0.28,-0.32,-2.48,-1.06,-0.43,-0.36,-0.77,-2.07,-2.35,-0.81,0.42,0.5,0.02,-2.0,-1.67,-0.67,-0.36,-0.67,-1.32,-2.57,-1.27,0.16,0.34,0.1,-1.16,-1.95,-0.83,-0.5,-0.63,-1.04,-2.79,-1.55,0.04,0.58,0.18,-1.02,-2.21,-0.94,-0.49,-0.52,-0.9,-2.94,-1.76,-0.16,0.48,0.32,-0.35,-2.45,-1.21,-0.67,-0.45,-0.69,-2.13,-2.44,-0.92,0.28,0.56,0.07,-1.84,-1.78,-0.92,-0.45,-0.51:-0.04,-0.07,-0.19,-0.33,-0.38,-0.36,-0.29,-0.2,-0.18,-0.16,-0.19,-0.05,-0.02,-0.09,-0.24,-0.58,-0.57,-0.75,-0.69,-0.62,0.05,0.18,0.22,0.05,0.17,0.15,-0.05,-0.29,-0.57,-0.63,-0.62,-0.09,0.18,0.16,0.01,0.11,0.22,-0.06,-0.31,-0.63,-0.68,-0.56,-0.26,0.55,0.51,0.27,0.18,0.16,0.07,-0.07,-0.37,-0.54,-0.62,-0.48,0.55,0.31,0.21,0.05,0.02,0.19,0.0,-0.34,-0.58,-0.55,-0.5,0.45,0.21,0.18,0.09,0.12,0.2,0.01,-0.37,-0.71,-0.62,-0.36,0.63,0.32,0.18,0.07,0.0,-0.02,-0.16,-0.37,-0.67,-0.67,-0.35,0.69,0.37,0.18,0.0,-0.11,0.24,0.1,-0.39,-0.56,-0.63,-0.55,0.54,0.07,0.08,0.02,-0.06,0.15,0.04,-0.31,-0.53,-0.69,-0.54,0.4,0.36,0.42,0.14,-0.09,0.26,0.06,-0.27,-0.61,-0.66,-0.5,0.19,0.32,0.09,0.05,-0.06,-0.17,-0.2,-0.28,-0.42,-0.59,-0.63,-0.62,0.24,0.07,0.08,-0.03,-0.26,-0.3,-0.21,-0.38,-0.51,-0.66,-0.59,-0.05,0.0,0.17,0.03,-0.11,-0.11,-0.28,-0.33,-0.45,-0.51,-0.37,0.18,0.27,0.08,-0.07,-0.11,0.07,0.11,-0.14,-0.49,-0.57,-0.39,0.2,0.43,0.24,0.04,-0.07,-0.18,-0.11,-0.21,-0.47,-0.53,-0.43,-0.46,0.4,0.16,0.09,0.12,-0.06,0.04,-0.22,-0.36,-0.47,-0.61,-0.51,-0.15,0.24,0.16,0.07,0.02,-0.09,-0.06,-0.3,-0.43,-0.57,-0.57,-0.46,0.22,0.07,0.07,0.07,-0.13,-0.05:RUNNING
1.97,0.09,-0.9,-0.66,-0.21,1.02,1.66,1.08,0.53,0.33,1.21,3.22,2.0,0.04,-1.08,-0.8,-0.14,1.01,1.47,0.82,0.31,0.42,1.24,3.0,2.03,0.43,-0.71,-0.54,-0.22,1.19,1.64,1.05,0.48,0.6,1.39,3.35,2.33,0.16,-0.8,-0.6,-0.28,1.18,1.95,1.16,0.6,0.38,0.97,2.94,2.84,0.44,-1.27,-1.0,-0.32,0.84,1.45,0.92,0.44,0.48,1.45,2.97,1.94,-0.01,-1.1,-0.71,-0.13,1.08,1.44,0.85,0.43,0.57,1.48,2.98,1.66,-0.07,-0.68,-0.48,-0.17,0.86,1.21,0.83,0.4,0.44,1.33,2.93,1.75,0.01,-0.81,-0.55,-0.09,0.84,1.28,0.85,0.48,0.54,1.13,2.59,2.36,0.89,-0.52,-0.7,-0.25,0.65,1.45,1.12,0.53,0.36,1.16,2.81,2.47,0.6,-0.64,-0.52,-0.14,0.72,1.33,1.02,0.67,0.47,0.96,2.38,2.64,1.02,-0.63,-0.73,-0.28,0.37,1.07,1.09,0.76,0.47,0.6,1.71,2.99,1.48,-0.42,-0.82,-0.38,-0.03,1.24,1.47,0.87,0.38,0.58,1.39,2.82,1.76,0.24,-0.57,-0.51,-0.22,1.04,1.8,1.26,0.7,0.64,1.19,2.77,2.26,0.39,-0.77,-0.79,-0.3,0.57,1.41,1.18,0.68,0.42,0.7,1.86,2.6,1.29,-0.08,-0.69,-0.61,-0.18,0.89,1.22,0.97,0.64,0.37,0.79,2.34,2.18,1.07,0.08,-0.53,-0.44,-0.05,1.52,1.45,0.89,0.45,0.16,0.32,1.41,1.45,0.77,0.27,0.19,0.35,0.49,0.59,0.57,0.43,0.4,0.4:0.84,-0.83,-2.32,-1.87,-1.09,-0.79,-1.09,-3.23,-3.0,-0.8,1.08,1.13,0.47,-1.76,-2.09,-1.5,-0.97,-0.99,-1.51,-2.97,-2.22,-0.37,0.79,0.99,0.47,-1.64,-1.87,-1.27,-0.77,-1.04,-1.57,-2.96,-2.23,-0.49,0.88,0.83,0.46,-1.46,-1.96,-1.58,-1.06,-0.86,-0.98,-2.71,-2.34,-0.58,0.69,0.77,0.53,-1.32,-1.73,-1.35,-0.52,-0.67,-1.35,-2.97,-2.54,-0.82,0.41,0.89,0.85,-0.77,-2.64,-1.74,-0.84,-0.7,-1.34,-2.78,-2.27,-0.64,0.5,0.83,0.52,-1.69,-2.05,-1.36,-0.83,-0.83,-1.44,-2.83,-2.13,-0.65,0.59,0.87,0.44,-1.79,-1.95,-1.13,-0.7,-0.63,-1.4,-2.7,-2.07,-0.75,0.64,0.96,0.52,-1.7,-2.0,-1.22,-0.6,-0.45,-1.25,-2.68,-2.14,-0.52,0.67,0.85,0.48,-1.04,-1.71,-1.33,-0.93,-0.72,-1.08,-2.21,-2.4,-0.9,0.5,0.96,0.69,-0.92,-1.66,-1.33,-0.89,-0.77,-0.92,-2.3,-2.52,-1.17,0.3,0.94,0.64,-0.83,-1.61,-1.47,-0.99,-0.68,-0.93,-2.15,-2.8,-1.6,-0.07,0.78,0.71,0.06,-1.9,-1.83,-1.08,-0.63,-0.83,-1.39,-2.79,-1.92,-0.29,0.83,0.79,0.38,-1.66,-1.66,-1.11,-0.62,-0.57,-1.01,-2.46,-2.52,-1.13,0.22,1.07,0.9,-1.09,-2.44,-1.48,-0.75,-0.49,-0.95,-2.4,-2.79,-1.36,0.12,0.85,0.64,-0.49,-2.0,-1.74,-1.02,-0.62,-0.56,-1.21,-2.5,-2.08,-0.93,0.12,0.72,0.58,-1.01,-1.66,-1.39,-0.94,-0.58,-0.41,-1.17,-2.61,-1.7,-0.62,0.09:0.59,0.72,0.7,0.78,0.73,1.62,0.85,0.43,-0.17,-0.26,-0.08,0.68,0.9,0.66,0.51,0.6,0.47,0.52,0.32,0.08,-0.07,-0.18,-0.05,0.3,0.52,0.52,0.7,0.73,0.53,0.95,0.52,0.17,-0.25,-0.61,-0.67,0.18,0.7,0.73,0.83,0.71,0.56,0.49,0.17,-0.1,-0.15,-0.25,-0.39,-0.01,0.28,0.46,0.63,0.75,0.56,0.72,0.38,-0.12,-0.28,-0.26,-0.09,0.22,0.4,0.35,0.48,0.71,0.67,0.63,0.33,0.08,-0.22,-0.25,-0.08,0.31,0.36,0.49,0.56,0.72,0.56,0.67,0.34,0.06,-0.25,-0.25,-0.07,0.39,0.48,0.53,0.69,0.74,0.65,0.4,0.06,-0.12,-0.11,-0.17,-0.12,0.25,0.39,0.42,0.36,0.45,0.27,0.99,0.81,0.51,0.14,0.01,-0.06,0.29,0.45,0.46,0.41,0.51,0.53,0.9,0.57,0.33,0.0,-0.12,-0.28,0.06,0.27,0.34,0.39,0.55,0.49,0.92,0.43,0.24,-0.15,-0.31,-0.5,-0.31,-0.03,0.39,0.63,0.65,0.57,0.76,0.72,0.47,0.15,-0.1,-0.35,-0.28,0.24,0.52,0.52,0.57,0.44,0.44,0.77,0.56,0.28,-0.11,-0.35,-0.42,-0.01,0.49,0.66,0.66,0.57,0.13,0.56,0.54,0.3,0.02,-0.12,-0.14,0.19,0.38,0.32,0.29,0.38,0.45,0.6,0.28,0.1,-0.05,-0.31,-0.4,-0.31,0.05,0.35,0.37,0.3,0.26,0.14,0.51,0.14,-0.04,-0.06,-0.19,-0.22,-0.14,0.38,0.26,0.23,0.16,0.07,-0.13,-0.27,-0.71,-0.65,-0.58,-0.52,-0.67:RUNNING
-0.5,0.9,0.96,0.73,0.75,1.01,1.49,1.04,-0.15,-0.86,-1.06,-0.57,1.21,0.91,0.61,0.74,1.17,1.72,0.73,-0.31,-0.86,-1.0,-0.64,0.83,0.79,0.55,0.64,1.22,1.8,0.56,-0.46,-0.95,-1.12,-0.62,0.89,0.72,0.62,0.85,1.14,1.39,0.44,-0.29,-0.76,-0.99,-0.7,0.84,0.63,0.5,0.79,0.98,1.34,0.55,-0.24,-0.67,-0.92,-0.82,0.41,0.75,0.59,0.74,1.08,1.89,1.16,-0.12,-0.85,-1.05,-0.78,0.75,1.0,0.69,0.92,1.13,1.53,1.01,-0.21,-0.77,-0.87,-0.73,0.65,0.93,0.69,0.79,1.16,1.79,0.86,-0.19,-0.8,-1.07,-0.78,0.72,1.04,0.66,0.77,1.0,1.39,1.37,0.07,-0.63,-1.12,-0.95,0.48,1.17,0.74,0.73,0.98,1.44,1.24,0.09,-0.57,-1.01,-0.86,0.09,1.11,0.74,0.88,1.18,1.45,1.6,-0.01,-0.74,-0.93,-0.84,-0.12,1.12,0.7,0.89,1.1,1.33,1.69,0.28,-0.56,-1.16,-1.0,-0.15,1.13,0.77,0.78,1.01,1.38,1.96,0.31,-0.56,-1.06,-1.0,-0.28,1.08,0.81,0.88,1.16,1.32,1.77,0.3,-0.5,-0.97,-1.01,-0.3,0.88,0.64,0.76,1.13,1.39,1.89,0.4,-0.83,-1.3,-0.93,0.26,1.2,0.68,0.68,1.39,1.92,1.65,0.02,-0.76,-1.09,-0.88,0.26,1.13,0.69,0.92,1.21,1.47,2.02,0.36,-0.52,-1.08,-0.98,-0.04,1.1,0.81,1.0,1.26,1.33,1.82,0.56,-0.45,-1.01,-0.96,0.01,1.45,0.8,0.64,1.08,1.23,1.85:0.44,1.44,1.3,0.93,0.42,0.71,2.81,2.33,0.93,0.05,-0.49,-0.5,1.06,2.79,1.72,0.71,0.16,1.26,3.39,1.53,0.24,-0.43,-0.48,1.17,2.82,1.61,0.62,0.13,1.28,3.26,1.88,0.54,-0.36,-0.63,0.95,3.0,1.78,0.66,0.15,1.61,3.26,1.41,0.21,-0.48,-0.52,1.65,3.0,1.41,0.38,0.08,1.72,3.24,1.71,0.45,-0.39,-0.51,2.08,2.63,1.21,0.25,0.18,2.2,3.2,1.52,0.35,-0.47,-0.53,2.35,2.69,1.14,0.19,0.01,1.99,3.03,1.46,0.34,-0.42,-0.43,1.85,3.03,1.36,0.34,-0.02,1.19,3.27,1.71,0.58,-0.32,-0.55,1.06,3.19,1.59,0.52,0.03,0.78,3.51,1.96,0.51,-0.41,-0.76,0.97,3.33,1.55,0.53,0.06,0.81,3.36,1.82,0.51,-0.46,-0.69,1.51,3.15,1.5,0.53,0.04,0.97,3.46,1.86,0.63,-0.19,-0.62,0.26,3.26,1.92,0.67,0.09,0.67,3.55,2.09,0.62,-0.32,-0.65,0.32,3.26,2.07,0.81,0.16,0.37,3.18,2.6,0.95,-0.16,-0.64,0.13,3.14,2.37,0.96,0.19,0.14,2.75,2.94,1.0,-0.06,-0.69,-0.35,2.76,2.69,1.24,0.35,0.16,2.75,2.89,1.05,-0.04,-0.62,-0.46,2.5,2.75,1.14,0.22,0.23,2.8,2.94,1.07,0.01,-0.6,-0.42,2.58,2.69,1.19,0.18,0.2,2.81,2.88,1.16,-0.04,-0.71,-0.23,2.83,2.79,1.24,0.47,0.96,3.41,2.51,0.86,-0.22,-0.76,0.18,3.31,2.67,1.17,0.43,0.74,3.43:0.12,0.08,0.54,0.2,-0.08,-0.44,-0.39,-0.28,0.34,0.57,0.31,0.18,0.17,0.41,0.3,-0.11,-0.47,-0.41,-0.07,0.65,0.57,0.28,0.18,0.17,0.63,0.16,-0.07,-0.37,-0.32,0.01,0.61,0.52,0.2,0.09,0.13,0.65,0.14,-0.25,-0.36,-0.36,0.13,0.7,0.51,0.16,0.12,0.05,0.53,0.04,-0.27,-0.34,-0.36,0.12,0.64,0.38,0.05,0.1,0.07,0.5,0.1,-0.2,-0.38,-0.38,-0.02,0.4,0.42,0.11,0.09,0.06,0.67,0.55,0.06,-0.43,-0.4,-0.07,0.64,0.55,0.26,0.14,0.2,0.42,0.45,-0.01,-0.39,-0.36,-0.01,0.53,0.53,0.2,0.13,0.16,0.73,0.3,-0.09,-0.42,-0.39,-0.12,0.67,0.64,0.26,0.09,0.2,0.18,0.33,-0.03,-0.35,-0.35,-0.17,0.59,0.65,0.24,0.04,0.16,0.14,0.36,-0.06,-0.46,-0.51,-0.32,0.23,0.48,0.24,0.14,0.2,0.01,0.64,0.12,-0.46,-0.49,-0.32,0.48,0.83,0.39,0.13,0.18,0.07,0.52,0.06,-0.24,-0.43,-0.31,0.22,0.75,0.42,0.16,0.2,0.06,1.01,0.44,-0.23,-0.43,-0.43,0.42,0.88,0.53,0.22,0.27,0.05,0.81,0.32,-0.12,-0.31,-0.38,0.2,0.62,0.39,0.19,0.34,0.0,0.51,0.25,0.12,-0.01,0.17,0.75,0.73,0.37,0.13,0.38,0.29,0.63,0.08,-0.2,-0.5,-0.29,0.45,0.65,0.45,0.31,0.38,0.12,0.7,0.06,-0.2,-0.29,-0.13,0.53,0.7,0.26,0.29,0.41,0.04,0.63,0.32,0.01,-0.17,-0.14:RUNNING
-0.43,-0.82,-0.4,0.92,1.84,0.98,0.61,0.66,1.0,1.95,0.87,-0.23,-0.8,-0.83,0.07,1.59,1.05,0.71,0.78,1.12,2.03,0.7,-0.46,-0.88,-0.83,-0.01,1.23,0.92,0.82,0.87,1.22,1.74,0.42,-0.48,-0.89,-0.97,-0.11,1.0,0.65,0.68,0.9,1.3,1.52,0.47,-0.36,-1.0,-0.99,-0.06,1.09,0.76,0.7,0.93,1.28,1.66,0.33,-0.63,-0.96,-0.81,0.2,1.0,0.66,0.7,0.93,1.26,1.63,0.34,-0.48,-1.0,-1.0,-0.18,0.99,0.69,0.71,0.91,1.25,1.36,0.26,-0.4,-0.99,-0.95,-0.12,0.78,0.65,0.75,0.94,1.21,1.37,0.22,-0.52,-1.0,-0.9,-0.07,1.08,0.76,0.73,0.98,1.26,1.2,0.07,-0.52,-0.91,-1.0,-0.16,1.04,0.75,0.77,0.98,1.39,1.47,0.15,-0.51,-1.12,-0.94,0.03,1.08,0.74,0.72,0.89,1.19,1.16,0.19,-0.52,-0.97,-0.87,-0.03,0.94,0.56,0.6,0.9,1.1,1.52,0.29,-0.52,-1.01,-0.86,-0.05,0.93,0.78,0.79,0.89,1.17,1.26,0.1,-0.67,-1.02,-0.8,0.22,0.99,0.66,0.72,0.9,1.09,1.4,0.21,-0.59,-1.02,-0.94,-0.18,0.82,0.66,0.81,1.1,1.25,1.52,0.23,-0.57,-0.97,-0.99,-0.39,0.95,0.81,0.87,0.97,1.17,1.12,0.09,-0.52,-0.84,-0.82,-0.15,0.86,0.69,0.62,0.8,1.25,1.11,0.17,-0.49,-0.83,-0.75,-0.22,0.57,0.61,0.7,0.8,0.95,0.77,0.16,-0.42,-0.74,-0.76,-0.43,0.4,0.2,0.49,0.94:2.76,2.47,0.81,-0.07,-0.58,-0.55,1.52,2.96,1.47,0.42,0.13,2.36,3.14,1.19,-0.07,-0.79,-0.68,2.33,2.57,1.2,0.28,0.17,2.76,2.86,1.1,-0.11,-0.64,-0.37,2.72,2.3,1.0,0.18,0.18,2.95,2.56,0.99,-0.07,-0.59,-0.04,2.75,2.22,0.94,0.18,0.23,3.08,2.65,1.08,-0.11,-0.6,-0.18,3.0,2.18,0.9,0.19,0.23,3.04,2.46,0.94,-0.15,-0.66,-0.12,3.05,2.19,0.86,0.14,0.24,3.05,2.49,0.99,-0.05,-0.6,-0.09,2.91,2.24,0.94,0.17,0.34,3.02,2.55,0.94,-0.14,-0.51,0.07,3.0,2.43,0.93,0.19,0.17,2.88,2.8,1.11,-0.09,-0.63,0.01,3.06,2.16,0.83,0.1,0.38,3.0,2.74,1.05,-0.19,-0.76,0.0,3.1,2.22,0.85,0.16,0.68,3.28,2.47,0.97,-0.1,-0.56,0.2,2.97,2.22,0.77,0.07,0.3,3.05,2.67,1.12,-0.02,-0.7,-0.25,2.9,2.26,0.84,0.16,0.38,3.18,2.52,0.92,-0.07,-0.6,0.33,3.06,2.07,0.68,0.07,0.48,3.15,2.55,0.99,-0.16,-0.63,-0.08,3.06,2.16,0.77,0.09,0.27,3.21,2.77,0.91,-0.31,-0.6,0.01,3.04,2.29,1.0,0.18,0.1,2.75,2.79,1.08,-0.01,-0.52,0.17,2.81,2.29,0.97,0.16,0.39,2.88,2.5,1.11,-0.1,-0.45,0.29,2.59,2.14,0.86,0.09,0.4,2.39,2.73,1.32,-0.12,-0.53,0.2,2.41,2.16,0.99,0.09,0.18,2.51,2.68,1.32,0.21,-0.5,-0.39,2.09,2.91:0.13,0.12,0.04,0.01,0.07,0.18,0.17,0.22,0.07,0.38,0.28,0.01,-0.08,-0.14,0.42,0.74,0.46,0.19,0.15,-0.02,0.61,0.33,0.1,-0.34,-0.26,-0.12,0.66,0.43,0.16,0.15,0.04,0.62,0.12,-0.31,-0.5,-0.43,-0.19,0.61,0.46,0.25,0.18,0.12,0.58,0.14,-0.19,-0.42,-0.3,0.07,0.59,0.37,0.14,0.19,0.07,0.4,-0.07,-0.29,-0.29,-0.23,0.22,0.62,0.27,0.07,0.14,0.1,0.34,-0.09,-0.34,-0.35,-0.22,0.38,0.65,0.31,0.08,0.2,0.06,0.37,-0.02,-0.15,-0.25,-0.15,0.46,0.69,0.42,0.07,0.14,0.0,0.32,-0.15,-0.35,-0.4,-0.32,0.19,0.53,0.28,0.1,0.17,0.07,0.47,0.0,-0.22,-0.36,-0.25,0.19,0.62,0.41,0.15,0.27,0.14,0.36,-0.05,-0.18,-0.31,-0.22,0.32,0.6,0.3,0.21,0.3,0.07,0.41,0.04,-0.1,-0.34,-0.26,0.43,0.74,0.4,0.17,0.16,0.05,0.27,-0.11,-0.27,-0.42,-0.29,0.22,0.58,0.34,0.12,0.23,-0.03,0.34,-0.02,-0.23,-0.34,-0.19,0.34,0.64,0.39,0.24,0.35,0.0,0.24,-0.05,-0.22,-0.32,-0.2,0.43,0.54,0.2,0.07,0.19,0.02,0.34,-0.05,-0.24,-0.23,-0.11,0.46,0.59,0.28,0.11,0.16,0.05,0.47,0.1,-0.23,-0.34,-0.31,0.31,0.57,0.23,0.01,0.16,0.11,0.43,0.09,-0.33,-0.52,-0.3,0.49,0.81,0.34,0.07,0.05,0.24,0.57,0.15,-0.17,-0.34,-0.23,0.27,0.76,0.42,0.12,0.09:RUNNING
0.3,-1.58,-1.69,-0.68,0.79,0.82,-0.17,-1.84,-1.5,-0.06,0.97,0.72,-0.89,-2.04,-1.13,0.58,1.0,0.33,-1.58,-1.78,-0.76,0.8,0.98,-0.07,-1.9,-1.49,-0.06,0.97,0.71,-0.68,-1.98,-1.22,0.5,0.94,0.34,-1.46,-1.75,-0.75,0.72,0.88,0.01,-1.9,-1.39,0.16,0.81,0.41,-1.0,-1.74,-1.02,0.28,0.77,0.52,-1.07,-1.91,-0.99,0.45,0.77,0.17,-1.24,-1.7,-0.8,0.54,0.65,-0.01,-1.66,-1.39,-0.22,0.68,0.51,-0.62,-1.77,-1.22,0.12,0.85,0.51,-0.94,-1.84,-1.12,0.4,0.89,0.29,-1.48,-1.69,-0.68,0.79,0.78,-0.4,-1.75,-1.33,-0.09,0.8,0.51,-0.93,-1.78,-0.98,0.56,0.76,0.07,-1.52,-1.55,-0.46,0.76,0.66,-0.45,-1.71,-1.24,0.06,0.7,0.43,-0.81,-1.7,-1.1,0.35,0.82,0.25,-1.35,-1.54,-0.7,0.61,0.61,-0.15,-1.59,-1.4,-0.48,0.65,0.69,-0.26,-1.71,-1.4,-0.23,0.74,0.67,-0.38,-1.85,-1.3,0.06,0.76,0.5,-0.71,-1.77,-1.0,0.33,0.72,0.42,-1.11,-1.73,-0.86,0.52,0.82,0.02,-1.69,-1.42,-0.25,0.74,0.56,-0.6,-1.73,-1.16,0.12,0.77,0.46,-0.86,-1.7,-1.02,0.38,0.66,0.18,-1.21,-1.48,-0.77,0.44,0.67,0.2,-1.29,-1.58,-0.87,0.47,0.74,0.25,-1.19,-1.63,-0.92,0.4,0.68,0.25,-1.46,-1.52,-0.43,0.6,0.58,-0.38,-1.57,-1.21,-0.07,0.65,0.5,-0.58,-1.55,-1.2,-0.25,0.58,0.58,-0.42,-1.69,-1.32,-0.29:-0.34,-0.46,-1.19,-0.92,-0.41,-0.65,-0.34,-0.64,-1.1,-0.65,-0.55,-0.81,-0.34,-0.66,-1.16,-0.66,-0.47,-0.9,-0.32,-0.93,-1.1,-0.52,-0.6,-0.85,-0.38,-0.97,-0.61,-0.4,-0.72,-0.43,-0.55,-1.02,-0.7,-0.64,-0.66,-0.2,-0.88,-1.02,-0.7,-0.7,-0.62,-0.13,-0.95,-1.07,-0.72,-0.68,-0.53,-0.3,-1.17,-0.92,-0.56,-0.69,-0.53,-0.22,-1.08,-0.98,-0.7,-0.73,-0.66,-0.16,-1.13,-1.01,-0.47,-0.67,-0.58,-0.5,-1.19,-0.88,-0.59,-0.65,-0.37,-0.71,-1.08,-0.86,-0.67,-0.52,-0.29,-0.68,-1.23,-0.91,-0.55,-0.51,-0.23,-0.64,-1.14,-0.72,-0.62,-0.57,-0.13,-0.76,-1.25,-0.73,-0.46,-0.34,-0.25,-1.02,-1.28,-0.67,-0.58,-0.45,-0.14,-1.0,-1.19,-0.73,-0.66,-0.62,-0.36,-0.99,-0.82,-0.59,-0.68,-0.46,-0.42,-1.08,-0.86,-0.62,-0.72,-0.38,-0.65,-0.85,-0.7,-0.8,-0.68,-0.21,-0.72,-1.0,-0.76,-0.6,-0.62,-0.26,-0.92,-1.19,-0.87,-0.53,-0.46,-0.38,-1.0,-1.11,-0.86,-0.49,-0.56,-0.3,-0.81,-1.09,-0.79,-0.75,-0.62,-0.26,-0.86,-1.02,-0.78,-0.74,-0.55,-0.33,-0.98,-1.0,-0.76,-0.69,-0.7,-0.32,-0.94,-0.99,-0.7,-0.69,-0.54,-0.21,-0.82,-1.0,-0.82,-0.61,-0.62,-0.34,-0.81,-1.26,-0.93,-0.35,-0.36,-0.5,-0.83,-1.19,-0.94,-0.6,-0.52,-0.2,-0.77,-1.23,-0.7,-0.56,-0.64,-0.25,-0.43,-1.23,-0.88,-0.66,-0.63,-0.38,-0.29,-1.16,-1.08,-0.56,-0.58,-0.35,-0.32,-1.07,-0.99,-0.75:-0.17,-0.54,-1.13,-1.01,-0.65,-0.03,-0.26,-0.66,-1.36,-1.0,-0.59,-0.06,-0.26,-0.84,-1.16,-0.83,-0.39,0.03,-0.42,-1.12,-1.08,-0.88,-0.1,-0.13,-0.65,-1.13,-1.02,-0.59,0.09,-0.34,-0.78,-1.06,-0.89,-0.32,-0.05,-0.47,-1.08,-1.02,-0.77,-0.19,-0.14,-0.57,-1.19,-1.02,-0.6,-0.15,-0.32,-0.76,-1.13,-0.92,-0.49,-0.13,-0.4,-1.07,-1.21,-0.8,-0.3,-0.17,-0.43,-1.26,-1.01,-0.58,-0.21,-0.45,-0.52,-1.07,-0.94,-0.57,-0.44,-0.34,-0.47,-1.07,-0.96,-0.63,-0.16,-0.33,-0.69,-1.06,-0.77,-0.48,-0.33,-0.38,-0.86,-1.0,-0.68,-0.43,-0.28,-0.52,-1.17,-1.1,-0.65,-0.16,-0.28,-0.63,-1.26,-0.91,-0.6,-0.16,-0.3,-0.7,-1.16,-0.9,-0.46,-0.09,-0.39,-0.97,-1.13,-0.73,-0.45,-0.15,-0.35,-0.88,-1.21,-0.77,-0.52,-0.07,-0.31,-0.86,-1.1,-0.68,-0.39,-0.31,-0.49,-0.93,-0.79,-0.56,-0.37,-0.3,-0.57,-0.99,-0.76,-0.66,-0.36,-0.19,-0.55,-1.09,-0.79,-0.63,-0.26,-0.25,-0.54,-1.06,-0.92,-0.69,-0.27,-0.28,-0.64,-0.97,-0.8,-0.49,-0.24,-0.43,-0.8,-1.01,-0.82,-0.46,-0.17,-0.35,-0.75,-0.99,-0.79,-0.54,-0.22,-0.38,-0.8,-0.96,-0.78,-0.42,-0.17,-0.39,-0.96,-0.99,-0.75,-0.27,-0.21,-0.52,-1.06,-0.9,-0.75,-0.29,-0.21,-0.46,-1.12,-1.13,-0.75,-0.14,-0.22,-0.66,-1.05,-0.8,-0.45,-0.19,-0.28,-0.74,-1.23,-0.85,-0.53,-0.17,-0.28,-0.62,-1.02,-0.84,-0.61,-0.3,-0.34,-0.62:SAWING
0.66,-0.05,0.2,1.09,0.79,0.0,0.08,0.86,0.9,0.1,0.02,0.85,1.01,0.1,0.03,0.67,1.17,0.4,-0.1,0.49,1.13,0.64,-0.05,0.28,1.2,0.74,-0.08,0.25,1.18,0.69,-0.02,0.25,1.17,0.84,0.0,0.14,0.98,0.88,0.07,0.07,0.8,1.02,0.11,0.02,0.64,1.06,0.32,-0.05,0.46,1.1,0.42,-0.06,0.38,1.08,0.55,-0.03,0.32,1.0,0.66,-0.15,0.17,1.14,0.81,-0.11,0.12,0.96,0.94,0.16,-0.05,0.56,1.18,0.41,-0.17,0.39,1.22,0.58,-0.11,0.19,1.24,0.84,0.0,0.05,0.75,1.04,0.17,-0.1,0.6,1.11,0.27,-0.15,0.49,1.17,0.45,-0.08,0.33,1.21,0.68,-0.1,0.16,1.08,0.85,0.01,0.05,0.86,1.05,0.08,-0.06,0.64,1.12,0.38,-0.11,0.43,1.25,0.38,-0.15,0.3,1.22,0.65,-0.06,0.2,1.12,0.84,-0.03,0.06,1.07,0.89,-0.08,0.06,0.98,0.96,0.05,-0.06,0.75,1.01,0.14,-0.03,0.71,1.02,0.28,-0.12,0.48,1.14,0.38,-0.12,0.4,1.18,0.61,-0.14,0.08,0.9,1.12,0.54,-0.31,-0.02,0.8,1.44,0.4,-0.45,0.06,1.1,1.25,0.55,-0.36,-0.07,0.55,1.26,0.84,-0.11,-0.09,0.73,1.26,0.5,-0.25,0.34,1.13,0.91,-0.08,0.05,0.85,1.12,0.36,-0.06,0.65,1.13,0.47,-0.04,0.57,1.05,0.6,-0.1,0.38,1.1,0.88,-0.02,0.15,0.89,1.07,0.32,-0.02,0.52,1.09,0.79,0.12,0.09,0.58,1.04:-1.21,-1.34,-0.45,-0.18,-1.25,-1.36,-0.41,-0.2,-1.32,-1.35,-0.45,-0.27,-1.26,-1.37,-0.53,-0.21,-0.96,-1.27,-0.73,-0.2,-0.83,-1.37,-0.83,-0.17,-0.74,-1.4,-0.95,-0.23,-0.58,-1.42,-0.99,-0.24,-0.48,-1.47,-1.08,-0.23,-0.48,-1.49,-1.13,-0.32,-0.39,-1.29,-1.28,-0.52,-0.26,-1.2,-1.32,-0.58,-0.25,-1.1,-1.45,-0.62,-0.17,-0.82,-1.44,-0.93,-0.16,-0.59,-1.41,-1.09,-0.31,-0.46,-1.4,-1.12,-0.27,-0.49,-1.39,-1.21,-0.28,-0.34,-1.39,-1.21,-0.39,-0.38,-1.21,-1.33,-0.56,-0.29,-1.12,-1.4,-0.64,-0.27,-0.88,-1.39,-0.76,-0.28,-0.82,-1.32,-0.84,-0.38,-0.73,-1.29,-0.9,-0.4,-0.65,-1.28,-1.1,-0.46,-0.44,-1.32,-1.26,-0.53,-0.29,-1.13,-1.37,-0.7,-0.24,-0.71,-1.39,-0.97,-0.22,-0.55,-1.53,-1.06,-0.35,-0.4,-1.22,-1.32,-0.61,-0.24,-1.0,-1.35,-0.67,-0.25,-0.93,-1.39,-0.82,-0.13,-0.71,-1.4,-0.95,-0.29,-0.45,-1.39,-1.17,-0.4,-0.35,-1.32,-1.26,-0.54,-0.2,-1.23,-1.42,-0.75,-0.24,-0.82,-1.44,-0.84,-0.2,-0.71,-1.51,-0.98,-0.24,-0.57,-1.38,-1.12,-0.42,-0.38,-1.32,-1.32,-0.48,-0.34,-1.4,-1.26,-0.45,-0.38,-1.12,-1.36,-0.71,-0.28,-1.05,-1.36,-0.75,-0.28,-0.9,-1.44,-0.9,-0.27,-0.73,-1.38,-0.98,-0.31,-0.51,-1.39,-1.23,-0.62,-0.34,-0.66,-1.37,-1.27,-0.74,-0.21,-0.53,-1.53,-1.39,-0.57,-0.12,-0.78,-1.26,-1.19,-0.85,-0.48,-0.44,-1.0,-1.26,-0.71:0.13,-0.15,-0.92,-0.53,0.12,-0.05,-0.91,-0.57,0.2,-0.06,-0.84,-0.66,0.08,0.09,-0.75,-0.78,-0.01,0.12,-0.63,-0.77,-0.03,0.14,-0.55,-0.79,-0.22,0.15,-0.26,-0.8,-0.39,0.15,0.0,-0.79,-0.58,0.18,0.03,-0.69,-0.56,0.18,-0.05,-0.84,-0.65,0.16,0.09,-0.72,-0.74,0.09,0.15,-0.65,-0.83,0.0,0.18,-0.59,-0.87,-0.15,0.15,-0.37,-0.84,-0.33,0.2,-0.25,-0.81,-0.38,0.14,-0.25,-0.78,-0.4,0.11,-0.03,-0.7,-0.66,0.05,0.03,-0.73,-0.72,0.05,0.12,-0.6,-0.78,-0.19,0.07,-0.27,-0.74,-0.47,0.07,0.03,-0.84,-0.75,0.13,0.23,-0.73,-0.88,-0.11,0.13,-0.54,-0.85,-0.12,0.16,-0.44,-0.94,-0.27,0.22,-0.24,-0.95,-0.46,0.15,-0.06,-0.76,-0.61,0.04,0.06,-0.66,-0.77,0.03,0.19,-0.59,-0.88,-0.15,0.22,-0.31,-0.83,-0.32,0.31,-0.23,-0.86,-0.39,0.21,-0.05,-0.77,-0.57,0.16,0.15,-0.76,-0.73,0.21,0.14,-0.81,-0.61,0.11,0.16,-0.57,-0.75,-0.05,0.17,-0.41,-0.74,-0.12,0.21,-0.28,-0.77,-0.27,0.21,-0.17,-0.73,-0.33,0.19,0.05,-0.7,-0.6,-0.02,0.14,-0.05,-0.55,-0.68,-0.16,0.22,0.08,-0.88,-0.71,0.01,0.29,-0.02,-0.68,-0.71,-0.29,-0.02,-0.01,-0.48,-0.65,-0.28,-0.01,-0.19,-0.55,-0.59,-0.05,-0.09,-0.42,-0.63,-0.34,-0.06,-0.32,-0.63,-0.41,-0.11,-0.27,-0.62,-0.5,-0.07,-0.19,-0.57,-0.61,-0.08,-0.12,-0.5,-0.75,-0.31,-0.09:SAWING
0.17,-0.34,-1.34,-1.44,-1.1,-0.36,0.13,0.05,-0.71,-1.58,-1.33,-0.74,0.03,0.14,-0.35,-1.37,-1.36,-1.09,-0.31,0.19,0.14,-0.53,-1.55,-1.26,-0.85,-0.07,0.2,-0.15,-1.26,-1.41,-1.12,-0.4,0.2,0.08,-0.69,-1.44,-1.32,-0.87,-0.07,0.15,-0.14,-1.2,-1.42,-1.12,-0.32,0.21,0.01,-0.86,-1.53,-1.26,-0.61,0.11,0.1,-0.44,-1.54,-1.4,-0.94,-0.13,0.11,-0.13,-1.0,-1.55,-1.19,-0.47,0.09,0.06,-0.7,-1.57,-1.29,-0.89,-0.09,0.17,-0.28,-1.19,-1.47,-1.13,-0.43,0.1,0.02,-0.76,-1.49,-1.38,-0.72,0.07,0.12,-0.38,-1.38,-1.47,-1.05,-0.35,0.12,-0.01,-0.86,-1.51,-1.29,-0.72,-0.02,0.1,-0.43,-1.42,-1.39,-1.01,-0.29,0.11,-0.01,-0.91,-1.48,-1.22,-0.66,0.04,0.11,-0.47,-1.5,-1.44,-1.07,-0.23,0.16,-0.03,-0.83,-1.49,-1.29,-0.87,-0.13,0.15,-0.1,-1.13,-1.48,-1.19,-0.58,0.07,0.1,-0.47,-1.39,-1.42,-1.09,-0.36,0.12,0.02,-0.72,-1.49,-1.34,-0.92,-0.19,0.14,-0.02,-0.95,-1.49,-1.29,-0.7,0.01,0.06,-0.34,-1.34,-1.39,-1.09,-0.48,0.02,0.03,-0.57,-1.34,-1.36,-1.01,-0.43,0.05,0.05,-0.68,-1.39,-1.26,-0.83,-0.07,0.12,-0.37,-1.34,-1.4,-1.02,-0.24,0.16,0.06,-0.88,-1.59,-1.26,-0.88,-0.05,0.14,-0.19,-1.11,-1.47,-1.19,-0.58,0.07,0.04,-0.45,-1.29,-1.4,-1.01,-0.29,0.13,-0.02,-0.83,-1.53,-1.29,-0.69,0.05,0.08,-0.34,-1.28:-0.25,-0.05,-0.33,-0.55,-0.65,-0.57,-0.29,-0.15,-0.23,-0.45,-0.62,-0.55,-0.45,-0.2,-0.23,-0.34,-0.53,-0.47,-0.41,-0.21,-0.26,-0.25,-0.42,-0.5,-0.42,-0.32,-0.39,-0.16,-0.29,-0.52,-0.48,-0.43,-0.36,-0.17,-0.24,-0.4,-0.55,-0.37,-0.35,-0.29,-0.07,-0.29,-0.54,-0.48,-0.38,-0.37,-0.16,-0.19,-0.34,-0.52,-0.45,-0.49,-0.42,-0.08,-0.23,-0.34,-0.49,-0.43,-0.38,-0.37,-0.12,-0.27,-0.48,-0.59,-0.52,-0.39,-0.19,-0.15,-0.35,-0.56,-0.42,-0.35,-0.43,-0.18,-0.2,-0.39,-0.54,-0.47,-0.38,-0.37,-0.15,-0.22,-0.5,-0.53,-0.46,-0.34,-0.23,-0.2,-0.35,-0.51,-0.36,-0.4,-0.39,-0.22,-0.24,-0.43,-0.45,-0.41,-0.4,-0.34,-0.21,-0.26,-0.5,-0.47,-0.44,-0.46,-0.31,-0.2,-0.27,-0.48,-0.4,-0.34,-0.4,-0.17,-0.25,-0.45,-0.47,-0.41,-0.45,-0.24,-0.26,-0.27,-0.5,-0.44,-0.38,-0.34,-0.37,-0.27,-0.27,-0.44,-0.44,-0.43,-0.44,-0.17,-0.19,-0.35,-0.5,-0.43,-0.37,-0.29,-0.23,-0.23,-0.44,-0.53,-0.42,-0.41,-0.24,-0.23,-0.29,-0.49,-0.44,-0.41,-0.31,-0.21,-0.2,-0.39,-0.52,-0.48,-0.39,-0.34,-0.22,-0.23,-0.47,-0.52,-0.42,-0.32,-0.32,-0.19,-0.32,-0.55,-0.48,-0.42,-0.32,-0.22,-0.18,-0.39,-0.52,-0.43,-0.47,-0.33,-0.15,-0.19,-0.48,-0.58,-0.39,-0.34,-0.21,-0.21,-0.37,-0.55,-0.44,-0.35,-0.2,-0.17,-0.23,-0.5,-0.55,-0.46,-0.3,-0.23,-0.21,-0.16,-0.43,-0.42,-0.37,-0.25:-1.32,-1.05,-0.64,-0.38,0.01,-0.6,-1.07,-1.17,-0.91,-0.47,-0.05,-0.34,-0.78,-1.26,-1.01,-0.75,-0.12,-0.13,-0.6,-1.22,-1.24,-0.97,-0.37,0.04,-0.48,-0.88,-1.26,-0.99,-0.7,-0.11,-0.16,-0.65,-1.14,-1.23,-0.84,-0.46,0.05,-0.43,-0.95,-1.27,-0.9,-0.71,-0.14,-0.09,-0.7,-1.26,-1.13,-0.84,-0.46,0.16,-0.46,-0.96,-1.38,-1.0,-0.68,-0.17,-0.16,-0.55,-1.06,-1.29,-0.84,-0.59,-0.06,-0.19,-0.76,-1.24,-1.06,-0.87,-0.49,0.07,-0.4,-0.88,-1.29,-1.04,-0.75,-0.18,-0.08,-0.52,-1.05,-1.3,-0.87,-0.66,-0.09,-0.13,-0.63,-1.21,-1.26,-0.88,-0.46,0.07,-0.39,-0.74,-1.23,-1.09,-0.85,-0.34,-0.07,-0.43,-0.79,-1.24,-1.02,-0.75,-0.3,-0.1,-0.62,-1.0,-1.1,-0.96,-0.41,0.03,-0.42,-0.96,-1.35,-0.95,-0.8,-0.07,-0.01,-0.72,-1.13,-1.07,-0.75,-0.68,-0.02,-0.36,-0.68,-1.13,-1.11,-0.79,-0.43,-0.04,-0.4,-0.91,-1.33,-1.04,-0.76,0.05,-0.17,-0.69,-1.09,-1.23,-0.94,-0.55,0.09,-0.44,-0.85,-1.28,-0.99,-0.65,-0.25,-0.16,-0.67,-1.13,-1.18,-0.9,-0.47,0.11,-0.56,-0.88,-1.26,-1.04,-0.68,-0.16,-0.14,-0.59,-1.06,-1.34,-0.87,-0.53,-0.1,-0.22,-0.67,-1.2,-1.26,-0.79,-0.42,-0.01,-0.37,-0.75,-1.19,-1.12,-0.77,-0.39,0.07,-0.51,-0.88,-1.23,-1.16,-0.68,-0.07,-0.12,-0.6,-1.19,-1.22,-0.73,-0.63,0.09,-0.41,-0.77,-1.21,-1.07,-0.73,-0.19,-0.06,-0.6,-1.08,-1.26:SAWING
-1.39,-1.18,-0.8,-0.19,0.08,-0.11,-0.73,-1.3,-1.27,-0.94,-0.35,0.09,0.02,-0.69,-1.46,-1.27,-0.88,-0.19,0.11,-0.11,-0.74,-1.33,-1.26,-0.89,-0.42,0.02,-0.02,-0.42,-1.09,-1.21,-1.06,-0.76,-0.41,-0.02,-0.02,-0.49,-1.12,-1.26,-1.06,-0.56,0.01,-0.01,-0.3,-1.06,-1.33,-1.12,-0.67,-0.09,0.02,-0.26,-1.0,-1.38,-1.12,-0.64,-0.07,0.05,-0.25,-0.96,-1.36,-1.19,-0.75,-0.09,0.08,-0.18,-0.85,-1.41,-1.26,-0.8,-0.18,0.08,-0.15,-0.67,-1.39,-1.32,-0.92,-0.3,0.08,-0.08,-0.62,-1.3,-1.36,-0.98,-0.33,0.07,0.0,-0.53,-1.35,-1.4,-1.07,-0.44,0.05,0.02,-0.39,-1.04,-1.39,-1.18,-0.72,-0.13,0.1,-0.1,-0.79,-1.42,-1.33,-0.94,-0.26,0.13,0.02,-0.61,-1.47,-1.32,-0.95,-0.18,0.16,-0.06,-0.88,-1.45,-1.2,-0.59,0.08,0.04,-0.49,-1.35,-1.26,-0.95,-0.27,0.09,-0.07,-0.73,-1.46,-1.26,-0.84,-0.22,0.11,-0.09,-0.72,-1.42,-1.3,-0.89,-0.26,0.09,-0.1,-0.73,-1.39,-1.26,-0.87,-0.26,0.06,-0.11,-0.75,-1.34,-1.26,-0.86,-0.28,0.04,-0.05,-0.61,-1.44,-1.24,-0.98,-0.27,0.07,-0.07,-0.69,-1.44,-1.26,-0.86,-0.26,0.04,-0.08,-0.64,-1.33,-1.27,-0.96,-0.35,0.06,-0.03,-0.55,-1.32,-1.38,-1.1,-0.49,0.07,0.08,-0.37,-1.44,-1.45,-1.19,-0.38,0.43,0.18,-0.99,-1.74,-1.33,-0.75,0.02,0.16,-0.22,-0.95,-1.53,-1.27,-0.81,-0.12,0.06,-0.13,-0.8,-1.47:-0.32,-0.12,-0.32,-0.57,-0.8,-0.78,-0.66,-0.36,-0.09,-0.22,-0.54,-0.69,-0.74,-0.67,-0.38,-0.29,-0.08,-0.38,-0.65,-0.78,-0.73,-0.42,-0.25,-0.11,-0.37,-0.63,-0.81,-0.74,-0.52,-0.35,-0.17,-0.22,-0.45,-0.65,-0.72,-0.55,-0.39,-0.24,-0.23,-0.39,-0.59,-0.65,-0.58,-0.42,-0.13,-0.16,-0.39,-0.56,-0.7,-0.58,-0.38,-0.18,-0.14,-0.41,-0.67,-0.72,-0.59,-0.45,-0.19,-0.29,-0.38,-0.58,-0.67,-0.62,-0.5,-0.41,-0.32,-0.28,-0.39,-0.53,-0.64,-0.63,-0.51,-0.31,-0.2,-0.24,-0.46,-0.61,-0.74,-0.47,-0.4,-0.07,-0.28,-0.38,-0.71,-0.64,-0.54,-0.27,-0.23,-0.25,-0.51,-0.71,-0.66,-0.53,-0.36,-0.09,-0.23,-0.46,-0.76,-0.73,-0.54,-0.39,-0.12,-0.19,-0.42,-0.69,-0.6,-0.62,-0.4,-0.25,-0.15,-0.36,-0.66,-0.69,-0.62,-0.47,-0.22,-0.16,-0.33,-0.64,-0.75,-0.67,-0.37,-0.32,-0.13,-0.34,-0.65,-0.72,-0.68,-0.58,-0.26,-0.21,-0.19,-0.5,-0.7,-0.71,-0.65,-0.42,-0.17,-0.18,-0.43,-0.68,-0.8,-0.71,-0.46,-0.32,-0.08,-0.36,-0.69,-0.76,-0.6,-0.48,-0.17,-0.21,-0.48,-0.76,-0.73,-0.49,-0.31,-0.16,-0.4,-0.63,-0.66,-0.6,-0.51,-0.21,-0.25,-0.36,-0.71,-0.7,-0.65,-0.39,-0.19,-0.2,-0.39,-0.65,-0.71,-0.66,-0.4,-0.22,-0.17,-0.4,-0.62,-0.69,-0.66,-0.41,-0.18,-0.22,-0.38,-0.65,-0.68,-0.62,-0.44,-0.37,-0.08,-0.39,-0.62,-0.71,-0.65,-0.44,-0.29,-0.16,-0.32,-0.67,-0.8,-0.67:-0.81,-0.61,-0.36,-0.15,-0.47,-0.83,-1.12,-0.8,-0.63,-0.35,-0.12,-0.52,-0.76,-1.1,-0.87,-0.69,-0.52,-0.1,-0.45,-0.64,-1.0,-1.0,-0.75,-0.64,-0.15,-0.29,-0.53,-0.94,-1.14,-0.81,-0.68,-0.37,-0.11,-0.55,-0.87,-1.09,-0.82,-0.73,-0.48,-0.15,-0.49,-0.61,-1.07,-0.99,-0.65,-0.66,-0.09,-0.38,-0.58,-0.95,-1.16,-0.82,-0.68,-0.37,-0.27,-0.59,-0.9,-1.19,-0.89,-0.68,-0.21,-0.21,-0.52,-0.75,-1.24,-0.97,-0.69,-0.25,-0.13,-0.53,-0.92,-1.14,-0.86,-0.73,-0.37,-0.24,-0.4,-0.72,-1.07,-0.93,-0.66,-0.62,-0.26,-0.43,-0.63,-0.85,-0.97,-0.86,-0.7,-0.57,-0.22,-0.44,-0.67,-1.13,-1.08,-0.79,-0.49,-0.19,-0.34,-0.61,-1.05,-1.13,-0.72,-0.61,-0.27,-0.33,-0.65,-1.01,-1.09,-0.8,-0.59,-0.2,-0.26,-0.56,-0.92,-1.18,-0.85,-0.62,-0.16,-0.25,-0.55,-0.87,-1.23,-0.91,-0.68,-0.27,-0.16,-0.48,-0.83,-1.14,-0.97,-0.68,-0.36,-0.11,-0.42,-0.75,-1.2,-1.0,-0.77,-0.45,-0.03,-0.38,-0.69,-1.13,-1.02,-0.82,-0.46,-0.12,-0.39,-0.56,-0.98,-1.13,-0.82,-0.65,-0.19,-0.16,-0.46,-0.77,-1.22,-0.91,-0.7,-0.29,-0.08,-0.5,-0.83,-1.27,-0.85,-0.57,-0.19,-0.29,-0.7,-1.0,-1.0,-0.72,-0.49,-0.06,-0.48,-0.79,-1.18,-0.94,-0.61,-0.3,-0.17,-0.56,-0.83,-1.18,-0.94,-0.68,-0.19,-0.13,-0.49,-0.85,-1.19,-0.94,-0.67,-0.17,-0.15,-0.54,-0.83,-1.18,-0.88,-0.68,-0.21,-0.2,-0.52,-0.77:SAWING
-0.45,0.39,1.25,0.8,-0.43,-0.66,-0.03,1.14,1.05,0.27,-0.7,-0.52,0.49,1.29,0.68,-0.37,-0.65,-0.1,1.0,1.08,0.29,-0.65,-0.56,0.36,1.12,0.83,-0.13,-0.68,-0.29,0.69,1.09,0.51,-0.45,-0.66,-0.04,1.15,1.08,0.41,-0.7,-0.71,-0.04,1.29,1.17,0.3,-0.66,-0.78,-0.18,1.19,1.09,0.22,-0.68,-0.55,0.12,1.35,1.06,0.08,-0.71,-0.49,0.29,1.34,0.9,-0.16,-0.6,-0.35,0.43,1.44,0.77,-0.19,-0.62,-0.32,0.84,1.29,0.65,-0.41,-0.62,-0.19,0.96,1.17,0.62,-0.48,-0.63,-0.19,1.04,1.13,0.46,-0.58,-0.63,0.02,1.32,1.01,-0.1,-0.77,-0.49,0.44,1.38,0.77,-0.19,-0.65,-0.37,0.7,1.32,0.63,-0.46,-0.79,-0.37,0.99,1.31,0.53,-0.59,-0.71,-0.21,1.21,1.12,0.24,-0.79,-0.59,0.31,1.34,0.95,-0.09,-0.8,-0.54,0.35,1.34,1.0,0.03,-0.82,-0.68,0.26,1.54,0.97,0.03,-0.79,-0.41,0.44,1.24,0.94,-0.01,-0.92,-0.48,0.67,1.37,0.87,-0.33,-0.88,-0.54,0.8,1.46,0.81,-0.51,-0.95,-0.43,0.9,1.4,0.68,-0.75,-0.92,-0.14,1.49,1.26,-0.07,-0.93,-0.68,0.11,1.56,1.15,0.12,-0.82,-0.71,0.04,1.42,1.11,0.24,-0.7,-0.75,-0.14,1.34,1.24,0.22,-0.84,-0.65,0.24,1.54,0.96,-0.4,-0.99,-0.56,0.72,1.58,1.01,-0.03,-0.82,-0.67,0.27,1.55,0.9,-0.36,-0.73,-0.29,0.62,1.36,0.92,-0.34,-0.79,-0.32,1.01:1.12,0.67,0.48,0.32,0.35,1.04,0.96,0.45,0.45,0.27,0.62,1.11,0.83,0.53,0.18,0.2,0.93,1.07,0.7,0.42,0.29,0.48,1.19,0.77,0.56,0.45,0.33,0.77,1.11,0.8,0.53,0.38,0.55,0.98,0.83,0.55,0.42,0.32,0.63,1.03,0.84,0.62,0.4,0.37,0.82,0.94,0.68,0.53,0.37,0.53,0.96,0.98,0.52,0.38,0.37,0.67,1.04,0.83,0.77,0.51,0.33,0.59,1.02,0.99,0.73,0.47,0.52,1.11,0.93,0.63,0.61,0.47,0.55,1.19,0.75,0.57,0.47,0.56,1.08,0.96,0.69,0.45,0.42,0.88,0.98,0.7,0.6,0.43,0.65,0.96,0.79,0.78,0.53,0.58,0.89,0.83,0.85,0.68,0.53,0.68,0.98,0.76,0.76,0.65,0.5,0.85,0.8,0.83,0.73,0.47,0.5,1.03,0.63,0.6,0.58,0.65,0.55,1.08,0.74,0.62,0.58,0.27,0.4,1.11,0.8,0.65,0.3,0.35,0.53,1.13,0.78,0.57,0.42,0.29,0.62,1.03,0.75,0.53,0.43,0.41,0.69,1.03,0.65,0.4,0.67,0.5,0.8,1.01,0.68,0.55,0.5,0.45,1.09,1.03,0.63,0.6,0.58,0.65,1.04,0.93,0.76,0.55,0.42,0.63,1.01,1.01,0.74,0.47,0.47,0.7,1.08,0.91,0.61,0.42,0.4,0.87,0.99,0.83,0.61,0.5,0.45,0.88,0.86,0.74,0.81,0.46,0.53,1.02,0.74,0.67,0.76,0.54,0.63,1.03,0.87,0.65,0.6,0.52,0.73,0.92,0.83,0.74,0.45,0.47,0.72,0.97:-0.62,-0.42,-0.47,-1.11,-1.07,-0.7,-0.43,-0.25,-0.89,-1.24,-0.85,-0.51,-0.31,-0.39,-1.02,-1.05,-0.83,-0.4,-0.16,-0.62,-1.17,-0.94,-0.47,-0.04,-0.25,-0.89,-1.22,-1.03,-0.34,0.02,-0.3,-1.04,-1.12,-0.7,-0.13,-0.08,-0.52,-1.22,-1.05,-0.4,0.06,-0.28,-1.04,-1.32,-0.82,0.02,0.11,-0.51,-1.44,-1.12,-0.54,0.02,-0.16,-0.85,-1.27,-0.92,-0.3,-0.07,-0.36,-0.91,-1.15,-0.87,-0.2,-0.06,-0.62,-1.2,-1.09,-0.8,-0.29,-0.11,-0.61,-1.34,-1.1,-0.77,-0.1,-0.3,-1.02,-1.17,-0.76,-0.44,-0.1,-0.31,-1.09,-1.08,-0.83,-0.26,-0.23,-0.76,-1.1,-0.82,-0.61,-0.23,-0.54,-1.12,-0.92,-0.55,-0.39,-0.39,-0.97,-1.04,-0.6,-0.51,-0.33,-0.48,-1.02,-1.02,-0.75,-0.4,-0.22,-0.69,-1.1,-0.8,-0.52,-0.25,-0.29,-0.89,-1.14,-0.86,-0.43,-0.19,-0.47,-1.07,-1.11,-0.84,-0.37,-0.18,-0.71,-1.05,-0.85,-0.53,-0.28,-0.43,-0.96,-1.09,-0.78,-0.3,-0.19,-0.65,-1.2,-1.02,-0.67,-0.24,-0.21,-0.67,-1.18,-0.92,-0.34,-0.05,-0.45,-0.92,-0.99,-0.75,-0.5,-0.06,-0.3,-1.04,-1.06,-0.64,-0.2,-0.14,-0.75,-1.17,-0.77,-0.16,-0.11,-0.48,-1.14,-1.23,-0.62,-0.04,-0.28,-0.88,-1.12,-0.74,-0.17,-0.14,-0.62,-1.1,-0.98,-0.53,-0.05,-0.2,-0.79,-1.09,-0.79,-0.21,-0.14,-0.5,-1.02,-0.94,-0.6,-0.17,-0.28,-0.74,-1.0,-0.89,-0.48,-0.35,-0.43,-0.92,-1.03,-0.69,-0.32,-0.16,-0.37,-1.01:SAWING
-0.32,-1.7,-1.39,-0.31,0.67,0.56,-0.37,-1.67,-1.34,-0.27,0.6,0.6,-0.41,-1.7,-1.35,-0.25,0.64,0.55,-0.59,-1.61,-1.22,-0.13,0.68,0.55,-0.68,-1.71,-1.13,-0.09,0.71,0.46,-0.78,-1.63,-1.0,0.05,0.52,0.36,-1.05,-1.58,-0.86,0.42,0.63,0.15,-1.32,-1.59,-0.85,0.4,0.6,0.14,-1.2,-1.67,-0.81,0.38,0.52,0.12,-1.25,-1.65,-0.76,0.45,0.55,0.07,-1.38,-1.61,-0.73,0.48,0.58,0.04,-1.26,-1.6,-0.93,0.19,0.51,0.25,-0.98,-1.67,-1.01,0.22,0.53,0.22,-1.02,-1.76,-0.85,0.39,0.49,0.05,-1.21,-1.66,-0.78,0.44,0.51,0.1,-1.18,-1.66,-0.89,0.36,0.54,0.05,-1.21,-1.47,-0.68,0.42,0.47,-0.1,-1.53,-1.41,-0.36,0.55,0.5,-0.22,-1.57,-1.46,-0.35,0.63,0.47,-0.68,-1.63,-1.1,0.1,0.58,0.35,-0.68,-1.61,-1.16,0.0,0.59,0.45,-0.45,-1.7,-1.28,-0.15,0.6,0.4,-0.45,-1.59,-1.3,-0.31,0.55,0.5,-0.28,-1.64,-1.39,-0.23,0.57,0.43,-0.51,-1.59,-1.22,-0.14,0.48,0.43,-0.28,-1.67,-1.52,-0.52,0.66,0.5,-0.2,-1.57,-1.48,-0.55,0.55,0.49,-0.1,-1.58,-1.52,-0.56,0.57,0.56,-0.25,-1.69,-1.37,-0.15,0.6,0.38,-0.59,-1.65,-1.33,-0.36,0.57,0.59,-0.22,-1.85,-1.52,-0.33,0.65,0.55,-0.24,-1.73,-1.52,-0.62,0.44,0.57,0.2,-1.3,-1.78,-0.9,0.29,0.6,0.36,-1.11,-1.75,-0.99,0.19,0.58,0.39,-1.11,-1.76:-0.37,-1.01,-1.0,-0.72,-0.74,-0.65,-0.29,-0.96,-0.97,-0.72,-0.84,-0.59,-0.2,-1.02,-1.16,-0.71,-0.66,-0.65,-0.38,-0.68,-1.1,-0.82,-0.82,-0.62,-0.35,-0.46,-1.1,-0.92,-0.78,-0.64,-0.4,-0.68,-1.04,-0.72,-0.63,-0.67,-0.32,-0.61,-1.26,-0.86,-0.59,-0.7,-0.47,-0.46,-1.25,-0.86,-0.44,-0.68,-0.53,-0.56,-1.12,-0.76,-0.54,-0.68,-0.32,-0.87,-1.11,-0.69,-0.55,-0.68,-0.39,-0.91,-1.0,-0.75,-0.69,-0.56,-0.27,-0.89,-1.26,-0.78,-0.4,-0.58,-0.44,-0.86,-1.19,-0.81,-0.48,-0.65,-0.42,-0.83,-1.22,-0.75,-0.56,-0.6,-0.38,-0.91,-1.07,-0.72,-0.62,-0.52,-0.47,-1.26,-0.88,-0.55,-0.57,-0.46,-0.48,-1.22,-1.0,-0.67,-0.5,-0.36,-0.8,-1.19,-0.85,-0.44,-0.46,-0.3,-0.92,-1.21,-0.82,-0.6,-0.44,-0.21,-1.0,-1.1,-0.82,-0.62,-0.56,-0.31,-0.91,-1.11,-0.84,-0.6,-0.55,-0.28,-1.0,-0.91,-0.68,-0.65,-0.53,-0.35,-1.05,-0.86,-0.51,-0.66,-0.62,-0.37,-1.11,-0.9,-0.57,-0.65,-0.55,-0.46,-0.96,-0.89,-0.81,-0.64,-0.63,-0.34,-1.0,-0.69,-0.58,-0.73,-0.33,-0.54,-1.05,-0.88,-0.74,-0.48,-0.21,-0.78,-1.25,-0.74,-0.4,-0.6,-0.43,-0.82,-1.11,-0.73,-0.5,-0.43,-0.3,-1.04,-1.25,-0.86,-0.4,-0.52,-0.8,-0.97,-0.79,-0.84,-0.88,-0.78,-0.82,-0.77,-0.37,-0.7,-0.45,-0.7,-0.24,-0.99,-0.59,-0.04,-0.08,-0.24,-0.26,-0.19,-0.18,-0.19,-0.2,-0.19,-0.2,-0.2,-0.19,-0.19:-0.57,-0.28,-0.24,-0.67,-1.1,-0.78,-0.34,-0.14,-0.35,-0.79,-1.11,-0.73,-0.36,-0.23,-0.27,-0.96,-1.14,-0.68,-0.4,-0.18,-0.33,-0.83,-1.11,-0.65,-0.3,-0.19,-0.47,-0.97,-1.04,-0.53,-0.23,-0.34,-0.49,-0.93,-1.0,-0.64,-0.34,-0.17,-0.33,-0.8,-1.22,-0.63,-0.28,-0.16,-0.38,-0.77,-1.17,-0.71,-0.39,-0.26,-0.36,-0.76,-1.13,-0.72,-0.39,-0.28,-0.39,-1.13,-1.14,-0.54,-0.3,-0.34,-0.32,-0.82,-1.2,-0.74,-0.29,-0.25,-0.51,-0.76,-0.89,-0.54,-0.29,-0.35,-0.48,-1.07,-0.85,-0.53,-0.22,-0.48,-0.51,-0.99,-0.87,-0.66,-0.46,-0.38,-0.53,-1.05,-0.81,-0.54,-0.34,-0.49,-0.59,-1.11,-0.82,-0.51,-0.37,-0.41,-0.44,-0.98,-0.88,-0.66,-0.36,-0.33,-0.45,-1.16,-0.97,-0.52,-0.13,-0.31,-0.53,-0.91,-0.82,-0.51,-0.21,-0.36,-0.57,-1.18,-0.97,-0.59,-0.33,-0.43,-0.38,-1.05,-1.14,-0.62,-0.3,-0.38,-0.41,-1.06,-1.08,-0.57,-0.34,-0.39,-0.43,-1.01,-0.95,-0.58,-0.32,-0.39,-0.49,-1.04,-0.93,-0.65,-0.3,-0.29,-0.49,-1.29,-0.87,-0.45,-0.16,-0.42,-0.44,-1.2,-0.99,-0.52,-0.22,-0.36,-0.41,-1.02,-1.12,-0.65,-0.44,-0.3,-0.37,-0.75,-1.18,-0.71,-0.38,-0.21,-0.32,-0.78,-1.24,-0.72,-0.35,-0.31,-0.33,-0.69,-1.23,-0.9,-0.55,-0.25,-0.37,-0.6,-1.17,-0.77,-0.43,-0.29,-0.4,-0.63,-1.18,-0.79,-0.46,-0.23,-0.33,-0.71,-1.23,-0.74,-0.31,-0.17,-0.43,-1.06,-1.19,-0.6,-0.17,-0.3:SAWING
-1.21,-1.8,-0.81,0.66,0.7,-0.18,-1.76,-1.38,-0.01,0.71,0.34,-1.13,-1.65,-0.62,0.61,0.56,-0.4,-1.7,-1.26,0.09,0.64,0.34,-0.96,-1.7,-0.92,0.44,0.62,0.1,-1.52,-1.53,-0.44,0.61,0.6,-0.52,-1.77,-1.21,0.22,0.77,0.34,-1.34,-1.66,-0.74,0.57,0.59,-0.02,-1.59,-1.49,-0.43,0.6,0.6,-0.31,-1.65,-1.23,0.03,0.62,0.34,-0.86,-1.54,-0.99,0.27,0.65,0.38,-1.16,-1.64,-0.8,0.52,0.53,0.04,-1.4,-1.46,-0.51,0.52,0.58,-0.22,-1.61,-1.28,-0.12,0.62,0.37,-0.92,-1.59,-0.88,0.4,0.57,0.16,-1.34,-1.51,-0.69,0.5,0.55,-0.1,-1.55,-1.3,-0.32,0.54,0.42,-0.42,-1.49,-1.27,-0.27,0.5,0.51,-0.31,-1.61,-1.28,-0.13,0.64,0.3,-0.63,-1.51,-1.13,-0.11,0.58,0.44,-0.59,-1.57,-1.14,0.0,0.56,0.37,-0.86,-1.6,-0.98,0.32,0.66,0.18,-1.22,-1.47,-0.72,0.44,0.53,0.05,-1.4,-1.46,-0.48,0.51,0.47,-0.4,-1.47,-1.13,-0.06,0.52,0.36,-0.82,-1.53,-1.01,0.16,0.57,0.26,-1.01,-1.5,-0.92,0.24,0.63,0.22,-1.25,-1.48,-0.8,0.38,0.55,-0.03,-1.44,-1.34,-0.57,0.49,0.44,-0.16,-1.42,-1.26,-0.38,0.45,0.43,-0.28,-1.53,-1.32,-0.32,0.52,0.39,-0.37,-1.47,-1.14,-0.05,0.56,0.29,-0.81,-1.5,-0.96,0.21,0.52,0.19,-1.01,-1.47,-0.89,0.15,0.49,0.28,-0.73,-1.54,-1.08,0.02,0.54,0.33,-0.83,-1.61,-0.98,0.29:-1.21,-0.94,-0.74,-0.84,-0.34,-0.74,-1.32,-0.78,-0.62,-0.75,-0.28,-1.24,-1.05,-0.46,-0.64,-0.45,-0.71,-1.26,-0.89,-0.4,-0.69,-0.47,-1.13,-1.0,-0.59,-0.55,-0.47,-0.79,-1.22,-0.81,-0.37,-0.83,-0.35,-1.04,-1.08,-0.56,-0.68,-0.68,-0.55,-1.12,-0.82,-0.5,-0.85,-0.34,-0.92,-0.99,-0.59,-0.73,-0.73,-0.37,-1.0,-0.93,-0.77,-0.66,-0.44,-0.58,-1.28,-0.8,-0.44,-0.81,-0.51,-0.7,-1.09,-0.83,-0.72,-0.67,-0.39,-0.95,-1.01,-0.66,-0.62,-0.72,-0.28,-0.99,-1.1,-0.81,-0.6,-0.56,-0.59,-1.08,-0.73,-0.6,-0.75,-0.46,-0.73,-1.11,-0.78,-0.63,-0.67,-0.4,-1.05,-0.95,-0.72,-0.71,-0.62,-0.46,-1.06,-0.86,-0.71,-0.77,-0.57,-0.55,-1.22,-0.95,-0.7,-0.59,-0.39,-0.74,-1.17,-0.75,-0.6,-0.76,-0.41,-0.57,-1.14,-0.97,-0.75,-0.6,-0.35,-0.89,-1.22,-0.93,-0.57,-0.65,-0.41,-0.9,-1.18,-0.76,-0.58,-0.76,-0.4,-0.97,-1.07,-0.77,-0.68,-0.7,-0.51,-1.16,-0.95,-0.54,-0.71,-0.71,-0.49,-1.1,-0.97,-0.65,-0.66,-0.43,-0.83,-1.04,-0.75,-0.76,-0.71,-0.39,-0.96,-1.09,-0.78,-0.73,-0.7,-0.44,-1.08,-0.98,-0.75,-0.85,-0.58,-0.38,-1.08,-0.85,-0.67,-0.83,-0.51,-0.32,-1.14,-1.2,-0.75,-0.54,-0.59,-0.72,-1.21,-0.92,-0.48,-0.65,-0.55,-0.55,-1.09,-0.96,-0.71,-0.73,-0.5,-0.75,-1.0,-0.74,-0.75,-0.75,-0.4,-0.86,-1.08,-0.81,-0.63,-0.56,-0.41,-1.09,-1.2,-0.82,-0.6,-0.67:-0.55,-0.01,-0.27,-0.68,-1.16,-0.77,-0.18,-0.22,-0.4,-0.99,-1.08,-0.55,0.03,-0.27,-0.6,-1.08,-0.8,-0.35,0.13,-0.28,-0.87,-1.01,-0.71,-0.12,-0.14,-0.56,-0.99,-0.84,-0.47,0.03,-0.36,-1.0,-0.91,-0.7,-0.19,-0.07,-0.71,-1.07,-0.76,-0.45,0.03,-0.38,-0.88,-1.0,-0.63,-0.19,-0.23,-0.51,-0.99,-0.87,-0.55,-0.13,-0.33,-0.7,-0.99,-0.7,-0.46,-0.11,-0.29,-0.92,-1.09,-0.69,-0.23,-0.13,-0.48,-1.09,-0.91,-0.51,-0.13,-0.24,-0.62,-0.86,-0.77,-0.51,-0.19,-0.32,-0.71,-1.07,-0.76,-0.41,-0.13,-0.37,-0.81,-1.06,-0.77,-0.26,-0.09,-0.47,-1.0,-0.94,-0.48,-0.18,-0.24,-0.54,-0.98,-0.83,-0.43,-0.17,-0.35,-0.77,-1.01,-0.64,-0.35,-0.11,-0.37,-0.87,-1.01,-0.61,-0.11,-0.16,-0.56,-0.94,-0.85,-0.49,-0.04,-0.12,-0.52,-1.16,-0.91,-0.45,-0.15,-0.27,-0.53,-0.92,-0.91,-0.53,-0.13,-0.26,-0.53,-1.13,-0.75,-0.36,-0.2,-0.34,-0.53,-0.98,-0.72,-0.31,-0.24,-0.42,-0.66,-0.87,-0.61,-0.38,-0.18,-0.41,-0.82,-0.86,-0.58,-0.27,-0.18,-0.46,-0.92,-0.8,-0.5,-0.18,-0.31,-0.62,-0.92,-0.72,-0.48,-0.14,-0.19,-0.64,-0.96,-0.69,-0.41,-0.11,-0.3,-0.73,-0.91,-0.56,-0.3,-0.22,-0.4,-0.78,-0.91,-0.68,-0.37,-0.2,-0.36,-0.8,-0.83,-0.58,-0.19,-0.18,-0.54,-0.95,-0.74,-0.48,-0.2,-0.36,-0.53,-0.89,-0.77,-0.44,-0.23,-0.36,-0.53,-0.85,-0.78,-0.47,-0.25,-0.3,-0.63,-0.93:SAWING
-0.95,-0.67,0.63,1.8,1.03,-0.24,-1.08,-0.6,0.73,1.85,0.92,-0.41,-1.03,-0.6,0.95,1.83,0.78,-0.65,-0.93,-0.37,1.31,1.56,0.61,-0.73,-0.93,-0.2,1.51,1.53,0.31,-1.07,-0.9,0.07,1.87,1.2,0.06,-1.28,-0.68,1.2,1.47,0.92,-0.13,-1.07,-0.67,0.98,1.64,0.78,-0.65,-0.92,-0.34,1.47,1.41,0.29,-0.92,-0.86,0.07,1.62,1.32,0.12,-1.15,-0.85,0.62,1.75,1.06,-0.26,-1.0,-0.69,0.49,1.73,1.05,-0.24,-1.02,-0.62,1.0,1.65,0.7,-0.63,-1.07,-0.42,1.65,1.52,0.0,-0.99,-0.77,0.3,1.94,0.92,-0.38,-0.95,-0.58,0.61,1.62,0.9,-0.09,-0.84,-0.7,0.36,1.62,1.22,-0.12,-1.04,-0.57,0.92,1.4,0.6,-0.75,-0.88,0.41,1.47,0.91,-0.14,-0.85,-0.64,0.64,1.7,0.73,-0.55,-0.9,-0.37,1.27,1.41,0.4,-0.77,-0.82,-0.17,1.45,1.44,0.52,-0.86,-1.09,-0.2,1.71,1.44,0.09,-1.14,-0.83,0.36,1.78,1.09,-0.09,-0.97,-0.85,0.22,1.85,1.17,-0.22,-0.98,-0.85,0.32,1.82,1.12,-0.3,-1.06,-0.73,0.69,1.85,0.9,-0.4,-1.14,-0.63,0.92,1.85,0.75,-0.52,-1.11,-0.33,1.53,1.42,0.52,-0.8,-1.06,-0.27,1.61,1.49,0.51,-1.03,-1.1,0.06,1.67,1.35,0.2,-1.12,-0.96,0.36,1.91,0.97,-0.46,-1.07,-0.6,1.05,1.88,0.58,-0.9,-1.11,-0.32,1.53,1.72,0.47,-0.88,-1.2,-0.04,1.94,1.23,0.16,-0.99,-0.89,0.02:0.04,0.32,0.93,0.7,0.5,0.13,0.04,0.5,0.94,0.61,0.38,0.27,0.26,0.63,0.82,0.57,0.5,0.17,0.15,0.63,0.91,0.64,0.41,0.04,0.22,0.8,0.98,0.38,0.37,0.19,0.63,0.91,0.65,0.5,0.28,0.09,0.16,1.01,0.6,0.51,0.35,0.09,0.38,0.79,0.69,0.58,0.23,0.13,0.64,0.88,0.58,0.63,0.08,0.21,0.83,0.92,0.55,0.33,0.11,0.2,0.92,0.83,0.51,0.38,0.15,0.3,0.94,0.86,0.73,0.29,0.05,0.22,1.01,0.84,0.42,0.43,0.1,0.57,1.03,0.64,0.51,0.19,0.16,0.76,0.88,0.51,0.45,0.27,0.27,0.7,0.93,0.55,0.34,0.13,0.33,0.9,0.82,0.6,0.35,0.27,0.29,0.86,0.78,0.57,0.35,0.3,0.38,0.9,0.75,0.53,0.34,0.25,0.39,0.89,0.73,0.43,0.32,0.29,0.76,0.77,0.47,0.35,0.25,0.38,0.76,0.8,0.5,0.46,0.17,0.41,0.99,0.74,0.4,0.52,0.17,0.35,0.94,0.75,0.47,0.41,0.13,0.26,0.97,0.7,0.22,0.38,0.5,0.97,0.87,0.46,0.03,0.25,0.83,1.06,1.54,0.7,0.52,0.27,0.1,-0.1,0.08,0.05,0.06,0.05,0.05,0.07,0.12,0.12,0.13,0.11,0.12,0.1,0.11,0.11,0.1,0.1,0.12,0.12,0.12,0.11,0.1,0.11,0.1,0.11,0.11,0.13,0.1,0.12,0.12,0.13,0.1,0.12,0.11,0.12,0.11,0.12,0.11,0.11,0.12,0.12,0.12,0.12,0.11,0.1,0.11,0.12:-0.3,-0.51,-0.95,-1.22,-0.93,-0.65,-0.18,-0.43,-1.24,-1.26,-0.92,-0.61,-0.15,-0.31,-1.01,-1.29,-1.05,-0.45,-0.05,-0.55,-1.34,-1.26,-0.87,-0.4,-0.2,-0.59,-1.16,-1.17,-0.87,-0.45,-0.3,-0.77,-1.24,-0.97,-0.73,-0.31,-0.4,-0.96,-1.1,-0.96,-0.88,-0.09,-0.52,-1.22,-1.06,-0.83,-0.65,-0.11,-0.47,-1.33,-1.21,-0.87,-0.36,-0.11,-0.62,-1.2,-1.08,-0.9,-0.47,-0.18,-0.65,-1.45,-1.15,-0.76,-0.1,-0.18,-0.92,-1.39,-1.15,-0.77,-0.03,-0.39,-1.1,-1.3,-0.97,-0.51,-0.05,-0.48,-1.19,-1.17,-0.88,-0.5,-0.23,-0.43,-0.94,-1.17,-1.08,-0.54,-0.16,-0.53,-1.18,-1.19,-0.9,-0.2,-0.46,-0.97,-1.08,-0.72,-0.72,-0.52,-0.41,-0.7,-1.33,-1.24,-0.58,-0.14,-0.58,-1.13,-1.18,-0.87,-0.45,-0.1,-0.57,-1.21,-1.22,-0.85,-0.57,-0.13,-0.45,-1.36,-1.24,-0.85,-0.41,-0.15,-0.64,-1.29,-1.19,-0.87,-0.72,-0.08,-0.52,-1.27,-1.13,-0.33,-0.03,-0.19,-0.2,0.3,0.44,1.0,0.5,-0.72,-0.03,0.28,0.25,0.09,0.08,0.09,0.09,0.08,0.09,0.08,0.07,0.06,0.07,0.06,0.08,0.06,0.06,0.06,0.06,0.06,0.06,0.05,0.05,0.06,0.08,0.06,0.05,0.06,0.06,0.06,0.05,0.06,0.06,0.05,0.06,0.06,0.05,0.06,0.05,0.05,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.05,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.05,0.05,0.05,0.05,0.06,0.06,0.05:SAWING
-0.56,0.64,0.76,-0.25,-1.71,-1.23,0.01,0.64,0.31,-1.25,-1.5,-0.56,0.62,0.58,-0.32,-1.67,-1.06,0.2,0.57,0.21,-1.2,-1.61,-0.56,0.68,0.61,-0.41,-1.66,-1.17,0.09,0.74,0.48,-0.98,-1.65,-0.75,0.55,0.66,0.02,-1.46,-1.41,-0.44,0.6,0.63,-0.05,-1.57,-1.41,-0.25,0.66,0.56,-0.43,-1.58,-1.14,0.25,0.71,0.35,-1.05,-1.6,-0.76,0.44,0.69,0.16,-1.29,-1.49,-0.52,0.59,0.64,-0.06,-1.52,-1.39,-0.33,0.6,0.63,-0.23,-1.59,-1.39,-0.22,0.73,0.61,-0.55,-1.69,-1.14,0.22,0.72,0.38,-1.06,-1.67,-0.9,0.49,0.73,0.12,-1.52,-1.46,-0.41,0.6,0.68,-0.2,-1.65,-1.3,-0.41,0.56,0.66,-0.16,-1.64,-1.28,-0.2,0.51,0.43,-0.45,-1.57,-1.13,-0.07,0.51,0.41,-0.68,-1.58,-1.11,-0.06,0.57,0.45,-0.67,-1.63,-1.12,0.06,0.59,0.29,-1.01,-1.52,-0.82,0.32,0.56,0.12,-1.22,-1.51,-0.61,0.52,0.56,-0.13,-1.52,-1.36,-0.34,0.57,0.5,-0.38,-1.55,-1.1,-0.01,0.49,0.31,-0.63,-1.47,-0.99,0.08,0.56,0.37,-0.89,-1.65,-0.91,0.29,0.56,0.26,-1.17,-1.54,-0.65,0.46,0.63,0.04,-1.5,-1.39,-0.3,0.61,0.57,-0.35,-1.64,-1.13,0.21,0.7,0.37,-1.06,-1.52,-0.63,0.55,0.66,-0.14,-1.51,-1.23,-0.08,0.66,0.56,-0.33,-1.52,-1.25,-0.16,0.54,0.55,-0.46,-1.51,-1.11,0.04,0.58,0.35,-0.72,-1.52,-0.99,0.16,0.61,0.23,-1.08:-0.66,-1.0,-0.56,-0.63,-0.62,-0.46,-1.07,-0.75,-0.5,-0.68,-0.29,-0.85,-1.04,-0.58,-0.63,-0.49,-0.64,-1.09,-0.68,-0.58,-0.67,-0.41,-1.02,-0.85,-0.54,-0.7,-0.5,-1.0,-0.9,-0.68,-0.56,-0.43,-0.99,-0.89,-0.8,-0.55,-0.43,-0.72,-0.95,-0.8,-0.66,-0.64,-0.49,-1.07,-0.9,-0.68,-0.72,-0.51,-0.89,-0.83,-0.72,-0.81,-0.44,-0.59,-1.14,-0.9,-0.83,-0.61,-0.37,-1.0,-0.92,-0.68,-0.79,-0.51,-0.61,-1.12,-0.8,-0.75,-0.76,-0.35,-0.98,-0.94,-0.74,-0.73,-0.29,-0.75,-1.05,-0.82,-0.7,-0.49,-0.48,-1.14,-0.82,-0.64,-0.68,-0.29,-0.93,-1.0,-0.75,-0.79,-0.56,-0.29,-1.17,-0.9,-0.72,-0.77,-0.38,-0.44,-1.23,-0.83,-0.62,-0.74,-0.22,-0.66,-1.23,-0.76,-0.69,-0.62,-0.32,-0.99,-0.96,-0.68,-0.71,-0.41,-0.39,-1.24,-0.77,-0.57,-0.68,-0.2,-0.71,-1.01,-0.62,-0.77,-0.47,-0.36,-1.17,-0.81,-0.72,-0.68,-0.24,-1.0,-0.96,-0.76,-0.78,-0.49,-0.47,-1.28,-0.71,-0.67,-0.65,-0.26,-0.86,-1.14,-0.72,-0.73,-0.68,-0.34,-1.06,-1.0,-0.77,-0.76,-0.46,-0.45,-1.36,-0.92,-0.56,-0.72,-0.43,-0.49,-1.34,-0.97,-0.64,-0.67,-0.39,-0.84,-1.08,-0.76,-0.78,-0.61,-0.31,-1.07,-0.98,-0.69,-0.78,-0.59,-0.35,-1.1,-0.95,-0.7,-0.73,-0.44,-0.49,-1.32,-0.94,-0.6,-0.67,-0.48,-0.65,-1.2,-0.8,-0.64,-0.74,-0.38,-0.85,-1.0,-0.69,-0.77,-0.7,-0.25,-1.1,-0.96,-0.53,-0.78,-0.49,-0.42:-0.97,-0.53,-0.34,-0.51,-0.77,-0.83,-0.37,-0.43,-0.57,-0.68,-0.87,-0.46,-0.45,-0.56,-0.6,-0.82,-0.85,-0.57,-0.44,-0.53,-0.85,-0.7,-0.45,-0.32,-0.55,-0.71,-0.88,-0.66,-0.39,-0.49,-0.52,-0.98,-0.8,-0.58,-0.37,-0.37,-0.76,-0.92,-0.65,-0.34,-0.36,-0.57,-0.89,-0.78,-0.44,-0.33,-0.47,-0.87,-0.89,-0.53,-0.25,-0.36,-0.67,-0.98,-0.69,-0.39,-0.35,-0.52,-0.97,-0.87,-0.49,-0.21,-0.4,-0.64,-1.1,-0.75,-0.37,-0.26,-0.42,-0.97,-1.07,-0.57,-0.27,-0.27,-0.54,-1.01,-0.86,-0.51,-0.26,-0.34,-0.65,-1.0,-0.71,-0.51,-0.43,-0.43,-0.83,-0.85,-0.59,-0.48,-0.31,-0.57,-0.97,-0.85,-0.67,-0.43,-0.17,-0.68,-1.0,-0.79,-0.36,-0.24,-0.47,-0.93,-1.09,-0.65,-0.13,-0.21,-0.71,-1.24,-0.8,-0.19,-0.11,-0.54,-1.12,-1.07,-0.48,-0.05,-0.29,-0.69,-1.02,-0.74,-0.43,-0.25,-0.34,-0.84,-0.98,-0.68,-0.32,-0.22,-0.46,-1.0,-0.97,-0.55,-0.15,-0.29,-0.54,-1.02,-0.88,-0.51,-0.21,-0.35,-0.7,-1.0,-0.74,-0.39,-0.34,-0.47,-0.83,-0.97,-0.68,-0.42,-0.32,-0.41,-0.99,-0.97,-0.65,-0.36,-0.37,-0.5,-1.05,-0.82,-0.6,-0.29,-0.28,-0.53,-1.01,-0.85,-0.61,-0.23,-0.4,-0.71,-0.97,-0.74,-0.6,-0.29,-0.37,-0.85,-0.94,-0.68,-0.42,-0.27,-0.52,-0.96,-0.83,-0.57,-0.27,-0.33,-0.54,-1.06,-0.84,-0.5,-0.31,-0.28,-0.48,-0.98,-0.86,-0.5,-0.18,-0.25,-0.66,-0.94,-0.75,-0.48,-0.11,-0.39:SAWING
0.41,1.2,1.06,0.32,-0.18,0.34,1.29,1.01,0.16,-0.2,0.37,1.41,0.96,-0.01,-0.03,0.83,1.21,0.62,-0.13,0.12,1.2,1.12,0.16,-0.14,0.62,1.32,0.77,-0.03,0.04,0.93,1.27,0.55,-0.11,0.23,1.06,1.24,0.42,-0.13,0.34,1.26,0.98,0.0,0.01,0.7,1.27,0.63,-0.31,0.02,1.12,1.24,0.31,-0.22,0.32,1.4,0.98,-0.05,-0.14,0.59,1.35,0.75,-0.31,-0.02,1.0,1.24,0.44,-0.3,0.12,1.19,1.21,0.28,-0.33,0.24,1.3,1.04,-0.04,-0.22,0.57,1.39,0.71,-0.31,0.03,1.02,1.19,0.35,-0.26,0.24,1.34,1.02,0.11,-0.22,0.32,1.38,1.09,0.11,-0.24,0.36,1.5,1.06,0.01,-0.22,0.45,1.48,0.97,-0.08,-0.16,0.68,1.45,0.76,-0.27,-0.02,1.02,1.29,0.45,-0.29,0.16,1.3,1.19,0.07,-0.13,0.41,1.38,1.05,0.11,-0.19,0.53,1.37,0.83,-0.09,0.05,0.83,1.33,0.55,-0.15,0.21,1.08,1.2,0.26,-0.18,0.46,1.35,0.98,-0.07,-0.01,0.67,1.32,0.85,-0.18,0.04,0.86,1.33,0.48,-0.27,0.24,1.34,1.05,0.02,-0.11,0.53,1.34,0.84,-0.19,-0.01,0.98,1.3,0.46,-0.3,0.18,1.25,1.16,0.25,-0.22,0.28,1.23,1.05,0.24,-0.2,0.29,1.4,1.07,-0.06,-0.23,0.6,1.35,0.72,-0.34,-0.06,1.0,1.29,0.61,-0.38,-0.07,0.91,1.39,0.51,-0.34,0.15,1.21,1.1,0.21,-0.17,0.4,1.26,0.91,-0.03,-0.14,0.62:-0.22,-0.11,-1.08,-1.44,-0.6,-0.14,-0.63,-1.39,-1.18,-0.55,-0.25,-0.64,-1.29,-1.2,-0.36,-0.07,-0.84,-1.41,-0.98,-0.19,-0.27,-1.26,-1.45,-0.59,-0.17,-0.67,-1.34,-1.08,-0.54,-0.18,-0.72,-1.29,-1.01,-0.23,-0.2,-1.23,-1.57,-0.73,-0.11,-0.42,-1.44,-1.33,-0.49,-0.08,-0.72,-1.34,-1.07,-0.53,-0.07,-0.74,-1.39,-0.96,-0.34,-0.29,-1.0,-1.29,-0.8,-0.26,-0.43,-1.35,-1.3,-0.54,-0.13,-0.76,-1.27,-0.99,-0.41,-0.3,-0.96,-1.23,-0.86,-0.42,-0.24,-0.92,-1.34,-0.91,-0.24,-0.2,-1.12,-1.49,-0.8,-0.15,-0.34,-1.26,-1.38,-0.61,-0.19,-0.5,-1.4,-1.26,-0.47,-0.16,-0.78,-1.32,-1.0,-0.33,-0.25,-1.05,-1.44,-0.89,-0.23,-0.27,-1.01,-1.28,-0.9,-0.34,-0.38,-1.14,-1.23,-0.67,-0.21,-0.57,-1.27,-1.13,-0.39,-0.22,-0.9,-1.35,-0.79,-0.29,-0.33,-1.13,-1.36,-0.66,-0.26,-0.47,-1.2,-1.19,-0.52,-0.23,-0.71,-1.26,-0.97,-0.36,-0.22,-1.1,-1.37,-0.69,-0.24,-0.51,-1.36,-1.16,-0.49,-0.17,-0.71,-1.37,-1.02,-0.38,-0.19,-0.91,-1.32,-0.85,-0.31,-0.31,-0.98,-1.26,-0.86,-0.32,-0.21,-1.07,-1.35,-0.75,-0.22,-0.44,-1.17,-1.16,-0.56,-0.06,-0.52,-1.42,-1.17,-0.58,-0.2,-0.52,-1.19,-1.12,-0.53,-0.13,-0.74,-1.26,-0.95,-0.3,-0.22,-1.01,-1.41,-0.81,-0.16,-0.45,-1.36,-1.39,-0.59,-0.13,-0.51,-1.34,-1.4,-0.76,-0.21,-0.31,-1.19,-1.52,-0.71,-0.11,-0.33,-1.34,-1.47,-0.72:-0.03,-0.03,-0.03,-0.04,-0.04,-0.02,-0.02,-0.03,-0.04,-0.04,-0.04,-0.05,-0.05,-0.05,-0.04,-0.03,-0.03,-0.04,-0.04,-0.04,-0.08,-0.23,-0.32,-0.14,0.03,0.22,0.28,0.21,0.2,0.19,0.27,0.36,0.23,0.18,0.06,-0.26,-0.44,-0.6,-0.72,-0.44,-0.27,-0.39,-0.66,-0.93,-0.68,-0.12,0.07,-0.23,-0.95,-1.1,-0.29,0.07,-0.11,-0.89,-1.07,-0.28,0.06,-0.23,-0.97,-0.81,-0.04,0.01,-0.63,-1.0,-0.42,0.07,-0.06,-0.89,-0.94,-0.05,0.05,-0.38,-1.06,-0.57,0.06,-0.06,-0.81,-0.89,-0.09,-0.05,-0.33,-0.93,-0.5,0.06,-0.24,-0.88,-0.74,-0.03,-0.03,-0.51,-0.92,-0.47,-0.05,-0.07,-0.71,-0.73,-0.14,-0.08,-0.44,-0.81,-0.47,0.03,-0.09,-0.76,-0.77,-0.12,0.05,-0.46,-0.9,-0.47,-0.03,-0.12,-0.71,-0.8,-0.16,-0.05,-0.44,-0.91,-0.44,0.01,-0.14,-0.84,-0.8,-0.07,-0.03,-0.41,-0.84,-0.63,-0.09,-0.06,-0.58,-0.87,-0.38,-0.03,-0.18,-0.81,-0.77,0.0,-0.05,-0.63,-0.9,-0.34,0.02,-0.22,-0.82,-0.74,-0.05,-0.06,-0.54,-0.89,-0.33,0.02,-0.25,-0.83,-0.63,0.01,-0.09,-0.55,-0.84,-0.28,0.02,-0.2,-0.79,-0.59,0.04,-0.18,-0.64,-0.79,-0.08,-0.08,-0.33,-0.88,-0.63,0.01,-0.03,-0.32,-0.89,-0.55,0.07,-0.06,-0.85,-0.92,-0.14,0.1,-0.28,-0.96,-0.75,0.06,0.12,-0.64,-0.97,-0.31,0.19,0.0,-0.82,-0.89,-0.11,0.18,-0.42,-0.86,-0.27,0.23,0.01,-0.78,-0.95,-0.03:SAWING
0.14,1.36,1.24,0.09,-1.01,-0.73,0.48,1.52,1.0,-0.28,-1.02,-0.67,0.48,1.6,0.98,-0.45,-0.97,-0.46,0.93,1.41,0.63,-0.7,-1.0,-0.29,1.46,1.3,0.19,-1.02,-0.83,0.54,1.66,0.76,-0.53,-1.02,-0.49,1.13,1.42,0.43,-0.73,-0.94,-0.38,1.12,1.33,0.38,-0.96,-0.92,-0.04,1.34,1.11,0.0,-1.14,-0.87,0.38,1.5,0.92,-0.04,-1.0,-0.89,0.18,1.46,0.92,-0.36,-0.95,-0.68,0.48,1.51,0.76,-0.55,-1.03,-0.59,1.05,1.49,0.66,-0.66,-1.1,-0.7,0.77,1.54,0.74,-0.61,-1.04,-0.57,0.93,1.22,0.63,-0.37,-1.03,-0.76,0.35,1.62,0.85,-0.51,-1.01,-0.58,0.81,1.49,0.53,-0.83,-1.0,-0.38,1.4,1.31,-0.1,-1.19,-0.79,0.7,1.56,0.7,-0.56,-1.12,-0.7,1.0,1.54,0.47,-0.91,-0.83,0.21,1.56,1.07,-0.12,-0.93,-0.87,-0.22,1.52,1.38,-0.1,-1.09,-0.7,0.74,1.42,0.8,-0.46,-1.03,-0.48,0.82,1.38,0.8,-0.27,-0.99,-0.65,0.61,1.7,0.83,-0.61,-0.96,-0.39,1.2,1.52,0.36,-0.88,-0.9,-0.1,1.63,1.28,0.02,-0.98,-0.74,0.46,1.68,0.96,-0.57,-1.05,-0.54,0.96,1.63,0.7,-0.62,-1.15,-0.47,1.29,1.37,0.44,-0.97,-0.97,0.27,1.56,0.98,-0.06,-0.99,-0.58,0.9,1.4,0.51,-0.66,-0.9,-0.21,1.41,1.27,0.24,-1.07,-0.72,0.69,1.44,0.7,-0.53,-0.94,-0.21,1.41,1.07,0.18,-0.87,-0.74,0.28,1.57,0.89,-0.33:0.1,0.32,0.72,0.64,0.33,-0.05,0.07,0.54,0.84,0.7,0.25,-0.01,0.14,1.13,0.66,0.2,0.08,0.22,0.77,0.82,0.53,0.37,0.07,0.11,0.63,0.88,0.57,0.21,0.02,0.3,0.9,0.68,0.33,0.04,0.0,0.53,0.73,0.6,0.42,0.02,0.12,0.44,0.82,0.61,0.34,0.06,0.15,0.63,0.86,0.44,0.31,0.11,0.07,0.83,0.68,0.65,0.33,0.15,0.47,0.76,0.7,0.29,0.2,0.37,0.79,0.68,0.43,0.15,0.11,0.5,0.72,0.55,0.31,0.04,0.3,0.78,0.71,0.45,0.11,0.1,0.41,0.78,0.75,0.38,0.02,0.19,0.76,0.68,0.51,0.36,0.15,0.28,0.93,0.7,0.4,0.19,0.04,0.38,0.99,0.75,0.47,0.15,0.18,0.47,1.25,0.64,0.1,0.08,0.32,0.82,0.88,0.51,0.11,0.07,0.52,0.93,0.66,0.39,0.04,0.17,0.77,0.9,0.62,0.16,0.15,0.61,0.78,0.63,0.45,0.1,0.15,0.79,0.86,0.62,0.32,0.06,0.4,0.9,0.74,0.56,0.22,0.02,0.32,0.85,0.94,0.45,0.07,0.21,0.56,0.83,0.66,0.29,0.31,0.54,0.4,0.82,0.58,0.37,0.06,0.16,0.53,0.79,0.73,0.51,0.0,0.12,0.55,0.91,0.61,0.4,0.03,0.25,0.65,0.84,0.57,0.25,0.03,0.23,0.93,0.75,0.59,0.2,0.0,0.32,0.63,0.6,0.63,0.21,0.28,0.66,0.74,0.66,0.34,0.05,0.22,0.62,0.8,0.5,0.27,0.07,0.41,1.0,0.65,0.52,0.17,0.09:-0.48,-0.63,-0.68,-1.08,-1.15,-0.77,-0.69,-0.5,-0.7,-0.99,-0.87,-0.81,-0.62,-0.49,-0.83,-1.15,-1.11,-0.64,-0.24,-0.6,-1.17,-1.1,-0.97,-0.47,-0.46,-0.89,-1.17,-0.89,-0.67,-0.39,-0.77,-1.23,-1.05,-0.8,-0.48,-0.48,-0.84,-1.18,-0.93,-0.75,-0.43,-0.67,-1.09,-1.01,-0.7,-0.67,-0.5,-0.65,-1.11,-1.12,-0.85,-0.38,-0.28,-0.83,-1.41,-1.12,-0.63,-0.12,-0.4,-1.27,-1.25,-0.87,-0.61,-0.16,-0.62,-1.32,-1.15,-0.7,-0.33,-0.4,-0.96,-1.28,-0.92,-0.86,-0.27,-0.46,-1.1,-1.12,-0.93,-0.44,-0.3,-0.83,-1.24,-0.99,-0.87,-0.21,-0.45,-1.24,-1.1,-0.82,-0.56,-0.31,-0.7,-1.2,-1.03,-0.75,-0.74,-0.29,-0.73,-1.36,-1.06,-0.66,-0.41,-0.35,-0.97,-1.3,-0.86,-0.72,-0.53,-0.47,-0.82,-1.24,-1.02,-0.76,-0.4,-0.43,-0.97,-1.27,-0.93,-0.7,-0.5,-0.36,-0.95,-1.28,-0.94,-0.67,-0.38,-0.47,-1.17,-1.29,-0.82,-0.55,-0.35,-0.59,-1.27,-1.17,-0.9,-0.55,-0.52,-0.73,-1.08,-0.95,-0.67,-0.36,-0.52,-1.0,-1.12,-0.87,-0.84,-0.49,-0.59,-0.96,-1.02,-0.84,-0.69,-0.47,-0.75,-1.11,-0.93,-0.8,-0.76,-0.43,-0.72,-1.12,-1.07,-0.92,-0.65,-0.4,-0.77,-1.13,-0.99,-0.82,-0.52,-0.43,-1.03,-1.26,-0.88,-0.67,-0.38,-0.55,-1.04,-1.12,-0.87,-1.08,-0.49,-0.57,-1.09,-1.02,-0.74,-0.98,-0.35,-0.35,-0.94,-1.32,-1.03,-0.82,-0.52,-0.48,-1.04,-1.27,-0.92,-0.61,-0.38,-0.59,-1.24,-1.15:SAWING
-1.36,-0.96,-0.26,0.12,0.01,-0.74,-1.52,-1.26,-0.94,-0.23,0.13,0.01,-0.81,-1.63,-1.24,-0.79,-0.03,0.07,-0.3,-1.2,-1.28,-1.08,-0.54,0.02,-0.01,-0.6,-1.55,-1.26,-0.85,-0.17,0.08,-0.19,-1.12,-1.46,-1.14,-0.67,-0.08,0.07,-0.14,-1.17,-1.52,-1.18,-0.62,-0.01,0.1,-0.26,-1.22,-1.46,-1.19,-0.68,-0.04,0.1,-0.25,-1.19,-1.46,-1.19,-0.72,-0.07,0.08,-0.15,-1.04,-1.51,-1.22,-0.79,-0.14,0.12,-0.06,-1.04,-1.5,-1.19,-0.82,-0.16,0.08,-0.08,-1.0,-1.5,-1.18,-0.84,-0.14,0.09,-0.27,-1.14,-1.42,-1.11,-0.73,-0.13,-0.1,-0.3,-1.01,-1.53,-1.16,-0.76,-0.11,0.04,-0.4,-1.39,-1.29,-1.09,-0.56,-0.03,-0.09,-0.41,-1.4,-1.39,-1.07,-0.45,0.02,0.02,-0.72,-1.59,-1.28,-0.9,-0.24,0.06,-0.12,-1.06,-1.46,-1.18,-0.79,-0.14,0.07,-0.29,-1.08,-1.4,-1.16,-0.68,-0.09,0.04,-0.45,-1.39,-1.27,-1.01,-0.43,-0.01,-0.07,-0.62,-1.45,-1.25,-1.0,-0.43,0.04,-0.1,-0.56,-1.48,-1.26,-0.98,-0.43,0.05,-0.08,-0.67,-1.49,-1.24,-0.87,-0.27,0.05,-0.14,-0.89,-1.46,-1.22,-0.83,-0.32,0.06,0.01,-0.82,-1.59,-1.23,-0.88,-0.24,0.06,-0.08,-0.85,-1.46,-1.22,-0.76,-0.15,0.04,-0.19,-1.26,-1.4,-1.12,-0.5,0.05,0.06,-0.53,-1.42,-1.38,-1.12,-0.51,0.08,0.05,-0.51,-1.48,-1.26,-1.0,-0.41,0.0,-0.07,-0.56,-1.48,-1.29,-0.97,-0.27,0.04,-0.11,-0.82,-1.44:-0.32,-0.25,-0.24,-0.47,-0.63,-0.61,-0.47,-0.39,-0.17,-0.28,-0.49,-0.55,-0.61,-0.43,-0.32,-0.18,-0.34,-0.46,-0.53,-0.53,-0.41,-0.36,-0.16,-0.38,-0.51,-0.47,-0.53,-0.4,-0.39,-0.18,-0.31,-0.47,-0.59,-0.42,-0.38,-0.29,-0.09,-0.41,-0.6,-0.49,-0.44,-0.29,-0.35,-0.13,-0.32,-0.6,-0.54,-0.4,-0.31,-0.11,-0.27,-0.48,-0.53,-0.47,-0.33,-0.35,-0.13,-0.32,-0.45,-0.48,-0.38,-0.42,-0.21,-0.22,-0.37,-0.56,-0.51,-0.4,-0.34,-0.26,-0.18,-0.41,-0.54,-0.47,-0.43,-0.35,-0.22,-0.15,-0.4,-0.56,-0.62,-0.48,-0.32,-0.15,-0.17,-0.47,-0.58,-0.49,-0.32,-0.33,-0.2,-0.2,-0.46,-0.54,-0.45,-0.32,-0.37,-0.21,-0.18,-0.42,-0.51,-0.51,-0.36,-0.29,-0.25,-0.2,-0.42,-0.45,-0.43,-0.41,-0.35,-0.17,-0.14,-0.35,-0.49,-0.53,-0.41,-0.26,-0.11,-0.08,-0.41,-0.54,-0.43,-0.39,-0.34,-0.07,-0.25,-0.42,-0.48,-0.49,-0.29,-0.34,-0.04,-0.25,-0.52,-0.55,-0.36,-0.32,-0.26,-0.14,-0.34,-0.55,-0.44,-0.39,-0.32,-0.23,-0.15,-0.41,-0.45,-0.49,-0.44,-0.34,-0.15,-0.19,-0.47,-0.54,-0.43,-0.42,-0.34,-0.16,-0.28,-0.49,-0.49,-0.44,-0.36,-0.33,-0.15,-0.31,-0.53,-0.45,-0.56,-0.37,-0.42,-0.13,-0.29,-0.48,-0.5,-0.59,-0.33,-0.27,-0.19,-0.32,-0.52,-0.6,-0.48,-0.35,-0.19,-0.23,-0.32,-0.41,-0.51,-0.44,-0.42,-0.2,-0.15,-0.34,-0.49,-0.54,-0.39,-0.34,-0.21,-0.26,-0.4,-0.52,-0.54,-0.41:0.03,0.03,0.03,0.03,0.03,0.03,0.03,-0.06,-0.15,-0.3,-0.42,-0.29,-0.21,-0.14,-0.41,-0.76,-0.9,-0.86,-0.82,-0.68,-0.91,-0.95,-0.8,-0.52,-0.43,-0.55,-0.83,-1.13,-1.13,-0.74,-0.46,-0.01,-0.32,-0.78,-1.33,-1.26,-0.69,-0.22,0.01,-0.6,-1.2,-1.22,-0.83,-0.52,-0.38,-0.34,-0.82,-1.16,-1.04,-0.75,-0.28,-0.12,-0.59,-1.27,-1.27,-0.82,-0.27,-0.02,-0.52,-0.95,-1.37,-1.0,-0.6,-0.05,-0.19,-0.75,-1.34,-1.17,-0.77,-0.27,0.01,-0.62,-1.19,-1.17,-0.9,-0.48,0.07,-0.5,-0.94,-1.25,-1.01,-0.68,-0.33,-0.08,-0.66,-1.27,-1.19,-0.83,-0.43,0.01,-0.39,-0.92,-1.27,-1.0,-0.61,-0.28,-0.08,-0.58,-1.36,-1.26,-0.79,-0.45,0.05,-0.26,-0.95,-1.33,-1.08,-0.69,-0.32,0.03,-0.58,-1.0,-1.23,-0.86,-0.6,-0.27,-0.19,-0.62,-1.04,-1.16,-0.8,-0.48,-0.03,-0.28,-0.72,-1.25,-1.07,-0.72,-0.52,0.01,-0.31,-0.81,-1.33,-1.16,-0.71,-0.43,-0.03,-0.41,-0.73,-1.24,-1.05,-0.75,-0.33,0.04,-0.47,-0.83,-1.4,-1.14,-0.71,-0.17,0.02,-0.58,-1.01,-1.26,-0.89,-0.68,-0.33,-0.04,-0.58,-1.12,-1.18,-0.85,-0.61,-0.12,-0.36,-0.72,-1.13,-1.13,-0.78,-0.31,-0.03,-0.58,-1.0,-1.23,-0.92,-0.53,-0.37,-0.15,-0.64,-1.22,-1.26,-0.81,-0.56,-0.07,-0.21,-0.69,-1.2,-1.11,-0.8,-0.74,-0.18,-0.16,-0.56,-1.17,-1.3,-0.88,-0.55,-0.04,-0.21,-0.64,-1.17,-1.25,-0.85,-0.61,-0.11,-0.16:SAWING
1.34,0.63,-0.21,-0.76,-0.5,0.37,1.85,1.44,0.8,0.14,-0.68,-0.7,-0.08,1.34,1.78,1.17,0.48,-0.28,-0.79,-0.51,0.36,1.87,1.53,0.79,-0.03,-0.65,-0.53,0.02,1.47,1.63,1.01,0.35,-0.36,-0.58,-0.36,0.48,1.78,1.42,0.7,-0.11,-0.55,-0.43,0.25,1.52,1.45,0.81,0.14,-0.59,-0.53,0.04,1.58,1.53,0.81,0.14,-0.63,-0.64,-0.11,1.2,1.7,1.16,0.51,-0.26,-0.65,-0.43,0.53,1.87,1.44,0.72,-0.09,-0.72,-0.66,0.15,1.91,1.61,1.0,0.39,-0.39,-0.81,-0.35,0.61,1.97,1.44,0.69,0.02,-0.75,-0.64,0.07,1.78,1.64,0.91,0.01,-0.76,-0.56,0.06,1.59,1.61,0.95,0.33,-0.46,-0.73,-0.35,0.67,1.95,1.43,0.7,-0.05,-0.73,-0.57,0.17,1.79,1.64,0.87,-0.02,-0.82,-0.46,0.36,1.45,1.41,0.97,0.42,-0.5,-0.74,-0.32,0.67,1.89,1.39,0.72,0.09,-0.75,-0.58,0.09,1.63,1.61,0.97,0.31,-0.59,-0.63,-0.07,1.32,1.8,1.07,0.44,-0.32,-0.62,-0.38,0.53,1.88,1.45,0.74,-0.07,-0.59,-0.45,0.16,1.66,1.61,0.98,0.37,-0.54,-0.61,-0.17,1.06,1.82,1.24,0.54,-0.41,-0.66,-0.34,0.63,1.8,1.36,0.8,0.14,-0.79,-0.61,0.12,1.7,1.57,0.92,0.15,-0.63,-0.53,0.09,1.4,1.52,1.07,0.41,-0.58,-0.7,-0.24,1.1,1.76,1.2,0.56,-0.12,-0.75,-0.58,0.22,1.81,1.61,0.9,0.3,-0.64,-0.63,-0.16,1.03,1.83:0.51,0.51,0.49,0.35,0.53,0.48,0.59,0.57,0.61,0.48,0.59,0.63,0.47,0.61,0.49,0.7,0.63,0.51,0.58,0.47,0.58,0.51,0.55,0.74,0.64,0.5,0.37,0.58,0.58,0.58,0.77,0.63,0.52,0.4,0.54,0.61,0.77,0.74,0.53,0.68,0.5,0.53,0.64,0.6,0.53,0.58,0.73,0.54,0.47,0.55,0.55,0.44,0.44,0.73,0.55,0.51,0.53,0.54,0.48,0.62,0.68,0.5,0.56,0.61,0.63,0.55,0.69,0.53,0.38,0.61,0.71,0.69,0.58,0.7,0.55,0.41,0.62,0.65,0.65,0.63,0.49,0.78,0.53,0.48,0.61,0.71,0.7,0.55,0.65,0.64,0.54,0.6,0.68,0.71,0.58,0.53,0.7,0.58,0.58,0.71,0.74,0.6,0.5,0.75,0.6,0.6,0.6,0.73,0.66,0.6,0.75,0.53,0.52,0.67,0.8,0.64,0.49,0.72,0.56,0.54,0.62,0.66,0.6,0.57,0.97,0.55,0.49,0.64,0.72,0.67,0.51,0.52,0.79,0.6,0.56,0.64,0.82,0.63,0.53,0.78,0.49,0.56,0.7,0.81,0.65,0.54,0.67,0.63,0.52,0.63,0.71,0.74,0.52,0.42,0.83,0.65,0.6,0.73,0.81,0.68,0.61,0.75,0.62,0.49,0.62,0.74,0.82,0.63,0.55,0.73,0.6,0.57,0.69,0.72,0.53,0.54,0.73,0.63,0.57,0.65,0.8,0.65,0.55,0.8,0.67,0.55,0.62,0.81,0.6,0.51,0.73,0.66,0.56,0.6,0.7,0.65,0.5,0.53,0.75,0.63,0.6,0.68,0.65,0.47,0.59,0.91:-0.77,-0.06,-0.22,-0.58,-0.77,-0.91,-1.02,-0.86,-0.15,-0.13,-0.46,-0.71,-1.1,-0.98,-0.58,-0.41,-0.17,-0.48,-0.75,-0.94,-0.82,-0.63,-0.4,-0.31,-0.49,-0.8,-0.97,-0.78,-0.57,-0.41,-0.34,-0.6,-0.93,-0.96,-0.7,-0.6,-0.26,-0.25,-0.64,-0.92,-0.93,-0.7,-0.62,-0.18,-0.26,-0.7,-0.97,-0.92,-0.65,-0.77,-0.13,-0.21,-0.65,-0.9,-0.93,-0.8,-0.6,-0.35,-0.15,-0.47,-0.77,-0.99,-0.89,-0.66,-0.38,-0.15,-0.35,-0.71,-0.99,-0.94,-0.63,-0.45,-0.29,-0.3,-0.56,-0.9,-0.92,-0.68,-0.52,-0.25,-0.18,-0.52,-0.91,-0.97,-0.7,-0.5,-0.25,-0.15,-0.47,-0.87,-0.98,-0.63,-0.41,-0.32,-0.25,-0.43,-0.8,-1.05,-0.85,-0.68,-0.5,-0.07,-0.33,-0.72,-1.04,-0.88,-0.57,-0.5,-0.28,-0.2,-0.55,-0.89,-1.01,-0.68,-0.52,-0.37,-0.18,-0.44,-0.77,-1.07,-0.88,-0.67,-0.46,-0.24,-0.32,-0.67,-0.96,-0.95,-0.59,-0.45,-0.3,-0.21,-0.51,-0.79,-0.93,-0.75,-0.65,-0.39,-0.12,-0.38,-0.7,-0.87,-0.89,-0.62,-0.52,-0.29,-0.23,-0.54,-0.85,-0.94,-0.66,-0.57,-0.41,-0.33,-0.51,-0.72,-0.94,-0.7,-0.52,-0.49,-0.3,-0.47,-0.72,-0.98,-0.72,-0.57,-0.53,-0.23,-0.3,-0.67,-0.98,-1.02,-0.68,-0.53,-0.25,-0.2,-0.52,-0.92,-1.03,-0.65,-0.52,-0.28,-0.05,-0.42,-0.84,-1.01,-0.93,-0.66,-0.42,-0.21,-0.21,-0.55,-0.89,-0.97,-0.68,-0.5,-0.38,-0.21,-0.43,-0.8,-1.0,-0.72,-0.53,-0.47,-0.21,-0.39:SAWING
1.52,1.01,0.36,-0.51,-0.25,0.34,1.24,1.46,1.06,0.53,-0.43,-0.3,0.18,1.19,1.51,1.08,0.58,-0.33,-0.37,0.11,1.1,1.57,1.13,0.62,-0.34,-0.36,0.04,1.01,1.61,1.22,0.8,-0.16,-0.59,-0.11,0.94,1.64,1.22,0.79,-0.26,-0.6,-0.05,1.08,1.66,1.23,0.76,-0.22,-0.61,-0.12,0.98,1.55,1.18,0.85,0.11,-0.62,-0.23,0.47,1.42,1.29,0.97,0.47,-0.45,-0.39,0.03,1.05,1.61,1.18,0.68,-0.37,-0.45,-0.03,0.94,1.62,1.2,0.7,-0.36,-0.5,0.04,1.06,1.59,1.19,0.81,-0.02,-0.62,-0.18,0.67,1.73,1.42,0.99,-0.01,-0.6,-0.16,0.53,1.66,1.36,0.94,0.31,-0.5,-0.17,0.44,1.36,1.38,1.04,0.62,-0.4,-0.37,0.0,0.98,1.58,1.19,0.91,0.29,-0.56,-0.28,0.42,1.38,1.38,1.08,0.73,-0.31,-0.34,0.08,1.0,1.6,1.2,0.84,0.06,-0.41,-0.11,0.52,1.4,1.26,0.97,0.41,-0.54,-0.17,0.3,1.24,1.35,1.06,0.6,-0.38,-0.28,0.08,0.93,1.5,1.2,0.68,-0.16,-0.29,0.03,0.65,1.55,1.26,0.91,0.22,-0.47,-0.06,0.45,1.39,1.39,1.05,0.57,-0.5,-0.29,0.14,1.39,1.53,1.14,0.51,-0.44,-0.34,0.11,1.1,1.39,1.16,0.86,0.12,-0.38,-0.09,0.53,1.41,1.25,0.95,0.27,-0.53,-0.16,0.41,1.38,1.38,1.06,0.56,-0.36,-0.24,0.19,1.07,1.45,1.13,0.83,0.24,-0.4,-0.15,0.55,1.28,1.29,1.08,0.76:-0.82,-1.0,-0.93,-0.9,-0.94,-0.96,-0.65,-0.4,-0.4,-0.7,-1.1,-1.09,-0.6,-0.48,-0.26,-0.36,-1.13,-1.52,-1.07,-0.55,-0.22,-0.16,-0.7,-1.46,-1.54,-0.98,-0.56,-0.17,-0.23,-0.79,-1.34,-1.45,-1.09,-0.75,-0.2,-0.08,-0.65,-1.46,-1.57,-1.22,-0.85,-0.24,0.09,-0.61,-1.29,-1.52,-1.46,-0.97,-0.39,0.07,-0.32,-1.0,-1.57,-1.66,-1.05,-0.6,-0.04,-0.18,-0.85,-1.44,-1.7,-1.19,-0.74,-0.09,-0.09,-0.84,-1.59,-1.64,-0.98,-0.56,-0.04,-0.24,-0.89,-1.59,-1.55,-0.96,-0.52,-0.11,-0.28,-0.95,-1.5,-1.34,-1.01,-0.51,-0.08,-0.32,-1.0,-1.51,-1.33,-0.9,-0.64,-0.31,-0.26,-0.77,-1.34,-1.34,-0.99,-0.56,-0.2,-0.33,-0.9,-1.41,-1.38,-0.99,-0.57,-0.2,-0.24,-0.79,-1.37,-1.66,-1.17,-0.54,-0.2,-0.13,-0.79,-1.59,-1.83,-0.88,-0.48,-0.23,-0.28,-0.93,-1.5,-1.51,-0.88,-0.56,-0.16,-0.29,-0.98,-1.49,-1.35,-0.9,-0.6,-0.3,-0.24,-0.89,-1.39,-1.49,-0.96,-0.58,-0.27,-0.23,-0.8,-1.32,-1.47,-1.14,-0.63,-0.2,-0.14,-0.78,-1.36,-1.48,-1.13,-0.72,-0.27,-0.04,-0.67,-1.25,-1.53,-1.29,-0.69,-0.2,-0.13,-0.67,-1.23,-1.53,-1.32,-0.78,-0.18,-0.07,-0.62,-1.33,-1.55,-1.23,-0.76,-0.29,-0.11,-0.62,-1.12,-1.44,-1.36,-0.81,-0.55,-0.12,-0.38,-0.91,-1.48,-1.61,-1.08,-0.57,-0.21,-0.18,-0.83,-1.41,-1.66,-1.18,-0.63,-0.21,-0.1,-0.81,-1.34,-1.66,-1.3,-0.6,-0.13,-0.08:-0.05,-0.05,-0.06,-0.06,-0.05,-0.06,-0.06,-0.06,-0.05,-0.05,-0.05,-0.05,-0.04,-0.05,-0.06,-0.06,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.05,-0.06,-0.11,-0.29,-0.41,-0.21,-0.05,0.12,0.16,0.1,0.11,0.06,0.06,0.06,0.2,0.29,0.12,-0.28,-0.3,-0.21,-0.31,-0.35,-0.32,-0.34,-0.19,-0.14,-0.23,-0.6,-1.02,-0.79,-0.45,-0.18,-0.05,-0.23,-0.71,-0.93,-0.48,-0.25,0.01,0.05,-0.26,-0.7,-0.85,-0.55,-0.17,0.05,0.02,-0.28,-0.74,-0.92,-0.48,-0.23,0.04,0.16,-0.18,-0.54,-0.82,-0.63,-0.27,0.06,0.14,-0.08,-0.45,-0.8,-0.6,-0.32,-0.08,0.1,0.04,-0.29,-0.72,-0.68,-0.37,-0.11,0.05,0.11,-0.23,-0.65,-0.74,-0.5,-0.17,0.07,0.11,-0.25,-0.7,-0.86,-0.4,-0.08,0.08,0.1,-0.28,-0.69,-0.78,-0.45,-0.15,0.06,0.03,-0.25,-0.55,-0.68,-0.54,-0.22,0.0,0.0,-0.31,-0.67,-0.69,-0.44,-0.25,-0.11,-0.07,-0.26,-0.59,-0.68,-0.52,-0.27,-0.1,-0.08,-0.29,-0.63,-0.67,-0.38,-0.21,-0.07,-0.01,-0.21,-0.59,-0.72,-0.34,-0.15,-0.02,-0.1,-0.37,-0.56,-0.65,-0.31,-0.05,-0.05,-0.14,-0.45,-0.64,-0.66,-0.37,-0.15,-0.05,-0.03,-0.29,-0.53,-0.63,-0.46,-0.31,0.01,0.0,-0.21,-0.66,-0.72,-0.45,-0.15,-0.05,0.02,-0.26,-0.68,-0.8,-0.52,-0.21,0.07,-0.02,-0.24,-0.65,-0.82,-0.48,-0.27,0.0,0.05,-0.17,-0.57,-0.89:SAWING
-0.5,0.17,1.78,1.61,0.95,0.2,-0.8,-0.66,0.0,1.61,1.78,1.12,0.41,-0.45,-0.76,-0.41,0.68,2.11,1.44,0.61,0.05,-0.83,-0.62,0.07,1.9,1.89,1.05,0.23,-0.91,-0.72,-0.02,1.61,1.95,1.2,0.38,-0.74,-0.85,-0.33,0.98,2.19,1.43,0.58,-0.42,-0.9,-0.44,0.63,2.05,1.58,0.76,-0.09,-0.86,-0.6,0.02,1.78,1.9,1.1,0.36,-0.7,-0.91,-0.4,0.87,2.1,1.46,0.61,-0.23,-0.93,-0.63,0.21,1.75,1.85,1.14,0.43,-0.47,-0.92,-0.53,0.51,2.17,1.61,0.73,-0.21,-0.92,-0.65,0.19,1.72,1.81,1.05,0.39,-0.43,-0.93,-0.47,0.63,2.06,1.54,0.79,0.1,-0.85,-0.77,-0.12,1.34,1.95,1.29,0.59,-0.14,-0.87,-0.71,0.06,1.88,1.83,1.05,0.35,-0.67,-0.82,-0.43,0.75,2.05,1.46,0.69,-0.02,-0.78,-0.68,-0.13,1.57,1.95,1.19,0.44,-0.51,-0.77,-0.48,0.29,2.14,1.7,0.87,0.23,-0.8,-0.76,-0.25,1.0,1.92,1.31,0.63,-0.14,-0.7,-0.51,0.17,1.64,1.65,1.02,0.34,-0.7,-0.82,-0.36,0.74,2.02,1.44,0.75,0.04,-0.7,-0.54,-0.14,1.27,1.91,1.22,0.42,-0.56,-0.71,-0.39,0.58,1.94,1.4,0.78,-0.08,-0.76,-0.53,0.17,1.7,1.62,1.02,0.41,-0.53,-0.64,-0.36,0.69,1.88,1.29,0.64,-0.19,-0.59,-0.42,0.28,1.63,1.44,0.94,0.22,-0.57,-0.59,-0.07,1.38,1.58,1.1,0.56,-0.3,-0.65,-0.36,0.48,1.83,1.41:0.45,0.47,0.74,0.42,0.43,0.45,0.47,0.42,0.45,0.9,0.55,0.44,0.55,0.62,0.5,0.48,0.87,0.49,0.39,0.56,0.64,0.51,0.46,0.77,0.63,0.53,0.56,0.63,0.63,0.49,0.58,0.88,0.52,0.32,0.56,0.62,0.58,0.54,0.89,0.6,0.43,0.58,0.68,0.56,0.66,0.78,0.58,0.48,0.59,0.68,0.63,0.45,0.6,0.8,0.55,0.6,0.67,0.67,0.48,0.5,0.82,0.59,0.49,0.59,0.67,0.58,0.52,0.8,0.6,0.47,0.58,0.75,0.66,0.53,0.58,0.65,0.58,0.63,0.67,0.65,0.55,0.58,0.73,0.57,0.54,0.63,0.65,0.65,0.42,0.37,0.8,0.56,0.46,0.63,0.68,0.53,0.44,0.73,0.6,0.51,0.61,0.59,0.63,0.5,0.49,0.8,0.56,0.45,0.63,0.75,0.64,0.64,0.62,0.63,0.53,0.6,0.72,0.74,0.56,0.47,0.68,0.6,0.56,0.63,0.7,0.77,0.65,0.52,0.69,0.55,0.53,0.66,0.79,0.68,0.55,0.68,0.6,0.55,0.61,0.68,0.69,0.42,0.41,1.01,0.59,0.47,0.61,0.75,0.66,0.53,0.62,0.74,0.52,0.55,0.63,0.63,0.49,0.47,0.83,0.64,0.5,0.58,0.64,0.58,0.48,0.51,0.8,0.57,0.5,0.65,0.73,0.66,0.55,0.72,0.66,0.49,0.53,0.75,0.7,0.43,0.49,0.83,0.51,0.47,0.7,0.69,0.46,0.57,0.81,0.5,0.45,0.59,0.7,0.63,0.42,0.53,0.79,0.51,0.47,0.68,0.63,0.5,0.54,0.75,0.49,0.44:-0.63,-0.45,-0.15,-0.39,-0.8,-1.04,-0.89,-0.65,-0.6,-0.29,-0.11,-0.52,-0.89,-1.11,-0.84,-0.55,-0.35,-0.33,-0.4,-0.67,-1.04,-1.0,-0.65,-0.55,-0.27,-0.14,-0.55,-0.92,-1.11,-0.77,-0.69,-0.38,-0.12,-0.38,-0.76,-1.03,-0.95,-0.6,-0.58,-0.36,-0.25,-0.63,-0.92,-0.94,-0.71,-0.67,-0.45,-0.15,-0.43,-0.76,-1.21,-0.89,-0.52,-0.44,-0.3,-0.34,-0.67,-0.99,-1.02,-0.7,-0.59,-0.4,-0.14,-0.47,-0.85,-1.09,-0.77,-0.6,-0.53,-0.28,-0.38,-0.67,-0.99,-0.92,-0.67,-0.54,-0.33,-0.28,-0.56,-1.05,-1.09,-0.68,-0.45,-0.35,-0.26,-0.57,-0.8,-0.97,-0.87,-0.65,-0.6,-0.25,-0.28,-0.61,-0.87,-0.98,-0.69,-0.56,-0.47,-0.19,-0.44,-0.75,-1.05,-0.86,-0.7,-0.53,-0.16,-0.33,-0.66,-1.02,-0.96,-0.67,-0.64,-0.3,-0.18,-0.51,-0.87,-1.03,-0.74,-0.56,-0.33,-0.2,-0.48,-0.76,-1.1,-0.83,-0.6,-0.5,-0.25,-0.43,-0.74,-0.9,-0.87,-0.65,-0.55,-0.28,-0.3,-0.61,-0.8,-0.87,-0.77,-0.54,-0.42,-0.18,-0.38,-0.7,-1.03,-0.97,-0.72,-0.47,-0.24,-0.28,-0.6,-0.87,-1.05,-0.76,-0.41,-0.2,-0.2,-0.48,-0.77,-1.0,-0.99,-0.75,-0.37,-0.11,-0.28,-0.6,-0.89,-1.03,-0.69,-0.44,-0.19,-0.24,-0.47,-0.77,-1.04,-0.82,-0.55,-0.45,-0.21,-0.2,-0.59,-0.89,-1.04,-0.79,-0.56,-0.3,-0.15,-0.33,-0.67,-1.02,-1.07,-0.65,-0.45,-0.3,-0.27,-0.47,-0.71,-1.06,-0.84,-0.59,-0.62,-0.18,-0.2,-0.72:SAWING
-0.87,-1.55,-1.27,-0.72,0.02,0.2,-0.39,-1.52,-1.33,-0.98,-0.27,0.02,-0.09,-0.8,-1.47,-1.28,-0.81,-0.09,0.1,-0.16,-1.06,-1.44,-1.2,-0.7,-0.06,0.06,-0.3,-1.27,-1.42,-1.12,-0.47,0.01,0.0,-0.49,-1.45,-1.37,-1.0,-0.32,0.09,-0.09,-0.8,-1.46,-1.29,-0.76,-0.07,0.13,-0.15,-1.25,-1.47,-1.16,-0.45,0.08,0.0,-0.67,-1.46,-1.29,-0.85,-0.17,0.08,-0.18,-1.06,-1.41,-1.18,-0.62,-0.04,-0.01,-0.41,-1.33,-1.36,-1.07,-0.42,0.02,0.0,-0.61,-1.51,-1.32,-0.95,-0.24,0.07,-0.07,-0.98,-1.39,-1.19,-0.67,-0.04,0.01,-0.42,-1.18,-1.4,-1.08,-0.51,-0.04,-0.02,-0.5,-1.29,-1.32,-1.01,-0.44,0.01,-0.02,-0.7,-1.39,-1.26,-0.85,-0.2,0.04,-0.23,-1.0,-1.4,-1.13,-0.54,-0.01,-0.01,-0.55,-1.29,-1.28,-0.93,-0.31,0.02,-0.11,-0.76,-1.39,-1.22,-0.73,-0.09,0.06,-0.25,-1.21,-1.46,-1.19,-0.5,0.08,0.07,-0.51,-1.53,-1.32,-0.96,-0.25,0.07,-0.07,-0.9,-1.55,-1.23,-0.72,-0.03,0.1,-0.33,-1.3,-1.49,-1.09,-0.49,0.03,0.01,-0.69,-1.57,-1.29,-0.85,-0.19,0.03,-0.18,-1.09,-1.53,-1.14,-0.63,0.0,0.03,-0.31,-1.42,-1.47,-1.05,-0.4,0.13,0.04,-0.69,-1.61,-1.28,-0.92,-0.13,0.07,-0.16,-1.09,-1.46,-1.19,-0.56,0.08,0.11,-0.59,-1.6,-1.29,-0.92,-0.22,0.09,-0.1,-0.98,-1.62,-1.2,-0.62,0.05,0.09,-0.52,-1.48,-1.37,-1.02,-0.47,0.03,0.1:-0.07,-0.29,-0.54,-0.48,-0.38,-0.37,-0.16,-0.19,-0.34,-0.52,-0.45,-0.49,-0.42,-0.08,-0.23,-0.34,-0.49,-0.43,-0.38,-0.37,-0.12,-0.27,-0.48,-0.59,-0.52,-0.39,-0.19,-0.15,-0.35,-0.56,-0.42,-0.35,-0.43,-0.18,-0.2,-0.39,-0.54,-0.47,-0.38,-0.37,-0.15,-0.22,-0.5,-0.53,-0.46,-0.34,-0.23,-0.2,-0.35,-0.51,-0.36,-0.4,-0.39,-0.22,-0.24,-0.43,-0.45,-0.41,-0.4,-0.34,-0.21,-0.26,-0.5,-0.47,-0.44,-0.46,-0.31,-0.2,-0.27,-0.48,-0.4,-0.34,-0.4,-0.17,-0.25,-0.45,-0.47,-0.41,-0.45,-0.24,-0.26,-0.27,-0.5,-0.44,-0.38,-0.34,-0.37,-0.27,-0.27,-0.44,-0.44,-0.43,-0.44,-0.17,-0.19,-0.35,-0.5,-0.43,-0.37,-0.29,-0.23,-0.23,-0.44,-0.53,-0.42,-0.41,-0.24,-0.23,-0.29,-0.49,-0.44,-0.41,-0.31,-0.21,-0.2,-0.39,-0.52,-0.48,-0.39,-0.34,-0.22,-0.23,-0.47,-0.52,-0.42,-0.32,-0.32,-0.19,-0.32,-0.55,-0.48,-0.42,-0.32,-0.22,-0.18,-0.39,-0.52,-0.43,-0.47,-0.33,-0.15,-0.19,-0.48,-0.58,-0.39,-0.34,-0.21,-0.21,-0.37,-0.55,-0.44,-0.35,-0.2,-0.17,-0.23,-0.5,-0.55,-0.46,-0.3,-0.23,-0.21,-0.16,-0.43,-0.42,-0.37,-0.25,-0.3,-0.19,-0.32,-0.45,-0.39,-0.32,-0.38,-0.11,-0.25,-0.43,-0.49,-0.42,-0.34,-0.29,-0.14,-0.29,-0.54,-0.58,-0.42,-0.26,-0.11,-0.15,-0.47,-0.62,-0.48,-0.4,-0.26,-0.14,-0.27,-0.5,-0.49,-0.28,-0.39,-0.34,-0.13,-0.32,-0.54,-0.47,-0.35,-0.31:-1.21,-1.26,-0.88,-0.46,0.07,-0.39,-0.74,-1.23,-1.09,-0.85,-0.34,-0.07,-0.43,-0.79,-1.24,-1.02,-0.75,-0.3,-0.1,-0.62,-1.0,-1.1,-0.96,-0.41,0.03,-0.42,-0.96,-1.35,-0.95,-0.8,-0.07,-0.01,-0.72,-1.13,-1.07,-0.75,-0.68,-0.02,-0.36,-0.68,-1.13,-1.11,-0.79,-0.43,-0.04,-0.4,-0.91,-1.33,-1.04,-0.76,0.05,-0.17,-0.69,-1.09,-1.23,-0.94,-0.55,0.09,-0.44,-0.85,-1.28,-0.99,-0.65,-0.25,-0.16,-0.67,-1.13,-1.18,-0.9,-0.47,0.11,-0.56,-0.88,-1.26,-1.04,-0.68,-0.16,-0.14,-0.59,-1.06,-1.34,-0.87,-0.53,-0.1,-0.22,-0.67,-1.2,-1.26,-0.79,-0.42,-0.01,-0.37,-0.75,-1.19,-1.12,-0.77,-0.39,0.07,-0.51,-0.88,-1.23,-1.16,-0.68,-0.07,-0.12,-0.6,-1.19,-1.22,-0.73,-0.63,0.09,-0.41,-0.77,-1.21,-1.07,-0.73,-0.19,-0.06,-0.6,-1.08,-1.26,-0.83,-0.61,0.02,-0.29,-0.66,-1.19,-1.18,-0.81,-0.46,0.01,-0.43,-0.78,-1.32,-1.07,-0.7,-0.27,0.05,-0.56,-1.0,-1.26,-0.91,-0.63,-0.04,-0.25,-0.65,-1.17,-1.14,-0.84,-0.47,0.01,-0.38,-0.79,-1.22,-1.0,-0.68,-0.53,-0.02,-0.45,-0.84,-1.25,-0.96,-0.69,-0.34,-0.12,-0.57,-1.0,-1.22,-0.96,-0.56,-0.06,-0.33,-0.72,-1.21,-1.07,-0.77,-0.38,-0.09,-0.55,-0.91,-1.19,-1.0,-0.72,-0.17,-0.21,-0.63,-1.0,-1.27,-0.86,-0.57,0.07,-0.35,-0.74,-1.32,-1.13,-0.81,-0.38,0.08,-0.51,-0.98,-1.29,-0.93,-0.64,-0.12,-0.08,-0.7:SAWING
0.62,1.26,1.2,0.9,0.18,-0.4,-0.2,0.29,0.9,1.23,1.1,0.82,0.0,-0.36,-0.02,0.48,1.13,1.2,0.96,0.42,-0.39,-0.22,0.23,0.97,1.3,1.05,0.59,-0.31,-0.33,0.12,0.94,1.36,1.11,0.71,-0.07,-0.38,-0.03,0.61,1.39,1.26,0.89,0.26,-0.4,-0.11,0.39,1.17,1.32,1.02,0.6,-0.21,-0.31,0.06,0.72,1.45,1.2,0.84,0.32,-0.34,-0.2,0.19,0.94,1.39,1.07,0.69,0.02,-0.41,-0.11,0.48,1.39,1.33,0.9,0.37,-0.41,-0.29,0.24,1.28,1.38,0.98,0.62,0.0,-0.21,0.15,0.78,1.44,1.13,0.85,0.32,-0.32,-0.07,0.32,1.08,1.51,1.13,0.65,-0.33,-0.28,0.07,0.76,1.5,1.23,0.93,0.23,-0.53,-0.18,0.3,1.17,1.42,1.1,0.76,-0.04,-0.5,-0.21,0.36,1.47,1.48,1.07,0.68,-0.4,-0.47,0.08,0.88,1.5,1.18,0.89,0.31,-0.51,-0.25,0.28,1.14,1.42,1.12,0.72,-0.2,-0.42,-0.03,0.58,1.33,1.27,0.97,0.48,-0.29,-0.42,-0.03,0.72,1.45,1.24,0.93,0.43,-0.35,-0.28,0.05,0.94,1.46,1.12,0.84,0.29,-0.35,-0.14,0.21,0.89,1.47,1.16,0.84,0.02,-0.43,-0.07,0.46,1.29,1.3,0.98,0.47,-0.42,-0.25,0.18,0.94,1.41,1.12,0.76,0.12,-0.46,-0.16,0.29,1.37,1.41,0.98,0.45,-0.48,-0.25,0.22,1.02,1.42,1.12,0.78,0.01,-0.5,-0.22,0.37,1.41,1.41,1.1,0.78,-0.08,-0.63,-0.2,0.4,1.52:-0.22,-0.36,-0.9,-1.39,-1.33,-0.97,-0.46,-0.23,-0.23,-0.74,-1.25,-1.22,-0.91,-0.5,-0.32,-0.23,-0.59,-1.07,-1.24,-1.08,-0.62,-0.4,-0.25,-0.41,-0.82,-1.27,-1.18,-0.73,-0.41,-0.23,-0.44,-0.84,-1.2,-1.28,-0.9,-0.43,-0.25,-0.17,-0.58,-1.22,-1.45,-1.17,-0.52,-0.15,-0.09,-0.57,-1.14,-1.34,-1.24,-0.78,-0.32,-0.1,-0.24,-0.77,-1.25,-1.27,-0.99,-0.57,-0.19,-0.07,-0.44,-0.93,-1.27,-1.28,-0.84,-0.41,-0.16,-0.19,-0.64,-1.16,-1.35,-1.12,-0.62,-0.35,-0.18,-0.42,-0.88,-1.29,-1.2,-0.82,-0.43,-0.2,-0.26,-0.56,-1.05,-1.26,-1.07,-0.63,-0.3,-0.11,-0.35,-0.79,-1.22,-1.24,-0.82,-0.42,-0.25,-0.25,-0.66,-1.27,-1.3,-0.9,-0.43,-0.25,-0.27,-0.62,-1.13,-1.32,-1.08,-0.52,-0.28,-0.21,-0.5,-0.88,-1.22,-1.24,-0.9,-0.43,-0.26,-0.31,-0.7,-1.2,-1.36,-1.02,-0.5,-0.33,-0.21,-0.46,-0.89,-1.33,-1.26,-0.87,-0.44,-0.31,-0.27,-0.63,-1.01,-1.23,-1.13,-0.71,-0.4,-0.25,-0.33,-0.82,-1.35,-1.27,-0.8,-0.41,-0.29,-0.25,-0.62,-1.2,-1.39,-1.11,-0.52,-0.23,-0.09,-0.48,-0.96,-1.21,-1.23,-0.88,-0.45,-0.14,-0.09,-0.73,-1.38,-1.41,-1.08,-0.57,-0.17,-0.03,-0.47,-1.04,-1.32,-1.32,-0.83,-0.41,-0.13,-0.16,-0.68,-1.01,-1.26,-1.35,-0.77,-0.39,-0.05,-0.2,-0.79,-1.23,-1.53,-1.25,-0.58,-0.06,-0.06,-0.53,-0.89,-1.22,-1.39,-0.95,-0.45,-0.14,-0.18,-0.65,-1.22,-1.42:-0.47,-0.2,-0.16,-0.22,-0.5,-0.91,-0.99,-0.69,-0.43,-0.16,-0.12,-0.28,-0.68,-0.96,-0.87,-0.47,-0.34,-0.23,-0.19,-0.49,-0.94,-1.0,-0.7,-0.37,-0.12,-0.09,-0.42,-0.75,-1.09,-0.92,-0.52,-0.32,-0.15,-0.16,-0.45,-0.73,-1.21,-0.95,-0.54,-0.2,-0.05,-0.22,-0.57,-1.0,-1.18,-0.83,-0.44,-0.19,-0.08,-0.21,-0.62,-1.04,-1.1,-0.66,-0.31,-0.13,-0.09,-0.44,-0.9,-1.17,-0.85,-0.44,-0.18,-0.07,-0.2,-0.61,-1.12,-1.07,-0.6,-0.25,-0.14,-0.17,-0.44,-0.83,-1.07,-0.89,-0.46,-0.23,-0.08,-0.24,-0.53,-0.93,-1.2,-0.8,-0.52,-0.2,-0.06,-0.25,-0.64,-1.05,-1.08,-0.64,-0.4,-0.12,-0.13,-0.45,-0.84,-1.11,-0.82,-0.39,-0.26,-0.23,-0.32,-0.6,-1.0,-1.04,-0.63,-0.36,-0.24,-0.21,-0.37,-0.76,-1.09,-0.96,-0.53,-0.28,-0.21,-0.21,-0.59,-0.96,-1.08,-0.83,-0.49,-0.23,-0.14,-0.32,-0.75,-1.02,-0.98,-0.68,-0.25,-0.16,-0.2,-0.5,-0.89,-1.13,-0.97,-0.48,-0.12,-0.11,-0.22,-0.66,-1.07,-1.04,-0.68,-0.55,-0.37,-0.41,-0.4,-0.17,-0.07,-0.07,0.05,0.18,0.31,0.3,-0.01,0.03,-0.01,-0.06,-0.07,-0.07,-0.04,-0.02,0.01,0.03,0.05,0.06,0.04,0.04,0.02,-0.03,-0.08,-0.15,-0.22,-0.16,-0.09,-0.06,-0.04,-0.03,-0.03,-0.04,-0.05,-0.07,-0.1,-0.12,-0.11,-0.08,-0.07,-0.05,-0.05,-0.05,-0.06,-0.07,-0.08,-0.09,-0.08,-0.07,-0.06,-0.06,-0.07,-0.08,-0.08,-0.07,-0.07,-0.06:SAWING
0.05,0.54,1.02,0.57,-0.01,0.34,1.0,0.68,0.0,0.28,0.98,0.81,0.02,0.07,0.84,1.05,0.14,-0.04,0.78,1.07,0.32,-0.12,0.77,0.99,0.29,-0.03,0.62,1.02,0.34,-0.04,0.58,1.0,0.44,-0.05,0.59,1.04,0.46,-0.05,0.5,1.04,0.55,-0.12,0.34,1.04,0.82,-0.02,0.12,1.04,0.79,-0.04,0.14,0.97,0.83,0.06,0.08,0.79,0.97,0.34,-0.02,0.54,0.99,0.5,-0.04,0.4,1.04,0.71,0.0,0.1,0.74,1.04,0.48,-0.11,0.2,0.98,0.97,0.18,-0.15,0.45,1.12,0.67,-0.14,0.22,1.0,0.86,-0.01,0.0,0.79,0.97,0.1,0.06,0.78,0.92,0.19,0.02,0.65,0.98,0.35,-0.03,0.41,1.0,0.61,-0.02,0.26,1.06,0.7,-0.01,0.15,0.97,0.91,0.19,-0.05,0.57,1.13,0.54,-0.12,0.25,1.06,0.93,-0.02,-0.04,0.71,1.12,0.54,-0.18,0.16,1.08,1.04,0.14,-0.12,0.58,1.13,0.5,-0.15,0.31,1.12,0.77,-0.12,0.15,1.0,0.83,0.02,0.03,0.82,1.06,0.38,-0.18,0.36,1.12,0.68,-0.13,0.12,1.0,1.02,0.14,-0.23,0.49,1.16,0.59,-0.18,0.18,1.1,0.91,-0.05,-0.06,0.72,1.1,0.39,-0.18,0.27,1.2,0.9,-0.12,-0.15,0.69,1.11,0.48,-0.15,0.1,0.97,1.0,0.07,-0.19,0.55,1.11,0.54,-0.17,0.22,1.07,0.84,-0.03,0.0,0.81,1.01,0.25,-0.13,0.42,1.12,0.62,-0.21,0.14,1.13,0.86,-0.06,-0.05,0.71,1.13:-1.25,-1.38,-0.5,-0.33,-1.19,-1.35,-0.5,-0.34,-1.22,-1.32,-0.52,-0.35,-1.18,-1.32,-0.49,-0.3,-1.26,-1.39,-0.64,-0.25,-0.88,-1.34,-0.78,-0.34,-0.93,-1.37,-0.83,-0.32,-0.63,-1.38,-1.02,-0.36,-0.56,-1.35,-1.11,-0.39,-0.4,-1.27,-1.35,-0.49,-0.27,-1.14,-1.41,-0.73,-0.23,-0.9,-1.35,-0.72,-0.26,-1.05,-1.41,-0.78,-0.28,-0.93,-1.41,-0.78,-0.32,-0.8,-1.33,-0.79,-0.34,-0.84,-1.39,-0.88,-0.26,-0.75,-1.42,-1.02,-0.3,-0.5,-1.38,-1.19,-0.36,-0.48,-1.48,-1.26,-0.43,-0.32,-1.38,-1.32,-0.58,-0.28,-1.02,-1.37,-0.86,-0.35,-0.76,-1.27,-0.97,-0.38,-0.55,-1.39,-1.28,-0.6,-0.32,-0.84,-1.36,-1.13,-0.44,-0.38,-1.07,-1.37,-0.85,-0.44,-0.6,-1.39,-1.18,-0.4,-0.39,-1.37,-1.36,-0.54,-0.3,-1.29,-1.36,-0.52,-0.32,-1.2,-1.36,-0.65,-0.32,-1.0,-1.39,-0.88,-0.34,-0.67,-1.4,-1.02,-0.36,-0.55,-1.51,-1.13,-0.35,-0.38,-1.26,-1.39,-0.69,-0.32,-0.8,-1.33,-1.08,-0.42,-0.42,-1.16,-1.44,-0.72,-0.25,-0.71,-1.41,-1.21,-0.39,-0.32,-1.13,-1.46,-0.78,-0.3,-0.77,-1.35,-1.04,-0.36,-0.5,-1.38,-1.24,-0.45,-0.4,-1.37,-1.37,-0.52,-0.26,-0.94,-1.28,-0.96,-0.44,-0.66,-1.27,-1.16,-0.52,-0.32,-1.0,-1.47,-0.91,-0.36,-0.68,-1.37,-1.12,-0.4,-0.47,-1.25,-1.33,-0.7,-0.36,-0.86,-1.29,-1.0,-0.45,-0.5,-1.22,-1.32,-0.81,-0.4,-0.7,-1.34,-1.14,-0.58,-0.4,-1.02:-0.39,-0.14,-0.08,-0.34,-0.36,-0.3,-0.05,-0.24,-0.39,-0.34,-0.05,-0.2,-0.33,-0.41,-0.22,-0.09,-0.16,-0.37,-0.4,-0.08,-0.13,-0.25,-0.34,-0.29,-0.12,-0.23,-0.33,-0.32,-0.03,-0.11,-0.35,-0.44,-0.11,-0.09,-0.39,-0.4,-0.1,-0.12,-0.33,-0.35,-0.15,-0.1,-0.32,-0.35,-0.24,-0.02,-0.26,-0.36,-0.33,-0.01,-0.17,-0.33,-0.41,-0.04,-0.12,-0.33,-0.4,-0.21,-0.03,-0.25,-0.43,-0.34,-0.03,-0.13,-0.36,-0.42,-0.19,0.01,-0.22,-0.43,-0.41,-0.04,-0.06,-0.36,-0.42,-0.26,0.03,-0.24,-0.44,-0.35,0.03,-0.19,-0.41,-0.38,-0.04,-0.16,-0.5,-0.48,-0.06,0.03,-0.21,-0.48,-0.42,-0.04,-0.22,-0.42,-0.38,0.02,-0.07,-0.29,-0.48,-0.28,0.0,-0.23,-0.4,-0.35,0.02,-0.18,-0.38,-0.38,-0.17,-0.08,-0.28,-0.41,-0.33,-0.01,-0.2,-0.38,-0.37,-0.17,-0.06,-0.23,-0.38,-0.31,-0.09,-0.12,-0.33,-0.31,-0.2,-0.08,-0.31,-0.43,-0.25,0.05,-0.16,-0.46,-0.39,-0.04,-0.14,-0.32,-0.36,-0.25,-0.04,-0.16,-0.35,-0.39,-0.05,-0.11,-0.36,-0.43,-0.15,-0.01,-0.12,-0.47,-0.32,-0.01,-0.29,-0.4,-0.35,0.06,-0.08,-0.37,-0.4,-0.13,-0.1,-0.25,-0.32,-0.27,0.0,-0.19,-0.3,-0.34,-0.11,-0.11,-0.3,-0.31,-0.27,-0.02,-0.14,-0.38,-0.43,-0.23,-0.13,-0.19,-0.36,-0.35,-0.08,-0.12,-0.4,-0.41,-0.28,-0.06,-0.21,-0.45,-0.33,-0.05,-0.21,-0.42,-0.34,-0.19,-0.12,-0.28,-0.42,-0.34,-0.11,-0.21:SAWING
-0.56,-0.27,-0.16,-0.36,-0.51,-0.68,-0.62,-0.46,-0.47,-0.24,0.08,-0.13,-1.0,-1.3,-1.06,-0.27,0.32,0.04,-1.02,-1.63,-1.29,-0.52,0.24,0.17,-0.51,-1.73,-1.39,-0.86,-0.01,0.25,-0.03,-1.14,-1.52,-1.19,-0.49,0.23,0.14,-0.43,-1.5,-1.29,-1.01,-0.21,0.18,-0.1,-0.99,-1.47,-1.22,-0.7,0.02,0.05,-0.33,-1.28,-1.38,-1.07,-0.34,0.11,-0.01,-0.66,-1.52,-1.28,-0.8,0.08,0.26,-0.31,-1.26,-1.45,-1.0,-0.24,0.22,0.09,-0.66,-1.52,-1.22,-0.77,0.0,0.2,-0.18,-1.09,-1.5,-1.2,-0.41,0.24,0.14,-0.55,-1.44,-1.38,-0.97,-0.21,0.18,0.04,-0.86,-1.53,-1.26,-0.77,0.02,0.2,-0.17,-1.21,-1.46,-1.18,-0.45,0.18,0.17,-0.64,-1.51,-1.32,-0.84,0.07,0.17,-0.25,-1.35,-1.42,-1.07,-0.21,0.26,-0.01,-0.85,-1.53,-1.28,-0.73,0.12,0.23,-0.3,-1.37,-1.39,-1.08,-0.37,0.22,0.14,-0.74,-1.45,-1.23,-0.86,-0.07,0.19,-0.17,-1.24,-1.4,-0.99,-0.28,0.17,-0.02,-0.81,-1.48,-1.19,-0.62,0.11,0.2,-0.38,-1.41,-1.41,-1.1,-0.25,0.26,0.12,-0.73,-1.63,-1.29,-0.85,0.02,0.24,-0.04,-0.93,-1.6,-1.26,-0.7,0.11,0.21,-0.15,-1.32,-1.51,-1.14,-0.48,0.2,0.16,-0.45,-1.54,-1.38,-1.0,-0.2,0.2,0.05,-0.84,-1.53,-1.24,-0.75,0.0,0.15,-0.13,-0.98,-1.5,-1.27,-0.67,0.16,0.16,-0.36,-1.45,-1.39,-1.01,-0.31,0.16,0.01,-0.77,-1.52,-1.32,-0.85:-0.25,-0.17,-0.23,-0.25,-0.32,-0.33,-0.48,-0.35,-0.38,-0.25,-0.11,-0.22,-0.42,-0.48,-0.38,-0.12,-0.07,-0.1,-0.4,-0.54,-0.41,-0.27,-0.16,-0.15,-0.32,-0.48,-0.47,-0.37,-0.39,-0.19,-0.3,-0.48,-0.58,-0.55,-0.37,-0.2,-0.08,-0.31,-0.58,-0.55,-0.49,-0.22,-0.06,-0.14,-0.32,-0.46,-0.43,-0.31,-0.31,-0.11,-0.26,-0.43,-0.41,-0.43,-0.33,-0.17,-0.15,-0.42,-0.58,-0.51,-0.56,-0.22,-0.15,-0.27,-0.53,-0.64,-0.48,-0.4,-0.22,-0.16,-0.34,-0.57,-0.59,-0.47,-0.26,-0.11,-0.22,-0.43,-0.56,-0.62,-0.51,-0.13,-0.13,-0.3,-0.51,-0.49,-0.41,-0.33,-0.16,-0.12,-0.34,-0.51,-0.51,-0.43,-0.31,-0.07,-0.24,-0.5,-0.57,-0.53,-0.26,-0.07,-0.09,-0.33,-0.52,-0.55,-0.35,-0.18,-0.07,-0.26,-0.56,-0.46,-0.41,-0.31,-0.05,-0.11,-0.34,-0.56,-0.47,-0.36,-0.28,-0.11,-0.21,-0.45,-0.42,-0.41,-0.31,-0.21,-0.13,-0.38,-0.44,-0.38,-0.33,-0.29,-0.11,-0.24,-0.51,-0.47,-0.45,-0.31,-0.17,-0.14,-0.46,-0.58,-0.53,-0.38,-0.19,-0.08,-0.31,-0.54,-0.53,-0.46,-0.31,-0.14,-0.13,-0.34,-0.5,-0.5,-0.49,-0.31,-0.21,-0.11,-0.36,-0.58,-0.57,-0.32,-0.28,-0.15,-0.16,-0.45,-0.62,-0.48,-0.36,-0.23,-0.11,-0.29,-0.56,-0.61,-0.5,-0.31,-0.18,-0.08,-0.39,-0.6,-0.57,-0.39,-0.29,-0.11,-0.08,-0.45,-0.56,-0.49,-0.34,-0.34,-0.07,-0.21,-0.49,-0.53,-0.5,-0.3,-0.11,-0.14,-0.32,-0.42,-0.67,-0.5:-0.4,-0.91,-1.39,-1.13,-0.72,-0.09,-0.23,-0.75,-1.41,-1.2,-0.61,-0.33,-0.03,-0.68,-1.14,-1.26,-0.85,-0.59,-0.12,-0.34,-0.74,-1.28,-1.13,-0.8,-0.56,-0.02,-0.49,-0.99,-1.16,-0.85,-0.66,-0.39,-0.25,-0.68,-1.13,-1.27,-0.91,-0.51,-0.03,-0.39,-0.82,-1.26,-1.08,-0.76,-0.32,-0.21,-0.67,-1.05,-1.12,-0.87,-0.57,-0.19,-0.49,-0.84,-1.25,-0.97,-0.68,-0.42,-0.22,-0.68,-1.11,-1.19,-0.87,-0.59,-0.22,-0.35,-0.68,-1.33,-1.12,-0.72,-0.36,-0.12,-0.5,-1.0,-1.33,-0.98,-0.7,-0.2,-0.13,-0.68,-1.2,-1.29,-0.84,-0.59,-0.07,-0.42,-0.72,-1.28,-1.16,-0.83,-0.27,-0.13,-0.54,-1.07,-1.34,-0.9,-0.64,-0.03,-0.38,-1.02,-1.36,-1.04,-0.77,-0.16,-0.18,-0.66,-1.23,-1.26,-0.88,-0.54,-0.03,-0.5,-0.86,-1.28,-1.02,-0.91,-0.32,-0.15,-0.78,-1.1,-1.28,-0.85,-0.53,-0.17,-0.41,-0.93,-1.24,-1.02,-0.66,-0.31,-0.21,-0.69,-1.21,-1.18,-0.84,-0.6,-0.04,-0.42,-0.86,-1.44,-1.06,-0.7,-0.3,-0.06,-0.55,-1.17,-1.39,-0.98,-0.64,-0.18,-0.12,-0.65,-1.37,-1.29,-0.77,-0.58,-0.01,-0.3,-0.8,-1.3,-1.13,-0.81,-0.55,0.01,-0.44,-0.99,-1.34,-0.97,-0.71,-0.16,-0.21,-0.65,-1.11,-1.25,-0.88,-0.7,-0.12,-0.23,-0.62,-1.24,-1.27,-0.9,-0.45,-0.03,-0.43,-0.92,-1.3,-1.08,-0.69,-0.14,-0.14,-0.57,-1.1,-1.36,-0.82,-0.66,-0.14,-0.16,-0.72,-1.24,-1.2,-0.81,-0.61,-0.01,-0.4,-0.7:SAWING
-0.08,0.11,-0.23,-1.12,-1.46,-1.17,-0.63,0.0,0.11,-0.29,-1.23,-1.51,-1.21,-0.55,0.07,0.14,-0.5,-1.52,-1.36,-0.99,-0.27,0.14,-0.04,-0.81,-1.59,-1.26,-0.82,-0.09,0.12,-0.11,-0.94,-1.51,-1.24,-0.81,-0.12,0.12,-0.07,-0.87,-1.55,-1.26,-0.85,-0.17,0.11,-0.05,-0.77,-1.47,-1.28,-0.95,-0.31,0.07,0.04,-0.56,-1.46,-1.32,-1.08,-0.4,0.09,0.06,-0.6,-1.46,-1.38,-0.98,-0.27,0.07,-0.02,-0.72,-1.59,-1.28,-0.85,-0.11,0.09,-0.16,-1.0,-1.46,-1.23,-0.75,-0.13,0.08,-0.14,-0.89,-1.47,-1.28,-0.86,-0.2,0.08,-0.13,-0.89,-1.48,-1.26,-0.71,-0.06,0.08,-0.32,-1.28,-1.46,-1.09,-0.38,0.05,-0.1,-0.82,-1.5,-1.2,-0.75,-0.07,0.11,-0.36,-1.46,-1.39,-0.99,-0.5,0.0,0.02,-0.72,-1.61,-1.2,-0.8,-0.21,0.05,-0.31,-1.27,-1.49,-1.06,-0.57,-0.01,-0.03,-0.48,-1.33,-1.4,-1.11,-0.5,-0.02,-0.07,-0.52,-1.39,-1.33,-1.06,-0.46,0.04,-0.04,-0.59,-1.47,-1.28,-1.0,-0.38,0.02,-0.08,-0.73,-1.49,-1.32,-0.98,-0.42,0.01,-0.06,-0.83,-1.46,-1.26,-0.86,-0.22,0.05,-0.15,-1.1,-1.51,-1.14,-0.63,-0.02,0.09,-0.36,-1.29,-1.46,-1.08,-0.47,0.13,0.09,-0.73,-1.61,-1.32,-0.83,-0.18,0.14,-0.24,-1.13,-1.46,-1.1,-0.58,0.0,0.0,-0.52,-1.47,-1.26,-0.88,-0.23,0.05,-0.17,-1.02,-1.44,-1.11,-0.62,0.0,0.09,-0.42,-1.39,-1.39,-1.07,-0.42,0.1,0.0:-0.43,-0.3,-0.2,-0.17,-0.34,-0.46,-0.4,-0.39,-0.32,-0.23,-0.21,-0.38,-0.48,-0.54,-0.42,-0.28,-0.2,-0.26,-0.5,-0.52,-0.47,-0.32,-0.34,-0.29,-0.31,-0.46,-0.47,-0.52,-0.42,-0.18,-0.23,-0.34,-0.49,-0.53,-0.44,-0.29,-0.11,-0.23,-0.43,-0.57,-0.57,-0.46,-0.23,-0.16,-0.21,-0.48,-0.55,-0.35,-0.32,-0.29,-0.17,-0.33,-0.49,-0.38,-0.47,-0.36,-0.18,-0.17,-0.32,-0.55,-0.62,-0.47,-0.3,-0.17,-0.13,-0.39,-0.52,-0.48,-0.41,-0.36,-0.19,-0.23,-0.28,-0.5,-0.48,-0.46,-0.48,-0.1,-0.13,-0.25,-0.45,-0.52,-0.46,-0.43,-0.14,-0.18,-0.29,-0.44,-0.46,-0.43,-0.38,-0.19,-0.16,-0.25,-0.48,-0.45,-0.41,-0.38,-0.18,-0.16,-0.29,-0.53,-0.42,-0.4,-0.32,-0.15,-0.26,-0.35,-0.36,-0.41,-0.31,-0.29,-0.08,-0.2,-0.26,-0.45,-0.37,-0.43,-0.24,-0.11,-0.18,-0.33,-0.33,-0.32,-0.29,-0.29,-0.07,-0.2,-0.36,-0.42,-0.38,-0.17,-0.21,-0.17,-0.4,-0.45,-0.41,-0.34,-0.2,-0.15,-0.18,-0.37,-0.39,-0.34,-0.31,-0.15,-0.04,-0.26,-0.41,-0.35,-0.31,-0.23,-0.08,-0.13,-0.42,-0.5,-0.46,-0.29,-0.17,-0.07,-0.18,-0.37,-0.47,-0.46,-0.24,-0.2,-0.1,-0.23,-0.35,-0.34,-0.37,-0.25,-0.25,-0.07,-0.22,-0.44,-0.39,-0.43,-0.29,-0.12,-0.07,-0.23,-0.39,-0.38,-0.37,-0.23,-0.15,-0.11,-0.26,-0.35,-0.37,-0.38,-0.21,-0.16,-0.11,-0.34,-0.5,-0.48,-0.37,-0.13,-0.15,-0.17,-0.45,-0.48,-0.38,-0.26:-1.26,-0.91,-0.57,-0.12,-0.35,-0.89,-1.33,-1.04,-0.71,-0.07,-0.11,-0.76,-1.25,-1.21,-0.78,-0.41,0.13,-0.55,-1.09,-1.28,-0.86,-0.66,0.05,-0.31,-0.83,-1.25,-1.01,-0.76,-0.37,-0.08,-0.52,-0.99,-1.25,-0.98,-0.59,-0.28,-0.17,-0.64,-1.25,-1.24,-0.73,-0.51,-0.04,-0.34,-0.79,-1.38,-1.13,-0.61,-0.5,0.04,-0.4,-1.01,-1.39,-1.02,-0.7,-0.23,-0.09,-0.55,-1.12,-1.37,-0.95,-0.63,-0.02,-0.25,-0.82,-1.29,-1.18,-0.79,-0.42,0.07,-0.48,-0.89,-1.35,-1.1,-0.6,-0.29,-0.02,-0.56,-1.09,-1.35,-0.93,-0.52,-0.28,-0.15,-0.66,-1.26,-1.24,-0.7,-0.49,-0.06,-0.4,-0.82,-1.26,-1.11,-0.68,-0.41,0.0,-0.39,-1.02,-1.3,-0.97,-0.68,-0.28,-0.08,-0.6,-1.06,-1.28,-0.97,-0.66,0.0,-0.2,-0.64,-1.23,-1.25,-0.81,-0.54,-0.01,-0.32,-0.75,-1.28,-1.13,-0.75,-0.39,0.0,-0.43,-1.0,-1.22,-0.94,-0.66,-0.39,-0.1,-0.6,-1.08,-1.25,-0.92,-0.54,-0.08,-0.27,-0.67,-1.24,-1.26,-0.82,-0.57,0.03,-0.27,-0.78,-1.29,-1.17,-0.83,-0.45,0.05,-0.49,-1.02,-1.32,-0.99,-0.65,-0.33,0.01,-0.69,-1.08,-1.24,-0.92,-0.7,-0.11,-0.14,-0.65,-1.01,-1.3,-1.0,-0.64,-0.32,-0.08,-0.64,-0.97,-1.39,-1.04,-0.62,-0.29,-0.04,-0.62,-0.89,-1.32,-1.02,-0.71,-0.59,0.08,-0.49,-0.85,-1.38,-1.13,-0.72,-0.27,-0.05,-0.52,-0.83,-1.41,-1.08,-0.66,-0.38,0.03,-0.6,-1.06,-1.35,-0.94,-0.64,-0.09:SAWING
-0.4,1.41,1.5,0.44,-1.14,-0.99,0.2,1.88,1.32,-0.39,-1.32,-0.53,1.57,1.67,0.6,-1.02,-1.16,-0.02,1.75,1.51,0.55,-1.1,-1.16,0.0,1.84,1.46,0.15,-1.21,-0.85,0.82,2.06,0.9,-0.79,-1.21,-0.48,1.73,1.63,0.16,-1.09,-1.08,0.41,2.17,0.96,-0.63,-1.45,-0.39,1.62,1.66,0.51,-0.73,-1.27,-0.32,1.65,1.64,0.28,-1.01,-0.98,0.35,1.85,1.21,-0.16,-1.24,-0.65,1.27,1.67,0.65,-0.71,-1.11,-0.06,1.83,1.31,-0.09,-1.19,-0.78,1.38,1.77,0.61,-0.85,-1.05,-0.38,1.29,1.52,0.18,-1.08,-0.7,0.63,1.76,0.97,-0.59,-1.09,-0.14,1.44,1.07,-0.09,-0.91,-0.58,1.19,1.51,0.42,-0.85,-0.78,0.4,1.69,1.08,-0.46,-1.0,-0.53,0.89,1.73,0.62,-0.91,-1.12,-0.04,1.85,1.33,0.11,-1.26,-0.99,0.56,2.03,1.13,-0.37,-1.18,-0.8,0.71,1.9,1.01,-0.58,-1.22,-0.48,1.6,1.51,0.48,-0.95,-1.07,0.0,1.76,1.27,0.09,-0.99,-0.68,0.53,1.68,1.06,-0.47,-1.14,-0.31,1.62,1.39,0.28,-1.0,-0.79,0.22,1.73,1.25,-0.06,-1.14,-0.82,0.87,1.92,0.95,-0.58,-1.09,-0.42,1.53,1.53,0.68,-0.83,-0.92,-0.12,1.53,1.54,0.27,-0.93,-0.91,0.16,1.95,1.46,0.17,-1.22,-0.81,0.57,1.88,1.17,-0.43,-1.12,-0.68,1.01,1.95,0.87,-0.65,-1.29,-0.62,1.87,1.66,0.39,-0.94,-0.94,-0.04,1.66,1.53,0.54,-0.72,-1.1,-0.35,1.57:0.16,0.61,0.88,0.65,0.37,0.17,0.29,0.71,0.95,0.49,0.5,0.11,0.35,1.04,0.63,0.71,0.45,0.12,0.29,0.82,0.86,0.48,0.13,0.12,0.68,0.76,0.67,0.59,0.22,0.11,0.77,0.78,0.53,0.67,0.05,0.24,0.68,0.93,0.68,0.47,0.13,0.3,0.99,0.5,0.67,0.44,0.13,0.37,0.88,0.72,0.5,0.45,0.17,0.41,0.88,0.72,0.59,0.43,0.17,0.25,1.08,0.58,0.5,0.42,0.13,0.31,0.87,0.7,0.62,0.4,0.22,0.62,0.93,0.58,0.49,0.08,0.09,0.69,0.89,0.62,0.45,0.17,0.28,0.91,0.57,0.65,0.2,0.25,0.7,0.77,0.7,0.37,0.12,0.27,0.65,0.75,0.61,0.32,0.12,0.45,0.8,0.76,0.57,0.27,0.09,0.64,0.54,0.54,0.51,0.29,0.26,0.87,0.6,0.47,0.46,0.17,0.51,0.76,0.7,0.64,0.36,0.19,0.73,0.63,0.63,0.7,0.35,0.27,0.83,0.65,0.6,0.55,0.22,0.34,0.93,0.67,0.68,0.35,0.18,0.6,0.77,0.74,0.62,0.24,0.27,0.8,0.8,0.78,0.47,0.14,0.3,0.86,0.83,0.7,0.41,0.0,0.46,0.58,0.9,0.68,0.42,0.06,0.51,0.79,0.7,0.63,0.28,0.2,0.63,0.86,0.73,0.53,0.15,0.2,0.83,0.68,0.63,0.57,0.1,0.28,0.9,0.65,0.63,0.42,0.03,0.6,0.83,0.63,0.51,0.27,0.2,0.63,0.68,0.58,0.7,0.96,0.58,0.54,0.0,0.55,0.67,0.93,0.27,0.51,0.02,-0.25:-0.55,-0.81,-1.01,-0.8,-0.56,-0.3,-0.52,-1.13,-0.98,-0.57,-0.38,-0.4,-0.85,-1.12,-0.85,-0.7,-0.25,-0.52,-1.05,-1.06,-0.84,-0.5,0.0,-0.65,-1.21,-0.95,-0.6,-0.26,-0.2,-0.97,-1.22,-0.87,-0.77,-0.04,-0.4,-1.1,-1.09,-0.87,-0.47,0.1,-0.75,-1.08,-1.02,-0.83,-0.38,0.02,-0.76,-1.16,-0.97,-0.77,-0.28,-0.03,-0.85,-1.21,-0.89,-0.77,0.0,-0.45,-1.13,-1.04,-0.78,-0.37,-0.1,-0.65,-1.3,-1.04,-0.62,-0.2,-0.18,-0.97,-1.24,-0.89,-0.76,0.05,-0.46,-1.12,-0.99,-0.79,-0.54,-0.03,-0.61,-1.24,-0.99,-0.94,-0.28,-0.19,-0.79,-1.17,-0.93,-0.92,-0.08,-0.37,-0.99,-1.12,-0.84,-0.63,0.11,-0.72,-1.14,-1.2,-0.88,-0.08,0.12,-0.87,-1.36,-1.04,-0.77,0.16,-0.29,-1.19,-1.09,-0.91,-0.39,0.02,-0.78,-1.29,-0.98,-0.6,0.01,-0.38,-1.24,-1.17,-0.7,-0.64,-0.11,-0.87,-1.24,-0.99,-0.94,-0.05,-0.59,-1.09,-1.24,-1.02,-0.41,-0.1,-0.84,-1.14,-1.11,-0.92,-0.1,-0.43,-1.05,-1.27,-1.13,-0.35,0.08,-0.8,-1.34,-1.18,-1.14,-0.25,0.03,-0.84,-1.33,-1.07,-1.17,-0.23,0.08,-0.94,-1.37,-1.09,-0.87,0.24,-0.34,-1.32,-1.22,-0.89,-0.3,0.13,-0.84,-1.44,-1.04,-0.83,-0.03,-0.19,-1.29,-1.35,-0.88,-0.38,0.0,-0.52,-1.32,-1.32,-0.94,-0.22,0.06,-0.81,-1.41,-1.12,-0.95,-0.05,-0.15,-0.99,-1.33,-1.02,-0.69,-0.01,-0.38,-1.17,-1.29,-1.06,-0.24,-0.1,-1.04,-1.26:SAWING
0.24,0.54,0.61,0.58,0.68,0.57,0.22,-0.34,-0.21,0.96,1.85,1.36,0.48,-0.73,-0.82,-0.2,1.73,2.0,1.07,0.24,-0.8,-0.77,-0.11,1.78,1.92,0.97,0.02,-0.75,-0.62,0.13,1.93,1.65,0.91,0.18,-0.73,-0.68,-0.02,1.61,1.66,0.95,0.23,-0.67,-0.65,-0.02,1.94,1.81,0.93,0.02,-0.93,-0.71,0.18,2.17,1.62,0.69,-0.14,-0.9,-0.66,0.2,2.19,1.79,0.85,0.07,-0.94,-0.94,-0.38,1.12,2.41,1.5,0.57,-0.51,-1.08,-0.79,0.18,2.29,1.85,0.91,-0.16,-1.02,-0.83,-0.08,1.86,1.95,1.1,0.1,-0.94,-0.91,-0.34,1.05,2.04,1.38,0.58,-0.49,-1.01,-0.65,0.36,2.1,1.61,0.85,0.08,-0.91,-0.91,-0.38,1.16,2.07,1.28,0.47,-0.26,-0.75,-0.12,1.52,1.92,1.27,0.48,-0.39,-0.95,-0.65,0.16,2.07,1.76,1.0,0.29,-0.81,-0.92,-0.41,0.77,2.12,1.46,0.73,0.08,-0.89,-0.83,-0.32,1.09,2.12,1.39,0.61,-0.22,-0.82,-0.66,-0.02,1.65,1.9,1.12,0.35,-0.56,-0.87,-0.41,0.56,2.15,1.5,0.69,-0.02,-0.82,-0.7,-0.07,1.64,1.85,1.05,0.32,-0.65,-0.81,-0.36,0.7,1.98,1.45,0.68,-0.03,-0.95,-0.66,0.16,1.9,1.66,0.96,0.23,-0.84,-0.81,-0.21,0.95,1.87,1.31,0.63,-0.21,-0.92,-0.6,0.27,1.84,1.57,0.93,0.16,-1.02,-0.8,-0.06,1.49,1.74,1.12,0.39,-0.48,-0.94,-0.46,0.82,1.83,1.31,0.75,0.12,-0.88,-0.85:0.59,0.58,0.5,0.44,0.5,0.75,0.45,0.54,0.63,0.62,0.48,0.33,0.65,0.56,0.51,0.65,0.57,0.36,0.27,0.61,0.63,0.53,0.64,0.78,0.51,0.33,0.46,0.68,0.53,0.5,0.67,0.57,0.39,0.35,0.75,0.53,0.48,0.65,0.7,0.52,0.32,0.53,0.76,0.56,0.55,0.62,0.44,0.41,0.63,0.75,0.58,0.55,0.68,0.58,0.36,0.35,0.82,0.59,0.44,0.61,0.67,0.55,0.4,0.52,0.77,0.47,0.47,0.64,0.66,0.55,0.43,0.48,0.78,0.46,0.44,0.58,0.7,0.62,0.44,0.5,0.62,0.54,0.55,0.66,0.74,0.6,0.53,0.74,0.42,0.43,0.65,0.75,0.59,0.46,0.63,0.58,0.45,0.56,0.65,0.57,0.41,0.42,0.75,0.53,0.55,0.64,0.69,0.54,0.53,0.73,0.44,0.4,0.61,0.79,0.69,0.62,0.55,0.64,0.46,0.5,0.62,0.7,0.56,0.5,0.73,0.58,0.42,0.55,0.78,0.73,0.52,0.65,0.62,0.47,0.53,0.66,0.66,0.52,0.61,0.71,0.55,0.64,0.68,0.67,0.6,0.53,0.61,0.63,0.5,0.55,0.65,0.72,0.58,0.56,0.55,0.44,0.46,0.65,0.94,0.93,0.67,0.61,0.55,0.41,0.56,0.63,0.58,0.45,0.55,0.73,0.45,0.46,0.67,0.65,0.58,0.6,0.67,0.66,0.45,0.55,0.58,0.71,0.62,0.53,0.75,0.48,0.4,0.66,0.74,0.69,0.5,0.5,0.73,0.48,0.45,0.7,0.78,0.6,0.49,0.63,0.56,0.48,0.58,0.73,0.67,0.48:-0.76,-0.59,-0.47,-0.27,-0.48,-0.8,-1.1,-0.85,-0.59,-0.4,-0.37,-0.54,-0.83,-1.07,-0.85,-0.52,-0.35,-0.23,-0.52,-0.86,-0.99,-0.73,-0.52,-0.36,-0.29,-0.55,-0.87,-1.0,-0.81,-0.6,-0.26,-0.19,-0.47,-0.87,-1.17,-0.88,-0.63,-0.59,-0.21,-0.17,-0.64,-1.05,-1.07,-0.67,-0.57,-0.39,-0.12,-0.45,-0.92,-1.27,-0.81,-0.58,-0.47,-0.18,-0.37,-0.81,-1.17,-0.84,-0.55,-0.53,-0.31,-0.28,-0.66,-1.02,-1.05,-0.72,-0.64,-0.31,-0.14,-0.51,-0.85,-1.07,-0.88,-0.54,-0.62,-0.4,-0.27,-0.62,-0.93,-0.76,-0.62,-0.59,-0.14,-0.29,-0.71,-1.02,-1.11,-0.7,-0.59,-0.44,-0.14,-0.4,-0.77,-1.09,-1.0,-0.67,-0.6,-0.35,-0.16,-0.5,-0.87,-1.15,-0.94,-0.64,-0.57,-0.3,-0.2,-0.57,-0.93,-0.99,-0.79,-0.67,-0.38,-0.21,-0.35,-0.66,-0.99,-0.95,-0.75,-0.58,-0.32,-0.2,-0.49,-0.87,-1.02,-0.82,-0.64,-0.49,-0.27,-0.33,-0.7,-1.09,-0.98,-0.64,-0.59,-0.3,-0.25,-0.58,-0.81,-0.95,-0.76,-0.63,-0.41,-0.29,-0.5,-0.8,-0.94,-0.71,-0.62,-0.67,-0.35,-0.23,-0.57,-0.97,-1.07,-0.66,-0.56,-0.38,-0.14,-0.46,-0.86,-1.05,-0.75,-0.6,-0.45,-0.24,-0.35,-0.73,-1.01,-1.07,-0.7,-0.44,-0.33,-0.25,-0.6,-0.86,-1.02,-0.86,-0.55,-0.49,-0.28,-0.3,-0.62,-0.9,-1.02,-0.76,-0.62,-0.25,-0.24,-0.45,-0.69,-0.99,-1.1,-0.77,-0.38,-0.25,-0.35,-0.61,-0.89,-0.97,-0.65,-0.65,-0.4,-0.19,-0.52,-0.79:SAWING
-0.08,1.09,1.45,0.83,-0.55,-0.42,0.63,1.52,1.04,-0.53,-0.45,0.6,1.53,1.0,-0.36,-0.46,0.51,1.59,0.9,-0.64,-0.31,0.7,1.48,0.8,-0.54,-0.14,0.94,1.42,0.49,-0.58,0.04,1.46,1.22,-0.16,-0.36,0.63,1.46,0.67,-0.51,-0.04,1.38,1.13,-0.17,-0.31,0.82,1.48,0.5,-0.72,0.04,1.91,1.08,-0.62,-0.39,0.75,1.5,0.46,-0.59,0.26,1.61,0.96,-0.38,0.01,1.39,1.13,-0.34,-0.34,0.81,1.47,0.47,-0.54,0.25,1.61,0.87,-0.42,0.09,1.53,1.0,-0.2,-0.06,1.0,1.24,0.32,-0.32,0.31,1.48,1.0,-0.34,-0.01,1.24,1.24,-0.15,-0.28,0.72,1.4,0.45,-0.38,0.42,1.44,0.7,-0.43,0.2,1.52,0.72,-0.42,0.08,1.42,0.99,-0.43,-0.03,1.42,1.0,-0.39,0.01,1.39,0.98,-0.41,-0.01,1.34,1.1,-0.36,-0.05,1.2,1.0,-0.31,0.05,1.28,0.94,-0.26,0.23,1.32,0.79,-0.32,0.16,1.26,0.89,-0.26,0.12,1.18,0.93,-0.25,0.09,1.18,0.95,-0.22,-0.01,1.0,1.06,-0.01,-0.1,0.84,1.18,0.17,-0.22,0.62,1.2,0.39,-0.28,0.37,1.24,0.71,-0.27,0.16,1.12,0.86,-0.18,0.09,1.01,0.98,-0.05,-0.06,0.94,1.16,-0.01,-0.21,0.82,1.13,0.14,-0.23,0.7,1.26,0.25,-0.28,0.5,1.29,0.57,-0.26,0.42,1.36,0.43,-0.36,0.42,1.26,0.64,-0.26,0.24,1.19,0.83,-0.21,0.2,1.22,0.77,-0.24,0.33,1.13,0.54,-0.14:-0.3,-1.13,-1.0,-0.33,-0.07,-1.19,-1.13,-0.4,-0.19,-0.88,-1.11,-0.76,-0.27,-0.45,-1.02,-1.0,-0.35,-0.21,-0.99,-1.16,-0.5,-0.29,-0.7,-1.17,-0.68,-0.29,-0.62,-1.19,-0.75,-0.34,-0.57,-1.2,-0.78,-0.36,-0.49,-1.12,-0.97,-0.37,-0.43,-1.1,-0.97,-0.41,-0.5,-1.09,-1.06,-0.32,-0.42,-1.04,-1.13,-0.32,-0.47,-1.07,-1.01,-0.34,-0.5,-1.14,-0.93,-0.25,-0.62,-1.11,-1.01,-0.25,-0.55,-1.06,-1.06,-0.28,-0.43,-1.1,-1.08,-0.24,-0.46,-1.09,-1.08,-0.33,-0.4,-0.94,-1.09,-0.57,-0.37,-0.86,-1.14,-0.78,-0.28,-0.76,-1.13,-0.93,-0.26,-0.54,-1.11,-1.02,-0.28,-0.47,-1.04,-1.0,-0.32,-0.45,-0.98,-1.06,-0.6,-0.29,-1.0,-1.18,-0.73,-0.22,-0.89,-1.26,-0.67,-0.26,-0.86,-1.24,-0.8,-0.19,-0.69,-1.18,-0.83,-0.17,-0.68,-1.39,-0.9,-0.15,-0.64,-1.25,-0.99,-0.23,-0.55,-1.17,-0.97,-0.22,-0.56,-1.13,-0.94,-0.3,-0.69,-1.18,-0.83,-0.34,-0.74,-1.13,-0.82,-0.29,-0.74,-1.2,-0.9,-0.26,-0.52,-1.26,-1.06,-0.31,-0.38,-1.25,-1.14,-0.3,-0.34,-1.08,-1.29,-0.72,-0.28,-0.78,-1.18,-0.92,-0.29,-0.64,-1.23,-0.99,-0.32,-0.58,-0.97,-1.11,-0.38,-0.45,-1.06,-1.06,-0.47,-0.46,-0.97,-1.13,-0.55,-0.44,-0.72,-1.2,-0.93,-0.33,-0.56,-1.05,-1.07,-0.35,-0.57,-1.08,-1.07,-0.34,-0.57,-1.01,-0.97,-0.36,-0.55,-0.95,-1.1,-0.46,-0.45,-1.01,-1.16,-0.53,-0.33,-1.04,-1.32,-0.72:-0.67,-0.77,-0.13,-0.26,-0.55,-0.84,-0.3,-0.11,-0.55,-0.89,-0.32,-0.13,-0.43,-0.79,-0.34,-0.08,-0.38,-0.88,-0.5,-0.06,-0.29,-0.76,-0.5,0.01,-0.31,-0.86,-0.57,0.05,-0.24,-0.77,-0.71,-0.06,-0.13,-0.75,-0.72,-0.09,-0.26,-0.72,-0.58,-0.08,-0.34,-0.81,-0.48,-0.07,-0.38,-0.78,-0.47,-0.11,-0.39,-0.79,-0.51,-0.07,-0.23,-0.78,-0.72,-0.06,-0.09,-0.74,-0.86,-0.06,0.01,-0.55,-1.0,-0.34,0.0,-0.31,-0.84,-0.5,-0.06,-0.28,-0.75,-0.59,-0.11,-0.23,-0.64,-0.68,-0.16,-0.28,-0.64,-0.73,-0.18,-0.27,-0.52,-0.78,-0.3,-0.18,-0.41,-0.77,-0.58,-0.08,-0.32,-0.66,-0.73,-0.17,-0.22,-0.64,-0.78,-0.17,-0.25,-0.65,-0.71,-0.22,-0.25,-0.62,-0.75,-0.23,-0.2,-0.57,-0.89,-0.15,-0.02,-0.52,-0.93,-0.27,0.02,-0.31,-0.94,-0.39,-0.02,-0.29,-0.87,-0.49,-0.03,-0.38,-0.86,-0.42,-0.06,-0.32,-0.92,-0.49,0.02,-0.32,-0.82,-0.59,0.0,-0.28,-0.74,-0.65,0.04,-0.17,-0.76,-0.77,0.0,-0.12,-0.55,-0.87,-0.2,-0.1,-0.62,-0.8,-0.23,-0.02,-0.46,-0.91,-0.36,-0.07,-0.32,-0.82,-0.48,0.03,-0.19,-0.75,-0.58,0.02,-0.18,-0.7,-0.65,-0.03,-0.16,-0.61,-0.6,-0.1,-0.19,-0.62,-0.66,-0.09,-0.13,-0.6,-0.76,-0.12,-0.06,-0.59,-0.75,-0.2,-0.02,-0.56,-0.78,-0.3,-0.02,-0.5,-0.72,-0.2,-0.11,-0.59,-0.76,-0.15,-0.11,-0.53,-0.75,-0.37,-0.12,-0.36,-0.73,-0.37,-0.22,-0.27:SAWING
-1.19,-0.58,0.13,0.15,-0.41,-1.47,-1.4,-1.13,-0.44,0.13,0.1,-0.42,-1.44,-1.46,-1.11,-0.53,0.12,0.1,-0.36,-1.27,-1.39,-1.1,-0.52,0.11,0.1,-0.43,-1.35,-1.44,-1.11,-0.47,0.1,0.1,-0.23,-1.39,-1.64,-1.2,-0.21,0.28,0.13,-0.72,-1.75,-1.37,-0.83,-0.03,0.19,-0.06,-1.28,-1.52,-1.17,-0.57,0.11,0.12,-0.36,-1.51,-1.42,-1.09,-0.44,0.15,0.13,-0.51,-1.61,-1.41,-1.07,-0.31,0.16,0.06,-0.68,-1.55,-1.32,-1.0,-0.27,0.16,0.04,-0.56,-1.62,-1.36,-0.96,-0.27,0.16,0.04,-0.72,-1.57,-1.33,-0.98,-0.26,0.16,0.03,-0.68,-1.52,-1.45,-1.1,-0.2,0.23,0.09,-0.73,-1.55,-1.46,-0.95,-0.09,0.21,0.0,-0.94,-1.63,-1.26,-0.81,-0.14,0.08,-0.12,-0.92,-1.44,-1.18,-0.65,0.0,0.02,-0.34,-1.21,-1.36,-1.09,-0.36,0.1,0.08,-0.61,-1.64,-1.26,-0.73,-0.04,0.14,-0.21,-1.19,-1.41,-1.05,-0.42,0.1,0.1,-0.35,-1.47,-1.39,-1.0,-0.33,0.16,0.06,-0.69,-1.48,-1.25,-0.75,-0.06,0.09,-0.26,-1.14,-1.38,-0.93,-0.23,0.11,-0.06,-1.0,-1.44,-1.1,-0.48,0.1,0.12,-0.49,-1.53,-1.3,-0.82,-0.13,0.09,-0.18,-1.06,-1.39,-1.04,-0.5,0.07,0.06,-0.51,-1.48,-1.28,-0.86,-0.15,0.13,-0.06,-0.91,-1.46,-1.19,-0.71,-0.01,0.12,-0.14,-1.11,-1.46,-1.13,-0.61,0.08,0.13,-0.44,-1.35,-1.36,-1.05,-0.37,0.11,0.08,-0.76,-1.52,-1.27,-0.9,-0.11,0.15:-0.35,-0.07,-0.09,-0.36,-0.54,-0.58,-0.42,-0.33,-0.25,-0.15,-0.37,-0.59,-0.55,-0.44,-0.46,-0.1,-0.27,-0.44,-0.66,-0.54,-0.49,-0.35,-0.12,-0.24,-0.59,-0.6,-0.47,-0.34,-0.11,-0.19,-0.41,-0.59,-0.54,-0.39,-0.25,-0.11,-0.26,-0.47,-0.55,-0.49,-0.36,-0.28,-0.13,-0.21,-0.46,-0.47,-0.42,-0.36,-0.24,-0.2,-0.29,-0.45,-0.32,-0.32,-0.31,-0.39,-0.13,-0.37,-0.54,-0.46,-0.34,-0.25,-0.18,-0.19,-0.48,-0.6,-0.4,-0.28,-0.34,-0.16,-0.31,-0.5,-0.4,-0.34,-0.38,-0.25,-0.13,-0.21,-0.5,-0.53,-0.44,-0.34,-0.33,-0.07,-0.21,-0.43,-0.5,-0.41,-0.4,-0.29,-0.18,-0.27,-0.48,-0.62,-0.45,-0.23,-0.29,-0.05,-0.21,-0.7,-0.62,-0.37,-0.29,-0.26,-0.1,-0.38,-0.7,-0.6,-0.27,-0.24,-0.1,-0.22,-0.46,-0.51,-0.38,-0.25,-0.32,-0.19,-0.23,-0.46,-0.42,-0.35,-0.29,-0.35,-0.11,-0.25,-0.54,-0.58,-0.4,-0.32,-0.21,-0.12,-0.29,-0.55,-0.55,-0.43,-0.22,-0.31,-0.17,-0.25,-0.47,-0.43,-0.39,-0.39,-0.25,-0.15,-0.26,-0.49,-0.54,-0.44,-0.34,-0.19,-0.15,-0.31,-0.49,-0.51,-0.4,-0.32,-0.11,-0.09,-0.36,-0.57,-0.52,-0.32,-0.27,-0.26,-0.18,-0.38,-0.51,-0.48,-0.35,-0.42,-0.21,-0.14,-0.36,-0.53,-0.47,-0.36,-0.33,-0.12,-0.25,-0.48,-0.5,-0.44,-0.3,-0.32,-0.2,-0.41,-0.54,-0.4,-0.32,-0.31,-0.23,-0.32,-0.48,-0.54,-0.49,-0.32,-0.3,-0.27,-0.28,-0.45,-0.47,-0.44,-0.39,-0.25:-1.16,-0.82,-0.56,-0.13,-0.38,-0.87,-1.34,-1.05,-0.55,-0.35,-0.06,-0.66,-1.25,-1.16,-0.74,-0.63,-0.07,-0.45,-0.85,-1.26,-1.14,-0.6,-0.56,-0.1,-0.42,-0.91,-1.33,-1.04,-0.6,-0.4,-0.21,-0.66,-1.13,-1.11,-0.73,-0.33,-0.35,-0.55,-1.01,-1.11,-0.78,-0.67,-0.29,-0.29,-0.82,-1.25,-1.06,-0.6,-0.5,-0.07,-0.53,-1.09,-1.21,-0.85,-0.63,-0.25,-0.39,-0.76,-1.12,-1.01,-0.68,-0.5,-0.11,-0.53,-1.09,-1.25,-0.86,-0.78,-0.16,-0.14,-0.75,-1.17,-1.22,-0.8,-0.72,-0.13,-0.28,-0.72,-1.2,-1.17,-0.84,-0.59,-0.03,-0.45,-0.91,-1.26,-1.0,-0.73,-0.41,-0.04,-0.55,-1.07,-1.26,-0.86,-0.73,-0.26,-0.11,-0.61,-1.1,-1.24,-0.85,-0.73,-0.25,-0.11,-0.61,-1.1,-1.26,-0.9,-0.76,-0.24,-0.13,-0.6,-1.08,-1.35,-0.92,-0.68,-0.2,-0.18,-0.65,-1.06,-1.23,-0.91,-0.77,-0.18,-0.22,-0.62,-1.09,-1.25,-0.83,-0.74,-0.21,-0.21,-0.68,-1.16,-1.16,-0.75,-0.67,-0.17,-0.31,-0.81,-1.27,-1.05,-0.76,-0.47,-0.15,-0.53,-0.87,-1.17,-0.96,-0.59,-0.62,-0.22,-0.44,-0.82,-1.2,-0.99,-0.74,-0.44,-0.17,-0.59,-1.02,-1.14,-0.92,-0.57,-0.16,-0.41,-0.73,-1.2,-1.11,-0.81,-0.55,-0.08,-0.49,-0.87,-1.21,-1.0,-0.67,-0.29,-0.29,-0.62,-1.11,-1.13,-0.7,-0.72,-0.14,-0.38,-0.69,-1.21,-1.26,-0.79,-0.65,-0.11,-0.23,-0.74,-1.39,-1.17,-0.65,-0.59,0.03,-0.34,-0.9,-1.35,-1.17,-0.77,-0.42,-0.05:SAWING
-1.32,0.16,0.64,0.06,-1.5,-1.37,-0.28,0.56,0.33,-1.04,-1.54,-0.61,0.47,0.38,-0.51,-1.57,-1.0,0.21,0.46,-0.13,-1.54,-1.21,0.11,0.49,-0.02,-1.55,-1.27,0.01,0.48,0.1,-1.35,-1.41,-0.28,0.48,0.22,-1.0,-1.46,-0.63,0.37,0.38,-0.57,-1.57,-0.98,0.21,0.45,-0.18,-1.44,-1.2,-0.04,0.49,0.14,-1.17,-1.49,-0.5,0.45,0.37,-0.7,-1.62,-0.94,0.3,0.53,0.02,-1.5,-1.48,-0.37,0.51,0.47,-0.87,-1.66,-0.69,0.42,0.42,-0.54,-1.51,-0.82,0.31,0.46,-0.35,-1.54,-1.13,0.17,0.57,0.06,-1.48,-1.35,-0.15,0.51,0.3,-1.02,-1.52,-0.56,0.41,0.44,-0.53,-1.61,-1.0,0.18,0.55,0.05,-1.51,-1.42,-0.33,0.5,0.41,-0.9,-1.66,-0.79,0.44,0.58,-0.22,-1.58,-1.21,0.11,0.57,0.11,-1.38,-1.47,-0.47,0.49,0.52,-0.58,-1.71,-1.06,0.23,0.57,-0.02,-1.52,-1.27,-0.14,0.49,0.28,-0.97,-1.59,-0.8,0.38,0.51,-0.24,-1.52,-1.14,0.12,0.55,0.08,-1.37,-1.45,-0.46,0.46,0.44,-0.66,-1.57,-1.14,-0.1,0.5,0.38,-1.01,-1.6,-0.75,0.36,0.59,-0.18,-1.61,-1.33,-0.15,0.54,0.45,-0.84,-1.7,-0.93,0.17,0.63,0.04,-1.62,-1.32,-0.13,0.5,0.28,-1.11,-1.53,-0.66,0.39,0.48,-0.33,-1.62,-1.11,0.16,0.48,0.08,-1.38,-1.4,-0.38,0.39,0.37,-0.58,-1.59,-0.98,0.17,0.51,0.15,-1.36,-1.48,-0.38,0.44,0.34,-0.57,-1.59,-0.96,0.16:-0.4,-0.63,-0.4,-1.05,-0.82,-0.6,-0.65,-0.32,-0.75,-0.94,-0.69,-0.62,-0.43,-0.38,-1.17,-0.77,-0.54,-0.53,-0.32,-0.85,-0.83,-0.8,-0.75,-0.29,-0.49,-1.04,-0.72,-0.58,-0.54,-0.31,-1.01,-0.83,-0.5,-0.67,-0.34,-0.67,-1.0,-0.69,-0.61,-0.35,-0.46,-1.02,-0.73,-0.62,-0.52,-0.2,-0.73,-1.06,-0.68,-0.7,-0.58,-0.23,-0.98,-0.81,-0.64,-0.59,-0.29,-0.61,-1.06,-0.64,-0.68,-0.65,-0.14,-0.92,-0.78,-0.58,-0.73,-0.29,-0.64,-0.98,-0.59,-0.65,-0.53,-0.29,-1.06,-0.87,-0.62,-0.61,-0.29,-0.85,-1.04,-0.64,-0.62,-0.49,-0.51,-1.18,-0.84,-0.48,-0.65,-0.32,-0.89,-1.01,-0.63,-0.57,-0.55,-0.51,-1.18,-0.9,-0.58,-0.6,-0.31,-0.99,-1.0,-0.64,-0.58,-0.68,-0.51,-1.1,-0.8,-0.5,-0.74,-0.4,-0.66,-0.97,-0.76,-0.66,-0.47,-0.42,-1.24,-0.91,-0.44,-0.54,-0.47,-0.93,-1.0,-0.75,-0.54,-0.5,-0.47,-1.16,-0.89,-0.57,-0.56,-0.36,-0.86,-1.11,-0.72,-0.51,-0.57,-0.42,-1.05,-1.0,-0.58,-0.62,-0.38,-0.66,-1.13,-0.85,-0.46,-0.55,-0.32,-0.93,-1.04,-0.7,-0.5,-0.46,-0.56,-1.17,-0.83,-0.41,-0.64,-0.4,-0.83,-1.01,-0.66,-0.69,-0.59,-0.35,-1.08,-0.77,-0.56,-0.71,-0.31,-0.82,-0.85,-0.79,-0.71,-0.46,-0.41,-1.12,-0.89,-0.6,-0.75,-0.46,-0.72,-0.98,-0.82,-0.78,-0.57,-0.33,-1.04,-0.98,-0.71,-0.72,-0.6,-0.66,-1.14,-0.88,-0.75,-0.72,-0.54,-0.98,-0.97,-0.72,-0.71,-0.53:-0.47,-0.23,-0.51,-1.11,-0.92,-0.52,-0.16,-0.48,-0.9,-0.99,-0.7,-0.3,-0.4,-0.65,-1.1,-0.88,-0.52,-0.22,-0.51,-1.0,-0.92,-0.58,-0.35,-0.44,-0.74,-1.02,-0.75,-0.33,-0.34,-0.64,-1.06,-0.87,-0.51,-0.38,-0.43,-0.74,-1.01,-0.81,-0.37,-0.34,-0.68,-0.96,-0.85,-0.51,-0.26,-0.5,-1.0,-1.05,-0.64,-0.25,-0.43,-0.82,-0.96,-0.74,-0.34,-0.38,-0.64,-1.02,-0.86,-0.68,-0.31,-0.44,-0.73,-1.02,-0.77,-0.45,-0.47,-0.57,-0.82,-0.88,-0.6,-0.46,-0.46,-0.63,-0.93,-0.73,-0.59,-0.35,-0.47,-0.78,-0.9,-0.68,-0.41,-0.4,-0.63,-1.07,-0.84,-0.49,-0.29,-0.44,-0.99,-1.01,-0.59,-0.3,-0.41,-0.77,-1.08,-0.68,-0.34,-0.39,-0.54,-1.02,-0.88,-0.55,-0.24,-0.44,-0.81,-1.04,-0.66,-0.3,-0.34,-0.52,-1.06,-0.95,-0.52,-0.2,-0.42,-0.75,-1.07,-0.68,-0.27,-0.23,-0.62,-1.08,-0.92,-0.5,-0.23,-0.42,-0.68,-1.12,-0.81,-0.32,-0.3,-0.51,-1.07,-0.97,-0.46,-0.23,-0.43,-0.91,-1.11,-0.67,-0.28,-0.31,-0.52,-1.12,-0.95,-0.46,-0.25,-0.39,-0.75,-1.13,-0.68,-0.37,-0.38,-0.44,-1.01,-1.0,-0.64,-0.27,-0.44,-0.65,-1.07,-0.77,-0.53,-0.32,-0.41,-0.82,-1.08,-0.73,-0.43,-0.41,-0.48,-1.01,-0.83,-0.54,-0.35,-0.38,-0.76,-1.07,-0.8,-0.29,-0.25,-0.56,-1.0,-0.94,-0.44,-0.24,-0.39,-0.72,-1.11,-0.76,-0.4,-0.33,-0.35,-1.04,-1.08,-0.56,-0.27,-0.36,-0.58,-1.0,-0.72,-0.43,-0.34,-0.3:SAWING
-1.8,-1.7,-0.53,0.77,0.68,-1.0,-1.91,-1.0,0.44,0.83,-0.13,-1.79,-1.44,-0.02,0.83,0.37,-1.46,-1.79,-0.56,0.82,0.75,-0.95,-1.9,-1.05,0.41,0.92,-0.14,-1.96,-1.37,-0.08,0.77,0.38,-1.26,-1.54,-0.6,0.56,0.65,-0.47,-1.83,-1.26,0.22,0.89,0.3,-1.44,-1.77,-0.78,0.64,0.78,-0.32,-1.94,-1.32,0.14,0.91,0.31,-1.5,-1.76,-0.53,0.68,0.82,-0.58,-1.91,-1.18,0.2,0.81,0.25,-1.52,-1.61,-0.29,0.69,0.53,-1.25,-1.66,-0.66,0.61,0.75,-0.61,-1.79,-1.07,0.24,0.69,0.1,-1.55,-1.39,-0.14,0.64,0.4,-1.27,-1.66,-0.63,0.62,0.76,-0.51,-1.74,-1.06,0.21,0.78,0.31,-1.59,-1.45,-0.47,0.66,0.76,-0.54,-1.78,-1.18,0.24,0.97,0.48,-1.57,-1.77,-0.75,0.81,1.07,-0.22,-2.07,-1.46,-0.06,0.91,0.73,-0.64,-2.14,-1.26,0.34,0.9,0.33,-1.38,-1.83,-0.91,0.65,0.97,0.03,-1.97,-1.54,-0.44,0.95,0.85,-0.7,-1.85,-1.1,0.16,0.81,0.1,-1.48,-1.22,-0.16,0.58,0.3,-1.08,-1.48,-0.69,0.44,0.56,-0.35,-1.63,-1.18,0.01,0.62,0.34,-1.0,-1.48,-0.63,0.33,0.47,0.0,-1.22,-1.3,-0.28,0.47,0.42,-0.42,-1.34,-0.85,0.14,0.48,-0.01,-1.1,-1.13,-0.26,0.41,0.36,-0.42,-1.26,-0.87,0.24,0.49,-0.02,-1.3,-1.13,0.02,0.57,0.19,-0.87,-1.38,-0.68,0.36,0.6,0.01,-1.5,-1.26,-0.04,0.67,0.38,-0.99,-1.41,-0.46,0.51:-0.69,-0.85,-0.54,-0.55,-0.09,-0.63,-0.76,-0.45,-0.43,-0.28,-0.41,-0.72,-0.44,-0.51,-0.48,-0.25,-0.66,-0.66,-0.49,-0.44,-0.53,-0.31,-0.76,-0.59,-0.51,-0.48,-0.42,-0.53,-0.8,-0.65,-0.44,-0.46,-0.31,-0.76,-0.65,-0.5,-0.46,-0.37,-0.74,-0.93,-0.56,-0.32,-0.4,-0.42,-0.94,-0.75,-0.39,-0.36,-0.21,-0.58,-0.82,-0.66,-0.48,-0.41,-0.25,-0.91,-0.82,-0.46,-0.46,-0.18,-0.67,-0.93,-0.59,-0.49,-0.46,-0.34,-0.92,-0.6,-0.37,-0.47,-0.23,-0.7,-0.74,-0.58,-0.5,-0.13,-0.55,-0.95,-0.58,-0.43,-0.53,-0.35,-0.85,-0.63,-0.49,-0.48,-0.17,-0.59,-0.85,-0.5,-0.43,-0.47,-0.24,-0.82,-0.55,-0.36,-0.54,-0.19,-0.63,-0.65,-0.32,-0.56,-0.35,-0.45,-0.76,-0.39,-0.28,-0.61,-0.36,-0.71,-0.5,-0.45,-0.54,-0.07,-0.76,-0.76,-0.44,-0.58,-0.25,-0.44,-0.81,-0.34,-0.58,-0.59,-0.08,-0.84,-0.68,-0.35,-0.65,-0.42,-0.27,-0.87,-0.62,-0.34,-0.66,-0.35,-0.52,-0.87,-0.44,-0.45,-0.64,-0.26,-0.71,-0.65,-0.46,-0.69,-0.48,-0.36,-0.79,-0.56,-0.35,-0.43,-0.32,-0.47,-0.91,-0.42,-0.34,-0.48,-0.17,-0.89,-0.56,-0.34,-0.63,-0.13,-0.32,-0.89,-0.48,-0.43,-0.48,-0.09,-0.57,-0.74,-0.42,-0.46,-0.21,-0.51,-0.86,-0.45,-0.37,-0.44,-0.28,-0.98,-0.76,-0.41,-0.45,-0.29,-0.38,-1.06,-0.7,-0.34,-0.48,-0.28,-0.27,-1.06,-0.74,-0.42,-0.5,-0.25,-0.28,-0.95,-0.8,-0.37,-0.37,-0.32,-0.32,-0.99:-0.19,-0.64,-1.39,-1.09,-0.65,-0.22,-0.51,-1.33,-1.16,-0.86,-0.29,-0.35,-0.91,-1.38,-0.99,-0.51,-0.26,-0.72,-1.41,-1.12,-0.59,-0.08,-0.62,-1.39,-1.16,-0.72,-0.17,-0.4,-1.04,-1.27,-0.86,-0.54,-0.27,-0.63,-1.24,-1.04,-0.71,-0.27,-0.43,-0.92,-1.3,-0.93,-0.65,-0.09,-0.52,-1.3,-1.08,-0.81,-0.35,-0.36,-0.8,-1.44,-0.96,-0.7,-0.31,-0.34,-1.11,-1.45,-0.93,-0.55,-0.19,-0.55,-1.28,-1.18,-0.82,-0.5,-0.32,-0.73,-1.13,-0.95,-0.86,-0.36,-0.23,-1.0,-1.12,-0.92,-0.69,-0.21,-0.67,-1.25,-1.08,-0.76,-0.26,-0.51,-1.33,-1.28,-0.68,-0.51,-0.3,-0.8,-1.33,-1.04,-0.78,-0.42,-0.42,-1.1,-1.25,-0.81,-0.61,-0.56,-0.7,-1.27,-1.13,-0.7,-0.46,-0.5,-1.05,-1.32,-0.95,-0.53,-0.58,-0.8,-1.24,-1.06,-0.55,-0.38,-0.65,-1.23,-1.34,-0.72,-0.31,-0.47,-0.81,-1.27,-1.12,-0.8,-0.4,-0.48,-1.23,-1.32,-0.78,-0.42,-0.47,-0.77,-1.25,-1.0,-0.65,-0.51,-0.59,-0.99,-1.0,-0.76,-0.51,-0.48,-1.02,-1.16,-0.92,-0.55,-0.43,-0.74,-1.17,-0.9,-0.71,-0.61,-0.65,-1.06,-1.13,-0.8,-0.6,-0.44,-0.73,-1.25,-0.94,-0.74,-0.6,-0.66,-1.04,-1.05,-0.83,-0.62,-0.51,-0.89,-1.08,-0.83,-0.8,-0.5,-0.72,-1.04,-0.93,-0.88,-0.57,-0.65,-0.94,-1.13,-0.89,-0.53,-0.52,-0.93,-1.26,-0.98,-0.57,-0.42,-0.7,-1.06,-1.02,-0.9,-0.53,-0.53,-0.85,-1.25,-0.91,-0.68,-0.5,-0.55,-1.0,-1.09:SAWING
-0.33,0.78,1.21,-0.16,-0.31,0.87,1.12,0.08,-0.34,0.66,1.12,-0.13,-0.23,1.01,1.1,-0.24,-0.2,1.07,1.08,-0.3,-0.16,1.2,1.1,-0.23,-0.24,0.94,1.24,0.11,-0.31,0.58,1.3,0.47,-0.38,0.32,1.34,0.49,-0.19,0.51,1.22,0.36,-0.24,0.46,1.24,0.34,-0.2,0.45,1.2,0.32,-0.22,0.62,1.14,0.1,-0.18,0.7,1.13,0.08,-0.12,0.78,1.04,0.02,-0.07,0.88,0.88,-0.09,0.06,0.97,0.86,-0.07,0.05,0.98,0.9,-0.06,0.06,1.02,0.86,0.04,-0.01,0.77,1.01,0.24,-0.12,0.58,1.08,0.27,-0.11,0.5,1.1,0.46,-0.15,0.39,1.17,0.5,-0.1,0.37,1.13,0.59,-0.07,0.26,1.16,0.66,-0.05,0.2,1.09,0.79,0.0,0.08,0.86,0.9,0.1,0.02,0.85,1.01,0.1,0.03,0.67,1.17,0.4,-0.1,0.49,1.13,0.64,-0.05,0.28,1.2,0.74,-0.08,0.25,1.18,0.69,-0.02,0.25,1.17,0.84,0.0,0.14,0.98,0.88,0.07,0.07,0.8,1.02,0.11,0.02,0.64,1.06,0.32,-0.05,0.46,1.1,0.42,-0.06,0.38,1.08,0.55,-0.03,0.32,1.0,0.66,-0.15,0.17,1.14,0.81,-0.11,0.12,0.96,0.94,0.16,-0.05,0.56,1.18,0.41,-0.17,0.39,1.22,0.58,-0.11,0.19,1.24,0.84,0.0,0.05,0.75,1.04,0.17,-0.1,0.6,1.11,0.27,-0.15,0.49,1.17,0.45,-0.08,0.33,1.21,0.68,-0.1,0.16,1.08,0.85,0.01,0.05,0.86,1.05,0.08,-0.06:-1.39,-1.21,-0.28,-0.34,-1.39,-1.21,-0.39,-0.38,-1.21,-1.33,-0.56,-0.29,-1.12,-1.4,-0.64,-0.27,-0.88,-1.39,-0.76,-0.28,-0.82,-1.32,-0.84,-0.38,-0.73,-1.29,-0.9,-0.4,-0.65,-1.28,-1.1,-0.46,-0.44,-1.32,-1.26,-0.53,-0.29,-1.13,-1.37,-0.7,-0.24,-0.71,-1.39,-0.97,-0.22,-0.55,-1.53,-1.06,-0.35,-0.4,-1.22,-1.32,-0.61,-0.24,-1.0,-1.35,-0.67,-0.25,-0.93,-1.39,-0.82,-0.13,-0.71,-1.4,-0.95,-0.29,-0.45,-1.39,-1.17,-0.4,-0.35,-1.32,-1.26,-0.54,-0.2,-1.23,-1.42,-0.75,-0.24,-0.82,-1.44,-0.84,-0.2,-0.71,-1.51,-0.98,-0.24,-0.57,-1.38,-1.12,-0.42,-0.38,-1.32,-1.32,-0.48,-0.34,-1.4,-1.26,-0.45,-0.38,-1.12,-1.36,-0.71,-0.28,-1.05,-1.36,-0.75,-0.28,-0.9,-1.44,-0.9,-0.27,-0.73,-1.38,-0.98,-0.31,-0.51,-1.39,-1.23,-0.62,-0.34,-0.66,-1.37,-1.27,-0.74,-0.21,-0.53,-1.53,-1.39,-0.57,-0.12,-0.78,-1.26,-1.19,-0.85,-0.48,-0.44,-1.0,-1.26,-0.71,-0.32,-0.72,-1.22,-1.01,-0.35,-0.59,-1.01,-1.13,-0.72,-0.27,-0.83,-1.08,-0.85,-0.32,-0.76,-1.04,-0.95,-0.29,-0.71,-1.04,-1.05,-0.31,-0.56,-0.94,-1.14,-0.74,-0.32,-0.79,-1.1,-0.93,-0.3,-0.47,-0.98,-1.17,-0.95,-0.4,-0.4,-0.97,-1.25,-1.07,-0.51,-0.14,-0.64,-1.41,-1.32,-0.79,-0.32,-0.33,-0.9,-1.29,-1.09,-0.7,-0.32,-0.57,-1.17,-1.22,-0.99,-0.41,-0.28,-0.86,-1.32,-1.18,-0.55,-0.28,-0.71,-1.21:-0.22,0.15,-0.26,-0.8,-0.39,0.15,0.0,-0.79,-0.58,0.18,0.03,-0.69,-0.56,0.18,-0.05,-0.84,-0.65,0.16,0.09,-0.72,-0.74,0.09,0.15,-0.65,-0.83,0.0,0.18,-0.59,-0.87,-0.15,0.15,-0.37,-0.84,-0.33,0.2,-0.25,-0.81,-0.38,0.14,-0.25,-0.78,-0.4,0.11,-0.03,-0.7,-0.66,0.05,0.03,-0.73,-0.72,0.05,0.12,-0.6,-0.78,-0.19,0.07,-0.27,-0.74,-0.47,0.07,0.03,-0.84,-0.75,0.13,0.23,-0.73,-0.88,-0.11,0.13,-0.54,-0.85,-0.12,0.16,-0.44,-0.94,-0.27,0.22,-0.24,-0.95,-0.46,0.15,-0.06,-0.76,-0.61,0.04,0.06,-0.66,-0.77,0.03,0.19,-0.59,-0.88,-0.15,0.22,-0.31,-0.83,-0.32,0.31,-0.23,-0.86,-0.39,0.21,-0.05,-0.77,-0.57,0.16,0.15,-0.76,-0.73,0.21,0.14,-0.81,-0.61,0.11,0.16,-0.57,-0.75,-0.05,0.17,-0.41,-0.74,-0.12,0.21,-0.28,-0.77,-0.27,0.21,-0.17,-0.73,-0.33,0.19,0.05,-0.7,-0.6,-0.02,0.14,-0.05,-0.55,-0.68,-0.16,0.22,0.08,-0.88,-0.71,0.01,0.29,-0.02,-0.68,-0.71,-0.29,-0.02,-0.01,-0.48,-0.65,-0.28,-0.01,-0.19,-0.55,-0.59,-0.05,-0.09,-0.42,-0.63,-0.34,-0.06,-0.32,-0.63,-0.41,-0.11,-0.27,-0.62,-0.5,-0.07,-0.19,-0.57,-0.61,-0.08,-0.12,-0.5,-0.75,-0.31,-0.09,-0.28,-0.74,-0.44,-0.06,-0.01,-0.49,-0.83,-0.46,-0.11,-0.03,-0.42,-0.75,-0.61,-0.07,0.12,-0.17,-0.69,-0.79,-0.29,0.01,0.08,-0.35,-0.74,-0.64:SAWING
-0.94,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.94,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.94,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.95,-0.94,-0.95,-0.95,-0.95,-1.02,-1.21,-1.13,-0.78,-0.43,-0.23,-0.17,-0.47,-0.75,-0.6,0.18,0.48,0.16,-1.33,-1.49,-0.51,0.7,0.71,-0.54,-1.84,-1.17,0.19,0.75,0.33,-1.47,-1.67,-0.47,0.64,0.54,-0.55,-1.76,-1.11,0.17,0.6,0.17,-1.34,-1.59,-0.58,0.47,0.46,-0.23,-1.77,-1.34,-0.05,0.64,0.22,-1.16,-1.66,-0.7,0.52,0.49,-0.44,-1.7,-1.2,0.12,0.54,0.09,-1.44,-1.58,-0.55,0.53,0.44,-0.47,-1.79,-1.27,0.26,0.77,0.16,-1.6,-1.72,-0.41,0.68,0.57,-0.58,-1.91,-1.23,0.35,0.78,0.23,-1.63,-1.79,-0.41,0.69,0.54,-0.6,-1.9,-1.23,0.31,0.73,0.21,-1.53,-1.76,-0.44,0.63,0.52,-0.63,-1.79,-1.0,0.38,0.7,-0.18,-1.66,-1.41,-0.24,0.69,0.48,-0.94,-1.73,-0.84,0.3,0.56,-0.11,-1.58,-1.24,-0.12,0.4,0.15,-0.9,-1.42,-0.71,0.06,0.16,-0.26,-1.21,-1.18,-0.51,0.15,-0.02,-0.89,-1.28,-0.83,0.01,0.12,-0.29,-1.4,-1.29,-0.55,0.16,0.06,-0.58,-1.57,-1.2,-0.3,0.2,-0.05,-1.01,-1.46,-0.67,0.21,0.13,-0.4,-1.28,-1.13,-0.2,0.35,0.16,-0.85,-1.65,-0.99,0.05,0.45,0.1,-1.3,-1.49,-0.68,0.29,0.41,-0.17,-1.51,-1.33,-0.4,0.36,0.27,-0.45:-0.25,-0.24,-0.25,-0.24,-0.24,-0.24,-0.24,-0.24,-0.24,-0.24,-0.24,-0.24,-0.25,-0.25,-0.24,-0.25,-0.26,-0.41,-0.5,-0.85,-0.89,-0.28,-0.07,-0.01,-0.47,-0.83,-0.42,-0.63,-0.79,-0.91,-0.62,-0.29,-0.4,-1.06,-0.77,-0.67,-0.59,-0.05,-0.72,-1.1,-0.72,-0.72,-0.42,-0.21,-1.21,-0.9,-0.73,-0.46,-0.02,-0.82,-1.13,-0.74,-0.68,-0.32,-0.39,-1.16,-0.86,-0.54,-0.43,-0.3,-0.53,-1.09,-0.82,-0.56,-0.42,-0.23,-1.02,-0.93,-0.45,-0.37,-0.23,-0.75,-1.05,-0.68,-0.44,-0.32,-0.44,-1.19,-0.83,-0.46,-0.38,-0.18,-0.69,-0.94,-0.67,-0.52,-0.34,-0.36,-1.14,-0.82,-0.41,-0.38,-0.15,-0.86,-0.97,-0.51,-0.57,-0.52,-0.36,-1.02,-0.71,-0.58,-0.5,-0.11,-0.78,-1.11,-0.62,-0.59,-0.57,-0.29,-0.93,-0.63,-0.48,-0.64,-0.27,-0.78,-0.69,-0.46,-0.56,-0.34,-0.64,-0.76,-0.45,-0.66,-0.62,-0.23,-0.8,-0.75,-0.52,-0.49,-0.2,-0.47,-1.14,-0.86,-0.5,-0.28,-0.24,-1.06,-1.2,-0.86,-0.33,-0.11,-0.62,-1.45,-1.08,-0.32,-0.06,-0.29,-1.21,-1.24,-0.6,-0.15,-0.06,-0.55,-1.38,-1.06,-0.4,-0.04,0.02,-0.8,-1.32,-0.97,-0.4,-0.16,-0.45,-1.08,-1.19,-0.84,-0.36,-0.37,-0.82,-0.98,-0.81,-0.55,-0.36,-0.22,-0.93,-0.98,-0.7,-0.51,-0.34,-0.41,-1.04,-0.74,-0.65,-0.51,-0.29,-0.48,-1.17,-0.84,-0.67,-0.44,-0.23,-0.75,-1.1,-0.7,-0.48,-0.52,-0.2,-0.87,-1.09,-0.62,-0.5,-0.46,-0.35,-0.93:-0.74,-0.31,-0.37,-0.56,-1.19,-1.25,-0.69,-0.23,-0.28,-0.56,-1.21,-1.08,-0.67,-0.34,-0.31,-0.59,-1.09,-1.01,-0.67,-0.3,-0.33,-0.56,-1.12,-1.06,-0.64,-0.23,-0.32,-0.58,-1.23,-1.01,-0.53,-0.26,-0.44,-0.82,-1.22,-0.85,-0.51,-0.13,-0.38,-0.91,-1.24,-0.88,-0.56,-0.25,-0.43,-0.86,-1.23,-0.81,-0.45,-0.19,-0.46,-0.9,-1.28,-0.86,-0.41,-0.13,-0.6,-0.95,-1.26,-0.77,-0.34,-0.4,-0.62,-0.96,-0.99,-0.79,-0.41,-0.43,-0.6,-1.23,-1.08,-0.5,-0.17,-0.43,-0.59,-1.17,-1.07,-0.68,-0.2,-0.42,-0.66,-1.13,-0.98,-0.5,-0.06,-0.53,-0.9,-1.09,-0.76,-0.42,-0.34,-0.59,-0.94,-1.07,-0.69,-0.31,-0.38,-0.65,-1.08,-0.94,-0.68,-0.16,-0.5,-0.87,-1.05,-0.79,-0.64,-0.3,-0.53,-0.92,-1.11,-0.81,-0.42,-0.44,-0.62,-1.0,-0.92,-0.82,-0.47,-0.4,-0.61,-1.16,-1.01,-0.66,-0.23,-0.48,-0.74,-1.1,-0.9,-0.5,-0.25,-0.53,-0.77,-1.11,-0.96,-0.62,-0.37,-0.48,-0.71,-1.11,-0.85,-0.49,-0.31,-0.52,-0.99,-1.13,-0.74,-0.43,-0.32,-0.56,-1.04,-1.24,-0.72,-0.32,-0.39,-0.57,-1.01,-1.16,-0.71,-0.51,-0.22,-0.42,-0.95,-1.23,-0.87,-0.53,-0.23,-0.54,-0.99,-1.19,-0.84,-0.49,-0.18,-0.5,-0.89,-1.14,-0.9,-0.33,-0.22,-0.55,-1.08,-1.16,-0.76,-0.38,-0.3,-0.47,-1.19,-1.34,-0.75,-0.32,-0.22,-0.53,-1.05,-1.26,-0.8,-0.35,-0.2,-0.45,-0.89,-1.3,-0.98,-0.45,-0.16,-0.43,-1.13,-1.26:SAWING
-0.42,0.66,2.06,1.44,0.65,-0.23,-0.75,-0.51,0.24,1.97,1.68,0.85,0.03,-0.82,-0.64,0.07,1.92,1.82,0.94,0.12,-0.86,-0.7,0.01,1.92,1.82,0.95,0.23,-0.8,-0.73,-0.08,1.75,1.88,1.11,0.39,-0.82,-0.74,-0.14,1.37,1.85,1.16,0.39,-0.75,-0.82,-0.29,1.27,1.9,1.13,0.33,-0.63,-0.8,-0.35,1.05,2.0,1.27,0.52,-0.48,-0.82,-0.43,0.63,2.02,1.43,0.7,-0.12,-0.75,-0.58,0.19,1.81,1.61,0.92,0.15,-0.71,-0.65,-0.06,1.46,1.8,1.05,0.33,-0.68,-0.77,-0.28,1.16,1.98,1.22,0.45,-0.58,-0.77,-0.29,0.88,1.91,1.31,0.62,-0.1,-0.63,-0.56,0.13,1.93,1.66,0.8,0.0,-0.8,-0.58,0.26,1.9,1.53,0.82,0.23,-0.64,-0.69,-0.14,1.25,1.85,1.19,0.51,-0.2,-0.79,-0.49,0.38,2.0,1.44,0.66,-0.34,-0.72,-0.36,0.56,1.86,1.39,0.71,-0.02,-0.77,-0.57,0.18,1.87,1.65,0.82,0.07,-0.7,-0.55,0.17,1.65,1.62,0.89,-0.04,-0.73,-0.49,0.18,1.68,1.59,0.9,0.15,-0.76,-0.63,-0.04,1.55,1.74,1.06,0.34,-0.61,-0.61,-0.21,1.02,1.78,1.22,0.53,-0.53,-0.76,-0.29,1.17,1.9,1.15,0.44,-0.67,-0.74,-0.24,1.33,1.89,1.12,0.45,-0.51,-0.8,-0.31,1.13,1.95,1.18,0.51,-0.34,-0.74,-0.34,0.76,1.85,1.34,0.59,-0.31,-0.7,-0.43,0.33,1.96,1.55,0.78,-0.1,-0.74,-0.49,0.31,1.8,1.55,0.85,0.24:0.83,0.49,0.5,0.63,0.55,0.42,0.6,0.78,0.49,0.46,0.57,0.65,0.57,0.78,0.65,0.43,0.53,0.6,0.55,0.5,0.68,0.67,0.38,0.51,0.58,0.55,0.49,0.65,0.68,0.5,0.51,0.45,0.54,0.5,0.59,0.74,0.51,0.51,0.51,0.65,0.57,0.64,0.75,0.53,0.5,0.55,0.58,0.5,0.59,0.7,0.48,0.56,0.6,0.6,0.45,0.53,0.76,0.51,0.5,0.6,0.58,0.52,0.67,0.78,0.47,0.48,0.59,0.63,0.47,0.42,0.67,0.6,0.55,0.6,0.6,0.53,0.48,0.79,0.6,0.42,0.55,0.63,0.45,0.39,0.78,0.62,0.44,0.59,0.7,0.6,0.52,0.87,0.55,0.42,0.6,0.7,0.47,0.3,0.56,0.69,0.63,0.6,0.62,0.46,0.36,0.68,0.71,0.47,0.55,0.66,0.56,0.45,0.56,0.79,0.5,0.53,0.67,0.62,0.44,0.52,0.82,0.46,0.53,0.68,0.61,0.45,0.53,0.75,0.55,0.49,0.57,0.73,0.62,0.51,0.65,0.59,0.44,0.56,0.67,0.63,0.46,0.57,0.75,0.47,0.51,0.63,0.54,0.39,0.47,0.75,0.54,0.51,0.55,0.61,0.52,0.44,0.83,0.58,0.45,0.54,0.61,0.58,0.54,0.8,0.49,0.45,0.57,0.65,0.61,0.55,0.7,0.66,0.39,0.46,0.64,0.71,0.53,0.45,0.78,0.52,0.5,0.65,0.64,0.43,0.5,0.77,0.51,0.5,0.61,0.65,0.52,0.47,0.73,0.62,0.48,0.58,0.62,0.49,0.56,0.73,0.59,0.52,0.63,0.68,0.51,0.5:-0.3,-0.6,-0.92,-0.99,-0.74,-0.52,-0.43,-0.28,-0.57,-0.86,-0.99,-0.77,-0.6,-0.33,-0.23,-0.52,-0.88,-1.02,-0.77,-0.71,-0.34,-0.2,-0.51,-0.79,-0.97,-0.75,-0.58,-0.45,-0.24,-0.48,-0.82,-1.06,-0.8,-0.57,-0.44,-0.23,-0.4,-0.75,-1.09,-0.98,-0.6,-0.4,-0.39,-0.4,-0.66,-0.95,-0.96,-0.64,-0.5,-0.37,-0.25,-0.7,-1.07,-1.02,-0.72,-0.43,-0.17,-0.25,-0.78,-1.04,-0.91,-0.63,-0.5,-0.36,-0.28,-0.72,-1.03,-0.96,-0.72,-0.47,-0.29,-0.41,-0.71,-0.93,-0.93,-0.72,-0.55,-0.4,-0.21,-0.51,-0.84,-1.04,-0.85,-0.64,-0.35,-0.25,-0.45,-0.82,-1.12,-0.9,-0.63,-0.43,-0.25,-0.42,-0.79,-1.09,-0.89,-0.69,-0.44,-0.2,-0.33,-0.75,-1.09,-0.96,-0.66,-0.57,-0.33,-0.24,-0.62,-0.97,-1.06,-0.81,-0.56,-0.33,-0.22,-0.5,-0.93,-1.09,-0.77,-0.55,-0.42,-0.18,-0.4,-0.81,-1.14,-0.99,-0.6,-0.32,-0.33,-0.37,-0.73,-1.05,-0.94,-0.65,-0.56,-0.3,-0.25,-0.63,-0.96,-1.04,-0.72,-0.51,-0.38,-0.24,-0.57,-0.89,-1.02,-0.81,-0.7,-0.48,-0.2,-0.45,-0.71,-1.04,-0.96,-0.63,-0.45,-0.33,-0.24,-0.61,-0.97,-1.06,-0.79,-0.57,-0.27,-0.2,-0.6,-0.92,-1.07,-0.83,-0.6,-0.37,-0.14,-0.43,-0.89,-1.12,-0.87,-0.66,-0.44,-0.23,-0.33,-0.75,-1.05,-1.11,-0.78,-0.41,-0.35,-0.25,-0.57,-0.92,-0.99,-0.8,-0.7,-0.35,-0.11,-0.44,-0.78,-1.05,-1.02,-0.7,-0.37,-0.23,-0.33,-0.72,-1.01,-0.97:SAWING
0.32,0.8,0.29,-1.45,-1.87,-0.89,0.47,0.8,0.24,-1.82,-1.83,-0.54,0.66,0.7,-0.37,-1.98,-1.34,-0.13,0.58,0.48,-0.73,-2.0,-1.26,0.06,0.65,0.45,-0.9,-1.95,-1.14,0.15,0.58,0.29,-1.24,-1.83,-0.82,0.44,0.59,0.11,-1.71,-1.64,-0.66,0.45,0.54,-0.06,-1.73,-1.55,-0.56,0.47,0.51,-0.09,-1.76,-1.62,-0.36,0.56,0.53,-0.57,-1.91,-1.32,0.13,0.66,0.4,-1.05,-1.97,-1.09,0.27,0.68,0.33,-1.53,-1.87,-0.62,0.54,0.61,-0.2,-1.87,-1.42,0.04,0.57,0.32,-1.0,-1.87,-0.85,0.52,0.59,-0.06,-1.83,-1.49,-0.03,0.64,0.33,-1.24,-1.87,-0.77,0.44,0.5,0.03,-1.62,-1.63,-0.48,0.4,0.41,-0.4,-1.75,-1.23,0.06,0.43,0.11,-1.32,-1.6,-0.71,0.34,0.43,-0.03,-1.73,-1.52,-0.28,0.42,0.24,-0.69,-1.66,-1.19,-0.11,0.42,0.19,-1.2,-1.69,-0.86,0.25,0.34,-0.19,-1.66,-1.46,-0.38,0.31,0.31,-0.58,-1.79,-1.27,-0.21,0.35,0.35,-0.52,-1.82,-1.29,-0.22,0.43,0.4,-0.92,-1.88,-1.08,0.0,0.44,0.29,-1.2,-1.83,-0.92,0.21,0.51,0.13,-1.55,-1.65,-0.74,0.33,0.42,-0.06,-1.6,-1.58,-0.72,0.35,0.53,-0.14,-1.79,-1.49,-0.37,0.46,0.34,-0.66,-1.76,-1.22,0.0,0.66,0.4,-1.38,-1.83,-0.92,0.42,0.58,0.02,-1.41,-1.67,-0.85,0.33,0.58,0.15,-1.6,-1.73,-0.56,0.57,0.45,-0.53,-1.74,-1.3,-0.22,0.44,0.39,-0.6,-1.78:-0.91,-0.63,-0.71,-0.48,-0.32,-1.1,-0.9,-0.59,-0.66,-0.4,-0.57,-1.09,-0.82,-0.67,-0.58,-0.35,-0.83,-0.91,-0.56,-0.55,-0.67,-0.3,-0.89,-0.91,-0.65,-0.6,-0.68,-0.28,-0.94,-0.93,-0.49,-0.65,-0.62,-0.48,-1.07,-0.77,-0.55,-0.62,-0.34,-0.5,-1.02,-0.77,-0.6,-0.59,-0.27,-0.65,-1.17,-0.8,-0.51,-0.55,-0.24,-0.95,-1.05,-0.65,-0.57,-0.58,-0.21,-0.91,-1.13,-0.62,-0.51,-0.61,-0.17,-1.13,-0.98,-0.55,-0.56,-0.71,-0.12,-1.05,-0.99,-0.59,-0.72,-0.51,-0.27,-0.95,-0.85,-0.43,-0.46,-0.36,-0.45,-1.22,-0.83,-0.49,-0.6,-0.5,-0.33,-1.0,-0.85,-0.59,-0.61,-0.56,-0.29,-1.11,-0.77,-0.48,-0.65,-0.63,-0.3,-0.95,-0.79,-0.5,-0.61,-0.39,-0.56,-1.26,-0.7,-0.41,-0.56,-0.32,-0.57,-1.24,-0.75,-0.41,-0.67,-0.43,-0.39,-1.22,-0.86,-0.48,-0.65,-0.4,-0.55,-0.88,-0.63,-0.51,-0.78,-0.41,-0.49,-0.88,-0.68,-0.56,-0.65,-0.29,-0.77,-0.99,-0.64,-0.6,-0.64,-0.31,-0.98,-1.02,-0.66,-0.65,-0.6,-0.32,-1.08,-0.82,-0.56,-0.82,-0.64,-0.19,-0.94,-0.83,-0.47,-0.78,-0.62,-0.24,-0.94,-0.8,-0.6,-0.72,-0.47,-0.32,-0.97,-0.81,-0.59,-0.73,-0.46,-0.4,-1.07,-0.81,-0.57,-0.6,-0.44,-0.56,-1.16,-0.7,-0.52,-0.66,-0.46,-0.57,-1.0,-0.59,-0.48,-0.71,-0.44,-0.62,-1.01,-0.65,-0.51,-0.73,-0.51,-0.55,-0.97,-0.56,-0.52,-0.68,-0.31,-0.78,-0.85,-0.56,-0.71,-0.73,-0.32,-0.72:-0.41,-0.67,-1.16,-0.87,-0.52,-0.15,-0.41,-0.74,-1.2,-0.85,-0.48,-0.14,-0.47,-1.05,-1.25,-0.66,-0.21,-0.22,-0.51,-1.26,-1.2,-0.63,-0.33,-0.24,-0.41,-1.22,-1.09,-0.5,-0.22,-0.29,-0.56,-1.1,-0.9,-0.49,-0.22,-0.47,-0.74,-1.07,-0.83,-0.6,-0.09,-0.38,-1.02,-1.24,-0.66,-0.36,-0.28,-0.56,-1.05,-1.0,-0.52,-0.42,-0.47,-0.71,-1.05,-0.78,-0.56,-0.27,-0.52,-1.13,-0.92,-0.52,-0.4,-0.54,-0.69,-1.04,-0.86,-0.6,-0.27,-0.56,-0.9,-0.97,-0.68,-0.43,-0.27,-0.57,-1.09,-0.86,-0.53,-0.28,-0.39,-0.67,-1.08,-0.82,-0.54,-0.31,-0.43,-1.05,-0.99,-0.59,-0.39,-0.41,-0.59,-1.05,-1.02,-0.76,-0.27,-0.23,-0.58,-1.33,-1.0,-0.38,-0.16,-0.47,-1.01,-1.08,-0.6,-0.12,-0.34,-0.54,-1.1,-0.91,-0.49,-0.15,-0.27,-0.51,-1.25,-0.98,-0.56,-0.05,-0.31,-0.51,-1.24,-0.9,-0.42,-0.16,-0.47,-0.76,-1.22,-0.74,-0.23,-0.12,-0.57,-0.86,-1.06,-0.64,-0.4,-0.21,-0.4,-0.98,-1.11,-0.63,-0.26,-0.15,-0.45,-1.13,-1.02,-0.57,-0.1,-0.19,-0.43,-1.21,-1.04,-0.5,0.01,-0.37,-0.8,-1.07,-0.77,-0.67,-0.14,-0.33,-0.87,-1.07,-0.8,-0.47,-0.06,-0.45,-0.92,-1.09,-0.74,-0.28,-0.24,-0.56,-0.93,-0.89,-0.72,-0.25,-0.24,-0.49,-1.13,-0.94,-0.68,-0.24,-0.25,-0.54,-1.19,-0.89,-0.46,-0.02,-0.36,-0.79,-1.1,-0.71,-0.65,-0.14,-0.27,-0.69,-1.11,-0.77,-0.41,0.03,-0.47,-0.8,-1.0,-0.68:SAWING
