## Score Augmentation for Diffusion Models (ScoreAug)

### Dependency and Setup  
This implementation builds heavily upon the **EDM** codebase. For detailed instructions on **requirements**, **dataset preparation**, and **FID calculation**, please refer to the original EDM README. Below, we provide examples for training ScoreAug.  

### Training Sxample Scripts

Below are some training script examples. For specific parameters and enhancement options, please refer to Appendix B of the paper.

- **Unconditional CIFAR-10, DDPM++, EDM w/o NLA + ScoreAug**  
   ```bash
   torchrun --standalone --nproc_per_node=8 train.py \
       --outdir=training-runs/uncond_cifar10_ddpmpp_nla_scoreaug \
       --nosubdir \
       --data=datasets/cifar10-32x32.zip \
       --cond=0 \
       --arch=ddpmpp \
       --augment=0 \
       --brightness=2 \
       --translation=0.25 \
       --cutout-v1=0.5 \
       --rotation=1 \
       --aug-cond=1
   ```

- **Conditional CIFAR-10, NCSN++, EDM w/ NLA + ScoreAug**  
   ```bash
   torchrun --standalone --nproc_per_node=8 train.py \
       --outdir=training-runs/cond_cifar10_ncsnpp_scoreaug \
       --nosubdir \
       --data=datasets/cifar10-32x32.zip \
       --cond=1 \
       --arch=ncsnpp \
       --augment=1 \
       --translation=0.125 \
       --cutout-v1=0.25 \
       --aug-cond=1
   ```

- **Unconditional CIFAR-10, DDPM++, ScoreAug × NLA (Eq6)**  
   ```bash
   torchrun --standalone --nproc_per_node=8 train.py \
       --outdir=training-runs/uncond_cifar10_ddpmpp_gsa1 \
       --nosubdir \
       --data=datasets/cifar10-32x32.zip \
       --cond=0 \
       --arch=ddpmpp \
       --gen-score-aug-v1=1
   ```

- **Conditional CIFAR-10, NCSN++, ScoreAug × NLA (Eq8)**  
   ```bash
   torchrun --standalone --nproc_per_node=8 train.py \
       --outdir=training-runs/cond_cifar10_ncsnpp_gsa2 \
       --nosubdir \
       --data=datasets/cifar10-32x32.zip \
       --cond=1 \
       --arch=ncsnpp \
       --gen-score-aug-v2=1
   ```
