import numpy as np

def deep_sea_obs_preprocess(obs, to_save=False):
    if to_save:
        return obs.flatten().argmax()
    return obs.flatten()

def cartpole_obs_preprocess(obs):
    return obs

def mountain_car_obs_preprocess(obs):
    return obs

def riverswim_obs_preprocess(state_num):

    def to_one_hot(obs):
        one_hot = np.zeros(state_num)
        one_hot[obs] = 1.
        return one_hot

    return to_one_hot

def scalar_obs_preprocess(scalar):
    assert np.isscalar(scalar)
    return np.array([scalar])
