import gym

class SparseMountainCarWrapper(gym.Wrapper):

    def __init__(self, env, steps_limit):
        self.step_count = 0
        self.steps_limit = steps_limit
        super(SparseMountainCarWrapper, self).__init__(env)

    def step(self, action):
        # self.env.step(action)
        self.step_count += 1
        observation, reward, done, info = self.env.step(action)
        if done:
            if self.steps_limit <= self.step_count:
                reward += 1
            else:
                reward += 2
            self.step_count = 0
        else:
            reward += 1
        return observation, reward, done, info
