#!/usr/bin/env bash

if [ "$#" -lt 2 ]; then
    echo "Usage: install virtual_env_name python_verison"
    exit
fi

VENV_NAME=$1
PYVER=$2

# path of this script
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
echo "---------------------- Work in $DIR ---------------------- "

# check if the env exists
find_conda_env(){
    conda env list | grep "$VENV_NAME" >/dev/null 2>/dev/null
}

# check env before install
if find_conda_env; then
    env="$(env | grep $VENV_NAME | wc -l)"
    if [ $env == 0 ] ; then
        conda activate $VENV_NAME
    fi
else
    # create conda virtual env
    conda create -n $VENV_NAME python=$PYVER -y
    conda activate $VENV_NAME
fi

# check env before install
env="$(env | grep $VENV_NAME | wc -l)"
# echo $env
if [ $env == 0 ] ; then
    echo "---------------------- Not inside the virtual env $VENV_NAME ---------------------- "
    echo "---------------------- Please manually run: conda activate $VENV_NAME ---------------------- "
    echo "----------------------  and then re-run this installation script ---------------------- "
    exit
fi

# requirements
echo "---------------------- Install Requirements ---------------------- "
pip3 install -r $DIR/requirements.txt

