#!/usr/bin/env bash

if [ "$#" -lt 6 ]; then
    echo "Usage: me.sh relative_config_filename remove_old_if_exist_0_or_1 exp_name gpus nb_gpus port [others, e.g., --resume-from]"
    exit
fi

PYTHON=${PYTHON:-"python"}

CONFIG_FILE=$1
RM_OLD_IF_EXISTS=$2
EXP_NAME=$3
GPUS=$4
NUM_GPUS=$5
PORT=${PORT:-$6}


DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


CONFIG_FILENAME=${CONFIG_FILE##*/}
CONFIG_BASE="${CONFIG_FILENAME%.*}"

WORK_DIR=$DIR/../work_dirs/detection/$EXP_NAME/$CONFIG_BASE

if [ -d $WORK_DIR ]; then
  echo "$WORK_DIR --- Already exists"
  if [ $RM_OLD_IF_EXISTS -gt 0 ]; then
    while true; do
        read -p "Are you sure to delete this result directory? " yn
        case $yn in
            [Yy]* ) rm -r $WORK_DIR; mkdir -p $WORK_DIR; break;;
            [Nn]* ) exit;;
            * ) echo "Please answer yes or no.";;
        esac
    done
  else
    echo "Resume"
  fi
else
    mkdir -p $WORK_DIR
fi


OMP_NUM_THREADS=1 MKL_NUM_THREADS=1 CUDA_VISIBLE_DEVICES=$GPUS $PYTHON -m torch.distributed.launch \
  --nproc_per_node=$NUM_GPUS --master_port=$PORT \
    $DIR/train.py $CONFIG_FILE \
    --launcher pytorch \
    --work-dir $WORK_DIR \
    ${@:7}
