#!/usr/bin/env bash

if [ "$#" -lt 10 ]; then
    echo "Usage: me Config_file Model_name Dataset_name Img_size Remove_old_if_exist_0_or_1 Resume_or_not_if_exist Exp_name Gpus Nb_gpus Port [others]"
    exit
fi

CONFIG_FILE=$1
MODEL=$2
DATASET=$3
DATA_SIZE=$4
RM_OLD_IF_EXIST=$5
RESUM_OLD_IF_EXIST=$6
EXP_NAME=$7
GPUS=$8
NUM_GPUS=$9
PORT=${PORT:-${10}}

PYTHON=${PYTHON:-"python"}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


if [ "$DATASET" = "IMNET" ]; then
  DATA_DIR=$DIR/../datasets/ILSVRC2015/Data/CLS-LOC/
  WORKERS=10
  if [ ! -d $DATA_DIR ]; then
    echo "not found $DATA_DIR"
    exit
  fi
fi

WORK_DIR=$DIR/../work_dirs/classification/$EXP_NAME

EXPERIMET="$DATASET"_"$DATA_SIZE"_"$MODEL"
EXPERIMENT_DIR=$WORK_DIR/$EXPERIMET
if [ -d $EXPERIMENT_DIR ]; then
  echo "$EXPERIMENT_DIR --- Already exists"
  if [ $RM_OLD_IF_EXIST -gt 0 ]; then
    while true; do
        read -p "Are you sure to delete this result directory? " yn
        case $yn in
            [Yy]* ) rm -r $EXPERIMENT_DIR; mkdir -p $EXPERIMENT_DIR; break;;
            [Nn]* ) exit;;
            * ) echo "Please answer yes or no.";;
        esac
    done
  else
    if [ $RESUM_OLD_IF_EXIST -gt 0 ]; then
      echo "Auto-resume"
    else
      echo "Skip"
      exit
    fi
  fi
fi

OMP_NUM_THREADS=1 CUDA_VISIBLE_DEVICES=$GPUS $PYTHON -m torch.distributed.launch \
  --nproc_per_node=$NUM_GPUS --master_port=$PORT \
  $DIR/train.py  $DATA_DIR --dataset $DATASET \
  --img-size $DATA_SIZE --workers $WORKERS \
  --config $CONFIG_FILE --model $MODEL  --pin-mem --use-multi-epochs-loader \
  --output $WORK_DIR --experiment $EXPERIMET \
  ${@:11}



