import numpy as np 
from .base import BaseColumnTransformer
import pandas as pd
from datetime import datetime

# Datetime Transformer
class DatetimeTransformer(BaseColumnTransformer):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        
    def _transform(self, X):
        
        # Convert to datetime first, then convert to UTC and remove timezone
        dt = pd.to_datetime(X)
        return dt.dt.tz_localize('UTC').dt.tz_localize(None)
            
    def _inverse_transform(self, X):
        # Implement inverse transformation logic
        return pd.to_datetime(X)

