import pandas as pd

from .base import BaseColumnTransformer


# String Transformer
class StringTransformer(BaseColumnTransformer):
    def _transform(self, X):
        return X.astype(str).tolist()

    def _inverse_transform(self, X):
        return pd.Series(X)