#!/bin/bash

# Configuration file for evaluate_combinations.sh
# Modify these variables according to your setup

# ================================================
# Input/Output Directories
# ================================================
export COMBINATIONS_DIR="./combinations"             # Output directory for generated combinations
export EVAL_DATA_DIR="./dataset/train_new"              # Dataset for evaluation
export EVAL_RESULTS_DIR="./eval_results/train_new"            # Individual evaluation results (organized structure)
export REPORT_DIR="./combination_reports"           # Analysis reports and summaries

# ================================================
# Evaluation Parameters
# ================================================
export EVAL_PARALLEL_SIZE=25                        # Number of parallel processes for evaluation
export EVAL_TIMEOUT=1000                              # Timeout per instance (seconds)
export MAX_COMBINATIONS=8                           # Maximum combinations to evaluate (0 = all)
export RANDOM_SEED=42
# ================================================
# Combination Generation Parameters
# ================================================
export SAMPLE_RESTART=2                             # Number of restart_condition samples (baseline + top-k)
export SAMPLE_BUMP_VAR=3                            # Number of bump_var_function samples (baseline + top-k)
export SAMPLE_REPHASE=1                             # Number of rephase_function samples (baseline + top-k)

# ================================================
# Advanced Options
# ================================================
export KEEP_TEMP_FILES=true                         # Keep intermediate files after evaluation
export FORCE_REGENERATE=true                       # Force regeneration of combinations even if they exist

# ================================================
# Dataset-specific configurations
# ================================================
# Uncomment and modify for different datasets:

# For small test datasets:
# export EVAL_TIMEOUT=10
# export EVAL_PARALLEL_SIZE=4
# export MAX_COMBINATIONS=3
# export SAMPLE_RESTART=2
# export SAMPLE_BUMP_VAR=1
# export SAMPLE_REPHASE=2

# For large production datasets:
# export EVAL_TIMEOUT=300
# export EVAL_PARALLEL_SIZE=24
# export MAX_COMBINATIONS=0  # Evaluate all combinations
# export SAMPLE_RESTART=3
# export SAMPLE_BUMP_VAR=3
# export SAMPLE_REPHASE=3

# For specific datasets:
# export EVAL_DATA_DIR="./dataset/SCPC"
# export EVAL_DATA_DIR="./dataset/LangFord_cnf"
# export EVAL_DATA_DIR="./dataset/CoinsGrid_cnf"

echo "Configuration loaded:"
echo "  📁 Search results: $RESULTS_JSON_DIR"
echo "  📁 Combinations: $COMBINATIONS_DIR"  
echo "  📁 Eval data: $EVAL_DATA_DIR"
echo "  📁 Results: $EVAL_RESULTS_DIR"
echo "  📁 Reports: $REPORT_DIR"
echo "  ⚙️  Parallel: $EVAL_PARALLEL_SIZE, Timeout: ${EVAL_TIMEOUT}s, Max: $MAX_COMBINATIONS"
echo "  🎯 Samples: restart=$SAMPLE_RESTART, bump_var=$SAMPLE_BUMP_VAR, rephase=$SAMPLE_REPHASE"