import numpy as np
def empirical_cf_2d(samples, domain_x, domain_y, modulate_term=None):
    
    domain_X, domain_Y = np.meshgrid(domain_x, domain_y)
    
    emp_cf = np.zeros(domain_X.shape, dtype=complex)

    
    for i in range(emp_cf.shape[0]):
        for j in range(emp_cf.shape[1]):
            if modulate_term is not None:
                array = np.array([domain_X[i][j], domain_Y[i][j]])
                term = array @ modulate_term @ array.T / 2
                fourier_data = np.exp(1j * (domain_X[i][j] * samples[:, 0] + domain_Y[i][j] * samples[:, 1]) + term)
            else:
                fourier_data = np.exp(1j * (domain_X[i][j] * samples[:, 0] + domain_Y[i][j] * samples[:, 1]))
            emp_cf[i][j] = np.mean(fourier_data)
    
    return emp_cf

