for i in $(seq 1 8); do
    OUTPUT_DIR=./mnli_pruned_0.${i}_finetune_w0
    num_gpus=4
    CUDA_VISIBLE_DEVICES=0,1,2,3 NCCL_P2P_DISABLE=1 nohup python -m torch.distributed.launch --nproc_per_node=$num_gpus --master_port=12345 non-GPT-2/examples/pytorch/text-classification/run_glue_prune_tune.py \
        --save_total_limit 10 \
        --model_name_or_path mnli \
        --task_name mnli \
        --output_dir ${OUTPUT_DIR} \
        --do_train \
        --do_eval \
        --num_train_epochs 3 \
        --save_steps 1000 \
        --seed 1 \
        --per_device_train_batch_size 8 \
        --max_seq_length 128 \
        --per_device_eval_batch_size 8 \
        --overwrite_output_dir \
        --logging_steps 1000 \
        --load_best_model_at_end True \
        --metric_for_best_model eval_accuracy \
        --pruning_ratio 0.${i} \
        --evaluation_strategy steps > 1001_mnli_pruned_0.${i}_finetune_w0.out 
done