for i in $(seq 1 8); do
    OUTPUT_DIR=./stsb_rank_16_pruned_0.${i}_finetune_wab
    num_gpus=4
    CUDA_VISIBLE_DEVICES=4,5,6,7 NCCL_P2P_DISABLE=1 nohup python -m torch.distributed.launch --nproc_per_node=$num_gpus --master_port=12381 non-GPT-2/examples/pytorch/text-classification/run_glue_prune_tune.py \
        --save_total_limit 10 \
        --model_name_or_path bert-base-uncased \
        --lora_path stsb_rank_16/pytorch_model.bin \
        --task_name stsb \
        --output_dir ${OUTPUT_DIR} \
        --do_train \
        --do_eval \
        --save_steps 20 \
        --seed 1 \
        --per_device_train_batch_size 8 \
        --per_device_eval_batch_size 8 \
        --overwrite_output_dir \
        --logging_steps 20 \
        --load_best_model_at_end True \
        --metric_for_best_model eval_pearson \
        --pruning_ratio 0.${i} \
        --apply_lora \
        --lora_r 16 \
        --learning_rate 5e-4 \
        --evaluation_strategy steps > 1001_stsb_prune_rank_16_0.${i}.out
done