OUTPUT_DIR='./deberta_cola'
num_gpus=4
NCCL_P2P_DISABLE=1 python -m torch.distributed.launch --nproc_per_node=$num_gpus --master_port=12345 examples/pytorch/text-classification/run_glue.py \
    --model_name_or_path microsoft/deberta-xlarge \
    --save_total_limit 100 \
    --task_name cola \
    --output_dir ${OUTPUT_DIR} \
    --do_train \
    --do_eval \
    --num_train_epochs 3 \
    --save_steps 100 \
    --seed 1 \
    --learning_rate 1e-4 \
    --num_train_epochs 10 \
    --overwrite_output_dir \
    --per_device_train_batch_size 4 \
    --max_seq_length 128 \
    --per_device_eval_batch_size 4 \
    --overwrite_output_dir \
    --logging_steps 100 \
    --load_best_model_at_end True \
    --weight_decay 0 \
    --metric_for_best_model eval_matthews_correlation \
    --evaluation_strategy steps > 0923_deberta_cola_dense.out &
