OUTPUT_DIR='./deberta_cola_rank_1'
num_gpus=4
NCCL_P2P_DISABLE=1 python -m torch.distributed.launch --nproc_per_node=$num_gpus --master_port=13345 non-GPT-2/examples/pytorch/text-classification/run_glue.py \
    --model_name_or_path microsoft/deberta-large \
    --save_total_limit 10 \
    --task_name cola \
    --output_dir ${OUTPUT_DIR} \
    --do_train \
    --do_eval \
    --num_train_epochs 3 \
    --save_steps 20 \
    --seed 1 \
    --overwrite_output_dir \
    --per_device_train_batch_size 8 \
    --max_seq_length 128 \
    --per_device_eval_batch_size 8 \
    --overwrite_output_dir \
    --logging_steps 20 \
    --load_best_model_at_end True \
    --weight_decay 0 \
    --apply_lora \
    --lora_r 1 \
    --lora_alpha 32 \
    --metric_for_best_model eval_matthews_correlation \
    --evaluation_strategy steps > 0929_deberta_cola_rank_1.out &
