# CALM: Co-evolution of Algorithms and Language Models for Automatic Heuristic Design

![Framework of CALM](./calm-framework.png)

**CALM** is the first framework for *LLM-based Automatic Heuristic Design (AHD)* that co-evolves a language model alongside the search for optimization heuristics. CALM can discover state-of-the-art heuristics for various combinatorial problems — running entirely on a machine with a 24 GB GPU, with no need for proprietary LLM APIs.

## 🚀 Key Features
- **Co-evolution of LLMs and algorithms** via GRPO.  
- **Cost-effective search** with quantized models like `Qwen2.5-7B-Instruct-INT4`.  
- **Superior performance** across multiple combinatorial optimization tasks.

## 🔧 Setup Instructions

CALM is built on [Unsloth](https://github.com/unslothai/unsloth), which requires a recent CUDA environment. Verified setup:

- **Python**: 3.11.11  
- **NVIDIA Driver**: 570.86.15  

1. Extract the provided package and open a terminal in the root folder.  
2. Install dependencies:

```bash
   pip install -r requirements.txt
```

* *If you intend to use the API-based search only, you can ignore/delete the requirments for `unsloth`, `vllm`, and `nvidia-ml-py3`.*

## 🔍 Running Heuristic Search

Included problem configurations:
- Online Bin Packing (`obp`)

- Traveling Salesman Problem (`tsp`)

- Orienteering Problem (`op_aco`)

- Capacitated Vehicle Routing Problem (`cvrp_aco`)

### Local Search

```bash
python train.py --configs "configs/<problem_name>/local.yaml" --repeat <number_of_trials>
```
Uses the local quantized model (`Qwen2.5-7B-Instruct-INT4`) with GRPO. This will cost about 22 GB of GPU memory.

### API-Based Search

1. Set your API key and base URL in:
```bash
configs/<problem_name>/api.yaml
```

2. Run:
```bash
python train.py --configs "configs/<problem_name>/api.yaml" --repeat <number_of_trials>
```

Outputs (logs and heuristics) are saved to:
```
calm_saved/<problem_name>/<config_file_name>_<trial_index>
```
Additional parameters available in `args.py`.

## 🧪 Evaluating Heuristics
To evaluate a discovered heuristic:
```bash
python heuristics.py <path_to_heuristic_file> --problem <problem_name>
```
This computes average performance on the test datasets defined in each problem’s `testing_dataset` method.
>✅ **Leading heuristics** discovered by CALM are under the `discovered_heuristics/` folder.
## ⚙️ Customizing CALM for Your Problem
1. **Environment File**
	Create `problems/<your_problem>.py` with:
	```python
	name = "..."
	description = "..."
	unit = "..."
	class Environment:
	    def training_dataset(self): ...
	    def testing_dataset(self): ...
	    def run_async(self, policy, instances): ...
	```

2. **Configuration Directory**
	Create `configs/<your_problem>/` containing:
	- A YAML file with at least:
		```yaml
		problem_name: <your_problem>
		```
	- Optionally, `seed.py` (seed function) and/or `template.py` (algorithm template).
		If placed elsewhere, specify their paths in the YAML.
		
		
Refer to existing `problems/` and `configs/` folders for examples.
