for IPC in 1
do
    GPU_ID=$1
    # if [ $IPC = 1 ]; then
    #     GPU_ID=${GPU_ID:0:1}
    #     echo "USING GPU ${GPU_ID}"
    # else
    #     echo "USING GPU ${GPU_ID}"
    # fi
    CKPT_DIR="../../store/pretrain"
    LOG_DIR="../../store/edc/recover/log"
    TRAIN_DATA_PATH="/nas/dataset/dataset_distillation/ImageNet-2012"
    SYN_PATH="../../store/edc/recover/syn_data/"
    STATISTIC_PATH="../../store/edc/recover/statistic_path/"
    INITIAL_IMG_DIR="${SYN_PATH}/WO_OPTIM_ImageNet_1k_Recover_IPC_${IPC}"
    time_stamp=$(date +"%Y%m%d_%H%M%S")
    # original batch size 80
    python -u recover_lt.py \
        --arch-name "resnet18" \
        --exp-name "EDC_ImageNet_1k_Recover_IPC_${IPC}" \
        --batch-size 100 \
        --lr 0.05 --category-aware "global" \
        --ipc-number $IPC --training-momentum 0.8  \
        --iteration 1000 --drop-rate 0.0 \
        --train-data-path $TRAIN_DATA_PATH \
        --syn-data-path $SYN_PATH \
        --ckpt-dir $CKPT_DIR \
        --statistic-path $STATISTIC_PATH \
        --l2-scale 0 --tv-l2 0 --r-loss 0.1 --nuc-norm 1. \
        --verifier --store-best-images --gpu-id $GPU_ID --initial-img-dir $INITIAL_IMG_DIR 2>&1 | tee ${LOG_DIR}/recover_lt_"${time_stamp}".log
done