#!/bin/bash
GPU_ID=$1
IPC=$2
sub_epoch=$3
# wandb offline
wandb disabled
# wandb enabled

epochs=300
repeat=$((epochs/sub_epoch))
suffix_suffix=_EP$((sub_epoch*repeat))_SUB${sub_epoch}_RP${repeat}
suffix="AUTO_FIXED"
model="resnet18"

# for IPC in 50
# do

output_dir="../../store/edc/train/final_${model}_fkd_${IPC}_${suffix}${suffix_suffix}"
train_dir="../../store/edc/recover/syn_data/EDC_ImageNet_1k_Recover_IPC_${IPC}"
val_dir="/nas/dataset/dataset_distillation/ImageNet-2012/val"
fkd_path="../../store/edc/relabel/FKD_EDC_IPC_${IPC}_${suffix}"
log_path="../../store/edc/train/log/final_${model}_fkd_${IPC}_${suffix}${suffix_suffix}.log"
python -u train_FKD_parallel.py \
    --wandb-project "final_${model}_fkd" \
    --batch-size 100 \
    --model "${model}" \
    --ls-type cos --loss-type "mse_gt" --ce-weight 0.025 \
    -j 4 --gradient-accumulation-steps 1  --st 2 --ema-dr 0.99 \
    -T 20 --gpu-id "${GPU_ID}" \
    --mix-type 'cutmix' \
    --output-dir "$output_dir" \
    --train-dir "$train_dir" \
    --val-dir $val_dir \
    --repeat $repeat \
    --epochs $epochs \
    --sub-epoch $sub_epoch \
    --fkd-path "$fkd_path" &> "$log_path"

# done

# model="efficientnet_b0"

# for IPC in 10 50
# do

# output_dir="../../store/edc/train/final_${model}_fkd_${IPC}_${suffix}${suffix_suffix}"
# train_dir="../../store/edc/recover/syn_data/EDC_ImageNet_1k_Recover_IPC_${IPC}"
# val_dir="/nas/dataset/dataset_distillation/ImageNet-2012/val"
# fkd_path="../../store/edc/relabel/FKD_EDC_IPC_${IPC}_${suffix}"
# log_path="../../store/edc/train/log/final_${model}_fkd_${IPC}_${suffix}${suffix_suffix}.log"
# python -u train_FKD_parallel.py \
#     --wandb-project "final_${model}_fkd" \
#     --batch-size 100 \
#     --model "${model}" \
#     --ls-type cos --loss-type "mse_gt" --ce-weight 0.025 \
#     -j 4 --gradient-accumulation-steps 1  --st 2 --ema-dr 0.99 \
#     -T 20 --gpu-id "${GPU_ID}" \
#     --mix-type 'cutmix' \
#     --output-dir $output_dir \
#     --train-dir $train_dir \
#     --val-dir $val_dir \
#     --repeat $repeat \
#     --epochs $epochs \
#     --fkd-path $fkd_path 2>&1 | tee $log_path

# done