#!/bin/bash
# IR: 1, 0.1, 0.02, 0.01
# IPC: 1, 10, 50, 100

# loop over IR and IPC
echo "[LOG]: start recover"
lr=0.1
rand_value=1
suffix="lt"
DEVICE=0
for rand_value in 0 1 2
do
    {
    for IPC in 1 10 50
    do
        for IR in 1 0.1 0.02 0.01
        do
            {
            log_path=./log/rand$((rand_value+1))/cifar10/recover_resnet18_E200_IR${IR}_IPC${IPC}_${suffix}.log
            start=$(date +%s)
            CUDA_VISIBLE_DEVICES=$DEVICE \
            python recover_cifar_lt.py \
            --arch-name "resnet18" \
            --arch-path "./save/rand$((rand_value+1))/cifar10/resnet18_E200_IR${IR}_lr${lr}/ckpt.pth" \
            --exp-name "cifar10_rn18_1K_mobile.lr0.25.bn0.01_IR${IR}_IPC${IPC}_rand$((rand_value+1))_${suffix}" \
            --batch-size "$IPC" \
            --lr 0.25 \
            --iteration 1000 \
            --r-bn 0.01 \
            --store-best-images \
            --ipc-start 0 --ipc-end $IPC \
            --IR $IR \
            --statistic-path "./statistics/IR${IR}_rand$((rand_value+1))_${suffix}" \
            --training-momentum 0.8 \
            --alpha 0.5 \
            --train-data-path "/home/xxx/work/dd/long_tail/sre2l_longtail/SRe2L/cifar10/data/cifar10" \
            --rand-value $rand_value \
            --long-tail \
            --verifier &>$log_path
            end=$(date +%s)
            echo "start=${start}, end=${end}" >> $log_path
            echo "IR=${IR}, IPC=${IPC} done in $((end-start))s" >> $log_path
            }&
        done
        wait
    done
    }&
    
    DEVICE=$((DEVICE+1))
done


wait
echo "[LOG]: finish recover"