# IR: 1, 0.1, 0.02, 0.01
# IPC: 1, 10, 50, 100

# loop over IR and IPC
echo "[LOG]: start recover"
DEVICE=0
for IR in 0.002 0.001
do
    for IPC in 1 10 50
    do
    {
        start=$(date +%s)
        CUDA_VISIBLE_DEVICES=$DEVICE \
        python recover_cifar.py \
        --arch-name "resnet18" \
        --arch-path "./result-1/save/cifar100/resnet18_E200_IR${IR}/ckpt.pth" \
        --exp-name "cifar100_rn18_1K_mobile.lr0.25.bn0.01_IR${IR}_IPC${IPC}" \
        --batch-size 100 \
        --lr 0.25 \
        --iteration 1000 \
        --r-bn 0.01 \
        --store-best-images \
        --ipc-start 0 --ipc-end $IPC \
        --syn-data-path ./result-1/syn_data \
        --verifier &>./result-1/log/cifar100/recover_resnet18_E200_IR${IR}_IPC${IPC}.log
        end=$(date +%s)
        echo "start=${start}, end=${end}" >> ./result-1/log/cifar100/recover_resnet18_E200_IR${IR}_IPC${IPC}.log
        echo "IR=${IR}, IPC=${IPC} done in $((end-start))s" >> ./result-1/log/cifar100/recover_resnet18_E200_IR${IR}_IPC${IPC}.log
    }&
    DEVICE=$((DEVICE+1))
    if [ $DEVICE -gt 4 ]; then
        DEVICE=0
    fi
    done
done

# DEVICE=4
# IR=1
# IPC=50
# CUDA_VISIBLE_DEVICES=$DEVICE \
# python recover_cifar.py \
# --arch-name "resnet18" \
# --arch-path "/path/to/cifar100/resnet18_E200_IR${IR}/ckpt.pth" \
# --exp-name "cifar100_rn18_1K_mobile.lr0.25.bn0.01" \
# --batch-size 100 \
# --lr 0.25 \
# --iteration 1000 \
# --r-bn 0.01 \
# --store-best-images \
# --ipc-start 0 --ipc-end $IPC


wait
echo "[LOG]: finish recover"