#!/bin/bash
echo "[LOG]: start relabel"

# DEVICE=0
lr=0.1
# rand_value=1
# DEVICE=1
# IR=1
DEVICE=1
base_log_path=./result-1/log/eval_logit_final_auto_tau
base_output_dir=./result-1/save_post_cifar100/eval_logit_final_auto_tau

mkdir -p $base_log_path
mkdir -p $base_output_dir

for IPC in 1 10 50 100
do
    DEVICE=0
    for IR in 1 0.1 0.02 0.01
    do
        {
        suffix=IR${IR}_IPC${IPC}_RD${rand_value}_final_auto_tau
        start=$(date +%s)
        log_path=${base_log_path}/${suffix}.log
        output_dir=${base_output_dir}/${suffix}

        CUDA_VISIBLE_DEVICES=$DEVICE \
        python relabel_cifar_logit_final_auto_tau.py \
        --epochs 400 \
        --output-dir $output_dir \
        --syn-data-path ./result-1/syn_data/cifar100_rn18_1K_mobile.lr0.25.bn0.01_IR${IR}_IPC${IPC} \
        --teacher-pat ./result-1/save/cifar100/resnet18_E200_IR${IR}/ckpt.pth \
        --imb-factor $IR --random-value 0 \
        --ipc $IPC --batch-size 128 &> $log_path

        end=$(date +%s)
        echo "start=${start}, end=${end}" >> $log_path
        echo "IR=${IR}, IPC=${IPC} done in $((end-start))s" >> $log_path
        }&
        DEVICE=$((DEVICE+1))
    done
done
wait

# IR=0.01
# IPC=50
# for tau in 0 0.5 1 1.5 2 2.5 3 3.5 4 4.5
#                 suffix=IR${IR}_IPC${IPC}_RD${rand_value}_TAU${tau}
#                 start=$(date +%s)
#                 log_path=${base_log_path}/${suffix}.log
#                 output_dir=${base_output_dir}/${suffix}

#                 CUDA_VISIBLE_DEVICES=$DEVICE \
#                 python relabel_cifar_logit.py \
#                 --epochs 400 \
#                 --output-dir $output_dir \
#                 --syn-data-path ./syn_data/rand$((rand_value+1))/cifar10_rn18_1K_mobile.lr0.25.bn0.01_IR${IR}_IPC${IPC} \
#                 --teacher-path ./save/rand$((rand_value+1))/cifar10/resnet18_E200_IR${IR}_lr${lr}/ckpt.pth \
#                 --tau $tau --imb-factor $IR --random-value $rand_value \
#                 --ipc $IPC --batch-size 128 &> $log_path

#                 end=$(date +%s)
#                 echo "start=${start}, end=${end}" >> $log_path
#                 echo "IR=${IR}, IPC=${IPC} done in $((end-start))s" >> $log_path

echo "[LOG]: finish relabel"