import os
import shutil

def copy_first_n_images(src_root, dst_root, n=50):
    # Ensure the destination root exists.
    if not os.path.exists(dst_root):
        os.makedirs(dst_root)
    
    # Loop over each item in the source directory.
    for subfolder in os.listdir(src_root):
        src_folder = os.path.join(src_root, subfolder)
        # Check if the item is a directory.
        if os.path.isdir(src_folder):
            dst_folder = os.path.join(dst_root, subfolder)
            os.makedirs(dst_folder, exist_ok=True)
            
            # List and sort all JPEG files.
            image_files = sorted(
                [f for f in os.listdir(src_folder) if f.lower().endswith('.jpg')]
            )
            
            # Copy only the first n images.
            for img in image_files[:n]:
                src_img_path = os.path.join(src_folder, img)
                dst_img_path = os.path.join(dst_folder, img)
                shutil.copy2(src_img_path, dst_img_path)
                print(f"Copied {src_img_path} to {dst_img_path}")

# Example usage:
source_directory = "/data0/xxx/work/imagenet-lt-pretrain/sre2l_imagenet/recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv.crop"     # Replace with your source directory path
destination_directory = "/data0/xxx/work/imagenet-lt-pretrain/sre2l_imagenet/recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv_ipc50.crop"  # Replace with your destination directory path

copy_first_n_images(source_directory, destination_directory, n=50)